/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_appchild.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 02:01:49 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _SFX_WHITER_HXX //autogen
// auto strip #include <svtools/whiter.hxx>
// auto strip #endif
// auto strip #ifndef _SFXENUMITEM_HXX //autogen
// auto strip #include <svtools/eitem.hxx>
// auto strip #endif

// auto strip #include "app.hxx"
#include "appdata.hxx"
// auto strip #include "workwin.hxx"
// auto strip #include "childwin.hxx"
#include "arrdecl.hxx"
// auto strip #include "templdlg.hxx"
#include "ipfrm.hxx"
#include "ipenv.hxx"
// auto strip #include "request.hxx"
// auto strip #include "bindings.hxx"
// auto strip #include "dispatch.hxx"
// auto strip #include "sfxtypes.hxx"
// auto strip #include "module.hxx"
#include "sfxsids.hrc"
namespace binfilter {

//=========================================================================

//STRIP001 ResId SfxApplication::GetCurrentObjectBar( USHORT nPosId ) const
//STRIP001 
//STRIP001 /*	[Beschreibung]
//STRIP001 
//STRIP001 	Mit dieser Methode kann die ResId der an der angegebenen Positions-Nummer
//STRIP001 	aktuell stehenden Symbol-Leiste erfragt werden. Als Positions-Nummern
//STRIP001 	k"onnen verwendet werden:
//STRIP001 
//STRIP001 		SFX_OBJECTBAR_APPLICATION
//STRIP001 		SFX_OBJECTBAR_OBJECT
//STRIP001 		SFX_OBJECTBAR_TOOLS
//STRIP001 		SFX_OBJECTBAR_MACRO
//STRIP001 		SFX_OBJECTBAR_FULLSCREEN
//STRIP001 		SFX_OBJECTBAR_RECORDING
//STRIP001 		SFX_OBJECTBAR_OPTIONS
//STRIP001 		SFX_OBJECTBAR_USERDEF1
//STRIP001 		SFX_OBJECTBAR_USERDEF2
//STRIP001 		SFX_OBJECTBAR_USERDEF3
//STRIP001 
//STRIP001 	Ist an der Position keine Symbol-Leiste vorhanden, dann wird eine ResId
//STRIP001 	mit einer Id von 0 und ohne ResManager zur"uckgegeben.
//STRIP001 
//STRIP001 
//STRIP001 	[Anmerkung]
//STRIP001 
//STRIP001 	Da intern keine fertige ResId verf"ugbar ist, mu\s leider eine Instanz
//STRIP001 	returnt werden.
//STRIP001 */
//STRIP001 
//STRIP001 {
//STRIP001 	ResId aResId(0, 0);
//STRIP001     SfxWorkWindow* pWork = GetWorkWindow_Impl(SfxViewFrame::Current());
//STRIP001     if ( pWork )
//STRIP001         pWork->GetObjectBar_Impl(nPosId, aResId);
//STRIP001 	return aResId;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ void SfxApplication::RegisterChildWindow( SfxModule *pMod, SfxChildWinFactory *pFact )
/*N*/ {
/*N*/ 	if ( pMod )
/*N*/ 	{
/*N*/ 		pMod->RegisterChildWindow( pFact );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (!pAppData_Impl->pFactArr)
/*?*/ 		pAppData_Impl->pFactArr = new SfxChildWinFactArr_Impl;
/*N*/ 
/*N*/ //#ifdef DBG_UTIL
/*N*/ 	for (USHORT nFactory=0; nFactory<pAppData_Impl->pFactArr->Count(); ++nFactory)
/*N*/ 	{
/*N*/ 		if (pFact->nId ==  (*pAppData_Impl->pFactArr)[nFactory]->nId)
/*N*/ 		{
/*N*/ 			pAppData_Impl->pFactArr->Remove( nFactory );
/*N*/ //			DBG_ERROR("ChildWindow mehrfach registriert!");
/*N*/ //			return;
/*N*/ 		}
/*N*/ 	}
/*N*/ //#endif
/*N*/ 
/*N*/ 	pAppData_Impl->pFactArr->C40_INSERT(
/*N*/ 		SfxChildWinFactory, pFact, pAppData_Impl->pFactArr->Count() );
/*N*/ }

/*N*/ void SfxApplication::RegisterChildWindowContext( SfxModule *pMod, USHORT nId,
/*N*/ 		SfxChildWinContextFactory *pFact)
/*N*/ {
/*N*/ 	SfxChildWinFactArr_Impl *pFactories;
/*N*/ 	SfxChildWinFactory *pF = NULL;
/*N*/ 	if ( pMod )
/*N*/ 	{
/*N*/ 		// Modul "ubergeben, ChildwindowFactory dort suchen
/*N*/ 		pFactories = pMod->GetChildWinFactories_Impl();
/*N*/ 		if ( pFactories )
/*N*/ 		{
/*N*/ 			USHORT nCount = pFactories->Count();
/*N*/ 			for (USHORT nFactory=0; nFactory<nCount; ++nFactory)
/*N*/ 			{
/*N*/ 				SfxChildWinFactory *pFac = (*pFactories)[nFactory];
/*N*/ 				if ( nId == pFac->nId )
/*N*/ 				{
/*N*/ 					// Factory gefunden, Context dort registrieren
/*N*/ 					pF = pFac;
/*N*/ 					break;
/*N*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( !pF )
/*N*/ 	{
/*N*/ 		// Factory an der Application suchen
/*N*/ 		DBG_ASSERT( pAppData_Impl, "Keine AppDaten!" );
/*N*/ 		DBG_ASSERT( pAppData_Impl->pFactArr, "Keine Factories!" );
/*N*/ 
/*N*/ 		pFactories = pAppData_Impl->pFactArr;
/*N*/ 		USHORT nCount = pFactories->Count();
/*N*/ 		for (USHORT nFactory=0; nFactory<nCount; ++nFactory)
/*N*/ 		{
/*N*/ 			SfxChildWinFactory *pFac = (*pFactories)[nFactory];
/*N*/ 			if ( nId == pFac->nId )
/*N*/ 			{
/*N*/ 				if ( pMod )
/*N*/ 				{
/*N*/ 					// Wenn der Context von einem Modul registriert wurde,
/*N*/ 					// mu\s die ChildwindowFactory auch dort zur Verf"ugung
/*N*/ 					// stehen, sonst m"u\ste sich die Contextfactory im DLL-Exit
/*N*/ 					// wieder abmelden !
/*N*/ 					pF = new SfxChildWinFactory( pFac->pCtor, pFac->nId,
/*N*/ 							pFac->nPos );
/*N*/ 					pMod->RegisterChildWindow( pF );
/*N*/ 				}
/*N*/ 				else
/*N*/ 					pF = pFac;
/*N*/ 				break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	if ( pF )
/*N*/ 	{
/*N*/ 		if ( !pF->pArr )
/*?*/ 			pF->pArr = new SfxChildWinContextArr_Impl;
/*N*/ 		pF->pArr->C40_INSERT( SfxChildWinContextFactory, pFact, pF->pArr->Count() );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ERROR( "Kein ChildWindow fuer diesen Context!" );
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxChildWinFactArr_Impl& SfxApplication::GetChildWinFactories_Impl() const
/*N*/ {
/*N*/ 	return ( *(pAppData_Impl->pFactArr));
/*N*/ }

//--------------------------------------------------------------------
#if SUPD<604
/*?*/ void SfxApplication::SetChildWindow(USHORT nId, BOOL bOn)
/*?*/ {
/*?*/     if ( pViewFrame )
/*?*/         pViewFrame->SetChildWindow( nId, bOn );
/*?*/ }
/*?*/ 
/*?*/ //--------------------------------------------------------------------
/*?*/ 
/*?*/ void SfxApplication::ToggleChildWindow(USHORT nId)
/*?*/ {
/*?*/ 
/*?*/     if ( pViewFrame )
/*?*/         pViewFrame->ToggleChildWindow( nId );
/*?*/ }
/*?*/ 
/*?*/ //--------------------------------------------------------------------
/*?*/ 
/*?*/ BOOL SfxApplication::HasChildWindow( USHORT nId )
/*?*/ {
/*?*/     if ( pViewFrame )
/*?*/         return pViewFrame->HasChildWindow(nId);
/*?*/     else
/*?*/         return FALSE;
/*?*/ }
/*?*/ 
/*?*/ //--------------------------------------------------------------------
/*?*/ 
/*?*/ BOOL SfxApplication::KnowsChildWindow( USHORT nId )
/*?*/ {
/*?*/     if ( pViewFrame )
/*?*/         return pViewFrame->KnowsChildWindow(nId);
/*?*/     else
/*?*/         return FALSE;
/*?*/ }
/*?*/ 
/*?*/ //--------------------------------------------------------------------
/*?*/ 
/*?*/ void SfxApplication::ShowChildWindow( USHORT nId, BOOL bVisible )
/*?*/ {
/*?*/     if ( pViewFrame )
/*?*/         pViewFrame->ShowChildWindow(nId, bVisible);
/*?*/ }
/*?*/ 
/*?*/ //--------------------------------------------------------------------
/*?*/ 
/*?*/ SfxChildWindow* SfxApplication::GetChildWindow(USHORT nId)
/*?*/ {
/*?*/     if ( pViewFrame )
/*?*/         return pViewFrame->GetChildWindow(nId);
/*?*/     else
/*?*/         return NULL;
/*?*/ }
/*?*/ 
#endif

//--------------------------------------------------------------------

//STRIP001 SfxTemplateDialog* SfxApplication::GetTemplateDialog()
//STRIP001 {
//STRIP001     if ( pViewFrame )
//STRIP001     {
//STRIP001         SfxChildWindow *pChild = pViewFrame->GetChildWindow(SfxTemplateDialogWrapper::GetChildWindowId());
//STRIP001         return pChild ? (SfxTemplateDialog*) pChild->GetWindow() : 0;
//STRIP001     }
//STRIP001 
//STRIP001     return NULL;
//STRIP001 }

//--------------------------------------------------------------------

/*N*/ SfxWorkWindow* SfxApplication::GetWorkWindow_Impl(const SfxViewFrame *pFrame) const
/*N*/ {
/*N*/     if ( pFrame )
/*N*/         return pFrame->GetFrame()->GetWorkWindow_Impl();
/*N*/     else if ( pViewFrame )
/*?*/         return pViewFrame->GetFrame()->GetWorkWindow_Impl();
/*N*/     else
/*N*/         return NULL;
/*N*/ }

//--------------------------------------------------------------------

/*N*/ SfxHelpPI* SfxApplication::GetHelpPI()
/*N*/ {
/*N*/     return NULL;
/*N*/ }
}
