/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sfx2_tplpitem.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:05:10 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// INCLUDE ---------------------------------------------------------------

#pragma hdrstop

#include "tplpitem.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

/*N*/ TYPEINIT1(SfxTemplateItem, SfxFlagItem);

//=========================================================================

/*N*/ SfxTemplateItem::SfxTemplateItem
/*N*/ (
/*N*/ 	USHORT nWhich,			// Slot-ID
/*N*/ 	const String& rStyle,	// Name des aktuellen Styles
/*N*/ 	USHORT nValue			// Flags f"ur das Filtern bei automatischer Anzeige
/*N*/ ) :
/*N*/ 
/*N*/ 	SfxFlagItem( nWhich, nValue ),
/*N*/ 
/*N*/ 	aStyle( rStyle )
/*N*/ 
/*N*/ {
/*N*/ }

//-------------------------------------------------------------------------

// copy ctor
/*N*/ SfxTemplateItem::SfxTemplateItem( const SfxTemplateItem& rCopy ) :
/*N*/ 
/*N*/ 	SfxFlagItem( rCopy ),
/*N*/ 
/*N*/ 	aStyle( rCopy.aStyle )
/*N*/ {
/*N*/ }

//-------------------------------------------------------------------------

// op ==

/*N*/ int SfxTemplateItem::operator==( const SfxPoolItem& rCmp ) const
/*N*/ {
/*N*/ 	return ( SfxFlagItem::operator==( rCmp ) &&
/*N*/ 			 aStyle == ( (const SfxTemplateItem&)rCmp ).aStyle );
/*N*/ }

//-------------------------------------------------------------------------

/*N*/ SfxPoolItem* SfxTemplateItem::Clone( SfxItemPool *) const
/*N*/ {
/*N*/ 	return new SfxTemplateItem(*this);
/*N*/ }

//-------------------------------------------------------------------------

/*?*/ BYTE SfxTemplateItem::GetFlagCount() const
/*?*/ {DBG_BF_ASSERT(0, "STRIP");  return 0;//STRIP001 
//STRIP001 	return sizeof(USHORT) * 8;
/*?*/ }


}
