/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: tbxcust.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 03:37:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _TBXCUST_HXX
#define _TBXCUST_HXX

// #include *****************************************************************

#ifndef _TOOLBOX_HXX //autogen
#include <vcl/toolbox.hxx>
#endif
#ifndef _SV_BITMAP_HXX
#include <vcl/bitmap.hxx>
#endif
#include <vcl/combobox.hxx>
#include <vcl/button.hxx>
#ifndef _HEADBAR_HXX
#include <svtools/headbar.hxx>
#endif

#include "basedlgs.hxx"
#include "imgmgr.hxx"
#include "childwin.hxx"
#include "sfxresid.hxx"
#include "cfgtreelstbox.hxx"

#include <vector>


namespace rtl { class OUString; }
class Bitmap;
namespace binfilter {
class SfxMacroInfoArr_Impl;
class SfxToolBoxManager;

// **************************************************************************

//STRIP001 class SfxCustomizeToolBox : public ToolBox
//STRIP001 {
//STRIP001     SfxBindings*    pBindings;
//STRIP001 	BOOL			bHelpInitialized;
//STRIP001 
//STRIP001 public:
//STRIP001     SfxCustomizeToolBox( Window* pParent, SfxBindings*, const ResId& );
//STRIP001 	virtual void    Customize( const ToolBoxCustomizeEvent& rCEvt );
//STRIP001 };

class SfxUserBitmapDialog_Impl;
class SfxTbxControlArr_Impl;

//STRIP001 class SfxToolboxCustomizer : public SfxModelessDialog
//STRIP001 {
//STRIP001 friend class SfxCustomizeToolBox;
//STRIP001 friend class SfxUserBitmapDialog_Impl;
//STRIP001 
//STRIP001 	sal_Int16					m_nSymbolSet;
//STRIP001 	FixedText					m_aTbFunctionsFT;
//STRIP001 	SfxConfigTreeListBox_Impl	m_aTbFunctionsTLB;
//STRIP001 	PushButton					m_aTbAddBtn;
//STRIP001 	PushButton					m_aTbRemoveBtn;
//STRIP001 	FixedText					m_aTbToolbarsFT;
//STRIP001 	ListBox						m_aTbToolbarsLB;
//STRIP001 	FixedText					m_aTbToolbarFT;
//STRIP001 	SfxToolbarTreeListBox_Impl	m_aTbToolbarTLB;
//STRIP001 	OKButton					m_aTbOkBtn;
//STRIP001 	CancelButton				m_aTbCancelBtn;
//STRIP001 	HelpButton					m_aTbHelpBtn;
//STRIP001 	PushButton					m_aTbApplyBtn;
//STRIP001 	PushButton					m_aTbDefaultBtn;
//STRIP001 	PushButton					m_aTbMoveUpBtn;
//STRIP001 	PushButton					m_aTbMoveDownBtn;
//STRIP001 	PushButton					m_aTbIconsBtn;
//STRIP001 	SfxUserBitmapDialog_Impl*	m_pBmpDlg;
//STRIP001 	USHORT						m_nCurrTbxPos;
//STRIP001 
//STRIP001 protected:
//STRIP001 	void				FillFunctionsListBox();
//STRIP001 	void				ClearToolBox();
//STRIP001 	virtual BOOL		Close();
//STRIP001 	void				CheckButtonsState();
//STRIP001 	void				StoreToolBoxes( BOOL bPreserveListener );
//STRIP001 
//STRIP001 public:
//STRIP001 						SfxToolboxCustomizer( SfxBindings*, SfxChildWindow*,
//STRIP001 							Window *pParent, const ResId& rResId );
//STRIP001 						~SfxToolboxCustomizer();
//STRIP001 	void            	Init();
//STRIP001 	virtual long		Notify( NotifyEvent& );
//STRIP001 	virtual void    	FillInfo(SfxChildWinInfo&) const;
//STRIP001 	SfxUserBitmapDialog_Impl*
//STRIP001 						ConnectUserBitmapDialog_Impl(USHORT nId, ToolBox& rTbx, SfxToolBoxManager* pMgr);
//STRIP001 	
//STRIP001 	DECL_LINK(			OnTreelistBoxChanged, void* );
//STRIP001 	DECL_LINK(			OnToolBarChanged, SfxToolBoxManager* );
//STRIP001 
//STRIP001 	DECL_LINK( 			SelectToolbars, ListBox* );
//STRIP001 	DECL_LINK(			SelectToolbar, Control* );
//STRIP001 	DECL_LINK(			SelectFunctions, Control* );
//STRIP001 	
//STRIP001 	DECL_LINK(			ApplyButtonHdl, Button * );
//STRIP001 	DECL_LINK(			OkButtonHdl, OKButton * );
//STRIP001 	DECL_LINK(			CancelButtonHdl, CancelButton * );
//STRIP001 
//STRIP001 	DECL_LINK( 			MoveUpButtonHdl, Button * );
//STRIP001 	DECL_LINK( 			MoveDownButtonHdl, Button * );
//STRIP001 	DECL_LINK( 			AddButtonHdl, Button * );
//STRIP001 	DECL_LINK( 			RemoveButtonHdl, Button * );
//STRIP001 
//STRIP001 	DECL_LINK( 			IconsButtonHdl, Button * );
//STRIP001 	DECL_LINK( 			DefaultButtonHdl, Button * );
//STRIP001     DECL_LINK(          SymbolsetChanged, void* );
//STRIP001 
//STRIP001 	void				SelectToolbar( USHORT nType );
//STRIP001 };

class SfxUserBitmapDialog_Impl : public ModalDialog
{
friend class SfxToolboxCustomizer;

	ToolBox         	aSymbolTb;
	FixedText       	aDescLabelFt;
	Edit       			aDescEdit;
	OKButton        	aOKButton;
	CancelButton    	aCancelButton;
	HelpButton      	aHelpBtn;
	PushButton			aDefaultBtn;
    FixedLine           aFunctionGb;
	USHORT          	nFuncId;
	String				aDirName;
    std::vector< ::rtl::OUString > aBitmapUrls;
	ToolBox*			pToolBox;
	SfxToolBoxManager*	pMgr;
    SfxImageManager*    pImageMgr;
	BOOL				bNoDefaultImage;
	BOOL				bBigImages;
	BmpConversion       nBmpColorConversion;
	USHORT              nBmpColorDepth;

    SfxUserBitmapDialog_Impl(SfxUserBitmapDialog_Impl &); // not implemented
    void operator =(SfxUserBitmapDialog_Impl); // not implemented

    Bitmap createBitmap(::rtl::OUString const & rUrl);

	Image				GetDefaultImage( USHORT nId );
	void				ResetToolBoxSelection();

public:

						SfxUserBitmapDialog_Impl(Window *pParent,
										const String& rName,
										ToolBox &rTbx,
                                        USHORT nId, SfxToolBoxManager* pMgr, SfxImageManager* );

						~SfxUserBitmapDialog_Impl();
	DECL_LINK( 			OKHdl, OKButton * );
	DECL_LINK( 			SelectHdl, ToolBox * );
	DECL_LINK( 			DefaultHdl, PushButton * );

	void				SetFunctionId(USHORT nId);
	void				SetToolBox(ToolBox& rTbx);
};

class SfxToolboxCustomWindow : public SfxChildWindow
{
public:
						SfxToolboxCustomWindow(Window *pParent, USHORT nId,
							SfxBindings *pBindings, SfxChildWinInfo *pInfo);
						SFX_DECL_CHILDWINDOW(SfxToolboxCustomWindow);

//STRIP001 						void SelectToolbar( USHORT nType );
};

}//end of namespace binfilter
#endif // #ifndef _TBXCUST_HXX


