/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: starmath_dialog.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:01:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #pragma hdrstop
//STRIP001
//STRIP001 #define SMDLL 1
//STRIP001
//STRIP001 #ifndef _TOOLS_RCID_H
//STRIP001 #include "tools/rcid.h"
//STRIP001 #endif
//STRIP001
//STRIP001 #ifndef _SFXENUMITEM_HXX //autogen
//STRIP001 #include <svtools/eitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXINTITEM_HXX //autogen
//STRIP001 #include <svtools/intitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXSTRITEM_HXX //autogen
//STRIP001 #include <svtools/stritem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXAPP_HXX //autogen
//STRIP001 #include <bf_sfx2/app.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CTRLTOOL_HXX //autogen
//STRIP001 #include <svtools/ctrltool.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_PRINTER_HXX
//STRIP001 #include <bf_sfx2/printer.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_SOUND_HXX //autogen
//STRIP001 #include <vcl/sound.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_SNDSTYLE_HXX //autogen
//STRIP001 #include <vcl/sndstyle.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_WAITOBJ_HXX
//STRIP001 #include <vcl/waitobj.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_SETTINGS_HXX
//STRIP001 #include <vcl/settings.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SV_WALL_HXX
//STRIP001 #include <vcl/wall.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXDISPATCH_HXX //autogen
//STRIP001 #include <bf_sfx2/dispatch.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_HRC //autogen
//STRIP001 #include <bf_sfx2/sfx.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _STRING_HXX //autogen
//STRIP001 #include <tools/string.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _TOOLS_DEBUG_HXX //autogen
//STRIP001 #include <tools/debug.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SUBSETMAP_HXX
//STRIP001 #include <bf_svx/ucsubset.hxx>
//STRIP001 #endif
//STRIP001
//STRIP001
//STRIP001 #ifndef CONFIG_HXX
//STRIP001 #include "config.hxx"
//STRIP001 #endif
//STRIP001 #ifndef DIALOG_HXX
//STRIP001 #include "dialog.hxx"
//STRIP001 #endif
//STRIP001 #ifndef _STARMATH_HRC
//STRIP001 #include "starmath.hrc"
//STRIP001 #endif
//STRIP001
//STRIP001 #include "dialog.hrc"
//STRIP001
//STRIP001 #ifndef _SMMOD_HXX
//STRIP001 #include "smmod.hxx"
//STRIP001 #endif
//STRIP001 #ifndef SYMBOL_HXX
//STRIP001 #include "symbol.hxx"
//STRIP001 #endif
//STRIP001 #ifndef VIEW_HXX
//STRIP001 #include "view.hxx"
//STRIP001 #endif
//STRIP001 #ifndef DOCUMENT_HXX
//STRIP001 #include "document.hxx"
//STRIP001 #endif
//STRIP001
//STRIP001 ////////////////////////////////////////
//STRIP001 //
//STRIP001 // Da der FontStyle besser ueber die Attribute gesetzt/abgefragt wird als ueber
//STRIP001 // den StyleName bauen wir uns hier unsere eigene Uebersetzung
//STRIP001 // Attribute <-> StyleName
//STRIP001 //
//STRIP001
//STRIP001 class SmFontStyles
//STRIP001 {
//STRIP001     String  aNormal;
//STRIP001     String  aBold;
//STRIP001     String  aItalic;
//STRIP001     String  aBoldItalic;
//STRIP001     String  aEmpty;
//STRIP001
//STRIP001 public:
//STRIP001     SmFontStyles();
//STRIP001
//STRIP001     USHORT          GetCount() const    { return 4; }
//STRIP001     const String &  GetStyleName( const Font &rFont ) const;
//STRIP001     const String &  GetStyleName( USHORT nIdx ) const;
//STRIP001 };
//STRIP001
//STRIP001
//STRIP001 SmFontStyles::SmFontStyles() :
//STRIP001     aNormal ( ResId( RID_FONTREGULAR, SM_MOD()->GetResMgr() ) ),
//STRIP001     aBold   ( ResId( RID_FONTBOLD,    SM_MOD()->GetResMgr() ) ),
//STRIP001     aItalic ( ResId( RID_FONTITALIC,  SM_MOD()->GetResMgr() ) )
//STRIP001 {
//STRIP001 //    SM_MOD()->GetResMgr().FreeResource();
//STRIP001
//STRIP001     aBoldItalic = aBold;
//STRIP001     aBoldItalic.AppendAscii( ", " );
//STRIP001     aBoldItalic += aItalic;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 const String & SmFontStyles::GetStyleName( const Font &rFont ) const
//STRIP001 {
//STRIP001     //! compare also SmSpecialNode::Prepare
//STRIP001     BOOL bBold   = rFont.GetWeight() > WEIGHT_NORMAL,
//STRIP001          bItalic = rFont.GetItalic() != ITALIC_NONE;
//STRIP001
//STRIP001     if (bBold && bItalic)
//STRIP001         return aBoldItalic;
//STRIP001     else if (bItalic)
//STRIP001         return aItalic;
//STRIP001     else if (bBold)
//STRIP001         return aBold;
//STRIP001     else
//STRIP001         return aNormal;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 const String & SmFontStyles::GetStyleName( USHORT nIdx ) const
//STRIP001 {
//STRIP001     // 0 = "normal",  1 = "italic",
//STRIP001     // 2 = "bold",    3 = "bold italic"
//STRIP001
//STRIP001     DBG_ASSERT( nIdx < GetCount(), "index out of range" );
//STRIP001     switch (nIdx)
//STRIP001     {
//STRIP001         case 0 : return aNormal;
//STRIP001         case 1 : return aItalic;
//STRIP001         case 2 : return aBold;
//STRIP001         case 3 : return aBoldItalic;
//STRIP001     }
//STRIP001     return aEmpty;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 const SmFontStyles & GetFontStyles()
//STRIP001 {
//STRIP001     static const SmFontStyles aImpl;
//STRIP001     return aImpl;
//STRIP001 }
//STRIP001
//STRIP001 /////////////////////////////////////////////////////////////////
//STRIP001
//STRIP001 void SetFontStyle(const XubString &rStyleName, Font &rFont)
//STRIP001 {
//STRIP001 	// finden des Index passend zum StyleName fuer den leeren StyleName wird
//STRIP001 	// 0 (nicht bold nicht italic) angenommen.
//STRIP001 	USHORT  nIndex = 0;
//STRIP001 	if (rStyleName.Len())
//STRIP001 	{
//STRIP001 		USHORT i;
//STRIP001         const SmFontStyles &rStyles = GetFontStyles();
//STRIP001         for (i = 0;  i < rStyles.GetCount();  i++)
//STRIP001             if (rStyleName.CompareTo( rStyles.GetStyleName(i) ) == COMPARE_EQUAL)
//STRIP001 				break;
//STRIP001         DBG_ASSERT(i < rStyles.GetCount(), "style-name unknown");
//STRIP001 		nIndex = i;
//STRIP001 	}
//STRIP001
//STRIP001 	rFont.SetItalic((nIndex & 0x1) ? ITALIC_NORMAL : ITALIC_NONE);
//STRIP001 	rFont.SetWeight((nIndex & 0x2) ? WEIGHT_BOLD : WEIGHT_NORMAL);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001 SmAboutDialog::SmAboutDialog(Window *pParent, BOOL bFreeRes) :
//STRIP001 	ModalDialog  (pParent, SmResId(RID_DEFAULTABOUT)),
//STRIP001 	aFixedText1  (this, ResId(1)),
//STRIP001 	aFixedText2  (this, ResId(2)),
//STRIP001 	aFixedText3  (this, ResId(3)),
//STRIP001 	aFixedText4  (this, ResId(4)),
//STRIP001 	aFixedText5  (this, ResId(5)),
//STRIP001 	aFixedText6  (this, ResId(6)),
//STRIP001 	aReleaseText (this, ResId(7)),
//STRIP001 	aFixedBitmap1(this, ResId(1)),
//STRIP001 	aOKButton1	 (this, ResId(1))
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 #ifndef PRODUCT
//STRIP001 	aReleaseText.Show();
//STRIP001 #else
//STRIP001 	aReleaseText.Hide();
//STRIP001 #endif
//STRIP001
//STRIP001 }
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK_INLINE_START( SmPrintOptionsTabPage, SizeButtonClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	aZoom.Enable(aSizeZoomed.IsChecked());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SmPrintOptionsTabPage, SizeButtonClickHdl, Button *, pButton )
//STRIP001
//STRIP001
//STRIP001 SmPrintOptionsTabPage::SmPrintOptionsTabPage(Window *pParent, const SfxItemSet &rOptions)
//STRIP001 	: SfxTabPage(pParent, SmResId(RID_PRINTOPTIONPAGE), rOptions),
//STRIP001     aFixedLine1     (this, ResId( FL_PRINTOPTIONS )),
//STRIP001 	aTitle		   	(this, ResId( CB_TITLEROW )),
//STRIP001 	aText		   	(this, ResId( CB_EQUATION_TEXT )),
//STRIP001 	aFrame		   	(this, ResId( CB_FRAME )),
//STRIP001     aFixedLine2     (this, ResId( FL_PRINT_FORMAT )),
//STRIP001 	aSizeNormal    	(this, ResId( RB_ORIGINAL_SIZE )),
//STRIP001 	aSizeScaled    	(this, ResId( RB_FIT_TO_PAGE )),
//STRIP001 	aSizeZoomed    	(this, ResId( RB_ZOOM )),
//STRIP001 	aZoom		   	(this, ResId( MF_ZOOM )),
//STRIP001     aFixedLine3      (this, ResId( FL_MISC_OPTIONS )),
//STRIP001 	aNoRightSpaces	(this, ResId( CB_IGNORE_SPACING ))
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001
//STRIP001 	aSizeNormal.SetClickHdl(LINK(this, SmPrintOptionsTabPage, SizeButtonClickHdl));
//STRIP001 	aSizeScaled.SetClickHdl(LINK(this, SmPrintOptionsTabPage, SizeButtonClickHdl));
//STRIP001 	aSizeZoomed.SetClickHdl(LINK(this, SmPrintOptionsTabPage, SizeButtonClickHdl));
//STRIP001
//STRIP001 	Reset(rOptions);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 BOOL SmPrintOptionsTabPage::FillItemSet(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	UINT16  nPrintSize;
//STRIP001 	if (aSizeNormal.IsChecked())
//STRIP001 		nPrintSize = PRINT_SIZE_NORMAL;
//STRIP001 	else if (aSizeScaled.IsChecked())
//STRIP001 		nPrintSize = PRINT_SIZE_SCALED;
//STRIP001 	else
//STRIP001 		nPrintSize = PRINT_SIZE_ZOOMED;
//STRIP001
//STRIP001 	rSet.Put(SfxUInt16Item(GetWhich(SID_PRINTSIZE), (UINT16) nPrintSize));
//STRIP001 	rSet.Put(SfxUInt16Item(GetWhich(SID_PRINTZOOM), (UINT16) aZoom.GetValue()));
//STRIP001 	rSet.Put(SfxBoolItem(GetWhich(SID_PRINTTITLE), aTitle.IsChecked()));
//STRIP001 	rSet.Put(SfxBoolItem(GetWhich(SID_PRINTTEXT), aText.IsChecked()));
//STRIP001 	rSet.Put(SfxBoolItem(GetWhich(SID_PRINTFRAME), aFrame.IsChecked()));
//STRIP001 	rSet.Put(SfxBoolItem(GetWhich(SID_NO_RIGHT_SPACES), aNoRightSpaces.IsChecked()));
//STRIP001
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmPrintOptionsTabPage::Reset(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SmPrintSize ePrintSize = (SmPrintSize)((const SfxUInt16Item &)rSet.Get(GetWhich(SID_PRINTSIZE))).GetValue();
//STRIP001
//STRIP001 	aSizeNormal.Check(ePrintSize == PRINT_SIZE_NORMAL);
//STRIP001 	aSizeScaled.Check(ePrintSize == PRINT_SIZE_SCALED);
//STRIP001 	aSizeZoomed.Check(ePrintSize == PRINT_SIZE_ZOOMED);
//STRIP001
//STRIP001 	aZoom.Enable(aSizeZoomed.IsChecked());
//STRIP001
//STRIP001 	aZoom.SetValue(((const SfxUInt16Item &)rSet.Get(GetWhich(SID_PRINTZOOM))).GetValue());
//STRIP001
//STRIP001 	aTitle.Check(((const SfxBoolItem &)rSet.Get(GetWhich(SID_PRINTTITLE))).GetValue());
//STRIP001 	aText.Check(((const SfxBoolItem &)rSet.Get(GetWhich(SID_PRINTTEXT))).GetValue());
//STRIP001 	aFrame.Check(((const SfxBoolItem &)rSet.Get(GetWhich(SID_PRINTFRAME))).GetValue());
//STRIP001 	aNoRightSpaces.Check(((const SfxBoolItem &)rSet.Get(GetWhich(SID_NO_RIGHT_SPACES))).GetValue());
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SfxTabPage* SmPrintOptionsTabPage::Create(Window* pWindow, const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	return (new SmPrintOptionsTabPage(pWindow, rSet));
//STRIP001 }
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001
//STRIP001 void SmShowFont::Paint(const Rectangle& rRect )
//STRIP001 {
//STRIP001     Control::Paint( rRect );
//STRIP001
//STRIP001 	XubString	Text (GetFont().GetName());
//STRIP001 	Size	TextSize(GetTextWidth(Text), GetTextHeight());
//STRIP001
//STRIP001 	DrawText(Point((GetOutputSize().Width()  - TextSize.Width())  / 2,
//STRIP001 				   (GetOutputSize().Height() - TextSize.Height()) / 2), Text);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowFont::SetFont(const Font& rFont)
//STRIP001 {
//STRIP001     Color aTxtColor( GetTextColor() );
//STRIP001 	Font aFont (rFont);
//STRIP001
//STRIP001 	Invalidate();
//STRIP001 	aFont.SetSize(Size(0, 24));
//STRIP001 	aFont.SetAlign(ALIGN_TOP);
//STRIP001 	Control::SetFont(aFont);
//STRIP001
//STRIP001     // keep old text color (new font may have different color)
//STRIP001     SetTextColor( aTxtColor );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK_INLINE_START( SmFontDialog, FontSelectHdl, ComboBox *, pComboBox )
//STRIP001 {
//STRIP001 	Face.SetName(pComboBox->GetText());
//STRIP001 	aShowFont.SetFont(Face);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SmFontDialog, FontSelectHdl, ComboBox *, pComboBox )
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmFontDialog, FontModifyHdl, ComboBox *, pComboBox )
//STRIP001 {
//STRIP001 	// if font is available in list then use it
//STRIP001 	USHORT nPos = pComboBox->GetEntryPos( pComboBox->GetText() );
//STRIP001 	if (COMBOBOX_ENTRY_NOTFOUND != nPos)
//STRIP001 	{
//STRIP001 		FontSelectHdl( pComboBox );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmFontDialog, AttrChangeHdl, CheckBox *, pCheckBox )
//STRIP001 {
//STRIP001 	if (aBoldCheckBox.IsChecked())
//STRIP001 		Face.SetWeight(FontWeight(WEIGHT_BOLD));
//STRIP001 	else
//STRIP001 		Face.SetWeight(FontWeight(WEIGHT_NORMAL));
//STRIP001
//STRIP001 	if (aItalicCheckBox.IsChecked())
//STRIP001 		Face.SetItalic(ITALIC_NORMAL);
//STRIP001 	else
//STRIP001 		Face.SetItalic(ITALIC_NONE);
//STRIP001
//STRIP001 	aShowFont.SetFont(Face);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmFontDialog::SetFont(const Font &rFont)
//STRIP001 {
//STRIP001 	Face = rFont;
//STRIP001
//STRIP001 	aFontBox.SetText(Face.GetName());
//STRIP001 	aBoldCheckBox.Check(Face.GetWeight() == WEIGHT_BOLD);
//STRIP001 	aItalicCheckBox.Check(Face.GetItalic() != ITALIC_NONE);
//STRIP001
//STRIP001 	aShowFont.SetFont(Face);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmFontDialog::SmFontDialog(Window * pParent, BOOL bFreeRes)
//STRIP001 	: ModalDialog(pParent,SmResId(RID_FONTDIALOG)),
//STRIP001 	aFixedText1 	(this, ResId(1)),
//STRIP001 	aFontBox		(this, ResId(1)),
//STRIP001 	aBoldCheckBox	(this, ResId(1)),
//STRIP001 	aItalicCheckBox (this, ResId(2)),
//STRIP001 	aOKButton1		(this, ResId(1)),
//STRIP001 	aCancelButton1	(this, ResId(1)),
//STRIP001 	aShowFont		(this, ResId(1)),
//STRIP001     aFixedText2     (this, ResId(2))
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 	{
//STRIP001 		WaitObject( this );
//STRIP001 		//Application::EnterWait();
//STRIP001
//STRIP001 		// get FontList from printer (if possible), otherwise from application window
//STRIP001 		SmViewShell *pView = SmGetActiveView();
//STRIP001 		DBG_ASSERT(pView, "Sm : NULL pointer");
//STRIP001 		OutputDevice *pDev = pView->GetDoc()->GetPrinter();
//STRIP001 		if (!pDev || pDev->GetDevFontCount() == 0)
//STRIP001 	    	pDev = &pView->GetGraphicWindow();
//STRIP001 		FontList aFontList(pDev);
//STRIP001
//STRIP001 		USHORT	nCount = aFontList.GetFontNameCount();
//STRIP001 		for (USHORT i = 0;  i < nCount;  i++)
//STRIP001 			aFontBox.InsertEntry( aFontList.GetFontName(i).GetName() );
//STRIP001
//STRIP001 		Face.SetSize(Size(0, 24));
//STRIP001 		Face.SetWeight(WEIGHT_NORMAL);
//STRIP001 		Face.SetItalic(ITALIC_NONE);
//STRIP001 		Face.SetFamily(FAMILY_DONTKNOW);
//STRIP001 		Face.SetPitch(PITCH_DONTKNOW);
//STRIP001 		Face.SetCharSet(RTL_TEXTENCODING_DONTKNOW);
//STRIP001 		Face.SetTransparent(TRUE);
//STRIP001
//STRIP001         InitColor_Impl();
//STRIP001
//STRIP001         // preview like controls should have a 2D look
//STRIP001         aShowFont.SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001
//STRIP001         //Application::LeaveWait();
//STRIP001 	}
//STRIP001
//STRIP001 	aFontBox.SetSelectHdl(LINK(this, SmFontDialog, FontSelectHdl));
//STRIP001 	aFontBox.SetModifyHdl(LINK(this, SmFontDialog, FontModifyHdl));
//STRIP001 	aBoldCheckBox.SetClickHdl(LINK(this, SmFontDialog, AttrChangeHdl));
//STRIP001 	aItalicCheckBox.SetClickHdl(LINK(this, SmFontDialog, AttrChangeHdl));
//STRIP001 }
//STRIP001
//STRIP001 void SmFontDialog::InitColor_Impl()
//STRIP001 {
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     Color aBC( GetDisplayBackground().GetColor() );
//STRIP001 #endif
//STRIP001     ColorData   nBgCol  = COL_WHITE,
//STRIP001                 nTxtCol = COL_BLACK;
//STRIP001     if (GetDisplayBackground().GetColor().IsDark())
//STRIP001     {
//STRIP001         const StyleSettings &rS = GetSettings().GetStyleSettings();
//STRIP001         nBgCol  = rS.GetFieldColor().GetColor();
//STRIP001         nTxtCol = rS.GetFieldTextColor().GetColor();
//STRIP001     }
//STRIP001
//STRIP001     Color aTmpColor( nBgCol );
//STRIP001     Wallpaper aWall( aTmpColor );
//STRIP001     Color aTxtColor( nTxtCol );
//STRIP001     aShowFont.SetBackground( aWall );
//STRIP001     aShowFont.SetTextColor( aTxtColor );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmFontDialog::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if ( rDCEvt.GetType() == DATACHANGED_SETTINGS  &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             InitColor_Impl();
//STRIP001
//STRIP001     ModalDialog::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmFontSizeDialog, DefaultButtonClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	QueryBox *pQueryBox = new QueryBox(this, SmResId(RID_DEFAULTSAVEQUERY));
//STRIP001
//STRIP001 	if (pQueryBox->Execute() == RET_YES)
//STRIP001 	{
//STRIP001         SmModule *pp = SM_MOD1();
//STRIP001         SmFormat aFmt( pp->GetConfig()->GetStandardFormat() );
//STRIP001         WriteTo( aFmt );
//STRIP001         pp->GetConfig()->SetStandardFormat( aFmt );
//STRIP001 	}
//STRIP001
//STRIP001 	delete pQueryBox;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmFontSizeDialog::SmFontSizeDialog(Window * pParent, BOOL bFreeRes)
//STRIP001 	: ModalDialog(pParent, SmResId(RID_FONTSIZEDIALOG)),
//STRIP001 	aFixedText1(this, ResId(1)),
//STRIP001 	aBaseSize(this, ResId(1)),
//STRIP001 	aFixedText4(this, ResId(4)),
//STRIP001 	aTextSize(this, ResId(4)),
//STRIP001 	aFixedText5(this, ResId(5)),
//STRIP001 	aIndexSize(this, ResId(5)),
//STRIP001 	aFixedText6(this, ResId(6)),
//STRIP001 	aFunctionSize(this, ResId(6)),
//STRIP001 	aFixedText7(this, ResId(7)),
//STRIP001 	aOperatorSize(this, ResId(7)),
//STRIP001 	aFixedText8(this, ResId(8)),
//STRIP001 	aBorderSize(this, ResId(8)),
//STRIP001     aFixedLine1(this, ResId(1)),
//STRIP001 	aOKButton1(this, ResId(1)),
//STRIP001 	aCancelButton1(this, ResId(1)),
//STRIP001 	aDefaultButton(this, ResId(1))
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 	aDefaultButton.SetClickHdl(LINK(this, SmFontSizeDialog, DefaultButtonClickHdl));
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmFontSizeDialog::ReadFrom(const SmFormat &rFormat)
//STRIP001 {
//STRIP001 	//! aufpassen: richtig runden!
//STRIP001 	aBaseSize.SetValue( SmRoundFraction(
//STRIP001 		Sm100th_mmToPts( rFormat.GetBaseSize().Height() ) ) );
//STRIP001
//STRIP001 	aTextSize    .SetValue( rFormat.GetRelSize(SIZ_TEXT) );
//STRIP001 	aIndexSize   .SetValue( rFormat.GetRelSize(SIZ_INDEX) );
//STRIP001 	aFunctionSize.SetValue( rFormat.GetRelSize(SIZ_FUNCTION) );
//STRIP001 	aOperatorSize.SetValue( rFormat.GetRelSize(SIZ_OPERATOR) );
//STRIP001 	aBorderSize  .SetValue( rFormat.GetRelSize(SIZ_LIMITS) );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmFontSizeDialog::WriteTo(SmFormat &rFormat) const
//STRIP001 {
//STRIP001 	rFormat.SetBaseSize( Size(0, SmPtsTo100th_mm(aBaseSize.GetValue())) );
//STRIP001
//STRIP001 	rFormat.SetRelSize(SIZ_TEXT, 	 (USHORT) aTextSize    .GetValue());
//STRIP001 	rFormat.SetRelSize(SIZ_INDEX,	 (USHORT) aIndexSize   .GetValue());
//STRIP001 	rFormat.SetRelSize(SIZ_FUNCTION, (USHORT) aFunctionSize.GetValue());
//STRIP001 	rFormat.SetRelSize(SIZ_OPERATOR, (USHORT) aOperatorSize.GetValue());
//STRIP001 	rFormat.SetRelSize(SIZ_LIMITS,	 (USHORT) aBorderSize  .GetValue());
//STRIP001
//STRIP001 	const Size aTmp (rFormat.GetBaseSize());
//STRIP001 	for (USHORT  i = FNT_BEGIN;  i <= FNT_END;  i++)
//STRIP001         rFormat.SetFontSize(i, aTmp);
//STRIP001
//STRIP001 	rFormat.RequestApplyChanges();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmFontTypeDialog, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	SmFontPickListBox *pActiveListBox;
//STRIP001
//STRIP001 	switch (pMenu->GetCurItemId())
//STRIP001 	{
//STRIP001 		case 1: pActiveListBox = &aVariableFont; break;
//STRIP001 		case 2: pActiveListBox = &aFunctionFont; break;
//STRIP001 		case 3: pActiveListBox = &aNumberFont;	 break;
//STRIP001 		case 4: pActiveListBox = &aTextFont;	 break;
//STRIP001 		case 5: pActiveListBox = &aSerifFont;	 break;
//STRIP001 		case 6: pActiveListBox = &aSansFont;	 break;
//STRIP001 		case 7: pActiveListBox = &aFixedFont;	 break;
//STRIP001 		default:pActiveListBox = NULL;
//STRIP001 	}
//STRIP001
//STRIP001 	if (pActiveListBox)
//STRIP001 	{
//STRIP001 		SmFontDialog *pFontDialog = new SmFontDialog(this);
//STRIP001
//STRIP001 		pActiveListBox->WriteTo(*pFontDialog);
//STRIP001 		if (pFontDialog->Execute() == RET_OK)
//STRIP001 			pActiveListBox->ReadFrom(*pFontDialog);
//STRIP001 		delete pFontDialog;
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK_INLINE_START( SmFontTypeDialog, DefaultButtonClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	QueryBox *pQueryBox = new QueryBox(this, SmResId(RID_DEFAULTSAVEQUERY));
//STRIP001 	if (pQueryBox->Execute() == RET_YES)
//STRIP001 	{
//STRIP001         SmModule *pp = SM_MOD1();
//STRIP001         SmFormat aFmt( pp->GetConfig()->GetStandardFormat() );
//STRIP001         WriteTo( aFmt );
//STRIP001         pp->GetConfig()->SetStandardFormat( aFmt );
//STRIP001 	}
//STRIP001
//STRIP001 	delete pQueryBox;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SmFontTypeDialog, DefaultButtonClickHdl, Button *, pButton )
//STRIP001
//STRIP001
//STRIP001 SmFontTypeDialog::SmFontTypeDialog(Window * pParent, BOOL bFreeRes)
//STRIP001 	: ModalDialog(pParent, SmResId(RID_FONTTYPEDIALOG)),
//STRIP001 	aFixedText1    (this, ResId(1)),
//STRIP001 	aVariableFont  (this, ResId(1)),
//STRIP001 	aFixedText2    (this, ResId(2)),
//STRIP001 	aFunctionFont  (this, ResId(2)),
//STRIP001 	aFixedText3    (this, ResId(3)),
//STRIP001 	aNumberFont    (this, ResId(3)),
//STRIP001 	aFixedText4    (this, ResId(4)),
//STRIP001 	aTextFont	   (this, ResId(4)),
//STRIP001 	aFixedText5    (this, ResId(5)),
//STRIP001 	aSerifFont	   (this, ResId(5)),
//STRIP001 	aFixedText6    (this, ResId(6)),
//STRIP001 	aSansFont	   (this, ResId(6)),
//STRIP001 	aFixedText7    (this, ResId(7)),
//STRIP001 	aFixedFont	   (this, ResId(7)),
//STRIP001     aFixedLine1    (this, ResId(1)),
//STRIP001     aFixedLine2    (this, ResId(2)),
//STRIP001 	aOKButton1	   (this, ResId(1)),
//STRIP001 	aCancelButton1 (this, ResId(1)),
//STRIP001 	aMenuButton    (this, ResId(1)),
//STRIP001 	aDefaultButton (this, ResId(2))
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 	aDefaultButton.SetClickHdl(LINK(this, SmFontTypeDialog, DefaultButtonClickHdl));
//STRIP001
//STRIP001 	aMenuButton.GetPopupMenu()->SetSelectHdl(LINK(this, SmFontTypeDialog, MenuSelectHdl));
//STRIP001 }
//STRIP001
//STRIP001 void SmFontTypeDialog::ReadFrom(const SmFormat &rFormat)
//STRIP001 {
//STRIP001 	SmModule *pp = SM_MOD1();
//STRIP001
//STRIP001 	aVariableFont = pp->GetConfig()->GetFontPickList(FNT_VARIABLE);
//STRIP001 	aFunctionFont = pp->GetConfig()->GetFontPickList(FNT_FUNCTION);
//STRIP001 	aNumberFont   = pp->GetConfig()->GetFontPickList(FNT_NUMBER);
//STRIP001 	aTextFont	  = pp->GetConfig()->GetFontPickList(FNT_TEXT);
//STRIP001 	aSerifFont	  = pp->GetConfig()->GetFontPickList(FNT_SERIF);
//STRIP001 	aSansFont	  = pp->GetConfig()->GetFontPickList(FNT_SANS);
//STRIP001 	aFixedFont	  = pp->GetConfig()->GetFontPickList(FNT_FIXED);
//STRIP001
//STRIP001 	aVariableFont.Insert( rFormat.GetFont(FNT_VARIABLE) );
//STRIP001 	aFunctionFont.Insert( rFormat.GetFont(FNT_FUNCTION) );
//STRIP001 	aNumberFont  .Insert( rFormat.GetFont(FNT_NUMBER) );
//STRIP001 	aTextFont    .Insert( rFormat.GetFont(FNT_TEXT) );
//STRIP001 	aSerifFont   .Insert( rFormat.GetFont(FNT_SERIF) );
//STRIP001 	aSansFont    .Insert( rFormat.GetFont(FNT_SANS) );
//STRIP001 	aFixedFont   .Insert( rFormat.GetFont(FNT_FIXED) );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmFontTypeDialog::WriteTo(SmFormat &rFormat) const
//STRIP001 {
//STRIP001 	SmModule *pp = SM_MOD1();
//STRIP001
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_VARIABLE) = aVariableFont;
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_FUNCTION) = aFunctionFont;
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_NUMBER)   = aNumberFont;
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_TEXT)	   = aTextFont;
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_SERIF)    = aSerifFont;
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_SANS)	   = aSansFont;
//STRIP001 	pp->GetConfig()->GetFontPickList(FNT_FIXED)    = aFixedFont;
//STRIP001
//STRIP001 	rFormat.SetFont( FNT_VARIABLE, aVariableFont.Get(0) );
//STRIP001 	rFormat.SetFont( FNT_FUNCTION, aFunctionFont.Get(0) );
//STRIP001 	rFormat.SetFont( FNT_NUMBER,   aNumberFont  .Get(0) );
//STRIP001 	rFormat.SetFont( FNT_TEXT,     aTextFont    .Get(0) );
//STRIP001 	rFormat.SetFont( FNT_SERIF,    aSerifFont   .Get(0) );
//STRIP001 	rFormat.SetFont( FNT_SANS,     aSansFont    .Get(0) );
//STRIP001 	rFormat.SetFont( FNT_FIXED,    aFixedFont   .Get(0) );
//STRIP001
//STRIP001 	rFormat.RequestApplyChanges();
//STRIP001 }
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001 struct FieldMinMax
//STRIP001 {
//STRIP001 	USHORT nMin, nMax;
//STRIP001 };
//STRIP001
//STRIP001 // Data for min and max values of the 4 metric fields
//STRIP001 // for each of the 10 categories
//STRIP001 static const FieldMinMax pMinMaxData[10][4] =
//STRIP001 {
//STRIP001 	// 0
//STRIP001 	{{ 0, 200 },	{ 0, 200 },		{ 0, 100 },		{ 0, 0 }},
//STRIP001 	// 1
//STRIP001 	{{ 0, 100 },	{ 0, 100 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 2
//STRIP001 	{{ 0, 100 },	{ 0, 100 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 3
//STRIP001 	{{ 0, 100 },	{ 1, 100 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 4
//STRIP001 	{{ 0, 100 },	{ 0, 100 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 5
//STRIP001 	{{ 0, 100 },	{ 0, 100 },		{ 0, 0 },		{ 0, 100 }},
//STRIP001 	// 6
//STRIP001 	{{ 0, 300 },	{ 0, 300 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 7
//STRIP001 	{{ 0, 100 },	{ 0, 100 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 8
//STRIP001 	{{ 0, 100 },	{ 0, 100 },		{ 0, 0 },		{ 0, 0 }},
//STRIP001 	// 9
//STRIP001 	{{ 0, 10000 },	{ 0, 10000 },	{ 0, 10000 },	{ 0, 10000 }}
//STRIP001 };
//STRIP001
//STRIP001 SmCategoryDesc::SmCategoryDesc(const ResId& rResId, USHORT nCategoryIdx) :
//STRIP001     Resource(rResId),
//STRIP001     bIsHighContrast(FALSE)
//STRIP001 {
//STRIP001 	if (IsAvailableRes(ResId(1).SetRT(RSC_STRING)))
//STRIP001 	{
//STRIP001 		Name = XubString(ResId(1));
//STRIP001
//STRIP001 		int i;
//STRIP001 		for (i = 0; i < 4; i++)
//STRIP001 		{
//STRIP001 			int nI2 = i + 2;
//STRIP001
//STRIP001 			if (IsAvailableRes(ResId(nI2).SetRT(RSC_STRING)))
//STRIP001 			{
//STRIP001 				Strings  [i] = new XubString(ResId(nI2));
//STRIP001 				Graphics [i] = new Bitmap(ResId(10*nI2));
//STRIP001 				GraphicsH[i] = new Bitmap(ResId(10*nI2+1));
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				Strings  [i] = 0;
//STRIP001 				Graphics [i] = 0;
//STRIP001 				GraphicsH[i] = 0;
//STRIP001 			}
//STRIP001 		}
//STRIP001
//STRIP001 		for (i = 0; i < 4; i++)
//STRIP001 		{
//STRIP001 			const FieldMinMax &rMinMax = pMinMaxData[ nCategoryIdx ][i];
//STRIP001 			Value[i] = Minimum[i] = rMinMax.nMin;
//STRIP001 			Maximum[i] = rMinMax.nMax;
//STRIP001 		}
//STRIP001 	}
//STRIP001
//STRIP001 	FreeResource();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmCategoryDesc::~SmCategoryDesc()
//STRIP001 {
//STRIP001 	for (int i = 0; i < 4; i++)
//STRIP001 	{
//STRIP001         delete Strings  [i];
//STRIP001         delete Graphics [i];
//STRIP001         delete GraphicsH[i];
//STRIP001 	}
//STRIP001 }
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001 IMPL_LINK( SmDistanceDialog, GetFocusHdl, Control *, pControl )
//STRIP001 {
//STRIP001 	if (Categories[nActiveCategory])
//STRIP001 	{
//STRIP001 		USHORT	i;
//STRIP001
//STRIP001 		if (pControl == &aMetricField1)
//STRIP001 			i = 0;
//STRIP001 		else if (pControl == &aMetricField2)
//STRIP001 			i = 1;
//STRIP001 		else if (pControl == &aMetricField3)
//STRIP001 			i = 2;
//STRIP001 		else if (pControl == &aMetricField4)
//STRIP001 			i = 3;
//STRIP001 		else
//STRIP001 			return 0;
//STRIP001 		aBitmap.SetBitmap(*(Categories[nActiveCategory]->GetGraphic(i)));
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001 IMPL_LINK( SmDistanceDialog, MenuSelectHdl, Menu *, pMenu )
//STRIP001 {
//STRIP001 	SetCategory(pMenu->GetCurItemId() - 1);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmDistanceDialog, DefaultButtonClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	QueryBox *pQueryBox = new QueryBox(this, SmResId(RID_DEFAULTSAVEQUERY));
//STRIP001
//STRIP001 	if (pQueryBox->Execute() == RET_YES)
//STRIP001 	{
//STRIP001         SmModule *pp = SM_MOD1();
//STRIP001         SmFormat aFmt( pp->GetConfig()->GetStandardFormat() );
//STRIP001         WriteTo( aFmt );
//STRIP001         pp->GetConfig()->SetStandardFormat( aFmt );
//STRIP001 	}
//STRIP001 	delete pQueryBox;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmDistanceDialog, CheckBoxClickHdl, CheckBox *, pCheckBox )
//STRIP001 {
//STRIP001 	if (pCheckBox == &aCheckBox1)
//STRIP001 	{
//STRIP001 		aCheckBox1.Toggle();
//STRIP001
//STRIP001 		BOOL bChecked = aCheckBox1.IsChecked();
//STRIP001 		aFixedText4  .Enable( bChecked );
//STRIP001 		aMetricField4.Enable( bChecked );
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmDistanceDialog::SetHelpId(MetricField &rField, ULONG nHelpId)
//STRIP001 {
//STRIP001  //! HelpID's die auf diese Weise explizit gesetzt werden, muessen im
//STRIP001 	//! util Verzeichnis im File "hidother.src" mit Hilfe von "hidspecial"
//STRIP001 	//! definiert werden!
//STRIP001
//STRIP001 	const XubString aEmptyText;
//STRIP001 	DBG_ASSERT(aEmptyText.Len() == 0, "Sm: Ooops...");
//STRIP001
//STRIP001 	rField.SetHelpId(nHelpId);
//STRIP001 	rField.SetHelpText(aEmptyText);
//STRIP001
//STRIP001 	// since MetricField inherits from SpinField which has a sub Edit field
//STRIP001 	// (which is actually the one we modify) we have to set the help-id
//STRIP001 	// for it too.
//STRIP001 	Edit *pSubEdit = rField.GetSubEdit();
//STRIP001 	if (pSubEdit)
//STRIP001 	{	pSubEdit->SetHelpId(nHelpId);
//STRIP001 		pSubEdit->SetHelpText(aEmptyText);
//STRIP001 	}
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmDistanceDialog::SetCategory(USHORT nCategory)
//STRIP001 {
//STRIP001 	DBG_ASSERT(0 <= nCategory  &&  nCategory < NOCATEGORIES,
//STRIP001 		"Sm: falsche Kategorienummer in SmDistanceDialog");
//STRIP001
//STRIP001 	// array to convert category- and metricfield-number in help ids.
//STRIP001 	// 0 is used in case of unused combinations.
//STRIP001  DBG_ASSERT(NOCATEGORIES == 10, "Sm : Array passt nicht zu Anzahl der Kategorien");
//STRIP001 	ULONG __READONLY_DATA  aCatMf2Hid[10][4] =
//STRIP001 	{
//STRIP001 		HID_SMA_DEFAULT_DIST,		HID_SMA_LINE_DIST,			HID_SMA_ROOT_DIST, 0,
//STRIP001 		HID_SMA_SUP_DIST, 			HID_SMA_SUB_DIST ,			0, 0,
//STRIP001 		HID_SMA_NUMERATOR_DIST, 	HID_SMA_DENOMINATOR_DIST,	0, 0,
//STRIP001 		HID_SMA_FRACLINE_EXCWIDTH,	HID_SMA_FRACLINE_LINEWIDTH, 0, 0,
//STRIP001 		HID_SMA_UPPERLIMIT_DIST,	HID_SMA_LOWERLIMIT_DIST,	0, 0,
//STRIP001 		HID_SMA_BRACKET_EXCHEIGHT,	HID_SMA_BRACKET_DIST,		0, HID_SMA_BRACKET_EXCHEIGHT2,
//STRIP001 		HID_SMA_MATRIXROW_DIST, 	HID_SMA_MATRIXCOL_DIST, 	0, 0,
//STRIP001 		HID_SMA_ATTRIBUT_DIST,		HID_SMA_INTERATTRIBUT_DIST, 0, 0,
//STRIP001 		HID_SMA_OPERATOR_EXCHEIGHT, HID_SMA_OPERATOR_DIST,		0, 0,
//STRIP001 		HID_SMA_LEFTBORDER_DIST,	HID_SMA_RIGHTBORDER_DIST,	HID_SMA_UPPERBORDER_DIST, HID_SMA_LOWERBORDER_DIST
//STRIP001 	};
//STRIP001
//STRIP001 	// array to help iterate over the controls
//STRIP001 	Window * __READONLY_DATA  aWin[4][2] =
//STRIP001 	{
//STRIP001 		&aFixedText1,	&aMetricField1,
//STRIP001 		&aFixedText2,	&aMetricField2,
//STRIP001 		&aFixedText3,	&aMetricField3,
//STRIP001 		&aFixedText4,	&aMetricField4
//STRIP001 	};
//STRIP001
//STRIP001 	SmCategoryDesc *pCat;
//STRIP001
//STRIP001 	// merken der (evtl neuen) Einstellungen der aktiven SmCategoryDesc
//STRIP001 	// bevor zu der neuen gewechselt wird.
//STRIP001 	if (nActiveCategory != CATEGORY_NONE)
//STRIP001 	{
//STRIP001 		pCat = Categories[nActiveCategory];
//STRIP001 		pCat->SetValue(0, (USHORT) aMetricField1.GetValue());
//STRIP001 		pCat->SetValue(1, (USHORT) aMetricField2.GetValue());
//STRIP001 		pCat->SetValue(2, (USHORT) aMetricField3.GetValue());
//STRIP001 		pCat->SetValue(3, (USHORT) aMetricField4.GetValue());
//STRIP001
//STRIP001 		if (nActiveCategory == 5)
//STRIP001 			bScaleAllBrackets = aCheckBox1.IsChecked();
//STRIP001
//STRIP001 		aMenuButton.GetPopupMenu()->CheckItem(nActiveCategory + 1, FALSE);
//STRIP001 	}
//STRIP001
//STRIP001  // aktivieren/deaktivieren der zugehoerigen Controls in Abhaengigkeit von der
//STRIP001  // gewaehlten Kategorie.
//STRIP001 	BOOL  bActive;
//STRIP001 	for (int i = 0;  i < 4;  i++)
//STRIP001 	{
//STRIP001 		FixedText   *pFT = (FixedText * const)   aWin[i][0];
//STRIP001 		MetricField *pMF = (MetricField * const) aWin[i][1];
//STRIP001
//STRIP001 		// Um feststellen welche Controls aktiv sein sollen wird das
//STRIP001      // vorhandensein einer zugehoerigen HelpID ueberprueft.
//STRIP001 		bActive = aCatMf2Hid[nCategory][i] != 0;
//STRIP001
//STRIP001 		pFT->Show(bActive);
//STRIP001 		pFT->Enable(bActive);
//STRIP001 		pMF->Show(bActive);
//STRIP001 		pMF->Enable(bActive);
//STRIP001
//STRIP001      // setzen von Masseinheit und Anzahl der Nachkommastellen
//STRIP001 		FieldUnit  eUnit;
//STRIP001 		USHORT     nDigits;
//STRIP001 		if (nCategory < 9)
//STRIP001 		{
//STRIP001 			eUnit   = FUNIT_CUSTOM;
//STRIP001 			nDigits = 0;
//STRIP001 			pMF->SetCustomUnitText( '%' );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			eUnit   = FUNIT_100TH_MM;
//STRIP001 			nDigits = 2;
//STRIP001 		}
//STRIP001      pMF->SetUnit(eUnit);            //! veraendert den Wert
//STRIP001 		pMF->SetDecimalDigits(nDigits);
//STRIP001
//STRIP001 		if (bActive)
//STRIP001 		{
//STRIP001 			pCat = Categories[nCategory];
//STRIP001 			pFT->SetText(*pCat->GetString(i));
//STRIP001
//STRIP001 			pMF->SetMin(pCat->GetMinimum(i));
//STRIP001 			pMF->SetMax(pCat->GetMaximum(i));
//STRIP001 			pMF->SetValue(pCat->GetValue(i));
//STRIP001
//STRIP001 			SetHelpId(*pMF, aCatMf2Hid[nCategory][i]);
//STRIP001 		}
//STRIP001 	}
//STRIP001  // nun noch die CheckBox und das zugehoerige MetricField genau dann aktivieren,
//STRIP001 	// falls es sich um das Klammer Menu handelt.
//STRIP001 	bActive = nCategory == 5;
//STRIP001 	aCheckBox1.Show(bActive);
//STRIP001 	aCheckBox1.Enable(bActive);
//STRIP001 	if (bActive)
//STRIP001 	{
//STRIP001 		aCheckBox1.Check( bScaleAllBrackets );
//STRIP001
//STRIP001 		BOOL bChecked = aCheckBox1.IsChecked();
//STRIP001 		aFixedText4  .Enable( bChecked );
//STRIP001 		aMetricField4.Enable( bChecked );
//STRIP001 	}
//STRIP001
//STRIP001 	aMenuButton.GetPopupMenu()->CheckItem(nCategory + 1, TRUE);
//STRIP001     aFixedLine.SetText(Categories[nCategory]->GetName());
//STRIP001
//STRIP001 	nActiveCategory = nCategory;
//STRIP001
//STRIP001 	aMetricField1.GrabFocus();
//STRIP001 	Invalidate();
//STRIP001 	Update();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmDistanceDialog::SmDistanceDialog(Window *pParent, BOOL bFreeRes)
//STRIP001 	: ModalDialog(pParent, SmResId(RID_DISTANCEDIALOG)),
//STRIP001 	aFixedText1    (this, ResId(1)),
//STRIP001 	aFixedText2    (this, ResId(2)),
//STRIP001 	aFixedText3    (this, ResId(3)),
//STRIP001 	aFixedText4    (this, ResId(4)),
//STRIP001 	aMetricField1  (this, ResId(1)),
//STRIP001 	aMetricField2  (this, ResId(2)),
//STRIP001 	aMetricField3  (this, ResId(3)),
//STRIP001 	aMetricField4  (this, ResId(4)),
//STRIP001 	aOKButton1	   (this, ResId(1)),
//STRIP001 	aCancelButton1 (this, ResId(1)),
//STRIP001 	aMenuButton    (this, ResId(1)),
//STRIP001 	aDefaultButton (this, ResId(1)),
//STRIP001 	aCheckBox1	   (this, ResId(1)),
//STRIP001 	aBitmap 	   (this, ResId(1)),
//STRIP001     aFixedLine     (this, ResId(1))
//STRIP001 {
//STRIP001 	for (int i = 0; i < NOCATEGORIES; i++)
//STRIP001 		Categories[i] = new SmCategoryDesc(SmResId(i + 1), i);
//STRIP001 	nActiveCategory   = CATEGORY_NONE;
//STRIP001 	bScaleAllBrackets = FALSE;
//STRIP001
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001     ApplyImages();
//STRIP001
//STRIP001     // preview like controls should have a 2D look
//STRIP001     aBitmap.SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001
//STRIP001 	aMetricField1.SetGetFocusHdl(LINK(this, SmDistanceDialog, GetFocusHdl));
//STRIP001 	aMetricField2.SetGetFocusHdl(LINK(this, SmDistanceDialog, GetFocusHdl));
//STRIP001 	aMetricField3.SetGetFocusHdl(LINK(this, SmDistanceDialog, GetFocusHdl));
//STRIP001 	aMetricField4.SetGetFocusHdl(LINK(this, SmDistanceDialog, GetFocusHdl));
//STRIP001 	aCheckBox1.SetClickHdl(LINK(this, SmDistanceDialog, CheckBoxClickHdl));
//STRIP001
//STRIP001 	aMenuButton.GetPopupMenu()->SetSelectHdl(LINK(this, SmDistanceDialog, MenuSelectHdl));
//STRIP001
//STRIP001 	aDefaultButton.SetClickHdl(LINK(this, SmDistanceDialog, DefaultButtonClickHdl));
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmDistanceDialog::~SmDistanceDialog()
//STRIP001 {
//STRIP001 	for (int i = 0; i < NOCATEGORIES; i++)
//STRIP001 		DELETEZ(Categories[i]);
//STRIP001 }
//STRIP001
//STRIP001 void SmDistanceDialog::ApplyImages()
//STRIP001 {
//STRIP001     BOOL bHighContrast = GetDisplayBackground().GetColor().IsDark() != 0;
//STRIP001     for (int i = 0;  i < NOCATEGORIES;  ++i)
//STRIP001     {
//STRIP001         SmCategoryDesc *pCat = Categories[i];
//STRIP001         if (pCat)
//STRIP001             pCat->SetHighContrast( bHighContrast );
//STRIP001     }
//STRIP001 }
//STRIP001
//STRIP001 void SmDistanceDialog::DataChanged( const DataChangedEvent &rEvt )
//STRIP001 {
//STRIP001     if ( (rEvt.GetType() == DATACHANGED_SETTINGS) && (rEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             ApplyImages();
//STRIP001
//STRIP001     ModalDialog::DataChanged( rEvt );
//STRIP001 }
//STRIP001
//STRIP001 void SmDistanceDialog::ReadFrom(const SmFormat &rFormat)
//STRIP001 {
//STRIP001 	Categories[0]->SetValue(0, rFormat.GetDistance(DIS_HORIZONTAL));
//STRIP001 	Categories[0]->SetValue(1, rFormat.GetDistance(DIS_VERTICAL));
//STRIP001 	Categories[0]->SetValue(2, rFormat.GetDistance(DIS_ROOT));
//STRIP001 	Categories[1]->SetValue(0, rFormat.GetDistance(DIS_SUPERSCRIPT));
//STRIP001 	Categories[1]->SetValue(1, rFormat.GetDistance(DIS_SUBSCRIPT));
//STRIP001 	Categories[2]->SetValue(0, rFormat.GetDistance(DIS_NUMERATOR));
//STRIP001 	Categories[2]->SetValue(1, rFormat.GetDistance(DIS_DENOMINATOR));
//STRIP001 	Categories[3]->SetValue(0, rFormat.GetDistance(DIS_FRACTION));
//STRIP001 	Categories[3]->SetValue(1, rFormat.GetDistance(DIS_STROKEWIDTH));
//STRIP001 	Categories[4]->SetValue(0, rFormat.GetDistance(DIS_UPPERLIMIT));
//STRIP001 	Categories[4]->SetValue(1, rFormat.GetDistance(DIS_LOWERLIMIT));
//STRIP001 	Categories[5]->SetValue(0, rFormat.GetDistance(DIS_BRACKETSIZE));
//STRIP001 	Categories[5]->SetValue(1, rFormat.GetDistance(DIS_BRACKETSPACE));
//STRIP001 	Categories[5]->SetValue(3, rFormat.GetDistance(DIS_NORMALBRACKETSIZE));
//STRIP001 	Categories[6]->SetValue(0, rFormat.GetDistance(DIS_MATRIXROW));
//STRIP001 	Categories[6]->SetValue(1, rFormat.GetDistance(DIS_MATRIXCOL));
//STRIP001 	Categories[7]->SetValue(0, rFormat.GetDistance(DIS_ORNAMENTSIZE));
//STRIP001 	Categories[7]->SetValue(1, rFormat.GetDistance(DIS_ORNAMENTSPACE));
//STRIP001 	Categories[8]->SetValue(0, rFormat.GetDistance(DIS_OPERATORSIZE));
//STRIP001 	Categories[8]->SetValue(1, rFormat.GetDistance(DIS_OPERATORSPACE));
//STRIP001 	Categories[9]->SetValue(0, rFormat.GetDistance(DIS_LEFTSPACE));
//STRIP001 	Categories[9]->SetValue(1, rFormat.GetDistance(DIS_RIGHTSPACE));
//STRIP001 	Categories[9]->SetValue(2, rFormat.GetDistance(DIS_TOPSPACE));
//STRIP001 	Categories[9]->SetValue(3, rFormat.GetDistance(DIS_BOTTOMSPACE));
//STRIP001
//STRIP001 	bScaleAllBrackets = rFormat.IsScaleNormalBrackets();
//STRIP001
//STRIP001 	// force update (even of category 0) by setting nActiveCategory to a
//STRIP001 	// non-existent category number
//STRIP001 	nActiveCategory = CATEGORY_NONE;
//STRIP001 	SetCategory(0);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmDistanceDialog::WriteTo(SmFormat &rFormat) /*const*/
//STRIP001 {
//STRIP001  // hmm... koennen die tatsaechlich unterschiedlich sein?
//STRIP001  // wenn nicht kann oben naemlich das const stehen!
//STRIP001 	SetCategory(nActiveCategory);
//STRIP001
//STRIP001 	rFormat.SetDistance( DIS_HORIZONTAL,    	Categories[0]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_VERTICAL,  		Categories[0]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_ROOT,  			Categories[0]->GetValue(2) );
//STRIP001 	rFormat.SetDistance( DIS_SUPERSCRIPT,   	Categories[1]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_SUBSCRIPT,     	Categories[1]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_NUMERATOR,     	Categories[2]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_DENOMINATOR,   	Categories[2]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_FRACTION,  		Categories[3]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_STROKEWIDTH,   	Categories[3]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_UPPERLIMIT,    	Categories[4]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_LOWERLIMIT,    	Categories[4]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_BRACKETSIZE,   	Categories[5]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_BRACKETSPACE,  	Categories[5]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_MATRIXROW,     	Categories[6]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_MATRIXCOL,     	Categories[6]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_ORNAMENTSIZE,  	Categories[7]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_ORNAMENTSPACE, 	Categories[7]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_OPERATORSIZE,  	Categories[8]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_OPERATORSPACE, 	Categories[8]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_LEFTSPACE,     	Categories[9]->GetValue(0) );
//STRIP001 	rFormat.SetDistance( DIS_RIGHTSPACE,    	Categories[9]->GetValue(1) );
//STRIP001 	rFormat.SetDistance( DIS_TOPSPACE,  		Categories[9]->GetValue(2) );
//STRIP001 	rFormat.SetDistance( DIS_BOTTOMSPACE,   	Categories[9]->GetValue(3) );
//STRIP001 	rFormat.SetDistance( DIS_NORMALBRACKETSIZE, Categories[5]->GetValue(3) );
//STRIP001
//STRIP001 	rFormat.SetScaleNormalBrackets( bScaleAllBrackets );
//STRIP001
//STRIP001 	rFormat.RequestApplyChanges();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmAlignDialog, DefaultButtonClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001    QueryBox *pQueryBox = new QueryBox(this, SmResId(RID_DEFAULTSAVEQUERY));
//STRIP001
//STRIP001 	if (pQueryBox->Execute() == RET_YES)
//STRIP001 	{
//STRIP001         SmModule *pp = SM_MOD1();
//STRIP001         SmFormat aFmt( pp->GetConfig()->GetStandardFormat() );
//STRIP001         WriteTo( aFmt );
//STRIP001         pp->GetConfig()->SetStandardFormat( aFmt );
//STRIP001 	}
//STRIP001
//STRIP001 	delete pQueryBox;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmAlignDialog::SmAlignDialog(Window * pParent, BOOL bFreeRes)
//STRIP001 	: ModalDialog(pParent, SmResId(RID_ALIGNDIALOG)),
//STRIP001 	aLeft		   (this, ResId(1)),
//STRIP001 	aCenter 	   (this, ResId(2)),
//STRIP001 	aRight		   (this, ResId(3)),
//STRIP001     aFixedLine1    (this, ResId(1)),
//STRIP001 	aOKButton1	   (this, ResId(1)),
//STRIP001 	aCancelButton1 (this, ResId(1)),
//STRIP001 	aDefaultButton (this, ResId(1))
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 	aDefaultButton.SetClickHdl(LINK(this, SmAlignDialog, DefaultButtonClickHdl));
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmAlignDialog::ReadFrom(const SmFormat &rFormat)
//STRIP001 {
//STRIP001 	switch (rFormat.GetHorAlign())
//STRIP001 	{
//STRIP001 		case AlignLeft:
//STRIP001 			aLeft  .Check(TRUE);
//STRIP001 			aCenter.Check(FALSE);
//STRIP001 			aRight .Check(FALSE);
//STRIP001 			break;
//STRIP001
//STRIP001 		case AlignCenter:
//STRIP001 			aLeft  .Check(FALSE);
//STRIP001 			aCenter.Check(TRUE);
//STRIP001 			aRight .Check(FALSE);
//STRIP001 			break;
//STRIP001
//STRIP001 		case AlignRight:
//STRIP001 			aLeft  .Check(FALSE);
//STRIP001 			aCenter.Check(FALSE);
//STRIP001 			aRight .Check(TRUE);
//STRIP001 			break;
//STRIP001 	}
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmAlignDialog::WriteTo(SmFormat &rFormat) const
//STRIP001 {
//STRIP001 	if (aLeft.IsChecked())
//STRIP001 		rFormat.SetHorAlign(AlignLeft);
//STRIP001 	else if (aRight.IsChecked())
//STRIP001 		rFormat.SetHorAlign(AlignRight);
//STRIP001 	else
//STRIP001 		rFormat.SetHorAlign(AlignCenter);
//STRIP001
//STRIP001 	rFormat.RequestApplyChanges();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 /**************************************************************************/
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbolSet::Paint(const Rectangle&)
//STRIP001 {
//STRIP001 	Push(PUSH_MAPMODE);
//STRIP001
//STRIP001  // MapUnit einstellen fuer die 'nLen' berechnet wurde
//STRIP001 	SetMapMode(MapMode(MAP_PIXEL));
//STRIP001
//STRIP001 	int v		 = (int) (aVScrollBar.GetThumbPos() * nColumns);
//STRIP001 	int nSymbols = (int) aSymbolSet.GetCount();
//STRIP001
//STRIP001     Color aTxtColor( GetTextColor() );
//STRIP001 	for (int i = v; i < nSymbols ; i++)
//STRIP001 	{
//STRIP001 		SmSym 	 aSymbol (aSymbolSet.GetSymbol(i));
//STRIP001 		Font     aFont	 (aSymbol.GetFace());
//STRIP001         aFont.SetAlign(ALIGN_TOP);
//STRIP001
//STRIP001 		// etwas kleinere FontSize nehmen (als nLen) um etwas Luft zu haben
//STRIP001      // (hoffentlich auch genug fuer links und rechts!)
//STRIP001 		aFont.SetSize(Size(0, nLen - (nLen / 3)));
//STRIP001 		SetFont(aFont);
//STRIP001         // keep text color
//STRIP001         SetTextColor( aTxtColor );
//STRIP001
//STRIP001 		int   nIV 	= i - v;
//STRIP001 		Size  aSize(GetTextWidth(aSymbol.GetCharacter()), GetTextHeight());
//STRIP001
//STRIP001 		DrawText(Point((nIV % nColumns) * nLen + (nLen - aSize.Width()) / 2,
//STRIP001 					   (nIV / nColumns) * nLen + (nLen - aSize.Height()) / 2),
//STRIP001 				 aSymbol.GetCharacter());
//STRIP001 	}
//STRIP001
//STRIP001 	if (nSelectSymbol != SYMBOL_NONE)
//STRIP001 	{
//STRIP001 		Invert(Rectangle(Point(((nSelectSymbol - v) % nColumns) * nLen,
//STRIP001 			  				   ((nSelectSymbol - v) / nColumns) * nLen),
//STRIP001 			  			 Size(nLen, nLen)));
//STRIP001 	}
//STRIP001
//STRIP001 	Pop();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbolSet::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	GrabFocus();
//STRIP001
//STRIP001 	if (rMEvt.IsLeft() && Rectangle(Point(0, 0), aOutputSize).IsInside(rMEvt.GetPosPixel()))
//STRIP001 	{
//STRIP001 		SelectSymbol ((rMEvt.GetPosPixel().Y() / nLen) * nColumns + (rMEvt.GetPosPixel().X() / nLen) +
//STRIP001 					  aVScrollBar.GetThumbPos() * nColumns);
//STRIP001
//STRIP001 		aSelectHdlLink.Call(this);
//STRIP001
//STRIP001 		if (rMEvt.GetClicks() > 1) aDblClickHdlLink.Call(this);
//STRIP001 	}
//STRIP001 	else Control::MouseButtonDown (rMEvt);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbolSet::KeyInput(const KeyEvent& rKEvt)
//STRIP001 {
//STRIP001 	USHORT n = nSelectSymbol;
//STRIP001
//STRIP001 	if (n != SYMBOL_NONE)
//STRIP001 	{
//STRIP001 		switch (rKEvt.GetKeyCode().GetCode())
//STRIP001 		{
//STRIP001 			case KEY_DOWN:		n += nColumns;	break;
//STRIP001 			case KEY_UP:		n -= nColumns;	break;
//STRIP001 			case KEY_LEFT:		n -= 1;	break;
//STRIP001 			case KEY_RIGHT:		n += 1;	break;
//STRIP001 			case KEY_HOME:		n  = 0;	break;
//STRIP001 			case KEY_END:		n  = aSymbolSet.GetCount() - 1;	break;
//STRIP001 			case KEY_PAGEUP:	n -= nColumns * nRows;	break;
//STRIP001 			case KEY_PAGEDOWN:	n += nColumns * nRows;	break;
//STRIP001
//STRIP001 			default:
//STRIP001 				Control::KeyInput(rKEvt);
//STRIP001 				return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		n = 0;
//STRIP001
//STRIP001 	if (n >= aSymbolSet.GetCount())
//STRIP001 		n = nSelectSymbol;
//STRIP001
//STRIP001 	// adjust scrollbar
//STRIP001 	if ((n < (USHORT) (aVScrollBar.GetThumbPos() * nColumns)) ||
//STRIP001 		(n >= (USHORT) ((aVScrollBar.GetThumbPos() + nRows) * nColumns)))
//STRIP001 	{
//STRIP001 		aVScrollBar.SetThumbPos(n / nColumns);
//STRIP001 		Invalidate();
//STRIP001 		Update();
//STRIP001 	}
//STRIP001
//STRIP001 	SelectSymbol(n);
//STRIP001 	aSelectHdlLink.Call(this);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmShowSymbolSet::SmShowSymbolSet(Window *pParent, const ResId& rResId) :
//STRIP001 	Control(pParent, rResId),
//STRIP001 	aVScrollBar(this, WinBits(WB_VSCROLL))
//STRIP001 {
//STRIP001 	nSelectSymbol = SYMBOL_NONE;
//STRIP001
//STRIP001 	aOutputSize = GetOutputSizePixel();
//STRIP001 	long nScrollBarWidth = aVScrollBar.GetSizePixel().Width(),
//STRIP001 		 nUseableWidth   = aOutputSize.Width() - nScrollBarWidth;
//STRIP001
//STRIP001  // Hoehe von 16pt in Pixeln (passend zu 'aOutputSize')
//STRIP001 	nLen = (USHORT) LogicToPixel(Size(0, 16), MapMode(MAP_POINT)).Height();
//STRIP001
//STRIP001 	nColumns = nUseableWidth / nLen;
//STRIP001 	if (nColumns > 2  && nColumns % 2 != 0)
//STRIP001 		nColumns--;
//STRIP001 	nRows	 = aOutputSize.Height() / nLen;
//STRIP001 	DBG_ASSERT(nColumns > 0, "Sm : keine Spalten");
//STRIP001 	DBG_ASSERT(nRows > 0, "Sm : keine Zeilen");
//STRIP001
//STRIP001 	// genau passend machen
//STRIP001 	aOutputSize.Width()	 = nColumns * nLen;
//STRIP001 	aOutputSize.Height() = nRows * nLen;
//STRIP001
//STRIP001 	aVScrollBar.SetPosSizePixel(Point(aOutputSize.Width() + 1, -1),
//STRIP001 								Size(nScrollBarWidth, aOutputSize.Height() + 2));
//STRIP001 	aVScrollBar.Enable(FALSE);
//STRIP001 	aVScrollBar.Show();
//STRIP001 	aVScrollBar.SetScrollHdl(LINK(this, SmShowSymbolSet, ScrollHdl));
//STRIP001
//STRIP001 	Size WindowSize (aOutputSize);
//STRIP001 	WindowSize.Width() += nScrollBarWidth;
//STRIP001 	SetOutputSizePixel(WindowSize);
//STRIP001
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbolSet::SetSymbolSet(const SmSymSet& rSymbolSet)
//STRIP001 {
//STRIP001 	aSymbolSet = rSymbolSet;
//STRIP001
//STRIP001 	if (aSymbolSet.GetCount() > (nColumns * nRows))
//STRIP001 	{
//STRIP001 		aVScrollBar.SetRange(Range(0, ((aSymbolSet.GetCount() + (nColumns - 1)) / nColumns) - nRows));
//STRIP001 		aVScrollBar.Enable(TRUE);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		aVScrollBar.SetRange(Range(0,0));
//STRIP001 		aVScrollBar.Enable (FALSE);
//STRIP001 	}
//STRIP001
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbolSet::SelectSymbol(USHORT nSymbol)
//STRIP001 {
//STRIP001 	int v = (int) (aVScrollBar.GetThumbPos() * nColumns);
//STRIP001
//STRIP001 	if (nSelectSymbol != SYMBOL_NONE)
//STRIP001 		Invalidate(Rectangle(Point(((nSelectSymbol - v) % nColumns) * nLen,
//STRIP001 								   ((nSelectSymbol - v) / nColumns) * nLen),
//STRIP001 							 Size(nLen, nLen)));
//STRIP001
//STRIP001 	if (nSymbol < aSymbolSet.GetCount())
//STRIP001 		nSelectSymbol = nSymbol;
//STRIP001
//STRIP001 	if (aSymbolSet.GetCount() == 0)
//STRIP001 		nSelectSymbol = SYMBOL_NONE;
//STRIP001
//STRIP001 	if (nSelectSymbol != SYMBOL_NONE)
//STRIP001 		Invalidate(Rectangle(Point(((nSelectSymbol - v) % nColumns) * nLen,
//STRIP001 								   ((nSelectSymbol - v) / nColumns) * nLen),
//STRIP001 							 Size(nLen, nLen)));
//STRIP001
//STRIP001 	Update();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmShowSymbolSet,	ScrollHdl, ScrollBar*, pScrollBar)
//STRIP001 {
//STRIP001 	Invalidate();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001 ////////////////////////////////////////////////////////////////////////////////
//STRIP001
//STRIP001 void SmShowSymbol::Paint(const Rectangle &rRect)
//STRIP001 {
//STRIP001     Control::Paint( rRect );
//STRIP001
//STRIP001 	const XubString &rText = GetText();
//STRIP001 	Size            aTextSize(GetTextWidth(rText), GetTextHeight());
//STRIP001
//STRIP001 	DrawText(Point((GetOutputSize().Width()  - aTextSize.Width())  / 2,
//STRIP001 				   (GetOutputSize().Height() - aTextSize.Height()) / 2), rText);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbol::MouseButtonDown(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	if (rMEvt.GetClicks() > 1)
//STRIP001 		aDblClickHdlLink.Call(this);
//STRIP001 	else
//STRIP001 		Control::MouseButtonDown (rMEvt);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowSymbol::SetSymbol(const SmSym *pSymbol)
//STRIP001 {
//STRIP001 	if (pSymbol)
//STRIP001 	{
//STRIP001         Color aTxtColor( GetTextColor() );
//STRIP001
//STRIP001 		Font aFont (pSymbol->GetFace());
//STRIP001 		aFont.SetSize(Size(0, GetOutputSize().Height() - GetOutputSize().Height() / 3));
//STRIP001         aFont.SetAlign(ALIGN_TOP);
//STRIP001 		SetFont(aFont);
//STRIP001
//STRIP001         // keep old text color (font may have different color set)
//STRIP001         SetTextColor(aTxtColor);
//STRIP001
//STRIP001 		SetText(XubString(pSymbol->GetCharacter()));
//STRIP001 	}
//STRIP001
//STRIP001  // 'Invalidate' fuellt den background mit der background-Farbe.
//STRIP001  // Falls der NULL pointer uebergeben wurde reicht dies also zum loeschen
//STRIP001 	// der Anzeige
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 ////////////////////////////////////////////////////////////////////////////////
//STRIP001
//STRIP001 void SmSymbolDialog::FillSymbolSets(BOOL bDeleteText)
//STRIP001  // fuellt die Eintraege der moeglichen 'SymbolsSet's im Dialog mit den
//STRIP001 	// aktuellen Werten des SymbolSet Managers, selektiert aber keinen.
//STRIP001 {
//STRIP001 	aSymbolSets.Clear();
//STRIP001 	if (bDeleteText)
//STRIP001 		aSymbolSets.SetNoSelection();
//STRIP001
//STRIP001     USHORT nNumSymSets = rSymSetMgr.GetSymbolSetCount();
//STRIP001 	for (USHORT i = 0;  i < nNumSymSets;  i++)
//STRIP001 		aSymbolSets.InsertEntry(rSymSetMgr.GetSymbolSet(i)->GetName());
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymbolDialog, SymbolSetChangeHdl, ListBox *, pListBox )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pListBox == &aSymbolSets, "Sm : falsches Argument");
//STRIP001
//STRIP001 	SelectSymbolSet(aSymbolSets.GetSelectEntry());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymbolDialog, SymbolChangeHdl, SmShowSymbolSet *, pShowSymbolSet )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pShowSymbolSet == &aSymbolSetDisplay, "Sm : falsches Argument");
//STRIP001
//STRIP001 	SelectSymbol(aSymbolSetDisplay.GetSelectSymbol());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001 IMPL_LINK( SmSymbolDialog, EditClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pButton == &aEditBtn, "Sm : falsches Argument");
//STRIP001
//STRIP001 	SmSymDefineDialog *pDialog = new SmSymDefineDialog(this, rSymSetMgr);
//STRIP001
//STRIP001 	// aktuelles Symbol und SymbolSet am neuen Dialog setzen
//STRIP001 	const XubString  aSymSetName (aSymbolSets.GetSelectEntry()),
//STRIP001 					aSymName    (aSymbolName.GetText());
//STRIP001 	pDialog->SelectOldSymbolSet(aSymSetName);
//STRIP001 	pDialog->SelectOldSymbol(aSymName);
//STRIP001 	pDialog->SelectSymbolSet(aSymSetName);
//STRIP001 	pDialog->SelectSymbol(aSymName);
//STRIP001
//STRIP001 	// altes SymbolSet merken
//STRIP001 	XubString  aOldSymbolSet (aSymbolSets.GetSelectEntry());
//STRIP001
//STRIP001     USHORT nSymPos = GetSelectedSymbol();
//STRIP001
//STRIP001     // Dialog an evtl geaenderte Daten des SymbolSet Manager anpassen
//STRIP001 	if (pDialog->Execute() == RET_OK  &&  rSymSetMgr.IsModified())
//STRIP001 		FillSymbolSets();
//STRIP001
//STRIP001 	// wenn das alte SymbolSet nicht mehr existiert zum ersten gehen
//STRIP001 	// (soweit eines vorhanden ist)
//STRIP001 	if (!SelectSymbolSet(aOldSymbolSet)  &&  aSymbolSets.GetEntryCount() > 0)
//STRIP001 		SelectSymbolSet(aSymbolSets.GetEntry(0));
//STRIP001
//STRIP001     SelectSymbol( nSymPos );
//STRIP001
//STRIP001 	delete pDialog;
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymbolDialog, SymbolDblClickHdl, SmShowSymbolSet *, pShowSymbolSet )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pShowSymbolSet == &aSymbolSetDisplay, "Sm : falsches Argument");
//STRIP001
//STRIP001 	GetClickHdl(&aGetBtn);
//STRIP001 	EndDialog(RET_OK);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymbolDialog, GetClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pButton == &aGetBtn, "Sm : falscher Button");
//STRIP001
//STRIP001 	const SmSym *pSym = GetSymbol();
//STRIP001 	if (pSym)
//STRIP001 	{
//STRIP001 		XubString	aText ('%');
//STRIP001 		aText += pSym->GetName();
//STRIP001
//STRIP001 		SmViewShell *pViewSh = SmGetActiveView();
//STRIP001 		if (pViewSh)
//STRIP001 			pViewSh->GetViewFrame()->GetDispatcher()->Execute(
//STRIP001 					SID_INSERTTEXT, SFX_CALLMODE_STANDARD,
//STRIP001 					new SfxStringItem(SID_INSERTTEXT, aText), 0L);
//STRIP001 	}
//STRIP001
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK_INLINE_START( SmSymbolDialog, CloseClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pButton == &aCloseBtn, "Sm : falscher Button");
//STRIP001
//STRIP001 	EndDialog(TRUE);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SmSymbolDialog, CloseClickHdl, Button *, pButton )
//STRIP001
//STRIP001
//STRIP001 SmSymbolDialog::SmSymbolDialog(Window *pParent, SmSymSetManager &rMgr, BOOL bFreeRes) :
//STRIP001 	ModalDialog			(pParent, SmResId(RID_SYMBOLDIALOG)),
//STRIP001 	aSymbolSetText  	(this, ResId(1)),
//STRIP001 	aSymbolSets    		(this, ResId(1)),
//STRIP001 	aSymbolSetDisplay 	(this, ResId(1)),
//STRIP001 	aSymbolName    		(this, ResId(2)),
//STRIP001 	aSymbolDisplay    	(this, ResId(2)),
//STRIP001 	aCloseBtn  			(this, ResId(3)),
//STRIP001 	aEditBtn  			(this, ResId(1)),
//STRIP001 	aGetBtn	   			(this, ResId(2)),
//STRIP001 	rSymSetMgr			(rMgr)
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 	pSymSet = NULL;
//STRIP001 	FillSymbolSets();
//STRIP001 	if (aSymbolSets.GetEntryCount() > 0)
//STRIP001 		SelectSymbolSet(aSymbolSets.GetEntry(0));
//STRIP001
//STRIP001     InitColor_Impl();
//STRIP001
//STRIP001     // preview like controls should have a 2D look
//STRIP001     aSymbolDisplay.SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001
//STRIP001 	aSymbolSets		 .SetSelectHdl	(LINK(this, SmSymbolDialog, SymbolSetChangeHdl));
//STRIP001 	aSymbolSetDisplay.SetSelectHdl  (LINK(this, SmSymbolDialog, SymbolChangeHdl));
//STRIP001 	aSymbolSetDisplay.SetDblClickHdl(LINK(this, SmSymbolDialog, SymbolDblClickHdl));
//STRIP001 	aSymbolDisplay	 .SetDblClickHdl(LINK(this, SmSymbolDialog, SymbolDblClickHdl));
//STRIP001 	aCloseBtn		 .SetClickHdl   (LINK(this, SmSymbolDialog, CloseClickHdl));
//STRIP001 	aEditBtn		 .SetClickHdl   (LINK(this, SmSymbolDialog, EditClickHdl));
//STRIP001 	aGetBtn			 .SetClickHdl   (LINK(this, SmSymbolDialog, GetClickHdl));
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmSymbolDialog::~SmSymbolDialog()
//STRIP001 {
//STRIP001     rSymSetMgr.Save();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymbolDialog::InitColor_Impl()
//STRIP001 {
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     Color aBC( GetDisplayBackground().GetColor() );
//STRIP001 #endif
//STRIP001     ColorData   nBgCol  = COL_WHITE,
//STRIP001                 nTxtCol = COL_BLACK;
//STRIP001     if (GetDisplayBackground().GetColor().IsDark())
//STRIP001     {
//STRIP001         const StyleSettings &rS = GetSettings().GetStyleSettings();
//STRIP001         nBgCol  = rS.GetFieldColor().GetColor();
//STRIP001         nTxtCol = rS.GetFieldTextColor().GetColor();
//STRIP001     }
//STRIP001
//STRIP001     Color aTmpColor( nBgCol );
//STRIP001     Wallpaper aWall( aTmpColor );
//STRIP001     Color aTxtColor( nTxtCol );
//STRIP001     aSymbolDisplay   .SetBackground( aWall );
//STRIP001     aSymbolDisplay   .SetTextColor( aTxtColor );
//STRIP001     aSymbolSetDisplay.SetBackground( aWall );
//STRIP001     aSymbolSetDisplay.SetTextColor( aTxtColor );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymbolDialog::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if ( rDCEvt.GetType() == DATACHANGED_SETTINGS  &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             InitColor_Impl();
//STRIP001
//STRIP001     ModalDialog::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 BOOL SmSymbolDialog::SelectSymbolSet(const XubString &rSymbolSetName)
//STRIP001 {
//STRIP001 	BOOL	bRet = FALSE;
//STRIP001 	USHORT 	nPos = aSymbolSets.GetEntryPos(rSymbolSetName);
//STRIP001
//STRIP001 	pSymSet = NULL;
//STRIP001 	if (nPos != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		aSymbolSets.SelectEntryPos(nPos);
//STRIP001 		USHORT nSymbolSetNo = rSymSetMgr.GetSymbolSetPos(aSymbolSets.GetSelectEntry());
//STRIP001 		pSymSet = rSymSetMgr.GetSymbolSet(nSymbolSetNo);
//STRIP001 		DBG_ASSERT(pSymSet, "Sm : NULL pointer");
//STRIP001
//STRIP001 		aSymbolSetDisplay.SetSymbolSet(*pSymSet);
//STRIP001 		if (pSymSet->GetCount() > 0)
//STRIP001 			SelectSymbol(0);
//STRIP001
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aSymbolSets.SetNoSelection();
//STRIP001
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymbolDialog::SelectSymbol(USHORT nSymbolNo)
//STRIP001 {
//STRIP001 	const SmSym *pSym = NULL;
//STRIP001 	if (pSymSet  &&  nSymbolNo < pSymSet->GetCount())
//STRIP001 		pSym = &pSymSet->GetSymbol(nSymbolNo);
//STRIP001
//STRIP001 	aSymbolSetDisplay.SelectSymbol(nSymbolNo);
//STRIP001 	aSymbolDisplay.SetSymbol(pSym);
//STRIP001 	aSymbolName.SetText(pSym ? pSym->GetName() : XubString());
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 const SmSym * SmSymbolDialog::GetSymbol() const
//STRIP001 {
//STRIP001 	USHORT nSymbolNo = aSymbolSetDisplay.GetSelectSymbol();
//STRIP001 	return pSymSet == NULL ? NULL : &pSymSet->GetSymbol(nSymbolNo);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 ////////////////////////////////////////////////////////////////////////////////
//STRIP001
//STRIP001
//STRIP001 void SmShowChar::Paint(const Rectangle &rRect)
//STRIP001 {
//STRIP001     Control::Paint( rRect );
//STRIP001
//STRIP001 	XubString Text (GetText ());
//STRIP001     if (Text.Len() > 0)
//STRIP001 	{
//STRIP001 		Size aTextSize(GetTextWidth(Text), GetTextHeight());
//STRIP001
//STRIP001 		DrawText(Point((GetOutputSize().Width()  - aTextSize.Width())  / 2,
//STRIP001 					   (GetOutputSize().Height() - aTextSize.Height()) / 2), Text);
//STRIP001 	}
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowChar::SetChar(xub_Unicode aChar)
//STRIP001 {
//STRIP001 	SetText(XubString(aChar));
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmShowChar::SetFont(const Font &rFont)
//STRIP001 {
//STRIP001     Color aTxtColor( GetTextColor() );
//STRIP001
//STRIP001 	Font  aFont (rFont);
//STRIP001 	Size  aSize (Size(0, GetOutputSize().Height() - GetOutputSize().Height() / 3));
//STRIP001
//STRIP001 	aFont.SetSize(aSize);
//STRIP001     aFont.SetAlign(ALIGN_TOP);
//STRIP001 	aFont.SetTransparent(TRUE);
//STRIP001 	Control::SetFont(aFont);
//STRIP001
//STRIP001     // keep text color (new font may have different one)
//STRIP001     SetTextColor( aTxtColor );
//STRIP001
//STRIP001 	Invalidate();
//STRIP001 }
//STRIP001
//STRIP001 ////////////////////////////////////////////////////////////////////////////////
//STRIP001
//STRIP001 void SmSymDefineDialog::FillSymbols(ComboBox &rComboBox, BOOL bDeleteText)
//STRIP001 {
//STRIP001 	DBG_ASSERT(&rComboBox == &aOldSymbols  ||  &rComboBox == &aSymbols,
//STRIP001 		"Sm : falsche ComboBox");
//STRIP001
//STRIP001 	rComboBox.Clear();
//STRIP001 	if (bDeleteText)
//STRIP001 		rComboBox.SetText(XubString());
//STRIP001
//STRIP001 	::com::boBox &rSymbolSets = &rComboBox == &aOldSymbols ?
//STRIP001 									aOldSymbolSets : aSymbolSets;
//STRIP001 	const SmSymSet *pSymSet = GetSymbolSet(rSymbolSets);
//STRIP001 	if (pSymSet)
//STRIP001 	{   USHORT nNumSymbols = pSymSet->GetCount();
//STRIP001 		for (USHORT i = 0;  i < nNumSymbols;  i++)
//STRIP001 			rComboBox.InsertEntry(pSymSet->GetSymbol(i).GetName());
//STRIP001 	}
//STRIP001
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::FillSymbolSets(ComboBox &rComboBox, BOOL bDeleteText)
//STRIP001 {
//STRIP001 	DBG_ASSERT(&rComboBox == &aOldSymbolSets  ||  &rComboBox == &aSymbolSets,
//STRIP001 		"Sm : falsche ComboBox");
//STRIP001
//STRIP001 	rComboBox.Clear();
//STRIP001 	if (bDeleteText)
//STRIP001 		rComboBox.SetText(XubString());
//STRIP001
//STRIP001     USHORT nNumSymSets = aSymSetMgrCopy.GetSymbolSetCount();
//STRIP001 	for (USHORT i = 0;  i < nNumSymSets;  i++)
//STRIP001 		rComboBox.InsertEntry(aSymSetMgrCopy.GetSymbolSet(i)->GetName());
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::FillFonts(BOOL bDelete)
//STRIP001 {
//STRIP001 	aFonts.Clear();
//STRIP001 	if (bDelete)
//STRIP001 		aFonts.SetNoSelection();
//STRIP001
//STRIP001 	// alle Fonts der 'FontList' in die Fontliste aufnehmen
//STRIP001 	// von denen mit gleichen Namen jedoch nur einen (denn der Style wird
//STRIP001  // ueber die 'FontStyleBox' gewaehlt und nicht auch noch hier)
//STRIP001 	DBG_ASSERT(pFontList, "Sm : NULL pointer");
//STRIP001 	USHORT	nCount = pFontList->GetFontNameCount();
//STRIP001 	for (USHORT i = 0;  i < nCount;  i++)
//STRIP001 		aFonts.InsertEntry( pFontList->GetFontName(i).GetName() );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::FillStyles(BOOL bDeleteText)
//STRIP001 {
//STRIP001 	aStyles.Clear();
//STRIP001 	if (bDeleteText)
//STRIP001 		aStyles.SetText(XubString());
//STRIP001
//STRIP001 	XubString aText (aFonts.GetSelectEntry());
//STRIP001 	if (aText.Len() != 0)
//STRIP001 	{
//STRIP001 		//aStyles.Fill(aText, &aFontList);
//STRIP001 		// eigene StyleName's verwenden
//STRIP001         const SmFontStyles &rStyles = GetFontStyles();
//STRIP001         for (USHORT i = 0;  i < rStyles.GetCount();  i++)
//STRIP001             aStyles.InsertEntry( rStyles.GetStyleName(i) );
//STRIP001
//STRIP001 		DBG_ASSERT(aStyles.GetEntryCount() > 0, "Sm : keine Styles vorhanden");
//STRIP001 		aStyles.SetText( aStyles.GetEntry(0) );
//STRIP001 	}
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmSymSet * SmSymDefineDialog::GetSymbolSet(const ComboBox &rComboBox)
//STRIP001 {
//STRIP001 	DBG_ASSERT(&rComboBox == &aOldSymbolSets  ||  &rComboBox == &aSymbolSets,
//STRIP001 		"Sm : falsche ComboBox");
//STRIP001
//STRIP001 	USHORT nSymbolSetNo = aSymSetMgrCopy.GetSymbolSetPos(rComboBox.GetText());
//STRIP001
//STRIP001 	return nSymbolSetNo == SYMBOLSET_NONE ?
//STRIP001 		NULL : aSymSetMgrCopy.GetSymbolSet(nSymbolSetNo);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmSym * SmSymDefineDialog::GetSymbol(const ComboBox &rComboBox)
//STRIP001 {
//STRIP001 	DBG_ASSERT(&rComboBox == &aOldSymbols  ||  &rComboBox == &aSymbols,
//STRIP001 		"Sm : falsche ComboBox");
//STRIP001
//STRIP001 	return aSymSetMgrCopy.GetSymbolByName(rComboBox.GetText());
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, OldSymbolChangeHdl, ComboBox *, pComboBox )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pComboBox == &aOldSymbols, "Sm : falsches Argument");
//STRIP001 	SelectSymbol(aOldSymbols, aOldSymbols.GetText(), FALSE);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, OldSymbolSetChangeHdl, ComboBox *, pComboBox )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pComboBox == &aOldSymbolSets, "Sm : falsches Argument");
//STRIP001 	SelectSymbolSet(aOldSymbolSets, aOldSymbolSets.GetText(), FALSE);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, ModifyHdl, ComboBox *, pComboBox )
//STRIP001 {
//STRIP001 	// merken der Cursorposition zum wiederherstellen derselben
//STRIP001 	Selection  aSelection (pComboBox->GetSelection());
//STRIP001
//STRIP001 	if (pComboBox == &aSymbols)
//STRIP001 		SelectSymbol(aSymbols, aSymbols.GetText(), FALSE);
//STRIP001 	else if (pComboBox == &aSymbolSets)
//STRIP001 		SelectSymbolSet(aSymbolSets, aSymbolSets.GetText(), FALSE);
//STRIP001 	else if (pComboBox == &aOldSymbols)
//STRIP001 		// nur Namen aus der Liste erlauben
//STRIP001 		SelectSymbol(aOldSymbols, aOldSymbols.GetText(), TRUE);
//STRIP001 	else if (pComboBox == &aOldSymbolSets)
//STRIP001 		// nur Namen aus der Liste erlauben
//STRIP001 		SelectSymbolSet(aOldSymbolSets, aOldSymbolSets.GetText(), TRUE);
//STRIP001 	else if (pComboBox == &aStyles)
//STRIP001 		// nur Namen aus der Liste erlauben (ist hier eh immer der Fall)
//STRIP001 		SelectStyle(aStyles.GetText(), TRUE);
//STRIP001 	else
//STRIP001 		DBG_ASSERT(0, "Sm : falsche ComboBox Argument");
//STRIP001
//STRIP001 	pComboBox->SetSelection(aSelection);
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, FontChangeHdl, ListBox *, pListBox )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pListBox == &aFonts, "Sm : falsches Argument");
//STRIP001
//STRIP001 	SelectFont(aFonts.GetSelectEntry());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, SubsetChangeHdl, ListBox *, pListBox )
//STRIP001 {
//STRIP001     USHORT nPos = aFontsSubsetLB.GetSelectEntryPos();
//STRIP001     if (LISTBOX_ENTRY_NOTFOUND != nPos)
//STRIP001     {
//STRIP001         const Subset* pSubset = reinterpret_cast<const Subset*> (aFontsSubsetLB.GetEntryData( nPos ));
//STRIP001         if (pSubset)
//STRIP001         {
//STRIP001             sal_Unicode cFirst = pSubset->GetRangeMin();
//STRIP001             aCharsetDisplay.SelectCharacter( cFirst );
//STRIP001         }
//STRIP001     }
//STRIP001     return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, StyleChangeHdl, ComboBox *, pComboBox )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pComboBox == &aStyles, "Sm : falsches Argument");
//STRIP001
//STRIP001 	SelectStyle(aStyles.GetText());
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, CharHighlightHdl, Control *, EMPTYARG )
//STRIP001 {
//STRIP001     sal_Unicode cChar = aCharsetDisplay.GetSelectCharacter();
//STRIP001
//STRIP001     DBG_ASSERT( pSubsetMap, "SubsetMap missing" )
//STRIP001     if (pSubsetMap)
//STRIP001     {
//STRIP001         const Subset* pSubset = pSubsetMap->GetSubsetByUnicode( cChar );
//STRIP001         if (pSubset)
//STRIP001             aFontsSubsetLB.SelectEntry( pSubset->GetName() );
//STRIP001         else
//STRIP001             aFontsSubsetLB.SetNoSelection();
//STRIP001     }
//STRIP001
//STRIP001     aSymbolDisplay.SetChar( cChar );
//STRIP001 	UpdateButtons();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, AddClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pButton == &aAddBtn, "Sm : falsches Argument");
//STRIP001  DBG_ASSERT(aAddBtn.IsEnabled(), "Sm : Voraussetzungen erfuellt ??");
//STRIP001
//STRIP001 	SmSymSet *pSymSet = GetSymbolSet(aSymbolSets);
//STRIP001
//STRIP001  // SymbolSet einfuegen falls es noch nicht existiert
//STRIP001 	if (!pSymSet)
//STRIP001 	{
//STRIP001 		pSymSet = new SmSymSet(aSymbolSets.GetText());
//STRIP001 		aSymSetMgrCopy.AddSymbolSet(pSymSet);
//STRIP001 		FillSymbolSets(aOldSymbolSets, FALSE);
//STRIP001 		FillSymbolSets(aSymbolSets,    FALSE);
//STRIP001 	}
//STRIP001 	DBG_ASSERT(pSymSet, "Sm : NULL pointer");
//STRIP001
//STRIP001  // Symbol ins SymbolSet einfuegen
//STRIP001 	SmSym *pSym = new SmSym(aSymbols.GetText(), aCharsetDisplay.GetFont(),
//STRIP001                             aCharsetDisplay.GetSelectCharacter(),
//STRIP001 							aSymbolSets.GetText());
//STRIP001 	pSymSet->AddSymbol(pSym);
//STRIP001
//STRIP001 	// update der Hash Tabelle erzwingen (damit aAddBtn disabled wird).
//STRIP001  // (wird spaeter nach Ueberarbeitung von symbol.cxx ueberfluessig werden).
//STRIP001 	aSymSetMgrCopy.ChangeSymbolSet((SmSymSet *)1);
//STRIP001
//STRIP001 	// Symbolliste aktualiseren
//STRIP001 	FillSymbols(aOldSymbols ,FALSE);
//STRIP001 	FillSymbols(aSymbols    ,FALSE);
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, ChangeClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pButton == &aChangeBtn, "Sm : falsches Argument");
//STRIP001  DBG_ASSERT(aChangeBtn.IsEnabled(), "Sm : Voraussetzungen erfuellt ??");
//STRIP001
//STRIP001 	// finden des SymbolSets zum alten Symbol
//STRIP001 	SmSymSet *pOldSymSet = GetSymbolSet(aOldSymbolSets);
//STRIP001 	DBG_ASSERT(pOldSymSet, "Sm : NULL pointer");
//STRIP001
//STRIP001 	// suchen des neuen SymbolSets
//STRIP001 	SmSymSet *pNewSymSet = GetSymbolSet(aSymbolSets);
//STRIP001  // SymbolSet einfuegen falls es noch nicht existiert
//STRIP001 	if (!pNewSymSet)
//STRIP001 	{
//STRIP001 		pNewSymSet = new SmSymSet(aSymbolSets.GetText());
//STRIP001 		aSymSetMgrCopy.AddSymbolSet(pNewSymSet);
//STRIP001 		FillSymbolSets(aOldSymbolSets, FALSE);
//STRIP001 		FillSymbolSets(aSymbolSets,    FALSE);
//STRIP001 	}
//STRIP001
//STRIP001 	// das (alte) Symbol besorgen
//STRIP001 	USHORT nSymbol = pOldSymSet->GetSymbolPos(aOldSymbols.GetText());
//STRIP001     DBG_ASSERT( SYMBOL_NONE != nSymbol, "symbol not found" );
//STRIP001 	SmSym *pSym    = (SmSym *) &pOldSymSet->GetSymbol(nSymbol);
//STRIP001 	DBG_ASSERT(pSym, "Sm : NULL pointer");
//STRIP001
//STRIP001     // apply changes
//STRIP001     pSym->SetName( aSymbols.GetText() );
//STRIP001     //! get font from symbol-display since charset-display does not keep
//STRIP001     //! the bold attribut.
//STRIP001     pSym->SetFace( aSymbolDisplay.GetFont() );
//STRIP001     pSym->SetCharacter( aCharsetDisplay.GetSelectCharacter() );
//STRIP001
//STRIP001  // das SymbolSet wechseln wenn noetig
//STRIP001 	if (pOldSymSet != pNewSymSet)
//STRIP001 	{
//STRIP001         pNewSymSet->AddSymbol( new SmSym( *pSym ) );
//STRIP001         pOldSymSet->DeleteSymbol(nSymbol);
//STRIP001
//STRIP001         //
//STRIP001         // update controls
//STRIP001         //
//STRIP001         // actualize symbol-lists in the dialog
//STRIP001         String  aOldSymbolName( pOrigSymbol->GetName() );
//STRIP001         aOldSymbols.SetText( String() );
//STRIP001         aOldSymbols.RemoveEntry( aOldSymbolName );
//STRIP001         if (aSymbolSets.GetText() == aOldSymbolSets.GetText())
//STRIP001             aSymbols.RemoveEntry( aOldSymbolName );
//STRIP001         // clear display for original symbol
//STRIP001         SetOrigSymbol(NULL, XubString());
//STRIP001     }
//STRIP001
//STRIP001 	//!! den SymbolSet Manger dazu zwingen seinen HashTable zu aktualisieren,
//STRIP001  //!! um mit moeglich neuen bzw fehlenden alten Symbol Namen konform zu sein.
//STRIP001 	aSymSetMgrCopy.ChangeSymbolSet((SmSymSet *)1);
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 IMPL_LINK( SmSymDefineDialog, DeleteClickHdl, Button *, pButton )
//STRIP001 {
//STRIP001 	DBG_ASSERT(pButton == &aDeleteBtn, "Sm : falsches Argument");
//STRIP001  DBG_ASSERT(aDeleteBtn.IsEnabled(), "Sm : Voraussetzungen erfuellt ??");
//STRIP001
//STRIP001 	if (pOrigSymbol)
//STRIP001 	{
//STRIP001      // loeschen des Symbols:
//STRIP001 		//
//STRIP001      // zugehoeriges SymbolSet finden
//STRIP001 		SmSymSet *pSymSet = GetSymbolSet(aOldSymbolSets);
//STRIP001 		DBG_ASSERT(pSymSet, "Sm : NULL pointer");
//STRIP001 		// finden des Index
//STRIP001 		XubString  aOldSymbolName (pOrigSymbol->GetName());
//STRIP001 		USHORT    nSymbolNo   = pSymSet->GetSymbolPos(aOldSymbolName);
//STRIP001 		DBG_ASSERT(nSymbolNo != SYMBOL_NONE, "Sm : kein Symbol");
//STRIP001      // Bezuege auf das Symbols loeschen
//STRIP001 		SetOrigSymbol(NULL, XubString());
//STRIP001 		// und weg mit dem Symbol
//STRIP001 		pSymSet->DeleteSymbol(nSymbolNo);
//STRIP001
//STRIP001 		//!! den SymbolSet Manger dazu zwingen seinen HashTable zu aktualisieren,
//STRIP001      //!! was er naemlich nicht tut, wenn in einem seiner SymbolSets geaendert/
//STRIP001      //!! geloescht wird, was wiederum zu einem Absturz fuehren kann (wenn er
//STRIP001      //!! ueber ein nicht mehr existentes aber nicht entferntes Symbol iteriert).
//STRIP001 		aSymSetMgrCopy.ChangeSymbolSet((SmSymSet *)1);
//STRIP001
//STRIP001      // aktualisieren der Symboleintraege des Dialogs
//STRIP001 		aOldSymbols.SetText(XubString());
//STRIP001 		aOldSymbols.RemoveEntry(aOldSymbolName);
//STRIP001 		if (aSymbolSets.GetText() == aOldSymbolSets.GetText())
//STRIP001 			aSymbols.RemoveEntry(aOldSymbolName);
//STRIP001 	}
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return 0;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::UpdateButtons()
//STRIP001 {
//STRIP001 	BOOL  bAdd    = FALSE,
//STRIP001 		  bChange = FALSE,
//STRIP001 		  bDelete = FALSE,
//STRIP001 		  bEqual;
//STRIP001 	XubString  aSymbolName    (aSymbols.GetText()),
//STRIP001 			  aSymbolSetName (aSymbolSets.GetText());
//STRIP001
//STRIP001 	if (aSymbolName.Len() > 0  &&  aSymbolSetName.Len() > 0)
//STRIP001 	{
//STRIP001 		// alle Einstellungen gleich?
//STRIP001 		//! (Font-, Style- und SymbolSet Name werden nicht case sensitiv verglichen)
//STRIP001 		bEqual = pOrigSymbol
//STRIP001 					&& aSymbolSetName.EqualsIgnoreCaseAscii(aOldSymbolSetName.GetText())
//STRIP001 					&& aSymbolName.Equals(pOrigSymbol->GetName())
//STRIP001                     && aFonts.GetSelectEntry().EqualsIgnoreCaseAscii(
//STRIP001                             pOrigSymbol->GetFace().GetName())
//STRIP001                     && aStyles.GetText().EqualsIgnoreCaseAscii(
//STRIP001                             GetFontStyles().GetStyleName(pOrigSymbol->GetFace()))
//STRIP001                     && aCharsetDisplay.GetSelectCharacter() == pOrigSymbol->GetCharacter();
//STRIP001
//STRIP001      // hinzufuegen nur wenn es noch kein Symbol desgleichen Namens gibt
//STRIP001 		bAdd    = aSymSetMgrCopy.GetSymbolByName(aSymbolName) == NULL;
//STRIP001
//STRIP001      // loeschen nur wenn alle Einstellungen gleich sind
//STRIP001 		bDelete = pOrigSymbol != NULL;
//STRIP001
//STRIP001      // aendern wenn bei gleichem Namen mindestens eine Einstellung anders ist
//STRIP001      // oder wenn es noch kein Symbol des neuen Namens gibt (wuerde implizites
//STRIP001      // loeschen des bereits vorhandenen Symbols erfordern)
//STRIP001 		BOOL  bEqualName = pOrigSymbol && aSymbolName == pOrigSymbol->GetName();
//STRIP001 		bChange = pOrigSymbol && (bEqualName && !bEqual || !bEqualName && bAdd);
//STRIP001 	}
//STRIP001
//STRIP001 	aAddBtn   .Enable(bAdd);
//STRIP001 	aChangeBtn.Enable(bChange);
//STRIP001 	aDeleteBtn.Enable(bDelete);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmSymDefineDialog::SmSymDefineDialog(Window * pParent, SmSymSetManager &rMgr, BOOL bFreeRes) :
//STRIP001 	ModalDialog			(pParent, SmResId(RID_SYMDEFINEDIALOG)),
//STRIP001 	aOldSymbolText     	(this, ResId(1)),
//STRIP001 	aOldSymbols	    	(this, ResId(1)),
//STRIP001 	aOldSymbolSetText  	(this, ResId(2)),
//STRIP001 	aOldSymbolSets     	(this, ResId(2)),
//STRIP001 	aCharsetDisplay 	(this, ResId(1)),
//STRIP001 	aSymbolText			(this, ResId(9)),
//STRIP001 	aSymbols            (this, ResId(4)),
//STRIP001 	aSymbolSetText      (this, ResId(10)),
//STRIP001 	aSymbolSets         (this, ResId(5)),
//STRIP001 	aFontText    		(this, ResId(3)),
//STRIP001 	aFonts		   		(this, ResId(1)),
//STRIP001     aFontsSubsetFT      (this, ResId( FT_FONTS_SUBSET )),
//STRIP001     aFontsSubsetLB      (this, ResId( LB_FONTS_SUBSET )),
//STRIP001 	aStyleText	    	(this, ResId(4)),
//STRIP001 	aStyles		    	(this, ResId(3)),
//STRIP001 	aOldSymbolName		(this, ResId(7)),
//STRIP001 	aOldSymbolDisplay	(this, ResId(3)),
//STRIP001 	aOldSymbolSetName	(this, ResId(8)),
//STRIP001 	aSymbolName			(this, ResId(5)),
//STRIP001 	aSymbolDisplay		(this, ResId(2)),
//STRIP001 	aSymbolSetName		(this, ResId(6)),
//STRIP001 	aAddBtn	   			(this, ResId(1)),
//STRIP001 	aChangeBtn  		(this, ResId(2)),
//STRIP001 	aDeleteBtn  		(this, ResId(3)),
//STRIP001 	aOkBtn	   			(this, ResId(1)),
//STRIP001 	aCancelBtn 			(this, ResId(1)),
//STRIP001 	aRightArrow			(this, ResId(1)),
//STRIP001 	pFontList			(NULL),
//STRIP001     pSubsetMap          (NULL),
//STRIP001 	rSymSetMgr			(rMgr)
//STRIP001 {
//STRIP001 	if (bFreeRes)
//STRIP001 		FreeResource();
//STRIP001
//STRIP001 	// get FontList from printer (if possible), otherwise from application window
//STRIP001 	SmViewShell *pView = SmGetActiveView();
//STRIP001 	DBG_ASSERT(pView, "Sm : NULL pointer");
//STRIP001 	OutputDevice *pDev = pView->GetDoc()->GetPrinter();
//STRIP001 	if (!pDev || pDev->GetDevFontCount() == 0)
//STRIP001 	    pDev = &pView->GetGraphicWindow();
//STRIP001 	pFontList = new FontList(pDev);
//STRIP001
//STRIP001
//STRIP001 	pOrigSymbol = 0;
//STRIP001
//STRIP001 	// make autocompletion for symbols case-sensitive
//STRIP001 	aOldSymbols.EnableAutocomplete(TRUE, TRUE);
//STRIP001 	aSymbols   .EnableAutocomplete(TRUE, TRUE);
//STRIP001
//STRIP001 	FillFonts();
//STRIP001 	if (aFonts.GetEntryCount() > 0)
//STRIP001 		SelectFont(aFonts.GetEntry(0));
//STRIP001
//STRIP001     InitColor_Impl();
//STRIP001
//STRIP001 	SetSymbolSetManager(rSymSetMgr);
//STRIP001
//STRIP001 	aOldSymbols	   .SetSelectHdl(LINK(this, SmSymDefineDialog, OldSymbolChangeHdl));
//STRIP001 	aOldSymbolSets .SetSelectHdl(LINK(this, SmSymDefineDialog, OldSymbolSetChangeHdl));
//STRIP001 	aSymbolSets    .SetModifyHdl(LINK(this, SmSymDefineDialog, ModifyHdl));
//STRIP001 	aOldSymbolSets .SetModifyHdl(LINK(this, SmSymDefineDialog, ModifyHdl));
//STRIP001 	aSymbols       .SetModifyHdl(LINK(this, SmSymDefineDialog, ModifyHdl));
//STRIP001 	aOldSymbols    .SetModifyHdl(LINK(this, SmSymDefineDialog, ModifyHdl));
//STRIP001 	aStyles		   .SetModifyHdl(LINK(this, SmSymDefineDialog, ModifyHdl));
//STRIP001 	aFonts         .SetSelectHdl(LINK(this, SmSymDefineDialog, FontChangeHdl));
//STRIP001     aFontsSubsetLB .SetSelectHdl(LINK(this, SmSymDefineDialog, SubsetChangeHdl));
//STRIP001 	aStyles        .SetSelectHdl(LINK(this, SmSymDefineDialog, StyleChangeHdl));
//STRIP001 	aAddBtn        .SetClickHdl (LINK(this, SmSymDefineDialog, AddClickHdl));
//STRIP001 	aChangeBtn     .SetClickHdl (LINK(this, SmSymDefineDialog, ChangeClickHdl));
//STRIP001 	aDeleteBtn     .SetClickHdl (LINK(this, SmSymDefineDialog, DeleteClickHdl));
//STRIP001     aCharsetDisplay.SetHighlightHdl( LINK( this, SmSymDefineDialog, CharHighlightHdl ) );
//STRIP001
//STRIP001     // preview like controls should have a 2D look
//STRIP001     aOldSymbolDisplay.SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001     aSymbolDisplay   .SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 SmSymDefineDialog::~SmSymDefineDialog()
//STRIP001 {
//STRIP001 	delete pFontList;
//STRIP001     delete pSubsetMap;
//STRIP001     delete pOrigSymbol;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::InitColor_Impl()
//STRIP001 {
//STRIP001 #if OSL_DEBUG_LEVEL > 1
//STRIP001     Color aBC( GetDisplayBackground().GetColor() );
//STRIP001 #endif
//STRIP001     ColorData   nBgCol  = COL_WHITE,
//STRIP001                 nTxtCol = COL_BLACK;
//STRIP001     if (GetDisplayBackground().GetColor().IsDark())
//STRIP001     {
//STRIP001         const StyleSettings &rS = GetSettings().GetStyleSettings();
//STRIP001         nBgCol  = rS.GetFieldColor().GetColor();
//STRIP001         nTxtCol = rS.GetFieldTextColor().GetColor();
//STRIP001     }
//STRIP001
//STRIP001     Color aTmpColor( nBgCol );
//STRIP001     Wallpaper aWall( aTmpColor );
//STRIP001     Color aTxtColor( nTxtCol );
//STRIP001     aCharsetDisplay  .SetBackground( aWall );
//STRIP001     aCharsetDisplay  .SetTextColor( aTxtColor );
//STRIP001     aOldSymbolDisplay.SetBackground( aWall );
//STRIP001     aOldSymbolDisplay.SetTextColor( aTxtColor );
//STRIP001     aSymbolDisplay   .SetBackground( aWall );
//STRIP001     aSymbolDisplay   .SetTextColor( aTxtColor );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001     if ( rDCEvt.GetType() == DATACHANGED_SETTINGS  &&
//STRIP001          (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001             InitColor_Impl();
//STRIP001
//STRIP001     ModalDialog::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 short SmSymDefineDialog::Execute()
//STRIP001 {
//STRIP001 	short nResult = ModalDialog::Execute();
//STRIP001
//STRIP001  // Aenderungen uebernehmen falls Dialog mit OK beendet wurde
//STRIP001 	if (aSymSetMgrCopy.IsModified()  &&  nResult == RET_OK)
//STRIP001 	{
//STRIP001 		// leere SymbolSets aus dem Ergebnis entfernen.
//STRIP001      // Dabei von hinten durch das array iterieren, da beim loeschen die
//STRIP001      // Elemente aufruecken.
//STRIP001         USHORT  nSymbolSets = aSymSetMgrCopy.GetSymbolSetCount();
//STRIP001 		for (int i = nSymbolSets - 1;  i >= 0;  i--)
//STRIP001 			if (aSymSetMgrCopy.GetSymbolSet(i)->GetCount() == 0)
//STRIP001 				aSymSetMgrCopy.DeleteSymbolSet(i);
//STRIP001
//STRIP001 		rSymSetMgr = aSymSetMgrCopy;
//STRIP001 	}
//STRIP001
//STRIP001 	return nResult;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::SetSymbolSetManager(const SmSymSetManager &rMgr)
//STRIP001 {
//STRIP001 	aSymSetMgrCopy = rMgr;
//STRIP001
//STRIP001  // Das modified Flag der Kopie auf FALSE setzen, damit man spaeter damit
//STRIP001  // testen kann ob sich was geaendert hat.
//STRIP001 	aSymSetMgrCopy.SetModified(FALSE);
//STRIP001
//STRIP001 	FillSymbolSets(aOldSymbolSets);
//STRIP001 	if (aOldSymbolSets.GetEntryCount() > 0)
//STRIP001 		SelectSymbolSet(aOldSymbolSets.GetEntry(0));
//STRIP001 	FillSymbolSets(aSymbolSets);
//STRIP001 	if (aSymbolSets.GetEntryCount() > 0)
//STRIP001 		SelectSymbolSet(aSymbolSets.GetEntry(0));
//STRIP001 	FillSymbols(aOldSymbols);
//STRIP001 	if (aOldSymbols.GetEntryCount() > 0)
//STRIP001 		SelectSymbol(aOldSymbols.GetEntry(0));
//STRIP001 	FillSymbols(aSymbols);
//STRIP001 	if (aSymbols.GetEntryCount() > 0)
//STRIP001 		SelectSymbol(aSymbols.GetEntry(0));
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 BOOL SmSymDefineDialog::SelectSymbolSet(ComboBox &rComboBox,
//STRIP001 		const XubString &rSymbolSetName, BOOL bDeleteText)
//STRIP001 {
//STRIP001 	DBG_ASSERT(&rComboBox == &aOldSymbolSets  ||  &rComboBox == &aSymbolSets,
//STRIP001 		"Sm : falsche ComboBox");
//STRIP001
//STRIP001 	// 'Normalisieren' des SymbolNamens (ohne leading und trailing Leerzeichen)
//STRIP001 	XubString  aNormName (rSymbolSetName);
//STRIP001 	aNormName.EraseLeadingChars(' ');
//STRIP001 	aNormName.EraseTrailingChars(' ');
//STRIP001 	// und evtl Abweichungen in der Eingabe beseitigen
//STRIP001 	rComboBox.SetText(aNormName);
//STRIP001
//STRIP001 	BOOL   bRet = FALSE;
//STRIP001 	USHORT nPos = rComboBox.GetEntryPos(aNormName);
//STRIP001
//STRIP001 	if (nPos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		rComboBox.SetText(rComboBox.GetEntry(nPos));
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else if (bDeleteText)
//STRIP001 		rComboBox.SetText(XubString());
//STRIP001
//STRIP001 	BOOL  bIsOld = &rComboBox == &aOldSymbolSets;
//STRIP001
//STRIP001  // setzen des SymbolSet Namens an der zugehoerigen Darstellung
//STRIP001 	FixedText &rFT = bIsOld ? aOldSymbolSetName : aSymbolSetName;
//STRIP001 	rFT.SetText(rComboBox.GetText());
//STRIP001
//STRIP001  // setzen der zum SymbolSet gehoerenden Symbol Namen an der zugehoerigen
//STRIP001 	// Auswahbox
//STRIP001 	::com::boBox  &rCB = bIsOld ? aOldSymbols : aSymbols;
//STRIP001 	FillSymbols(rCB, FALSE);
//STRIP001
//STRIP001  // bei Wechsel des SymbolSets fuer das alte Zeichen ein gueltiges
//STRIP001 	// Symbol bzw keins zur Anzeige bringen
//STRIP001 	if (bIsOld)
//STRIP001 	{
//STRIP001 		XubString  aOldSymbolName;
//STRIP001 		if (aOldSymbols.GetEntryCount() > 0)
//STRIP001 			aOldSymbolName = aOldSymbols.GetEntry(0);
//STRIP001 		SelectSymbol(aOldSymbols, aOldSymbolName, TRUE);
//STRIP001 	}
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::SetOrigSymbol(const SmSym *pSymbol,
//STRIP001 									  const XubString &rSymbolSetName)
//STRIP001 {
//STRIP001     // clear old symbol
//STRIP001     delete pOrigSymbol;
//STRIP001     pOrigSymbol = 0;
//STRIP001
//STRIP001     XubString   aSymName,
//STRIP001                 aSymSetName;
//STRIP001 	if (pSymbol)
//STRIP001 	{
//STRIP001         // set new symbol
//STRIP001         pOrigSymbol = new SmSym( *pSymbol );
//STRIP001
//STRIP001 		aSymName    = pSymbol->GetName();
//STRIP001 		aSymSetName = rSymbolSetName;
//STRIP001 		aOldSymbolDisplay.SetFont(pSymbol->GetFace());
//STRIP001 		aOldSymbolDisplay.SetChar(pSymbol->GetCharacter());
//STRIP001 	}
//STRIP001 	else
//STRIP001  {   // loeschen des angezeigten Symbols
//STRIP001 		aOldSymbolDisplay.SetText(XubString());
//STRIP001 		aOldSymbolDisplay.Invalidate();
//STRIP001 	}
//STRIP001 	aOldSymbolName   .SetText(aSymName);
//STRIP001 	aOldSymbolSetName.SetText(aSymSetName);
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 BOOL SmSymDefineDialog::SelectSymbol(ComboBox &rComboBox,
//STRIP001 		const XubString &rSymbolName, BOOL bDeleteText)
//STRIP001 {
//STRIP001 	DBG_ASSERT(&rComboBox == &aOldSymbols  ||  &rComboBox == &aSymbols,
//STRIP001 		"Sm : falsche ComboBox");
//STRIP001
//STRIP001 	// 'Normalisieren' des SymbolNamens (ohne Leerzeichen)
//STRIP001 	XubString  aNormName (rSymbolName);
//STRIP001 	aNormName.EraseAllChars(' ');
//STRIP001 	// und evtl Abweichungen in der Eingabe beseitigen
//STRIP001 	rComboBox.SetText(aNormName);
//STRIP001
//STRIP001 	BOOL   bRet = FALSE;
//STRIP001 	USHORT nPos = rComboBox.GetEntryPos(aNormName);
//STRIP001
//STRIP001 	BOOL  bIsOld = &rComboBox == &aOldSymbols;
//STRIP001
//STRIP001 	if (nPos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		rComboBox.SetText(rComboBox.GetEntry(nPos));
//STRIP001
//STRIP001 		if (!bIsOld)
//STRIP001 		{
//STRIP001 			const SmSym *pSymbol = GetSymbol(aSymbols);
//STRIP001 			if (pSymbol)
//STRIP001 			{
//STRIP001              // Font und Style entsprechend waehlen
//STRIP001 				const Font &rFont = pSymbol->GetFace();
//STRIP001 				SelectFont(rFont.GetName(), FALSE);
//STRIP001                 SelectStyle(GetFontStyles().GetStyleName(rFont), FALSE);
//STRIP001
//STRIP001              // da das setzen des Fonts ueber den Style Namen des SymbolsFonts nicht
//STRIP001 				// so gut klappt (er kann zB leer sein obwohl der Font selbst 'bold' und
//STRIP001              // 'italic' ist!). Setzen wir hier den Font wie er zum Symbol gehoert
//STRIP001 				// zu Fu?
//STRIP001 				aCharsetDisplay.SetFont(rFont);
//STRIP001 				aSymbolDisplay.SetFont(rFont);
//STRIP001
//STRIP001              // das zugehoerige Zeichen auswaehlen
//STRIP001 				SelectChar(pSymbol->GetCharacter());
//STRIP001 			}
//STRIP001 		}
//STRIP001
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else if (bDeleteText)
//STRIP001 		rComboBox.SetText(XubString());
//STRIP001
//STRIP001 	if (bIsOld)
//STRIP001 	{
//STRIP001 		// bei Wechsel des alten Symbols nur vorhandene anzeigen sonst keins
//STRIP001 		const SmSym *pOldSymbol = NULL;
//STRIP001 		XubString     aOldSymbolSetName;
//STRIP001 		if (nPos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 		{
//STRIP001 			pOldSymbol        = aSymSetMgrCopy.GetSymbolByName(aNormName);
//STRIP001 			aOldSymbolSetName = aOldSymbolSets.GetText();
//STRIP001 		}
//STRIP001 		SetOrigSymbol(pOldSymbol, aOldSymbolSetName);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aSymbolName.SetText(rComboBox.GetText());
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::SetFont(const XubString &rFontName, const XubString &rStyleName)
//STRIP001 {
//STRIP001 	// Font (FontInfo) passend zu Namen und Style holen
//STRIP001 	DBG_ASSERT(pFontList, "Sm : NULL pointer");
//STRIP001 	FontInfo  aFI( pFontList->Get(rFontName, WEIGHT_NORMAL, ITALIC_NONE) );
//STRIP001 	SetFontStyle(rStyleName, aFI);
//STRIP001
//STRIP001 	aCharsetDisplay.SetFont(aFI);
//STRIP001 	aSymbolDisplay.SetFont(aFI);
//STRIP001
//STRIP001     // update subset listbox for new font's unicode subsets
//STRIP001     FontCharMap aFontCharMap;
//STRIP001     aCharsetDisplay.GetFontCharMap( aFontCharMap );
//STRIP001     if (pSubsetMap)
//STRIP001         delete pSubsetMap;
//STRIP001     pSubsetMap = new SubsetMap( &aFontCharMap );
//STRIP001     //
//STRIP001     aFontsSubsetLB.Clear();
//STRIP001     bool bFirst = true;
//STRIP001     const Subset* pSubset;
//STRIP001     while( NULL != (pSubset = pSubsetMap->GetNextSubset( bFirst )) )
//STRIP001     {
//STRIP001         USHORT nPos = aFontsSubsetLB.InsertEntry( pSubset->GetName());
//STRIP001         aFontsSubsetLB.SetEntryData( nPos, (void *) pSubset );
//STRIP001         // subset must live at least as long as the selected font !!!
//STRIP001         if( bFirst )
//STRIP001 	    aFontsSubsetLB.SelectEntryPos( nPos );
//STRIP001         bFirst = false;
//STRIP001     }
//STRIP001     if( bFirst )
//STRIP001         aFontsSubsetLB.SetNoSelection();
//STRIP001     aFontsSubsetLB.Enable( !bFirst );
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 BOOL SmSymDefineDialog::SelectFont(const XubString &rFontName, BOOL bApplyFont)
//STRIP001 {
//STRIP001 	BOOL   bRet = FALSE;
//STRIP001 	USHORT nPos = aFonts.GetEntryPos(rFontName);
//STRIP001
//STRIP001 	if (nPos != LISTBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		aFonts.SelectEntryPos(nPos);
//STRIP001 		if (aStyles.GetEntryCount() > 0)
//STRIP001 			SelectStyle(aStyles.GetEntry(0));
//STRIP001 		if (bApplyFont)
//STRIP001 			SetFont(aFonts.GetSelectEntry(), aStyles.GetText());
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aFonts.SetNoSelection();
//STRIP001 	FillStyles();
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 BOOL SmSymDefineDialog::SelectStyle(const XubString &rStyleName, BOOL bApplyFont)
//STRIP001 {
//STRIP001 	BOOL   bRet = FALSE;
//STRIP001 	USHORT nPos = aStyles.GetEntryPos(rStyleName);
//STRIP001
//STRIP001  // falls der Style nicht zur Auswahl steht nehmen wir den erst moeglichen
//STRIP001 	// (sofern vorhanden)
//STRIP001 	if (nPos == COMBOBOX_ENTRY_NOTFOUND  &&  aStyles.GetEntryCount() > 0)
//STRIP001 		nPos = 0;
//STRIP001
//STRIP001 	if (nPos != COMBOBOX_ENTRY_NOTFOUND)
//STRIP001 	{
//STRIP001 		aStyles.SetText(aStyles.GetEntry(nPos));
//STRIP001 		if (bApplyFont)
//STRIP001 			SetFont(aFonts.GetSelectEntry(), aStyles.GetText());
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		aStyles.SetText(XubString());
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001
//STRIP001
//STRIP001 void SmSymDefineDialog::SelectChar(xub_Unicode cChar)
//STRIP001 {
//STRIP001     aCharsetDisplay.SelectCharacter( cChar );
//STRIP001     aSymbolDisplay.SetChar( cChar );
//STRIP001
//STRIP001 	UpdateButtons();
//STRIP001 }


/**************************************************************************/

}
