/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_connctrl.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:37:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#include "xoutx.hxx"

#include "svdoedge.hxx"
#include "svdattrx.hxx"

#ifndef _SVDMARK_HXX //autogen
#include "svdmark.hxx"
#endif
#ifndef _SVDVIEW_HXX //autogen
#include "svdview.hxx"
#endif

#include "svdpage.hxx" // SdrObjList

#include "connctrl.hxx"
#include "dialmgr.hxx"
#include "dlgutil.hxx"
namespace binfilter {

/*************************************************************************
|*
|* Ctor SvxXConnectionPreview
|*
*************************************************************************/

//STRIP001 SvxXConnectionPreview::SvxXConnectionPreview( Window* pParent, const ResId& rResId,
//STRIP001 							const SfxItemSet& rInAttrs ) :
//STRIP001 							Control	( pParent, rResId ),
//STRIP001 							pEdgeObj( NULL ),
//STRIP001 							pObjList( NULL ),
//STRIP001 							pView	( NULL ),
//STRIP001 							rAttrs	( rInAttrs )
//STRIP001 {
//STRIP001 	pExtOutDev = new ExtOutputDevice( this );
//STRIP001 
//STRIP001 	SetMapMode( MAP_100TH_MM );
//STRIP001 
//STRIP001 	SetStyles();
//STRIP001 }

/*************************************************************************
|*
|* Dtor SvxXConnectionPreview
|*
*************************************************************************/

//STRIP001 SvxXConnectionPreview::~SvxXConnectionPreview()
//STRIP001 {
//STRIP001 	delete pObjList;
//STRIP001 	delete pExtOutDev;
//STRIP001 }

/*************************************************************************
|*
|* Dtor SvxXConnectionPreview
|*
*************************************************************************/

//STRIP001 void SvxXConnectionPreview::Construct()
//STRIP001 {
//STRIP001 	DBG_ASSERT( pView, "Keine gueltige View Uebergeben!" );
//STRIP001 
//STRIP001 	const SdrMarkList& rMarkList = pView->GetMarkList();
//STRIP001 	ULONG nMarkCount = rMarkList.GetMarkCount();
//STRIP001 
//STRIP001 	if( nMarkCount >= 1 )
//STRIP001 	{
//STRIP001 		BOOL bFound = FALSE;
//STRIP001 		const SdrObject* pObj = rMarkList.GetMark(0)->GetObj();
//STRIP001 
//STRIP001 
//STRIP001 		for( USHORT i = 0; i < nMarkCount && !bFound; i++ )
//STRIP001 		{
//STRIP001 			pObj = rMarkList.GetMark( i )->GetObj();
//STRIP001 			UINT32 nInv = pObj->GetObjInventor();
//STRIP001 			UINT16 nId = pObj->GetObjIdentifier();
//STRIP001 			if( nInv == SdrInventor && nId == OBJ_EDGE )
//STRIP001 			{
//STRIP001 				bFound = TRUE;
//STRIP001 				SdrEdgeObj* pTmpEdgeObj = (SdrEdgeObj*) pObj;
//STRIP001 				pEdgeObj = (SdrEdgeObj*) pTmpEdgeObj->Clone();
//STRIP001 
//STRIP001 				SdrObjConnection& rConn1 = (SdrObjConnection&)pEdgeObj->GetConnection( TRUE );
//STRIP001 				SdrObjConnection& rConn2 = (SdrObjConnection&)pEdgeObj->GetConnection( FALSE );
//STRIP001 
//STRIP001 				rConn1 = pTmpEdgeObj->GetConnection( TRUE );
//STRIP001 				rConn2 = pTmpEdgeObj->GetConnection( FALSE );
//STRIP001 
//STRIP001 				SdrObject* pTmpObj1 = pTmpEdgeObj->GetConnectedNode( TRUE );
//STRIP001 				SdrObject* pTmpObj2 = pTmpEdgeObj->GetConnectedNode( FALSE );
//STRIP001 
//STRIP001 				pObjList = new SdrObjList( pView->GetModel(), NULL );
//STRIP001 				if( pTmpObj1 )
//STRIP001 				{
//STRIP001 					SdrObject* pObj1 = pTmpObj1->Clone();
//STRIP001 					pObjList->InsertObject( pObj1 );
//STRIP001 					pEdgeObj->ConnectToNode( TRUE, pObj1 );
//STRIP001 				}
//STRIP001 				if( pTmpObj2 )
//STRIP001 				{
//STRIP001 					SdrObject* pObj2 = pTmpObj2->Clone();
//STRIP001 					pObjList->InsertObject( pObj2 );
//STRIP001 					pEdgeObj->ConnectToNode( FALSE, pObj2 );
//STRIP001 				}
//STRIP001 				pObjList->InsertObject( pEdgeObj );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pEdgeObj )
//STRIP001 		pEdgeObj = new SdrEdgeObj();
//STRIP001 
//STRIP001 	// Groesse anpassen
//STRIP001 	if( pObjList )
//STRIP001 	{
//STRIP001 		OutputDevice* pOD = pView->GetWin( 0 );
//STRIP001 		Rectangle aRect = pObjList->GetAllObjBoundRect();
//STRIP001 
//STRIP001 		MapMode aMapMode = GetMapMode();
//STRIP001 		aMapMode.SetMapUnit( pOD->GetMapMode().GetMapUnit() );
//STRIP001 		SetMapMode( aMapMode );
//STRIP001 
//STRIP001 		MapMode			aDisplayMap( aMapMode );
//STRIP001 		Point			aNewPos;
//STRIP001 		Size			aNewSize;
//STRIP001 		const Size		aWinSize = PixelToLogic( GetOutputSizePixel(), aDisplayMap );
//STRIP001 		const long		nWidth = aWinSize.Width();
//STRIP001 		const long		nHeight = aWinSize.Height();
//STRIP001 		double          fRectWH = (double) aRect.GetWidth() / aRect.GetHeight();
//STRIP001 		double          fWinWH = (double) nWidth / nHeight;
//STRIP001 
//STRIP001 		// Bitmap an Thumbgroesse anpassen (hier nicht!)
//STRIP001 		if ( fRectWH < fWinWH)
//STRIP001 		{
//STRIP001 			aNewSize.Width() = (long) ( (double) nHeight * fRectWH );
//STRIP001 			aNewSize.Height()= nHeight;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNewSize.Width() = nWidth;
//STRIP001 			aNewSize.Height()= (long) ( (double) nWidth / fRectWH );
//STRIP001 		}
//STRIP001 
//STRIP001 		Fraction aFrac1( aWinSize.Width(), aRect.GetWidth() );
//STRIP001 		Fraction aFrac2( aWinSize.Height(), aRect.GetHeight() );
//STRIP001 		Fraction aMinFrac( aFrac1 <= aFrac2 ? aFrac1 : aFrac2 );
//STRIP001 
//STRIP001 		// MapMode umsetzen
//STRIP001 		aDisplayMap.SetScaleX( aMinFrac );
//STRIP001 		aDisplayMap.SetScaleY( aMinFrac );
//STRIP001 
//STRIP001 		// Zentrierung
//STRIP001 		aNewPos.X() = ( nWidth - aNewSize.Width() )  >> 1;
//STRIP001 		aNewPos.Y() = ( nHeight - aNewSize.Height() ) >> 1;
//STRIP001 
//STRIP001 		aDisplayMap.SetOrigin( LogicToLogic( aNewPos, aMapMode, aDisplayMap ) );
//STRIP001 		SetMapMode( aDisplayMap );
//STRIP001 
//STRIP001 		// Ursprung
//STRIP001 		aNewPos = aDisplayMap.GetOrigin();
//STRIP001 		aNewPos -= Point( aRect.TopLeft().X(), aRect.TopLeft().Y() );
//STRIP001 		aDisplayMap.SetOrigin( aNewPos );
//STRIP001 		SetMapMode( aDisplayMap );
//STRIP001 
//STRIP001 
//STRIP001 		Point aPos;
//STRIP001 		MouseEvent aMEvt( aPos, 1, 0, MOUSE_RIGHT );
//STRIP001 		MouseButtonDown( aMEvt );
//STRIP001 		/*
//STRIP001 		Point aPt( -aRect.TopLeft().X(), -aRect.TopLeft().Y() );
//STRIP001 		aMapMode.SetOrigin( aPt );
//STRIP001 
//STRIP001 		// Skalierung
//STRIP001 		Size aSize = GetOutputSize();
//STRIP001 		Fraction aFrac1( aSize.Width(), aRect.GetWidth() );
//STRIP001 		Fraction aFrac2( aSize.Height(), aRect.GetHeight() );
//STRIP001 		Fraction aMaxFrac( aFrac1 > aFrac2 ? aFrac1 : aFrac2 );
//STRIP001 		Fraction aMinFrac( aFrac1 <= aFrac2 ? aFrac1 : aFrac2 );
//STRIP001 		BOOL bChange = (BOOL) ( (double)aMinFrac > 1.0 );
//STRIP001 		aMapMode.SetScaleX( aMinFrac );
//STRIP001 		aMapMode.SetScaleY( aMinFrac );
//STRIP001 
//STRIP001 		// zentrieren
//STRIP001 		long nXXL = aSize.Width() > aRect.GetWidth() ? aSize.Width() : aRect.GetWidth();
//STRIP001 		long nXS = aSize.Width() <= aRect.GetWidth() ? aSize.Width() : aRect.GetWidth();
//STRIP001 		if( bChange )
//STRIP001 		{
//STRIP001 			long nTmp = nXXL; nXXL = nXS; nXS = nTmp;
//STRIP001 		}
//STRIP001 		long nX = (long) ( (double)aMinFrac * (double)nXXL );
//STRIP001 		nX = (long) ( (double)labs( nXS - nX ) / (double)aMinFrac / 2.0 );
//STRIP001 
//STRIP001 		long nYXL = aSize.Height() > aRect.GetHeight() ? aSize.Height() : aRect.GetHeight();
//STRIP001 		long nYS = aSize.Height() <= aRect.GetHeight() ? aSize.Height() : aRect.GetHeight();
//STRIP001 		if( bChange )
//STRIP001 		{
//STRIP001 			long nTmp = nXXL; nXXL = nXS; nXS = nTmp;
//STRIP001 		}
//STRIP001 		long nY = (long) ( (double)aMinFrac * (double)nYXL );
//STRIP001 		nY = (long) ( (double)labs( nYS - nY ) / (double)aMinFrac / 2.0 );
//STRIP001 
//STRIP001 		aPt += Point( nX, nY );
//STRIP001 		aMapMode.SetOrigin( aPt );
//STRIP001 
//STRIP001 		SetMapMode( aMapMode );
//STRIP001 		*/
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|* SvxXConnectionPreview: Paint()
|*
*************************************************************************/

//STRIP001 void SvxXConnectionPreview::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	SdrPaintInfoRec aInfoRec;
//STRIP001 
//STRIP001 	//pEdgeObj->Paint( *pExtOutDev, aInfoRec );
//STRIP001 	if( pObjList )
//STRIP001 		pObjList->Paint( *pExtOutDev, aInfoRec );
//STRIP001 }

/*************************************************************************
|*
|* SvxXConnectionPreview: SetAttributes()
|*
*************************************************************************/

//STRIP001 void SvxXConnectionPreview::SetAttributes( const SfxItemSet& rInAttrs )
//STRIP001 {
//STRIP001 //-/	pEdgeObj->SetAttributes( rInAttrs, FALSE );
//STRIP001 //-/	SdrBroadcastItemChange aItemChange(*pEdgeObj);
//STRIP001 	pEdgeObj->SetItemSetAndBroadcast(rInAttrs);
//STRIP001 //-/	pEdgeObj->BroadcastItemChange(aItemChange);
//STRIP001 
//STRIP001 	Invalidate();
//STRIP001 }

/*************************************************************************
|*
|* Ermittelt die Anzahl der Linienversaetze anhand des Preview-Objektes
|*
*************************************************************************/

//STRIP001 USHORT SvxXConnectionPreview::GetLineDeltaAnz()
//STRIP001 {
//STRIP001 //-/	USHORT nCount = 0;
//STRIP001 //-/	SfxItemSet aSet( rAttrs );
//STRIP001 //-/
//STRIP001 //-/	pEdgeObj->TakeAttributes( aSet, FALSE, FALSE );
//STRIP001 //-/
//STRIP001 //-/	if( aSet.GetItemState( SDRATTR_EDGELINEDELTAANZ ) != SFX_ITEM_DONTCARE )
//STRIP001 //-/	{
//STRIP001 //-/		nCount = ( ( const SdrEdgeLineDeltaAnzItem& ) aSet.
//STRIP001 //-/					Get( SDRATTR_EDGELINEDELTAANZ ) ).GetValue();
//STRIP001 //-/	}
//STRIP001 //-/	return( nCount );
//STRIP001 	const SfxItemSet& rSet = pEdgeObj->GetItemSet();
//STRIP001 	sal_uInt16 nCount(0);
//STRIP001 
//STRIP001 	if(SFX_ITEM_DONTCARE != rSet.GetItemState(SDRATTR_EDGELINEDELTAANZ))
//STRIP001 		nCount = ((const SdrEdgeLineDeltaAnzItem&)rSet.Get(SDRATTR_EDGELINEDELTAANZ)).GetValue();
//STRIP001 
//STRIP001 	return nCount;
//STRIP001 }

/*************************************************************************
|*
|* SvxXConnectionPreview: MouseButtonDown()
|*
*************************************************************************/

//STRIP001 void SvxXConnectionPreview::MouseButtonDown( const MouseEvent& rMEvt )
//STRIP001 {
//STRIP001 	BOOL bZoomIn  = rMEvt.IsLeft() && !rMEvt.IsShift();
//STRIP001 	BOOL bZoomOut = rMEvt.IsRight() || rMEvt.IsShift();
//STRIP001 	BOOL bCtrl	  = rMEvt.IsMod1();
//STRIP001 
//STRIP001 	if( bZoomIn || bZoomOut )
//STRIP001 	{
//STRIP001 		MapMode aMapMode = GetMapMode();
//STRIP001 		Fraction aXFrac = aMapMode.GetScaleX();
//STRIP001 		Fraction aYFrac = aMapMode.GetScaleY();
//STRIP001 		Fraction* pMultFrac;
//STRIP001 
//STRIP001 		if( bZoomIn )
//STRIP001 		{
//STRIP001 			if( bCtrl )
//STRIP001 				pMultFrac = new Fraction( 3, 2 );
//STRIP001 			else
//STRIP001 				pMultFrac = new Fraction( 11, 10 );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if( bCtrl )
//STRIP001 				pMultFrac = new Fraction( 2, 3 );
//STRIP001 			else
//STRIP001 				pMultFrac = new Fraction( 10, 11 );
//STRIP001 		}
//STRIP001 
//STRIP001 		aXFrac *= *pMultFrac;
//STRIP001 		aYFrac *= *pMultFrac;
//STRIP001 		if( (double)aXFrac > 0.001 && (double)aXFrac < 1000.0 &&
//STRIP001 			(double)aYFrac > 0.001 && (double)aYFrac < 1000.0 )
//STRIP001 		{
//STRIP001 			aMapMode.SetScaleX( aXFrac );
//STRIP001 			aMapMode.SetScaleY( aYFrac );
//STRIP001 			SetMapMode( aMapMode );
//STRIP001 
//STRIP001 			Size aOutSize( GetOutputSize() );
//STRIP001 
//STRIP001 			Point aPt( aMapMode.GetOrigin() );
//STRIP001 			long nX = (long)( ( (double)aOutSize.Width() - ( (double)aOutSize.Width() * (double)*pMultFrac  ) ) / 2.0 + 0.5 );
//STRIP001 			long nY = (long)( ( (double)aOutSize.Height() - ( (double)aOutSize.Height() * (double)*pMultFrac  ) ) / 2.0 + 0.5 );
//STRIP001 			aPt.X() +=  nX;
//STRIP001 			aPt.Y() +=  nY;
//STRIP001 
//STRIP001 			aMapMode.SetOrigin( aPt );
//STRIP001 			SetMapMode( aMapMode );
//STRIP001 
//STRIP001 			Invalidate();
//STRIP001 		}
//STRIP001 		delete pMultFrac;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SvxXConnectionPreview::SetStyles()
//STRIP001 {
//STRIP001 	const StyleSettings& rStyles = Application::GetSettings().GetStyleSettings();
//STRIP001 	SetDrawMode( GetDisplayBackground().GetColor().IsDark() ? OUTPUT_DRAWMODE_CONTRAST : OUTPUT_DRAWMODE_COLOR );
//STRIP001 	SetBackground( Wallpaper( Color( rStyles.GetFieldColor() ) ) );
//STRIP001 }

//STRIP001 void SvxXConnectionPreview::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	Control::DataChanged( rDCEvt );
//STRIP001 
//STRIP001 	if ( (rDCEvt.GetType() == DATACHANGED_SETTINGS) && (rDCEvt.GetFlags() & SETTINGS_STYLE) )
//STRIP001 	{
//STRIP001 		SetStyles();
//STRIP001 	}
//STRIP001 }

}
