/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_imapwnd.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:52:11 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _URLOBJ_HXX //autogen
#include <tools/urlobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX
#include <vcl/msgbox.hxx>
#endif
#ifndef _SV_HELP_HXX //autogen
#include <vcl/help.hxx>
#endif
#pragma hdrstop

#ifndef _SFXSIDS_HRC
#include <bf_sfx2/sfxsids.hrc>		// SID_ATTR_MACROITEM
#endif
#define _ANIMATION
#define ITEMID_MACRO SID_ATTR_MACROITEM
#ifndef _MACROPG_HXX //autogen
#include <bf_sfx2/macropg.hxx>
#endif
#ifndef _GOODIES_IMAPRECT_HXX //autogen
#include <svtools/imaprect.hxx>
#endif
#ifndef _GOODIES_IMAPCIRC_HXX //autogen
#include <svtools/imapcirc.hxx>
#endif
#ifndef _GOODIES_IMAPPOLY_HXX //autogen
#include <svtools/imappoly.hxx>
#endif
#ifndef _URLBMK_HXX //autogen
#include <svtools/urlbmk.hxx>
#endif

#include <xoutbmp.hxx>
#include <dialmgr.hxx>
#include <dialogs.hrc>
#include <svxids.hrc>
#include <imapdlg.hrc>
#include <imapwnd.hxx>
#include "svdpage.hxx"
#include "svdorect.hxx"
#include "svdocirc.hxx"
#include "svdopath.hxx"
#include "xfltrit.hxx"
#include "svdpagv.hxx"

#ifndef SVTOOLS_URIHELPER_HXX
#include <svtools/urihelper.hxx>
#endif
#ifndef _SVX_FILLITEM_HXX //autogen
#include <xfillit.hxx>
#endif
#ifndef _SVX_XLINIIT_HXX //autogen
#include <xlineit.hxx>
#endif

#include <sot/formats.hxx>
#include "so3/staticbaseurl.hxx"
namespace binfilter {

/*N*/ #ifdef MAC
/*N*/ #define TRANSCOL Color( COL_LIGHTGRAY )
/*N*/ #else
/*N*/ #define TRANSCOL Color( COL_WHITE )
/*N*/ #endif

/*************************************************************************
|*
|*	URLDlg
|*
\************************************************************************/

//STRIP001 URLDlg::URLDlg( Window* pWindow, const String& rURL,
//STRIP001 				const String& rDescription, const String& rTarget,
//STRIP001 				const String& rName, TargetList& rTargetList ) :
//STRIP001 
//STRIP001 	ModalDialog			( pWindow, SVX_RES( RID_SVXDLG_IMAPURL ) ),
//STRIP001 
//STRIP001     aFlURL              ( this, ResId( FL_URL ) ),
//STRIP001 	aBtnOk				( this, ResId( BTN_OK ) ),
//STRIP001 	aBtnCancel			( this, ResId( BTN_CANCEL ) ),
//STRIP001 	aFtURL1				( this, ResId( FT_URL1 ) ),
//STRIP001 	aEdtURL				( this, ResId( EDT_URL ) ),
//STRIP001 	aFtURLDescription	( this, ResId( FT_URLDESCRIPTION ) ),
//STRIP001 	aEdtURLDescription	( this, ResId( EDT_URLDESCRIPTION ) ),
//STRIP001 	aFtTarget			( this, ResId( FT_TARGET ) ),
//STRIP001 	aCbbTargets			( this, ResId( CBB_TARGETS ) ),
//STRIP001 	aFtName				( this, ResId( FT_NAME ) ),
//STRIP001 	aEdtName			( this, ResId( EDT_NAME ) )
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aEdtURL.SetText( rURL );
//STRIP001 	aEdtURLDescription.SetText( rDescription );
//STRIP001 	aEdtName.SetText( rName );
//STRIP001 
//STRIP001 	for( String* pStr = rTargetList.First(); pStr; pStr = rTargetList.Next() )
//STRIP001 		aCbbTargets.InsertEntry( *pStr );
//STRIP001 
//STRIP001 	if( !rTarget.Len() )
//STRIP001 		aCbbTargets.SetText( String::CreateFromAscii( "_self" ) );
//STRIP001 	else
//STRIP001 		aCbbTargets.SetText( rTarget );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMapWindow::IMapWindow( Window* pParent, const ResId& rResId ) :
//STRIP001 			GraphCtrl( pParent, rResId ),
//STRIP001 			DropTargetHelper( this )
//STRIP001 {
//STRIP001 	SetWinStyle( WB_SDRMODE );
//STRIP001 
//STRIP001 	pItemInfo = new SfxItemInfo[ 1 ];
//STRIP001 	memset( pItemInfo, 0, sizeof( SfxItemInfo ) );
//STRIP001 	pIMapPool = new SfxItemPool( String::CreateFromAscii( "IMapItemPool" ),
//STRIP001 								 SID_ATTR_MACROITEM, SID_ATTR_MACROITEM, pItemInfo );
//STRIP001 	pIMapPool->FreezeIdRanges();
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMapWindow::~IMapWindow()
//STRIP001 {
//STRIP001 	// Liste loeschen
//STRIP001 	for( String* pStr = aTargetList.First(); pStr; pStr = aTargetList.Next() )
//STRIP001 		delete pStr;
//STRIP001 
//STRIP001 	delete pIMapPool;
//STRIP001 	delete[] pItemInfo;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::SetImageMap( const ImageMap& rImageMap )
//STRIP001 {
//STRIP001 	ReplaceImageMap( rImageMap, FALSE );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::ReplaceImageMap( const ImageMap& rImageMap, BOOL bScaleToGraphic )
//STRIP001 {
//STRIP001 	SdrPage*	pPage = (SdrPage*) pModel->GetPage( 0 );
//STRIP001 	long		nCount = rImageMap.GetIMapObjectCount();
//STRIP001 
//STRIP001 	// zuerst alle Zeichenobjekte loeschen
//STRIP001 	aIMap = rImageMap;
//STRIP001 	pPage->Clear();
//STRIP001 
//STRIP001 	// neue Zeichenobjekte generieren
//STRIP001 	for ( long i = nCount - 1; i > -1; i-- )
//STRIP001 	{
//STRIP001 		SdrObject* pNewObj = CreateObj( rImageMap.GetIMapObject( (USHORT) i ) );
//STRIP001 
//STRIP001 		if ( pNewObj )
//STRIP001 			pPage->InsertObject( pNewObj );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 BOOL IMapWindow::ReplaceActualIMapInfo( const NotifyInfo& rNewInfo )
//STRIP001 {
//STRIP001 	const SdrObject*	pSdrObj = GetSelectedSdrObject();
//STRIP001 	IMapObject*			pIMapObj;
//STRIP001 	BOOL				bRet = FALSE;
//STRIP001 
//STRIP001 	if ( pSdrObj && ( ( pIMapObj = GetIMapObj( pSdrObj ) ) != NULL ) )
//STRIP001 	{
//STRIP001 		pIMapObj->SetURL( rNewInfo.aMarkURL );
//STRIP001 		pIMapObj->SetDescription( rNewInfo.aMarkDescription );
//STRIP001 		pIMapObj->SetTarget( rNewInfo.aMarkTarget );
//STRIP001 		pModel->SetChanged( TRUE );
//STRIP001 		UpdateInfo( FALSE );
//STRIP001 
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 const ImageMap& IMapWindow::GetImageMap()
//STRIP001 {
//STRIP001 	if ( pModel->IsChanged() )
//STRIP001 	{
//STRIP001 		SdrPage* pPage = (SdrPage*) pModel->GetPage( 0 );
//STRIP001 
//STRIP001 		if ( pPage )
//STRIP001 		{
//STRIP001 			const long nCount = pPage->GetObjCount();
//STRIP001 
//STRIP001 			aIMap.ClearImageMap();
//STRIP001 
//STRIP001 			for ( long i = nCount - 1; i > -1; i-- )
//STRIP001 				aIMap.InsertIMapObject( *( ( (IMapUserData*) pPage->GetObj( i )->GetUserData( 0 ) )->GetObject() ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		pModel->SetChanged( FALSE );
//STRIP001 	}
//STRIP001 
//STRIP001 	return aIMap;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::SetTargetList( TargetList& rTargetList )
//STRIP001 {
//STRIP001 	String* pStr;
//STRIP001 
//STRIP001 	// alte Liste loeschen
//STRIP001 	for( pStr = aTargetList.First(); pStr; pStr = aTargetList.Next() )
//STRIP001 		delete pStr;
//STRIP001 
//STRIP001 	aTargetList.Clear();
//STRIP001 
//STRIP001 	// mit uebergebener Liste fuellen
//STRIP001 	for( pStr = rTargetList.First(); pStr; pStr = rTargetList.Next() )
//STRIP001 		aTargetList.Insert( new String( *pStr ) );
//STRIP001 
//STRIP001 	pModel->SetChanged( FALSE );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SdrObject* IMapWindow::CreateObj( const IMapObject* pIMapObj )
//STRIP001 {
//STRIP001 	Point 		aPoint;
//STRIP001 	Rectangle 	aClipRect( aPoint, GetGraphicSize() );
//STRIP001 	SdrObject*	pSdrObj = NULL;
//STRIP001 	IMapObject*	pCloneIMapObj;
//STRIP001 
//STRIP001 	switch( pIMapObj->GetType() )
//STRIP001 	{
//STRIP001 		case( IMAP_OBJ_RECTANGLE ):
//STRIP001 		{
//STRIP001 			IMapRectangleObject*	pIMapRectObj = (IMapRectangleObject*) pIMapObj;
//STRIP001 			Rectangle				aDrawRect( pIMapRectObj->GetRectangle( FALSE ) );
//STRIP001 
//STRIP001 			// auf Zeichenflaeche clippen
//STRIP001 			aDrawRect.Intersection( aClipRect );
//STRIP001 
//STRIP001 			pSdrObj = (SdrObject*) new SdrRectObj( aDrawRect );
//STRIP001 			pCloneIMapObj = (IMapObject*) new IMapRectangleObject( *pIMapRectObj );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( IMAP_OBJ_CIRCLE ):
//STRIP001 		{
//STRIP001 			IMapCircleObject*	pIMapCircleObj = (IMapCircleObject*) pIMapObj;
//STRIP001 			const Point			aCenter( pIMapCircleObj->GetCenter( FALSE ) );
//STRIP001 			const long			nRadius = pIMapCircleObj->GetRadius( FALSE );
//STRIP001 			const Point			aOffset( nRadius, nRadius );
//STRIP001 			Rectangle			aCircle( aCenter - aOffset, aCenter + aOffset );
//STRIP001 
//STRIP001 			// auf Zeichenflaeche begrenzen
//STRIP001 			aCircle.Intersection( aClipRect );
//STRIP001 
//STRIP001 			pSdrObj = (SdrObject*) new SdrCircObj( OBJ_CIRC, aCircle, 0, 36000 );
//STRIP001 			pCloneIMapObj = (IMapObject*) new IMapCircleObject( *pIMapCircleObj );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( IMAP_OBJ_POLYGON ):
//STRIP001 		{
//STRIP001 			IMapPolygonObject*	pIMapPolyObj = (IMapPolygonObject*) pIMapObj;
//STRIP001 
//STRIP001 			// Falls wir eigentlich eine Ellipse sind,
//STRIP001 			// erzeugen wir auch wieder eine Ellipse
//STRIP001 			if ( pIMapPolyObj->HasExtraEllipse() )
//STRIP001 			{
//STRIP001 				Rectangle aDrawRect( pIMapPolyObj->GetExtraEllipse() );
//STRIP001 
//STRIP001 				// auf Zeichenflaeche clippen
//STRIP001 				aDrawRect.Intersection( aClipRect );
//STRIP001 
//STRIP001 				pSdrObj = (SdrObject*) new SdrCircObj( OBJ_CIRC, aDrawRect, 0, 36000 );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				const Polygon& 	rPoly = pIMapPolyObj->GetPolygon( FALSE );
//STRIP001 				USHORT			nCount = rPoly.GetSize();
//STRIP001 				Polygon			aDrawPoly( rPoly );
//STRIP001 
//STRIP001 				// auf Zeichenflaeche clippen
//STRIP001 				aDrawPoly.Clip( aClipRect );
//STRIP001 
//STRIP001 				pSdrObj = (SdrObject*) new SdrPathObj( OBJ_POLY, XPolyPolygon( XPolygon( aDrawPoly ) ) );
//STRIP001 			}
//STRIP001 
//STRIP001 			pCloneIMapObj = (IMapObject*) new IMapPolygonObject( *pIMapPolyObj );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pSdrObj )
//STRIP001 	{
//STRIP001 		SfxItemSet aSet( pModel->GetItemPool() );
//STRIP001 
//STRIP001 		aSet.Put( XFillStyleItem( XFILL_SOLID ) );
//STRIP001 		aSet.Put( XFillColorItem( String(), TRANSCOL ) );
//STRIP001 
//STRIP001 		if ( !pIMapObj->IsActive() )
//STRIP001 		{
//STRIP001 			aSet.Put( XFillTransparenceItem( 100 ) );
//STRIP001 			aSet.Put( XLineColorItem( String(), Color( COL_RED ) ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aSet.Put( XFillTransparenceItem( 50 ) );
//STRIP001 			aSet.Put( XLineColorItem( String(), Color( COL_BLACK ) ) );
//STRIP001 		}
//STRIP001 
//STRIP001 //-/		pSdrObj->SetAttributes( aSet, FALSE );
//STRIP001 //-/		SdrBroadcastItemChange aItemChange(*pSdrObj);
//STRIP001 		pSdrObj->SetItemSetAndBroadcast(aSet);
//STRIP001 //-/		pSdrObj->BroadcastItemChange(aItemChange);
//STRIP001 
//STRIP001 		pSdrObj->InsertUserData( new IMapUserData( pCloneIMapObj ) );
//STRIP001 		pSdrObj->SetUserCall( GetSdrUserCall() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSdrObj;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::InitSdrModel()
//STRIP001 {
//STRIP001 	GraphCtrl::InitSdrModel();
//STRIP001 
//STRIP001 	SfxItemSet aSet( pModel->GetItemPool() );
//STRIP001 
//STRIP001 	aSet.Put( XFillColorItem( String(), TRANSCOL ) );
//STRIP001 	aSet.Put( XFillTransparenceItem( 50 ) );
//STRIP001 	pView->SetAttributes( aSet );
//STRIP001 	pView->SetFrameDragSingles( TRUE );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::SdrObjCreated( const SdrObject& rObj )
//STRIP001 {
//STRIP001 	switch( rObj.GetObjIdentifier() )
//STRIP001 	{
//STRIP001 		case( OBJ_RECT ):
//STRIP001 		{
//STRIP001 			SdrRectObj*			 pRectObj = (SdrRectObj*) &rObj;
//STRIP001 			IMapRectangleObject* pObj = new IMapRectangleObject( pRectObj->GetLogicRect(),
//STRIP001 																 String(), String(), TRUE, FALSE );
//STRIP001 
//STRIP001 			pRectObj->InsertUserData( new IMapUserData( pObj ) );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( OBJ_CIRC ):
//STRIP001 		{
//STRIP001 			IMapPolygonObject*	pObj;
//STRIP001 			SdrCircObj*			pCircObj = (SdrCircObj*) &rObj;
//STRIP001 			SdrPathObj*			pPathObj = (SdrPathObj*) pCircObj->ConvertToPolyObj( FALSE, FALSE );
//STRIP001 			const XPolygon&		rXPoly = pPathObj->GetPathPoly().GetObject( 0 );
//STRIP001 			USHORT				nCount = rXPoly.GetPointCount();
//STRIP001 			Polygon				aPoly( nCount );
//STRIP001 
//STRIP001 			for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 				aPoly[ i ] = rXPoly[ i ];
//STRIP001 
//STRIP001 			// wurde von uns nur temporaer angelegt
//STRIP001 			delete pPathObj;
//STRIP001 
//STRIP001 			pObj = new IMapPolygonObject( aPoly, String(), String(), TRUE, FALSE );
//STRIP001 			pObj->SetExtraEllipse( aPoly.GetBoundRect() );
//STRIP001 			pCircObj->InsertUserData( new IMapUserData( pObj ) );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case( OBJ_POLY ):
//STRIP001 		case( OBJ_FREEFILL ):
//STRIP001 		case( OBJ_PATHPOLY ):
//STRIP001 		case( OBJ_PATHFILL ):
//STRIP001 		{
//STRIP001 			IMapPolygonObject*	pObj;
//STRIP001 			SdrPathObj*			pPathObj = (SdrPathObj*) &rObj;
//STRIP001 			const XPolyPolygon&	rXPolyPoly = pPathObj->GetPathPoly();
//STRIP001 
//STRIP001 			if ( rXPolyPoly.Count() )
//STRIP001 			{
//STRIP001 				const XPolygon&		rXPoly = rXPolyPoly.GetObject( 0 );
//STRIP001 				USHORT				nCount = rXPoly.GetPointCount();
//STRIP001 				Polygon				aPoly( nCount );
//STRIP001 
//STRIP001 				for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 					aPoly[ i ] = rXPoly[ i ];
//STRIP001 
//STRIP001 				IMapPolygonObject aPolyObj( aPoly, String(), String(), TRUE, FALSE );
//STRIP001 
//STRIP001 				pObj = new IMapPolygonObject( aPoly, String(), String(), TRUE, FALSE );
//STRIP001 				pPathObj->InsertUserData( new IMapUserData( pObj ) );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::SdrObjChanged( const SdrObject& rObj )
//STRIP001 {
//STRIP001 	IMapUserData* pUserData = (IMapUserData*) rObj.GetUserData( 0 );
//STRIP001 
//STRIP001 	if ( pUserData )
//STRIP001 	{
//STRIP001 		String			aURL;
//STRIP001 		String			aText;
//STRIP001 		String			aTarget;
//STRIP001 		IMapObject*		pIMapObj = pUserData->GetObject();
//STRIP001 		BOOL			bActive = TRUE;
//STRIP001 
//STRIP001 		if ( pIMapObj )
//STRIP001 		{
//STRIP001 			aURL = pIMapObj->GetURL();
//STRIP001 			aText = pIMapObj->GetDescription();
//STRIP001 			aTarget = pIMapObj->GetTarget();
//STRIP001 			bActive = pIMapObj->IsActive();
//STRIP001 		}
//STRIP001 
//STRIP001 		switch( rObj.GetObjIdentifier() )
//STRIP001 		{
//STRIP001 			case( OBJ_RECT ):
//STRIP001 			{
//STRIP001 				pUserData->ReplaceObject( new IMapRectangleObject( ( (const SdrRectObj&) rObj ).GetLogicRect(),
//STRIP001 										  aURL, aText, aTarget, bActive, FALSE ) );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( OBJ_CIRC ):
//STRIP001 			{
//STRIP001 				const SdrCircObj&	rCircObj = (const SdrCircObj&) rObj;
//STRIP001 				SdrPathObj*			pPathObj = (SdrPathObj*) rCircObj.ConvertToPolyObj( FALSE, FALSE );
//STRIP001 				const XPolygon&		rXPoly = pPathObj->GetPathPoly().GetObject( 0 );
//STRIP001 				USHORT				nCount = rXPoly.GetPointCount();
//STRIP001 				Polygon				aPoly( nCount );
//STRIP001 
//STRIP001 				for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 					aPoly[ i ] = rXPoly[ i ];
//STRIP001 
//STRIP001 				IMapPolygonObject* pObj = new IMapPolygonObject( aPoly, aURL, aText, aTarget, bActive, FALSE );
//STRIP001 				pObj->SetExtraEllipse( aPoly.GetBoundRect() );
//STRIP001 
//STRIP001 				// wurde von uns nur temporaer angelegt
//STRIP001 				delete pPathObj;
//STRIP001 				pUserData->ReplaceObject( pObj );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( OBJ_POLY ):
//STRIP001 			case( OBJ_FREEFILL ):
//STRIP001 			case( OBJ_PATHPOLY ):
//STRIP001 			case( OBJ_PATHFILL ):
//STRIP001 			{
//STRIP001 				const SdrPathObj&	rPathObj = (const SdrPathObj&) rObj;
//STRIP001 				const XPolyPolygon&	rXPolyPoly = rPathObj.GetPathPoly();
//STRIP001 
//STRIP001 				if ( rXPolyPoly.Count() )
//STRIP001 				{
//STRIP001 					const XPolygon&		rXPoly = rPathObj.GetPathPoly().GetObject( 0 );
//STRIP001 					USHORT				nCount = rXPoly.GetPointCount();
//STRIP001 					Polygon				aPoly( nCount );
//STRIP001 
//STRIP001 					for ( USHORT i = 0; i < nCount; i++ )
//STRIP001 						aPoly[ i ] = rXPoly[ i ];
//STRIP001 
//STRIP001 					IMapPolygonObject*	pObj = new IMapPolygonObject( aPoly, aURL, aText, aTarget, bActive, FALSE );
//STRIP001 					pUserData->ReplaceObject( pObj );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::MouseButtonUp(const MouseEvent& rMEvt)
//STRIP001 {
//STRIP001 	GraphCtrl::MouseButtonUp( rMEvt );
//STRIP001 	UpdateInfo( TRUE );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::MarkListHasChanged()
//STRIP001 {
//STRIP001 	GraphCtrl::MarkListHasChanged();
//STRIP001 	UpdateInfo( FALSE );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SdrObject* IMapWindow::GetHitSdrObj( const Point& rPosPixel ) const
//STRIP001 {
//STRIP001 	SdrObject*	pObj = NULL;
//STRIP001 	Point		aPt = PixelToLogic( rPosPixel );
//STRIP001 
//STRIP001 	if ( Rectangle( Point(), GetGraphicSize() ).IsInside( aPt ) )
//STRIP001 	{
//STRIP001 		SdrPage* pPage = (SdrPage*) pModel->GetPage( 0 );
//STRIP001 		ULONG	 nCount;
//STRIP001 
//STRIP001 		if ( pPage && ( ( nCount = pPage->GetObjCount() ) > 0 ) )
//STRIP001 		{
//STRIP001 			for ( long i = nCount - 1; i >= 0; i-- )
//STRIP001 			{
//STRIP001 				SdrObject*	pTestObj = pPage->GetObj( i );
//STRIP001 				IMapObject*	pIMapObj = GetIMapObj( pTestObj );
//STRIP001 
//STRIP001 				if ( pIMapObj && pIMapObj->IsHit( aPt ) )
//STRIP001 				{
//STRIP001 					pObj = pTestObj;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pObj;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMapObject* IMapWindow::GetIMapObj( const SdrObject* pSdrObj ) const
//STRIP001 {
//STRIP001 	IMapObject*	pIMapObj = NULL;
//STRIP001 
//STRIP001 	if ( pSdrObj )
//STRIP001 	{
//STRIP001 		IMapUserData* pUserData = (IMapUserData*) pSdrObj->GetUserData( 0 );
//STRIP001 
//STRIP001 		if ( pUserData )
//STRIP001 			pIMapObj = pUserData->GetObject();
//STRIP001 	}
//STRIP001 
//STRIP001 	return pIMapObj;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 SdrObject* IMapWindow::GetSdrObj( const IMapObject* pIMapObj ) const
//STRIP001 {
//STRIP001 	SdrObject*	pSdrObj = NULL;
//STRIP001 	SdrPage*	pPage = (SdrPage*) pModel->GetPage( 0 );
//STRIP001 	ULONG		nCount;
//STRIP001 
//STRIP001 	if ( pPage && ( ( nCount = pPage->GetObjCount() ) > 0 ) )
//STRIP001 	{
//STRIP001 		for ( ULONG i = 0; i < nCount; i++ )
//STRIP001 		{
//STRIP001 			SdrObject* pTestObj = pPage->GetObj( i );
//STRIP001 
//STRIP001 			if ( pIMapObj == GetIMapObj( pTestObj ) )
//STRIP001 			{
//STRIP001 				pSdrObj = pTestObj;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return pSdrObj;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::Command(const CommandEvent& rCEvt)
//STRIP001 {
//STRIP001 	Region  aRegion;
//STRIP001 	USHORT  nSelId = 0;
//STRIP001 
//STRIP001 	if ( rCEvt.GetCommand() == COMMAND_CONTEXTMENU )
//STRIP001 	{
//STRIP001 		PopupMenu			aMenu( SVX_RES( RID_SVXMN_IMAP ) );
//STRIP001 		const SdrMarkList&	rMarkList = pView->GetMarkList();
//STRIP001 		ULONG				nMarked = rMarkList.GetMarkCount();
//STRIP001 
//STRIP001 		aMenu.EnableItem( MN_URL, FALSE );
//STRIP001 		aMenu.EnableItem( MN_ACTIVATE, FALSE );
//STRIP001 		aMenu.EnableItem( MN_MACRO, FALSE );
//STRIP001 		aMenu.EnableItem( MN_MARK_ALL, pModel->GetPage( 0 )->GetObjCount() != pView->GetMarkedObjCount() );
//STRIP001 
//STRIP001 		if ( !nMarked )
//STRIP001 		{
//STRIP001 			aMenu.EnableItem( MN_POSITION, FALSE );
//STRIP001 			aMenu.EnableItem( MN_FRAME_TO_TOP, FALSE );
//STRIP001 			aMenu.EnableItem( MN_MOREFRONT, FALSE );
//STRIP001 			aMenu.EnableItem( MN_MOREBACK, FALSE );
//STRIP001 			aMenu.EnableItem( MN_FRAME_TO_BOTTOM, FALSE );
//STRIP001 			aMenu.EnableItem( MN_DELETE, FALSE );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( nMarked == 1 )
//STRIP001 			{
//STRIP001 				SdrObject*	pSdrObj = GetSelectedSdrObject();
//STRIP001 
//STRIP001 				aMenu.EnableItem( MN_URL, TRUE );
//STRIP001 				aMenu.EnableItem( MN_ACTIVATE, TRUE );
//STRIP001 				aMenu.EnableItem( MN_MACRO, TRUE );
//STRIP001 				aMenu.CheckItem( MN_ACTIVATE, GetIMapObj( pSdrObj )->IsActive() );
//STRIP001 			}
//STRIP001 
//STRIP001 			aMenu.EnableItem( MN_POSITION, TRUE );
//STRIP001 			aMenu.EnableItem( MN_FRAME_TO_TOP, TRUE );
//STRIP001 			aMenu.EnableItem( MN_MOREFRONT, TRUE );
//STRIP001 			aMenu.EnableItem( MN_MOREBACK, TRUE );
//STRIP001 			aMenu.EnableItem( MN_FRAME_TO_BOTTOM, TRUE );
//STRIP001 			aMenu.EnableItem( MN_DELETE, TRUE );
//STRIP001 		}
//STRIP001 
//STRIP001 		aMenu.SetSelectHdl( LINK( this, IMapWindow, MenuSelectHdl ) );
//STRIP001 		aMenu.Execute( this, rCEvt.GetMousePosPixel() );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		Window::Command(rCEvt);
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 sal_Int8 IMapWindow::AcceptDrop( const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	return( ( GetHitSdrObj( rEvt.maPosPixel ) != NULL ) ? rEvt.mnAction : DND_ACTION_NONE );
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 sal_Int8 IMapWindow::ExecuteDrop( const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( IsDropFormatSupported( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK ) )
//STRIP001 	{
//STRIP001 		const String	aString;
//STRIP001 		INetBookmark	aBookMark( aString, aString );
//STRIP001 		SdrObject*		pSdrObj = GetHitSdrObj( rEvt.maPosPixel );
//STRIP001 
//STRIP001 		if( pSdrObj && TransferableDataHelper( rEvt.maDropEvent.Transferable ).GetINetBookmark( SOT_FORMATSTR_ID_NETSCAPE_BOOKMARK, aBookMark ) )
//STRIP001 		{
//STRIP001 			IMapObject* pIMapObj = GetIMapObj( pSdrObj );
//STRIP001 
//STRIP001 			pIMapObj->SetURL( aBookMark.GetURL() );
//STRIP001 			pIMapObj->SetDescription( aBookMark.GetDescription() );
//STRIP001 			pModel->SetChanged( TRUE );
//STRIP001 			pView->UnmarkAll();
//STRIP001 			pView->MarkObj( pSdrObj, pView->GetPageViewPvNum( 0 ) );
//STRIP001 			UpdateInfo( TRUE );
//STRIP001 			nRet =  rEvt.mnAction;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::RequestHelp( const HelpEvent& rHEvt )
//STRIP001 {
//STRIP001 	SdrObject*			pSdrObj = NULL;
//STRIP001 	SdrPageView*		pPageView = NULL;
//STRIP001 	Point				aPos = PixelToLogic( ScreenToOutputPixel( rHEvt.GetMousePosPixel() ) );
//STRIP001 
//STRIP001 	if ( Help::IsBalloonHelpEnabled() || Help::IsQuickHelpEnabled() )
//STRIP001 	{
//STRIP001 		if ( pView->PickObj( aPos, pSdrObj, pPageView ) )
//STRIP001 		{
//STRIP001 			const IMapObject*	pIMapObj = GetIMapObj( pSdrObj );
//STRIP001 			String				aStr;
//STRIP001 
//STRIP001 			if ( pIMapObj && ( aStr = pIMapObj->GetURL() ).Len() )
//STRIP001 			{
//STRIP001 				String		aDescr( pIMapObj->GetDescription() );
//STRIP001 				Rectangle	aLogicPix( LogicToPixel( Rectangle( Point(), GetGraphicSize() ) ) );
//STRIP001 				Rectangle	aScreenRect( OutputToScreenPixel( aLogicPix.TopLeft() ),
//STRIP001 										 OutputToScreenPixel( aLogicPix.BottomRight() ) );
//STRIP001 
//STRIP001 				if ( Help::IsBalloonHelpEnabled() )
//STRIP001 					Help::ShowBalloon( this, rHEvt.GetMousePosPixel(), aScreenRect, aStr );
//STRIP001 				else if ( Help::IsQuickHelpEnabled() )
//STRIP001 					Help::ShowQuickHelp( this, aScreenRect, aStr );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			Window::RequestHelp( rHEvt );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::SetCurrentObjState( BOOL bActive )
//STRIP001 {
//STRIP001 	SdrObject* pObj = GetSelectedSdrObject();
//STRIP001 
//STRIP001 	if ( pObj )
//STRIP001 	{
//STRIP001 		SfxItemSet aSet( pModel->GetItemPool() );
//STRIP001 
//STRIP001 		GetIMapObj( pObj )->SetActive( bActive );
//STRIP001 
//STRIP001 		aSet.Put( XFillColorItem( String(), TRANSCOL ) );
//STRIP001 
//STRIP001 		if ( !bActive )
//STRIP001 		{
//STRIP001 			aSet.Put( XFillTransparenceItem( 100 ) );
//STRIP001 			aSet.Put( XLineColorItem( String(), Color( COL_RED ) ) );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aSet.Put( XFillTransparenceItem( 50 ) );
//STRIP001 			aSet.Put( XLineColorItem( String(), Color( COL_BLACK ) ) );
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->SetAttributes( aSet, FALSE );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::UpdateInfo( BOOL bNewObj )
//STRIP001 {
//STRIP001 	if ( aInfoLink.IsSet() )
//STRIP001 	{
//STRIP001 		const SdrObject*	pSdrObj = GetSelectedSdrObject();
//STRIP001 		const IMapObject*	pIMapObj = pSdrObj ? GetIMapObj( pSdrObj ) : NULL;
//STRIP001 
//STRIP001 		aInfo.bNewObj = bNewObj;
//STRIP001 
//STRIP001 		if ( pIMapObj )
//STRIP001 		{
//STRIP001 			aInfo.bOneMarked = TRUE;
//STRIP001 			aInfo.aMarkURL = pIMapObj->GetURL();
//STRIP001 			aInfo.aMarkDescription = pIMapObj->GetDescription();
//STRIP001 			aInfo.aMarkTarget = pIMapObj->GetTarget();
//STRIP001 			aInfo.bActivated = pIMapObj->IsActive();
//STRIP001 			aInfoLink.Call( this );
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aInfo.aMarkURL = aInfo.aMarkDescription = aInfo.aMarkTarget = String();
//STRIP001 			aInfo.bOneMarked = FALSE;
//STRIP001 			aInfo.bActivated = FALSE;
//STRIP001 		}
//STRIP001 
//STRIP001 		aInfoLink.Call( this );
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::DoMacroAssign()
//STRIP001 {
//STRIP001 	SdrObject*	pSdrObj = GetSelectedSdrObject();
//STRIP001 
//STRIP001 	if ( pSdrObj )
//STRIP001 	{
//STRIP001 		SfxItemSet		aSet( *pIMapPool, SID_ATTR_MACROITEM, SID_ATTR_MACROITEM );
//STRIP001 		SvxMacroItem	aMacroItem;
//STRIP001 		IMapObject*		pIMapObj = GetIMapObj( pSdrObj );
//STRIP001 
//STRIP001 		aMacroItem.SetMacroTable( pIMapObj->GetMacroTable() );
//STRIP001 		aSet.Put( aMacroItem, SID_ATTR_MACROITEM );
//STRIP001 
//STRIP001 		SfxMacroAssignDlg	aMacroDlg( this, aSet );
//STRIP001 		SfxMacroTabPage*	pMacroTabPage = (SfxMacroTabPage*) aMacroDlg.GetTabPage();
//STRIP001 
//STRIP001 		if ( pMacroTabPage )
//STRIP001 		{
//STRIP001 			pMacroTabPage->AddEvent( String::CreateFromAscii( "MouseOver" ), SFX_EVENT_MOUSEOVER_OBJECT );
//STRIP001 			pMacroTabPage->AddEvent( String::CreateFromAscii( "MouseOut" ), SFX_EVENT_MOUSEOUT_OBJECT );
//STRIP001 
//STRIP001 			if ( aMacroDlg.Execute() == RET_OK )
//STRIP001 			{
//STRIP001 				const SfxItemSet* pOutSet = aMacroDlg.GetOutputItemSet();
//STRIP001 				pIMapObj->SetMacroTable( ((const SvxMacroItem& )pOutSet->Get( SID_ATTR_MACROITEM )).GetMacroTable() );
//STRIP001         		pModel->SetChanged( TRUE );
//STRIP001 		        UpdateInfo( FALSE );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 void IMapWindow::DoPropertyDialog()
//STRIP001 {
//STRIP001 	SdrObject*	pSdrObj = GetSelectedSdrObject();
//STRIP001 
//STRIP001 	if ( pSdrObj )
//STRIP001 	{
//STRIP001 		IMapObject* pIMapObj = GetIMapObj( pSdrObj );
//STRIP001 		URLDlg		aDlg( this, pIMapObj->GetURL(), pIMapObj->GetDescription(),
//STRIP001 						  pIMapObj->GetTarget(), pIMapObj->GetName(), aTargetList );
//STRIP001 
//STRIP001 		if ( aDlg.Execute() == RET_OK )
//STRIP001 		{
//STRIP001 			const String aURLText( aDlg.GetURL() );
//STRIP001 
//STRIP001 			if ( aURLText.Len() )
//STRIP001 			{
//STRIP001 				pIMapObj->SetURL( so3::StaticBaseUrl::SmartRelToAbs( aURLText, FALSE,
//STRIP001 															  INetURLObject::WAS_ENCODED,
//STRIP001 															  INetURLObject::DECODE_UNAMBIGUOUS ) );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				pIMapObj->SetURL( aURLText );
//STRIP001 
//STRIP001 			pIMapObj->SetDescription( aDlg.GetDescription() );
//STRIP001 			pIMapObj->SetTarget( aDlg.GetTarget() );
//STRIP001 			pIMapObj->SetName( aDlg.GetName() );
//STRIP001 			pModel->SetChanged( TRUE );
//STRIP001 			UpdateInfo( TRUE );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*************************************************************************
|*
|*
|*
\************************************************************************/

//STRIP001 IMPL_LINK( IMapWindow, MenuSelectHdl, Menu*, pMenu )
//STRIP001 {
//STRIP001 	if (pMenu)
//STRIP001 	{
//STRIP001 		USHORT  nId = pMenu->GetCurItemId();
//STRIP001 
//STRIP001 		switch(nId)
//STRIP001 		{
//STRIP001 			case( MN_URL ):
//STRIP001 				DoPropertyDialog();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_MACRO ):
//STRIP001 				DoMacroAssign();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_ACTIVATE ):
//STRIP001 			{
//STRIP001 				const BOOL bNewState = !pMenu->IsItemChecked( MN_ACTIVATE );
//STRIP001 
//STRIP001 				pMenu->CheckItem( MN_ACTIVATE, bNewState );
//STRIP001 				SetCurrentObjState( bNewState );
//STRIP001 				UpdateInfo( FALSE );
//STRIP001 			}
//STRIP001 
//STRIP001 			case( MN_FRAME_TO_TOP ):
//STRIP001 				pView->PutMarkedToTop();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_MOREFRONT ):
//STRIP001 				pView->MovMarkedToTop();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_MOREBACK ):
//STRIP001 				pView->MovMarkedToBtm();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_FRAME_TO_BOTTOM ):
//STRIP001 				pView->PutMarkedToBtm();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_MARK_ALL ):
//STRIP001 				pView->MarkAll();
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_DELETE ):
//STRIP001 				pView->DeleteMarked();
//STRIP001 
//STRIP001 			default :
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//STRIP001 void IMapWindow::CreateDefaultObject()
//STRIP001 {
//STRIP001 	SdrPageView* pPageView = pView->GetPageViewPvNum(0);
//STRIP001 
//STRIP001 	if(pPageView)
//STRIP001 	{
//STRIP001 		// calc position and size
//STRIP001 		Point aPagePos = pPageView->GetOffset();
//STRIP001 		Size aPageSize = pPageView->GetPage()->GetSize();
//STRIP001 		sal_uInt32 nDefaultObjectSizeWidth = aPageSize.Width() / 4;
//STRIP001 		sal_uInt32 nDefaultObjectSizeHeight = aPageSize.Height() / 4;
//STRIP001 		aPagePos.X() += (aPageSize.Width() / 2) - (nDefaultObjectSizeWidth / 2);
//STRIP001 		aPagePos.Y() += (aPageSize.Height() / 2) - (nDefaultObjectSizeHeight / 2);
//STRIP001 		Rectangle aNewObjectRectangle(aPagePos, Size(nDefaultObjectSizeWidth, nDefaultObjectSizeHeight));
//STRIP001 
//STRIP001 		SdrObject* pObj = SdrObjFactory::MakeNewObject(	pView->GetCurrentObjInventor(), pView->GetCurrentObjIdentifier(), 0L, pModel);
//STRIP001 		pObj->SetLogicRect(aNewObjectRectangle);
//STRIP001 
//STRIP001 		switch( pObj->GetObjIdentifier() )
//STRIP001 		{
//STRIP001 		case OBJ_POLY:
//STRIP001 		case OBJ_PATHPOLY:
//STRIP001 			{
//STRIP001 				XPolyPolygon aPoly;
//STRIP001 
//STRIP001 				XPolygon aInnerPoly;
//STRIP001 				aInnerPoly[0] = aNewObjectRectangle.BottomLeft();
//STRIP001 				aInnerPoly[1] = aNewObjectRectangle.TopLeft();
//STRIP001 				aInnerPoly[2] = aNewObjectRectangle.TopCenter();
//STRIP001 				aInnerPoly[3] = aNewObjectRectangle.Center();
//STRIP001 				aInnerPoly[4] = aNewObjectRectangle.RightCenter();
//STRIP001 				aInnerPoly[5] = aNewObjectRectangle.BottomRight();
//STRIP001 
//STRIP001 				aPoly.Insert(aInnerPoly);
//STRIP001 				((SdrPathObj*)pObj)->SetPathPoly(aPoly);
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		case OBJ_FREEFILL:
//STRIP001 		case OBJ_PATHFILL:
//STRIP001 			{
//STRIP001 				XPolyPolygon aPoly;
//STRIP001 
//STRIP001 				sal_Int32 nWdt(aNewObjectRectangle.GetWidth() / 2);
//STRIP001 				sal_Int32 nHgt(aNewObjectRectangle.GetHeight() / 2);
//STRIP001 				
//STRIP001 				XPolygon aInnerPoly(aNewObjectRectangle.Center(), nWdt, nHgt);
//STRIP001 
//STRIP001 				aPoly.Insert(aInnerPoly);
//STRIP001 				((SdrPathObj*)pObj)->SetPathPoly(aPoly);
//STRIP001 				break;
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 
//STRIP001 		pView->InsertObject(pObj, *pPageView, 0);
//STRIP001 		SdrObjCreated( *pObj );
//STRIP001 		SetCurrentObjState( true );
//STRIP001 		pView->MarkObj( pObj, pPageView );
//STRIP001 	}
//STRIP001 }

//STRIP001 void IMapWindow::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001 	KeyCode aCode = rKEvt.GetKeyCode();
//STRIP001 
//STRIP001 /*
//STRIP001 	switch(aCode.GetCode())
//STRIP001 	{
//STRIP001 		case KEY_ESCAPE:
//STRIP001 		{
//STRIP001 			if ( pView->IsAction() )
//STRIP001 			{
//STRIP001 				pView->BrkAction();
//STRIP001 				return;
//STRIP001 			}
//STRIP001 			else if ( pView->HasMarkedObj() )
//STRIP001 			{
//STRIP001 				const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 				SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 				if(pHdl)
//STRIP001 				{
//STRIP001 					((SdrHdlList&)rHdlList).ResetFocusHdl();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					pView->UnmarkAllObj();
//STRIP001 					((Dialog*)GetParent())->GrabFocusToFirstControl();
//STRIP001 				}
//STRIP001 
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	}
//STRIP001 */
//STRIP001 	GraphCtrl::KeyInput( rKEvt );	
//STRIP001 }

//STRIP001 void IMapWindow::SelectFirstObject()
//STRIP001 {
//STRIP001 	SdrPage*	pPage = (SdrPage*) pModel->GetPage( 0 );
//STRIP001 	if( pPage->GetObjCount() != 0 )
//STRIP001 	{
//STRIP001 		GrabFocus();
//STRIP001 		pView->UnmarkAllObj();
//STRIP001 		pView->MarkNextObj(TRUE);
//STRIP001 	}
//STRIP001 }

//STRIP001 void IMapWindow::StartPolyEdit()
//STRIP001 {
//STRIP001 	GrabFocus();
//STRIP001 
//STRIP001 	if( !pView->HasMarkedObj() )
//STRIP001 		pView->MarkNextObj(TRUE);
//STRIP001 
//STRIP001 	const SdrHdlList& rHdlList = pView->GetHdlList();
//STRIP001 	SdrHdl* pHdl = rHdlList.GetFocusHdl();
//STRIP001 
//STRIP001 	if(!pHdl)	
//STRIP001 	{
//STRIP001 		((SdrHdlList&)rHdlList).TravelFocusHdl(true);
//STRIP001 	}
//STRIP001 }
} //namespace binfilter
