/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_paraprev.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 04:59:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

#pragma hdrstop

#include "paraprev.hxx"
namespace binfilter {

// STATIC DATA -----------------------------------------------------------

//STRIP001 #define FOUR_POINTS	80

// class SvxParaPrevWindow -----------------------------------------------

//STRIP001 SvxParaPrevWindow::SvxParaPrevWindow( Window* pParent, const ResId& rId ) :
//STRIP001 
//STRIP001 	Window( pParent, rId ),
//STRIP001 
//STRIP001 	nFirstLineOfst	( 0 ),
//STRIP001 	nLeftMargin		( 0 ),
//STRIP001 	nRightMargin	( 0 ),
//STRIP001 	nUpper			( 0 ),
//STRIP001 	nLower			( 0 ),
//STRIP001 	eAdjust			( SVX_ADJUST_LEFT ),
//STRIP001 #if  SUPD>352
//STRIP001 	eLastLine       ( SVX_ADJUST_LEFT ),
//STRIP001 #endif
//STRIP001 	eLine			( SVX_PREV_LINESPACE_1 ),
//STRIP001 	nLineVal		( 0 )
//STRIP001 
//STRIP001 {
//STRIP001 	// defaultmaessing in Twips rechnen
//STRIP001 	SetMapMode( MapMode( MAP_TWIP ) );
//STRIP001 	aWinSize = GetOutputSizePixel();
//STRIP001 	aWinSize = PixelToLogic( aWinSize );
//STRIP001     Size aTmp(1, 1);
//STRIP001     aTmp = PixelToLogic(aTmp);
//STRIP001     aWinSize.Width() -= aTmp.Width() /2;
//STRIP001     aWinSize.Height() -= aTmp.Height() /2;
//STRIP001 
//STRIP001 	aSize = Size( 11905, 16837 );
//STRIP001 
//STRIP001     SetBorderStyle( WINDOW_BORDER_MONO );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 void SvxParaPrevWindow::Paint( const Rectangle& rRect )
//STRIP001 {
//STRIP001 	DrawParagraph( TRUE );
//STRIP001 }

// -----------------------------------------------------------------------

//STRIP001 #define DEF_MARGIN	120

//STRIP001 void SvxParaPrevWindow::DrawParagraph( BOOL bAll )
//STRIP001 {
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001     const Color& rWinColor = rStyleSettings.GetWindowColor();
//STRIP001     Color aGrayColor(COL_LIGHTGRAY);
//STRIP001 
//STRIP001     SetFillColor( Color( rWinColor ) );
//STRIP001     if( bAll )
//STRIP001         DrawRect( Rectangle( Point(), aWinSize ) );
//STRIP001 
//STRIP001     SetLineColor();
//STRIP001 
//STRIP001 	long nH = aWinSize.Height() / 19;
//STRIP001 	Size aLineSiz( aWinSize.Width() - DEF_MARGIN, nH ),
//STRIP001 		 aSiz = aLineSiz;
//STRIP001 	Point aPnt;
//STRIP001 	aPnt.X() = DEF_MARGIN / 2;
//STRIP001     SetFillColor( aGrayColor );
//STRIP001 
//STRIP001 	for ( USHORT i = 0; i < 9; ++i )
//STRIP001 	{
//STRIP001 		if ( 3 == i )
//STRIP001 		{
//STRIP001             SetFillColor( Color( COL_GRAY ) );
//STRIP001             long nTop = nUpper * aLineSiz.Height() / aSize.Height();
//STRIP001 			aPnt.Y() += nTop * 2;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( 6 == i )
//STRIP001             SetFillColor( aGrayColor );
//STRIP001 
//STRIP001 		if ( 3 <= i && 6 > i )
//STRIP001 		{
//STRIP001 			long nLeft = nLeftMargin * aLineSiz.Width() / aSize.Width();
//STRIP001 			long nFirst = nFirstLineOfst * aLineSiz.Width() / aSize.Width();
//STRIP001 			long nTmp = nLeft + nFirst;
//STRIP001 
//STRIP001 			if ( 3 == i )
//STRIP001 			{
//STRIP001 				aPnt.X() += nTmp;
//STRIP001 				aSiz.Width() -= nTmp;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				aPnt.X() += nLeft;
//STRIP001 				aSiz.Width() -= nLeft;
//STRIP001 			}
//STRIP001             long nRight = nRightMargin * aLineSiz.Width() / aSize.Width();
//STRIP001             aSiz.Width() -= nRight;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( 4 == i || 5 == i || 6 == i )
//STRIP001 		{
//STRIP001 			switch ( eLine )
//STRIP001 			{
//STRIP001 				case SVX_PREV_LINESPACE_1:						break;
//STRIP001 				case SVX_PREV_LINESPACE_15:	aPnt.Y() += nH / 2;	break;
//STRIP001 				case SVX_PREV_LINESPACE_2:	aPnt.Y() += nH;		break;
//STRIP001 
//STRIP001 				case SVX_PREV_LINESPACE_PROP:
//STRIP001 				case SVX_PREV_LINESPACE_MIN:
//STRIP001 				case SVX_PREV_LINESPACE_DURCH:					break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		aPnt.Y() += nH;
//STRIP001 
//STRIP001         if ( (3 <= i) && (5 >= i) )
//STRIP001 		{
//STRIP001             long nLW;
//STRIP001             switch( i )
//STRIP001             {
//STRIP001                 case 3: nLW = aLineSiz.Width() * 8 / 10;    break;
//STRIP001                 case 4: nLW = aLineSiz.Width() * 9 / 10;    break;
//STRIP001                 case 5: nLW = aLineSiz.Width() / 2;         break;
//STRIP001             }
//STRIP001 
//STRIP001 			if ( nLW > aSiz.Width() )
//STRIP001 				nLW = aSiz.Width();
//STRIP001 
//STRIP001 			switch ( eAdjust )
//STRIP001 			{
//STRIP001 				case SVX_ADJUST_LEFT:
//STRIP001 					break;
//STRIP001 				case SVX_ADJUST_RIGHT:
//STRIP001 					aPnt.X() += ( aSiz.Width() - nLW );
//STRIP001 					break;
//STRIP001 				case SVX_ADJUST_CENTER:
//STRIP001 					aPnt.X() += ( aSiz.Width() - nLW ) / 2;
//STRIP001 					break;
//STRIP001             }
//STRIP001             if( SVX_ADJUST_BLOCK == eAdjust )
//STRIP001             {
//STRIP001                 if( 5 == i )
//STRIP001                 {
//STRIP001                     switch( eLastLine )
//STRIP001                     {
//STRIP001                         case SVX_ADJUST_LEFT:
//STRIP001                             break;
//STRIP001                         case SVX_ADJUST_RIGHT:
//STRIP001                             aPnt.X() += ( aSiz.Width() - nLW );
//STRIP001                             break;
//STRIP001                         case SVX_ADJUST_CENTER:
//STRIP001                             aPnt.X() += ( aSiz.Width() - nLW ) / 2;
//STRIP001                             break;
//STRIP001                         case SVX_ADJUST_BLOCK:
//STRIP001                             nLW = aSiz.Width();
//STRIP001                             break;
//STRIP001                     }
//STRIP001                 }
//STRIP001                 else
//STRIP001                     nLW = aSiz.Width();
//STRIP001 			}
//STRIP001             aSiz.Width() = nLW;
//STRIP001 		}
//STRIP001 
//STRIP001         Rectangle aRect( aPnt, aSiz );
//STRIP001 
//STRIP001 		if ( Lines[i] != aRect || bAll )
//STRIP001 		{
//STRIP001 			if ( !bAll )
//STRIP001 			{
//STRIP001 				Color aFillCol = GetFillColor();
//STRIP001                 SetFillColor( rWinColor );
//STRIP001                 DrawRect( Lines[i] );
//STRIP001 				SetFillColor( aFillCol );
//STRIP001 			}
//STRIP001 			DrawRect( aRect );
//STRIP001 			Lines[i] = aRect;
//STRIP001 		}
//STRIP001 
//STRIP001 		if ( 5 == i )
//STRIP001 		{
//STRIP001 			long nBottom = nLower * aLineSiz.Height() / aSize.Height();
//STRIP001 			aPnt.Y() += nBottom * 2;
//STRIP001 		}
//STRIP001 
//STRIP001 		aPnt.Y() += nH;
//STRIP001 		// wieder zuruecksetzen, fuer jede Linie neu berechnen
//STRIP001 		aPnt.X() = DEF_MARGIN / 2;
//STRIP001 		aSiz = aLineSiz;
//STRIP001 	}
//STRIP001 }

//STRIP001 #undef DEF_MARGIN

// -----------------------------------------------------------------------

//STRIP001 void SvxParaPrevWindow::OutputSizeChanged()
//STRIP001 {
//STRIP001 	aWinSize = GetOutputSizePixel();
//STRIP001 	aWinSize = PixelToLogic( aWinSize );
//STRIP001 	Invalidate();
//STRIP001 }

}
