/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_fmshimp.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:45:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#pragma hdrstop

#if STLPORT_VERSION>=321
#include <math.h>	// prevent conflict between exception and std::exception
#endif

// auto strip #ifndef _SVX_GRIDCOLS_HXX
// auto strip #include "gridcols.hxx"
// auto strip #endif

#ifndef _E3D_OBJ3D_HXX
#include <obj3d.hxx>
#endif

#ifndef _SVX_FMVWIMP_HXX
#include "fmvwimp.hxx"
#endif

#ifndef _COM_SUN_STAR_SDBC_XROWSETLISTENER_HPP_
#include <com/sun/star/sdbc/XRowSetListener.hpp>
#endif

// auto strip #ifndef _COM_SUN_STAR_BEANS_XPROPERTYCHANGELISTENER_HPP_
// auto strip #include <com/sun/star/beans/XPropertyChangeListener.hpp>
// auto strip #endif

#ifndef _COM_SUN_STAR_SDB_XSQLQUERYCOMPOSERFACTORY_HPP_
#include <com/sun/star/sdb/XSQLQueryComposerFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif

#ifndef _SVX_FMSHIMP_HXX
#include "fmshimp.hxx"
#endif

#ifndef _SVDPAGV_HXX //autogen
#include "svdpagv.hxx"
#endif

#ifndef _SVX_FMPAGE_HXX
#include "fmpage.hxx"
#endif

// auto strip #ifndef _ISOLANG_HXX
// auto strip #include <tools/isolang.hxx>
// auto strip #endif

// auto strip #ifndef _SHL_HXX
// auto strip #include <tools/shl.hxx>
// auto strip #endif

// auto strip #ifndef _SV_MSGBOX_HXX //autogen
// auto strip #include <vcl/msgbox.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_DIALMGR_HXX //autogen
// auto strip #include <dialmgr.hxx>
// auto strip #endif

#ifndef _SVX_FMRESIDS_HRC
#include "fmresids.hrc"
#endif // _SVX_FMRESIDS_HRC

// auto strip #ifndef _SVX_FMITEMS_HXX
// auto strip #include "fmitems.hxx"
// auto strip #endif

#ifndef _SVX_FMOBJ_HXX
#include "fmobj.hxx"
#endif

#ifndef _MULTIPRO_HXX
#include "multipro.hxx"
#endif

#ifndef _SFXDISPATCH_HXX //autogen
#include <bf_sfx2/dispatch.hxx>
#endif

// auto strip #ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
// auto strip #include <com/sun/star/frame/FrameSearchFlag.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_FORM_XLOADABLE_HPP_
#include <com/sun/star/form/XLoadable.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XCONTAINER_HPP_
#include <com/sun/star/container/XContainer.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XENUMERATION_HPP_
// auto strip #include <com/sun/star/container/XEnumeration.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
// auto strip #include <com/sun/star/container/XIndexAccess.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_CONTAINER_XENUMERATIONACCESS_HPP_
// auto strip #include <com/sun/star/container/XEnumerationAccess.hpp>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
// auto strip #include <com/sun/star/frame/FrameSearchFlag.hpp>
// auto strip #endif

// auto strip #ifndef _COM_SUN_STAR_AWT_XTEXTCOMPONENT_HPP_
// auto strip #include <com/sun/star/awt/XTextComponent.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XBOUNDCOMPONENT_HPP_
// auto strip #include <com/sun/star/form/XBoundComponent.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_LISTSOURCETYPE_HPP_
// auto strip #include <com/sun/star/form/ListSourceType.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_VIEW_XSELECTIONSUPPLIER_HPP_
// auto strip #include <com/sun/star/view/XSelectionSupplier.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_SCRIPT_XEVENTATTACHERMANAGER_HPP_
// auto strip #include <com/sun/star/script/XEventAttacherManager.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XBOUNDCONTROL_HPP_
// auto strip #include <com/sun/star/form/XBoundControl.hpp>
// auto strip #endif
#ifndef _COM_SUN_STAR_FORM_XRESET_HPP_
#include <com/sun/star/form/XReset.hpp>
#endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XGRID_HPP_
// auto strip #include <com/sun/star/form/XGrid.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_FORM_XGRIDPEER_HPP_
// auto strip #include <com/sun/star/form/XGridPeer.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XNUMBERFORMATTER_HPP_
// auto strip #include <com/sun/star/util/XNumberFormatter.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XMODESELECTOR_HPP_
// auto strip #include <com/sun/star/util/XModeSelector.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XMODIFYBROADCASTER_HPP_
// auto strip #include <com/sun/star/util/XModifyBroadcaster.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_UTIL_XCANCELLABLE_HPP_
// auto strip #include <com/sun/star/util/XCancellable.hpp>
// auto strip #endif
// auto strip #ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
// auto strip #include <com/sun/star/beans/PropertyAttribute.hpp>
// auto strip #endif
#ifndef _SVX_FMGLOB_HXX
#include <fmglob.hxx>
#endif

#ifndef _SVDITER_HXX //autogen
#include <svditer.hxx>
#endif

// auto strip #ifndef _OSL_MUTEX_HXX_
// auto strip #include <osl/mutex.hxx>
// auto strip #endif

#ifndef _SFXVIEWSH_HXX //autogen wg. SfxViewShell
#include <bf_sfx2/viewsh.hxx>
#endif

#ifndef _SFXVIEWFRM_HXX //autogen wg. SfxViewFrame
#include <bf_sfx2/viewfrm.hxx>
#endif

// auto strip #ifndef _SFXFRAME_HXX //autogen wg. SfxFrame
// auto strip #include <bf_sfx2/frame.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_FMSERVS_HXX
// auto strip #include "fmservs.hxx"
// auto strip #endif // _SVX_FMSERVS_HXX

// auto strip #ifndef _TOOLS_COLOR_HXX
// auto strip #include <tools/color.hxx>
// auto strip #endif

#ifndef _SVX_FMUNOPGE_HXX
#include "fmpgeimp.hxx"
#endif
// auto strip #ifndef _SVX_FMTOOLS_HXX
// auto strip #include "fmtools.hxx"
// auto strip #endif
#ifndef _SVX_FMPROP_HRC
#include "fmprop.hrc"
#endif
#ifndef _SVX_FMSHELL_HXX
#include "fmshell.hxx"
#endif
#ifndef _SVX_SVXIDS_HRC
#include "svxids.hrc"
#endif

#ifndef _SVX_FMMODEL_HXX
#include "fmmodel.hxx"
#endif
#ifndef _SVX_FMUNDO_HXX
#include "fmundo.hxx"
#endif

#ifndef _SVX_FMURL_HXX
#include "fmurl.hxx"
#endif

// auto strip #ifndef _URLOBJ_HXX //autogen wg. INetURLObject
// auto strip #include <tools/urlobj.hxx>
// auto strip #endif

// auto strip #ifndef _COMPHELPER_PROPERTY_HXX_
// auto strip #include <comphelper/property.hxx>
// auto strip #endif
#ifndef _CONNECTIVITY_DBTOOLS_HXX_
#include <connectivity/dbtools.hxx>
#endif
// auto strip #ifndef _COMPHELPER_GUARDING_HXX_
// auto strip #include <comphelper/guarding.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_STLTYPES_HXX_
// auto strip #include <comphelper/stl_types.hxx>
// auto strip #endif
// auto strip #ifndef _COMPHELPER_PROCESSFACTORY_HXX_
// auto strip #include <comphelper/processfactory.hxx>
// auto strip #endif
// auto strip #ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
// auto strip #include <cppuhelper/servicefactory.hxx>
// auto strip #endif
#ifndef _COMPHELPER_EXTRACT_HXX_
#include <comphelper/extract.hxx>
#endif
// auto strip #ifndef _LEGACYBINFILTERMGR_HXX
// auto strip #include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
// auto strip #endif
namespace binfilter {

extern sal_Int16 ControllerSlotMap[];

extern sal_Int16 AutoSlotMap[];

// wird fuer Invalidate verwendet -> mitpflegen
extern sal_uInt16 DatabaseSlotMap[];

// wird fuer Invalidate verwendet -> mitpflegen
// aufsteigend sortieren !!!!!!
sal_Int16 DlgSlotMap[] =	// slots des Controllers
{
	SID_FM_CTL_PROPERTIES,
	SID_FM_PROPERTIES,
	SID_FM_TAB_DIALOG,
	SID_FM_ADD_FIELD,
	SID_FM_SHOW_FMEXPLORER,
	SID_FM_FIELDS_CONTROL,
	SID_FM_SHOW_PROPERTIES,
	SID_FM_PROPERTY_CONTROL,
	SID_FM_FMEXPLORER_CONTROL,
	0
};

sal_uInt16 ModifySlotMap[] =	// slots des Controllers
{
	SID_FM_RECORD_NEXT,
	SID_FM_RECORD_NEW,
	SID_FM_RECORD_SAVE,
	SID_FM_RECORD_UNDO,
	0
};

sal_Int16 SelObjectSlotMap[] =	// vom SelObject abhaengige Slots
{
	SID_FM_CONVERTTO_EDIT,
	SID_FM_CONVERTTO_BUTTON,
	SID_FM_CONVERTTO_FIXEDTEXT,
	SID_FM_CONVERTTO_LISTBOX,
	SID_FM_CONVERTTO_CHECKBOX,
	SID_FM_CONVERTTO_RADIOBUTTON,
	SID_FM_CONVERTTO_GROUPBOX,
	SID_FM_CONVERTTO_COMBOBOX,
	SID_FM_CONVERTTO_GRID,
	SID_FM_CONVERTTO_IMAGEBUTTON,
	SID_FM_CONVERTTO_FILECONTROL,
	SID_FM_CONVERTTO_DATE,
	SID_FM_CONVERTTO_TIME,
	SID_FM_CONVERTTO_NUMERIC,
	SID_FM_CONVERTTO_CURRENCY,
	SID_FM_CONVERTTO_PATTERN,
	SID_FM_CONVERTTO_IMAGECONTROL,
	SID_FM_CONVERTTO_FORMATTED,

	SID_FM_FMEXPLORER_CONTROL,

	0
};

// die folgenden Arrays muessen kosistent sein, also einander entsprechende Eintraege an der selben relativen Position
// innerhalb ihres jeweiligen Arrays stehen
sal_Int16 nConvertSlots[] =
{
	SID_FM_CONVERTTO_EDIT,
	SID_FM_CONVERTTO_BUTTON,
	SID_FM_CONVERTTO_FIXEDTEXT,
	SID_FM_CONVERTTO_LISTBOX,
	SID_FM_CONVERTTO_CHECKBOX,
	SID_FM_CONVERTTO_RADIOBUTTON,
	SID_FM_CONVERTTO_GROUPBOX,
	SID_FM_CONVERTTO_COMBOBOX,
	SID_FM_CONVERTTO_GRID,
	SID_FM_CONVERTTO_IMAGEBUTTON,
	SID_FM_CONVERTTO_FILECONTROL,
	SID_FM_CONVERTTO_DATE,
	SID_FM_CONVERTTO_TIME,
	SID_FM_CONVERTTO_NUMERIC,
	SID_FM_CONVERTTO_CURRENCY,
	SID_FM_CONVERTTO_PATTERN,
	SID_FM_CONVERTTO_IMAGECONTROL,
	SID_FM_CONVERTTO_FORMATTED
};

sal_Int16 nCreateSlots[] =
{
	SID_FM_EDIT,
	SID_FM_PUSHBUTTON,
	SID_FM_FIXEDTEXT,
	SID_FM_LISTBOX,
	SID_FM_CHECKBOX,
	SID_FM_RADIOBUTTON,
	SID_FM_GROUPBOX,
	SID_FM_COMBOBOX,
	SID_FM_DBGRID,
	SID_FM_IMAGEBUTTON,
	SID_FM_FILECONTROL,
	SID_FM_DATEFIELD,
	SID_FM_TIMEFIELD,
	SID_FM_NUMERICFIELD,
	SID_FM_CURRENCYFIELD,
	SID_FM_PATTERNFIELD,
	SID_FM_IMAGECONTROL,
	SID_FM_FORMATTEDFIELD
};

sal_Int16 nObjectTypes[] =
{
	OBJ_FM_EDIT,
	OBJ_FM_BUTTON,
	OBJ_FM_FIXEDTEXT,
	OBJ_FM_LISTBOX,
	OBJ_FM_CHECKBOX,
	OBJ_FM_RADIOBUTTON,
	OBJ_FM_GROUPBOX,
	OBJ_FM_COMBOBOX,
	OBJ_FM_GRID,
	OBJ_FM_IMAGEBUTTON,
	OBJ_FM_FILECONTROL,
	OBJ_FM_DATEFIELD,
	OBJ_FM_TIMEFIELD,
	OBJ_FM_NUMERICFIELD,
	OBJ_FM_CURRENCYFIELD,
	OBJ_FM_PATTERNFIELD,
	OBJ_FM_IMAGECONTROL,
	OBJ_FM_FORMATTEDFIELD
};

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::binfilter::svxform;//STRIP008 using namespace ::svxform;

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXBoundFormFieldIterator::ShouldStepInto(const Reference< XInterface>& _rContainer) const
//STRIP001 {
//STRIP001 	if (_rContainer == m_xStartingPoint)
//STRIP001 		// would be quite stupid to step over the root ....
//STRIP001 		return sal_True;
//STRIP001 
//STRIP001 	return Reference< XControlModel>(_rContainer, UNO_QUERY).is();
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXBoundFormFieldIterator::ShouldHandleElement(const Reference< XInterface>& _rElement)
//STRIP001 {
//STRIP001 	if (!_rElement.is())
//STRIP001 		// NULL element
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	if (Reference< XForm>(_rElement, UNO_QUERY).is() || Reference< XGrid>(_rElement, UNO_QUERY).is())
//STRIP001 		// a forms or a grid
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XPropertySet> xSet(_rElement, UNO_QUERY);
//STRIP001 	if (!xSet.is() || !::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xSet))
//STRIP001 		// no "BoundField" property
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Any aVal( xSet->getPropertyValue(FM_PROP_BOUNDFIELD) );
//STRIP001 	if (aVal.getValueTypeClass() != TypeClass_INTERFACE)
//STRIP001 		// void or invalid property value
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	return aVal.hasValue();
//STRIP001 }

//==============================================================================

//STRIP001 /*?*/ DECL_CURSOR_ACTION_THREAD(FmMoveToLastThread);
//STRIP001 IMPL_CURSOR_ACTION_THREAD(FmMoveToLastThread, SVX_RES(RID_STR_MOVING_CURSOR), last());

//------------------------------------------------------------------------------
/*N*/ sal_Bool isControlList(const SdrMarkList& rMarkList)
/*N*/ {
/*N*/ 	// enthaelt die liste nur Controls und mindestens ein control
/*N*/ 	sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
/*N*/ 	sal_Bool  bControlList = nMarkCount != 0;
/*N*/ 
/*N*/ 	sal_Bool bHadAnyLeafs = sal_False;
/*N*/ 
/*N*/ 	for (sal_uInt32 i = 0; i < nMarkCount && bControlList; i++)
/*N*/ 	{
/*?*/ 		SdrObject *pObj = rMarkList.GetMark(i)->GetObj();
/*?*/ 		E3dObject* pAs3DObject = PTR_CAST(E3dObject, pObj);
/*?*/ 		// E3dObject's do not contain any 2D-objects (by definition)
/*?*/ 		// we need this extra check here : an E3dObject->IsGroupObject says "YES", but an SdrObjListIter working
/*?*/ 		// with an E3dObject doesn't give me any Nodes (E3dObject has a sub list, but no members in that list,
/*?*/ 		// cause there implementation differs from the one of "normal" SdrObject's. Unfortunally SdrObject::IsGroupObject
/*?*/ 		// doesn't check the element count of the sub list, which is simply a bug in IsGroupObject we can't fix at the moment).
/*?*/ 		// So at the end of this function bControlList would have the same value it was initialized with above : sal_True
/*?*/ 		// And this would be wrong :)
/*?*/ 		// 03.02.00 - 72529 - FS
/*?*/ 		if (!pAs3DObject)
/*?*/ 			if (pObj->IsGroupObject())
/*?*/ 			{
/*?*/ 				SdrObjListIter aIter(*pObj->GetSubList());
/*?*/ 				while (aIter.IsMore() && bControlList)
/*?*/ 				{
/*?*/ 					bControlList = FmFormInventor == aIter.Next()->GetObjInventor();
/*?*/ 					bHadAnyLeafs = sal_True;
/*?*/ 				}
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				bHadAnyLeafs = sal_True;
/*?*/ 				bControlList = FmFormInventor == pObj->GetObjInventor();
/*?*/ 			}
/*N*/ 	}
/*N*/ 
/*N*/ 	return bControlList && bHadAnyLeafs;
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 Reference< XForm> GetForm(const Reference< XInterface>& xElement)
//STRIP001 {
//STRIP001 	Reference< XChild> xChild(xElement, UNO_QUERY);
//STRIP001 	Reference< XInterface> xParent;
//STRIP001 	if (xChild.is())
//STRIP001 		xParent = xChild->getParent();
//STRIP001 
//STRIP001 	Reference< XForm> xForm(xParent, UNO_QUERY);
//STRIP001 	if (!xForm.is() && xParent.is())
//STRIP001 		xForm = GetForm(xParent);
//STRIP001 
//STRIP001 	return xForm;
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 Reference< XForm> GetForm(const FmFormObj* pObj)
//STRIP001 {
//STRIP001 	Reference< XForm> xForm;
//STRIP001 	if (pObj)
//STRIP001 	{
//STRIP001 		Reference< XFormComponent> xFormComponent(pObj->GetUnoControlModel(), UNO_QUERY);
//STRIP001 		if (xFormComponent.is())
//STRIP001 			xForm = Reference< XForm>(xFormComponent->getParent(), UNO_QUERY);
//STRIP001 	}
//STRIP001 	return xForm;
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ Reference< XForm> FmXFormShell::DetermineCurForm(const SdrMarkList& rMarkList, sal_Bool& bMixedWithFormControls)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// gibt es eine aktuelle Form, wird ermittelt aus den selektierten Objekten
/*N*/ 	Reference< XForm> xReferenceForm;
/*N*/ 	bMixedWithFormControls = sal_False;
/*N*/ 	sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
/*N*/ 
/*N*/ 	sal_Bool bHasFormControls = sal_False;
/*N*/ 	sal_Bool bHasForeignControls = sal_False;
/*N*/ 
/*N*/ 	Reference< XForm> xForm;
/*N*/ 	for (sal_uInt32 i=0; i<nMarkCount; i++)
/*N*/ 	{
/*?*/ 		SdrObject* pObj = rMarkList.GetMark(i)->GetObj();
/*?*/ 		if (pObj->GetObjInventor() == FmFormInventor)
/*?*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			FmFormObj* pFormObj = PTR_CAST(FmFormObj, pObj);
//STRIP001 /*?*/ 			xForm = GetForm(pFormObj);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			if (!xReferenceForm.is())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				xReferenceForm = xForm;
//STRIP001 /*?*/ 				bHasFormControls = sal_True;
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else if (xForm.is() && (XForm*)xReferenceForm.get() != (XForm*)xForm.get())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// mehr als eine Form selektiert
//STRIP001 /*?*/ 				bMixedWithFormControls = sal_True;
//STRIP001 /*?*/ 				return Reference< XForm>();
//STRIP001 /*?*/ 			}
/*?*/ 		}
/*?*/ 		else if (pObj->IsGroupObject())
/*?*/ 		{
/*?*/ 			SdrObjListIter aIter(*pObj->GetSubList());
/*?*/ 			while (aIter.IsMore())
/*?*/ 			{
/*?*/ 				SdrObject* pObj = aIter.Next();
/*?*/ 				if (pObj->GetObjInventor() == FmFormInventor)
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					FmFormObj* pFormObj = PTR_CAST(FmFormObj, pObj);
//STRIP001 /*?*/ 					xForm = GetForm(pFormObj);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (!xReferenceForm.is())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						xReferenceForm = xForm;
//STRIP001 /*?*/ 						bHasFormControls = sal_True;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else if (xForm.is() && (XForm*)xReferenceForm.get() != (XForm*)xForm.get())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						// mehr als eine Form selektiert
//STRIP001 /*?*/ 						bMixedWithFormControls = sal_True;
//STRIP001 /*?*/ 						return Reference< XForm>();
//STRIP001 /*?*/ 					}
/*?*/ 				} else
/*?*/ 					// irgendein Nicht-Form-Control
/*?*/ 					bHasForeignControls = sal_True;
/*?*/ 			}
/*?*/ 		} else
/*?*/ 			bHasForeignControls = sal_True;
/*N*/ 	}
/*N*/ 
/*N*/ 	// hierher komme ich nicht mehr, wenn Controls aus mindestens zwei Forms selektiert sind, also ermittelt sich
/*N*/ 	// bMixedWithFormControls wie folgt
/*N*/ 	bMixedWithFormControls = bHasForeignControls && bHasFormControls;
/*N*/ 	return xReferenceForm;
/*N*/ }


//========================================================================
// class FmXFormShell_Base_Disambiguation
//========================================================================
/*N*/ FmXFormShell_Base_Disambiguation::FmXFormShell_Base_Disambiguation( ::osl::Mutex& _rMutex )
/*N*/ 	:FmXFormShell_BD_BASE( _rMutex )
/*N*/ {
/*N*/ }

/*N*/ void SAL_CALL FmXFormShell_Base_Disambiguation::disposing()
/*N*/ {
/*N*/ 	WeakComponentImplHelperBase::disposing();
/*N*/ 	// Note:
/*N*/ 	// This is a HACK.
/*N*/ 	// Normally it should be sufficient to call the "disposing" of our direct
/*N*/ 	// base class, but SUN PRO 5 does not like this and claims there is a conflict
/*N*/ 	// with the XEventListener::disposing(EventObject) of our various listener
/*N*/ 	// base classes.
/*N*/ }

//========================================================================
// class FmXFormShell
//========================================================================
/*N*/ DBG_NAME(FmXFormShell)
//------------------------------------------------------------------------
/*N*/ FmXFormShell::FmXFormShell( FmFormShell* _pShell, SfxViewFrame* _pViewFrame )
/*N*/ 		:FmXFormShell_BASE(m_aMutex)
/*N*/ 		,FmXFormShell_CFGBASE(::rtl::OUString::createFromAscii("Office.Common/Misc"), CONFIG_MODE_DELAYED_UPDATE)
/*N*/ 		,m_pShell(_pShell)
/*N*/ 		,m_bDatabaseBar(sal_False)
/*N*/ 		,m_eNavigate(NavigationBarMode_NONE)
/*N*/ 		,m_bActiveModified(sal_False)
/*N*/ 		,m_bTrackProperties(sal_True)
/*N*/ 		,m_bInActivate(sal_False)
/*N*/ 		,m_bSetFocus(sal_False)
/*N*/ 		,m_nLockSlotInvalidation(0)
/*N*/ 		,m_nInvalidationEvent(0)
/*N*/ 		,m_bFilterMode(sal_False)
/*N*/ 		,m_bHadPropBrw(sal_False)
/*N*/ 		,m_pMainFrameInterceptor(NULL)
/*N*/ 		,m_pExternalViewInterceptor(NULL)
/*N*/ 		,m_bChangingDesignMode(sal_False)
/*N*/ 		,m_bUseWizards(sal_True)
/*N*/ 		,m_bPreparedClose( sal_False )
/*N*/ {
/*N*/ 	DBG_CTOR(FmXFormShell,NULL);
/*N*/ 	m_aMarkTimer.SetTimeout(100);
/*N*/ 	m_aMarkTimer.SetTimeoutHdl(LINK(this,FmXFormShell,OnTimeOut));
/*N*/ 
/*N*/ 	// we are a DispatchInterceptor, so we want to be inserted into the frame's dispatch chain, thus having
/*N*/ 	// a chance for frame-spanning communication (via UNO, not slots)
/*N*/ 	SfxFrame* pFrame = _pViewFrame ? _pViewFrame->GetFrame() : NULL;
/*N*/ 	Reference< ::com::sun::star::frame::XFrame> xUnoFrame;
/*N*/ 	if( pFrame)
/*N*/ 		xUnoFrame = pFrame->GetFrameInterface();
/*N*/ 	else
/*?*/ 		xUnoFrame = Reference< ::com::sun::star::frame::XFrame>(NULL);
/*N*/ 
/*N*/ 	// to prevent deletion of this we acquire our refcounter once
/*N*/ 	::comphelper::increment(FmXFormShell_BASE::m_refCount);
/*N*/ 
/*N*/ 	// dispatch interception for the frame
/*N*/ 	Reference< ::com::sun::star::frame::XDispatchProviderInterception> xSupplier(xUnoFrame, UNO_QUERY);
/*N*/ 
/*N*/ 	::rtl::OUString sInterceptorScheme = FMURL_FORMSLOTS_PREFIX;
/*N*/ 	sInterceptorScheme += ::rtl::OUString::createFromAscii("*");
/*N*/ 	m_pMainFrameInterceptor = new FmXDispatchInterceptorImpl(xSupplier, this, 0, Sequence< ::rtl::OUString >(&sInterceptorScheme, 1));
/*N*/ 	m_pMainFrameInterceptor->acquire();
/*N*/ 
/*N*/ 	m_xAttachedFrame = xUnoFrame;
/*N*/ 
/*N*/ 	// correct the refcounter
/*N*/ 	::comphelper::decrement(FmXFormShell_BASE::m_refCount);
/*N*/ 
/*N*/ 	// cache the current configuration settings we're interested in
/*N*/ 	implAdjustConfigCache();
/*N*/ 	// and register for changes on this settings
/*N*/ 	Sequence< ::rtl::OUString > aNames(1);
/*N*/ 	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
/*N*/ 	EnableNotification(aNames);
/*N*/ }

//------------------------------------------------------------------------
/*N*/ FmXFormShell::~FmXFormShell()
/*N*/ {
/*N*/ 	DBG_DTOR(FmXFormShell,NULL);
/*N*/ }

//------------------------------------------------------------------
//STRIP001 Any SAL_CALL FmXFormShell::queryInterface( const Type& type) throw ( RuntimeException )
//STRIP001 {
//STRIP001 	return FmXFormShell_BASE::queryInterface(type);
//STRIP001 }
//------------------------------------------------------------------------------
//STRIP001 Sequence< Type > SAL_CALL FmXFormShell::getTypes(  ) throw(RuntimeException)
//STRIP001 {
//STRIP001 	return FmXFormShell_BASE::getTypes();
//STRIP001 }
//------------------------------------------------------------------------------
/*N*/ Sequence< sal_Int8 > SAL_CALL FmXFormShell::getImplementationId() throw(RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); Sequence< sal_Int8 > a; return a;//STRIP001 
//STRIP001 	return ::binfilter::form::OImplementationIds::getImplementationId(getTypes());//STRIP008 return ::form::OImplementationIds::getImplementationId(getTypes());
/*N*/ }
//	EventListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::disposing(const EventObject& e) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //STRIP001 	if (m_xActiveController == e.Source)
//STRIP001 	{
//STRIP001 		// wird der Controller freigeben dann alles loslassen
//STRIP001 		stopListening();
//STRIP001 		m_xActiveForm = NULL;
//STRIP001 		m_xActiveController = NULL;
//STRIP001 		m_xNavigationController = NULL;
//STRIP001 
//STRIP001 		m_pShell->GetViewShell()->GetViewFrame()->GetBindings().InvalidateShell(*m_pShell);
//STRIP001 	}
//STRIP001 
//STRIP001 	if (e.Source == m_xExternalViewController)
//STRIP001 	{
//STRIP001 		Reference< XFormController> xFormController(m_xExternalViewController, UNO_QUERY);
//STRIP001 		if (xFormController.is())
//STRIP001 			xFormController->removeActivateListener((XFormControllerListener*)this);
//STRIP001 
//STRIP001 		Reference< ::com::sun::star::lang::XComponent> xComp(m_xExternalViewController, UNO_QUERY);
//STRIP001 		if (xComp.is())
//STRIP001 			xComp->removeEventListener((XEventListener*)(XPropertyChangeListener*)this);
//STRIP001 
//STRIP001 		m_xExternalViewController = NULL;
//STRIP001 		m_xExternalDisplayedForm = NULL;
//STRIP001 		m_xExtViewTriggerController = NULL;
//STRIP001 
//STRIP001 		InvalidateSlot(SID_FM_VIEW_AS_GRID, sal_True, sal_False);
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::propertyChange(const PropertyChangeEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (evt.PropertyName == FM_PROP_ISMODIFIED)
//STRIP001 	{
//STRIP001 		m_bPreparedClose = sal_False;
//STRIP001 			// the "modification state" of the current for changed -> the next PrepareClose call
//STRIP001 			// must do the full check
//STRIP001 
//STRIP001 		if (!::comphelper::getBOOL(evt.NewValue))
//STRIP001 			m_bActiveModified = sal_False;
//STRIP001 	}
//STRIP001 	else if (evt.PropertyName == FM_PROP_ISNEW)
//STRIP001 	{
//STRIP001 		if (!::comphelper::getBOOL(evt.NewValue))
//STRIP001 			m_bActiveModified = sal_False;
//STRIP001 	}
//STRIP001 	else if (evt.PropertyName == FM_PROP_ROWCOUNT)
//STRIP001 	{
//STRIP001 		// Das gleich folgenden Update erzwingt ein Neu-Painten der entsprechenden Slots. Wenn ich mich aber hier nicht
//STRIP001 		// in dem HauptThread der Applikation befinde (weil zum Beispiel ein Cursor gerade Datensaetze zaehlt und mir dabei
//STRIP001 		// immer diese PropertyChanges beschert), kann sich das mit en normalen Paints im HauptThread der Applikation beissen.
//STRIP001 		// (Solche Paints passieren zum Beispiel, wenn man einfach nur eine andere Applikation ueber das Office legt und wieder
//STRIP001 		// zurueckschaltet).
//STRIP001 		// Deshalb die Benutzung des SolarMutex, der sichert das ab.
//STRIP001 		::vos::IMutex& rSolarSafety = Application::GetSolarMutex();
//STRIP001 		if (rSolarSafety.tryToAcquire())
//STRIP001 		{
//STRIP001 			m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(SID_FM_RECORD_TOTAL , sal_True, sal_False);
//STRIP001 			m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Update(SID_FM_RECORD_TOTAL);
//STRIP001 			rSolarSafety.release();
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// with the following the slot is invalidated asynchron
//STRIP001 			LockSlotInvalidation(sal_True);
//STRIP001 			InvalidateSlot(SID_FM_RECORD_TOTAL , sal_True, sal_False);
//STRIP001 			LockSlotInvalidation(sal_False);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else if (m_xParser.is())
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if (evt.PropertyName == FM_PROP_ACTIVECOMMAND)
//STRIP001 				m_xParser->setQuery(::comphelper::getString(evt.NewValue));
//STRIP001 			else if (evt.PropertyName == FM_PROP_FILTER_CRITERIA)
//STRIP001 			{
//STRIP001 				if (m_xParser->getFilter() != ::comphelper::getString(evt.NewValue))
//STRIP001 					m_xParser->setFilter(::comphelper::getString(evt.NewValue));
//STRIP001 			}
//STRIP001 			else if (evt.PropertyName == FM_PROP_SORT)
//STRIP001 			{
//STRIP001 				if (m_xParser->getOrder() != ::comphelper::getString(evt.NewValue))
//STRIP001 					m_xParser->setOrder(::comphelper::getString(evt.NewValue));
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 			DBG_ERROR("FmXFormShell::propertyChange: Exception occured!");
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	// this may be called from a non-main-thread so invalidate the shell asynchronously
//STRIP001 	LockSlotInvalidation(sal_True);
//STRIP001 	InvalidateSlot(0, 0, 0);		// special meaning : invalidate m_pShell
//STRIP001 	LockSlotInvalidation(sal_False);
/*?*/ }

// XModifyListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::modified(const EventObject& rEvent) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (!m_bActiveModified)
//STRIP001 	{
//STRIP001 		m_bActiveModified = sal_True;
//STRIP001 		m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(ModifySlotMap);
//STRIP001 
//STRIP001 		m_bPreparedClose = sal_False;
//STRIP001 			// the "modification state" of the current for changed -> the next PrepareClose call
//STRIP001 			// must do the full check
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ Reference< ::com::sun::star::frame::XDispatch> FmXFormShell::interceptedQueryDispatch(sal_uInt16 _nId, const URL& aURL, const ::rtl::OUString& aTargetFrameName, sal_Int32 nSearchFlags) throw( RuntimeException )
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	::osl::MutexGuard aGuard(m_aAsyncSafety);
/*N*/ 
/*N*/ 	if (!m_pShell)
/*?*/ 		return Reference< ::com::sun::star::frame::XDispatch>();
/*N*/ 	// if we have no shell we are disposed, so we disposed all our dispatchers, too, so there is no need to supply a dispatcher
/*N*/ 	// (and no possibility : without our shell, methods like GetPageForms won't work properly)
/*N*/ 
/*N*/ 	// check if it is one of the form navigation urls
/*N*/ 	static ::rtl::OUString sFormNavUrls[] = {
/*N*/ 		FMURL_RECORD_MOVEFIRST,
/*N*/ 		FMURL_RECORD_MOVEPREV,
/*N*/ 		FMURL_RECORD_MOVENEXT,
/*N*/ 		FMURL_RECORD_MOVELAST,
/*N*/ 		FMURL_RECORD_MOVETONEW,
/*N*/ 		FMURL_RECORD_UNDO
/*N*/ 	};
/*N*/ 	static sal_Int16 nAccordingSlots[] = {
/*N*/ 		SID_FM_RECORD_FIRST,
/*N*/ 		SID_FM_RECORD_PREV,
/*N*/ 		SID_FM_RECORD_NEXT,
/*N*/ 		SID_FM_RECORD_LAST,
/*N*/ 		SID_FM_RECORD_NEW,
/*N*/ 		SID_FM_RECORD_UNDO
/*N*/ 	};
/*N*/ 	::rtl::OUString sMark;
/*N*/ 	UniString sAccessPath,sExternalCheck,sPageId;
/*N*/ 	for (sal_Int16 i=0; i<sizeof(sFormNavUrls)/sizeof(sFormNavUrls[0]); ++i)
/*N*/ 	{
/*N*/ 		if (aURL.Main.equals(sFormNavUrls[i]))
/*N*/ 		{
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			sMark = aURL.Mark;
//STRIP001 /*?*/ 			DBG_ASSERT(sMark.getLength(), "FmXFormShell::queryDispatch : invalid URL !");
//STRIP001 /*?*/ 				// form navigation slots should always have a mark describing their form model's access paths (FmXFormController builds such a mark)
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			sAccessPath = sMark.getStr();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// check if it comes from our external form grid view
//STRIP001 /*?*/ 			String sComponentName = (::rtl::OUString)FMURL_COMPONENT_FORMGRIDVIEW;
//STRIP001 /*?*/ 			sExternalCheck = sComponentName;
//STRIP001 /*?*/ 			INetURLObject aExternalCheck(sExternalCheck);
//STRIP001 /*?*/ 			if (String(aExternalCheck.GetURLPath()) == sAccessPath)
//STRIP001 /*?*/ 			{	// it comes from the external dispatcher
//STRIP001 /*?*/ 				// -> correct the access path
//STRIP001 /*?*/				DBG_ASSERT(m_xExternalDisplayedForm.is() && m_xExternalViewController.is(),
//STRIP001 /*?*/ 					"FmXFormShell::queryDispatch : where did this dispatch request come from ?");
//STRIP001 /*?*/ 				sAccessPath = GetAccessPathFromForm(m_xExternalDisplayedForm, GetPageId(m_xExternalDisplayedForm));
//STRIP001 /*?*/ 				sMark = sAccessPath;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				DBG_ASSERT(_nId == 1, "FmXFormShell::queryDispatch : where did this came from ?");
//STRIP001 /*?*/ 				// the FmXDispatchInterceptorImpl which forwarded this request should be m_pExternalViewInterceptor, and this interceptor
//STRIP001 /*?*/ 				// should have ID 1 ...
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ #if DBG_UTIL
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				DBG_ASSERT(_nId == 0, "FmXFormShell::queryDispatch : where did this came from ?");
//STRIP001 /*?*/ 				// the FmXDispatchInterceptorImpl which forwarded this request should be m_pMainFrameInterceptor, and this interceptor
//STRIP001 /*?*/ 				// should have ID 0 ...
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ #endif
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// get the form the dispatcher is requested for
//STRIP001 /*?*/ 			// first the page id
//STRIP001 /*?*/ 			String sOriginalPathWithPagePrefix = sAccessPath;
//STRIP001 /*?*/ 			xub_StrLen nSepPos = sAccessPath.Search('\\');
//STRIP001 /*?*/ 			DBG_ASSERT(nSepPos != STRING_NOTFOUND, "FmXFormShell::queryDispatch : invalid URL mark (no page prefix) !");
//STRIP001 /*?*/ 			sPageId = sAccessPath.Copy(0, nSepPos);
//STRIP001 /*?*/ 			sAccessPath = sAccessPath.Copy(nSepPos + 1, STRING_LEN);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// from this id the forms collection and the form
//STRIP001 /*?*/ 			Reference< XIndexAccess> xPageForms(GetPageForms(sPageId), UNO_QUERY);
//STRIP001 /*?*/ 			Reference< XResultSet> xAffectedForm(getElementFromAccessPath(xPageForms, UniString(sAccessPath)), UNO_QUERY);
//STRIP001 /*?*/ 			DBG_ASSERT(xAffectedForm.is(), "FmXFormShell::queryDispatch : could not retrieve a form for the request !");
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< XPropertySet> xFormProps(xAffectedForm, UNO_QUERY);
//STRIP001 /*?*/ 			NavigationBarMode eMode = NavigationBarMode_CURRENT;
//STRIP001 /*?*/ 			if	(	!xFormProps.is()
//STRIP001 /*?*/ 				||	!( xFormProps->getPropertyValue( FM_PROP_NAVIGATION ) >>= eMode )
//STRIP001 /*?*/ 				||	( NavigationBarMode_CURRENT != eMode )
//STRIP001 /*?*/ 				)
//STRIP001 /*?*/ 			{	// we can't supply a dispatcher for that : else we would have to listen to all operations on the parent
//STRIP001 /*?*/ 				// form and to all ops on the affected form itself, just to keep the state up-to-date. This would be too much to do ...
//STRIP001 /*?*/ 				// 73233 - 22.02.00 - FS
//STRIP001 /*?*/ 				return Reference< ::com::sun::star::frame::XDispatch>();
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			// get the dispatcher array for the form
//STRIP001 /*?*/ 			SingleFormDispatchers& aDispatchers = m_aNavigationDispatcher[sMark];
//STRIP001 /*?*/ 				// the [] operator will create a new one if it didn't exist before
//STRIP001 /*?*/ 			if (!aDispatchers.size())
//STRIP001 /*?*/ 			{	// it was a new one -> fill it with initial NULL values
//STRIP001 /*?*/ 				for (sal_Int16 j=0; j<sizeof(sFormNavUrls)/sizeof(sFormNavUrls[0]); ++j)
//STRIP001 /*?*/ 					aDispatchers.insert(aDispatchers.begin(), (FmFormNavigationDispatcher*)NULL);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			FmFormNavigationDispatcher*& pRequestedDispatcher = aDispatchers[i];
//STRIP001 /*?*/ 			if (!pRequestedDispatcher)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				// nobody requested a dispatcher for this form and this slot before -> create a new one
//STRIP001 /*?*/ 				m_pShell->GetViewShell()->GetViewFrame()->GetBindings().DENTERREGISTRATIONS();
//STRIP001 /*?*/ 				pRequestedDispatcher = new FmFormNavigationDispatcher(aURL, nAccordingSlots[i], m_pShell->GetViewShell()->GetViewFrame()->GetBindings(), xAffectedForm, sOriginalPathWithPagePrefix);
//STRIP001 /*?*/ 				m_pShell->GetViewShell()->GetViewFrame()->GetBindings().DLEAVEREGISTRATIONS();
//STRIP001 /*?*/ 				DBG_ASSERT(((sPageId += '\\') += sAccessPath) == GetAccessPathFromForm(xAffectedForm, GetPageId(xAffectedForm)),
//STRIP001 /*?*/ 					"FmXFormShell::queryDispatch : hmmm ... what does this access path mean ?");
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				pRequestedDispatcher->acquire();
//STRIP001 /*?*/ 				pRequestedDispatcher->setExecutor(LINK(this, FmXFormShell, OnExecuteNavSlot));
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			Reference< XResultSet> xNavigationForm;
//STRIP001 /*?*/ 			if (m_xNavigationController.is())
//STRIP001 /*?*/ 				xNavigationForm = Reference< XResultSet>(m_xNavigationController->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 			// xNavigationForm is the form which our navigation bar belongs to
//STRIP001 /*?*/ 			// activate the new dispatcher if (and only if) it belongs to the same form
//STRIP001 /*?*/ 			if (xAffectedForm == xNavigationForm)
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pRequestedDispatcher->SetActive(sal_True);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 			else
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				pRequestedDispatcher->SetActive(sal_False);
//STRIP001 /*?*/ 				UpdateFormDispatcher(pRequestedDispatcher);
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			return (::com::sun::star::frame::XDispatch*)pRequestedDispatcher;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	return Reference< ::com::sun::star::frame::XDispatch>();
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::formActivated(const EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(rEvent.Source == m_xExternalViewController, "FmXFormShell::formActivated : where did this come from ?");
//STRIP001 	setActiveController(Reference< XFormController>(rEvent.Source, UNO_QUERY));
/*?*/ }

//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::formDeactivated(const EventObject& rEvent) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(rEvent.Source == m_xExternalViewController, "FmXFormShell::formDeactivated : where did this come from ?");
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::disposing()
/*N*/ {
/*N*/ 	FmXFormShell_BASE::disposing();
/*N*/ 
/*N*/ 	if ( m_pShell && !m_pShell->IsDesignMode() )
/*N*/ 		setActiveController( NULL, sal_True );
/*N*/ 		// do NOT save the content of the old form (the second parameter tells this)
/*N*/ 		// if we're here, then we expect that PrepareClose has been called, and thus the user
/*N*/ 		// got a chance to commit or reject any changes. So in case we're here and the there
/*N*/ 		// are still uncommitted changes, the user explicitly wanted this.
/*N*/ 		// 2002-11-11 - 104702 - fs@openoffice.org
/*N*/ 
/*N*/ 	// dispose our interceptor helpers
/*N*/ 	if (m_pMainFrameInterceptor)
/*N*/ 	{
/*N*/ 		m_pMainFrameInterceptor->dispose();
/*N*/ 		m_pMainFrameInterceptor->release();
/*N*/ 		m_pMainFrameInterceptor = NULL;
/*N*/ 	}
/*N*/ 	if (m_pExternalViewInterceptor)
/*N*/ 	{
/*?*/ 		m_pExternalViewInterceptor->dispose();
/*?*/ 		m_pExternalViewInterceptor->release();
/*?*/ 		m_pExternalViewInterceptor = NULL;
/*N*/ 	}
/*N*/ 
/*N*/ 	m_xAttachedFrame = NULL;
/*N*/ 
/*N*/ 	CloseExternalFormViewer();
/*N*/ 
/*N*/ 	while ( m_aLoadingPages.size() )
/*N*/ 	{
/*?*/ 		Application::RemoveUserEvent( m_aLoadingPages.front().nEventId );
/*?*/ 		m_aLoadingPages.pop();
/*N*/ 	}
/*N*/ 
/*N*/ 	// dispose all our navigation dispatchers
/*N*/ 	for (	FormsDispatchersIterator aFormIter = m_aNavigationDispatcher.begin();
/*N*/ 			aFormIter != m_aNavigationDispatcher.end();
/*N*/ 			++aFormIter
/*N*/ 		)
/*N*/ 	{
/*?*/ 		for (	SingleFormDispatchersIterator aDispIter = (*aFormIter).second.begin();
/*?*/ 				aDispIter < (*aFormIter).second.end();
/*?*/ 				++aDispIter
/*?*/ 			)
/*?*/ 		{
/*?*/ 			FmFormNavigationDispatcher* pCurDispatcher = *aDispIter;
/*?*/ 			if (pCurDispatcher)
/*?*/ 			{
/*?*/ 				pCurDispatcher->dispose();
/*?*/ 				pCurDispatcher->release();
/*?*/ 				*aDispIter = NULL;
/*?*/ 			}
/*N*/ 		}
/*N*/ 	}
/*N*/ 	m_aNavigationDispatcher.clear();
/*N*/ 
/*N*/ 	{
/*N*/ 		::osl::MutexGuard aGuard(m_aInvalidationSafety);
/*N*/ 		if (m_nInvalidationEvent)
/*N*/ 		{
/*?*/ 			Application::RemoveUserEvent(m_nInvalidationEvent);
/*?*/ 			m_nInvalidationEvent = 0;
/*N*/ 		}
/*N*/ 	}
/*N*/ 
/*N*/ 	{
/*N*/ 		::osl::ClearableMutexGuard aGuard(m_aAsyncSafety);
/*N*/ 		if (HasAnyPendingCursorAction())
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			CancelAnyPendingCursorAction();
/*N*/ 		aGuard.clear();
/*N*/ 
/*N*/ 		DBG_ASSERT(!m_nInvalidationEvent, "FmXFormShell::~FmXFormShell : still have an invalidation event !");
/*N*/ 			// should habe been deleted while beeing disposed
/*N*/ 
/*N*/ 		m_aMarkTimer.Stop();
/*N*/ 	}
/*N*/ 
/*N*/ 	// we are disposed from within the destructor of our shell, so now the shell pointer is invalid ....
/*N*/ 	m_pShell					= NULL;
/*N*/ 	m_xActiveController 		= NULL;
/*N*/ 	m_xNavigationController 	= NULL;
/*N*/ 	m_xActiveForm				= NULL;
/*N*/ 	m_xParser					= NULL;
/*N*/ 	m_xForms					= NULL;
/*N*/ 	m_xSelObject				= NULL;
/*N*/ 	m_xCurControl				= NULL;
/*N*/ 	m_xCurForm					= NULL;
/*N*/ 	m_xLastGridFound			= NULL;
/*N*/ 	m_xAttachedFrame			= NULL;
/*N*/ 	m_xExternalViewController	= NULL;
/*N*/ 	m_xExtViewTriggerController = NULL;
/*N*/ 	m_xExternalDisplayedForm	= NULL;
/*N*/ 	m_xLastGridFound			= NULL;
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::InvalidateSlot(sal_Int16 nId, sal_Bool bWithItem, sal_Bool bWithId)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(m_aInvalidationSafety);
//STRIP001 	if (m_nLockSlotInvalidation)
//STRIP001 	{
//STRIP001 		m_arrInvalidSlots.Insert(nId, m_arrInvalidSlots.Count());
//STRIP001 		BYTE nFlags = (bWithItem ? 0x02 :0) + (bWithId ? 0x01 : 0);
//STRIP001 		m_arrInvalidSlots_Flags.Insert(nFlags, m_arrInvalidSlots_Flags.Count());
//STRIP001 	}
//STRIP001 	else
//STRIP001 		if (nId)
//STRIP001 			m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(nId, bWithItem, bWithId);
//STRIP001 		else
//STRIP001 			m_pShell->GetViewShell()->GetViewFrame()->GetBindings().InvalidateShell(*m_pShell);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::LockSlotInvalidation(sal_Bool bLock)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(m_aInvalidationSafety);
//STRIP001 	DBG_ASSERT(bLock || m_nLockSlotInvalidation>0, "FmXFormShell::LockSlotInvalidation : invalid call !");
//STRIP001 
//STRIP001 	if (bLock)
//STRIP001 		++m_nLockSlotInvalidation;
//STRIP001 	else if (!--m_nLockSlotInvalidation)
//STRIP001 	{
//STRIP001 		// alles, was sich waehrend der gelockten Phase angesammelt hat, (asynchron) invalidieren
//STRIP001 		if (!m_nInvalidationEvent)
//STRIP001 			m_nInvalidationEvent = Application::PostUserEvent(LINK(this, FmXFormShell, OnInvalidateSlots));
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnInvalidateSlots, void*, EMPTYARG)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(m_aInvalidationSafety);
//STRIP001 	m_nInvalidationEvent = 0;
//STRIP001 
//STRIP001 	DBG_ASSERT(m_arrInvalidSlots.Count() == m_arrInvalidSlots_Flags.Count(),
//STRIP001 		"FmXFormShell::OnInvalidateSlots : inconsistent slot arrays !");
//STRIP001 	BYTE nFlags;
//STRIP001 	for (sal_Int16 i=0; i<m_arrInvalidSlots.Count(); ++i)
//STRIP001 	{
//STRIP001 		nFlags = m_arrInvalidSlots_Flags[i];
//STRIP001 
//STRIP001 		if (m_arrInvalidSlots[i])
//STRIP001 			m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(m_arrInvalidSlots[i], (nFlags & 0x02), (nFlags & 0x01));
//STRIP001 		else
//STRIP001 			m_pShell->GetViewShell()->GetViewFrame()->GetBindings().InvalidateShell(*m_pShell);
//STRIP001 	}
//STRIP001 
//STRIP001 	m_arrInvalidSlots.Remove(0, m_arrInvalidSlots.Count());
//STRIP001 	m_arrInvalidSlots_Flags.Remove(0, m_arrInvalidSlots_Flags.Count());
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::ForceUpdateSelection(sal_Bool bAllowInvalidation)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (IsSelectionUpdatePending())
//STRIP001 	{
//STRIP001 		m_aMarkTimer.Stop();
//STRIP001 
//STRIP001 		// die Invalidierung der Slots, die implizit von SetSelection besorgt wird, eventuell abschalten
//STRIP001 		if (!bAllowInvalidation)
//STRIP001 			LockSlotInvalidation(sal_True);
//STRIP001 
//STRIP001 		SetSelection(m_pShell->GetFormView()->GetMarkList());
//STRIP001 
//STRIP001 		if (!bAllowInvalidation)
//STRIP001 			LockSlotInvalidation(sal_False);
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 PopupMenu* FmXFormShell::GetConversionMenu()
//STRIP001 {
//STRIP001 	const StyleSettings& rSettings = Application::GetSettings().GetStyleSettings();
//STRIP001 	BOOL bIsHiContrastMode	= rSettings.GetMenuColor().IsDark();
//STRIP001 
//STRIP001 	PopupMenu* pNewMenu = new PopupMenu(SVX_RES( RID_FMSHELL_CONVERSIONMENU ));
//STRIP001 
//STRIP001 	ImageList aImageList( SVX_RES( bIsHiContrastMode ? RID_SVXIMGLIST_FMEXPL_HC : RID_SVXIMGLIST_FMEXPL) );
//STRIP001 	for (int i=0; i<sizeof(nConvertSlots)/sizeof(nConvertSlots[0]); ++i)
//STRIP001 	{
//STRIP001 		// das entsprechende Image dran
//STRIP001 		pNewMenu->SetItemImage(nConvertSlots[i], aImageList.GetImage(nCreateSlots[i]));
//STRIP001 	}
//STRIP001 
//STRIP001 	return pNewMenu;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::IsControlConversionSlot(sal_uInt16 nSlotId)
//STRIP001 {
//STRIP001 	for (int i=0; i<sizeof(nConvertSlots)/sizeof(nConvertSlots[0]); ++i)
//STRIP001 		if (nConvertSlots[i] == nSlotId)
//STRIP001 			return sal_True;
//STRIP001 	return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::ExecuteControlConversionSlot(const Reference< XFormComponent>& xContext, sal_uInt16 nSlotId)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	for (int i=0; i<sizeof(nConvertSlots)/sizeof(nConvertSlots[0]); ++i)
//STRIP001 	{
//STRIP001 		if (nConvertSlots[i] == nSlotId)
//STRIP001 			return ConvertControlTo(xContext, nObjectTypes[i]);
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::IsConversionPossible(const Reference< XPropertySet>& xContext, sal_Int16 nConversionSlot)
//STRIP001 {
//STRIP001 	Reference< XServiceInfo> xInfo(xContext, UNO_QUERY);
//STRIP001 	if (!xInfo.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	sal_Int16 nObjectType = getControlTypeByObject(xInfo);
//STRIP001 
//STRIP001 	if ((OBJ_FM_HIDDEN == nObjectType) || (OBJ_FM_CONTROL == nObjectType) || (OBJ_FM_GRID == nObjectType))
//STRIP001 		return sal_False;	// hiddens koennen nicht konvertiert werden
//STRIP001 
//STRIP001 	DBG_ASSERT(sizeof(nConvertSlots)/sizeof(nConvertSlots[0]) == sizeof(nObjectTypes)/sizeof(nObjectTypes[0]),
//STRIP001 		"FmXFormShell::IsConversionPossible : nConvertSlots & nObjectTypes must have the same size !");
//STRIP001 
//STRIP001 	for (sal_Int16 i=0; i<sizeof(nConvertSlots)/sizeof(nConvertSlots[0]); ++i)
//STRIP001 		if (nConvertSlots[i] == nConversionSlot)
//STRIP001 			return nObjectTypes[i] != nObjectType;
//STRIP001 
//STRIP001 	return sal_True;	// alle anderen Slots nehmen wir als gueltig an
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::CheckControlConversionSlots(const Reference< XPropertySet>& xContext, Menu& rMenu)
//STRIP001 {
//STRIP001 	for (sal_Int16 i=0; i<rMenu.GetItemCount(); ++i)
//STRIP001 		// der Context ist schon von einem Typ, der dem Eitnrag entspricht -> disable
//STRIP001 		rMenu.EnableItem(rMenu.GetItemId(i), IsConversionPossible(xContext, rMenu.GetItemId(i)));
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::ConvertControlTo(const Reference< XFormComponent>& xModel, sal_uInt16 nTargetObjectId)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (!xModel.is())
//STRIP001 		// das wuerde ausser einem Performance-Verlust nix machen, aber trotzdem ...
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	FmFormPage* pCurrentPage = m_pShell->GetCurPage();
//STRIP001 
//STRIP001 	SdrUnoObj* pFound = NULL;
//STRIP001 	for (sal_uInt32 i=0; i<pCurrentPage->GetObjCount(); ++i)
//STRIP001 	{
//STRIP001 		SdrObject* pCurrent = pCurrentPage->GetObj(i);
//STRIP001 
//STRIP001 		// wenn das Ding eine Gruppierung ist -> durchiterieren
//STRIP001 		SdrObjListIter* pGroupIterator = NULL;
//STRIP001 		if (pCurrent->IsGroupObject())
//STRIP001 		{
//STRIP001 			pGroupIterator = new SdrObjListIter(*pCurrent->GetSubList());
//STRIP001 			pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		while (pCurrent)
//STRIP001 		{
//STRIP001 			if (pCurrent->IsUnoObj())
//STRIP001 			{
//STRIP001 				Reference< XFormComponent> xCurrent(((SdrUnoObj*)pCurrent)->GetUnoControlModel(), UNO_QUERY);
//STRIP001 				if ((XFormComponent*)xCurrent.get() == (XFormComponent*)xModel.get())
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pGroupIterator) 	// ich iteriere gerade durch eine Gruppe von Controls
//STRIP001 				pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
//STRIP001 			else
//STRIP001 				pCurrent = NULL;
//STRIP001 		}
//STRIP001 		delete pGroupIterator;
//STRIP001 
//STRIP001 		if (pCurrent)
//STRIP001 		{
//STRIP001 			pFound = (SdrUnoObj*)pCurrent;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!pFound)
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	::rtl::OUString uNewName(getServiceNameByControlType(nTargetObjectId));
//STRIP001 	Reference< XControlModel> xNewModel(::legacy_binfilters::getLegacyProcessServiceFactory()->createInstance(uNewName), UNO_QUERY);
//STRIP001 	if (!xNewModel.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XControlModel> xOldModel(pFound->GetUnoControlModel());
//STRIP001 	Reference< XServiceInfo> xModelInfo(xOldModel, UNO_QUERY);
//STRIP001 	sal_Int16 nOldModelType = xModelInfo.is() ? getControlTypeByObject(xModelInfo) : OBJ_FM_CONTROL;
//STRIP001 
//STRIP001 	// Properties uebertragen
//STRIP001 	Reference< XPropertySet> xOldSet(xOldModel, UNO_QUERY);
//STRIP001 	Reference< XPropertySet> xNewSet(xNewModel, UNO_QUERY);
//STRIP001 
//STRIP001 	
//STRIP001 	Locale aNewLanguage = Application::GetSettings().GetUILocale();
//STRIP001 	TransferFormComponentProperties(xOldSet, xNewSet, aNewLanguage);
//STRIP001 
//STRIP001 	Sequence< ::com::sun::star::script::ScriptEventDescriptor> aOldScripts;
//STRIP001 	Reference< XChild> xChild(xOldModel, UNO_QUERY);
//STRIP001 	if (xChild.is())
//STRIP001 	{
//STRIP001 		Reference< XIndexAccess> xParent(xChild->getParent(), UNO_QUERY);
//STRIP001 
//STRIP001 		// remember old script events
//STRIP001 		Reference< ::com::sun::star::script::XEventAttacherManager> xEvManager(xChild->getParent(), UNO_QUERY);
//STRIP001 		if (xParent.is() && xEvManager.is())
//STRIP001 		{
//STRIP001 			sal_Int32 nIndex = getElementPos(xParent, xOldModel);
//STRIP001 			if (nIndex>=0 && nIndex<xParent->getCount())
//STRIP001 				aOldScripts = xEvManager->getScriptEvents(nIndex);
//STRIP001 		}
//STRIP001 
//STRIP001 		// replace the mdoel within the parent container
//STRIP001 		Reference< XIndexContainer> xIndexParent(xChild->getParent(), UNO_QUERY);   //Modified by BerryJia for fixing Bug102516 Time(China):2002-9-5 16:00
//STRIP001 		if (xIndexParent.is())
//STRIP001 		{
//STRIP001 			// the form container works with FormComponents
//STRIP001 			Reference< XFormComponent> xComponent(xNewModel, UNO_QUERY);
//STRIP001 			DBG_ASSERT(xComponent.is(), "FmXFormShell::ConvertControlTo : the new model is no form component !");
//STRIP001 			Any aNewModel(makeAny(xComponent));
//STRIP001 			try
//STRIP001 			{
//STRIP001 				//Modified by BerryJia for fixing Bug102516 Time(China):2002-9-5 16:00
//STRIP001 				sal_Int32 nIndex = getElementPos(xParent, xOldModel);
//STRIP001 				if (nIndex>=0 && nIndex<xParent->getCount())
//STRIP001 					xIndexParent->replaceByIndex(nIndex, aNewModel);
//STRIP001 				else
//STRIP001 				{
//STRIP001 					DBG_ERROR("FmXFormShell::ConvertControlTo : could not replace the model !");
//STRIP001 					Reference< ::com::sun::star::lang::XComponent> xNewComponent(xNewModel, UNO_QUERY);
//STRIP001 					if (xNewComponent.is())
//STRIP001 						xNewComponent->dispose();
//STRIP001 					return sal_False;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			catch(Exception&)
//STRIP001 			{
//STRIP001 				DBG_ERROR("FmXFormShell::ConvertControlTo : could not replace the model !");
//STRIP001 				Reference< ::com::sun::star::lang::XComponent> xNewComponent(xNewModel, UNO_QUERY);
//STRIP001 				if (xNewComponent.is())
//STRIP001 					xNewComponent->dispose();
//STRIP001 				return sal_False;
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// special handling for the LabelControl-property : can only be set when the model is placed
//STRIP001 	// within the forms hierarchy
//STRIP001 	if (::comphelper::hasProperty(FM_PROP_CONTROLLABEL, xOldSet) && ::comphelper::hasProperty(FM_PROP_CONTROLLABEL, xNewSet))
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			xNewSet->setPropertyValue(FM_PROP_CONTROLLABEL, xOldSet->getPropertyValue(FM_PROP_CONTROLLABEL));
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	// neues Model setzen
//STRIP001 	pFound->SetChanged();
//STRIP001 	pFound->SetUnoControlModel(xNewModel);
//STRIP001 
//STRIP001 	// transfer script events
//STRIP001 	// (do this _after_ SetUnoControlModel as we need the new (implicitly created) control)
//STRIP001 	if (aOldScripts.getLength())
//STRIP001 	{
//STRIP001 		// das Control zum Model suchen
//STRIP001 		SdrPageView* pPageView = m_pShell->GetFormView()->GetPageViewPvNum(0);
//STRIP001 		DBG_ASSERT(pPageView->GetWinList().GetCount() > 0, "FmXFormShell::ConvertControlTo : no SdrPageViewWinRecs");
//STRIP001 		const SdrPageViewWinRec& rViewWinRec = pPageView->GetWinList()[0];
//STRIP001 		Reference< XControlContainer> xControlContainer(rViewWinRec.GetControlContainerRef());
//STRIP001 
//STRIP001 		Sequence< Reference< XControl> > aControls( xControlContainer->getControls() );
//STRIP001 		const Reference< XControl>* pControls = aControls.getConstArray();
//STRIP001 
//STRIP001 		sal_uInt32 nLen = aControls.getLength();
//STRIP001 		Reference< XControl> xControl;
//STRIP001 		for (sal_uInt32 i=0 ; i<nLen; ++i)
//STRIP001 		{
//STRIP001 			if (pControls[i]->getModel() == xNewModel)
//STRIP001 			{
//STRIP001 				xControl = pControls[i];
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		TransferEventScripts(xNewModel, xControl, aOldScripts);
//STRIP001 	}
//STRIP001 
//STRIP001 	// create an undo action
//STRIP001 	FmFormModel* pModel = m_pShell->GetFormModel();
//STRIP001 	DBG_ASSERT(pModel != NULL, "FmXFormShell::ConvertControlTo : my shell has no model !");
//STRIP001 	if (pModel)
//STRIP001 		pModel->AddUndo(new FmUndoModelReplaceAction(*pModel, pFound, xOldModel));
//STRIP001 
//STRIP001 	return sal_True;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::LoopGrids(sal_Int16 nWhat)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XIndexContainer> xControlModels(m_xActiveForm, UNO_QUERY);
//STRIP001 	if (xControlModels.is())
//STRIP001 		for (sal_Int16 i=0; i<xControlModels->getCount(); ++i)
//STRIP001 		{
//STRIP001 			Reference< XPropertySet> xModelSet;
//STRIP001 			xControlModels->getByIndex(i) >>= xModelSet;
//STRIP001 			if (!xModelSet.is())
//STRIP001 				continue;
//STRIP001 
//STRIP001 			if (!::comphelper::hasProperty(FM_PROP_CLASSID, xModelSet))
//STRIP001 				continue;
//STRIP001 			sal_Int16 nClassId = ::comphelper::getINT16(xModelSet->getPropertyValue(FM_PROP_CLASSID));
//STRIP001 			if (FormComponentType::GRIDCONTROL != nClassId)
//STRIP001 				continue;
//STRIP001 
//STRIP001 			if (!::comphelper::hasProperty(FM_PROP_CURSORCOLOR, xModelSet) || !::comphelper::hasProperty(FM_PROP_ALWAYSSHOWCURSOR, xModelSet) || !::comphelper::hasProperty(FM_PROP_DISPLAYSYNCHRON, xModelSet))
//STRIP001 				continue;
//STRIP001 
//STRIP001 			switch (nWhat & GA_SYNC_MASK)
//STRIP001 			{
//STRIP001 				case GA_DISABLE_SYNC:
//STRIP001 					{
//STRIP001 						sal_Bool bB(sal_False);
//STRIP001 						xModelSet->setPropertyValue(FM_PROP_DISPLAYSYNCHRON, Any(&bB,getBooleanCppuType()));
//STRIP001 					}
//STRIP001 					break;
//STRIP001 				case GA_FORCE_SYNC:
//STRIP001 				{
//STRIP001 					Any aOldVal( xModelSet->getPropertyValue(FM_PROP_DISPLAYSYNCHRON) );
//STRIP001 					sal_Bool bB(sal_True);
//STRIP001 					xModelSet->setPropertyValue(FM_PROP_DISPLAYSYNCHRON, Any(&bB,getBooleanCppuType()));
//STRIP001 					xModelSet->setPropertyValue(FM_PROP_DISPLAYSYNCHRON, aOldVal);
//STRIP001 				}
//STRIP001 				break;
//STRIP001 				case GA_ENABLE_SYNC:
//STRIP001 					{
//STRIP001 						sal_Bool bB(sal_True);
//STRIP001 						xModelSet->setPropertyValue(FM_PROP_DISPLAYSYNCHRON, Any(&bB,getBooleanCppuType()));
//STRIP001 					}
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			if (nWhat & GA_DISABLE_ROCTRLR)
//STRIP001 			{
//STRIP001 				sal_Bool bB(sal_False);
//STRIP001 				xModelSet->setPropertyValue(FM_PROP_ALWAYSSHOWCURSOR, Any(&bB,getBooleanCppuType()));
//STRIP001 				Reference< XPropertyState> xModelPropState(xModelSet, UNO_QUERY);
//STRIP001 				if (xModelPropState.is())
//STRIP001 					xModelPropState->setPropertyToDefault(FM_PROP_CURSORCOLOR);
//STRIP001 				else
//STRIP001 					xModelSet->setPropertyValue(FM_PROP_CURSORCOLOR, Any());		// this should be the default
//STRIP001 			}
//STRIP001 			else if (nWhat & GA_ENABLE_ROCTRLR)
//STRIP001 			{
//STRIP001 				sal_Bool bB(sal_True);
//STRIP001 				xModelSet->setPropertyValue(FM_PROP_ALWAYSSHOWCURSOR, Any(&bB,getBooleanCppuType()));
//STRIP001 				xModelSet->setPropertyValue(FM_PROP_CURSORCOLOR, makeAny(sal_Int32(COL_LIGHTRED)));
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 /*	// alle Controls der Page durchiterieren und nach GridControls suchen ...
//STRIP001 	SdrPageView* pCurPageView = m_pShell->GetFormView()->GetPageViewPvNum(0);
//STRIP001 	// deren ViewWinRec-Liste, daraus das erste Element
//STRIP001 	DBG_ASSERT(pCurPageView->GetWinList().GetCount() > 0, "FmXFormShell::LoopGrids : unexpected : no SdrPageViewWinRecs");
//STRIP001 	const SdrPageViewWinRec& rViewWinRec = pCurPageView->GetWinList()[0];
//STRIP001 	// von dem bekomme ich alle Controls ...
//STRIP001 	Reference< XControlContainer> xControlContainer( rViewWinRec.GetControlContainerRef());
//STRIP001 	Sequence< Reference< XControl> > seqControls = xControlContainer->getControls();
//STRIP001 	const Reference< XControl>* pControls = seqControls.getConstArray();
//STRIP001 	// ... die ich dann durchsuchen kann
//STRIP001 	for (int i=0; i<seqControls.getLength(); ++i)
//STRIP001 	{
//STRIP001 		Reference<XGridPeer> xGridPeer(pControls[i]->getPeer(), UNO_QUERY);
//STRIP001 		if (!xGridPeer.is())
//STRIP001 			continue;
//STRIP001 
//STRIP001 		FmXGridPeer* pPeer = (FmXGridPeer*)xGridPeer->getImplementation(FmXGridPeer_getReflection());
//STRIP001 		if (!pPeer)
//STRIP001 			continue;
//STRIP001 
//STRIP001 		FmGridControl* pGrid = (FmGridControl*)pPeer->GetWindow();
//STRIP001 		// what to do ?
//STRIP001 		// display synchronisation ?
//STRIP001 		switch (nWhat & GA_SYNC_MASK)
//STRIP001 		{
//STRIP001 			case GA_DISABLE_SYNC:
//STRIP001 				pGrid->setDisplaySynchron(sal_False); break;
//STRIP001 			case GA_FORCE_SYNC:
//STRIP001 				pGrid->forceSyncDisplay(); break;
//STRIP001 			case GA_ENABLE_SYNC:
//STRIP001 				pGrid->setDisplaySynchron(sal_True); break;
//STRIP001 		}
//STRIP001 
//STRIP001 		if (nWhat & GA_DISABLE_ROCTRLR)
//STRIP001 			pGrid->forceROController(sal_False);
//STRIP001 		else if (nWhat & GA_ENABLE_ROCTRLR)
//STRIP001 			pGrid->forceROController(sal_True);
//STRIP001 	}
//STRIP001 */
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::ExecuteSearch()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	UniString sTestContexts;
//STRIP001 	//	m_arrSearchContexts.Remove(0, m_arrSearchContexts.Count());
//STRIP001 	m_arrSearchContexts.clear();
//STRIP001 
//STRIP001 	// eine Sammlung aller (logischen) Formulare
//STRIP001 	Reference< XInterface> xAllForms(m_pShell->GetCurPage()->GetForms(),UNO_QUERY);
//STRIP001 	//	::fml::convertIFace((XInterface*),xAllForms);
//STRIP001 	CollectFormContexts(xAllForms, String(), sTestContexts);
//STRIP001 	sTestContexts.EraseLeadingChars(';');
//STRIP001 
//STRIP001 	// hier sind jetzt dummerweise noch alle Forms drin, die ueberhaupt keine gueltigen Controls enthalten
//STRIP001 	// um das auszufiltern, benutze ich einfach meinen OnSearchContextRequest-Handler, der genau die gueltigen Controls einer Form sammelt
//STRIP001 	FmFormArray::reverse_iterator aIter = m_arrSearchContexts.rbegin();
//STRIP001 	sal_Int32 i = m_arrSearchContexts.size();
//STRIP001 	for (; aIter != m_arrSearchContexts.rend(); ++aIter,i--)
//STRIP001 	{
//STRIP001 		FmSearchContext fmscTest;
//STRIP001 		fmscTest.nContext = i-1;
//STRIP001 		sal_uInt32 lValidControls = LINK(this, FmXFormShell, OnSearchContextRequest).Call(&fmscTest);
//STRIP001 		if (lValidControls == 0)
//STRIP001 		{
//STRIP001 			m_arrSearchContexts.erase(aIter.base()-1);
//STRIP001 			sTestContexts.SetToken(i-1, ';', String());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// jetzt enthaelt die Context-Liste noch ein paar Leer-Token
//STRIP001 	UniString strRealContexts,strCurrentToken;
//STRIP001 	for (xub_StrLen j=0; j<sTestContexts.GetTokenCount(';'); ++j)
//STRIP001 	{
//STRIP001 		strCurrentToken = sTestContexts.GetToken(j);
//STRIP001 		if (strCurrentToken.Len() != 0)
//STRIP001 		{
//STRIP001 			strRealContexts += ';';
//STRIP001 			strRealContexts += strCurrentToken;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	strRealContexts.EraseLeadingChars(';');
//STRIP001 
//STRIP001 	if (m_arrSearchContexts.size() == 0)
//STRIP001 	{	// es gibt keine Controls, die alle Bedingungen fuer eine Suche erfuellen
//STRIP001 		ErrorBox(NULL, WB_OK, SVX_RESSTR(RID_STR_NODATACONTROLS)).Execute();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// jetzt brauche ich noch einen 'initial context'
//STRIP001 	sal_Int16 nInitialContext = 0;
//STRIP001 	Reference< XForm> xActiveForm( getActiveForm());
//STRIP001 	for (i=0; i<(sal_Int32)m_arrSearchContexts.size(); ++i)
//STRIP001 	{
//STRIP001 		if (m_arrSearchContexts.at(i) == xActiveForm)
//STRIP001 		{
//STRIP001 			nInitialContext = (sal_Int16)i;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// wenn der Dialog initial den Text des aktiven Controls anbieten soll, muss dieses ein XTextComponent-Interface habe,
//STRIP001 	// ausserdem macht das nur Sinn, wenn das aktuelle Feld auch an ein Tabellen- (oder was-auch-immer-)Feld gebunden ist
//STRIP001 	UniString strActiveField;
//STRIP001 	UniString strInitialText;
//STRIP001 	// ... das bekomme ich von meinem FormController
//STRIP001 	DBG_ASSERT(m_xActiveController.is(), "FmXFormShell::ExecuteSearch : no active controller !");
//STRIP001 	Reference< XControl> xActiveControl( m_xActiveController->getCurrentControl());
//STRIP001 	if (xActiveControl.is())
//STRIP001 	{
//STRIP001 		// das Control kann mir sein Model sagen ...
//STRIP001 		Reference< XControlModel> xActiveModel( xActiveControl->getModel());
//STRIP001 		DBG_ASSERT(xActiveModel.is(), "FmXFormShell::ExecuteSearch : active control has no model !");
//STRIP001 
//STRIP001 		// das Model frage ich nach der ControlSource-Eigenschaft ...
//STRIP001 		Reference< XPropertySet> xProperties(xActiveControl->getModel(), UNO_QUERY);
//STRIP001 		if (::comphelper::hasProperty(FM_PROP_CONTROLSOURCE, xProperties) && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xProperties))
//STRIP001 		{
//STRIP001 			Reference< XPropertySet> xField;
//STRIP001 			xProperties->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 			if (xField.is())	// (nur wenn das Ding wirklich gebunden ist)
//STRIP001 			{
//STRIP001 				// und das Control selber nach einem TextComponent-Interface (damit ich mir dort den Text abholen kann)
//STRIP001 				Reference< XTextComponent> xText(xActiveControl, UNO_QUERY);
//STRIP001 				if (xText.is())
//STRIP001 				{
//STRIP001 					strActiveField = getLabelName(xProperties).getStr();
//STRIP001 					strInitialText = xText->getText().getStr();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// das Control selber hat keine ControlSource, aber vielleicht ist es ein GridControl
//STRIP001 			Reference< XGrid> xGrid(xActiveControl, UNO_QUERY);
//STRIP001 			if (xGrid.is())
//STRIP001 			{
//STRIP001 				// fuer strActiveField brauche ich die die ControlSource der Column, dafuer den Columns-Container, dafuer die
//STRIP001 				// GridPeer
//STRIP001 				Reference< XGridPeer> xGridPeer(xActiveControl->getPeer(), UNO_QUERY);
//STRIP001 				Reference< XIndexAccess> xColumns;
//STRIP001 				if (xGridPeer.is())
//STRIP001 					xColumns = Reference< XIndexAccess>(xGridPeer->getColumns(),UNO_QUERY);
//STRIP001 
//STRIP001 				sal_Int16 nViewCol = xGrid->getCurrentColumnPosition();
//STRIP001 				sal_Int16 nModelCol = GridView2ModelPos(xColumns, nViewCol);
//STRIP001 				Reference< XPropertySet> xCurrentCol;
//STRIP001 				if(xColumns.is())
//STRIP001 					xColumns->getByIndex(nModelCol) >>= xCurrentCol;
//STRIP001 				if (xCurrentCol.is())
//STRIP001 					strActiveField = ::comphelper::getString(xCurrentCol->getPropertyValue(FM_PROP_LABEL)).getStr();
//STRIP001 
//STRIP001 				// the text fo the current column
//STRIP001 				Reference< XIndexAccess> xColControls(xGridPeer, UNO_QUERY);
//STRIP001 				Reference< XInterface> xCurControl;
//STRIP001 				xColControls->getByIndex(nViewCol) >>= xCurControl;
//STRIP001 				::rtl::OUString sInitialText;
//STRIP001 				if (IsSearchableControl(xCurControl, &sInitialText))
//STRIP001 					strInitialText = sInitialText.getStr();
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// um eventuelle GridControls, die ich kenne, kuemmern
//STRIP001 	LoopGrids(GA_DISABLE_SYNC /*| GA_ENABLE_ROCTRLR*/);
//STRIP001 
//STRIP001 	// jetzt bin ich reif fuer den Dialog
//STRIP001 	FmSearchDialog dlg(&m_pShell->GetViewShell()->GetViewFrame()->GetWindow(), strInitialText, strRealContexts, nInitialContext, LINK(this, FmXFormShell, OnSearchContextRequest),
//STRIP001 		FmSearchDialog::SM_ALLOWSCHEDULE);
//STRIP001 	// wenn die potentiellen Deadlocks, die durch die Benutzung des Solar-Mutex in MTs VCLX...-Klasen entstehen, irgendwann mal
//STRIP001 	// ausgeraeumt sind, sollte hier ein SM_USETHREAD rein, denn die Suche in einem eigenen Thread ist doch etwas fluessiger
//STRIP001 	// sollte allerdings irgendwie von dem unterliegenden Cursor abhaengig gemacht werden, DAO zum Beispiel ist nicht thread-sicher
//STRIP001 
//STRIP001 	dlg.SetActiveField(strActiveField);
//STRIP001 
//STRIP001 	dlg.SetFoundHandler(LINK(this, FmXFormShell, OnFoundData));
//STRIP001 	dlg.SetCanceledNotFoundHdl(LINK(this, FmXFormShell, OnCanceledNotFound));
//STRIP001 	dlg.Execute();
//STRIP001 
//STRIP001 	// GridControls wieder restaurieren
//STRIP001 	LoopGrids(GA_ENABLE_SYNC | GA_DISABLE_ROCTRLR);
//STRIP001 
//STRIP001 	m_pShell->GetFormView()->UnMarkAll(m_pShell->GetFormView()->GetPageViewPvNum(0));
//STRIP001 		// da ich in OnFoundData (fals ich dort war) Controls markiert habe
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::GetY2KState(sal_uInt16& n)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (m_pShell->IsDesignMode())
//STRIP001 		// im Design-Modus (ohne aktive Controls) soll sich das Haupt-Dokument darum kuemmern
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XForm> xForm( getActiveForm());
//STRIP001 	if (!xForm.is())
//STRIP001 		// kein aktuelles Formular (also insbesondere kein aktuelles Control) -> das Haupt-Dokument soll sich kuemmern
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XRowSet> xDB(xForm, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xDB.is(), "FmXFormShell::GetY2KState : current form has no dbform-interface !");
//STRIP001 
//STRIP001 	Reference< XNumberFormatsSupplier> xSupplier( getNumberFormats(OStaticDataAccessTools().getRowSetConnection(xDB), sal_False));
//STRIP001 	if (xSupplier.is())
//STRIP001 	{
//STRIP001 		Reference< XPropertySet> xSet(xSupplier->getNumberFormatSettings());
//STRIP001 		if (xSet.is())
//STRIP001 		{
//STRIP001 			try
//STRIP001 			{
//STRIP001 				Any aVal( xSet->getPropertyValue(::rtl::OUString::createFromAscii("TwoDigitDateStart")) );
//STRIP001 				aVal >>= n;
//STRIP001 				return sal_True;
//STRIP001 			}
//STRIP001 			catch(Exception&)
//STRIP001 			{
//STRIP001 			}
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::SetY2KState(sal_uInt16 n)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XForm> xActiveForm( getActiveForm());
//STRIP001 	Reference< XRowSet> xDB(xActiveForm, UNO_QUERY);
//STRIP001 	if (xDB.is())
//STRIP001 	{
//STRIP001 		Reference< XNumberFormatsSupplier> xSupplier( getNumberFormats(getRowSetConnection(xDB), sal_False));
//STRIP001 		if (xSupplier.is())
//STRIP001 		{
//STRIP001 			Reference< XPropertySet> xSet(xSupplier->getNumberFormatSettings());
//STRIP001 			if (xSet.is())
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					Any aVal;
//STRIP001 					aVal <<= n;
//STRIP001 					xSet->setPropertyValue(::rtl::OUString::createFromAscii("TwoDigitDateStart"), aVal);
//STRIP001 				}
//STRIP001 				catch(Exception&)
//STRIP001 				{
//STRIP001 					DBG_ERROR("FmXFormShell::SetY2KState: Exception occured!");
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// kein aktives Formular gefunden -> alle aktuell vorhandenen Formulare durchiterieren
//STRIP001 	Reference< XIndexAccess> xCurrentForms( m_xForms);
//STRIP001 	if (!xCurrentForms.is())
//STRIP001 	{	// im alive-Modus sind meine Forms nicht gesetzt, wohl aber die an der Page
//STRIP001 		if (m_pShell->GetCurPage())
//STRIP001 			xCurrentForms = Reference< XIndexAccess>(m_pShell->GetCurPage()->GetForms(), UNO_QUERY);
//STRIP001 	}
//STRIP001 	if (!xCurrentForms.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	::comphelper::IndexAccessIterator aIter(xCurrentForms);
//STRIP001 	Reference< XInterface> xCurrentElement( aIter.Next());
//STRIP001 	while (xCurrentElement.is())
//STRIP001 	{
//STRIP001 		// ist das aktuelle Element eine DatabaseForm ?
//STRIP001 		Reference< XRowSet> xDB(xCurrentElement, UNO_QUERY);
//STRIP001 		if (xDB.is())
//STRIP001 		{
//STRIP001 			Reference< XNumberFormatsSupplier> xSupplier( getNumberFormats(getRowSetConnection(xDB), sal_False));
//STRIP001 			if (!xSupplier.is())
//STRIP001 				continue;
//STRIP001 
//STRIP001 			Reference< XPropertySet> xSet(xSupplier->getNumberFormatSettings());
//STRIP001 			if (xSet.is())
//STRIP001 			{
//STRIP001 				try
//STRIP001 				{
//STRIP001 					Any aVal;
//STRIP001 					aVal <<= n;
//STRIP001 					xSet->setPropertyValue(::rtl::OUString::createFromAscii("TwoDigitDateStart"), aVal);
//STRIP001 				}
//STRIP001 				catch(Exception&)
//STRIP001 				{
//STRIP001 					DBG_ERROR("FmXFormShell::SetY2KState: Exception occured!");
//STRIP001 				}
//STRIP001 
//STRIP001 			}
//STRIP001 		}
//STRIP001 		xCurrentElement = aIter.Next();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::CanMoveLeft(const Reference< XFormController>& xController)
//STRIP001 {
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XPropertySet> xSet(xController->getModel(), UNO_QUERY);
//STRIP001 	return CanMoveLeft(xSet);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::CanMoveLeft(const Reference< XPropertySet>& _xControllerModel)
//STRIP001 {
//STRIP001 	if (!_xControllerModel.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XResultSet> xCursor(_xControllerModel, UNO_QUERY);
//STRIP001 	sal_Bool bIsNew = ::comphelper::getBOOL(_xControllerModel->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 	sal_Int32 nCount	= ::comphelper::getINT32(_xControllerModel->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 	return nCount && (!xCursor->isFirst() || bIsNew);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::CanMoveRight(const Reference< XFormController>& xController)
//STRIP001 {
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XPropertySet> xSet(xController->getModel(), UNO_QUERY);
//STRIP001 	return CanMoveRight(xSet);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::CanMoveRight(const Reference< XPropertySet>& _xControllerModel)
//STRIP001 {
//STRIP001 	if (!_xControllerModel.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XResultSet> xCursor(_xControllerModel, UNO_QUERY);
//STRIP001 	sal_Int32 nCount		= ::comphelper::getINT32(_xControllerModel->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 	sal_Bool  bIsModified	= ::comphelper::getBOOL(_xControllerModel->getPropertyValue(FM_PROP_ISMODIFIED));
//STRIP001 	sal_Bool  bIsNew		= ::comphelper::getBOOL(_xControllerModel->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 	sal_Bool  bCanInsert	= OStaticDataAccessTools().canInsert(_xControllerModel);
//STRIP001 
//STRIP001 	return	(
//STRIP001 				(	nCount
//STRIP001 				&&	!xCursor->isLast()
//STRIP001 				&&	!bIsNew
//STRIP001 				)
//STRIP001 			)
//STRIP001 			||
//STRIP001 			(
//STRIP001 				bCanInsert && (!bIsNew || bIsModified)
//STRIP001 			);
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ sal_Bool FmXFormShell::CommitCurrent(const Reference< XFormController>& _xController)
/*N*/ {DBG_BF_ASSERT(0, "STRIP");return FALSE;//STRIP001 
//STRIP001 	// mu noch ein Control commitet werden
//STRIP001 	Reference< XControl> xActiveControl(_xController->getCurrentControl());
//STRIP001 	Reference< XBoundControl> xLockingTest(xActiveControl, UNO_QUERY);
//STRIP001 	sal_Bool bControlIsLocked = xLockingTest.is() && xLockingTest->getLock();
//STRIP001 	sal_Bool bResult = sal_True;
//STRIP001 	if (xActiveControl.is() && !bControlIsLocked)
//STRIP001 	{
//STRIP001 		// zunaechst das Control fragen ob es das IFace unterstuetzt
//STRIP001 		Reference< XBoundComponent> xBound(xActiveControl, UNO_QUERY);
//STRIP001 		if (!xBound.is())
//STRIP001 			xBound	= Reference< XBoundComponent>(xActiveControl->getModel(), UNO_QUERY);
//STRIP001 		if (xBound.is() && !xBound->commit())
//STRIP001 			bResult = sal_False;
//STRIP001 	}
//STRIP001 	return bResult;
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 void FmXFormShell::ResetCurrent(const Reference< XFormController>& _xController)
//STRIP001 {
//STRIP001 	Reference< XControl> xActiveControl( _xController->getCurrentControl());
//STRIP001 	if (xActiveControl.is())
//STRIP001 	{
//STRIP001 		Reference< XReset> xReset(xActiveControl->getModel(), UNO_QUERY);
//STRIP001 		if (xReset.is())
//STRIP001 			xReset->reset();
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 void FmXFormShell::ResetAll(const Reference< XForm>& _xForm)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XIndexAccess> xContainer(_xForm, UNO_QUERY);
//STRIP001 	for (sal_Int16 nBothViews=0; nBothViews<2; ++nBothViews)
//STRIP001 	{
//STRIP001 		if (xContainer.is())
//STRIP001 		{
//STRIP001 			Reference< XReset> xReset;
//STRIP001 			for (sal_Int32 i=0; i<xContainer->getCount(); ++i)
//STRIP001 			{
//STRIP001 				xContainer->getByIndex(i) >>= xReset;
//STRIP001 				if (xReset.is())
//STRIP001 				{
//STRIP001 					Reference< XForm> xAsForm(xReset, UNO_QUERY);
//STRIP001 					if (!xAsForm.is())	// no resets on the form
//STRIP001 						xReset->reset();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		xContainer = NULL;
//STRIP001 		if ((nBothViews == 0) && (getInternalForm(_xForm) == m_xExternalDisplayedForm))
//STRIP001 		{
//STRIP001 			Reference< XFormController> xExternalFormController(m_xExternalViewController, UNO_QUERY);
//STRIP001 			if (xExternalFormController.is())
//STRIP001 				xContainer = Reference< XIndexAccess>(xExternalFormController->getModel(), UNO_QUERY);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::SaveModified(const Reference< XResultSetUpdate>& _xCursor, Reference< XPropertySet>& _xSet, sal_Bool& _rRecordInserted)
//STRIP001 {
//STRIP001 	_rRecordInserted = sal_False;
//STRIP001 	if (!_xCursor.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	_xSet = Reference< XPropertySet>(_xCursor, UNO_QUERY);
//STRIP001 	if (!_xSet.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	// mu gespeichert werden ?
//STRIP001 	sal_Bool  bIsNew		= ::comphelper::getBOOL(_xSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 	sal_Bool  bIsModified	= ::comphelper::getBOOL(_xSet->getPropertyValue(FM_PROP_ISMODIFIED));
//STRIP001 	sal_Bool bResult = !bIsModified;
//STRIP001 	if (bIsModified)
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if (bIsNew)
//STRIP001 				_xCursor->insertRow();
//STRIP001 			else
//STRIP001 				_xCursor->updateRow();
//STRIP001 			bResult = sal_True;
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 			DBG_ERROR("FmXFormShell::SaveModified: Exception occured!");
//STRIP001 		}
//STRIP001 
//STRIP001 		_rRecordInserted = bIsNew && bResult;
//STRIP001 	}
//STRIP001 	return bResult;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::SaveModified(const Reference< XFormController>& xController,
//STRIP001 								Reference< XResultSetUpdate>& xCursor,
//STRIP001 								Reference< XPropertySet>& xSet,
//STRIP001 								sal_Bool& rRecordInserted)
//STRIP001 
//STRIP001 {
//STRIP001 	rRecordInserted = sal_False;
//STRIP001 
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	xCursor = Reference< XResultSetUpdate>(xController->getModel(), UNO_QUERY);
//STRIP001 	return SaveModified(xCursor, xSet, rRecordInserted);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::IsModified(const Reference< XFormController>& xController)
//STRIP001 {
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XPropertySet> xSet(xController->getModel(), UNO_QUERY);
//STRIP001 	if (!xSet.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	// Modifiziert
//STRIP001 	if (::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISMODIFIED)))
//STRIP001 		return sal_True;
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::SaveModified(const Reference< XFormController>& xController, sal_Bool bCommit)
//STRIP001 {
//STRIP001 	if (!bCommit || CommitCurrent(xController))
//STRIP001 	{
//STRIP001 		Reference< XResultSetUpdate> xCursor;
//STRIP001 		Reference< XPropertySet> xSet;
//STRIP001 		sal_Bool bInserted;
//STRIP001 		return SaveModified(xController,
//STRIP001 							xCursor,
//STRIP001 							xSet,
//STRIP001 							bInserted);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::MoveRight(const Reference< XResultSetUpdate>& _xCursor)
//STRIP001 {
//STRIP001 	if (!_xCursor.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XPropertySet> xSet;
//STRIP001 	Reference< XResultSet> xReadCursor(_xCursor, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xReadCursor.is(), "FmXFormShell::MoveRight : invalid cursor !");
//STRIP001 	sal_Bool bInserted;
//STRIP001 
//STRIP001 	sal_Bool bSuccess = SaveModified(_xCursor, xSet, bInserted);
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if (bInserted)
//STRIP001 			{
//STRIP001 				// go to insert row
//STRIP001 				_xCursor->moveToInsertRow();
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				if (xReadCursor->isLast())
//STRIP001 					_xCursor->moveToInsertRow();
//STRIP001 				else
//STRIP001 					xReadCursor->next();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 			DBG_ERROR("FmXFormShell::MoveRight: Exception occured!");
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	return bSuccess;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::MoveRight(const Reference< XFormController>& xController)
//STRIP001 {
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	return MoveRight(Reference< XResultSetUpdate>(xController->getModel(), UNO_QUERY));
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::MoveLeft(const Reference< XResultSetUpdate>& _xCursor)
//STRIP001 {
//STRIP001 	if (!_xCursor.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	Reference< XPropertySet> xSet;
//STRIP001 	Reference< XResultSet> xReadCursor(_xCursor, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xReadCursor.is(), "FmXFormShell::MoveLeft : invalid cursor !");
//STRIP001 	sal_Bool bInserted;
//STRIP001 
//STRIP001 	sal_Bool bSuccess = SaveModified(_xCursor, xSet, bInserted);
//STRIP001 
//STRIP001 	if (bSuccess)
//STRIP001 	{
//STRIP001 		try
//STRIP001 		{
//STRIP001 			if (bInserted)
//STRIP001 			{
//STRIP001 				// retrieve the bookmark of the new record and move previous to that bookmark
//STRIP001 				Reference< XRowLocate> xLocate(xReadCursor, UNO_QUERY);
//STRIP001 				xLocate->moveRelativeToBookmark(xLocate->getBookmark(), -1);
//STRIP001 			}
//STRIP001 			else if (::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW)))
//STRIP001 			{
//STRIP001 				// we assume that the inserted record is now the last record in the
//STRIP001 				// result set
//STRIP001 				xReadCursor->last();
//STRIP001 			}
//STRIP001 			else
//STRIP001 				xReadCursor->previous();
//STRIP001 		}
//STRIP001 		catch(Exception&)
//STRIP001 		{
//STRIP001 			DBG_ERROR("FmXFormShell::MoveLeft: Exception occured!");
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 	return bSuccess;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::MoveLeft(const Reference< XFormController>& xController)
//STRIP001 {
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	return MoveLeft(Reference< XResultSetUpdate>(xController->getModel(), UNO_QUERY));
//STRIP001 }

// XRowSetListener
//------------------------------------------------------------------------------
/*?*/ void SAL_CALL FmXFormShell::cursorMoved(const EventObject& event) throw( RuntimeException )
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	m_bActiveModified = sal_False;
//STRIP001 	m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(DatabaseSlotMap);
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::CloseExternalFormViewer()
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (!m_xExternalViewController.is())
/*N*/ 		return;
/*N*/ 
/*?*/ 	Reference< ::com::sun::star::frame::XFrame> xExternalViewFrame( m_xExternalViewController->getFrame());
/*?*/ 	Reference< ::com::sun::star::frame::XDispatchProvider> xCommLink(xExternalViewFrame, UNO_QUERY);
/*?*/ 	if (!xCommLink.is())
/*?*/ 		return;
/*?*/ 
/*?*/ 	xExternalViewFrame->setComponent(NULL,NULL);
/*?*/ 	::comphelper::disposeComponent(xExternalViewFrame);
/*?*/ 	
/*?*/ //	URL aCloseUrl;
/*?*/ //		// tool windows (like the task local beamer used for the grid) are assumed to close when dispatching an empty URL
/*?*/ //
/*?*/ //	Reference< ::com::sun::star::frame::XDispatch> xCloser(xCommLink->queryDispatch(aCloseUrl, ::rtl::OUString::createFromAscii("_self"), 0));
/*?*/ //	DBG_ASSERT(xCloser.is(), "FmXFormShell::CloseExternalFormViewer : don't know how to close the tool frame !");
/*?*/ //	if (xCloser.is())
/*?*/ //		xCloser->dispatch(aCloseUrl, Sequence< PropertyValue>());
/*?*/ 
/*?*/ 	m_xExternalViewController	= NULL;
/*?*/ 	m_xExtViewTriggerController = NULL;
/*?*/ 	m_xExternalDisplayedForm	= NULL;
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 Reference< XResultSet> FmXFormShell::getInternalForm(const Reference< XResultSet>& _xForm) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XFormController> xExternalCtrlr(m_xExternalViewController, UNO_QUERY);
//STRIP001 	if (xExternalCtrlr.is() && (_xForm == xExternalCtrlr->getModel()))
//STRIP001 	{
//STRIP001 		DBG_ASSERT(m_xExternalDisplayedForm.is(), "FmXFormShell::getInternalForm : invalid external form !");
//STRIP001 		return m_xExternalDisplayedForm;
//STRIP001 	}
//STRIP001 	return _xForm;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 Reference< XForm> FmXFormShell::getInternalForm(const Reference< XForm>& _xForm) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XFormController> xExternalCtrlr(m_xExternalViewController, UNO_QUERY);
//STRIP001 	if (xExternalCtrlr.is() && (_xForm == xExternalCtrlr->getModel()))
//STRIP001 	{
//STRIP001 		DBG_ASSERT(m_xExternalDisplayedForm.is(), "FmXFormShell::getInternalForm : invalid external form !");
//STRIP001 		return Reference< XForm>(m_xExternalDisplayedForm, UNO_QUERY);
//STRIP001 	}
//STRIP001 	return _xForm;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::ActivateDispatchers(const UniString& _sNavFormAccess, sal_Bool _bActivate)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	for (	ConstFormsDispatchersIterator aFormIter = m_aNavigationDispatcher.begin();
//STRIP001 			aFormIter != m_aNavigationDispatcher.end();
//STRIP001 			++aFormIter
//STRIP001 		)
//STRIP001 	{
//STRIP001 		UniString sPath = aFormIter->first;
//STRIP001 
//STRIP001 		if (sPath == _sNavFormAccess)
//STRIP001 		{
//STRIP001 			for (	ConstSingleFormDispatchersIterator aDispIter = (*aFormIter).second.begin();
//STRIP001 					aDispIter < (*aFormIter).second.end();
//STRIP001 					++aDispIter
//STRIP001 				)
//STRIP001 			{
//STRIP001 				FmFormNavigationDispatcher* pCurDispatcher = *aDispIter;
//STRIP001 				if (pCurDispatcher)
//STRIP001 					pCurDispatcher->SetActive(_bActivate);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 UniString FmXFormShell::GetAccessPathFromForm(const Reference< XResultSet>& _xForm, const UniString& rAssumedPagePrefix) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	UniString sReturn;
//STRIP001 	if (!_xForm.is())
//STRIP001 		return sReturn;
//STRIP001 
//STRIP001 	Reference< XResultSet> xForm(getInternalForm(_xForm));
//STRIP001 
//STRIP001 	sReturn = getFormComponentAccessPath(xForm);
//STRIP001 
//STRIP001 	// prepend the page ident to the path
//STRIP001 	UniString sPrefix( rAssumedPagePrefix );
//STRIP001 	if (!sPrefix.Len())
//STRIP001 	{
//STRIP001 		FmFormPage* pPage = m_pShell->GetCurPage();
//STRIP001 		DBG_ASSERT(pPage, "FmXFormShell::GetAccessPathFromForm : have no current page !");
//STRIP001 
//STRIP001 		if (pPage && pPage->GetImpl())
//STRIP001 			sPrefix = pPage->GetImpl()->GetPageId();
//STRIP001 		else
//STRIP001 			sPrefix.AssignAscii("no page");
//STRIP001 	}
//STRIP001 
//STRIP001 	sPrefix += '\\';
//STRIP001 	sPrefix += sReturn;
//STRIP001 	sReturn = sPrefix;
//STRIP001 
//STRIP001 	return sReturn;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 UniString FmXFormShell::GetPageId(const Reference< XResultSet>& _xForm) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	UniString sEmptyReturn;
//STRIP001 	FmFormModel* pModel = m_pShell->GetFormModel();
//STRIP001 	if (!pModel)
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormShell::GetPageId : have no form model !");
//STRIP001 		return sEmptyReturn;
//STRIP001 	}
//STRIP001 
//STRIP001 	// search the top level forms collection
//STRIP001 	Reference< XInterface> xTopLevelContainer( getInternalForm(_xForm));
//STRIP001 	Reference< XResultSet> xAsResultSet(xTopLevelContainer, UNO_QUERY);
//STRIP001 	while (xAsResultSet.is())
//STRIP001 	{
//STRIP001 		Reference< XChild> xChild(xTopLevelContainer, UNO_QUERY);
//STRIP001 		xTopLevelContainer = xChild->getParent();
//STRIP001 		xAsResultSet = Reference< XResultSet>(xTopLevelContainer, UNO_QUERY);
//STRIP001 	}
//STRIP001 
//STRIP001 	// search all pages of my model
//STRIP001 	for (sal_Int16 i=0; i<pModel->GetPageCount(); ++i)
//STRIP001 	{
//STRIP001 		FmFormPage* pCurrent = PTR_CAST(FmFormPage, pModel->GetPage(i));
//STRIP001 		if (!pCurrent)
//STRIP001 			continue;
//STRIP001 		if (pCurrent->GetForms() == xTopLevelContainer)
//STRIP001 			return pCurrent->GetImpl()->GetPageId();
//STRIP001 	}
//STRIP001 
//STRIP001 	return sEmptyReturn;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 Reference< XNameContainer> FmXFormShell::GetPageForms(const UniString sPageId) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XNameContainer> aEmptyReturn;
//STRIP001 	FmFormModel* pModel = m_pShell->GetFormModel();
//STRIP001 	if (!pModel)
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormShell::GetPageForms : have no form model !");
//STRIP001 		return aEmptyReturn;
//STRIP001 	}
//STRIP001 
//STRIP001 	for (sal_uInt16 i=0; i<pModel->GetPageCount(); ++i)
//STRIP001 	{
//STRIP001 		FmFormPage* pCurrent = PTR_CAST(FmFormPage, pModel->GetPage(i));
//STRIP001 		if (!pCurrent)
//STRIP001 			continue;
//STRIP001 		if (pCurrent->GetImpl()->GetPageId() == sPageId)
//STRIP001 			return pCurrent->GetForms();
//STRIP001 	}
//STRIP001 
//STRIP001 	return aEmptyReturn;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::UpdateAllFormDispatchers(const UniString& _rPath)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	for (	FormsDispatchersIterator aDispIter = m_aNavigationDispatcher.begin();
//STRIP001 			aDispIter != m_aNavigationDispatcher.end();
//STRIP001 			++aDispIter
//STRIP001 		)
//STRIP001 	{
//STRIP001 		UniString sThisRoundPath = aDispIter->first;
//STRIP001 		if (PathsInterfere(sThisRoundPath, _rPath))
//STRIP001 			// child or anchestor
//STRIP001 		{
//STRIP001 			SingleFormDispatchers& rDisp = (*aDispIter).second;
//STRIP001 			for (	SingleFormDispatchersIterator aIter = rDisp.begin();
//STRIP001 					aIter != rDisp.end();
//STRIP001 					++aIter
//STRIP001 				)
//STRIP001 			{
//STRIP001 				FmFormNavigationDispatcher* pCurrent = *aIter;
//STRIP001 				if (pCurrent)
//STRIP001 					UpdateFormDispatcher(pCurrent);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::UpdateFormDispatcher(FmFormNavigationDispatcher* _pDisp)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	sal_Bool bEnable = sal_False;
//STRIP001 	if (!_pDisp)
//STRIP001 		return;
//STRIP001 	// all navigation slots are disabled if the form is blocked because of a pending move
//STRIP001 	if (!HasPendingCursorAction(_pDisp->getForm()))
//STRIP001 	{
//STRIP001 		Reference< XPropertySet> xSet(_pDisp->getForm(), UNO_QUERY);
//STRIP001 		switch (_pDisp->getSlot())
//STRIP001 		{
//STRIP001 			case SID_FM_RECORD_UNDO:
//STRIP001 				bEnable = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISMODIFIED));
//STRIP001 				break;
//STRIP001 			case SID_FM_RECORD_PREV:
//STRIP001 			case SID_FM_RECORD_FIRST:
//STRIP001 				bEnable = CanMoveLeft(xSet);
//STRIP001 				break;
//STRIP001 			case SID_FM_RECORD_NEXT:
//STRIP001 				bEnable = CanMoveRight(xSet);
//STRIP001 				break;
//STRIP001 			case SID_FM_RECORD_LAST:
//STRIP001 			{
//STRIP001 				Reference< XResultSet> xCursor(xSet, UNO_QUERY);
//STRIP001 				sal_Int32 nCount = ::comphelper::getINT32(xSet->getPropertyValue(FM_PROP_ROWCOUNT));
//STRIP001 				bEnable = nCount && (!xCursor->isLast() || ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW)));
//STRIP001 			}
//STRIP001 				break;
//STRIP001 			case SID_FM_RECORD_NEW:
//STRIP001 			{
//STRIP001 				if (::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW)))
//STRIP001 					bEnable = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISMODIFIED));
//STRIP001 				else
//STRIP001 					bEnable = canInsert(xSet);
//STRIP001 			}
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	_pDisp->SetStatus(bEnable ? SFX_ITEM_AVAILABLE : SFX_ITEM_DISABLED, NULL);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnExecuteNavSlot, FmFormNavigationDispatcher*, pDispatcher)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(pDispatcher, "FmXFormShell::OnExecuteNavSlot : invalid argument !");
//STRIP001 
//STRIP001 	Reference< XResultSet > xCursor( pDispatcher->getForm() );
//STRIP001 	Reference< XResultSetUpdate > xUpdateCursor( xCursor, UNO_QUERY );
//STRIP001 
//STRIP001 	// all slots except undo need a SaveModified
//STRIP001 	if ( pDispatcher->getSlot() != SID_FM_RECORD_UNDO )
//STRIP001 	{
//STRIP001 	    Reference< XPropertySet> xCursorSet;
//STRIP001 		sal_Bool bDoneSomething = sal_False;
//STRIP001 		if ( !SaveModified( xUpdateCursor, xCursorSet, bDoneSomething ) )
//STRIP001 			return 1L;
//STRIP001 	}
//STRIP001 
//STRIP001 	switch ( pDispatcher->getSlot() )
//STRIP001 	{
//STRIP001 		case SID_FM_RECORD_UNDO:
//STRIP001 		{
//STRIP001 			Reference< XPropertySet> xSet(xCursor, UNO_QUERY);
//STRIP001 			sal_Bool bInserting = xSet.is() && ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 			if (!bInserting)
//STRIP001 				xUpdateCursor->cancelRowUpdates();
//STRIP001 
//STRIP001 			ResetAll(getActiveForm());
//STRIP001 
//STRIP001 			if (bInserting) 				// wieder in den EinfuegeModus
//STRIP001 				DO_SAFE( xUpdateCursor->moveToInsertRow(); );
//STRIP001 
//STRIP001 			if (xCursor == getActiveForm())
//STRIP001 				m_bActiveModified = sal_False;
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_FM_RECORD_FIRST:
//STRIP001 			DO_SAFE( xCursor->first(); );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_FM_RECORD_PREV:
//STRIP001 			MoveLeft(xUpdateCursor);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_FM_RECORD_NEXT:
//STRIP001 			MoveRight(xUpdateCursor);
//STRIP001 			break;
//STRIP001 
//STRIP001 		case SID_FM_RECORD_LAST:
//STRIP001 		{
//STRIP001 			// run in an own thread if ...
//STRIP001 			Reference< XPropertySet> xCursorProps(xCursor, UNO_QUERY);
//STRIP001 			// ... the data source is thread safe ...
//STRIP001 			sal_Bool bAllowOwnThread = ::comphelper::hasProperty(FM_PROP_THREADSAFE, xCursorProps) && ::comphelper::getBOOL(xCursorProps->getPropertyValue(FM_PROP_THREADSAFE));
//STRIP001 			// ... the record count is unknown
//STRIP001 			sal_Bool bNeedOwnThread = ::comphelper::hasProperty(FM_PROP_ROWCOUNTFINAL, xCursorProps) && !::comphelper::getBOOL(xCursorProps->getPropertyValue(FM_PROP_ROWCOUNTFINAL));
//STRIP001 
//STRIP001 
//STRIP001 			if (bNeedOwnThread && bAllowOwnThread)
//STRIP001 				DoAsyncCursorAction(pDispatcher->getForm(), FmXFormShell::CA_MOVE_TO_LAST);
//STRIP001 			else
//STRIP001 				DO_SAFE( xCursor->last(); );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		case SID_FM_RECORD_NEW:
//STRIP001 		{
//STRIP001 			Reference< XResultSet >  xCursor( xUpdateCursor, UNO_QUERY );
//STRIP001 			DBG_ASSERT( xCursor.is(), "FmXFormShell:OnExecuteNavSlot: invalid cursor (no XResultSet)!" );
//STRIP001 			if ( xCursor.is() )
//STRIP001 			{
//STRIP001 				// move to the last row before moving to the insert row
//STRIP001 				// 21.01.2002 - 96480 - fs@openoffice.org
//STRIP001 				DO_SAFE( xCursor->last(); );
//STRIP001 				DO_SAFE( xUpdateCursor->moveToInsertRow(); );
//STRIP001 
//STRIP001 				// TODO: here, the same comments as in FmFormShell::Execute( SID_FM_RECORD_NEW ) apply
//STRIP001 				// think about this DO_SAFE
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (xCursor == getActiveForm())
//STRIP001 		m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(DatabaseSlotMap);
//STRIP001 
//STRIP001 	UpdateAllFormDispatchers(pDispatcher->getFormAccessPath());
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setActiveController( const Reference< XFormController>& xController, sal_Bool _bNoSaveOldContent )
/*N*/ {
/*N*/ 	DBG_ASSERT(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (m_bChangingDesignMode)
/*N*/ 		return;
/*N*/ 	DBG_ASSERT(!m_pShell->IsDesignMode(), "nur im alive mode verwenden");
/*N*/ 
/*N*/ 	// Ist die Routine ein zweites Mal gerufen worden,
/*N*/ 	// dann sollte der Focus nicht mehr umgesetzt werden
/*N*/ 	if (m_bInActivate)
/*N*/ 	{
/*N*/ 		m_bSetFocus = xController != m_xActiveController;
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	if (xController != m_xActiveController)
/*?*/ 	{{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 
//STRIP001 /*?*/ 		// if there is a async cursor action running we have to restore the locking state of the controls of the old controller
//STRIP001 /*?*/ 		if (HasPendingCursorAction(Reference< XResultSet>(m_xActiveForm, UNO_QUERY)))
//STRIP001 /*?*/ 			restoreControlLocks();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		::osl::ClearableMutexGuard aGuard(m_aAsyncSafety);
//STRIP001 /*?*/ 		// switch all nav dispatchers belonging to the form of the current nav controller to 'non active'
//STRIP001 /*?*/ 		Reference< XResultSet> xNavigationForm;
//STRIP001 /*?*/ 		if (m_xNavigationController.is())
//STRIP001 /*?*/ 			xNavigationForm = Reference< XResultSet>(m_xNavigationController->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 		if (xNavigationForm.is())
//STRIP001 /*?*/ 			ActivateDispatchers(GetAccessPathFromForm(xNavigationForm), sal_False);
//STRIP001 /*?*/ 		aGuard.clear();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		m_bInActivate = sal_True;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// check if the 2 controllers serve different forms
//STRIP001 /*?*/ 		Reference< XResultSet> xOldForm;
//STRIP001 /*?*/ 		if (m_xActiveController.is())
//STRIP001 /*?*/ 			xOldForm = Reference< XResultSet>(m_xActiveController->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 		Reference< XResultSet> xNewForm;
//STRIP001 /*?*/ 		if (xController.is())
//STRIP001 /*?*/ 			xNewForm = Reference< XResultSet>(xController->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 		xOldForm = getInternalForm(xOldForm);
//STRIP001 /*?*/ 		xNewForm = getInternalForm(xNewForm);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		sal_Bool bDifferentForm = ( xOldForm.get() != xNewForm.get() );
//STRIP001 /*?*/ 		sal_Bool bNeedSave = bDifferentForm && !_bNoSaveOldContent;
//STRIP001 /*?*/ 			// we save the content of the old form if we move to a new form, and saving old content is allowed
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		if ( m_xActiveController.is() && bNeedSave )
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// beim Wechsel des Controllers den Inhalt speichern, ein Commit
//STRIP001 /*?*/ 			// wurde bereits ausgefuehrt
//STRIP001 /*?*/ 			Reference< XControl> xCurrentControl(m_xActiveController->getCurrentControl());
//STRIP001 /*?*/ 			if (xCurrentControl.is())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				Reference< XBoundComponent> xCurrentBoundComp(xCurrentControl,UNO_QUERY);
//STRIP001 /*?*/ 				if ( xCurrentBoundComp.is() )
//STRIP001 /*?*/ 					xCurrentBoundComp->commit();
//STRIP001 /*?*/ 				m_bSetFocus = sal_True;
//STRIP001 /*?*/ 				Reference< XPropertySet>	xSet(getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 				if (IsModified(m_xActiveController))
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					sal_Bool bIsNew = ::comphelper::getBOOL(xSet->getPropertyValue(FM_PROP_ISNEW));
//STRIP001 /*?*/ 					sal_Bool bResult = sal_False;
//STRIP001 /*?*/ 					Reference< XResultSetUpdate> xCursor(getActiveForm(), UNO_QUERY);
//STRIP001 /*?*/ 					try
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						if (bIsNew)
//STRIP001 /*?*/ 							xCursor->insertRow();
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							xCursor->updateRow();
//STRIP001 /*?*/ 						bResult = sal_True;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					catch(Exception&)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						DBG_ERROR("FmXFormShell::setActiveController: Exception occured!");
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					// Konnte nicht gespeichert werden, dann den Focus wieder zurueck setzen
//STRIP001 /*?*/ 					if (!bResult && m_bSetFocus)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Reference< XWindow> xWindow(xCurrentControl, UNO_QUERY);
//STRIP001 /*?*/ 						xWindow->setFocus();
//STRIP001 /*?*/ 						m_bInActivate = sal_False;
//STRIP001 /*?*/ 						return;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if (bResult && bIsNew)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						DO_SAFE( Reference< XResultSet>(xCursor, UNO_QUERY)->last(); );
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		stopListening();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		m_xActiveController = xController;
//STRIP001 /*?*/ 		if (m_xActiveController.is())
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			// set eventlistener to know when it is disposed
//STRIP001 /*?*/ 			Reference< ::com::sun::star::lang::XComponent> xComp(m_xActiveController, UNO_QUERY);
//STRIP001 /*?*/ 			if (xComp.is())
//STRIP001 /*?*/ 				xComp->addEventListener((XEventListener*)(XPropertyChangeListener*)this);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 			m_xActiveForm = getInternalForm(Reference< XForm>(m_xActiveController->getModel(), UNO_QUERY));
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 		else
//STRIP001 /*?*/ 			m_xActiveForm = NULL;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		startListening();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// activate all dispatchers belonging to form of the new navigation controller
//STRIP001 /*?*/ 		xNavigationForm = NULL;
//STRIP001 /*?*/ 		if (m_xNavigationController.is())
//STRIP001 /*?*/ 			xNavigationForm = Reference< XResultSet>(m_xNavigationController->getModel(), UNO_QUERY);
//STRIP001 /*?*/ 		if (xNavigationForm.is())
//STRIP001 /*?*/ 			ActivateDispatchers(GetAccessPathFromForm(xNavigationForm), sal_True);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		// if there is a async cursor action running we have to lock the controls of the new controller
//STRIP001 /*?*/ 		if (HasPendingCursorAction(Reference< XResultSet>(m_xActiveForm, UNO_QUERY)))
//STRIP001 /*?*/ 			setControlLocks();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		m_bInActivate = sal_False;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		m_pShell->UIFeatureChanged();
//STRIP001 /*?*/ 		m_pShell->GetViewShell()->GetViewFrame()->GetBindings().InvalidateShell(*m_pShell);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 		InvalidateSlot(SID_FM_FILTER_NAVIGATOR_CONTROL, sal_True, sal_True);
/*?*/ 	}
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setCurControl( const SdrMarkList& rMarkList )
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (isControlList(rMarkList))
/*N*/ 	{
/*N*/ 		// Aktuell selektiertes Objekt setzen
/*?*/ 		sal_uInt32 nMarkCount = rMarkList.GetMarkCount();
/*?*/ 		FmFormObj* pSelFormObj = NULL;
/*?*/ 		if (nMarkCount==1)
/*?*/ 		{
/*?*/ 			SdrObject *pObj=rMarkList.GetMark(0)->GetObj();
/*?*/ 
/*?*/ 			if( pObj->IsGroupObject() ) // Mehrfachselektion
/*?*/ 			{
/*?*/ 				Reference< XPropertyState> xMultiIFace(FmXMultiSet::Create( rMarkList ));
/*?*/ 				setCurControl( xMultiIFace );
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				pSelFormObj = PTR_CAST(FmFormObj, rMarkList.GetMark(0)->GetObj());
/*?*/ 
/*?*/ 				if ( pSelFormObj ) // Einfachselektion
/*?*/ 				{
/*?*/ 					Reference< XFormComponent> xFormComponent(pSelFormObj->GetUnoControlModel(), UNO_QUERY);
/*?*/ 					if (xFormComponent.is())
/*?*/ 						setCurControl(xFormComponent);
/*?*/ 					else
/*?*/ 						setCurControl( Reference< XInterface>() );
/*?*/ 				}
/*?*/ 				else
/*?*/ 					setCurControl( Reference< XInterface>() );
/*?*/ 			}
/*?*/ 		}
/*?*/ 		else if (nMarkCount > 1)			// Mehrfachselektion
/*?*/ 		{
/*?*/ 			Reference< XPropertyState> xMultiIFace(FmXMultiSet::Create( rMarkList ));
/*?*/ 			setCurControl( xMultiIFace );
/*?*/ 		}
/*N*/ 	}
/*N*/ 	else // Keine Selektion oder gemischt
/*N*/ 		setCurControl( Reference< XInterface>() );
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setCurControl(const Reference< XInterface>& xNewControl)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DBG_ASSERT(m_pShell->IsDesignMode(), "nur im designmode verwenden");
/*N*/ 
/*N*/ 	if (m_xCurControl == xNewControl)
/*N*/ 		return;
/*N*/ 
/*N*/ 	// Stammen beide Objecte vom gleichen Container
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 	if (m_xCurControl.is())
//STRIP001 /*?*/ 	{
//STRIP001 /*?*/ 		Reference< XChild> xCur(m_xCurControl, UNO_QUERY);
//STRIP001 /*?*/ 		Reference< XChild> xNew(xNewControl, UNO_QUERY);
//STRIP001 /*?*/ 		// wenn nichts selektiert oder unterschiedliche Vter und der Vater von xCurControl ist ein XSelectionSupplier
//STRIP001 /*?*/ 		// dann mu dieser deselektieren.
//STRIP001 /*?*/ 		if (!xNew.is() || xCur->getParent() != xNew->getParent())
//STRIP001 /*?*/ 		{
//STRIP001 /*?*/ 			Reference< ::com::sun::star::view::XSelectionSupplier> xSel(xCur->getParent(), UNO_QUERY);
//STRIP001 /*?*/ 			if (xSel.is())
//STRIP001 /*?*/ 			{
//STRIP001 /*?*/ 				xSel->select(Any());
//STRIP001 /*?*/ 			}
//STRIP001 /*?*/ 		}
//STRIP001 /*?*/ 	}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	m_xCurControl = xNewControl;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 	InvalidateSlot(SID_FM_CTL_PROPERTIES);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::setSelObject(const Reference< XInterface>& xNewObj)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DBG_ASSERT(m_pShell->IsDesignMode(), "nur im designmode verwenden");
/*N*/ 
/*N*/ 	if (m_xSelObject != xNewObj)
/*N*/ 	{
/*?*/ 		m_xSelObject = xNewObj;
/*?*/ 		for (sal_Int16 i = 0; i<sizeof(SelObjectSlotMap)/sizeof(SelObjectSlotMap[0]); ++i)
/*?*/			 {DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 /*?*/ 			InvalidateSlot(SelObjectSlotMap[i]);
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::setCurForm(const Reference< XForm>& xF)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(m_pShell->IsDesignMode(), "nur im designmode verwenden");
//STRIP001 	if (xF != m_xCurForm)
//STRIP001 	{
//STRIP001 		m_xCurForm = xF;
//STRIP001 		FmFormPage* pPage = m_pShell->GetCurPage();
//STRIP001 		if (pPage)
//STRIP001 			pPage->GetImpl()->setCurForm( xF );
//STRIP001 		for (sal_Int16 i = 0; i<sizeof(DlgSlotMap)/sizeof(DlgSlotMap[0]); ++i)
//STRIP001 			InvalidateSlot(DlgSlotMap[i]);
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::startListening()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XRowSet> xDatabaseForm(m_xActiveForm, UNO_QUERY);
//STRIP001 	if (xDatabaseForm.is() && getRowSetConnection(xDatabaseForm).is())
//STRIP001 	{
//STRIP001 		Reference< XPropertySet> xActiveFormSet(m_xActiveForm, UNO_QUERY);
//STRIP001 		if (xActiveFormSet.is())
//STRIP001 		{
//STRIP001 			// wenn es eine Datenquelle gibt, dann den Listener aufbauen
//STRIP001 			::rtl::OUString aSource = ::comphelper::getString(xActiveFormSet->getPropertyValue(FM_PROP_COMMAND));
//STRIP001 			if (aSource.getLength())
//STRIP001 			{
//STRIP001 				// we have to recognize any change roset change
//STRIP001 				xDatabaseForm->addRowSetListener(this);
//STRIP001 
//STRIP001 				// Modify
//STRIP001 				Reference< XModifyBroadcaster> xBroadCaster(m_xActiveController, UNO_QUERY);
//STRIP001 				if (xBroadCaster.is())
//STRIP001 					xBroadCaster->addModifyListener(this);
//STRIP001 
//STRIP001 				sal_Bool bUseEscapeProcessing = ::comphelper::getBOOL(xActiveFormSet->getPropertyValue(FM_PROP_ESCAPE_PROCESSING));
//STRIP001 				if (bUseEscapeProcessing)
//STRIP001 				{
//STRIP001 					Reference< XSQLQueryComposerFactory> xFactory(getRowSetConnection(xDatabaseForm), UNO_QUERY);
//STRIP001 					if (xFactory.is())
//STRIP001 						m_xParser = xFactory->createQueryComposer();
//STRIP001 				}
//STRIP001 
//STRIP001 				m_bDatabaseBar = sal_True;
//STRIP001 
//STRIP001 				xActiveFormSet->getPropertyValue(FM_PROP_NAVIGATION) >>= m_eNavigate;
//STRIP001 
//STRIP001 				xActiveFormSet->addPropertyChangeListener(FM_PROP_ISMODIFIED,this);
//STRIP001 				xActiveFormSet->addPropertyChangeListener(FM_PROP_ISNEW, this);
//STRIP001 
//STRIP001 				switch (m_eNavigate)
//STRIP001 				{
//STRIP001 					case NavigationBarMode_PARENT:
//STRIP001 					{
//STRIP001 						// suchen des Controllers, ueber den eine Navigation moeglich ist
//STRIP001 						Reference< XChild> xChild(m_xActiveController, UNO_QUERY);
//STRIP001 						Reference< XFormController> xParent;
//STRIP001 						while (xChild.is())
//STRIP001 						{
//STRIP001 							xChild = Reference< XChild>(xChild->getParent(), UNO_QUERY);
//STRIP001 							xParent  = Reference< XFormController>(xChild, UNO_QUERY);
//STRIP001 							Reference< XPropertySet> xParentSet;
//STRIP001 							if (xParent.is())
//STRIP001 								xParentSet = Reference< XPropertySet>(xParent->getModel(), UNO_QUERY);
//STRIP001 							if (xParentSet.is())
//STRIP001 							{
//STRIP001 								xParentSet->getPropertyValue(FM_PROP_NAVIGATION) >>= m_eNavigate;
//STRIP001 								if (m_eNavigate == NavigationBarMode_CURRENT)
//STRIP001 									break;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						m_xNavigationController = xParent;
//STRIP001 					}	break;
//STRIP001 					case NavigationBarMode_CURRENT:
//STRIP001 						m_xNavigationController = m_xActiveController;
//STRIP001 						break;
//STRIP001 					default:
//STRIP001 						m_xNavigationController = NULL;
//STRIP001 						m_bDatabaseBar = sal_False;
//STRIP001 				}
//STRIP001 
//STRIP001 				// an dem Controller, der die Navigation regelt, wg. RecordCount lauschen
//STRIP001 				Reference< XPropertySet> xNavigationSet;
//STRIP001 				if (m_xNavigationController.is())
//STRIP001 				{
//STRIP001 					xNavigationSet = Reference< XPropertySet>(m_xNavigationController->getModel(), UNO_QUERY);
//STRIP001 					if (xNavigationSet.is())
//STRIP001 						xNavigationSet->addPropertyChangeListener(FM_PROP_ROWCOUNT,this);
//STRIP001 				}
//STRIP001 
//STRIP001 				// und dem Parser die Query-/Filter-/Sort-Einstellungen der aktiven Form
//STRIP001 				if (m_xParser.is())
//STRIP001 				{
//STRIP001 					Reference< XLoadable> xLoad(m_xActiveForm,UNO_QUERY);
//STRIP001 					if ( xLoad.is() && xLoad->isLoaded() )
//STRIP001 					{
//STRIP001 						::rtl::OUString aStatement	= ::comphelper::getString(xActiveFormSet->getPropertyValue(FM_PROP_ACTIVECOMMAND));
//STRIP001 						::rtl::OUString aFilter 	= ::comphelper::getString(xActiveFormSet->getPropertyValue(FM_PROP_FILTER_CRITERIA));
//STRIP001 						::rtl::OUString aSort		= ::comphelper::getString(xActiveFormSet->getPropertyValue(FM_PROP_SORT));
//STRIP001 
//STRIP001 						try
//STRIP001 						{
//STRIP001 							m_xParser->setQuery(aStatement);
//STRIP001 							m_xParser->setFilter(aFilter);
//STRIP001 							m_xParser->setOrder(aSort);
//STRIP001 						}
//STRIP001 						catch(Exception&)
//STRIP001 						{
//STRIP001 							DBG_ERROR("FmXFormShell::startListening: Exception occured!");
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					// nothing to do, change the parser on a reload
//STRIP001 					xActiveFormSet->addPropertyChangeListener(FM_PROP_ACTIVECOMMAND,this);
//STRIP001 					xActiveFormSet->addPropertyChangeListener(FM_PROP_FILTER_CRITERIA, this);
//STRIP001 					xActiveFormSet->addPropertyChangeListener(FM_PROP_SORT, this);
//STRIP001 				}
//STRIP001 				m_bActiveModified = sal_False;
//STRIP001 				return;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	m_eNavigate  = NavigationBarMode_NONE;
//STRIP001 	m_bDatabaseBar = sal_False;
//STRIP001 	m_xNavigationController = NULL;
//STRIP001 	m_bActiveModified = sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::stopListening()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XRowSet> xDatabaseForm(m_xActiveForm, UNO_QUERY);
//STRIP001 	if (xDatabaseForm.is() && m_bDatabaseBar)
//STRIP001 	{
//STRIP001 		// datensatzwechsel mitbekommen
//STRIP001 		xDatabaseForm->removeRowSetListener(this);
//STRIP001 
//STRIP001 		// Modify
//STRIP001 		Reference< XModifyBroadcaster> xBroadCaster(m_xActiveController, UNO_QUERY);
//STRIP001 		if (xBroadCaster.is())
//STRIP001 			xBroadCaster->removeModifyListener(this);
//STRIP001 
//STRIP001 		// satzstatus
//STRIP001 		Reference< XPropertySet> xActiveFormSet(m_xActiveForm, UNO_QUERY);
//STRIP001 		if (xActiveFormSet.is())
//STRIP001 		{
//STRIP001 			xActiveFormSet->removePropertyChangeListener(FM_PROP_ISMODIFIED,this);
//STRIP001 			xActiveFormSet->removePropertyChangeListener(FM_PROP_ISNEW, this);
//STRIP001 
//STRIP001 			if (m_xParser.is())
//STRIP001 			{
//STRIP001 				xActiveFormSet->removePropertyChangeListener(FM_PROP_FILTER_CRITERIA, this);
//STRIP001 				xActiveFormSet->removePropertyChangeListener(FM_PROP_ACTIVECOMMAND,this);
//STRIP001 				xActiveFormSet->removePropertyChangeListener(FM_PROP_SORT,this);
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		Reference< ::com::sun::star::lang::XComponent> xComp(m_xParser, UNO_QUERY);
//STRIP001 		if (xComp.is())
//STRIP001 			xComp->dispose();
//STRIP001 		m_xParser = NULL;
//STRIP001 
//STRIP001 		if (m_xNavigationController.is())
//STRIP001 		{
//STRIP001 			Reference< XPropertySet> xSet(m_xNavigationController->getModel(), UNO_QUERY);
//STRIP001 			if (xSet.is())
//STRIP001 				xSet->removePropertyChangeListener(FM_PROP_ROWCOUNT, this);
//STRIP001 
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	m_bDatabaseBar = sal_False;
//STRIP001 	m_eNavigate  = NavigationBarMode_NONE;
//STRIP001 	m_xNavigationController = NULL;
//STRIP001 	m_bActiveModified = sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::ShowProperties(const Reference< XInterface>& rxObject, sal_Bool bShow)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	// Evtl. noch aktuelles Objekt umsetzen
//STRIP001 	if (rxObject != m_xSelObject)
//STRIP001 		setSelObject( rxObject );
//STRIP001 
//STRIP001 	// Wenn Fenster bereits angezeigt wird, nur StatusUpdate
//STRIP001 	sal_Bool bHasChild = m_pShell->GetViewShell()->GetViewFrame()->HasChildWindow(SID_FM_SHOW_PROPERTIES);
//STRIP001 	if (bHasChild && bShow)
//STRIP001 		InvalidateSlot(SID_FM_PROPERTY_CONTROL, sal_True, sal_True);
//STRIP001 
//STRIP001 	// Ansonsten Fenster ein-/ausblenden
//STRIP001 	else
//STRIP001 		m_pShell->GetViewShell()->GetViewFrame()->ToggleChildWindow(SID_FM_SHOW_PROPERTIES);
//STRIP001 
//STRIP001 	InvalidateSlot(SID_FM_PROPERTIES);
//STRIP001 	InvalidateSlot(SID_FM_CTL_PROPERTIES);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnFoundData, FmFoundRecordInformation*, pfriWhere)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT((pfriWhere->nContext >= 0) && (pfriWhere->nContext < (sal_Int16)m_arrSearchContexts.size()),
//STRIP001 		"FmXFormShell::OnFoundData : ungueltiger Kontext !");
//STRIP001 	Reference< XForm> xForm( m_arrSearchContexts.at(pfriWhere->nContext));
//STRIP001 	DBG_ASSERT(xForm.is(), "FmXFormShell::OnFoundData : ungueltige Form !");
//STRIP001 
//STRIP001 	Reference< XRowLocate> xCursor(xForm, UNO_QUERY);
//STRIP001 	if (!xCursor.is())
//STRIP001 		return 0;		// was soll ich da machen ?
//STRIP001 
//STRIP001 	// zum Datensatz
//STRIP001 	xCursor->moveToBookmark(pfriWhere->aPosition);
//STRIP001 
//STRIP001 	LoopGrids(GA_FORCE_SYNC);
//STRIP001 
//STRIP001 	// und zum Feld (dazu habe ich vor dem Start des Suchens die XVclComponent-Interfaces eingesammelt)
//STRIP001 	DBG_ASSERT(pfriWhere->nFieldPos < m_arrSearchedControls.Count(), "FmXFormShell::OnFoundData : ungueltige Daten uebergeben !");
//STRIP001 	SdrObject* pObject = m_arrSearchedControls.GetObject(pfriWhere->nFieldPos);
//STRIP001 	DBG_ASSERT(pObject != NULL, "FmXFormShell::OnFoundData : unerwartet : ungueltiges VclControl-Interface");
//STRIP001 
//STRIP001 	m_pShell->GetFormView()->UnMarkAll(m_pShell->GetFormView()->GetPageView(m_pShell->GetCurPage()));
//STRIP001 	m_pShell->GetFormView()->MarkObj(pObject, m_pShell->GetFormView()->GetPageView(m_pShell->GetCurPage()));
//STRIP001 
//STRIP001 	DBG_ASSERT(pObject->IsUnoObj(), "FmXFormShell::OnFoundData : ungueltiges Control !");
//STRIP001 	Reference< XControlModel> xControlModel( ((SdrUnoObj*)pObject)->GetUnoControlModel());
//STRIP001 	DBG_ASSERT(xControlModel.is(), "FmXFormShell::OnFoundData : ungueltiges Control !");
//STRIP001 
//STRIP001 	// disable the permanent cursor for the last grid we found a record
//STRIP001 	if (m_xLastGridFound.is() && (m_xLastGridFound != xControlModel))
//STRIP001 	{
//STRIP001 		Reference< XPropertySet> xOldSet(m_xLastGridFound, UNO_QUERY);
//STRIP001 		sal_Bool bB(sal_False);
//STRIP001 		xOldSet->setPropertyValue(FM_PROP_ALWAYSSHOWCURSOR, makeAny( (sal_Bool)sal_False ) );
//STRIP001 		Reference< XPropertyState> xOldSetState(xOldSet, UNO_QUERY);
//STRIP001 		if (xOldSetState.is())
//STRIP001 			xOldSetState->setPropertyToDefault(FM_PROP_CURSORCOLOR);
//STRIP001 		else
//STRIP001 			xOldSet->setPropertyValue(FM_PROP_CURSORCOLOR, Any());
//STRIP001 	}
//STRIP001 
//STRIP001 	// wenn das Feld sich in einem GridControl befindet, muss ich dort noch in die entsprechende Spalte gehen
//STRIP001 	sal_Int32 nGridColumn = m_arrRelativeGridColumn.GetObject(pfriWhere->nFieldPos);
//STRIP001 	if (nGridColumn != -1)
//STRIP001 	{	// dummer weise muss ich mir das Control erst wieder besorgen
//STRIP001 		Reference< XControl> xControl( GetControlFromModel(xControlModel));
//STRIP001 		Reference< XGrid> xGrid(xControl, UNO_QUERY);
//STRIP001 		DBG_ASSERT(xGrid.is(), "FmXFormShell::OnFoundData : ungueltiges Control !");
//STRIP001 		// wenn eine der Asserts anschlaegt, habe ich beim Aufbauen von m_arrSearchedControls wohl was falsch gemacht
//STRIP001 
//STRIP001 		// enable a permanent cursor for the grid so we can see the found text
//STRIP001 		Reference< XPropertySet> xModelSet(xControlModel, UNO_QUERY);
//STRIP001 		DBG_ASSERT(xModelSet.is(), "FmXFormShell::OnFoundData : invalid control model (no property set) !");
//STRIP001 		sal_Bool bB(sal_True);
//STRIP001 		xModelSet->setPropertyValue(FM_PROP_ALWAYSSHOWCURSOR, Any(&bB,getBooleanCppuType()));
//STRIP001 		xModelSet->setPropertyValue(FM_PROP_CURSORCOLOR, makeAny(sal_Int32(COL_LIGHTRED)));
//STRIP001 		m_xLastGridFound = xControlModel;
//STRIP001 
//STRIP001 		xGrid->setCurrentColumnPosition((sal_Int16)nGridColumn);
//STRIP001 	}
//STRIP001 
//STRIP001 	// als der Cursor neu positioniert wurde, habe ich (in positioned) meine Formularleisten-Slots invalidiert, aber das greift
//STRIP001 	// hier dummerweise nicht, da i.A. ja der (modale) Suchdialog oben ist ... also Gewalt ...
//STRIP001 	sal_uInt16 nPos = 0;
//STRIP001 	while (DatabaseSlotMap[nPos])
//STRIP001 		m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Update(DatabaseSlotMap[nPos++]);
//STRIP001 		// leider geht das Update im Gegensatz zum Invalidate nur mit einzelnen Slots)
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnCanceledNotFound, FmFoundRecordInformation*, pfriWhere)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT((pfriWhere->nContext >= 0) && (pfriWhere->nContext < (sal_Int16)m_arrSearchContexts.size()),
//STRIP001 		"FmXFormShell::OnCanceledNotFound : ungueltiger Kontext !");
//STRIP001 	Reference< XForm> xForm( m_arrSearchContexts.at(pfriWhere->nContext));
//STRIP001 	DBG_ASSERT(xForm.is(), "FmXFormShell::OnCanceledNotFound : ungueltige Form !");
//STRIP001 
//STRIP001 	Reference< XRowLocate> xCursor(xForm, UNO_QUERY);
//STRIP001 	if (!xCursor.is())
//STRIP001 		return 0;		// was soll ich da machen ?
//STRIP001 
//STRIP001 	// zum Datensatz
//STRIP001 	xCursor->moveToBookmark(pfriWhere->aPosition);
//STRIP001 
//STRIP001 	m_pShell->GetFormView()->UnMarkAll(m_pShell->GetFormView()->GetPageViewPvNum(0));
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnSearchContextRequest, FmSearchContext*, pfmscContextInfo)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(pfmscContextInfo->nContext < (sal_Int16)m_arrSearchContexts.size(), "FmXFormShell::OnSearchContextRequest : invalid parameter !");
//STRIP001 	Reference< XForm> xForm( m_arrSearchContexts.at(pfmscContextInfo->nContext));
//STRIP001 	DBG_ASSERT(xForm.is(), "FmXFormShell::OnSearchContextRequest : unexpected : invalid context !");
//STRIP001 
//STRIP001 	Reference< XResultSet> xIter(xForm, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xIter.is(), "FmXFormShell::OnSearchContextRequest : unexpected : context has no iterator !");
//STRIP001 
//STRIP001 	// --------------------------------------------------------------------------------------------
//STRIP001 	// die Liste der zu involvierenden Felder zusammenstellen (sind die ControlSources aller Felder, die eine solche Eigenschaft habe)
//STRIP001 	UniString strFieldList, sFieldDisplayNames;
//STRIP001 	m_arrSearchedControls.Remove(0, m_arrSearchedControls.Count());
//STRIP001 	m_arrRelativeGridColumn.Remove(0, m_arrRelativeGridColumn.Count());
//STRIP001 
//STRIP001 	// folgendes kleines Problem : Ich brauche, um gefundene Felder zu markieren, SdrObjekte. Um hier festzustellen, welche Controls
//STRIP001 	// ich in die Suche einbeziehen soll, brauche ich Controls (also XControl-Interfaces). Ich muss also ueber eines von beiden
//STRIP001 	// iterieren und mir das jeweils andere besorgen. Dummerweise gibt es keine direkte Verbindung zwischen beiden Welten (abgesehen
//STRIP001 	// von einem GetUnoControl an SdrUnoObject, das aber ein OutputDevice verlangt, womit ich nichts anfangen kann).
//STRIP001 	// Allerdings komme ich sowohl von einem Control als auch von einem SdrObject zum Model, und damit ist mir mit einer doppelten
//STRIP001 	// Schleife die Zuordnung SdrObject<->Control moeglich.
//STRIP001 	// Die Alternative zu dieser (unschoenen und sicher auch nicht ganz fixen) Loesung waere, auf das Cachen der SdrObjects zu
//STRIP001 	// verzichten, was dann aber in OnFoundData zu wesentlicher Mehrarbeit fuehren wuerde (da ich mir dort jedesmal das SdrObject
//STRIP001 	// erst besorgen muesste). Da aber OnFoundData i.d.R. oefter aufgerufen wird als ExecuteSearch, erledige ich das hier.
//STRIP001 
//STRIP001 	Reference< XNameAccess> xValidFormFields;
//STRIP001 	Reference< XColumnsSupplier> xSupplyCols(xIter, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xSupplyCols.is(), "FmXFormShell::OnSearchContextRequest : invalid cursor : no columns supplier !");
//STRIP001 	if (xSupplyCols.is())
//STRIP001 		xValidFormFields = xSupplyCols->getColumns();
//STRIP001 	DBG_ASSERT(xValidFormFields.is(), "FmXFormShell::OnSearchContextRequest : form has no fields !");
//STRIP001 
//STRIP001 	// aktuelle(r) Page/Controller
//STRIP001 	FmFormPage* pCurrentPage = m_pShell->GetCurPage();
//STRIP001 	DBG_ASSERT(pCurrentPage!=NULL, "FmXFormShell::OnSearchContextRequest : no page !");
//STRIP001 	// alle Sdr-Controls dieser Seite durchsuchen ...
//STRIP001 	::rtl::OUString sControlSource, sCompareString,aName;
//STRIP001 	for (sal_Int32 i=0; i<(sal_Int32)pCurrentPage->GetObjCount(); ++i)
//STRIP001 	{
//STRIP001 		SdrObject* pCurrent = pCurrentPage->GetObj(i);
//STRIP001 
//STRIP001 		// wenn das Ding eine Gruppierung ist -> durchiterieren
//STRIP001 		SdrObjListIter* pGroupIterator = NULL;
//STRIP001 		if (pCurrent->IsGroupObject())
//STRIP001 		{
//STRIP001 			pGroupIterator = new SdrObjListIter(*pCurrent->GetSubList());
//STRIP001 			pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
//STRIP001 		}
//STRIP001 
//STRIP001 		while (pCurrent)
//STRIP001 		{
//STRIP001 			if (pCurrent->IsUnoObj())
//STRIP001 			{
//STRIP001 				// das Model zum aktuellen Object ...
//STRIP001 				Reference< XControlModel> xControlModel( ((SdrUnoObj*)pCurrent)->GetUnoControlModel());
//STRIP001 				DBG_ASSERT(xControlModel.is(), "FmXFormShell::OnSearchContextRequest : invalid objects !");
//STRIP001 				// ... als FormComponent
//STRIP001 				Reference< XFormComponent> xCurrentAsFormComponent(xControlModel, UNO_QUERY);
//STRIP001 				if (!xCurrentAsFormComponent.is())
//STRIP001 				{
//STRIP001 					if (pGroupIterator) 	// ich iteriere gerade durch eine Gruppe von Controls
//STRIP001 						pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
//STRIP001 					else
//STRIP001 						pCurrent = NULL;
//STRIP001 					continue;
//STRIP001 				}
//STRIP001 
//STRIP001 				// gehoert diese FormComponent ueberhaupt zu der Form, um die es geht ?
//STRIP001 				Reference< XInterface> xParentOfCurrent( xCurrentAsFormComponent->getParent());
//STRIP001 				if (xParentOfCurrent != xForm) // vergleich fuehrt zu richtigem Ergebnis, seit TF_ONE
//STRIP001 				{
//STRIP001 					if (pGroupIterator) 	// ich iteriere gerade durch eine Gruppe von Controls
//STRIP001 						pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
//STRIP001 					else
//STRIP001 						pCurrent = NULL;
//STRIP001 					continue;
//STRIP001 				}
//STRIP001 
//STRIP001 				// ... nach der ControlSource-Eigenschaft fragen
//STRIP001 				SearchableControlIterator iter(xCurrentAsFormComponent);
//STRIP001 				Reference< XControl> xControlBehindModel;
//STRIP001 					// das Control, das als Model xControlModel hat
//STRIP001 					// (das folgende while kann mehrmals durchlaufen werden, ohne dass das Control sich aendert, dann muss
//STRIP001 					// ich nicht jedesmal neu suchen)
//STRIP001 
//STRIP001 				Reference< XInterface> xCurrent( iter.Next());
//STRIP001 				while (xCurrent.is())
//STRIP001 				{
//STRIP001 					sControlSource = iter.getCurrentValue();
//STRIP001 					if (sControlSource == sCompareString)
//STRIP001 					{	// das aktuelle Element hat keine ControlSource, also ist es ein GridControl (das ist das einzige, was
//STRIP001 						// der SearchableControlIterator noch zulaesst)
//STRIP001 						xControlBehindModel = GetControlFromModel(xControlModel);
//STRIP001 						DBG_ASSERT(xControlBehindModel.is(), "FmXFormShell::OnSearchContextRequest : didn't ::std::find a control with requested model !");
//STRIP001 
//STRIP001 						Reference< XGridPeer> xGridPeer(xControlBehindModel->getPeer(), UNO_QUERY);
//STRIP001 						do
//STRIP001 						{
//STRIP001 							if (!xGridPeer.is())
//STRIP001 								break;
//STRIP001 
//STRIP001 							Reference< XIndexAccess> xPeerContainer(xGridPeer, UNO_QUERY);
//STRIP001 							if (!xPeerContainer.is())
//STRIP001 								break;
//STRIP001 
//STRIP001 							Reference< XIndexAccess> xModelColumns(xGridPeer->getColumns(), UNO_QUERY);
//STRIP001 							DBG_ASSERT(xModelColumns.is(), "FmXFormShell::OnSearchContextRequest : there is a grid control without columns !");
//STRIP001 								// the case 'no columns' should be indicated with an empty container, I think ...
//STRIP001 							DBG_ASSERT(xModelColumns->getCount() >= xPeerContainer->getCount(), "FmXFormShell::OnSearchContextRequest : impossible : have more view than model columns !");
//STRIP001 
//STRIP001 							Reference< XInterface> xCurrentColumn;
//STRIP001 							for (sal_Int16 nViewPos=0; nViewPos<xPeerContainer->getCount(); ++nViewPos)
//STRIP001 							{
//STRIP001 								xPeerContainer->getByIndex(nViewPos) >>= xCurrentColumn;
//STRIP001 								if (!xCurrentColumn.is())
//STRIP001 									continue;
//STRIP001 
//STRIP001 								// can we use this column control fo searching ?
//STRIP001 								if (!IsSearchableControl(xCurrentColumn))
//STRIP001 									continue;
//STRIP001 
//STRIP001 								sal_Int16 nModelPos = GridView2ModelPos(xModelColumns, nViewPos);
//STRIP001 								Reference< XPropertySet> xCurrentColModel;
//STRIP001 								xModelColumns->getByIndex(nModelPos) >>= xCurrentColModel;
//STRIP001 								aName = ::comphelper::getString(xCurrentColModel->getPropertyValue(FM_PROP_CONTROLSOURCE));
//STRIP001 								// the cursor has a field matching the control source ?
//STRIP001 								if (xValidFormFields->hasByName(aName))
//STRIP001 								{
//STRIP001 									strFieldList += aName.getStr();
//STRIP001 									strFieldList += ';';
//STRIP001 
//STRIP001 									sFieldDisplayNames += ::comphelper::getString(xCurrentColModel->getPropertyValue(FM_PROP_LABEL)).getStr();
//STRIP001 									sFieldDisplayNames += ';';
//STRIP001 
//STRIP001 									pfmscContextInfo->arrFields.push_back(xCurrentColumn);
//STRIP001 
//STRIP001 									// und das SdrObjekt zum Feld
//STRIP001 									m_arrSearchedControls.C40_INSERT(SdrObject, pCurrent, m_arrSearchedControls.Count());
//STRIP001 									// die Nummer der Spalte
//STRIP001 									m_arrRelativeGridColumn.Insert(nViewPos, m_arrRelativeGridColumn.Count());
//STRIP001 								}
//STRIP001 							}
//STRIP001 						} while (sal_False);
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						if (sControlSource.getLength() && xValidFormFields->hasByName(sControlSource))
//STRIP001 						{
//STRIP001 							// jetzt brauche ich das Control zum SdrObject
//STRIP001 							if (!xControlBehindModel.is())
//STRIP001 							{
//STRIP001 								xControlBehindModel = GetControlFromModel(xControlModel);
//STRIP001 								DBG_ASSERT(xControlBehindModel.is(), "FmXFormShell::OnSearchContextRequest : didn't ::std::find a control with requested model !");
//STRIP001 							}
//STRIP001 
//STRIP001 							if (IsSearchableControl(xControlBehindModel))
//STRIP001 							{	// alle Tests ueberstanden -> in die Liste mit aufnehmen
//STRIP001 								strFieldList += sControlSource.getStr();
//STRIP001 								strFieldList += ';';
//STRIP001 
//STRIP001 								// the label which should appear for the control :
//STRIP001 								sFieldDisplayNames += getLabelName(Reference< XPropertySet>(xControlModel, UNO_QUERY)).getStr();
//STRIP001 								sFieldDisplayNames += ';';
//STRIP001 
//STRIP001 								// das SdrObjekt merken (beschleunigt die Behandlung in OnFoundData)
//STRIP001 								m_arrSearchedControls.C40_INSERT(SdrObject, pCurrent, m_arrSearchedControls.Count());
//STRIP001 
//STRIP001 								// die Nummer der Spalte (hier ein Dummy, nur fuer GridControls interesant)
//STRIP001 								m_arrRelativeGridColumn.Insert(-1, m_arrRelativeGridColumn.Count());
//STRIP001 
//STRIP001 								// und fuer die formatierte Suche ...
//STRIP001 								pfmscContextInfo->arrFields.push_back(Reference< XInterface>(xControlBehindModel, UNO_QUERY));
//STRIP001 							}
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					xCurrent = iter.Next();
//STRIP001 				}
//STRIP001 			}
//STRIP001 
//STRIP001 			if (pGroupIterator) 	// ich iteriere gerade durch eine Gruppe von Controls
//STRIP001 				pCurrent = pGroupIterator->IsMore() ? pGroupIterator->Next() : NULL;
//STRIP001 			else
//STRIP001 				pCurrent = NULL;
//STRIP001 		}
//STRIP001 		delete pGroupIterator;
//STRIP001 	}
//STRIP001 	strFieldList.EraseTrailingChars(';');
//STRIP001 	sFieldDisplayNames.EraseTrailingChars(';');
//STRIP001 
//STRIP001 	if (!pfmscContextInfo->arrFields.size())
//STRIP001 	{
//STRIP001 		pfmscContextInfo->arrFields.clear();
//STRIP001 		pfmscContextInfo->xCursor = NULL;
//STRIP001 		pfmscContextInfo->strUsedFields.Erase();
//STRIP001 		return 0L;
//STRIP001 	}
//STRIP001 
//STRIP001 	pfmscContextInfo->xCursor = xIter;
//STRIP001 	pfmscContextInfo->strUsedFields = strFieldList;
//STRIP001 	pfmscContextInfo->sFieldDisplayNames = sFieldDisplayNames;
//STRIP001 
//STRIP001 	// 66463 - 31.05.99 - FS
//STRIP001 	// wenn der Cursor sich in einem anderen RecordMode als STANDARD befindet, ruecksetzen
//STRIP001 	Reference< XPropertySet> xCursorSet(pfmscContextInfo->xCursor, UNO_QUERY);
//STRIP001 	Reference< XResultSetUpdate> xUpdateCursor(pfmscContextInfo->xCursor, UNO_QUERY);
//STRIP001 	if (xUpdateCursor.is() && xCursorSet.is() && xCursorSet.is())
//STRIP001 		if (::comphelper::getBOOL(xCursorSet->getPropertyValue(FM_PROP_ISNEW)))
//STRIP001 			xUpdateCursor->moveToCurrentRow();
//STRIP001 		else
//STRIP001 			if (::comphelper::getBOOL(xCursorSet->getPropertyValue(FM_PROP_ISMODIFIED)))
//STRIP001 				xUpdateCursor->cancelRowUpdates();
//STRIP001 
//STRIP001 	return pfmscContextInfo->arrFields.size();
//STRIP001 }

  // XContainerListener
//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::elementInserted(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// neues Object zum lauschen
/*N*/ 	Reference< XInterface> xTemp;
/*N*/ 	evt.Element >>= xTemp;
/*N*/ 	AddElement(xTemp);
/*N*/ 	m_pShell->DetermineForms(sal_True);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::elementReplaced(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*N*/ {DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XInterface> xTemp;
//STRIP001 	evt.ReplacedElement >>= xTemp;
//STRIP001 	RemoveElement(xTemp);
//STRIP001 	evt.Element >>= xTemp;
//STRIP001 	AddElement(xTemp);
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormShell::elementRemoved(const ContainerEvent& evt) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XInterface> xTemp;
//STRIP001 	evt.Element >>= xTemp;
//STRIP001 	RemoveElement(xTemp);
//STRIP001 	m_pShell->DetermineForms(sal_True);
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::ResetForms(const Reference< XIndexAccess>& _xForms, sal_Bool bInvalidate)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (m_xForms != _xForms)
/*N*/ 	{
/*N*/ 		RemoveElement(m_xForms);
/*N*/ 
/*N*/ 		m_xForms = _xForms;
/*N*/ 
/*N*/ 		AddElement(m_xForms);
/*N*/ 	}
/*N*/ 	m_pShell->DetermineForms(bInvalidate);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::AddElement(const Reference< XInterface>& Element)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// am Container horchen
/*N*/ 	Reference< XIndexContainer> xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface> xElement;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xElement;
/*N*/ 			AddElement(xElement);
/*N*/ 		}
/*N*/ 
/*N*/ 		Reference< XContainer> xCont(Element, UNO_QUERY);
/*N*/ 		if (xCont.is())
/*N*/ 			xCont->addContainerListener(this);
/*N*/ 	}
/*N*/ 
/*N*/ 	Reference< ::com::sun::star::view::XSelectionSupplier> xSelSupplier(Element, UNO_QUERY);
/*N*/ 	if (xSelSupplier.is())
/*?*/ 		xSelSupplier->addSelectionChangeListener(this);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::RemoveElement(const Reference< XInterface>& Element)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	Reference< ::com::sun::star::view::XSelectionSupplier> xSelSupplier(Element, UNO_QUERY);
/*N*/ 	if (xSelSupplier.is())
/*?*/ 		xSelSupplier->removeSelectionChangeListener(this);
/*N*/ 
/*N*/ 	// Verbindung zu Kindern aufheben
/*N*/ 	Reference< XIndexContainer> xContainer(Element, UNO_QUERY);
/*N*/ 	if (xContainer.is())
/*N*/ 	{
/*N*/ 		Reference< XContainer> xCont(Element, UNO_QUERY);
/*N*/ 		if (xCont.is())
/*N*/ 			xCont->removeContainerListener(this);
/*N*/ 
/*N*/ 		sal_uInt32 nCount = xContainer->getCount();
/*N*/ 		Reference< XInterface> xElement;
/*N*/ 		for (sal_uInt32 i = 0; i < nCount; i++)
/*N*/ 		{
/*N*/ 			xContainer->getByIndex(i) >>= xElement;
/*N*/ 			RemoveElement(xElement);
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
/*?*/ void FmXFormShell::selectionChanged(const EventObject& rEvent) throw(::com::sun::star::uno::RuntimeException)
/*?*/ {
/*?*/ DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< ::com::sun::star::view::XSelectionSupplier> xSupplier(rEvent.Source, UNO_QUERY);
//STRIP001 	Any aSelObj( xSupplier->getSelection() );
//STRIP001 	if (aSelObj.getValueTypeClass() != TypeClass_INTERFACE)
//STRIP001 		return;
//STRIP001 	Reference< XInterface> xSelObj;
//STRIP001 	aSelObj >>= xSelObj;
//STRIP001 
//STRIP001 	// es wurde eine Selektion weggenommen, dieses kann nur durch die Shell vorgenommen werden
//STRIP001 	if (!xSelObj.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	Reference< XInterface> xPreviousObject( getSelObject());
//STRIP001 	EnableTrackProperties(sal_False);
//STRIP001 
//STRIP001 	sal_Bool bMarkChanged = m_pShell->GetFormView()->checkUnMarkAll(rEvent.Source);
//STRIP001 	Reference< XForm> xNewForm( GetForm(rEvent.Source));
//STRIP001 
//STRIP001 	setCurControl(xSelObj);
//STRIP001 	setCurForm(xNewForm);
//STRIP001 
//STRIP001 	// wurde vorher Form angezeigt, dann wieder die Form anzeigen
//STRIP001 	Reference< XForm> xOldForm(xPreviousObject, UNO_QUERY);
//STRIP001 	if (xOldForm.is())
//STRIP001 		setSelObject(m_xCurForm);
//STRIP001 	else
//STRIP001 		setSelObject(m_xCurControl);
//STRIP001 
//STRIP001 	if (IsPropBrwOpen() && m_xSelObject != xPreviousObject)
//STRIP001 		ShowProperties(m_xSelObject, sal_True);
//STRIP001 
//STRIP001 	EnableTrackProperties(sal_True);
//STRIP001 	if ( bMarkChanged )
//STRIP001 		m_pShell->NotifyMarkListChanged(m_pShell->GetFormView());
/*?*/ }

//------------------------------------------------------------------------------
/*N*/ IMPL_LINK(FmXFormShell, OnTimeOut, void*, EMPTYTAG)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	if (m_pShell->IsDesignMode() && m_pShell->GetFormView())
/*N*/ 		SetSelection(m_pShell->GetFormView()->GetMarkList());
/*N*/ 
/*N*/ 	return 0;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::SetSelectionDelayed(FmFormView* pView)
/*N*/ {
/*N*/ 	if (m_pShell->IsDesignMode() && IsTrackPropertiesEnabled() && !m_aMarkTimer.IsActive())
/*N*/ 		m_aMarkTimer.Start();
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::SetSelection(const SdrMarkList& rMarkList)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DetermineSelection(rMarkList);
/*N*/ 	m_pShell->NotifyMarkListChanged(m_pShell->GetFormView());
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::DetermineSelection(const SdrMarkList& rMarkList)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	// Aktuelles Objekt setzen
/*N*/ 	Reference< XInterface> xPreviousObject( m_xSelObject);
/*N*/ 	sal_Bool bMixedWithFormControls = sal_True;
/*N*/ 	Reference< XForm> xNewForm( DetermineCurForm(rMarkList, bMixedWithFormControls));
/*N*/ 
/*N*/ 	// Aktuelle Form anpassen
/*N*/ 	if (xNewForm.is() || bMixedWithFormControls)
/*N*/ 	{
/*N*/ 		// die Form wird nur angepasst, wenn eine eindeutige From gefunden wurde oder eine gemischte Selektion existiert,
/*N*/ 		// die auch FormControls enthaelt (NICHT bei einer Selektion ohne solche oder bei leerer Selektion)
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		if ((XForm*)xNewForm.get() != (XForm*)m_xCurForm.get())
//STRIP001 /*?*/ 			setCurForm( xNewForm );
/*N*/ 	}
/*N*/ 
/*N*/ 	setCurControl(rMarkList);
/*N*/ 
/*N*/ 	// wurde vorher Form angezeigt, dann wieder die Form anzeigen
/*N*/ 	Reference< XForm> xOldForm(m_xSelObject, UNO_QUERY);
/*N*/ 	if (xOldForm.is())
/*?*/ 		setSelObject(xNewForm);
/*N*/ 	else
/*N*/ 		setSelObject(m_xCurControl);
/*N*/ 
/*N*/ 	// Falls ein Propertybrowser angezeigt wird, diesen invalidieren
/*N*/ 	if (IsPropBrwOpen() && xPreviousObject != m_xSelObject)
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		ShowProperties(m_xSelObject, sal_True);
/*N*/ }

//------------------------------------------------------------------------------
/*N*/ sal_Bool FmXFormShell::IsPropBrwOpen() const
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	return( ( m_pShell->GetViewShell() && m_pShell->GetViewShell()->GetViewFrame() ) ?
/*N*/ 			m_pShell->GetViewShell()->GetViewFrame()->HasChildWindow(SID_FM_SHOW_PROPERTIES) : sal_False );
/*N*/ }

//------------------------------------------------------------------------------
class FmXFormShell::SuspendPropertyTracking
{
private:
	FmXFormShell*	m_pShell;
	sal_Bool		m_bEnabled;

public:
	SuspendPropertyTracking( FmXFormShell* _pShell )
		:m_pShell( _pShell )
		,m_bEnabled( sal_False )
	{
		if ( m_pShell && m_pShell->IsTrackPropertiesEnabled() )
		{
			m_pShell->EnableTrackProperties( sal_False );
			m_bEnabled = sal_True;
		}
	}

//STRIP001 	~SuspendPropertyTracking( )
//STRIP001 	{
//STRIP001 		if ( m_bEnabled )	// note that ( sal_False != m_bEnabled ) implies ( NULL != m_pShell )
//STRIP001 			m_pShell->EnableTrackProperties( sal_True );
//STRIP001 	}
};

//------------------------------------------------------------------------------
/*N*/ void FmXFormShell::SetDesignMode(sal_Bool bDesign)
/*N*/ {
/*N*/ 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
/*N*/ 	DBG_ASSERT(m_pShell && m_pShell->GetFormView(), "FmXFormShell::SetDesignMode : invalid call (have no shell or no view) !");
/*N*/ 	m_bChangingDesignMode = sal_True;
/*N*/ 
/*N*/ 	// 67506 - 15.07.99 - FS
/*N*/ 	// if we're switching off the design mode we have to force the property browser to be closed
/*N*/ 	// so it can commit it's changes _before_ we load the forms
/*N*/ 	if (!bDesign)
/*N*/ 	{
/*N*/ 		m_bHadPropBrw = m_pShell->GetViewShell()->GetViewFrame()->HasChildWindow(SID_FM_SHOW_PROPERTIES);
/*N*/ 		if (m_bHadPropBrw)
/*?*/ 		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 m_pShell->GetViewShell()->GetViewFrame()->ToggleChildWindow(SID_FM_SHOW_PROPERTIES);
/*N*/ 	}
/*N*/ 
/*N*/ 	FmFormView* pFormView = m_pShell->GetFormView();
/*N*/ 	if (bDesign)
/*N*/ 	{
/*N*/ 		// we are currently filtering, so stop filtering
/*N*/ 		if (m_bFilterMode)
/*?*/			DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 			stopFiltering(sal_False);
/*N*/ 
/*N*/ 		// an den Objekten meiner MarkList als Listener abmelden
/*N*/ 		pFormView->GetImpl()->stopMarkListWatching();
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		m_aMarkTimer.Stop();
/*N*/ 
/*N*/ 		SuspendPropertyTracking aSuspend( this );
/*N*/ 		pFormView->GetImpl()->saveMarkList( sal_True );
/*N*/ 	}
/*N*/ 
/*N*/ 	if (bDesign && m_xExternalViewController.is())
/*?*/ 		CloseExternalFormViewer();
/*N*/ 
/*N*/ 	pFormView->ChangeDesignMode(bDesign);
/*N*/ 
/*N*/ 	// Listener benachrichtigen
/*N*/ 	FmDesignModeChangedHint aChangedHint( bDesign );
/*N*/ 	m_pShell->Broadcast(aChangedHint);
/*N*/ 
/*N*/ 	FmFormPage* pPage = m_pShell->GetCurPage();
/*N*/ 	if (pPage)
/*N*/ 	{
/*N*/ 		if (bDesign)
/*N*/ 		{
/*N*/ 			Reference< XIndexAccess> xIndex(pPage->GetForms(), UNO_QUERY);
/*N*/ 			ResetForms(xIndex, sal_False);
/*N*/ 		}
/*N*/ 		else
/*N*/ 			ResetForms();
/*N*/ 	}
/*N*/ 
/*N*/ 	m_pShell->m_bDesignMode = bDesign;
/*N*/ 	if (bDesign)
/*N*/ 	{
/*N*/ 		SdrMarkList aList;
/*N*/ 		{
/*N*/ 			// during changing the mark list, don't track the selected objects in the property browser
/*N*/ 			SuspendPropertyTracking aSuspend( this );
/*N*/ 			// restore the marks
/*N*/ 			pFormView->GetImpl()->restoreMarkList( aList );
/*N*/ 		}
/*N*/ 
/*N*/ 		// synchronize with the restored mark list
/*N*/ 		if ( aList.GetMarkCount() )
/*?*/ 			SetSelection( aList );
/*N*/ 	}
/*N*/ 	else
/*N*/ 	{
/*N*/ 		// am Model der View als Listener anmelden (damit ich mitbekomme, wenn jemand waehrend des Alive-Modus
/*N*/ 		// Controls loescht, die ich eigentlich mit saveMarkList gespeichert habe) (60343)
/*N*/ 		pFormView->GetImpl()->startMarkListWatching();
/*N*/ 	}
/*N*/ 
/*N*/ 	m_pShell->UIFeatureChanged();
/*N*/ 
/*N*/ 	// 67506 - 15.07.99 - FS
/*N*/ 	if (bDesign && m_bHadPropBrw)
/*N*/ 	{
/*N*/ 		// The UIFeatureChanged performes an update (a check of the available features) asynchronously.
/*N*/ 		// So we can't call ShowProperties directly as the according feature isn't enabled yet.
/*N*/ 		// That's why we use an asynchron execution on the dispatcher.
/*N*/ 		// (And that's why this has to be done AFTER the UIFeatureChanged.)
/*?*/		DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 		FmInterfaceItem aInterfaceItem( SID_FM_SHOW_PROPERTY_BROWSER, getSelObject() );
//STRIP001 /*?*/ 		m_pShell->GetViewShell()->GetViewFrame()->GetDispatcher()->Execute( SID_FM_SHOW_PROPERTY_BROWSER, SFX_CALLMODE_ASYNCHRON,
//STRIP001 /*?*/ 			&aInterfaceItem, 0L );
/*N*/ 	}
/*N*/ 	m_bChangingDesignMode = sal_False;
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 Reference< XControl> FmXFormShell::GetControlFromModel(const Reference< XControlModel>& xModel)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	// die View ...
//STRIP001 	SdrPageView* pCurPageView = m_pShell->GetFormView()->GetPageViewPvNum(0);
//STRIP001 	// deren ViewWinRec-Liste, daraus das erste Element
//STRIP001 	DBG_ASSERT(pCurPageView->GetWinList().GetCount() > 0, "FmXFormShell::GetControlFromModel : unexpected : no SdrPageViewWinRecs");
//STRIP001 	const SdrPageViewWinRec& rViewWinRec = pCurPageView->GetWinList()[0];
//STRIP001 	// von dem bekomme ich alle Controls ...
//STRIP001 	Reference< XControlContainer> xControlContainer(rViewWinRec.GetControlContainerRef());
//STRIP001 	Sequence< Reference< XControl> > seqControls( xControlContainer->getControls() );
//STRIP001 	Reference< XControl>* pControls = seqControls.getArray();
//STRIP001 	// ... die ich dann durchsuchen kann
//STRIP001 	for (int i=0; i<seqControls.getLength(); ++i)
//STRIP001 	{
//STRIP001 		Reference< XControlModel> xSearchLoopModel( pControls[i]->getModel());
//STRIP001 		if ((XControlModel*)xSearchLoopModel.get() == (XControlModel*)xModel.get())
//STRIP001 			return pControls[i];
//STRIP001 	}
//STRIP001 	return Reference< XControl>(NULL);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::CollectFormContexts(const Reference< XInterface>& xStartingPoint, const UniString& sCurrentLevelPrefix, UniString& sNames)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XIndexAccess> xAllComponentIndizies(xStartingPoint, UNO_QUERY);
//STRIP001 
//STRIP001 	if (xAllComponentIndizies.is() && xAllComponentIndizies->getCount())
//STRIP001 	{
//STRIP001 		// work through all children
//STRIP001 		UniString sCurrentFormName, sNextLevelPrefix;
//STRIP001 		Reference< XForm> xCurrentAsForm;
//STRIP001 		for (sal_Int32 i=0; i<xAllComponentIndizies->getCount(); ++i)
//STRIP001 		{
//STRIP001 			xAllComponentIndizies->getByIndex(i) >>= xCurrentAsForm;;
//STRIP001 			// is the current child a form?
//STRIP001 			if (xCurrentAsForm.is())
//STRIP001 			{
//STRIP001 				Reference< XPropertySet> xAskForName(xCurrentAsForm, UNO_QUERY);
//STRIP001 				if (xAskForName.is())
//STRIP001 				{
//STRIP001 					try { sCurrentFormName = ::comphelper::getString(xAskForName->getPropertyValue(FM_PROP_NAME)).getStr(); }
//STRIP001 					catch(Exception&)
//STRIP001 					{
//STRIP001 						DBG_ERROR("FmXFormShell::CollectFormContexts: Exception occured!");
//STRIP001 					}
//STRIP001 				}
//STRIP001 				// den Namen an die Aufzaehlung haengen
//STRIP001 				sNames += ';';
//STRIP001 				sNames += sCurrentFormName;
//STRIP001 				if (sCurrentLevelPrefix.Len() != 0)
//STRIP001 				{
//STRIP001 					sNames.AppendAscii(" (");
//STRIP001 					sNames += sCurrentLevelPrefix;
//STRIP001 					sNames += ')';
//STRIP001 				}
//STRIP001 
//STRIP001 				// den Prefix fuer den naechsten Level
//STRIP001 				sNextLevelPrefix = sCurrentLevelPrefix;
//STRIP001 				if (sCurrentLevelPrefix.Len() != 0)
//STRIP001 					sNextLevelPrefix += '/';
//STRIP001 				sNextLevelPrefix += sCurrentFormName;
//STRIP001 
//STRIP001 				// das Interface merken
//STRIP001 				m_arrSearchContexts.push_back(xCurrentAsForm);
//STRIP001 
//STRIP001 				// und absteigen
//STRIP001 				CollectFormContexts(xCurrentAsForm, sNextLevelPrefix, sNames);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 Reference< XPropertySet> FmXFormShell::GetBoundField(const Reference< XControl>& _xControl, const Reference< XForm>& _xForm) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	// sonderbehandlung fuer databaseGrid
//STRIP001 	Reference< XGrid> xGrid(_xControl, UNO_QUERY);
//STRIP001 	Reference< XPropertySet> xModel, xField;
//STRIP001 
//STRIP001 	if (xGrid.is())
//STRIP001 	{
//STRIP001 		sal_Int16 nCurrentPos = xGrid->getCurrentColumnPosition();
//STRIP001 		Reference< XIndexAccess> xCols(_xControl->getModel(), UNO_QUERY);
//STRIP001 		nCurrentPos = GridView2ModelPos(xCols, nCurrentPos);
//STRIP001 		if (nCurrentPos != (sal_Int16)-1)
//STRIP001 			 xCols->getByIndex(nCurrentPos) >>= xModel;
//STRIP001 	}
//STRIP001 	else if (_xControl.is())
//STRIP001 	{
//STRIP001 		xModel = Reference< XPropertySet>(_xControl->getModel(), UNO_QUERY);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Das gebundene Feld ist jetzt eine extra Eigenschaft, nicht mehr indirekt ueber die ControlSource zu besorgen,
//STRIP001 	// da das Control selber durchaus entscheiden kann, dass es sich trotz gueltiger ControlSource nicht binden will.
//STRIP001 	// (zum Beispiel ein TextControl an ein Bild-Feld)
//STRIP001 	// (FS - 64265)
//STRIP001 	if (xModel.is() && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xModel))
//STRIP001 		xModel->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 
//STRIP001 	return xField;
//STRIP001 }

//------------------------------------------------------------------------------
//void FmXFormShell::SetWizardUsing(sal_Bool bUseThem)
//{
//	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//
//	m_bUseWizards = bUseThem;
//
//	// forward this to the configuration
//	Sequence< ::rtl::OUString > aNames(1);
//	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
//	Sequence< Any > aValues(1);
//	aValues[0] = bool2any(m_bUseWizards);
//	m_aWizardUsing.SetProperties(aNames, aValues);
//}

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::startFiltering()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	// setting all forms in filter mode
//STRIP001 	FmXFormView* pXView = m_pShell->GetFormView()->GetImpl();
//STRIP001 
//STRIP001 	// if the active controller is our external one we have to use the trigger controller
//STRIP001 	Reference< XControlContainer> xContainer;
//STRIP001 	if (getActiveController() == m_xExternalViewController)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(m_xExtViewTriggerController.is(), "FmXFormShell::startFiltering : inconsistent : active external controller, but noone triggered this !");
//STRIP001 		xContainer = m_xExtViewTriggerController->getContainer();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		xContainer = getActiveController()->getContainer();
//STRIP001 
//STRIP001 	FmWinRecList::iterator i = pXView->findWindow(xContainer);
//STRIP001 	if (i != pXView->getWindowList().end())
//STRIP001 	{
//STRIP001 		const ::std::vector< Reference< XFormController> >& rControllerList = (*i)->GetList();
//STRIP001 		for (::std::vector< Reference< XFormController> >::const_iterator j = rControllerList.begin();
//STRIP001 			 j != rControllerList.end(); ++j)
//STRIP001 		{
//STRIP001 			Reference< XModeSelector> xModeSelector(*j, UNO_QUERY);
//STRIP001 			if (xModeSelector.is())
//STRIP001 				xModeSelector->setMode(FILTER_MODE);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	m_bFilterMode = sal_True;
//STRIP001 
//STRIP001 	m_pShell->UIFeatureChanged();
//STRIP001 	m_pShell->GetViewShell()->GetViewFrame()->GetBindings().InvalidateShell(*m_pShell);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void saveFilter(const Reference< XFormController>& _rxController)
//STRIP001 {
//STRIP001 	Reference< XPropertySet> xFormAsSet(_rxController->getModel(), UNO_QUERY);
//STRIP001 	Reference< XPropertySet> xControllerAsSet(_rxController, UNO_QUERY);
//STRIP001 	Reference< XIndexAccess> xControllerAsIndex(_rxController, UNO_QUERY);
//STRIP001 
//STRIP001 	// call the subcontroller
//STRIP001 	Reference< XFormController> xController;
//STRIP001 	for (sal_Int32 i = 0, nCount = xControllerAsIndex->getCount(); i < nCount; ++i)
//STRIP001 	{
//STRIP001 		xControllerAsIndex->getByIndex(i) >>= xController;
//STRIP001 		saveFilter(xController);
//STRIP001 	}
//STRIP001 
//STRIP001 	try
//STRIP001 	{
//STRIP001 
//STRIP001 		xFormAsSet->setPropertyValue(FM_PROP_FILTER_CRITERIA, xControllerAsSet->getPropertyValue(FM_PROP_FILTER_CRITERIA));
//STRIP001 
//STRIP001 		sal_Bool bB(sal_True);
//STRIP001 		xFormAsSet->setPropertyValue(FM_PROP_APPLYFILTER, Any(&bB,getBooleanCppuType()));
//STRIP001 	}
//STRIP001 	catch(Exception&)
//STRIP001 	{
//STRIP001 		DBG_ERROR("saveFilter: Exception occured!");
//STRIP001 	}
//STRIP001 
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::stopFiltering(sal_Bool bSave)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	m_bFilterMode = sal_False;
//STRIP001 
//STRIP001 	FmXFormView* pXView = m_pShell->GetFormView()->GetImpl();
//STRIP001 
//STRIP001 	// if the active controller is our external one we have to use the trigger controller
//STRIP001 	Reference< XControlContainer> xContainer;
//STRIP001 	if (getActiveController() == m_xExternalViewController)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(m_xExtViewTriggerController.is(), "FmXFormShell::startFiltering : inconsistent : active external controller, but noone triggered this !");
//STRIP001 		xContainer = m_xExtViewTriggerController->getContainer();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		xContainer = getActiveController()->getContainer();
//STRIP001 
//STRIP001 	FmWinRecList::iterator i = pXView->findWindow(xContainer);
//STRIP001 	if (i != pXView->getWindowList().end())
//STRIP001 	{
//STRIP001 		const ::std::vector< Reference< XFormController> >& rControllerList = (*i)->GetList();
//STRIP001 		::std::vector < ::rtl::OUString >	aOriginalFilters;
//STRIP001 		::std::vector < sal_Bool >			aOriginalApplyFlags;
//STRIP001 
//STRIP001 		if (bSave)
//STRIP001 		{
//STRIP001 			for (::std::vector< Reference< XFormController> > ::const_iterator j = rControllerList.begin();
//STRIP001 				 j != rControllerList.end(); ++j)
//STRIP001 			{
//STRIP001 				if (bSave)
//STRIP001 				{	// remember the current filter settings in case we're goin to reload the forms below (which may fail)
//STRIP001 					try
//STRIP001 					{
//STRIP001 						Reference< XPropertySet > xFormAsSet((*j)->getModel(), UNO_QUERY);
//STRIP001 						aOriginalFilters.push_back(::comphelper::getString(xFormAsSet->getPropertyValue(FM_PROP_FILTER_CRITERIA)));
//STRIP001 						aOriginalApplyFlags.push_back(::comphelper::getBOOL(xFormAsSet->getPropertyValue(FM_PROP_APPLYFILTER)));
//STRIP001 					}
//STRIP001 					catch(Exception&)
//STRIP001 					{
//STRIP001 						DBG_ERROR("FmXFormShell::stopFiltering : could not get the original filter !");
//STRIP001 						// put dummies into the arrays so the they have the right size
//STRIP001 
//STRIP001 						if (aOriginalFilters.size() == aOriginalApplyFlags.size())
//STRIP001 							// the first getPropertyValue failed -> use two dummies
//STRIP001 							aOriginalFilters.push_back( ::rtl::OUString() );
//STRIP001 						aOriginalApplyFlags.push_back( sal_False );
//STRIP001 					}
//STRIP001 				}
//STRIP001 				saveFilter(*j);
//STRIP001 			}
//STRIP001 		}
//STRIP001 		for (::std::vector< Reference< XFormController> > ::const_iterator j = rControllerList.begin();
//STRIP001 			 j != rControllerList.end(); ++j)
//STRIP001 		{
//STRIP001 
//STRIP001 			Reference< XModeSelector> xModeSelector(*j, UNO_QUERY);
//STRIP001 			if (xModeSelector.is())
//STRIP001 				xModeSelector->setMode(DATA_MODE);
//STRIP001 		}
//STRIP001 		if (bSave)	// execute the filter
//STRIP001 		{
//STRIP001 			const ::std::vector< Reference< XFormController> > & rControllerList = (*i)->GetList();
//STRIP001 			for (::std::vector< Reference< XFormController> > ::const_iterator j = rControllerList.begin();
//STRIP001 				 j != rControllerList.end(); ++j)
//STRIP001 			{
//STRIP001 				Reference< XLoadable> xReload((*j)->getModel(), UNO_QUERY);
//STRIP001 				if (!xReload.is())
//STRIP001 					continue;
//STRIP001 				Reference< XPropertySet > xFormSet(xReload, UNO_QUERY);
//STRIP001 
//STRIP001 				try
//STRIP001 				{
//STRIP001 					xReload->reload();
//STRIP001 				}
//STRIP001 				catch(Exception&)
//STRIP001 				{
//STRIP001 					DBG_ERROR("FmXFormShell::stopFiltering: Exception occured!");
//STRIP001 				}
//STRIP001 
//STRIP001 				if (!isRowSetAlive(xFormSet))
//STRIP001 				{	// something went wrong -> restore the original state
//STRIP001 					::rtl::OUString sOriginalFilter = aOriginalFilters[ j - rControllerList.begin() ];
//STRIP001 					sal_Bool bOriginalApplyFlag = aOriginalApplyFlags[ j - rControllerList.begin() ];
//STRIP001 					try
//STRIP001 					{
//STRIP001 						xFormSet->setPropertyValue(FM_PROP_FILTER_CRITERIA, makeAny(sOriginalFilter));
//STRIP001 						xFormSet->setPropertyValue(FM_PROP_APPLYFILTER, makeAny(bOriginalApplyFlag));
//STRIP001 						xReload->reload();
//STRIP001 					}
//STRIP001 					catch(Exception&)
//STRIP001 					{
//STRIP001 						DBG_ERROR("FmXFormShell::stopFiltering: Exception occured!");
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	m_pShell->UIFeatureChanged();
//STRIP001 	m_pShell->GetViewShell()->GetViewFrame()->GetBindings().InvalidateShell(*m_pShell);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void clearFilter(const Reference< XFormController>& _rxController)
//STRIP001 {
//STRIP001 	Reference< XPropertySet> xControllerAsSet(_rxController, UNO_QUERY);
//STRIP001 	Reference< XIndexAccess> xControllerAsIndex(_rxController, UNO_QUERY);
//STRIP001 
//STRIP001 	// call the subcontroller
//STRIP001 	Reference< XFormController> xController;
//STRIP001 	for (sal_Int32 i = 0, nCount = xControllerAsIndex->getCount();
//STRIP001 		 i < nCount; i++)
//STRIP001 	{
//STRIP001 		xControllerAsIndex->getByIndex(i) >>= xController;
//STRIP001 		clearFilter(xController);
//STRIP001 	}
//STRIP001 
//STRIP001 	// clear the filter
//STRIP001 	Reference< XIndexContainer> xContainer;
//STRIP001 	xControllerAsSet->getPropertyValue(FM_PROP_FILTERSUPPLIER) >>= xContainer;
//STRIP001 	if (xContainer.is())
//STRIP001 	{
//STRIP001 		// clear the current filter
//STRIP001 		Sequence< PropertyValue> aCondition;
//STRIP001 
//STRIP001 		// as there is always an empty row, if we have a filter:
//STRIP001 		if (xContainer->getCount())
//STRIP001 		{
//STRIP001 			xControllerAsSet->setPropertyValue(FM_PROP_CURRENTFILTER, makeAny(sal_Int32(xContainer->getCount() - 1)));
//STRIP001 			while (xContainer->getCount() > 1)
//STRIP001 				xContainer->removeByIndex(0);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::clearFilter()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	FmXFormView* pXView = m_pShell->GetFormView()->GetImpl();
//STRIP001 
//STRIP001 	// if the active controller is our external one we have to use the trigger controller
//STRIP001 	Reference< XControlContainer> xContainer;
//STRIP001 	if (getActiveController() == m_xExternalViewController)
//STRIP001 	{
//STRIP001 		DBG_ASSERT(m_xExtViewTriggerController.is(), "FmXFormShell::startFiltering : inconsistent : active external controller, but noone triggered this !");
//STRIP001 		xContainer = m_xExtViewTriggerController->getContainer();
//STRIP001 	}
//STRIP001 	else
//STRIP001 		xContainer = getActiveController()->getContainer();
//STRIP001 
//STRIP001 	FmWinRecList::iterator i = pXView->findWindow(xContainer);
//STRIP001 	if (i != pXView->getWindowList().end())
//STRIP001 	{
//STRIP001 		const ::std::vector< Reference< XFormController> > & rControllerList = (*i)->GetList();
//STRIP001 		for (::std::vector< Reference< XFormController> > ::const_iterator j = rControllerList.begin();
//STRIP001 			 j != rControllerList.end(); ++j)
//STRIP001 		{
//STRIP001 			::clearFilter(*j);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::setControlLocks()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XTabController> xCtrler(getActiveController(), UNO_QUERY);
//STRIP001 	if (!xCtrler.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	Reference< XControlContainer> xControls(xCtrler->getContainer(), UNO_QUERY);
//STRIP001 	if (!xControls.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	DBG_ASSERT(m_aControlLocks.Count() == 0, "FmXFormShell::setControlLocks : locking state array isn't empty (called me twice ?) !");
//STRIP001 
//STRIP001 	Sequence< Reference< XControl> > aControls = xControls->getControls();
//STRIP001 	const Reference< XControl>* pControls = aControls.getConstArray();
//STRIP001 
//STRIP001 	// iterate through all bound controls, remember the old locking state, set the lock
//STRIP001 	for (sal_Int32 i=0; i<aControls.getLength(); ++i)
//STRIP001 	{
//STRIP001 		Reference< XBoundControl> xCtrl(pControls[i], UNO_QUERY);
//STRIP001 		if (!xCtrl.is())
//STRIP001 		{
//STRIP001 			// it may be a container of controls
//STRIP001 			Reference< XIndexAccess> xContainer(pControls[i], UNO_QUERY);
//STRIP001 			if (xContainer.is())
//STRIP001 			{	// no recursion. we only know top level control containers (e.g. grid controls)
//STRIP001 				for (sal_Int16 i=0; i<xContainer->getCount(); ++i)
//STRIP001 				{
//STRIP001 					xContainer->getByIndex(i) >>= xCtrl;
//STRIP001 					if (!xCtrl.is())
//STRIP001 						continue;
//STRIP001 
//STRIP001 					m_aControlLocks.Insert(xCtrl->getLock(), m_aControlLocks.Count());
//STRIP001 					xCtrl->setLock(sal_True);
//STRIP001 				}
//STRIP001 			}
//STRIP001 			continue;
//STRIP001 		}
//STRIP001 
//STRIP001 		m_aControlLocks.Insert(xCtrl->getLock(), m_aControlLocks.Count());
//STRIP001 		xCtrl->setLock(sal_True);
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::restoreControlLocks()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	Reference< XTabController> xCtrler(getActiveController(), UNO_QUERY);
//STRIP001 	if (!xCtrler.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	Reference< XControlContainer> xControls(xCtrler->getContainer(), UNO_QUERY);
//STRIP001 	if (!xControls.is())
//STRIP001 		return;
//STRIP001 
//STRIP001 	Sequence< Reference< XControl> > aControls(xControls->getControls());
//STRIP001 	const Reference< XControl>* pControls = aControls.getConstArray();
//STRIP001 
//STRIP001 	// iterate through all bound controls, restore the old locking state
//STRIP001 	sal_Int32 nBoundControl = 0;
//STRIP001 	for (sal_Int32 i=0; i<aControls.getLength(); ++i)
//STRIP001 	{
//STRIP001 		Reference< XBoundControl> xCtrl(pControls[i], UNO_QUERY);
//STRIP001 		if (!xCtrl.is())
//STRIP001 		{
//STRIP001 			// it may be a container of controls
//STRIP001 			Reference< XIndexAccess> xContainer(pControls[i], UNO_QUERY);
//STRIP001 			if (xContainer.is())
//STRIP001 			{	// no recursion. we only know top level control containers (e.g. grid controls)
//STRIP001 				for (sal_Int16 i=0; i<xContainer->getCount(); ++i)
//STRIP001 				{
//STRIP001 					xContainer->getByIndex(i) >>= xCtrl;
//STRIP001 					if (!xCtrl.is())
//STRIP001 						continue;
//STRIP001 
//STRIP001 					DBG_ASSERT(nBoundControl < m_aControlLocks.Count(), "FmXFormShell::restoreControlLocks : m_aControlLocks is invalid !");
//STRIP001 					xCtrl->setLock(m_aControlLocks.GetObject((sal_uInt16)nBoundControl));
//STRIP001 					++nBoundControl;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			continue;
//STRIP001 		}
//STRIP001 
//STRIP001 		DBG_ASSERT(nBoundControl < m_aControlLocks.Count(), "FmXFormShell::restoreControlLocks : m_aControlLocks is invalid !");
//STRIP001 			// a violation of this condition would mean a) setControlLocks hasn't been called or b) the ControlContainer
//STRIP001 			// has changed since the last call to setControlLocks.
//STRIP001 			// a) clearly is a fault of the programmer and b) shouldn't be possible (as we are in alive mode)
//STRIP001 		xCtrl->setLock(m_aControlLocks.GetObject((sal_uInt16)nBoundControl));
//STRIP001 		++nBoundControl;
//STRIP001 	}
//STRIP001 	m_aControlLocks.Remove(0, m_aControlLocks.Count());
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::DoAsyncCursorAction(const Reference< XFormController>& _xController, CURSOR_ACTION _eWhat)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(_xController.is(), "FmXFormShell::DoAsyncCursorAction : invalid argument !");
//STRIP001 	DoAsyncCursorAction(Reference< XResultSet>(_xController->getModel(), UNO_QUERY), _eWhat);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::DoAsyncCursorAction(const Reference< XResultSet>& _xForm, CURSOR_ACTION _eWhat)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(m_aAsyncSafety);
//STRIP001 	DBG_ASSERT(_xForm.is(), "FmXFormShell::DoAsyncCursorAction : invalid argument !");
//STRIP001 
//STRIP001 	// get the id of the page the form belongs to
//STRIP001 	UniString sFormPageId = GetPageId(_xForm);
//STRIP001 	DBG_ASSERT(sFormPageId.Len(), "FmXFormShell::DoAsyncCursorAction : could not ::std::find the page the form belongs to !");
//STRIP001 
//STRIP001 	// build the access path for the form
//STRIP001 	if (HasPendingCursorAction(_xForm))
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormShell::DoAsyncCursorAction : invalid call !");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	UniString sPath = GetAccessPathFromForm(_xForm, sFormPageId);
//STRIP001 	DBG_ASSERT(sPath.Len(), "FmXFormShell::DoAsyncCursorAction : could not ::std::find a page for the form !");
//STRIP001 
//STRIP001 	CursorActionDescription& rDesc = m_aCursorActions[sPath];
//STRIP001 		// [] will create a new one if non-existent
//STRIP001 	DBG_ASSERT(rDesc.pThread == NULL, "FmXFormShell::DoAsyncCursorAction : the cursor action thread for this form is still alive !");
//STRIP001 
//STRIP001 	Reference< XResultSet> xCursor(getInternalForm(_xForm), UNO_QUERY);
//STRIP001 	switch (_eWhat)
//STRIP001 	{
//STRIP001 		case CA_MOVE_TO_LAST :
//STRIP001 			rDesc.pThread = new FmMoveToLastThread(xCursor, sPath);
//STRIP001 			break;
//STRIP001 		case CA_MOVE_ABSOLUTE:
//STRIP001 			DBG_ERROR("FmXFormShell::DoAsyncCursorAction : CA_MOVE_ABSOLUTE not supported yet !");
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	rDesc.pThread->SetTerminationHdl(LINK(this, FmXFormShell, OnCursorActionDone));
//STRIP001 	rDesc.pThread->EnableSelfDelete(sal_False);
//STRIP001 
//STRIP001 	rDesc.bCanceling = sal_False;
//STRIP001 
//STRIP001 	// set the control locks before starting the thread
//STRIP001 	DBG_ASSERT(getInternalForm(m_xActiveForm) == m_xActiveForm, "FmXFormShell::DoAsyncCursorAction : the active form should always be a internal one !");
//STRIP001 	if (getInternalForm(_xForm) == m_xActiveForm)
//STRIP001 		setControlLocks();
//STRIP001 
//STRIP001 	// go ...
//STRIP001 	rDesc.pThread->create();
//STRIP001 
//STRIP001 	// set a priority slightly below normal
//STRIP001 	rDesc.pThread->setPriority(::vos::OThread::TPriority_BelowNormal);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::HasPendingCursorAction(const UniString& _rAccessPath) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(((FmXFormShell*)this)->m_aAsyncSafety);
//STRIP001 
//STRIP001 	for (	ConstCursorActionsIterator aIter = m_aCursorActions.begin();
//STRIP001 			aIter != m_aCursorActions.end();
//STRIP001 			++aIter
//STRIP001 		)
//STRIP001 	{
//STRIP001 		if (!(*aIter).second.pThread && !(*aIter).second.nFinishedEvent)
//STRIP001 			continue;
//STRIP001 		UniString sThisThreadPath = (*aIter).second.pThread->getAccessPath();
//STRIP001 
//STRIP001 		// we have found a running thread. it blocks the form given by the access path if
//STRIP001 		// one of the two forms (the thread's or the given) is an anestor of the other
//STRIP001 		// this is the case if and only if one path is a prefix of the other
//STRIP001 		if (PathsInterfere(sThisThreadPath, _rAccessPath))
//STRIP001 			return sal_True;
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::HasPendingCursorAction(const Reference< XResultSet>& _xForm) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (!_xForm.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	return HasPendingCursorAction(GetAccessPathFromForm(_xForm, GetPageId(_xForm)));
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::HasPendingCursorAction(const Reference< XFormController>& xController) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	if (!xController.is())
//STRIP001 		return sal_False;
//STRIP001 
//STRIP001 	return HasPendingCursorAction(Reference< XResultSet>(xController->getModel(), UNO_QUERY));
//STRIP001 }

//------------------------------------------------------------------------------
/*N*/ sal_Bool FmXFormShell::HasAnyPendingCursorAction() const
/*N*/ {
/*N*/ 	::osl::MutexGuard aGuard(((FmXFormShell*)this)->m_aAsyncSafety);
/*N*/ 
/*N*/ 	for (ConstCursorActionsIterator aIter = m_aCursorActions.begin(); aIter != m_aCursorActions.end(); ++aIter)
/*N*/ 	{
/*?*/ 		if (((*aIter).second.pThread != NULL) || ((*aIter).second.nFinishedEvent != 0))
/*?*/ 			return sal_True;
/*N*/ 	}
/*N*/ 	return sal_False;
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::CancelAnyPendingCursorAction()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::comphelper::OReusableGuard< ::osl::Mutex> aGuard(m_aAsyncSafety);
//STRIP001 
//STRIP001 	CursorActionsIterator aIter;
//STRIP001 	for (aIter = m_aCursorActions.begin(); aIter != m_aCursorActions.end(); ++aIter)
//STRIP001 	{
//STRIP001 		if (!(*aIter).second.nFinishedEvent && (*aIter).second.pThread)
//STRIP001 		{	// the thread is really running
//STRIP001 			(*aIter).second.bCanceling = sal_True;
//STRIP001 
//STRIP001 			aGuard.clear();
//STRIP001 			(*aIter).second.pThread->StopItWait();
//STRIP001 				// StopItWait returns after the termination handler (our OnCursorActionDone) has been called
//STRIP001 			aGuard.attach(m_aAsyncSafety);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// all threads are finished (means canceled), now do the cleanup
//STRIP001 	for (aIter = m_aCursorActions.begin(); aIter != m_aCursorActions.end(); ++aIter)
//STRIP001 	{
//STRIP001 		if ((*aIter).second.pThread)
//STRIP001 		{
//STRIP001 			LINK(this, FmXFormShell, OnCursorActionDoneMainThread).Call((*aIter).second.pThread);
//STRIP001 			DBG_ASSERT((*aIter).second.pThread == NULL, "FmXFormShell::CancelAnyPendingCursorAction : strange behaviour of OnCursorActionDoneMainThread !");
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnCursorActionDone, FmCursorActionThread*, pThread)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(m_aAsyncSafety);
//STRIP001 
//STRIP001 	// search the pos of the thread within m_aCursorActions
//STRIP001 	CursorActionsIterator aIter;
//STRIP001 	for (aIter = m_aCursorActions.begin(); aIter != m_aCursorActions.end(); ++aIter)
//STRIP001 	{
//STRIP001 		if ((*aIter).second.pThread == pThread)
//STRIP001 			break;
//STRIP001 	}
//STRIP001 
//STRIP001 	DBG_ASSERT(aIter != m_aCursorActions.end(), "FmXFormShell::OnCursorActionDone : could not ::std::find the thread !");
//STRIP001 	DBG_ASSERT((*aIter).second.nFinishedEvent == 0, "FmXFormShell::OnCursorActionDone : another 'ActionDone' for this thread is pending !");
//STRIP001 		// as we allow only one async action at a time (per form) this shouldn't happen
//STRIP001 
//STRIP001 	if (!(*aIter).second.bCanceling)
//STRIP001 		(*aIter).second.nFinishedEvent = Application::PostUserEvent(LINK(this, FmXFormShell, OnCursorActionDoneMainThread), pThread);
//STRIP001 	// if bCanceling is sal_True an other thread's execution is in CancelAnyPendingCursorAction
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool FmXFormShell::PathsInterfere(const UniString& _rPathLeft, const UniString& _rPathRight) const
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	return ((_rPathLeft.Search(_rPathRight) == 0) || (_rPathRight.Search(_rPathLeft) == 0));
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmXFormShell, OnCursorActionDoneMainThread, FmCursorActionThread*, pThread)
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	::osl::MutexGuard aGuard(m_aAsyncSafety);
//STRIP001 
//STRIP001 	// search the pos of the thread within m_aCursorActions
//STRIP001 	CursorActionsIterator aIter = m_aCursorActions.find(pThread->getAccessPath());
//STRIP001 	DBG_ASSERT(aIter != m_aCursorActions.end(), "FmXFormShell::OnCursorActionDoneMainThread : could not ::std::find the thread data !");
//STRIP001 	DBG_ASSERT((*aIter).second.pThread == pThread, "FmXFormShell::OnCursorActionDoneMainThread : invalid thread data !");
//STRIP001 
//STRIP001 	// remember some thread parameters
//STRIP001 	UniString sPath = pThread->getAccessPath();
//STRIP001 	Reference< XResultSet> xForm(pThread->getDataSource(), UNO_QUERY);
//STRIP001 
//STRIP001 	// throw away the thread
//STRIP001 	delete (*aIter).second.pThread;
//STRIP001 	(*aIter).second.pThread = NULL;
//STRIP001 	(*aIter).second.nFinishedEvent = 0;
//STRIP001 	(*aIter).second.bCanceling = sal_False;
//STRIP001 	// as we allow exactly one thread per form we may remove this ones data from m_aCursorActions
//STRIP001 	m_aCursorActions.erase(aIter);
//STRIP001 
//STRIP001 	// there may be several dispatchers affected (one async move locks not only the form itself, but all forms
//STRIP001 	// which are an ancestor or a child)
//STRIP001 	// -> update their status
//STRIP001 	UpdateAllFormDispatchers(sPath);
//STRIP001 
//STRIP001 	DBG_ASSERT(getInternalForm(m_xActiveForm) == m_xActiveForm, "FmXFormShell::DoAsyncCursorAction : the active form should always be a internal one !");
//STRIP001 	DBG_ASSERT(getInternalForm(xForm) == xForm, "FmXFormShell::DoAsyncCursorAction : the thread's form should always be a internal one !");
//STRIP001 		// if one of the two asserts above fails the upcoming comparison is senseless
//STRIP001 	if (xForm == m_xActiveForm)
//STRIP001 	{
//STRIP001 		// the active controller belongs to the form where the action is finished
//STRIP001 		// -> re-enable the controls if they are not locked because of another running thread
//STRIP001 		if (!HasPendingCursorAction(xForm))
//STRIP001 			restoreControlLocks();
//STRIP001 	}
//STRIP001 
//STRIP001 	m_pShell->GetViewShell()->GetViewFrame()->GetBindings().Invalidate(DatabaseSlotMap);
//STRIP001 		// it may not be neccessary but me thinks it's faster without the check if we really have to do this
//STRIP001 
//STRIP001 	return 0L;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::CreateExternalView()
//STRIP001 {
//STRIP001 	OSL_ENSURE(!FmXFormShell_BASE::rBHelper.bDisposed,"FmXFormShell: Object already disposed!");
//STRIP001 	DBG_ASSERT(m_xAttachedFrame.is(), "FmXFormShell::CreateExternalView : no frame !");
//STRIP001 
//STRIP001 	// the frame the external view is displayed in
//STRIP001 	sal_Bool bAlreadyExistent = m_xExternalViewController.is();
//STRIP001 	Reference< ::com::sun::star::frame::XFrame> xExternalViewFrame;
//STRIP001 	::rtl::OUString sFrameName = ::rtl::OUString::createFromAscii("_beamer");
//STRIP001 	sal_Int32 nSearchFlags = ::com::sun::star::frame::FrameSearchFlag::CHILDREN | ::com::sun::star::frame::FrameSearchFlag::CREATE;
//STRIP001 
//STRIP001 	Reference< XFormController> xCurrentNavController( getNavController());
//STRIP001 		// the creation of the "partwindow" may cause a deactivate of the document which will result in our nav controller to be set to NULL
//STRIP001 
//STRIP001 	// _first_ check if we have any valid fields we can use for the grid view
//STRIP001 	// FS - 21.10.99 - 69219
//STRIP001 	FmXBoundFormFieldIterator aModelIterator(xCurrentNavController->getModel());
//STRIP001 	Reference< XPropertySet> xCurrentModelSet;
//STRIP001 	sal_Bool bHaveUsableControls = sal_False;
//STRIP001 	while ((xCurrentModelSet = Reference< XPropertySet>(aModelIterator.Next(), UNO_QUERY)).is())
//STRIP001 	{
//STRIP001 		// the FmXBoundFormFieldIterator only supplies controls with a valid control source
//STRIP001 		// so we just have to check the field type
//STRIP001 		sal_Int16 nClassId = ::comphelper::getINT16(xCurrentModelSet->getPropertyValue(FM_PROP_CLASSID));
//STRIP001 		switch (nClassId)
//STRIP001 		{
//STRIP001 			case FormComponentType::IMAGECONTROL:
//STRIP001 			case FormComponentType::CONTROL:
//STRIP001 				continue;
//STRIP001 		}
//STRIP001 		bHaveUsableControls = sal_True;
//STRIP001 		break;
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!bHaveUsableControls)
//STRIP001 	{
//STRIP001 		ErrorBox(NULL, WB_OK, SVX_RESSTR(RID_STR_NOCONTROLS_FOR_EXTERNALDISPLAY)).Execute();
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	// load the component for external form views
//STRIP001 	if (!bAlreadyExistent)
//STRIP001 	{
//STRIP001 		URL aWantToDispatch;
//STRIP001 		aWantToDispatch.Complete = FMURL_COMPONENT_FORMGRIDVIEW;
//STRIP001 
//STRIP001 		Reference< ::com::sun::star::frame::XDispatchProvider> xProv(m_xAttachedFrame, UNO_QUERY);
//STRIP001 		Reference< ::com::sun::star::frame::XDispatch> xDisp;
//STRIP001 		if (xProv.is())
//STRIP001 			xDisp = xProv->queryDispatch(aWantToDispatch, sFrameName, nSearchFlags);
//STRIP001 		if (xDisp.is())
//STRIP001 		{
//STRIP001 			xDisp->dispatch(aWantToDispatch, Sequence< PropertyValue>());
//STRIP001 		}
//STRIP001 
//STRIP001 		// with this the component should be loaded, now search the frame where it resides in
//STRIP001 		xExternalViewFrame = m_xAttachedFrame->findFrame(sFrameName, ::com::sun::star::frame::FrameSearchFlag::CHILDREN);
//STRIP001 		if (xExternalViewFrame.is())
//STRIP001 		{
//STRIP001 			m_xExternalViewController = xExternalViewFrame->getController();
//STRIP001 			Reference< ::com::sun::star::lang::XComponent> xComp(m_xExternalViewController, UNO_QUERY);
//STRIP001 			if (xComp.is())
//STRIP001 				xComp->addEventListener((XEventListener*)(XPropertyChangeListener*)this);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		xExternalViewFrame = m_xExternalViewController->getFrame();
//STRIP001 		Reference< ::com::sun::star::frame::XDispatchProvider> xCommLink(xExternalViewFrame, UNO_QUERY);
//STRIP001 
//STRIP001 		// if we display the active form we interpret the slot as "remove it"
//STRIP001 		Reference< XForm> xCurrentModel(xCurrentNavController->getModel(), UNO_QUERY);
//STRIP001 		if ((xCurrentModel == m_xExternalDisplayedForm) || (getInternalForm(xCurrentModel) == m_xExternalDisplayedForm))
//STRIP001 		{
//STRIP001 			if (m_xExternalViewController == getActiveController())
//STRIP001 				::com::mitCurrent(Reference< XFormController>(m_xExternalViewController, UNO_QUERY));
//STRIP001 
//STRIP001 			Reference< XFormController> xNewController(m_xExtViewTriggerController);
//STRIP001 			CloseExternalFormViewer();
//STRIP001 			setActiveController(xNewController);
//STRIP001 			return;
//STRIP001 		}
//STRIP001 
//STRIP001 		URL aClearURL;
//STRIP001 		aClearURL.Complete = FMURL_GRIDVIEW_CLEARVIEW;
//STRIP001 
//STRIP001 		Reference< ::com::sun::star::frame::XDispatch> xClear( xCommLink->queryDispatch(aClearURL, ::rtl::OUString::createFromAscii(""), 0));
//STRIP001 		if (xClear.is())
//STRIP001 			xClear->dispatch(aClearURL, Sequence< PropertyValue>());
//STRIP001 	}
//STRIP001 
//STRIP001 	// interception of slots of the external view
//STRIP001 	if (m_pExternalViewInterceptor)
//STRIP001 	{	// already intercepting ...
//STRIP001 		if (m_pExternalViewInterceptor->getIntercepted() != xExternalViewFrame)
//STRIP001 		{	// ... but another frame -> create a new interceptor
//STRIP001 			m_pExternalViewInterceptor->dispose();
//STRIP001 			m_pExternalViewInterceptor->release();
//STRIP001 			m_pExternalViewInterceptor = NULL;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if (!m_pExternalViewInterceptor)
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::frame::XDispatchProviderInterception> xSupplier(xExternalViewFrame, UNO_QUERY);
//STRIP001 		::rtl::OUString sInterceptorScheme = FMURL_FORMSLOTS_PREFIX;
//STRIP001 		sInterceptorScheme += ::rtl::OUString::createFromAscii("*");
//STRIP001 		m_pExternalViewInterceptor = new FmXDispatchInterceptorImpl(xSupplier, this, 1, Sequence< ::rtl::OUString >(&sInterceptorScheme, 1));
//STRIP001 		m_pExternalViewInterceptor->acquire();
//STRIP001 	}
//STRIP001 
//STRIP001 	// get the dispatch interface of the frame so we can communicate (interceptable) with the controller
//STRIP001 	Reference< ::com::sun::star::frame::XDispatchProvider> xCommLink(xExternalViewFrame, UNO_QUERY);
//STRIP001 
//STRIP001 	if (m_xExternalViewController.is())
//STRIP001 	{
//STRIP001 		DBG_ASSERT(xCommLink.is(), "FmXFormShell::CreateExternalView : the component doesn't have the necessary interfaces !");
//STRIP001 		// collect the dispatchers we will need
//STRIP001 		URL aAddColumnURL;
//STRIP001 		aAddColumnURL.Complete = FMURL_GRIDVIEW_ADDCOLUMN;
//STRIP001 		Reference< ::com::sun::star::frame::XDispatch> xAddColumnDispatch( xCommLink->queryDispatch(aAddColumnURL, ::rtl::OUString::createFromAscii(""), 0));
//STRIP001 		URL aAttachURL;
//STRIP001 		aAttachURL.Complete = FMURL_GRIDVIEW_ATTACHTOFORM;
//STRIP001 		Reference< ::com::sun::star::frame::XDispatch> xAttachDispatch( xCommLink->queryDispatch(aAttachURL, ::rtl::OUString::createFromAscii(""), 0));
//STRIP001 
//STRIP001 		if (xAddColumnDispatch.is() && xAttachDispatch.is())
//STRIP001 		{
//STRIP001 			DBG_ASSERT(xCurrentNavController.is(), "FmXFormShell::CreateExternalView : invalid call : have no nav controller !");
//STRIP001 			// first : dispatch the descriptions for the columns to add
//STRIP001 			Sequence< Reference< XControl> > aCurrentControls(xCurrentNavController->getControls());
//STRIP001 			const Reference< XControl>* pCurrentControl = aCurrentControls.getConstArray();
//STRIP001 
//STRIP001 			sal_Int16 nAddedColumns = 0;
//STRIP001 
//STRIP001 			// for radio buttons we need some special structures
//STRIP001 			DECLARE_STL_USTRINGACCESS_MAP(Sequence< ::rtl::OUString>, MapUString2UstringSeq);
//STRIP001 			DECLARE_STL_ITERATORS(MapUString2UstringSeq);
//STRIP001 			DECLARE_STL_USTRINGACCESS_MAP(::rtl::OUString, FmMapUString2UString);
//STRIP001 			DECLARE_STL_USTRINGACCESS_MAP(sal_Int16, FmMapUString2Int16);
//STRIP001 			DECLARE_STL_ITERATORS(FmMapUString2Int16);
//STRIP001 
//STRIP001 			MapUString2UstringSeq	aRadioValueLists;
//STRIP001 			MapUString2UstringSeq	aRadioListSources;
//STRIP001 			FmMapUString2UString	aRadioControlSources;
//STRIP001 			FmMapUString2Int16		aRadioPositions;
//STRIP001 
//STRIP001 			FmXBoundFormFieldIterator aModelIterator(xCurrentNavController->getModel());
//STRIP001 			Reference< XPropertySet> xCurrentModelSet;
//STRIP001 			Any aCurrentBoundField;
//STRIP001 			::rtl::OUString sColumnType,aGroupName,sControlSource;
//STRIP001 			Sequence< Property> aProps;
//STRIP001 			Reference< XPropertySet> xCurrentBoundField;
//STRIP001 			while ((xCurrentModelSet = Reference< XPropertySet>(aModelIterator.Next(), UNO_QUERY)).is())
//STRIP001 			{
//STRIP001 				xCurrentModelSet->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xCurrentBoundField;
//STRIP001 				OSL_ENSURE(xCurrentModelSet.is(),"xCurrentModelSet is null!");
//STRIP001 				// create a description of the column to be created
//STRIP001 				// first : determine it's type
//STRIP001 
//STRIP001 				sal_Int16 nClassId = ::comphelper::getINT16(xCurrentModelSet->getPropertyValue(FM_PROP_CLASSID));
//STRIP001 				switch (nClassId)
//STRIP001 				{
//STRIP001 					case FormComponentType::RADIOBUTTON:
//STRIP001 					{
//STRIP001 						// get the label of the button (this is the access key for our structures)
//STRIP001 						aGroupName = getLabelName(xCurrentModelSet);
//STRIP001 
//STRIP001 						// add the reference value of the radio button to the list source sequence
//STRIP001 						Sequence< ::rtl::OUString>& aThisGroupLabels = aRadioListSources[aGroupName];
//STRIP001 						sal_Int32 nNewSizeL = aThisGroupLabels.getLength() + 1;
//STRIP001 						aThisGroupLabels.realloc(nNewSizeL);
//STRIP001 						aThisGroupLabels.getArray()[nNewSizeL - 1] = ::comphelper::getString(xCurrentModelSet->getPropertyValue(FM_PROP_REFVALUE));
//STRIP001 
//STRIP001 						// add the label to the value list sequence
//STRIP001 						Sequence< ::rtl::OUString>& aThisGroupControlSources = aRadioValueLists[aGroupName];
//STRIP001 						sal_Int32 nNewSizeC = aThisGroupControlSources.getLength() + 1;
//STRIP001 						aThisGroupControlSources.realloc(nNewSizeC);
//STRIP001 						aThisGroupControlSources.getArray()[nNewSizeC - 1] = ::comphelper::getString(xCurrentModelSet->getPropertyValue(FM_PROP_LABEL));
//STRIP001 
//STRIP001 						// remember the controls source of the radio group
//STRIP001 						sControlSource = ::comphelper::getString(xCurrentModelSet->getPropertyValue(FM_PROP_CONTROLSOURCE));
//STRIP001 						if (aRadioControlSources.find(aGroupName) == aRadioControlSources.end())
//STRIP001 							aRadioControlSources[aGroupName] = sControlSource;
//STRIP001 #ifdef DBG_UTIL
//STRIP001 						else
//STRIP001 							DBG_ASSERT(aRadioControlSources[aGroupName] == sControlSource,
//STRIP001 							"FmXFormShell::CreateExternalView : inconsistent radio buttons detected !");
//STRIP001 							// (radio buttons with the same name should have the same control source)
//STRIP001 #endif
//STRIP001 						// remember the position within the columns
//STRIP001 						if (aRadioPositions.find(aGroupName) == aRadioPositions.end())
//STRIP001 							aRadioPositions[aGroupName] = (sal_Int16)nAddedColumns;
//STRIP001 
//STRIP001 						// any further handling is done below
//STRIP001 						continue;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 					case FormComponentType::IMAGECONTROL:
//STRIP001 					case FormComponentType::CONTROL:
//STRIP001 						// no grid columns for these types (though they have a control source)
//STRIP001 						continue;
//STRIP001 					case FormComponentType::CHECKBOX:
//STRIP001 						sColumnType = FM_COL_CHECKBOX; break;
//STRIP001 					case FormComponentType::LISTBOX:
//STRIP001 						sColumnType = FM_COL_LISTBOX; break;
//STRIP001 					case FormComponentType::COMBOBOX:
//STRIP001 						sColumnType = FM_COL_COMBOBOX; break;
//STRIP001 					case FormComponentType::DATEFIELD:
//STRIP001 						sColumnType = FM_COL_DATEFIELD; break;
//STRIP001 					case FormComponentType::TIMEFIELD:
//STRIP001 						sColumnType = FM_COL_TIMEFIELD; break;
//STRIP001 					case FormComponentType::NUMERICFIELD:
//STRIP001 						sColumnType = FM_COL_NUMERICFIELD; break;
//STRIP001 					case FormComponentType::CURRENCYFIELD:
//STRIP001 						sColumnType = FM_COL_CURRENCYFIELD; break;
//STRIP001 					case FormComponentType::PATTERNFIELD:
//STRIP001 						sColumnType = FM_COL_PATTERNFIELD; break;
//STRIP001 
//STRIP001 					case FormComponentType::TEXTFIELD:
//STRIP001 						{
//STRIP001 							sColumnType = FM_COL_TEXTFIELD;
//STRIP001 							// we know at least two different controls which are TextFields : the basic edit field and the formatted
//STRIP001 							// field. we distinguish them by their service name
//STRIP001 							Reference< XServiceInfo> xInfo(xCurrentModelSet, UNO_QUERY);
//STRIP001 							if (xInfo.is())
//STRIP001 							{
//STRIP001 								sal_Int16 nObjectType = getControlTypeByObject(xInfo);
//STRIP001 								if (OBJ_FM_FORMATTEDFIELD == nObjectType)
//STRIP001 									sColumnType = FM_COL_FORMATTEDFIELD;
//STRIP001 							}
//STRIP001 						}
//STRIP001 						break;
//STRIP001 					default:
//STRIP001 						sColumnType = FM_COL_TEXTFIELD; break;
//STRIP001 				}
//STRIP001 
//STRIP001 				const sal_Int16 nDispatchArgs = 3;
//STRIP001 				Sequence< PropertyValue> aDispatchArgs(nDispatchArgs);
//STRIP001 				PropertyValue* pDispatchArgs = aDispatchArgs.getArray();
//STRIP001 
//STRIP001 				// properties describing "meta data" about the column
//STRIP001 				// the type
//STRIP001 				pDispatchArgs->Name = FMARG_ADDCOL_COLUMNTYPE;
//STRIP001 				pDispatchArgs->Value <<= sColumnType;
//STRIP001 				++pDispatchArgs;
//STRIP001 
//STRIP001 				// the pos : append the col
//STRIP001 				pDispatchArgs->Name = FMARG_ADDCOL_COLUMNPOS;
//STRIP001 				pDispatchArgs->Value <<= nAddedColumns;
//STRIP001 				++pDispatchArgs;
//STRIP001 
//STRIP001 				// the properties to forward to the new column
//STRIP001 				Sequence< PropertyValue> aColumnProps(1);
//STRIP001 				PropertyValue* pColumnProps = aColumnProps.getArray();
//STRIP001 
//STRIP001 				// the label
//STRIP001 				pColumnProps->Name = FM_PROP_LABEL;
//STRIP001 				pColumnProps->Value <<= getLabelName(xCurrentModelSet);
//STRIP001 				++pColumnProps;
//STRIP001 
//STRIP001 				// for all other props : transfer them
//STRIP001 				Reference< XPropertySetInfo> xControlModelInfo( xCurrentModelSet->getPropertySetInfo());
//STRIP001 				DBG_ASSERT(xControlModelInfo.is(), "FmXFormShell::CreateExternalView : the control model has no property info ! This will crash !");
//STRIP001 				aProps = xControlModelInfo->getProperties();
//STRIP001 				const Property* pProps = aProps.getConstArray();
//STRIP001 
//STRIP001 				// realloc the control description sequence
//STRIP001 				sal_Int32 nExistentDescs = pColumnProps - aColumnProps.getArray();
//STRIP001 				aColumnProps.realloc(nExistentDescs + aProps.getLength());
//STRIP001 				pColumnProps = aColumnProps.getArray() + nExistentDescs;
//STRIP001 
//STRIP001 				for (sal_Int32 i=0; i<aProps.getLength(); ++i, ++pProps)
//STRIP001 				{
//STRIP001 					if (pProps->Name.equals(FM_PROP_LABEL))
//STRIP001 						// already set
//STRIP001 						continue;
//STRIP001 					if (pProps->Name.equals(FM_PROP_DEFAULTCONTROL))
//STRIP001 						// allow the column's own "default control"
//STRIP001 						continue;
//STRIP001 					if (pProps->Attributes & PropertyAttribute::READONLY)
//STRIP001 						// assume that properties which are readonly for the control are ro for the column to be created, too
//STRIP001 						continue;
//STRIP001 
//STRIP001 					pColumnProps->Name = pProps->Name;
//STRIP001 					pColumnProps->Value = xCurrentModelSet->getPropertyValue(pProps->Name);
//STRIP001 					++pColumnProps;
//STRIP001 				}
//STRIP001 				aColumnProps.realloc(pColumnProps - aColumnProps.getArray());
//STRIP001 
//STRIP001 				// columns props are a dispatch argument
//STRIP001 				pDispatchArgs->Name = ::rtl::OUString::createFromAscii("ColumnProperties"); // TODO : fmurl.*
//STRIP001 				pDispatchArgs->Value = makeAny(aColumnProps);
//STRIP001 				++pDispatchArgs;
//STRIP001 				DBG_ASSERT(nDispatchArgs == (pDispatchArgs - aDispatchArgs.getConstArray()),
//STRIP001 					"FmXFormShell::CreateExternalView : forgot to adjust nDispatchArgs ?");
//STRIP001 
//STRIP001 				// dispatch the "add column"
//STRIP001 				xAddColumnDispatch->dispatch(aAddColumnURL, aDispatchArgs);
//STRIP001 				++nAddedColumns;
//STRIP001 			}
//STRIP001 
//STRIP001 			// now for the radio button handling
//STRIP001 			sal_Int16 nOffset(0);
//STRIP001 			// properties describing the "direct" column properties
//STRIP001 			const sal_Int16 nListBoxDescription = 6;
//STRIP001 			Sequence< PropertyValue> aListBoxDescription(nListBoxDescription);
//STRIP001 			for (	ConstFmMapUString2UStringIterator aCtrlSource = aRadioControlSources.begin();
//STRIP001 					aCtrlSource != aRadioControlSources.end();
//STRIP001 					++aCtrlSource, ++nOffset
//STRIP001 				)
//STRIP001 			{
//STRIP001 
//STRIP001 				PropertyValue* pListBoxDescription = aListBoxDescription.getArray();
//STRIP001 				// label
//STRIP001 				pListBoxDescription->Name = FM_PROP_LABEL;
//STRIP001 				pListBoxDescription->Value <<= (*aCtrlSource).first;
//STRIP001 				++pListBoxDescription;
//STRIP001 
//STRIP001 				// control source
//STRIP001 				pListBoxDescription->Name = FM_PROP_CONTROLSOURCE;
//STRIP001 				pListBoxDescription->Value <<= (*aCtrlSource).second;
//STRIP001 				++pListBoxDescription;
//STRIP001 
//STRIP001 				// bound column
//STRIP001 				pListBoxDescription->Name = FM_PROP_BOUNDCOLUMN;
//STRIP001 				pListBoxDescription->Value <<= (sal_Int16)1;
//STRIP001 				++pListBoxDescription;
//STRIP001 
//STRIP001 				// content type
//STRIP001 				pListBoxDescription->Name = FM_PROP_LISTSOURCETYPE;
//STRIP001 				 ListSourceType eType = ListSourceType_VALUELIST;
//STRIP001 				 pListBoxDescription->Value = makeAny(eType);
//STRIP001 				++pListBoxDescription;
//STRIP001 
//STRIP001 				// list source
//STRIP001 				MapUString2UstringSeq::const_iterator aCurrentListSource = aRadioListSources.find((*aCtrlSource).first);
//STRIP001 				DBG_ASSERT(aCurrentListSource != aRadioListSources.end(),
//STRIP001 					"FmXFormShell::CreateExternalView : inconsistent radio descriptions !");
//STRIP001 				pListBoxDescription->Name = FM_PROP_LISTSOURCE;
//STRIP001 				pListBoxDescription->Value = makeAny((*aCurrentListSource).second);
//STRIP001 				++pListBoxDescription;
//STRIP001 
//STRIP001 				// value list
//STRIP001 				MapUString2UstringSeq::const_iterator aCurrentValueList = aRadioValueLists.find((*aCtrlSource).first);
//STRIP001 				DBG_ASSERT(aCurrentValueList != aRadioValueLists.end(),
//STRIP001 					"FmXFormShell::CreateExternalView : inconsistent radio descriptions !");
//STRIP001 				pListBoxDescription->Name = FM_PROP_STRINGITEMLIST;
//STRIP001 				pListBoxDescription->Value = makeAny(((*aCurrentValueList).second));
//STRIP001 				++pListBoxDescription;
//STRIP001 
//STRIP001 				DBG_ASSERT(nListBoxDescription == (pListBoxDescription - aListBoxDescription.getConstArray()),
//STRIP001 					"FmXFormShell::CreateExternalView : forgot to adjust nListBoxDescription ?");
//STRIP001 
//STRIP001 				// properties describing the column "meta data"
//STRIP001 				const sal_Int16 nDispatchArgs = 3;
//STRIP001 				Sequence< PropertyValue> aDispatchArgs(nDispatchArgs);
//STRIP001 				PropertyValue* pDispatchArgs = aDispatchArgs.getArray();
//STRIP001 
//STRIP001 				// column type : listbox
//STRIP001 				pDispatchArgs->Name = FMARG_ADDCOL_COLUMNTYPE;
//STRIP001 				::rtl::OUString fColName = FM_COL_LISTBOX;
//STRIP001 				pDispatchArgs->Value <<= fColName;
//STRIP001 //				pDispatchArgs->Value <<= (::rtl::OUString)FM_COL_LISTBOX;
//STRIP001 				++pDispatchArgs;
//STRIP001 
//STRIP001 				// column position
//STRIP001 				pDispatchArgs->Name = FMARG_ADDCOL_COLUMNPOS;
//STRIP001 				FmMapUString2Int16::const_iterator aOffset = aRadioPositions.find((*aCtrlSource).first);
//STRIP001 				DBG_ASSERT(aOffset != aRadioPositions.end(),
//STRIP001 					"FmXFormShell::CreateExternalView : inconsistent radio descriptions !");
//STRIP001 				sal_Int16 nPosition = (*aOffset).second;
//STRIP001 				nPosition += nOffset;
//STRIP001 					// we alread inserted nOffset additinal columns ....
//STRIP001 				pDispatchArgs->Value <<= nPosition;
//STRIP001 				++pDispatchArgs;
//STRIP001 
//STRIP001 				// the
//STRIP001 				pDispatchArgs->Name = ::rtl::OUString::createFromAscii("ColumnProperties"); // TODO : fmurl.*
//STRIP001 				pDispatchArgs->Value = makeAny(aListBoxDescription);
//STRIP001 				++pDispatchArgs;
//STRIP001 				DBG_ASSERT(nDispatchArgs == (pDispatchArgs - aDispatchArgs.getConstArray()),
//STRIP001 					"FmXFormShell::CreateExternalView : forgot to adjust nDispatchArgs ?");
//STRIP001 
//STRIP001 				// dispatch the "add column"
//STRIP001 				xAddColumnDispatch->dispatch(aAddColumnURL, aDispatchArgs);
//STRIP001 				++nAddedColumns;
//STRIP001 			}
//STRIP001 
//STRIP001 
//STRIP001 			DBG_ASSERT(nAddedColumns > 0, "FmXFormShell::CreateExternalView : no controls (inconsistent) !");
//STRIP001 				// we should have checked if we have any usable controls (see above).
//STRIP001 
//STRIP001 			// "load" the "form" of the external view
//STRIP001 			PropertyValue aArg;
//STRIP001 			aArg.Name = FMARG_ATTACHTO_MASTERFORM;
//STRIP001 			Reference< XResultSet> xForm(xCurrentNavController->getModel(), UNO_QUERY);
//STRIP001 			aArg.Value <<= xForm;
//STRIP001 
//STRIP001 			m_xExternalDisplayedForm = Reference< XResultSet>(xForm, UNO_QUERY);
//STRIP001 				// do this before dispatching the "attach" command, as the atach may result in a call to our queryDispatch (for the FormSlots)
//STRIP001 				// whichs needs the m_xExternalDisplayedForm
//STRIP001 
//STRIP001 			xAttachDispatch->dispatch(aAttachURL, Sequence< PropertyValue>(&aArg, 1));
//STRIP001 
//STRIP001 			m_xExtViewTriggerController = xCurrentNavController;
//STRIP001 
//STRIP001 			// we want to know modifications done in the external view
//STRIP001 			// if the external controller is a XFormController we can use all our default handlings for it
//STRIP001 			Reference< XFormController> xFormController(m_xExternalViewController, UNO_QUERY);
//STRIP001 			if (xFormController.is())
//STRIP001 				xFormController->addActivateListener((XFormControllerListener*)this);
//STRIP001 
//STRIP001 			// finally, do an update for all dispatchers of the form which we has displayed in the external
//STRIP001 			// browser
//STRIP001 			//
//STRIP001 			// This is a slight hack. The timeline when dispatching and loading this external form
//STRIP001 			// is somewhat bad, it results in a grid in this form which has invalid status information
//STRIP001 			// for the slots we're intercepting (moveNext and such).
//STRIP001 			// Instead of creating complex workarounds (which I cannot imagine at the moment), we
//STRIP001 			// force an update of the dispatchers here.
//STRIP001 			//
//STRIP001 			// 94525 - 2002-10-14 - fs@openoffice.org
//STRIP001 			//
//STRIP001 			::rtl::OUString sDisplayFormAccessPath = GetAccessPathFromForm( m_xExternalDisplayedForm, GetPageId( m_xExternalDisplayedForm ) );
//STRIP001 			SingleFormDispatchers& rDispatchers = m_aNavigationDispatcher[ sDisplayFormAccessPath ];
//STRIP001 			// loop through all the dispatchers for this form
//STRIP001 			for (	SingleFormDispatchers::const_iterator aDisp = rDispatchers.begin();
//STRIP001 					aDisp != rDispatchers.end();
//STRIP001 					++aDisp
//STRIP001 				)
//STRIP001 			{
//STRIP001 				(*aDisp)->BroadcastCurrentState( );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 #ifdef DBG_UTIL
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormShell::CreateExternalView : could not create the external form view !");
//STRIP001 	}
//STRIP001 #endif
//STRIP001 	InvalidateSlot(SID_FM_VIEW_AS_GRID, sal_True, sal_False);
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::implAdjustConfigCache()
/*N*/ {
/*N*/ 	// get (cache) the wizard usage flag
/*N*/ 	Sequence< ::rtl::OUString > aNames(1);
/*N*/ 	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
/*N*/ 	Sequence< Any > aFlags = GetProperties(aNames);
/*N*/ 	if (1 == aFlags.getLength())
/*N*/ 		m_bUseWizards = ::cppu::any2bool(aFlags[0]);
/*N*/ }

//------------------------------------------------------------------------
//STRIP001 void FmXFormShell::Notify( const ::com::sun::star::uno::Sequence< ::rtl::OUString >& _rPropertyNames)
//STRIP001 {
//STRIP001 	const ::rtl::OUString* pSearch = _rPropertyNames.getConstArray();
//STRIP001 	const ::rtl::OUString* pSearchTil = pSearch + _rPropertyNames.getLength();
//STRIP001 	for (;pSearch < pSearchTil; ++pSearch)
//STRIP001 		if (0 == pSearch->compareToAscii("FormControlPilotsEnabled"))
//STRIP001 		{
//STRIP001 			implAdjustConfigCache();
//STRIP001 			InvalidateSlot(SID_FM_USE_WIZARDS, sal_True, sal_True);
//STRIP001 		}
//STRIP001 }

//------------------------------------------------------------------------
//STRIP001 void FmXFormShell::SetWizardUsing(sal_Bool _bUseThem)
//STRIP001 {
//STRIP001 	m_bUseWizards = _bUseThem;
//STRIP001 
//STRIP001 	Sequence< ::rtl::OUString > aNames(1);
//STRIP001 	aNames[0] = ::rtl::OUString::createFromAscii("FormControlPilotsEnabled");
//STRIP001 	Sequence< Any > aValues(1);
//STRIP001 	aValues[0] = ::cppu::bool2any(m_bUseWizards);
//STRIP001 	PutProperties(aNames, aValues);
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::viewDeactivated( FmFormView* _pCurrentView, sal_Bool _bDeactivateController /* = sal_True */ )
/*N*/ {
/*N*/ 	// deactivate our view if we are deactivated ourself
/*N*/ 	// FS - 30.06.99 - 67308
/*N*/ 	if ( _pCurrentView )
/*N*/ 	{
/*N*/ 		// deactivate the controls on this page
/*N*/ 		if ( _pCurrentView->GetImpl() && !_pCurrentView->IsDesignMode() )
/*N*/ 		{
/*N*/ 			_pCurrentView->GetImpl()->Deactivate( _bDeactivateController );
/*N*/ 		}
/*N*/ 
/*N*/ 		// if we have an async load operation pending for the 0-th page for this view,
/*N*/ 		// we need to cancel this
/*N*/ 		// 103727 - 2002-09-26 - fs@openoffice.org
/*N*/ 		const SdrPageView* pCurPageView = _pCurrentView->GetPageViewPvNum( 0 );
/*N*/ 		const FmFormPage* pPage = pCurPageView ? PTR_CAST( FmFormPage, pCurPageView->GetPage() ) : NULL;
/*N*/ 		if ( pPage )
/*N*/ 		{
/*N*/ 			// move all events from our queue to a new one, omit the events for the deactivated
/*N*/ 			// page
/*N*/ 			::std::queue< FmLoadAction > aNewEvents;
/*N*/ 			while ( m_aLoadingPages.size() )
/*N*/ 			{
/*N*/ 				FmLoadAction aAction = m_aLoadingPages.front();
/*N*/ 				m_aLoadingPages.pop();
/*N*/ 				if ( pPage != aAction.pPage )
/*N*/ 				{
/*?*/ 					aNewEvents.push( aAction );
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{
/*N*/ 					Application::RemoveUserEvent( aAction.nEventId );
/*N*/ 				}
/*N*/ 			}
/*N*/ 			m_aLoadingPages = aNewEvents;
/*N*/ 		}
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::viewActivated( FmFormView* _pCurrentView, sal_Bool _bSyncAction /* = sal_False */ )
/*N*/ {
/*N*/ 	// activate our view if we are activated ourself
/*N*/ 	// FS - 30.06.99 - 67308
/*N*/ 	if ( _pCurrentView && _pCurrentView->GetImpl() && !_pCurrentView->IsDesignMode() )
/*N*/ 	{
/*N*/ 		// load forms for the page the current view belongs to
/*N*/ 		SdrPageView* pCurPageView = _pCurrentView->GetPageViewPvNum( 0 );
/*N*/ 		FmFormPage* pPage = pCurPageView ? PTR_CAST( FmFormPage, pCurPageView->GetPage() ) : NULL;
/*N*/ 		if ( pPage )
/*N*/ 		{
/*N*/ 			if ( !pPage->GetImpl()->hasEverBeenActivated() )
/*N*/ 				loadForms( pPage, FORMS_LOAD | ( _bSyncAction ? FORMS_SYNC : FORMS_ASYNC ) );
/*N*/ 			pPage->GetImpl()->setHasBeenActivated( );
/*N*/ 		}
/*N*/ 
/*N*/ 		// first-time initializations for the views
/*N*/ 		if ( !_pCurrentView->GetImpl()->hasEverBeenActivated( ) )
/*N*/ 		{
/*N*/ 			_pCurrentView->GetImpl()->onFirstViewActivation( PTR_CAST( FmFormModel, _pCurrentView->GetModel() ) );
/*N*/ 			_pCurrentView->GetImpl()->setHasBeenActivated( );
/*N*/ 		}
/*N*/ 
/*N*/ 		// activate the current view
/*N*/ 		_pCurrentView->GetImpl()->Activate( _bSyncAction );
/*N*/ 	}
/*N*/ }

//------------------------------------------------------------------------------
//STRIP001 void FmXFormShell::smartControlReset( const Reference< XIndexAccess >& _rxModels )
//STRIP001 {
//STRIP001 	if (!_rxModels.is())
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmXFormShell::smartControlReset: invalid container!");
//STRIP001 		return;
//STRIP001 	}
//STRIP001 
//STRIP001 	static const ::rtl::OUString sClassIdPropertyName = FM_PROP_CLASSID;
//STRIP001 	static const ::rtl::OUString sBoundFieldPropertyName = FM_PROP_BOUNDFIELD;
//STRIP001 	sal_Int32 nCount = _rxModels->getCount();
//STRIP001 	Reference< XPropertySet > xCurrent;
//STRIP001 	Reference< XPropertySetInfo > xCurrentInfo;
//STRIP001 	Reference< XPropertySet > xBoundField;
//STRIP001 
//STRIP001 	for (sal_Int32 i=0; i<nCount; ++i)
//STRIP001 	{
//STRIP001 		_rxModels->getByIndex(i) >>= xCurrent;
//STRIP001 		if (xCurrent.is())
//STRIP001 			xCurrentInfo = xCurrent->getPropertySetInfo();
//STRIP001 		else
//STRIP001 			xCurrentInfo.clear();
//STRIP001 		if (!xCurrentInfo.is())
//STRIP001 			continue;
//STRIP001 
//STRIP001 		if (xCurrentInfo->hasPropertyByName(sClassIdPropertyName))
//STRIP001 		{	// it's a control model
//STRIP001 
//STRIP001 			// check if this control is bound to a living database field
//STRIP001 			if (xCurrentInfo->hasPropertyByName(sBoundFieldPropertyName))
//STRIP001 				xCurrent->getPropertyValue(sBoundFieldPropertyName) >>= xBoundField;
//STRIP001 			else
//STRIP001 				xBoundField.clear();
//STRIP001 
//STRIP001 			if (!xBoundField.is())
//STRIP001 			{	// no, not valid bound -> reset it
//STRIP001 				Reference< XReset > xControlReset(xCurrent, UNO_QUERY);
//STRIP001 				if (xControlReset.is())
//STRIP001 					xControlReset->reset();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			Reference< XIndexAccess > xContainer(xCurrent, UNO_QUERY);
//STRIP001 			if (xContainer.is())
//STRIP001 				smartControlReset(xContainer);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------
/*N*/ IMPL_LINK( FmXFormShell, OnLoadForms, FmFormPage*, _pPage )
/*N*/ {
/*N*/ 	FmLoadAction aAction = m_aLoadingPages.front();
/*N*/ 	m_aLoadingPages.pop();
/*N*/ 
/*N*/ 	loadForms( aAction.pPage, aAction.nFlags & ~FORMS_ASYNC );
/*N*/ 	return 0L;
/*N*/ }

//------------------------------------------------------------------------
/*N*/ void FmXFormShell::loadForms( FmFormPage* _pPage, const sal_uInt16 _nBehaviour /* FORMS_LOAD | FORMS_SYNC */ )
/*N*/ {
/*N*/ 	DBG_ASSERT( ( _nBehaviour & ( FORMS_ASYNC | FORMS_UNLOAD ) )  != ( FORMS_ASYNC | FORMS_UNLOAD ),
/*N*/ 		"FmXFormShell::loadForms: async loading not supported - this will heavily fail!" );
/*N*/ 
/*N*/ 	if ( _nBehaviour & FORMS_ASYNC )
/*N*/ 	{
/*N*/ 		m_aLoadingPages.push( FmLoadAction(
/*N*/ 			_pPage,
/*N*/ 			_nBehaviour,
/*N*/ 			Application::PostUserEvent( LINK( this, FmXFormShell, OnLoadForms ), _pPage )
/*N*/ 		) );
/*N*/ 		return;
/*N*/ 	}
/*N*/ 
/*N*/ 	DBG_ASSERT( _pPage, "FmXFormShell::loadForms: invalid page!" );
/*N*/ 	if ( _pPage )
/*N*/ 	{
/*N*/ 		// lock the undo env so the forms can change non-transient properties while loading
/*N*/ 		// (without this my doc's modified flag would be set)
/*N*/ 		FmFormModel* pModel = PTR_CAST( FmFormModel, _pPage->GetModel() );
/*N*/ 		DBG_ASSERT( pModel, "FmXFormShell::loadForms: invalid model!" );
/*N*/ 		if ( pModel )
/*N*/ 			pModel->GetUndoEnv().Lock();
/*N*/ 
/*N*/ 		// load all forms
/*N*/ 		Reference< XIndexAccess >  xForms;
/*N*/ 		xForms = xForms.query( _pPage->GetForms() );
/*N*/ 		DBG_ASSERT( xForms.is(), "FmXFormShell::loadForms: invalid forms collection!" );
/*N*/ 
/*N*/ 		if ( xForms.is() )
/*N*/ 		{
/*N*/ 			Reference< XLoadable >  xForm;
/*N*/ 			for ( sal_Int32 j = 0, nCount = xForms->getCount(); j < nCount; ++j )
/*N*/ 			{
/*?*/ 				xForms->getByIndex( j ) >>= xForm;
/*?*/ 				// a database form must be loaded for
/*?*/ 				if ( 0 == ( _nBehaviour & FORMS_UNLOAD ) )
/*?*/ 				{
/*?*/					DBG_BF_ASSERT(0, "STRIP"); //STRIP001 /*?*/ 					if ( ::isLoadable( xForm ) && !xForm->isLoaded() )
//STRIP001 /*?*/ 						xForm->load();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if ( _nBehaviour & FORMS_RESET )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						Reference< XIndexAccess > xContainer( xForm, UNO_QUERY );
//STRIP001 /*?*/ 						DBG_ASSERT( xContainer.is(), "FmXFormShell::loadForms: the form is no container!" );
//STRIP001 /*?*/ 						if ( xContainer.is() )
//STRIP001 /*?*/ 							smartControlReset( xContainer );
//STRIP001 /*?*/ 					}
/*?*/ 				}
/*?*/ 				else
/*?*/ 				{
/*?*/ 					if ( xForm->isLoaded() )
/*?*/ 						xForm->unload();
/*?*/ 
/*?*/ 					if ( _nBehaviour & FORMS_RESET )
/*?*/ 					{
/*?*/ 						Reference< XReset > xReset( xForm, UNO_QUERY );
/*?*/ 						DBG_ASSERT( xReset.is(), "FmXFormShell::loadForms: the form cannot be resets!" );
/*?*/ 						if ( xReset.is() )
/*?*/ 							xReset->reset();
/*?*/ 					}
/*?*/ 				}
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 		if ( pModel )
/*N*/ 			// unlock the environment
/*N*/ 			pModel->GetUndoEnv().UnLock();
/*N*/ 	}
/*N*/ }

//==============================================================================
//==============================================================================
//STRIP001 SearchableControlIterator::SearchableControlIterator(Reference< XInterface> xStartingPoint)
//STRIP001 	:IndexAccessIterator(xStartingPoint)
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool SearchableControlIterator::ShouldHandleElement(const Reference< XInterface>& xElement)
//STRIP001 {
//STRIP001 	// wenn das Ding eine ControlSource und einen BoundField-Property hat
//STRIP001 	Reference< XPropertySet> xProperties(xElement, UNO_QUERY);
//STRIP001 	if (::comphelper::hasProperty(FM_PROP_CONTROLSOURCE, xProperties) && ::comphelper::hasProperty(FM_PROP_BOUNDFIELD, xProperties))
//STRIP001 	{
//STRIP001 		// und das BoundField gueltig ist
//STRIP001 		Reference< XPropertySet> xField;
//STRIP001 		xProperties->getPropertyValue(FM_PROP_BOUNDFIELD) >>= xField;
//STRIP001 		if (xField.is())
//STRIP001 		{
//STRIP001 			// nehmen wir's
//STRIP001 			m_sCurrentValue = ::comphelper::getString(xProperties->getPropertyValue(FM_PROP_CONTROLSOURCE));
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	// wenn es ein Grid-Control ist
//STRIP001 	if (::comphelper::hasProperty(FM_PROP_CLASSID, xProperties))
//STRIP001 	{
//STRIP001 		Any aClassId( xProperties->getPropertyValue(FM_PROP_CLASSID) );
//STRIP001 		if (::comphelper::getINT16(aClassId) == FormComponentType::GRIDCONTROL)
//STRIP001 		{
//STRIP001 			m_sCurrentValue = ::rtl::OUString();
//STRIP001 			return sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return sal_False;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 sal_Bool SearchableControlIterator::ShouldStepInto(const Reference< XInterface>& xContainer) const
//STRIP001 {
//STRIP001 	return sal_True;
//STRIP001 }

//==============================================================================
//==============================================================================
/*N*/ SV_IMPL_PTRARR(StatusForwarderArray, SfxStatusForwarder*)

/*N*/ SFX_IMPL_MENU_CONTROL(ControlConversionMenuController, SfxBoolItem);

//------------------------------------------------------------------------------
/*?*/ ControlConversionMenuController::ControlConversionMenuController(sal_uInt16 nId, Menu &rMenu, SfxBindings &rBindings)
/*?*/ 	:SfxMenuControl(nId, rBindings)
/*?*/ 	,m_pMainMenu(&rMenu)
/*?*/ 	,m_pConversionMenu(NULL)
/*?*/ {
/*?*/	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 	if (nId == SID_FM_CHANGECONTROLTYPE)
//STRIP001 	{
//STRIP001 		m_pConversionMenu = FmXFormShell::GetConversionMenu();
//STRIP001 		rMenu.SetPopupMenu(nId, m_pConversionMenu);
//STRIP001 
//STRIP001 		for (sal_Int16 i=0; i<m_pConversionMenu->GetItemCount(); ++i)
//STRIP001 		{
//STRIP001 			rBindings.Invalidate(m_pConversionMenu->GetItemId(i));
//STRIP001 			SfxStatusForwarder* pForwarder = new SfxStatusForwarder(m_pConversionMenu->GetItemId(i), *this);
//STRIP001 			m_aStatusForwarders.C40_INSERT(SfxStatusForwarder, pForwarder, m_aStatusForwarders.Count());
//STRIP001 		}
//STRIP001 	}
/*?*/ }

//------------------------------------------------------------------------------
//STRIP001 ControlConversionMenuController::~ControlConversionMenuController()
//STRIP001 {
//STRIP001 	m_pMainMenu->SetPopupMenu(SID_FM_CHANGECONTROLTYPE, NULL);
//STRIP001 	delete m_pConversionMenu;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void ControlConversionMenuController::StateChanged(sal_uInt16 nSID, SfxItemState eState, const SfxPoolItem* pState)
//STRIP001 {
//STRIP001 	if (nSID == GetId())
//STRIP001 		SfxMenuControl::StateChanged(nSID, eState, pState);
//STRIP001 	else if (FmXFormShell::IsControlConversionSlot(nSID))
//STRIP001 	{
//STRIP001 		if ((m_pConversionMenu->GetItemPos(nSID) != MENU_ITEM_NOTFOUND) && (eState == SFX_ITEM_DISABLED))
//STRIP001 		{
//STRIP001 			m_pConversionMenu->RemoveItem(m_pConversionMenu->GetItemPos(nSID));
//STRIP001 		}
//STRIP001 		else if ((m_pConversionMenu->GetItemPos(nSID) == MENU_ITEM_NOTFOUND) && (eState != SFX_ITEM_DISABLED))
//STRIP001 		{
//STRIP001 			// We can't simply re-insert the item because we have a clear order for all the our items.
//STRIP001 			// So first we have to determine the position of the item to insert.
//STRIP001 			PopupMenu* pSource = FmXFormShell::GetConversionMenu();
//STRIP001 			sal_Int16 nSourcePos = pSource->GetItemPos(nSID);
//STRIP001 			DBG_ASSERT(nSourcePos != MENU_ITEM_NOTFOUND, "ControlConversionMenuController::StateChanged : FmXFormShell supplied an invalid menu !");
//STRIP001 			sal_Int16 nPrevInSource = nSourcePos;
//STRIP001 			sal_Int16 nPrevInConversion = MENU_ITEM_NOTFOUND;
//STRIP001 			while (nPrevInSource>0)
//STRIP001 			{
//STRIP001 				sal_Int16 nPrevId = pSource->GetItemId(--nPrevInSource);
//STRIP001 
//STRIP001 				// do we have the source's predecessor in our conversion menu, too ?
//STRIP001 				nPrevInConversion = m_pConversionMenu->GetItemPos(nPrevId);
//STRIP001 				if (nPrevInConversion != MENU_ITEM_NOTFOUND)
//STRIP001 					break;
//STRIP001 			}
//STRIP001 			if (MENU_ITEM_NOTFOUND == nPrevInConversion)
//STRIP001 				// none of the items which precede the nSID-slot in the source menu are present in our conversion menu
//STRIP001 				nPrevInConversion = 0 - 1;	// put the item at the first position
//STRIP001 			m_pConversionMenu->InsertItem(nSID, pSource->GetItemText(nSID), pSource->GetItemBits(nSID), ++nPrevInConversion);
//STRIP001 			m_pConversionMenu->SetItemImage(nSID, pSource->GetItemImage(nSID));
//STRIP001 			m_pConversionMenu->SetHelpId(nSID, pSource->GetHelpId(nSID));
//STRIP001 
//STRIP001 			delete pSource;
//STRIP001 		}
//STRIP001 		m_pMainMenu->EnableItem(SID_FM_CHANGECONTROLTYPE, m_pConversionMenu->GetItemCount() > 0);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		DBG_ERROR("ControlConversionMenuController::StateChanged : unknown id !");
//STRIP001 	}
//STRIP001 }

//==================================================================

//STRIP001 FmCursorActionThread::FmCursorActionThread(const Reference< XResultSet>& _xDataSource, const UniString& _rStopperCaption,
//STRIP001 										   const UniString& _rPath)
//STRIP001 	:m_xDataSource(_xDataSource)
//STRIP001 	,m_sStopperCaption(_rStopperCaption)
//STRIP001 	,m_bCanceled(sal_False)
//STRIP001 	,m_bDeleteMyself(sal_False)
//STRIP001 	,m_bDisposeCursor(sal_False)
//STRIP001 	,m_bTerminated(sal_False)
//STRIP001 	,m_bRunFailed(sal_False)
//STRIP001 	,m_sAccessPath(_rPath)
//STRIP001 {
//STRIP001 	DBG_ASSERT(m_xDataSource.is() && Reference< XCancellable>(m_xDataSource, UNO_QUERY).is(),
//STRIP001 		"FmCursorActionThread::FmCursorActionThread : invalid cursor !");
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmCursorActionThread::run()
//STRIP001 {
//STRIP001 	// On instantiation of a SfxCancellable the application is notified and 'switches on' the red stop button.
//STRIP001 	// Unfortunally this is conditioned with the acquirement of the solar mutex, and the application tries
//STRIP001 	// only once and ignores the notification if it fails.
//STRIP001 	// To prevent that we get the solar mutex and _block_ 'til we got it.
//STRIP001 	// As we are in the 'top level execution' of this thread (with a rather small stack and no other mutexes locked)
//STRIP001 	// we shouldn't experience problems with deadlocks ...
//STRIP001 	::vos::OClearableGuard aSolarGuard(Application::GetSolarMutex());
//STRIP001 	ThreadStopper* pStopper = new ThreadStopper(this, m_sStopperCaption);
//STRIP001 	aSolarGuard.clear();
//STRIP001 
//STRIP001 	// we're not canceled yet
//STRIP001 	::osl::ClearableMutexGuard aInitGuard(m_aAccessSafety);
//STRIP001 	m_bCanceled = sal_False;
//STRIP001 	m_bRunFailed = sal_False;
//STRIP001 	aInitGuard.clear();
//STRIP001 
//STRIP001 	// start it
//STRIP001 	try
//STRIP001 	{
//STRIP001 		RunImpl();
//STRIP001 	}
//STRIP001 	catch(SQLException e)
//STRIP001 	{
//STRIP001 		::osl::MutexGuard aErrorGuard(m_aAccessSafety);
//STRIP001 		m_bRunFailed = sal_True;
//STRIP001 		m_aRunException = e;
//STRIP001 	}
//STRIP001 	catch(Exception&)
//STRIP001 	{
//STRIP001 		DBG_ERROR("FmCursorActionThread::run : catched a non-database exception !");
//STRIP001 	}
//STRIP001 
//STRIP001 
//STRIP001 	sal_Bool bReallyCanceled;
//STRIP001 	::osl::ClearableMutexGuard aEvalGuard(m_aAccessSafety);
//STRIP001 	bReallyCanceled = m_bCanceled;
//STRIP001 	aEvalGuard.clear();
//STRIP001 
//STRIP001 	pStopper->OwnerTerminated();
//STRIP001 		// this will cause the stopper to delete itself (in the main thread) so we don't have to care of the
//STRIP001 		// solar mutex
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmCursorActionThread::onTerminated()
//STRIP001 {
//STRIP001 	::osl::ClearableMutexGuard aResetGuard(m_aAccessSafety);
//STRIP001 	if (m_aTerminationHandler.IsSet())
//STRIP001 		m_aTerminationHandler.Call(this);
//STRIP001 
//STRIP001 	if (IsCursorDisposeEnabled())
//STRIP001 	{
//STRIP001 		Reference< ::com::sun::star::lang::XComponent> xDataSourceComponent(m_xDataSource, UNO_QUERY);
//STRIP001 		if (xDataSourceComponent.is())
//STRIP001 			xDataSourceComponent->dispose();
//STRIP001 	}
//STRIP001 
//STRIP001 	aResetGuard.clear();
//STRIP001 		// with this StopItWait has a chance to do it's Terminated()
//STRIP001 
//STRIP001 	::osl::MutexGuard aGuard(m_aFinalExitControl);
//STRIP001 		// Terminated() in StopItWait still returns sal_False
//STRIP001 	m_bTerminated = sal_True;
//STRIP001 		// Terminated() now returns sal_True, but StopItWait can't exit until this method exits (because of the guarded m_aFinalExitControl)
//STRIP001 
//STRIP001 	if (IsSelfDeleteEnabled())
//STRIP001 		delete this;
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmCursorActionThread::StopIt()
//STRIP001 {
//STRIP001 	::osl::MutexGuard aGuard(m_aAccessSafety);
//STRIP001 	m_bCanceled = sal_True;
//STRIP001 
//STRIP001 	Reference< XCancellable> xCancel(m_xDataSource, UNO_QUERY);
//STRIP001 	DBG_ASSERT(xCancel.is(), "FmCursorActionThread::StopIt : invalid cursor !");
//STRIP001 	xCancel->cancel();
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmCursorActionThread::StopItWait()
//STRIP001 {
//STRIP001 	StopIt();
//STRIP001 
//STRIP001 	while (!Terminated())
//STRIP001 		;
//STRIP001 
//STRIP001 	// OnTerminated has been called, but we can't simply exit : Suppose the caller want's to delete the thread object
//STRIP001 	// immediately after returning from StopItWait. With the following guard we ensure that we exit this method
//STRIP001 	// only after onTerminated has exited.
//STRIP001 	::osl::ClearableMutexGuard aGuard(m_aFinalExitControl);
//STRIP001 
//STRIP001 	// now onTerminated has exited, so we can leave, too
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 FmCursorActionThread::ThreadStopper::ThreadStopper(FmCursorActionThread* pOwner, const UniString& rTitle)
//STRIP001 	:SfxCancellable(SFX_APP()->GetCancelManager(), rTitle)
//STRIP001 	,m_pOwner(pOwner)
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmCursorActionThread::ThreadStopper::Cancel()
//STRIP001 {
//STRIP001 	if (!m_pOwner)		// the owner is already terminated and we're waiting for the OnDeleteInMainThread event
//STRIP001 		return;
//STRIP001 
//STRIP001 	::osl::MutexGuard aGuard(m_pOwner->m_aAccessSafety);
//STRIP001 	if (IsCancelled())
//STRIP001 		// we already did pass this to our owner
//STRIP001 		return;
//STRIP001 
//STRIP001 	SfxCancellable::Cancel();
//STRIP001 	m_pOwner->StopIt();
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmCursorActionThread::ThreadStopper::OwnerTerminated()
//STRIP001 {
//STRIP001 	m_pOwner = NULL;
//STRIP001 	Application::PostUserEvent(LINK(this, FmCursorActionThread::ThreadStopper, OnDeleteInMainThread), this);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 IMPL_LINK(FmCursorActionThread::ThreadStopper, OnDeleteInMainThread, FmCursorActionThread::ThreadStopper*, pThis)
//STRIP001 {
//STRIP001 	delete pThis;
//STRIP001 	return 0L;
//STRIP001 }

//==============================================================================
//==============================================================================

//------------------------------------------------------------------------------
//STRIP001 FmFormNavigationDispatcher::FmFormNavigationDispatcher(const URL& _rUrl, sal_Int16 _nSlotId, SfxBindings& _rBindings, const Reference< XResultSet>& _xForm, const UniString& _rAccessPath)
//STRIP001 		:FmSlotDispatch(_rUrl, _nSlotId, _rBindings)
//STRIP001 		,m_bActive(sal_False)
//STRIP001 		,m_xCursor(_xForm)
//STRIP001 		,m_sAccessPath(_rAccessPath)
//STRIP001 {
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmFormNavigationDispatcher::SetActive(sal_Bool bEnable)
//STRIP001 {
//STRIP001 	if (m_bActive == bEnable)
//STRIP001 		return;
//STRIP001 
//STRIP001 	m_bActive = bEnable;
//STRIP001 
//STRIP001 	// broadcast the initial state
//STRIP001 	if (bEnable)
//STRIP001 	{
//STRIP001 		SfxPoolItem* pState = NULL;
//STRIP001 		SfxItemState eInitialState = GetBindings().QueryState(m_nSlot, pState);
//STRIP001 		NotifyState(eInitialState, pState);
//STRIP001 		delete pState;
//STRIP001 	}
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmFormNavigationDispatcher::SetStatus(SfxItemState eState, const SfxPoolItem* pState)
//STRIP001 {
//STRIP001 	m_aNonActiveState = BuildEvent(eState, pState);
//STRIP001 	NOTIFY_LISTENERS(m_aStatusListeners, ::com::sun::star::frame::XStatusListener, statusChanged, m_aNonActiveState);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmFormNavigationDispatcher::StateChanged(USHORT nSID, SfxItemState eState, const SfxPoolItem* pState)
//STRIP001 {
//STRIP001 	if (IsActive())
//STRIP001 		FmSlotDispatch::StateChanged(nSID, eState, pState);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmFormNavigationDispatcher::NotifyState(SfxItemState eState, const SfxPoolItem* pState, const Reference< ::com::sun::star::frame::XStatusListener>& rListener)
//STRIP001 {
//STRIP001 	if (IsActive())
//STRIP001 		FmSlotDispatch::NotifyState(eState, pState, rListener);
//STRIP001 	else
//STRIP001 		if (rListener.is())
//STRIP001 			rListener->statusChanged(m_aNonActiveState);
//STRIP001 		else
//STRIP001 			NOTIFY_LISTENERS(m_aStatusListeners, ::com::sun::star::frame::XStatusListener, statusChanged, m_aNonActiveState);
//STRIP001 }

//------------------------------------------------------------------------------
//STRIP001 void FmFormNavigationDispatcher::dispose(void) throw( RuntimeException )
//STRIP001 {
//STRIP001 	m_aNonActiveState.Source = NULL;
//STRIP001 		// the Source is a reference to myself, so we would never be deleted without this
//STRIP001 	FmSlotDispatch::dispose();
//STRIP001 }

//==============================================================================




}
