/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_galbrws2.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 05:55:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#define ITEMID_BRUSH 0

// auto strip #include <sot/formats.hxx>
// auto strip #include <vcl/msgbox.hxx>
// auto strip #include <svtools/valueset.hxx>
// auto strip #include <svtools/urlbmk.hxx>
// auto strip #include <svtools/stritem.hxx>
// auto strip #include <svtools/intitem.hxx>
// auto strip #include <svtools/eitem.hxx>
// auto strip #include <svtools/transfer.hxx>
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #include <bf_sfx2/viewfrm.hxx>
#include <bf_sfx2/sfxsids.hrc>
// auto strip #include "impgrf.hxx"
// auto strip #include "brshitem.hxx"
#include "helpid.hrc"
// auto strip #include "gallery1.hxx"
// auto strip #include "galtheme.hxx"
// auto strip #include "galmisc.hxx"
// auto strip #include "galdlg.hxx"
// auto strip #include "galbrws2.hxx"
namespace binfilter {

// -----------
// - Defines -
// -----------

#undef GALLERY_USE_CLIPBOARD

#define TBX_ID_ICON 1
#define TBX_ID_LIST 2

// -----------
// - statics -
// -----------

//STRIP001 GalleryBrowserMode GalleryBrowser2::meInitMode = GALLERYBROWSERMODE_ICON;

// --------------------------
// - GalleryBackgroundPopup -
// --------------------------

//STRIP001 class GalleryBackgroundPopup : public PopupMenu, public SfxControllerItem
//STRIP001 {
//STRIP001 	const GalleryTheme* mpTheme;
//STRIP001 	ULONG				mnObjectPos;
//STRIP001 
//STRIP001 	virtual void		Select();
//STRIP001 	virtual void		StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 					GalleryBackgroundPopup( const GalleryTheme* pTheme, ULONG nObjectPos );
//STRIP001 					~GalleryBackgroundPopup();
//STRIP001 };
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryBackgroundPopup::GalleryBackgroundPopup( const GalleryTheme* pTheme, ULONG nObjectPos ) :
//STRIP001 			SfxControllerItem	( SID_GALLERY_BG_BRUSH, SfxViewFrame::Current()->GetBindings() ),
//STRIP001 			mpTheme				( pTheme ),
//STRIP001 			mnObjectPos			( nObjectPos )
//STRIP001 {
//STRIP001 	SfxViewFrame::Current()->GetBindings().Update( SID_GALLERY_BG_BRUSH );
//STRIP001 	RemoveDisabledEntries();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryBackgroundPopup::~GalleryBackgroundPopup()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBackgroundPopup::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if ( ( nSID == SID_GALLERY_BG_BRUSH ) && pItem && ( eState != SFX_ITEM_DISABLED ) )
//STRIP001 	{
//STRIP001 		SfxStringListItem*	pStrLstItem;
//STRIP001 		SfxStringItem*		pStrItem;
//STRIP001 
//STRIP001 		PopupMenu::Clear();
//STRIP001 
//STRIP001 		if( ( pStrLstItem = PTR_CAST( SfxStringListItem, pItem ) ) != NULL )
//STRIP001 		{
//STRIP001 			List* pList = pStrLstItem->GetList();
//STRIP001 
//STRIP001 			if( pList )
//STRIP001 				for ( ULONG i = 0, nCount = pList->Count(); i < nCount; i++ )
//STRIP001 					InsertItem( (USHORT) i + 1, *(String*) pList->GetObject( i ) );
//STRIP001 		}
//STRIP001 		else if( ( pStrItem = PTR_CAST( SfxStringItem, pItem ) ) != NULL )
//STRIP001 			InsertItem( 1, pStrItem->GetValue() );
//STRIP001 		else
//STRIP001 		{
//STRIP001 			DBG_ERROR( "SgaBGPopup::StateChanged(...): Wrong item type!" );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBackgroundPopup::Select()
//STRIP001 {
//STRIP001 	Menu::Select();
//STRIP001 
//STRIP001 	const INetURLObject	aURL( mpTheme->GetObjectURL( mnObjectPos ) );	
//STRIP001 	const SvxBrushItem	aBrushItem( aURL.GetMainURL( INetURLObject::NO_DECODE ), String(), GPOS_TILED, SID_GALLERY_BG_BRUSH );
//STRIP001 	const SfxUInt16Item aPosItem( SID_GALLERY_BG_POS, GetCurItemId() - 1 );
//STRIP001 	const SfxStringItem	aPathItem( SID_FILE_NAME, aURL.GetMainURL( INetURLObject::NO_DECODE ) );
//STRIP001 
//STRIP001 	SfxViewFrame::Current()->GetBindings().GetDispatcher()->Execute( SID_GALLERY_BG_BRUSH,
//STRIP001 							  SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD,
//STRIP001 							  &aBrushItem, &aPosItem, &aPathItem, 0L );
//STRIP001 }
//STRIP001 
//STRIP001 // ---------------------
//STRIP001 // - GalleryThemePopup -
//STRIP001 // ---------------------
//STRIP001 
//STRIP001 class GalleryThemePopup : public PopupMenu, public SfxControllerItem
//STRIP001 {
//STRIP001 	GalleryBackgroundPopup	maBackgroundPopup;
//STRIP001 	const GalleryTheme*		mpTheme;
//STRIP001 	ULONG					mnObjectPos;
//STRIP001 	BOOL					mbPreview;
//STRIP001 
//STRIP001 	virtual void			StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pState );
//STRIP001 
//STRIP001 public:
//STRIP001 
//STRIP001 							GalleryThemePopup( const GalleryTheme* pTheme, ULONG nObjectPos, BOOL bPreview );
//STRIP001 							~GalleryThemePopup();
//STRIP001 };
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryThemePopup::GalleryThemePopup( const GalleryTheme* pTheme, ULONG nObjectPos, BOOL bPreview ) :
//STRIP001 	PopupMenu			( GAL_RESID( RID_SVXMN_GALLERY2 ) ),
//STRIP001 	SfxControllerItem	( SID_GALLERY_ENABLE_ADDCOPY, SfxViewFrame::Current()->GetBindings() ),
//STRIP001 	maBackgroundPopup	( pTheme, nObjectPos ),
//STRIP001 	mpTheme				( pTheme ),
//STRIP001 	mnObjectPos			( nObjectPos ),
//STRIP001 	mbPreview			( bPreview )
//STRIP001 {
//STRIP001 	const SgaObjKind	eObjKind = mpTheme->GetObjectKind( mnObjectPos );
//STRIP001 	PopupMenu*			pAddMenu = GetPopupMenu( MN_ADDMENU );
//STRIP001 	SfxBindings&		rBindings = SfxViewFrame::Current()->GetBindings();
//STRIP001     INetURLObject       aURL;
//STRIP001 
//STRIP001     const_cast< GalleryTheme* >( mpTheme )->GetURL( mnObjectPos, aURL );
//STRIP001     const BOOL bValidURL = ( aURL.GetProtocol() != INET_PROT_NOT_VALID );
//STRIP001 
//STRIP001 	pAddMenu->EnableItem( MN_ADD, bValidURL && SGA_OBJ_SOUND != eObjKind );
//STRIP001 	pAddMenu->EnableItem( MN_ADD_LINK, bValidURL && SGA_OBJ_SVDRAW != eObjKind );
//STRIP001 	
//STRIP001     EnableItem( MN_ADDMENU, pAddMenu->IsItemEnabled( MN_ADD ) || pAddMenu->IsItemEnabled( MN_ADD_LINK ) );
//STRIP001     EnableItem( MN_PREVIEW, bValidURL );
//STRIP001     
//STRIP001     CheckItem( MN_PREVIEW, mbPreview );
//STRIP001 
//STRIP001 	if( mpTheme->IsReadOnly() || !mpTheme->GetObjectCount() )
//STRIP001 	{
//STRIP001 		EnableItem( MN_DELETE, FALSE );
//STRIP001 		EnableItem( MN_TITLE, FALSE );
//STRIP001 
//STRIP001 		if( mpTheme->IsReadOnly() )
//STRIP001 			EnableItem( MN_PASTECLIPBOARD, FALSE );
//STRIP001 		
//STRIP001 		if( !mpTheme->GetObjectCount() )
//STRIP001 			EnableItem( MN_COPYCLIPBOARD, FALSE );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		EnableItem( MN_DELETE, !bPreview );
//STRIP001 		EnableItem( MN_TITLE, TRUE );
//STRIP001 		EnableItem( MN_COPYCLIPBOARD, TRUE );
//STRIP001 		EnableItem( MN_PASTECLIPBOARD, TRUE );
//STRIP001 	}
//STRIP001 
//STRIP001 #ifdef GALLERY_USE_CLIPBOARD
//STRIP001 	if( IsItemEnabled( MN_PASTECLIPBOARD ) )
//STRIP001     {
//STRIP001     	TransferableDataHelper	aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( this ) );
//STRIP001     	BOOL					bEnable = FALSE;
//STRIP001 
//STRIP001 	    if( aDataHelper.GetFormatCount() )
//STRIP001 	    {
//STRIP001 		    if( aDataHelper.HasFormat( SOT_FORMATSTR_ID_DRAWING ) ||
//STRIP001 			    aDataHelper.HasFormat( SOT_FORMAT_FILE_LIST ) ||
//STRIP001 			    aDataHelper.HasFormat( FORMAT_FILE ) ||
//STRIP001 			    aDataHelper.HasFormat( SOT_FORMATSTR_ID_SVXB ) ||
//STRIP001 			    aDataHelper.HasFormat( FORMAT_GDIMETAFILE ) ||
//STRIP001 			    aDataHelper.HasFormat( FORMAT_BITMAP ) )
//STRIP001 		    {
//STRIP001 			    bEnable = TRUE;
//STRIP001 		    }
//STRIP001 	    }
//STRIP001 
//STRIP001         if( !bEnable )
//STRIP001     		EnableItem( MN_PASTECLIPBOARD, FALSE );
//STRIP001     }
//STRIP001 #else
//STRIP001 	EnableItem( MN_COPYCLIPBOARD, FALSE );
//STRIP001 	EnableItem( MN_PASTECLIPBOARD, FALSE );
//STRIP001 #endif
//STRIP001 
//STRIP001 	if( !maBackgroundPopup.GetItemCount() || ( eObjKind == SGA_OBJ_SVDRAW ) || ( eObjKind == SGA_OBJ_SOUND ) )
//STRIP001 		pAddMenu->EnableItem( MN_BACKGROUND, FALSE );
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pAddMenu->EnableItem( MN_BACKGROUND, TRUE );
//STRIP001 		pAddMenu->SetPopupMenu( MN_BACKGROUND, &maBackgroundPopup );
//STRIP001 	}
//STRIP001 
//STRIP001 	rBindings.Update( SID_GALLERY_ENABLE_ADDCOPY );
//STRIP001 	RemoveDisabledEntries();
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryThemePopup::~GalleryThemePopup()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryThemePopup::StateChanged( USHORT nSID, SfxItemState eState, const SfxPoolItem* pItem )
//STRIP001 {
//STRIP001 	if( ( nSID == SID_GALLERY_ENABLE_ADDCOPY ) && pItem && ( eState != SFX_ITEM_DISABLED ) )
//STRIP001 	{
//STRIP001 		SfxBoolItem*        pBoolItem = PTR_CAST( SfxBoolItem, pItem );
//STRIP001     	const SgaObjKind	eObjKind = mpTheme->GetObjectKind( mnObjectPos );
//STRIP001 		
//STRIP001         DBG_ASSERT( pBoolItem || pBoolItem == 0, "SfxBoolItem erwartet!");
//STRIP001 		
//STRIP001         GetPopupMenu( MN_ADDMENU )->EnableItem( MN_ADD, pBoolItem->GetValue() && ( eObjKind != SGA_OBJ_SOUND ) );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------
//STRIP001 // - GalleryToolBox -
//STRIP001 // ------------------
//STRIP001 
//STRIP001 GalleryToolBox::GalleryToolBox( GalleryBrowser2* pParent ) :
//STRIP001     ToolBox( pParent, WB_TABSTOP )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryToolBox::~GalleryToolBox()
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 // ------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryToolBox::KeyInput( const KeyEvent& rKEvt )
//STRIP001 {
//STRIP001     if( !static_cast< GalleryBrowser2* >( GetParent() )->KeyInput( rKEvt, this ) )
//STRIP001         ToolBox::KeyInput( rKEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -------------------
//STRIP001 // - GalleryBrowser2 -
//STRIP001 // -------------------
//STRIP001 
//STRIP001 GalleryBrowser2::GalleryBrowser2( GalleryBrowser* pParent, const ResId& rResId, Gallery* pGallery ) :
//STRIP001 	Control				( pParent, rResId ),
//STRIP001 	mpGallery			( pGallery ),
//STRIP001 	mpCurTheme			( NULL ),
//STRIP001 	mpIconView          ( new GalleryIconView( this, NULL ) ),
//STRIP001     mpListView          ( new GalleryListView( this, NULL ) ),
//STRIP001 	mpPreview           ( new GalleryPreview( this, NULL ) ),
//STRIP001     maViewBox           ( this ), 
//STRIP001     maSeparator         ( this, WB_VERT ),
//STRIP001 	maInfoBar			( this, WB_LEFT | WB_VCENTER ),
//STRIP001 	mnCurActionPos		( 0xffffffff ),
//STRIP001     meMode              ( GALLERYBROWSERMODE_NONE ),
//STRIP001     meLastMode          ( GALLERYBROWSERMODE_NONE ),
//STRIP001 	mbCurActionIsLinkage( FALSE )
//STRIP001 {
//STRIP001     Image       aDummyImage;
//STRIP001     const Link  aSelectHdl( LINK( this, GalleryBrowser2, SelectObjectHdl ) );
//STRIP001     Font        aInfoFont( maInfoBar.GetControlFont() );
//STRIP001 
//STRIP001     maViewBox.InsertItem( TBX_ID_ICON, aDummyImage );
//STRIP001     maViewBox.SetItemBits( TBX_ID_ICON, TIB_RADIOCHECK | TIB_AUTOCHECK );
//STRIP001     maViewBox.SetHelpId( TBX_ID_ICON, HID_GALLERY_ICONVIEW );
//STRIP001     maViewBox.SetQuickHelpText( TBX_ID_ICON, String( GAL_RESID( RID_SVXSTR_GALLERY_ICONVIEW ) ) );
//STRIP001 
//STRIP001     maViewBox.InsertItem( TBX_ID_LIST, aDummyImage );
//STRIP001     maViewBox.SetItemBits( TBX_ID_LIST, TIB_RADIOCHECK | TIB_AUTOCHECK );
//STRIP001     maViewBox.SetHelpId( TBX_ID_LIST, HID_GALLERY_LISTVIEW );
//STRIP001     maViewBox.SetQuickHelpText( TBX_ID_LIST, String( GAL_RESID( RID_SVXSTR_GALLERY_LISTVIEW ) ) );
//STRIP001 
//STRIP001     maViewBox.SetBorder( 0, 1 );
//STRIP001     maViewBox.SetOutStyle( TOOLBOX_STYLE_FLAT );
//STRIP001     maViewBox.SetPosSizePixel( Point(), maViewBox.CalcWindowSizePixel() );
//STRIP001     maViewBox.SetSelectHdl( LINK( this, GalleryBrowser2, SelectTbxHdl ) );
//STRIP001     maViewBox.Show();
//STRIP001 
//STRIP001 	maInfoBar.Show();
//STRIP001     maSeparator.Show();
//STRIP001 
//STRIP001 	mpIconView->SetSelectHdl( aSelectHdl );
//STRIP001 	mpListView->SetSelectHdl( aSelectHdl );
//STRIP001 
//STRIP001     InitSettings();
//STRIP001 
//STRIP001     SetMode( ( GALLERYBROWSERMODE_PREVIEW != GalleryBrowser2::meInitMode ) ? GalleryBrowser2::meInitMode : GALLERYBROWSERMODE_ICON );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 GalleryBrowser2::~GalleryBrowser2()
//STRIP001 {
//STRIP001 	delete mpPreview;
//STRIP001     delete mpListView;
//STRIP001 	delete mpIconView;
//STRIP001 
//STRIP001 	if( mpCurTheme )
//STRIP001 		mpGallery->ReleaseTheme( mpCurTheme, *this );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::InitSettings()
//STRIP001 {
//STRIP001     BOOL  bHC = GALLERY_DLG_COLOR.IsDark();
//STRIP001     Image aIconImage( GAL_RESID( bHC? RID_SVXIMG_GALLERY_VIEW_ICON_HC : RID_SVXIMG_GALLERY_VIEW_ICON ) );
//STRIP001     Image aListImage( GAL_RESID( bHC? RID_SVXIMG_GALLERY_VIEW_LIST_HC : RID_SVXIMG_GALLERY_VIEW_LIST ) );
//STRIP001     Font  aInfoFont( maInfoBar.GetControlFont() );
//STRIP001 
//STRIP001     maViewBox.SetItemImage( TBX_ID_ICON, aIconImage );
//STRIP001     maViewBox.SetItemImage( TBX_ID_LIST, aListImage );
//STRIP001 
//STRIP001     aInfoFont.SetWeight( WEIGHT_BOLD );
//STRIP001     aInfoFont.SetColor( GALLERY_FG_COLOR );
//STRIP001     maInfoBar.SetControlFont( aInfoFont );
//STRIP001 	
//STRIP001     maInfoBar.SetBackground( Wallpaper( GALLERY_DLG_COLOR ) );
//STRIP001 	maInfoBar.SetControlBackground( GALLERY_DLG_COLOR );
//STRIP001 
//STRIP001 	maSeparator.SetBackground( Wallpaper( GALLERY_BG_COLOR ) );
//STRIP001 	maSeparator.SetControlBackground( GALLERY_BG_COLOR );
//STRIP001 	maSeparator.SetControlForeground( GALLERY_FG_COLOR );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::DataChanged( const DataChangedEvent& rDCEvt )
//STRIP001 {
//STRIP001 	if ( ( rDCEvt.GetType() == DATACHANGED_SETTINGS ) && ( rDCEvt.GetFlags() & SETTINGS_STYLE ) )
//STRIP001         InitSettings();
//STRIP001     else
//STRIP001         Control::DataChanged( rDCEvt );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::Resize()
//STRIP001 {
//STRIP001 	Control::Resize();
//STRIP001 
//STRIP001 	mpIconView->Hide();
//STRIP001     mpListView->Hide();
//STRIP001     mpPreview->Hide(); 
//STRIP001 
//STRIP001 	const Size	aOutSize( GetOutputSizePixel() );
//STRIP001     const Size  aBoxSize( maViewBox.GetOutputSizePixel() );
//STRIP001     const long  nOffset = 2, nSepWidth = 2;
//STRIP001     const long  nInfoBarX = aBoxSize.Width() + ( nOffset * 3 ) + nSepWidth;
//STRIP001 	const Point	aPt( 0, aBoxSize.Height() + 3 );
//STRIP001 	const Size	aSz( aOutSize.Width(), aOutSize.Height() - aPt.Y() );
//STRIP001 	
//STRIP001     maSeparator.SetPosSizePixel( Point( aBoxSize.Width() + nOffset, 0 ), Size( nSepWidth, aBoxSize.Height() ) );
//STRIP001     maInfoBar.SetPosSizePixel( Point( nInfoBarX, 0 ), Size( aOutSize.Width() - nInfoBarX, aBoxSize.Height() ) );
//STRIP001 	
//STRIP001     mpIconView->SetPosSizePixel( aPt, aSz );
//STRIP001     mpListView->SetPosSizePixel( aPt, aSz );
//STRIP001 	mpPreview->SetPosSizePixel( aPt, aSz );
//STRIP001 
//STRIP001     switch( GetMode() )
//STRIP001     {
//STRIP001         case( GALLERYBROWSERMODE_ICON ): mpIconView->Show(); break;
//STRIP001         case( GALLERYBROWSERMODE_LIST ): mpListView->Show(); break;
//STRIP001         case( GALLERYBROWSERMODE_PREVIEW ): mpPreview->Show(); break;
//STRIP001 
//STRIP001         default:
//STRIP001         break;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::Notify( SfxBroadcaster& rBC, const SfxHint& rHint )
//STRIP001 {
//STRIP001 	const GalleryHint& rGalleryHint = (const GalleryHint&) rHint;
//STRIP001 
//STRIP001 	switch( rGalleryHint.GetType() )
//STRIP001 	{
//STRIP001 		case( GALLERY_HINT_THEME_UPDATEVIEW ):
//STRIP001 		{
//STRIP001             if( GALLERYBROWSERMODE_PREVIEW == GetMode() )
//STRIP001                 SetMode( meLastMode );
//STRIP001 
//STRIP001 			ImplUpdateViews( (USHORT) rGalleryHint.GetData1() + 1 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 		default:
//STRIP001 		break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryBrowser2::AcceptDrop( DropTargetHelper& rTarget, const AcceptDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( mpCurTheme && !mpCurTheme->IsReadOnly() && !mpCurTheme ->IsImported() )
//STRIP001 	{
//STRIP001 		if( !mpCurTheme->IsDragging() )
//STRIP001 		{
//STRIP001 			if( rTarget.IsDropFormatSupported( SOT_FORMATSTR_ID_DRAWING ) ||
//STRIP001 				rTarget.IsDropFormatSupported( SOT_FORMAT_FILE_LIST ) ||
//STRIP001 				rTarget.IsDropFormatSupported( FORMAT_FILE ) ||
//STRIP001 				rTarget.IsDropFormatSupported( SOT_FORMATSTR_ID_SVXB ) ||
//STRIP001 				rTarget.IsDropFormatSupported( FORMAT_GDIMETAFILE ) ||
//STRIP001 				rTarget.IsDropFormatSupported( FORMAT_BITMAP ) )
//STRIP001 			{
//STRIP001 				nRet = DND_ACTION_COPY;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			nRet = DND_ACTION_COPY;
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Int8 GalleryBrowser2::ExecuteDrop( DropTargetHelper& rTarget, const ExecuteDropEvent& rEvt )
//STRIP001 {
//STRIP001 	sal_Int8 nRet = DND_ACTION_NONE;
//STRIP001 
//STRIP001 	if( mpCurTheme )
//STRIP001 	{
//STRIP001 		Point		aSelPos;
//STRIP001 		const ULONG nItemId = ImplGetSelectedItemId( &rEvt.maPosPixel, aSelPos );
//STRIP001 		const ULONG	nInsertPos = ( nItemId ? ( nItemId - 1 ) : LIST_APPEND );
//STRIP001 
//STRIP001 		if( mpCurTheme->IsDragging() )
//STRIP001 			mpCurTheme->ChangeObjectPos( mpCurTheme->GetDragPos(), nInsertPos );
//STRIP001 		else
//STRIP001 			nRet = mpCurTheme->InsertTransferable( rEvt.maDropEvent.Transferable, nInsertPos );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::StartDrag( Window* pWindow, const Point* pDragPoint )
//STRIP001 {
//STRIP001 	if( mpCurTheme )
//STRIP001 	{
//STRIP001 	    Point		aSelPos;
//STRIP001 		const ULONG nItemId = ImplGetSelectedItemId( pDragPoint, aSelPos );
//STRIP001 
//STRIP001         if( nItemId )
//STRIP001 			mpCurTheme->StartDrag( this, nItemId - 1 );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::TogglePreview( Window* pWindow, const Point* pPreviewPoint )
//STRIP001 {
//STRIP001     SetMode( ( GALLERYBROWSERMODE_PREVIEW != GetMode() ) ? GALLERYBROWSERMODE_PREVIEW : meLastMode );
//STRIP001 	GetViewWindow()->GrabFocus();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::ShowContextMenu( Window* pWindow, const Point* pContextPoint )
//STRIP001 {
//STRIP001     Point		aSelPos;
//STRIP001 	const ULONG nItemId = ImplGetSelectedItemId( pContextPoint, aSelPos );
//STRIP001 
//STRIP001 	if( mpCurTheme && nItemId && ( nItemId <= mpCurTheme->GetObjectCount() ) )
//STRIP001 	{
//STRIP001         ImplSelectItemId( nItemId );
//STRIP001 
//STRIP001 		SfxBindings& rBindings = SfxViewFrame::Current()->GetBindings();
//STRIP001 		rBindings.ENTERREGISTRATIONS();
//STRIP001 		GalleryThemePopup aMenu( mpCurTheme, nItemId - 1, GALLERYBROWSERMODE_PREVIEW == GetMode() );
//STRIP001 		rBindings.LEAVEREGISTRATIONS();
//STRIP001 		aMenu.SetSelectHdl( LINK( this, GalleryBrowser2, MenuSelectHdl ) );
//STRIP001 		aMenu.Execute( this, aSelPos  );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryBrowser2::KeyInput( const KeyEvent& rKEvt, Window* pWindow )
//STRIP001 {
//STRIP001     Point		aSelPos;
//STRIP001 	const ULONG	nItemId = ImplGetSelectedItemId( NULL, aSelPos );
//STRIP001     BOOL        bRet = static_cast< GalleryBrowser* >( GetParent() )->KeyInput( rKEvt, pWindow );
//STRIP001 
//STRIP001     if( !bRet && !maViewBox.HasFocus() && nItemId && mpCurTheme )
//STRIP001     {
//STRIP001         USHORT              nExecuteId = 0;
//STRIP001 	    const SgaObjKind	eObjKind = mpCurTheme->GetObjectKind( nItemId - 1 );
//STRIP001         INetURLObject       aURL;
//STRIP001 
//STRIP001         const_cast< GalleryTheme* >( mpCurTheme )->GetURL( nItemId - 1, aURL );
//STRIP001         
//STRIP001         const BOOL  bValidURL = ( aURL.GetProtocol() != INET_PROT_NOT_VALID );
//STRIP001         BOOL        bPreview = bValidURL;
//STRIP001         BOOL        bAdd = bValidURL;
//STRIP001         BOOL        bAddLink = ( bValidURL && SGA_OBJ_SVDRAW != eObjKind );
//STRIP001         BOOL        bDelete = FALSE;
//STRIP001         BOOL        bTitle = FALSE;
//STRIP001 
//STRIP001 	    if( !mpCurTheme->IsReadOnly() && mpCurTheme->GetObjectCount() )
//STRIP001 	    {
//STRIP001             bDelete = ( GALLERYBROWSERMODE_PREVIEW != GetMode() );
//STRIP001             bTitle = TRUE;
//STRIP001 	    }
//STRIP001 
//STRIP001         switch( rKEvt.GetKeyCode().GetCode() )
//STRIP001         {
//STRIP001             case( KEY_SPACE ):
//STRIP001             case( KEY_RETURN ):
//STRIP001             case( KEY_P ):
//STRIP001             {
//STRIP001                 if( bPreview )
//STRIP001                 {
//STRIP001                     TogglePreview( pWindow );
//STRIP001                     bRet = TRUE;
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_INSERT ):
//STRIP001             case( KEY_I ):
//STRIP001             {
//STRIP001                 if( bAddLink && rKEvt.GetKeyCode().IsShift() && rKEvt.GetKeyCode().IsMod1() )
//STRIP001                     nExecuteId = MN_ADD_LINK;
//STRIP001                 else if( bAdd )
//STRIP001                     nExecuteId = MN_ADD;
//STRIP001             }
//STRIP001             break;
//STRIP001         
//STRIP001             case( KEY_DELETE ):
//STRIP001             case( KEY_D ):
//STRIP001             {
//STRIP001                 if( bDelete )
//STRIP001                     nExecuteId = MN_DELETE;
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( KEY_T ):
//STRIP001             {
//STRIP001                 if( bTitle )
//STRIP001                     nExecuteId = MN_TITLE;
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             default:
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         if( nExecuteId )
//STRIP001         {
//STRIP001             ImplExecute( nExecuteId );
//STRIP001             bRet = TRUE;
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::SelectTheme( const String& rThemeName )
//STRIP001 {
//STRIP001 	delete mpIconView, mpIconView = NULL;
//STRIP001     delete mpListView, mpListView = NULL;
//STRIP001 	delete mpPreview, mpPreview = NULL;
//STRIP001 	
//STRIP001 	if( mpCurTheme )
//STRIP001 		mpGallery->ReleaseTheme( mpCurTheme, *this );
//STRIP001 
//STRIP001 	mpCurTheme = mpGallery->AcquireTheme( rThemeName, *this );
//STRIP001 	
//STRIP001 	mpIconView = new GalleryIconView( this, mpCurTheme );
//STRIP001     mpListView = new GalleryListView( this, mpCurTheme );
//STRIP001 	mpPreview = new GalleryPreview( this, mpCurTheme );
//STRIP001 
//STRIP001     const Link aSelectHdl( LINK( this, GalleryBrowser2, SelectObjectHdl ) );
//STRIP001 
//STRIP001 	mpIconView->SetSelectHdl( aSelectHdl );
//STRIP001 	mpListView->SetSelectHdl( aSelectHdl );
//STRIP001 
//STRIP001     if( GALLERYBROWSERMODE_PREVIEW == GetMode() )
//STRIP001         meMode = meLastMode;
//STRIP001 
//STRIP001 	Resize();
//STRIP001     ImplUpdateViews( 1 );
//STRIP001 
//STRIP001     maViewBox.EnableItem( TBX_ID_ICON, TRUE );
//STRIP001     maViewBox.EnableItem( TBX_ID_LIST, TRUE );
//STRIP001     maViewBox.CheckItem( ( GALLERYBROWSERMODE_ICON == GetMode() ) ? TBX_ID_ICON : TBX_ID_LIST, TRUE );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::SetMode( GalleryBrowserMode eMode )
//STRIP001 {
//STRIP001     if( GetMode() != eMode )
//STRIP001     {
//STRIP001         meLastMode = GetMode();
//STRIP001 
//STRIP001         switch( eMode )
//STRIP001         {
//STRIP001             case( GALLERYBROWSERMODE_ICON ):
//STRIP001             {
//STRIP001 			    mpListView->Hide();
//STRIP001 
//STRIP001 			    mpPreview->Hide();
//STRIP001     			mpPreview->SetGraphic( Graphic() );
//STRIP001 	    		mpPreview->PreviewSound( INetURLObject() );
//STRIP001 
//STRIP001                 mpIconView->Show();
//STRIP001 
//STRIP001                 maViewBox.EnableItem( TBX_ID_ICON, TRUE );
//STRIP001                 maViewBox.EnableItem( TBX_ID_LIST, TRUE );
//STRIP001 
//STRIP001                 maViewBox.CheckItem( TBX_ID_ICON, TRUE );
//STRIP001                 maViewBox.CheckItem( TBX_ID_LIST, FALSE );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( GALLERYBROWSERMODE_LIST ):
//STRIP001             {
//STRIP001 			    mpIconView->Hide();
//STRIP001 
//STRIP001 			    mpPreview->Hide();
//STRIP001     			mpPreview->SetGraphic( Graphic() );
//STRIP001 	    		mpPreview->PreviewSound( INetURLObject() );
//STRIP001 
//STRIP001                 mpListView->Show();
//STRIP001 
//STRIP001                 maViewBox.EnableItem( TBX_ID_ICON, TRUE );
//STRIP001                 maViewBox.EnableItem( TBX_ID_LIST, TRUE );
//STRIP001 
//STRIP001                 maViewBox.CheckItem( TBX_ID_ICON, FALSE );
//STRIP001                 maViewBox.CheckItem( TBX_ID_LIST, TRUE );
//STRIP001             }
//STRIP001             break;
//STRIP001 
//STRIP001             case( GALLERYBROWSERMODE_PREVIEW ):
//STRIP001             {
//STRIP001     			Graphic		aGraphic;
//STRIP001 			    Point		aSelPos;
//STRIP001 	    		const ULONG	nItemId = ImplGetSelectedItemId( NULL, aSelPos );
//STRIP001 
//STRIP001                 if( nItemId )
//STRIP001                 {
//STRIP001                     const ULONG nPos = nItemId - 1;
//STRIP001 
//STRIP001    			        mpIconView->Hide();
//STRIP001                     mpListView->Hide();
//STRIP001 
//STRIP001                     if( mpCurTheme )
//STRIP001     			        mpCurTheme->GetGraphic( nPos, aGraphic );
//STRIP001 				    
//STRIP001                     mpPreview->SetGraphic( aGraphic );
//STRIP001  					mpPreview->Show();
//STRIP001 
//STRIP001 			        if( mpCurTheme && mpCurTheme->GetObjectKind( nPos ) == SGA_OBJ_SOUND )
//STRIP001 				        mpPreview->PreviewSound( mpCurTheme->GetObjectURL( nPos ) );
//STRIP001 
//STRIP001                     maViewBox.EnableItem( TBX_ID_ICON, FALSE );
//STRIP001                     maViewBox.EnableItem( TBX_ID_LIST, FALSE );
//STRIP001                 }
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 
//STRIP001         GalleryBrowser2::meInitMode = meMode = eMode;
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Window* GalleryBrowser2::GetViewWindow() const
//STRIP001 {
//STRIP001     Window* pRet;
//STRIP001 
//STRIP001     switch( GetMode() )
//STRIP001     {
//STRIP001         case( GALLERYBROWSERMODE_LIST ): pRet = mpListView; break;
//STRIP001         case( GALLERYBROWSERMODE_PREVIEW ): pRet = mpPreview; break;
//STRIP001 
//STRIP001         default:
//STRIP001             pRet = mpIconView;
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001     return pRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::Travel( GalleryBrowserTravel eTravel )
//STRIP001 {
//STRIP001     if( mpCurTheme )
//STRIP001     {
//STRIP001 		Point		aSelPos;
//STRIP001         const ULONG nItemId = ImplGetSelectedItemId( NULL, aSelPos );
//STRIP001 
//STRIP001         if( nItemId )
//STRIP001         {
//STRIP001             ULONG nNewItemId = nItemId;
//STRIP001 
//STRIP001             switch( eTravel )
//STRIP001             {
//STRIP001                 case( GALLERYBROWSERTRAVEL_FIRST ):     nNewItemId = 1; break;
//STRIP001                 case( GALLERYBROWSERTRAVEL_LAST ):      nNewItemId = mpCurTheme->GetObjectCount(); break;
//STRIP001                 case( GALLERYBROWSERTRAVEL_PREVIOUS ):  nNewItemId--; break;
//STRIP001                 case( GALLERYBROWSERTRAVEL_NEXT ):      nNewItemId++; break;
//STRIP001             }
//STRIP001 
//STRIP001             if( nNewItemId < 1 )
//STRIP001                 nNewItemId = 1;
//STRIP001             else if( nNewItemId > mpCurTheme->GetObjectCount() )
//STRIP001                 nNewItemId = mpCurTheme->GetObjectCount();
//STRIP001 
//STRIP001             if( nNewItemId != nItemId )
//STRIP001             {
//STRIP001                 ImplSelectItemId( nNewItemId );
//STRIP001             	ImplUpdateInfoBar();
//STRIP001 
//STRIP001                 if( GALLERYBROWSERMODE_PREVIEW == GetMode() )
//STRIP001                 {
//STRIP001     			    Graphic		aGraphic;
//STRIP001                     const ULONG nPos = nNewItemId - 1;
//STRIP001 
//STRIP001                     mpCurTheme->GetGraphic( nPos, aGraphic );
//STRIP001                     mpPreview->SetGraphic( aGraphic );
//STRIP001 
//STRIP001 			        if( SGA_OBJ_SOUND == mpCurTheme->GetObjectKind( nPos ) )
//STRIP001 				        mpPreview->PreviewSound( mpCurTheme->GetObjectURL( nPos ) );
//STRIP001 
//STRIP001                     mpPreview->Invalidate();
//STRIP001                 }
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::ImplUpdateViews( USHORT nSelectionId )
//STRIP001 {
//STRIP001 	mpIconView->Hide();
//STRIP001     mpListView->Hide();
//STRIP001     mpPreview->Hide(); 
//STRIP001 
//STRIP001 	mpIconView->Clear();
//STRIP001     mpListView->Clear();
//STRIP001 
//STRIP001 	if( mpCurTheme )
//STRIP001 	{
//STRIP001 		for( ULONG i = 0, nCount = mpCurTheme->GetObjectCount(); i < nCount; )
//STRIP001         {
//STRIP001             mpListView->RowInserted( i++ );
//STRIP001 			mpIconView->InsertItem( (USHORT) i );
//STRIP001         }
//STRIP001 
//STRIP001         ImplSelectItemId( ( ( nSelectionId > mpCurTheme->GetObjectCount() ) ? mpCurTheme->GetObjectCount() : nSelectionId ) );
//STRIP001 	}
//STRIP001 
//STRIP001     switch( GetMode() )
//STRIP001     {
//STRIP001         case( GALLERYBROWSERMODE_ICON ): mpIconView->Show(); break;
//STRIP001         case( GALLERYBROWSERMODE_LIST ): mpListView->Show(); break;
//STRIP001         case( GALLERYBROWSERMODE_PREVIEW ): mpPreview->Show(); break;
//STRIP001 
//STRIP001         default:
//STRIP001         break;
//STRIP001     }
//STRIP001 
//STRIP001 	ImplUpdateInfoBar();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::ImplUpdateInfoBar()
//STRIP001 {
//STRIP001 	String aInfoText;
//STRIP001 
//STRIP001 	if( mpCurTheme )
//STRIP001 	{
//STRIP001 	    Point		aSelPos;
//STRIP001 		const ULONG nItemId = ImplGetSelectedItemId( NULL, aSelPos );
//STRIP001 
//STRIP001         if( nItemId )
//STRIP001         {
//STRIP001             const ULONG nPos = nItemId - 1;
//STRIP001 
//STRIP001 		    aInfoText = mpCurTheme->GetName();
//STRIP001 
//STRIP001 		    if( nPos < mpCurTheme->GetObjectCount() )
//STRIP001 		    {
//STRIP001 			    SgaObject* pObj = mpCurTheme->AcquireObject( nPos );
//STRIP001 
//STRIP001 			    if( pObj )
//STRIP001 			    {
//STRIP001 				    aInfoText = GetItemText( *mpCurTheme, *pObj, GALLERY_ITEM_THEMENAME | GALLERY_ITEM_TITLE | GALLERY_ITEM_PATH );
//STRIP001 				    mpCurTheme->ReleaseObject( pObj );
//STRIP001 			    }
//STRIP001 		    }
//STRIP001         }
//STRIP001 	}
//STRIP001 
//STRIP001 	maInfoBar.SetText( aInfoText );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 ULONG GalleryBrowser2::ImplGetSelectedItemId( const Point* pSelPos, Point& rSelPos )
//STRIP001 {
//STRIP001 	const Size  aOutputSizePixel( GetOutputSizePixel() );
//STRIP001     ULONG       nRet = 0;
//STRIP001     
//STRIP001     if( GALLERYBROWSERMODE_PREVIEW == GetMode() )
//STRIP001     {
//STRIP001         nRet = ( ( GALLERYBROWSERMODE_ICON == meLastMode ) ? mpIconView->GetSelectItemId() : ( mpListView->FirstSelectedRow() + 1 ) );
//STRIP001 	        
//STRIP001 	    if( pSelPos )
//STRIP001 	        rSelPos = GetPointerPosPixel();
//STRIP001 	    else
//STRIP001     	    rSelPos = Point( aOutputSizePixel.Width() >> 1, aOutputSizePixel.Height() >> 1 );
//STRIP001     }
//STRIP001     else if( GALLERYBROWSERMODE_ICON == GetMode() )
//STRIP001 	{
//STRIP001 	    if( pSelPos )
//STRIP001 	    {
//STRIP001             nRet = mpIconView->GetItemId( *pSelPos );
//STRIP001 		    rSelPos = GetPointerPosPixel();
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 	    {
//STRIP001             nRet = mpIconView->GetSelectItemId();
//STRIP001 	    	rSelPos = mpIconView->GetItemRect( (USHORT) nRet ).Center();
//STRIP001 	    }
//STRIP001 	}
//STRIP001     else
//STRIP001 	{
//STRIP001 	    if( pSelPos )
//STRIP001 	    {
//STRIP001             nRet = mpListView->GetRowAtYPosPixel( pSelPos->Y() ) + 1;
//STRIP001 	    	rSelPos = GetPointerPosPixel();
//STRIP001 	    }
//STRIP001 	    else
//STRIP001 	    {
//STRIP001             nRet = mpListView->FirstSelectedRow() + 1;
//STRIP001 	    	rSelPos = mpListView->GetFieldRectPixel( (USHORT) nRet, 1 ).Center();
//STRIP001 	    }
//STRIP001 	}
//STRIP001 
//STRIP001 	rSelPos.X() = Max( Min( rSelPos.X(), aOutputSizePixel.Width() - 1L ), 0L );
//STRIP001 	rSelPos.Y() = Max( Min( rSelPos.Y(), aOutputSizePixel.Height() - 1L ), 0L );
//STRIP001 
//STRIP001     return nRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::ImplSelectItemId( ULONG nItemId )
//STRIP001 {
//STRIP001     if( nItemId )
//STRIP001     {
//STRIP001 
//STRIP001         mpIconView->SelectItem( (USHORT) nItemId );
//STRIP001         mpListView->SelectRow( nItemId - 1 );
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 void GalleryBrowser2::ImplExecute( USHORT nId )
//STRIP001 {
//STRIP001     Point		aSelPos;
//STRIP001 	const ULONG nItemId = ImplGetSelectedItemId( NULL, aSelPos );
//STRIP001 
//STRIP001     if( mpCurTheme && nItemId )
//STRIP001     {
//STRIP001         mnCurActionPos = nItemId - 1;
//STRIP001 
//STRIP001 		switch( nId )
//STRIP001 		{
//STRIP001 			case( MN_ADD ):
//STRIP001 			case( MN_ADD_LINK ):
//STRIP001 			{
//STRIP001 				sal_uInt32 nFormat;
//STRIP001 
//STRIP001 				mbCurActionIsLinkage = ( MN_ADD_LINK == nId );
//STRIP001 		
//STRIP001 				switch( mpCurTheme->GetObjectKind( mnCurActionPos ) )
//STRIP001 				{
//STRIP001 					case( SGA_OBJ_BMP ):
//STRIP001 					case( SGA_OBJ_ANIM ):
//STRIP001 					case( SGA_OBJ_INET ):
//STRIP001 						nFormat = SGA_FORMAT_GRAPHIC | SGA_FORMAT_STRING;
//STRIP001 					break;
//STRIP001 
//STRIP001 					case ( SGA_OBJ_SOUND ) :
//STRIP001 						nFormat = SGA_FORMAT_SOUND | SGA_FORMAT_STRING;
//STRIP001 					break;
//STRIP001 
//STRIP001 					case( SGA_OBJ_SVDRAW ):
//STRIP001 						nFormat = SGA_FORMAT_GRAPHIC | SGA_FORMAT_SVDRAW | SGA_FORMAT_STRING;
//STRIP001 					break;
//STRIP001 
//STRIP001 					default :
//STRIP001 					break;
//STRIP001 				}
//STRIP001 
//STRIP001 				const SfxUInt32Item aItem( SID_GALLERY_FORMATS, nFormat );
//STRIP001 				SfxViewFrame::Current()->GetBindings().GetDispatcher()->Execute( 
//STRIP001 					SID_GALLERY_FORMATS, SFX_CALLMODE_ASYNCHRON | SFX_CALLMODE_RECORD, &aItem, 0L );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_PREVIEW ):
//STRIP001                 SetMode( ( GALLERYBROWSERMODE_PREVIEW != GetMode() ) ? GALLERYBROWSERMODE_PREVIEW : meLastMode );
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_DELETE ):
//STRIP001 			{
//STRIP001 				if( !mpCurTheme->IsReadOnly() &&
//STRIP001 					QueryBox( NULL, WB_YES_NO, String( GAL_RESID( RID_SVXSTR_GALLERY_DELETEOBJ ) ) ).Execute() == RET_YES )
//STRIP001 				{
//STRIP001 					mpCurTheme->RemoveObject( mnCurActionPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_TITLE ):
//STRIP001 			{
//STRIP001 				SgaObject* pObj = mpCurTheme->AcquireObject( mnCurActionPos );
//STRIP001 
//STRIP001 				if( pObj )
//STRIP001 				{
//STRIP001                     const String    aOldTitle( GetItemText( *mpCurTheme, *pObj, GALLERY_ITEM_TITLE ) );
//STRIP001 					TitleDialog	    aDlg( this, aOldTitle );
//STRIP001 
//STRIP001 					if( aDlg.Execute() == RET_OK )
//STRIP001 					{
//STRIP001 						String aNewTitle( aDlg.GetTitle() );
//STRIP001 
//STRIP001 						if( ( !aNewTitle.Len() && pObj->GetTitle().Len() ) || ( aNewTitle != aOldTitle ) )
//STRIP001 						{
//STRIP001                             if( !aNewTitle.Len() )
//STRIP001                                 aNewTitle = String( RTL_CONSTASCII_USTRINGPARAM( "__<empty>__" ) );
//STRIP001 
//STRIP001 							pObj->SetTitle( aNewTitle );
//STRIP001 							mpCurTheme->InsertObject( *pObj );
//STRIP001 						}
//STRIP001 					}
//STRIP001 
//STRIP001 					mpCurTheme->ReleaseObject( pObj );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_COPYCLIPBOARD ):
//STRIP001 			{
//STRIP001                 Window* pWindow;
//STRIP001 
//STRIP001                 switch( GetMode() )
//STRIP001                 {
//STRIP001                     case( GALLERYBROWSERMODE_ICON ): pWindow = (Window*) mpIconView; break;
//STRIP001                     case( GALLERYBROWSERMODE_LIST ): pWindow = (Window*) mpListView; break;
//STRIP001                     case( GALLERYBROWSERMODE_PREVIEW ): pWindow = (Window*) mpPreview; break;
//STRIP001 
//STRIP001                     default:
//STRIP001                         pWindow = NULL;
//STRIP001                     break;
//STRIP001                 }
//STRIP001 
//STRIP001 				mpCurTheme->CopyToClipboard( pWindow, mnCurActionPos );
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			case( MN_PASTECLIPBOARD ):
//STRIP001 			{
//STRIP001 				if( !mpCurTheme->IsReadOnly() )
//STRIP001 				{
//STRIP001 					TransferableDataHelper aDataHelper( TransferableDataHelper::CreateFromSystemClipboard( this ) );
//STRIP001 					mpCurTheme->InsertTransferable( aDataHelper.GetTransferable(), mnCurActionPos );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			break;
//STRIP001 
//STRIP001 			default:
//STRIP001 			break;
//STRIP001 		}
//STRIP001     }
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 String GalleryBrowser2::GetItemText( const GalleryTheme& rTheme, const SgaObject& rObj, ULONG nItemTextFlags )
//STRIP001 {
//STRIP001 	INetURLObject   aURL;
//STRIP001     String          aRet;
//STRIP001 
//STRIP001     if( rTheme.IsImported() )
//STRIP001 	{
//STRIP001 		aURL = rTheme.GetParent()->GetImportURL( rTheme.GetName() );
//STRIP001 
//STRIP001 		aURL.removeSegment();
//STRIP001 		aURL.Append( rObj.GetURL().GetName() );
//STRIP001 	}
//STRIP001     else
//STRIP001         aURL = rObj.GetURL();
//STRIP001 
//STRIP001     if( nItemTextFlags & GALLERY_ITEM_THEMENAME )
//STRIP001     {
//STRIP001         aRet += rTheme.GetName();
//STRIP001         aRet += String( RTL_CONSTASCII_USTRINGPARAM( " - " ) );
//STRIP001     }
//STRIP001 
//STRIP001     if( nItemTextFlags & GALLERY_ITEM_TITLE )
//STRIP001     {
//STRIP001 		String aTitle( rObj.GetTitle() );
//STRIP001 
//STRIP001         if( !aTitle.Len() )
//STRIP001             aTitle = aURL.getBase( INetURLObject::LAST_SEGMENT, true, INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001 
//STRIP001         if( !aTitle.Len() )
//STRIP001         {
//STRIP001             aTitle = aURL.GetMainURL( INetURLObject::DECODE_UNAMBIGUOUS );
//STRIP001             aTitle = aTitle.GetToken( aTitle.GetTokenCount( '/' ) - 1, '/' );
//STRIP001         }
//STRIP001 
//STRIP001         aRet += aTitle;
//STRIP001     }
//STRIP001 
//STRIP001     if( nItemTextFlags & GALLERY_ITEM_PATH )
//STRIP001     {
//STRIP001         const String aPath( aURL.getFSysPath( INetURLObject::FSYS_DETECT ) );
//STRIP001 
//STRIP001         if( aPath.Len() && ( nItemTextFlags & GALLERY_ITEM_TITLE ) )
//STRIP001             aRet += String( RTL_CONSTASCII_USTRINGPARAM( " (" ) );
//STRIP001 
//STRIP001         aRet += aURL.getFSysPath( INetURLObject::FSYS_DETECT );
//STRIP001 
//STRIP001         if( aPath.Len() && ( nItemTextFlags & GALLERY_ITEM_TITLE ) )
//STRIP001             aRet += ')';
//STRIP001     }
//STRIP001     
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 INetURLObject GalleryBrowser2::GetURL() const
//STRIP001 {
//STRIP001 	INetURLObject aURL;
//STRIP001 
//STRIP001 	if( mpCurTheme && mnCurActionPos != 0xffffffff )
//STRIP001 		aURL = mpCurTheme->GetObjectURL( mnCurActionPos );
//STRIP001 
//STRIP001 	return aURL;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 String GalleryBrowser2::GetFilterName() const
//STRIP001 {
//STRIP001 	String aFilterName;
//STRIP001 
//STRIP001 	if( mpCurTheme && mnCurActionPos != 0xffffffff )
//STRIP001 	{
//STRIP001 		const SgaObjKind eObjKind = mpCurTheme->GetObjectKind( mnCurActionPos );
//STRIP001 
//STRIP001 		if( ( SGA_OBJ_BMP == eObjKind ) || ( SGA_OBJ_ANIM == eObjKind ) )
//STRIP001 		{
//STRIP001 			GraphicFilter*		pFilter = GetGrfFilter();
//STRIP001 			INetURLObject		aURL; mpCurTheme->GetURL( mnCurActionPos, aURL );
//STRIP001 			sal_uInt16			nFilter = pFilter->GetImportFormatNumberForShortName( aURL.GetExtension() );
//STRIP001 			
//STRIP001 			if( GRFILTER_FORMAT_DONTKNOW != nFilter )
//STRIP001 				aFilterName = pFilter->GetImportFormatName( nFilter );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return aFilterName;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 Graphic GalleryBrowser2::GetGraphic() const
//STRIP001 {
//STRIP001 	Graphic aGraphic;
//STRIP001 
//STRIP001 	if( mpCurTheme && mnCurActionPos != 0xffffffff )
//STRIP001 		mpCurTheme->GetGraphic(	mnCurActionPos, aGraphic );
//STRIP001 
//STRIP001 	return aGraphic;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryBrowser2::GetVCDrawModel( FmFormModel& rModel ) const
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	if( mpCurTheme && mnCurActionPos != 0xffffffff )
//STRIP001 		bRet = mpCurTheme->GetModel( mnCurActionPos, rModel );
//STRIP001 
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 BOOL GalleryBrowser2::IsLinkage() const
//STRIP001 {
//STRIP001 	return mbCurActionIsLinkage;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser2, MenuSelectHdl, Menu*, pMenu )
//STRIP001 {
//STRIP001 	if( pMenu )
//STRIP001         ImplExecute( pMenu->GetCurItemId() );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser2, SelectObjectHdl, void*, p )
//STRIP001 {
//STRIP001 	ImplUpdateInfoBar();
//STRIP001 	return 0L;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------------
//STRIP001 
//STRIP001 IMPL_LINK( GalleryBrowser2, SelectTbxHdl, ToolBox*, pBox )
//STRIP001 {
//STRIP001     if( pBox->GetCurItemId() == TBX_ID_ICON )
//STRIP001         SetMode( GALLERYBROWSERMODE_ICON );
//STRIP001     else if( pBox->GetCurItemId() == TBX_ID_LIST )
//STRIP001         SetMode( GALLERYBROWSERMODE_LIST );
//STRIP001         
//STRIP001 	return 0L;
//STRIP001 }
}
