/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_numfmtsh.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:17:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// include ---------------------------------------------------------------

// auto strip #ifndef _COLOR_HXX
// auto strip #include <tools/color.hxx>
// auto strip #endif
#pragma hdrstop

#define _SVX_NUMFMTSH_CXX
#define _SVSTDARR_STRINGSDTOR

// auto strip #ifndef _TOOLS_DEBUG_HXX //autogen
// auto strip #include <tools/debug.hxx>
// auto strip #endif

#define _ZFORLIST_DECLARE_TABLE
// auto strip #ifndef _ZFORLIST_HXX //autogen
// auto strip #include <svtools/zforlist.hxx>
// auto strip #endif

// auto strip #ifndef _ZFORMAT_HXX //autogen
// auto strip #include <svtools/zformat.hxx>
// auto strip #endif

// auto strip #ifndef _SVX_LANGTAB_HXX //autogen
// auto strip #include <langtab.hxx>
// auto strip #endif

// auto strip #ifndef _SV_SVAPP_HXX
// auto strip #include <vcl/svapp.hxx>
// auto strip #endif

// auto strip #include "numfmtsh.hxx"
namespace binfilter {
// class SvxNumberFormatShell --------------------------------------------

//STRIP001 const double SvxNumberFormatShell::DEFAULT_NUMVALUE = 1234.56789;
//STRIP001 
//STRIP001 SV_IMPL_PTRARR( NfShCurrencyEntries, NfCurrencyEntry* );
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 SvxNumberFormatShell* SvxNumberFormatShell::Create( SvNumberFormatter* pNumFormatter,
//STRIP001 											  sal_uInt32              nFormatKey,
//STRIP001 											  SvxNumberValueType eNumValType,
//STRIP001 											  const String&		 rNumStr )
//STRIP001 {
//STRIP001 	return new SvxNumberFormatShell(pNumFormatter,nFormatKey,
//STRIP001 									eNumValType,rNumStr );
//STRIP001 }
//STRIP001 
//STRIP001 SvxNumberFormatShell* SvxNumberFormatShell::Create( SvNumberFormatter* pNumFormatter,
//STRIP001 											  sal_uInt32				 nFormatKey,
//STRIP001 											  SvxNumberValueType eNumValType,
//STRIP001 											  double			 nNumVal,
//STRIP001 											  const String*		 pNumStr )
//STRIP001 {
//STRIP001 	return new SvxNumberFormatShell(pNumFormatter,nFormatKey,
//STRIP001 									eNumValType,nNumVal,pNumStr );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 #define _INIT \
//STRIP001 	pFormatter		( pNumFormatter ), 	\
//STRIP001 	pCurFmtTable	( NULL ), 			\
//STRIP001 	nCurFormatKey	( nFormatKey ), 	\
//STRIP001 	nInitFormatKey	( nFormatKey ), 	\
//STRIP001 	eValType		( eNumValType ), 	\
//STRIP001 	pCurCurrencyEntry(NULL),			\
//STRIP001 	bBankingSymbol	(sal_False),			\
//STRIP001 	nCurCurrencyEntryPos((sal_uInt16) SELPOS_NONE), \
//STRIP001 	bUndoAddList	( sal_True )
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxNumberFormatShell::SvxNumberFormatShell(	SvNumberFormatter*	pNumFormatter,
//STRIP001 											sal_uInt32				nFormatKey,
//STRIP001 											SvxNumberValueType	eNumValType,
//STRIP001 											const String&		rNumStr )
//STRIP001 	:	_INIT
//STRIP001 {
//STRIP001 	nValNum = DEFAULT_NUMVALUE;
//STRIP001 
//STRIP001 	switch ( eValType )
//STRIP001 	{
//STRIP001 		case SVX_VALUE_TYPE_STRING:
//STRIP001 			aValStr = rNumStr;
//STRIP001 			break;
//STRIP001 		case SVX_VALUE_TYPE_NUMBER:
//STRIP001 		case SVX_VALUE_TYPE_UNDEFINED:
//STRIP001 		default:
//STRIP001 			aValStr.Erase();
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxNumberFormatShell::SvxNumberFormatShell( SvNumberFormatter*	pNumFormatter,
//STRIP001 											sal_uInt32				nFormatKey,
//STRIP001 											SvxNumberValueType	eNumValType,
//STRIP001 											double				nNumVal,
//STRIP001 											const String*		pNumStr )
//STRIP001 	:	_INIT
//STRIP001 {
//STRIP001 	//	#50441# When used in Writer, the SvxNumberInfoItem contains the
//STRIP001 	//	original string in addition to the value
//STRIP001 
//STRIP001 	if ( pNumStr )
//STRIP001 		aValStr = *pNumStr;
//STRIP001 
//STRIP001 	switch ( eValType )
//STRIP001 	{
//STRIP001 		case SVX_VALUE_TYPE_NUMBER:
//STRIP001 			nValNum = nNumVal;
//STRIP001 			break;
//STRIP001 		case SVX_VALUE_TYPE_STRING:
//STRIP001 		case SVX_VALUE_TYPE_UNDEFINED:
//STRIP001 		default:
//STRIP001 			nValNum = DEFAULT_NUMVALUE;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 SvxNumberFormatShell::~SvxNumberFormatShell()
//STRIP001 {
//STRIP001 	/*
//STRIP001 	 * An dieser Stelle wird abhaengig davon, ob die
//STRIP001 	 * hinzugefuegten, benutzerdefinierten als gueltig
//STRIP001 	 * erklaert wurden (ValidateNewEntries()), die
//STRIP001 	 * Add-Liste wieder aus dem Zahlenformatierer entfernt.
//STRIP001 	 *
//STRIP001 	 * Loeschen von Formaten aus dem Formatierer passiert
//STRIP001 	 * aus Undo-Gruenden nur in der aufrufenden Instanz.
//STRIP001 	 */
//STRIP001 
//STRIP001 	if ( bUndoAddList )
//STRIP001 	{
//STRIP001 		// Hinzugefuegte Formate sind nicht gueltig:
//STRIP001 		// => wieder entfernen:
//STRIP001 
//STRIP001 		for ( sal_uInt16 i = 0; i < aAddList.Count(); ++i )
//STRIP001 			pFormatter->DeleteEntry( aAddList[i] );
//STRIP001 	}
//STRIP001 
//STRIP001 	//--------------------------------
//STRIP001 	// Add-/Remove-Listen leerraeumen:
//STRIP001 	//--------------------------------
//STRIP001 	aAddList.Remove( 0, aAddList.Count() );
//STRIP001 	aDelList.Remove( 0, aAddList.Count() );
//STRIP001 
//STRIP001 	if(aCurrencyFormatList.Count()>0)
//STRIP001 		aCurrencyFormatList.DeleteAndDestroy(0,aCurrencyFormatList.Count());
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_uInt32 SvxNumberFormatShell::GetUpdateDataCount() const
//STRIP001 {
//STRIP001 	return aDelList.Count();
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetUpdateData( sal_uInt32* pDelArray, const sal_uInt32 nSize )
//STRIP001 {
//STRIP001 	const sal_uInt32 nCount = aDelList.Count();
//STRIP001 
//STRIP001 	DBG_ASSERT( pDelArray && ( nSize == nCount ), "Array nicht initialisiert!" );
//STRIP001 
//STRIP001 	if ( pDelArray && ( nSize == nCount ) )
//STRIP001 		for ( sal_uInt16 i = 0; i < aDelList.Count(); ++i )
//STRIP001 			*pDelArray++ = aDelList[i];
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::CategoryChanged( sal_uInt16     nCatLbPos,
//STRIP001 											short&     rFmtSelPos,
//STRIP001 											SvStrings& rFmtEntries )
//STRIP001 {
//STRIP001 	short nOldCategory = nCurCategory;
//STRIP001 	PosToCategory_Impl( nCatLbPos, nCurCategory );
//STRIP001 	pCurFmtTable = &( pFormatter->GetEntryTable( nCurCategory,
//STRIP001 												 nCurFormatKey,
//STRIP001 												 eCurLanguage ) );
//STRIP001 	// reinitialize currency if category newly entered
//STRIP001 	if ( nCurCategory == NUMBERFORMAT_CURRENCY && nOldCategory != nCurCategory )
//STRIP001 		pCurCurrencyEntry = NULL;
//STRIP001 	rFmtSelPos = FillEntryList_Impl( rFmtEntries );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::LanguageChanged( LanguageType eLangType,
//STRIP001 											short&		 rFmtSelPos,
//STRIP001 											SvStrings&   rFmtEntries )
//STRIP001 {
//STRIP001 	eCurLanguage = eLangType;
//STRIP001 	pCurFmtTable = &(pFormatter->ChangeCL( nCurCategory,
//STRIP001 										   nCurFormatKey,
//STRIP001 										   eCurLanguage ) );
//STRIP001 	rFmtSelPos = FillEntryList_Impl( rFmtEntries );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::FormatChanged( sal_uInt16  nFmtLbPos,
//STRIP001 										  String& rPreviewStr,
//STRIP001                                           Color*& rpFontColor )
//STRIP001 {
//STRIP001 	//nCurFormatKey = pCurFmtTable->GetKey( pCurFmtTable->GetObject( nFmtLbPos ) );
//STRIP001 
//STRIP001 	if(nFmtLbPos<aCurEntryList.Count())
//STRIP001 	{
//STRIP001 		nCurFormatKey=aCurEntryList[nFmtLbPos];
//STRIP001 
//STRIP001 		if(nCurFormatKey!=NUMBERFORMAT_ENTRY_NOT_FOUND)
//STRIP001 		{
//STRIP001             GetPreviewString_Impl( rPreviewStr, rpFontColor );
//STRIP001 		}
//STRIP001 		else if(nCurCategory==NUMBERFORMAT_CURRENCY)
//STRIP001 		{
//STRIP001 			if(nFmtLbPos<aCurrencyFormatList.Count())
//STRIP001 			{
//STRIP001 				//nCurFormatKey=nFmtLbPos;
//STRIP001 				MakePrevStringFromVal(*aCurrencyFormatList[nFmtLbPos],
//STRIP001                                     rPreviewStr,rpFontColor,nValNum);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::AddFormat( String& rFormat,  sal_uInt32& rErrPos,
//STRIP001 									  sal_uInt16& rCatLbSelPos, short& rFmtSelPos,
//STRIP001 									  SvStrings& rFmtEntries )
//STRIP001 {
//STRIP001 	sal_Bool 	bInserted	= sal_False;
//STRIP001 	sal_uInt32	nAddKey		= pFormatter->GetEntryKey( rFormat, eCurLanguage );
//STRIP001 
//STRIP001 	if ( nAddKey != NUMBERFORMAT_ENTRY_NOT_FOUND ) // bereits vorhanden?
//STRIP001 	{
//STRIP001 		if ( IsRemoved_Impl( nAddKey ) )
//STRIP001 		{
//STRIP001 			// Key suchen und loeschen
//STRIP001 			sal_Bool	bFound	= sal_False;
//STRIP001 			sal_uInt16	nAt		= 0;
//STRIP001 
//STRIP001 			for ( sal_uInt16 i = 0; !bFound && i < aDelList.Count(); ++i )
//STRIP001 			{
//STRIP001 				if ( aDelList[i] == nAddKey )
//STRIP001 				{
//STRIP001 					bFound	= sal_True;
//STRIP001 					nAt		= i;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			DBG_ASSERT( bFound, "Key not found" );
//STRIP001 			aDelList.Remove( nAt );
//STRIP001 			bInserted = sal_True;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			DBG_ERROR( "Doppeltes Format!" );
//STRIP001 	}
//STRIP001 	else // neues Format
//STRIP001 	{
//STRIP001 		xub_StrLen nErrPos = (xub_StrLen)rErrPos;
//STRIP001 		bInserted = pFormatter->PutEntry( rFormat, nErrPos,
//STRIP001 										  nCurCategory, nAddKey,
//STRIP001 										  eCurLanguage );
//STRIP001 		rErrPos = sal_uInt32(nErrPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( bInserted ) // eingefuegt
//STRIP001 	{
//STRIP001 		nCurFormatKey = nAddKey;
//STRIP001 		DBG_ASSERT( !IsAdded_Impl( nCurFormatKey ), "Doppeltes Format!" );
//STRIP001 		aAddList.Insert( nCurFormatKey, aAddList.Count() );
//STRIP001 
//STRIP001 		// aktuelle Tabelle holen
//STRIP001 		pCurFmtTable = &(pFormatter->GetEntryTable( nCurCategory,
//STRIP001 													nCurFormatKey,
//STRIP001 													eCurLanguage ));
//STRIP001 		nCurCategory=pFormatter->GetType(nAddKey); //@@ ???
//STRIP001 		CategoryToPos_Impl( nCurCategory, rCatLbSelPos );
//STRIP001 		rFmtSelPos = FillEntryList_Impl( rFmtEntries );
//STRIP001 	}
//STRIP001 	else if ( rErrPos != 0 ) // Syntaxfehler
//STRIP001 		;
//STRIP001 	else // Doppelt einfuegen nicht moeglich
//STRIP001 		DBG_ERROR( "Doppeltes Format!" ); // oder doch?
//STRIP001 
//STRIP001 	return bInserted;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::RemoveFormat( const String& 	rFormat,
//STRIP001 										 sal_uInt16&		rCatLbSelPos,
//STRIP001 										 short&			rFmtSelPos,
//STRIP001 										 SvStrings& 	rFmtEntries )
//STRIP001 {
//STRIP001 	sal_uInt32 nDelKey = pFormatter->GetEntryKey( rFormat, eCurLanguage );
//STRIP001 
//STRIP001 	DBG_ASSERT( nDelKey != NUMBERFORMAT_ENTRY_NOT_FOUND, "Eintrag nicht gefunden!" );
//STRIP001 	DBG_ASSERT( !IsRemoved_Impl( nDelKey ), "Eintrag bereits geloescht!" );
//STRIP001 
//STRIP001 	if ( (nDelKey != NUMBERFORMAT_ENTRY_NOT_FOUND) && !IsRemoved_Impl( nDelKey ) )
//STRIP001 	{
//STRIP001 		aDelList.Insert( nDelKey, aDelList.Count() );
//STRIP001 
//STRIP001 		if ( IsAdded_Impl( nDelKey ) )
//STRIP001 		{
//STRIP001 			// Key suchen und loeschen
//STRIP001 			sal_Bool	bFound	= sal_False;
//STRIP001 			sal_uInt16	nAt		= 0;
//STRIP001 
//STRIP001 			for ( sal_uInt16 i = 0; !bFound && i < aAddList.Count(); ++i )
//STRIP001 			{
//STRIP001 				if ( aAddList[i] == nDelKey )
//STRIP001 				{
//STRIP001 					bFound	= sal_True;
//STRIP001 					nAt		= i;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			DBG_ASSERT( bFound, "Key not found" );
//STRIP001 			aAddList.Remove( nAt );
//STRIP001 		}
//STRIP001 
//STRIP001 		nCurCategory=pFormatter->GetType(nDelKey); //@@ 01.10.97
//STRIP001 		pCurFmtTable = &(pFormatter->GetEntryTable( nCurCategory,
//STRIP001 													nCurFormatKey,
//STRIP001 													eCurLanguage ));
//STRIP001 
//STRIP001 		nCurFormatKey=pFormatter->GetStandardFormat(nCurCategory,
//STRIP001 											eCurLanguage );
//STRIP001 
//STRIP001 		CategoryToPos_Impl( nCurCategory, rCatLbSelPos );
//STRIP001 		rFmtSelPos = FillEntryList_Impl( rFmtEntries );
//STRIP001 		//rFmtSelPos = (short) nCurFormatKey; //@@ 01.10.97
//STRIP001 	}
//STRIP001 	return sal_True;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::MakeFormat( String& rFormat,
//STRIP001 									   sal_Bool bThousand, sal_Bool bNegRed,
//STRIP001 									   sal_uInt16 nPrecision, sal_uInt16 nLeadingZeroes,
//STRIP001 									   sal_uInt16 nCurrencyPos)
//STRIP001 {
//STRIP001 	if(aCurrencyFormatList.Count()>nCurrencyPos)
//STRIP001 	{
//STRIP001 		 sal_uInt32 rErrPos=0;
//STRIP001 		sal_uInt16 rCatLbSelPos=0;
//STRIP001 		short  rFmtSelPos=0;
//STRIP001 		SvStrings aFmtEList;
//STRIP001 
//STRIP001 		sal_uInt32 nFound = pFormatter->TestNewString( *aCurrencyFormatList[nCurrencyPos], eCurLanguage );
//STRIP001 
//STRIP001 		if ( nFound == NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 		{
//STRIP001 			AddFormat( *aCurrencyFormatList[nCurrencyPos],rErrPos,rCatLbSelPos,
//STRIP001 					rFmtSelPos,aFmtEList);
//STRIP001 		}
//STRIP001 
//STRIP001 		if(rErrPos==0)
//STRIP001 		{
//STRIP001 			pFormatter->GenerateFormat( rFormat, nCurFormatKey,
//STRIP001 										eCurLanguage,
//STRIP001 										bThousand, bNegRed,
//STRIP001 										nPrecision, nLeadingZeroes );
//STRIP001 		}
//STRIP001 		aFmtEList.DeleteAndDestroy(0,aFmtEList.Count());
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pFormatter->GenerateFormat( rFormat, nCurFormatKey,
//STRIP001 									eCurLanguage,
//STRIP001 									bThousand, bNegRed,
//STRIP001 									nPrecision, nLeadingZeroes );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetOptions( const String&	rFormat,
//STRIP001 									   sal_Bool&			rThousand,
//STRIP001 									   sal_Bool&			rNegRed,
//STRIP001 									   sal_uInt16&			rPrecision,
//STRIP001 									   sal_uInt16&			rLeadingZeroes,
//STRIP001 									   sal_uInt16&			rCatLbPos )
//STRIP001 {
//STRIP001 
//STRIP001 	sal_uInt32 nFmtKey = pFormatter->GetEntryKey( rFormat, eCurLanguage );
//STRIP001 
//STRIP001 	if(nFmtKey != NUMBERFORMAT_ENTRY_NOT_FOUND)
//STRIP001 	{
//STRIP001 		if ( nFmtKey != NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 		{
//STRIP001 			pFormatter->GetFormatSpecialInfo( nFmtKey,
//STRIP001 											  rThousand, rNegRed,
//STRIP001 											  rPrecision, rLeadingZeroes );
//STRIP001 
//STRIP001 			CategoryToPos_Impl( pFormatter->GetType( nFmtKey ), rCatLbPos );
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rCatLbPos = CAT_USERDEFINED;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		sal_Bool bTestBanking=sal_False;
//STRIP001 		sal_uInt16 nPos=FindCurrencyTableEntry(rFormat, bTestBanking );
//STRIP001 
//STRIP001 		if(IsInTable(nPos,bTestBanking,rFormat) &&
//STRIP001 			pFormatter->GetFormatSpecialInfo( rFormat,rThousand, rNegRed,
//STRIP001 								  rPrecision, rLeadingZeroes,eCurLanguage)==0)
//STRIP001 		{
//STRIP001 			rCatLbPos = CAT_CURRENCY;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rCatLbPos = CAT_USERDEFINED;
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::MakePreviewString( const String& rFormatStr,
//STRIP001 											  String&       rPreviewStr,
//STRIP001                                               Color*&       rpFontColor )
//STRIP001 {
//STRIP001     rpFontColor = NULL;
//STRIP001 
//STRIP001 	ULONG nExistingFormat = pFormatter->GetEntryKey( rFormatStr, eCurLanguage );
//STRIP001 	if ( nExistingFormat == NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 	{
//STRIP001 		//	real preview - not implemented in NumberFormatter for text formats
//STRIP001 
//STRIP001 		pFormatter->GetPreviewString( rFormatStr, nValNum, rPreviewStr,
//STRIP001                                       &rpFontColor, eCurLanguage );
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//	format exists
//STRIP001 
//STRIP001 		//	#50441# if a string was set in addition to the value, use it for text formats
//STRIP001 		BOOL bUseText = ( eValType == SVX_VALUE_TYPE_STRING ||
//STRIP001 							( aValStr.Len() && ( pFormatter->GetType(nExistingFormat) & NUMBERFORMAT_TEXT ) ) );
//STRIP001 		if ( bUseText )
//STRIP001 			pFormatter->GetOutputString( aValStr, nExistingFormat,
//STRIP001                                          rPreviewStr, &rpFontColor );
//STRIP001 		else
//STRIP001 			pFormatter->GetOutputString( nValNum, nExistingFormat,
//STRIP001                                          rPreviewStr, &rpFontColor );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::IsUserDefined( const String& rFmtString )
//STRIP001 {
//STRIP001 	sal_uInt32 nFound = pFormatter->GetEntryKey( rFmtString, eCurLanguage );
//STRIP001 
//STRIP001 	sal_Bool bFlag=sal_False;
//STRIP001 	if ( nFound != NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 	{
//STRIP001 		bFlag=pFormatter->IsUserDefined( rFmtString, eCurLanguage );
//STRIP001 
//STRIP001 		if(bFlag)
//STRIP001 		{
//STRIP001 			const SvNumberformat* pNumEntry	= pFormatter->GetEntry(nFound);
//STRIP001 
//STRIP001 			if(pNumEntry!=NULL && pNumEntry->HasNewCurrency())
//STRIP001 			{
//STRIP001 				sal_Bool bTestBanking;
//STRIP001 				sal_uInt16 nPos=FindCurrencyTableEntry(rFmtString,bTestBanking);
//STRIP001 				bFlag=!IsInTable(nPos,bTestBanking,rFmtString);
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bFlag;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::FindEntry( const String& rFmtString, sal_uInt32* pAt /* = NULL */ )
//STRIP001 {
//STRIP001 	sal_Bool bRes=sal_False;
//STRIP001 	sal_uInt32 nFound = pFormatter->TestNewString( rFmtString, eCurLanguage );
//STRIP001 
//STRIP001 	if ( nFound == NUMBERFORMAT_ENTRY_NOT_FOUND )
//STRIP001 	{
//STRIP001 		sal_Bool bTestBanking=sal_False;
//STRIP001 		sal_uInt16 nPos=FindCurrencyTableEntry(rFmtString, bTestBanking );
//STRIP001 
//STRIP001 		if(IsInTable(nPos,bTestBanking,rFmtString))
//STRIP001 		{
//STRIP001 			nFound=NUMBERFORMAT_ENTRY_NEW_CURRENCY;
//STRIP001 			bRes=sal_True;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		bRes=!IsRemoved_Impl( nFound );
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( pAt )
//STRIP001 		*pAt = nFound;
//STRIP001 
//STRIP001 	return bRes;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetInitSettings(
//STRIP001         sal_uInt16&     nCatLbPos,
//STRIP001         LanguageType&   rLangType,
//STRIP001         sal_uInt16&     nFmtLbSelPos,
//STRIP001         SvStrings&      rFmtEntries,
//STRIP001         String&         rPrevString,
//STRIP001         Color*&         rpPrevColor )
//STRIP001 {
//STRIP001 	// -------------------------------------------------------------------
//STRIP001 	// Vorbedingung: Zahlenformatierer gefunden
//STRIP001 	DBG_ASSERT( pFormatter != NULL, "Zahlenformatierer nicht gefunden!" );
//STRIP001 
//STRIP001 	sal_uInt16					nCount		= 0;
//STRIP001 	short					nSelPos		= SELPOS_NONE;
//STRIP001 	SvNumberFormatTable*	pFmtTable	= NULL;
//STRIP001 
//STRIP001 	// Sonderbehandlung fuer undefiniertes Zahlenformat:
//STRIP001 	if ( (eValType == SVX_VALUE_TYPE_UNDEFINED) && (nCurFormatKey == 0) )
//STRIP001 		PosToCategory_Impl( CAT_ALL, nCurCategory );		// Kategorie = Alle
//STRIP001 	else
//STRIP001 		nCurCategory = NUMBERFORMAT_UNDEFINED;		// Kategorie = Undefiniert
//STRIP001 
//STRIP001 	pCurFmtTable =	&(pFormatter->GetFirstEntryTable( nCurCategory,
//STRIP001 													  nCurFormatKey,
//STRIP001 													  eCurLanguage ));
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 	CategoryToPos_Impl( nCurCategory, nCatLbPos );
//STRIP001 	rLangType = eCurLanguage;
//STRIP001 
//STRIP001 	nSelPos = FillEntryList_Impl( rFmtEntries );
//STRIP001 
//STRIP001 	DBG_ASSERT( nSelPos != SELPOS_NONE, "Leere Formatliste!" );
//STRIP001 
//STRIP001 	nFmtLbSelPos = (nSelPos != SELPOS_NONE) ? (sal_uInt16)nSelPos : 0;
//STRIP001     GetPreviewString_Impl( rPrevString, rpPrevColor );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEntryList_Impl( SvStrings& rList )
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	short nSelPos=0;
//STRIP001 	aCurEntryList.Remove(nSelPos,aCurEntryList.Count());
//STRIP001 	sal_uInt16			nPrivCat;
//STRIP001 	nSelPos=SELPOS_NONE;
//STRIP001 
//STRIP001 	if(nCurCategory==NUMBERFORMAT_ALL)
//STRIP001 	{
//STRIP001 		FillEListWithStd_Impl(rList,CAT_NUMBER,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_PERCENT,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_CURRENCY,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_DATE,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_TIME,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_SCIENTIFIC,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_FRACTION,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_BOOLEAN,nSelPos);
//STRIP001 		FillEListWithStd_Impl(rList,CAT_TEXT,nSelPos);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		CategoryToPos_Impl(nCurCategory, nPrivCat);
//STRIP001 		FillEListWithStd_Impl(rList,nPrivCat,nSelPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	if(	nPrivCat!=CAT_CURRENCY)
//STRIP001 		nSelPos=FillEListWithUsD_Impl(rList,nPrivCat,nSelPos);
//STRIP001 
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatShell::FillEListWithStd_Impl( SvStrings& rList,sal_uInt16 nPrivCat,short &nSelPos )
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	if(aCurrencyFormatList.Count()>0)
//STRIP001 		aCurrencyFormatList.DeleteAndDestroy(0,aCurrencyFormatList.Count());
//STRIP001 
//STRIP001 	if(nPrivCat==CAT_CURRENCY)
//STRIP001 	{
//STRIP001 		nSelPos=FillEListWithCurrency_Impl(rList,nSelPos);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		NfIndexTableOffset eOffsetStart;
//STRIP001 		NfIndexTableOffset eOffsetEnd;
//STRIP001 
//STRIP001 		switch(nPrivCat)
//STRIP001 		{
//STRIP001 			case CAT_NUMBER			:eOffsetStart=NF_NUMBER_START;
//STRIP001 								 	eOffsetEnd=NF_NUMBER_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_PERCENT		:eOffsetStart=NF_PERCENT_START;
//STRIP001 								 	eOffsetEnd=NF_PERCENT_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_CURRENCY		:eOffsetStart=NF_CURRENCY_START;
//STRIP001 								 	eOffsetEnd=NF_CURRENCY_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_DATE			:eOffsetStart=NF_DATE_START;
//STRIP001 								 	eOffsetEnd=NF_DATE_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_TIME			:eOffsetStart=NF_TIME_START;
//STRIP001 								 	eOffsetEnd=NF_TIME_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_SCIENTIFIC		:eOffsetStart=NF_SCIENTIFIC_START;
//STRIP001 								 	eOffsetEnd=NF_SCIENTIFIC_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_FRACTION		:eOffsetStart=NF_FRACTION_START;
//STRIP001 								 	eOffsetEnd=NF_FRACTION_END;
//STRIP001 								 	break;
//STRIP001 			case CAT_BOOLEAN		:eOffsetStart=NF_BOOLEAN;
//STRIP001 								 	eOffsetEnd=NF_BOOLEAN;
//STRIP001 								 	break;
//STRIP001 			case CAT_TEXT			:eOffsetStart=NF_TEXT;
//STRIP001 								 	eOffsetEnd=NF_TEXT;
//STRIP001 								 	break;
//STRIP001 			default					:return;
//STRIP001 								 	break;
//STRIP001 		}
//STRIP001 
//STRIP001 		nSelPos=FillEListWithFormats_Impl(rList,nSelPos,eOffsetStart,eOffsetEnd);
//STRIP001 
//STRIP001 		if(nPrivCat==CAT_DATE || nPrivCat==CAT_TIME)
//STRIP001 		{
//STRIP001 			nSelPos=FillEListWithDateTime_Impl(rList,nSelPos);
//STRIP001 			//if(nSelPos!=SELPOS_NONE) nSelPos=nTmpPos;
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEListWithFormats_Impl( SvStrings& rList,short nSelPos,
//STRIP001 													   NfIndexTableOffset eOffsetStart,
//STRIP001 													   NfIndexTableOffset eOffsetEnd)
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	sal_uInt16	nMyType;
//STRIP001 
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	const SvNumberformat*	pNumEntry	= pCurFmtTable->First();
//STRIP001 	sal_uInt16 			nCount		= 0;
//STRIP001 	sal_uInt32			nNFEntry;
//STRIP001 	String			aStrComment;
//STRIP001 	String			aNewFormNInfo;
//STRIP001 	String			aPrevString;
//STRIP001 	String			a2PrevString;
//STRIP001 
//STRIP001 	short			nMyCat		= SELPOS_NONE;
//STRIP001 	short			nIq=0;
//STRIP001 
//STRIP001 	long nIndex;
//STRIP001 
//STRIP001 	for(nIndex=eOffsetStart;nIndex<=eOffsetEnd;nIndex++)
//STRIP001 	{
//STRIP001 		nNFEntry=pFormatter->GetFormatIndex((NfIndexTableOffset)nIndex,eCurLanguage);
//STRIP001 
//STRIP001 		pNumEntry	= pFormatter->GetEntry(nNFEntry);
//STRIP001 
//STRIP001 		if(pNumEntry==NULL) continue;
//STRIP001 
//STRIP001 		nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 		aStrComment=pNumEntry->GetComment();
//STRIP001 		CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 		aNewFormNInfo=	pNumEntry->GetFormatstring();
//STRIP001 
//STRIP001 		const StringPtr pStr = new String(aNewFormNInfo);
//STRIP001 
//STRIP001 		if ( nNFEntry == nCurFormatKey )
//STRIP001 		{
//STRIP001 			nSelPos = ( !IsRemoved_Impl( nNFEntry ) ) ? aCurEntryList.Count() : SELPOS_NONE;
//STRIP001 		}
//STRIP001 
//STRIP001 		rList.Insert( pStr,rList.Count());
//STRIP001 		aCurEntryList.Insert( nNFEntry, aCurEntryList.Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEListWithDateTime_Impl( SvStrings& rList,short nSelPos)
//STRIP001 {
//STRIP001 	sal_uInt16	nMyType;
//STRIP001 
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	const SvNumberformat*	pNumEntry	= pCurFmtTable->First();
//STRIP001 	sal_uInt16 			nCount		= 0;
//STRIP001 	sal_uInt32			nNFEntry;
//STRIP001 	String			aStrComment;
//STRIP001 	String			aNewFormNInfo;
//STRIP001 	String			aPrevString;
//STRIP001 	String			a2PrevString;
//STRIP001 
//STRIP001 	short			nMyCat		= SELPOS_NONE;
//STRIP001 	short			nIq=0;
//STRIP001 
//STRIP001 	long nIndex;
//STRIP001 
//STRIP001 	for(nIndex=NF_DATETIME_START;nIndex<=NF_DATETIME_END;nIndex++)
//STRIP001 	{
//STRIP001 		nNFEntry=pFormatter->GetFormatIndex((NfIndexTableOffset)nIndex,eCurLanguage);
//STRIP001 
//STRIP001 		pNumEntry	= pFormatter->GetEntry(nNFEntry);
//STRIP001 		if(pNumEntry!=NULL)
//STRIP001 		{
//STRIP001 			nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 			aStrComment=pNumEntry->GetComment();
//STRIP001 			CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 			aNewFormNInfo=	pNumEntry->GetFormatstring();
//STRIP001 
//STRIP001 			const StringPtr pStr = new String(aNewFormNInfo);
//STRIP001 
//STRIP001 			if ( nNFEntry == nCurFormatKey )
//STRIP001 			{
//STRIP001 				nSelPos = ( !IsRemoved_Impl( nNFEntry ) ) ? aCurEntryList.Count() : SELPOS_NONE;
//STRIP001 			}
//STRIP001 
//STRIP001 			rList.Insert( pStr,rList.Count());
//STRIP001 			aCurEntryList.Insert( nNFEntry, aCurEntryList.Count() );
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEListWithCurrency_Impl( SvStrings& rList,short nSelPos)
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	const NfCurrencyEntry* pTmpCurrencyEntry;
//STRIP001 	sal_Bool			 bTmpBanking;
//STRIP001 	XubString		 rSymbol;
//STRIP001 
//STRIP001 	sal_Bool bFlag=pFormatter->GetNewCurrencySymbolString(nCurFormatKey,rSymbol,
//STRIP001 				&pTmpCurrencyEntry,&bTmpBanking);
//STRIP001 
//STRIP001 	if((!bFlag && pCurCurrencyEntry==NULL)	||
//STRIP001 		(bFlag && pTmpCurrencyEntry==NULL && !rSymbol.Len())	||
//STRIP001 		nCurCategory==NUMBERFORMAT_ALL)
//STRIP001 	{
//STRIP001 		if ( nCurCategory == NUMBERFORMAT_ALL )
//STRIP001 			FillEListWithUserCurrencys(rList,nSelPos);
//STRIP001 		nSelPos=FillEListWithSysCurrencys(rList,nSelPos);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		nSelPos=FillEListWithUserCurrencys(rList,nSelPos);
//STRIP001 	}
//STRIP001 
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEListWithSysCurrencys( SvStrings& rList,short nSelPos)
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	sal_uInt16	nMyType;
//STRIP001 
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	const SvNumberformat*	pNumEntry	= pCurFmtTable->First();
//STRIP001 	sal_uInt16 			nCount		= 0;
//STRIP001 	sal_uInt32			nNFEntry;
//STRIP001 	String			aStrComment;
//STRIP001 	String			aNewFormNInfo;
//STRIP001 	String			aPrevString;
//STRIP001 	String			a2PrevString;
//STRIP001 
//STRIP001 	nCurCurrencyEntryPos=0;
//STRIP001 
//STRIP001 	short			nMyCat		= SELPOS_NONE;
//STRIP001 	short			nIq=0;
//STRIP001 
//STRIP001 	NfIndexTableOffset eOffsetStart=NF_CURRENCY_START;
//STRIP001 	NfIndexTableOffset eOffsetEnd=NF_CURRENCY_END;;
//STRIP001 	long nIndex;
//STRIP001 
//STRIP001 	for(nIndex=eOffsetStart;nIndex<=eOffsetEnd;nIndex++)
//STRIP001 	{
//STRIP001 		nNFEntry=pFormatter->GetFormatIndex((NfIndexTableOffset)nIndex,eCurLanguage);
//STRIP001 
//STRIP001 		pNumEntry	= pFormatter->GetEntry(nNFEntry);
//STRIP001 
//STRIP001 		if(pNumEntry==NULL) continue;
//STRIP001 
//STRIP001 		nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 		aStrComment=pNumEntry->GetComment();
//STRIP001 		CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 		aNewFormNInfo=	pNumEntry->GetFormatstring();
//STRIP001 
//STRIP001 		const StringPtr pStr = new String(aNewFormNInfo);
//STRIP001 
//STRIP001 		if ( nNFEntry == nCurFormatKey )
//STRIP001 		{
//STRIP001 			nSelPos = ( !IsRemoved_Impl( nNFEntry ) ) ? aCurEntryList.Count() : SELPOS_NONE;
//STRIP001 		}
//STRIP001 
//STRIP001 		rList.Insert( pStr,rList.Count());
//STRIP001 		aCurEntryList.Insert( nNFEntry, aCurEntryList.Count() );
//STRIP001 	}
//STRIP001 
//STRIP001 	if(nCurCategory!=NUMBERFORMAT_ALL)
//STRIP001 	{
//STRIP001 		pNumEntry	= pCurFmtTable->First();
//STRIP001 		nCount		= 0;
//STRIP001 		while ( pNumEntry )
//STRIP001 		{
//STRIP001 			sal_uInt32 nKey = pCurFmtTable->GetCurKey();
//STRIP001 
//STRIP001 			nCount++;
//STRIP001 
//STRIP001 			if ( !IsRemoved_Impl( nKey ))
//STRIP001 			{
//STRIP001 				sal_Bool bUserNewCurrency=sal_False;
//STRIP001 				if(pNumEntry->HasNewCurrency())
//STRIP001 				{
//STRIP001 					const NfCurrencyEntry* pTmpCurrencyEntry;
//STRIP001 					sal_Bool			bTmpBanking;
//STRIP001 					XubString		rSymbol;
//STRIP001 
//STRIP001 					pFormatter->GetNewCurrencySymbolString(nKey,rSymbol,
//STRIP001 						&pTmpCurrencyEntry,&bTmpBanking);
//STRIP001 
//STRIP001 					bUserNewCurrency=(pTmpCurrencyEntry!=NULL);
//STRIP001 				}
//STRIP001 
//STRIP001 				if(!bUserNewCurrency &&(pNumEntry->GetType() & NUMBERFORMAT_DEFINED))
//STRIP001 				{
//STRIP001 					nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 					aStrComment=pNumEntry->GetComment();
//STRIP001 					CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 					aNewFormNInfo=	pNumEntry->GetFormatstring();
//STRIP001 
//STRIP001 					const StringPtr pStr = new String(aNewFormNInfo);
//STRIP001 
//STRIP001 					if ( nKey == nCurFormatKey ) nSelPos =aCurEntryList.Count();
//STRIP001 					rList.Insert( pStr,rList.Count());
//STRIP001 					aCurEntryList.Insert( nKey, aCurEntryList.Count() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			pNumEntry = pCurFmtTable->Next();
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEListWithUserCurrencys( SvStrings& rList,short nSelPos)
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	sal_uInt16 nMyType;
//STRIP001 
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	sal_uInt16 			nCount		= 0;
//STRIP001 	String			aStrComment;
//STRIP001 	String			aNewFormNInfo;
//STRIP001 	String			aPrevString;
//STRIP001 	String			a2PrevString;
//STRIP001 	short			nMyCat = SELPOS_NONE;
//STRIP001 	short			nIq=0;
//STRIP001 
//STRIP001 	const NfCurrencyEntry* pTmpCurrencyEntry;
//STRIP001 	sal_Bool        bTmpBanking, bAdaptSelPos;
//STRIP001 	XubString		rSymbol;
//STRIP001 	XubString		rBankSymbol;
//STRIP001 
//STRIP001 	SvStrings		aList;
//STRIP001 	SvULongs		aKeyList;
//STRIP001 
//STRIP001 	sal_Bool bFlag=pFormatter->GetNewCurrencySymbolString(nCurFormatKey,rSymbol,
//STRIP001 				&pTmpCurrencyEntry,&bTmpBanking);
//STRIP001 
//STRIP001 	XubString rShortSymbol;
//STRIP001 
//STRIP001 	if(pCurCurrencyEntry==NULL)
//STRIP001 	{
//STRIP001         // If no currency format was previously selected (we're not about to
//STRIP001         // add another currency) and no NfCurrencyEntry was found that matches
//STRIP001         // nCurFormatKey, try to select the initial currency format
//STRIP001         // (nCurFormatKey).
//STRIP001         bAdaptSelPos = (pTmpCurrencyEntry == NULL);
//STRIP001 		pCurCurrencyEntry=(NfCurrencyEntry*)pTmpCurrencyEntry;
//STRIP001 		bBankingSymbol=bTmpBanking;
//STRIP001 		nCurCurrencyEntryPos=FindCurrencyFormat(pTmpCurrencyEntry,bTmpBanking);
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001         if (pTmpCurrencyEntry == pCurCurrencyEntry)
//STRIP001             bAdaptSelPos = sal_True;
//STRIP001         else
//STRIP001         {
//STRIP001             bAdaptSelPos = sal_False;
//STRIP001 		    pTmpCurrencyEntry = pCurCurrencyEntry;
//STRIP001         }
//STRIP001 		bTmpBanking=bBankingSymbol;
//STRIP001 	}
//STRIP001 
//STRIP001 	if(pTmpCurrencyEntry!=NULL)
//STRIP001 	{
//STRIP001 		pTmpCurrencyEntry->BuildSymbolString(rSymbol,sal_False);
//STRIP001 		pTmpCurrencyEntry->BuildSymbolString(rBankSymbol,sal_True);
//STRIP001 		pTmpCurrencyEntry->BuildSymbolString(rShortSymbol,bTmpBanking,sal_True);
//STRIP001 	}
//STRIP001 
//STRIP001 	const SvNumberformat*	pNumEntry	= pCurFmtTable->First();
//STRIP001 
//STRIP001 	while ( pNumEntry )
//STRIP001 	{
//STRIP001 		sal_uInt32 nKey = pCurFmtTable->GetCurKey();
//STRIP001 
//STRIP001 		nCount++;
//STRIP001 
//STRIP001 		if ( !IsRemoved_Impl( nKey ) )
//STRIP001 		{
//STRIP001 			if( pNumEntry->GetType() & NUMBERFORMAT_DEFINED ||
//STRIP001 					pNumEntry->IsAdditionalStandardDefined() )
//STRIP001 			{
//STRIP001 				nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 				aStrComment=pNumEntry->GetComment();
//STRIP001 				CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 				aNewFormNInfo=	pNumEntry->GetFormatstring();
//STRIP001 
//STRIP001 				sal_Bool bInsFlag=sal_False;
//STRIP001 				if ( pNumEntry->HasNewCurrency() )
//STRIP001 					bInsFlag = sal_True;	// merge locale formats into currency selection
//STRIP001 				else if(!bTmpBanking && aNewFormNInfo.Search(rSymbol)!=STRING_NOTFOUND||
//STRIP001 				   bTmpBanking && aNewFormNInfo.Search(rBankSymbol)!=STRING_NOTFOUND)
//STRIP001 				{
//STRIP001 					bInsFlag=sal_True;
//STRIP001 				}
//STRIP001 				else if(aNewFormNInfo.Search(rShortSymbol)!=STRING_NOTFOUND)
//STRIP001 				{
//STRIP001 					XubString rTstSymbol;
//STRIP001 					const NfCurrencyEntry* pTstCurrencyEntry;
//STRIP001 					sal_Bool bTstBanking;
//STRIP001 
//STRIP001 					sal_Bool bTstFlag=pFormatter->GetNewCurrencySymbolString(nKey,rTstSymbol,
//STRIP001 								&pTstCurrencyEntry,&bTstBanking);
//STRIP001 
//STRIP001 					if(pTmpCurrencyEntry==pTstCurrencyEntry && bTstBanking==bTmpBanking)
//STRIP001 					{
//STRIP001 						bInsFlag=sal_True;
//STRIP001 					}
//STRIP001 
//STRIP001 				}
//STRIP001 
//STRIP001 				if(bInsFlag)
//STRIP001 				{
//STRIP001 					const StringPtr pStr = new String(aNewFormNInfo);
//STRIP001 
//STRIP001 					aList.Insert( pStr,aList.Count());
//STRIP001 					aKeyList.Insert( nKey, aKeyList.Count() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pNumEntry = pCurFmtTable->Next();
//STRIP001 	}
//STRIP001 
//STRIP001 	NfWSStringsDtor aWSStringsDtor;
//STRIP001 	sal_uInt16 nDefault;
//STRIP001 	if ( pTmpCurrencyEntry && nCurCategory != NUMBERFORMAT_ALL )
//STRIP001     {
//STRIP001         nDefault = pFormatter->GetCurrencyFormatStrings(
//STRIP001 			aWSStringsDtor,	*pTmpCurrencyEntry, bTmpBanking );
//STRIP001         if ( !bTmpBanking )
//STRIP001             pFormatter->GetCurrencyFormatStrings(
//STRIP001                 aWSStringsDtor, *pTmpCurrencyEntry, TRUE );
//STRIP001     }
//STRIP001 	else
//STRIP001 		nDefault = 0;
//STRIP001     if ( !bTmpBanking && nCurCategory != NUMBERFORMAT_ALL )
//STRIP001     {   // append formats for all currencies defined in the current I18N locale
//STRIP001         const NfCurrencyTable& rCurrencyTable = SvNumberFormatter::GetTheCurrencyTable();
//STRIP001         sal_uInt16 nCurrCount = rCurrencyTable.Count();
//STRIP001         LanguageType eLang = SvNumberFormatter::GetProperLanguage( eCurLanguage );
//STRIP001         for ( sal_uInt16 i=0; i < nCurrCount; ++i )
//STRIP001         {
//STRIP001             const NfCurrencyEntry* pCurr = rCurrencyTable[i];
//STRIP001             if ( pCurr->GetLanguage() == eLang && pTmpCurrencyEntry != pCurr )
//STRIP001             {
//STRIP001                 pFormatter->GetCurrencyFormatStrings( aWSStringsDtor, *pCurr, FALSE );
//STRIP001                 pFormatter->GetCurrencyFormatStrings( aWSStringsDtor, *pCurr, TRUE );
//STRIP001             }
//STRIP001         }
//STRIP001     }
//STRIP001 
//STRIP001     sal_uInt16 i,nPos;
//STRIP001 	sal_uInt16 nOldListCount = rList.Count();
//STRIP001 	for( i=0, nPos=nOldListCount; i<aWSStringsDtor.Count(); i++)
//STRIP001 	{
//STRIP001 		sal_Bool bFlag=sal_True;
//STRIP001 		String aInsStr(*aWSStringsDtor[i]);
//STRIP001 		sal_uInt16 j;
//STRIP001 		for(j=0;j<aList.Count();j++)
//STRIP001 		{
//STRIP001 			const StringPtr pTestStr=aList[j];
//STRIP001 
//STRIP001 			if(*pTestStr==aInsStr)
//STRIP001 			{
//STRIP001 				bFlag=sal_False;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if(bFlag)
//STRIP001 		{
//STRIP001 			rList.Insert(new String(aInsStr),nPos);
//STRIP001 			aCurEntryList.Insert( NUMBERFORMAT_ENTRY_NOT_FOUND, nPos++);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			rList.Insert(aList[j],nPos);
//STRIP001 			aList.Remove(j);
//STRIP001 			aCurEntryList.Insert( aKeyList[j],nPos++);
//STRIP001 			aKeyList.Remove(j);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for(i=0;i<aKeyList.Count();i++)
//STRIP001 	{
//STRIP001 		if(aKeyList[i]!=NUMBERFORMAT_ENTRY_NOT_FOUND)
//STRIP001 		{
//STRIP001 			rList.Insert(aList[i],rList.Count());
//STRIP001 			aCurEntryList.Insert( aKeyList[i],aCurEntryList.Count());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	for(i=nOldListCount;i<rList.Count();i++)
//STRIP001 	{
//STRIP001 		aCurrencyFormatList.Insert(new String(*rList[i]),aCurrencyFormatList.Count());
//STRIP001 
//STRIP001 		if ( nSelPos == SELPOS_NONE && bAdaptSelPos && aCurEntryList[i] == nCurFormatKey )
//STRIP001 			nSelPos = i;
//STRIP001 	}
//STRIP001 
//STRIP001 	if ( nSelPos == SELPOS_NONE && nCurCategory != NUMBERFORMAT_ALL )
//STRIP001 		nSelPos = nDefault;
//STRIP001 
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 short SvxNumberFormatShell::FillEListWithUsD_Impl( SvStrings& rList, sal_uInt16 nPrivCat, short nSelPos)
//STRIP001 {
//STRIP001 	/* Erstellen einer aktuellen Liste von Format-Eintraegen.
//STRIP001 	 * Rueckgabewert ist die Listenposition des aktuellen Formates.
//STRIP001 	 * Ist die Liste leer oder gibt es kein aktuelles Format,
//STRIP001 	 * so wird SELPOS_NONE geliefert.
//STRIP001 	 */
//STRIP001 	sal_uInt16 nMyType;
//STRIP001 
//STRIP001 	DBG_ASSERT( pCurFmtTable != NULL, "Unbekanntes Zahlenformat!" );
//STRIP001 
//STRIP001 	const SvNumberformat*	pNumEntry	= pCurFmtTable->First();
//STRIP001 	sal_uInt16 			nCount		= 0;
//STRIP001 	String			aStrComment;
//STRIP001 	String			aNewFormNInfo;
//STRIP001 	String			aPrevString;
//STRIP001 	String			a2PrevString;
//STRIP001 
//STRIP001 	short			nMyCat		= SELPOS_NONE;
//STRIP001 	short			nIq=0;
//STRIP001 	sal_Bool		bAdditional = (nPrivCat != CAT_USERDEFINED &&
//STRIP001 									nCurCategory != NUMBERFORMAT_ALL);
//STRIP001 
//STRIP001 	while ( pNumEntry )
//STRIP001 	{
//STRIP001 		sal_uInt32 nKey = pCurFmtTable->GetCurKey();
//STRIP001 
//STRIP001 		nCount++;
//STRIP001 
//STRIP001 		if ( !IsRemoved_Impl( nKey ) )
//STRIP001 		{
//STRIP001 			if( (pNumEntry->GetType() & NUMBERFORMAT_DEFINED) ||
//STRIP001 					(bAdditional && pNumEntry->IsAdditionalStandardDefined()) )
//STRIP001 			{
//STRIP001 				nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 				aStrComment=pNumEntry->GetComment();
//STRIP001 				CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 				aNewFormNInfo=	pNumEntry->GetFormatstring();
//STRIP001 
//STRIP001 				sal_Bool bFlag=sal_True;
//STRIP001 				if(pNumEntry->HasNewCurrency())
//STRIP001 				{
//STRIP001 					sal_Bool bTestBanking;
//STRIP001 					sal_uInt16 nPos=FindCurrencyTableEntry(aNewFormNInfo,bTestBanking);
//STRIP001 					bFlag=!IsInTable(nPos,bTestBanking,aNewFormNInfo);
//STRIP001 				}
//STRIP001 				if(bFlag)
//STRIP001 				{
//STRIP001 					const StringPtr pStr = new String(aNewFormNInfo);
//STRIP001 
//STRIP001 					if ( nKey == nCurFormatKey ) nSelPos =aCurEntryList.Count();
//STRIP001 					rList.Insert( pStr,rList.Count());
//STRIP001 					aCurEntryList.Insert( nKey, aCurEntryList.Count() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		pNumEntry = pCurFmtTable->Next();
//STRIP001 	}
//STRIP001 	return nSelPos;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetPreviewString_Impl( String& rString, Color*& rpColor )
//STRIP001 {
//STRIP001     rpColor = NULL;
//STRIP001 
//STRIP001 	//	#50441# if a string was set in addition to the value, use it for text formats
//STRIP001 	BOOL bUseText = ( eValType == SVX_VALUE_TYPE_STRING ||
//STRIP001 						( aValStr.Len() && ( pFormatter->GetType(nCurFormatKey) & NUMBERFORMAT_TEXT ) ) );
//STRIP001 
//STRIP001 	if ( bUseText )
//STRIP001         pFormatter->GetOutputString( aValStr, nCurFormatKey, rString, &rpColor );
//STRIP001 	else
//STRIP001         pFormatter->GetOutputString( nValNum, nCurFormatKey, rString, &rpColor );
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::IsRemoved_Impl( sal_uInt32 nKey )
//STRIP001 {
//STRIP001 	sal_Bool bFound = sal_False;
//STRIP001 	for ( sal_uInt16 i = 0; !bFound && i < aDelList.Count(); ++i )
//STRIP001 		if ( aDelList[i] == nKey )
//STRIP001 			bFound = sal_True;
//STRIP001 	return bFound;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::IsAdded_Impl( sal_uInt32 nKey )
//STRIP001 {
//STRIP001 	sal_Bool bFound = sal_False;
//STRIP001 	for ( sal_uInt16 i = 0; !bFound && i < aAddList.Count(); ++i )
//STRIP001 		if ( aAddList[i] == nKey )
//STRIP001 			bFound = sal_True;
//STRIP001 	return bFound;
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 // Konvertierungs-Routinen:
//STRIP001 // ------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::PosToCategory_Impl( sal_uInt16 nPos, short& rCategory )
//STRIP001 {
//STRIP001 	// Kategorie ::com::sun::star::form-Positionen abbilden (->Resource)
//STRIP001 	switch ( nPos )
//STRIP001 	{
//STRIP001 		case CAT_USERDEFINED:	rCategory = NUMBERFORMAT_DEFINED;		break;
//STRIP001 		case CAT_NUMBER:		rCategory = NUMBERFORMAT_NUMBER;		break;
//STRIP001 		case CAT_PERCENT:		rCategory = NUMBERFORMAT_PERCENT;		break;
//STRIP001 		case CAT_CURRENCY:		rCategory = NUMBERFORMAT_CURRENCY;		break;
//STRIP001 		case CAT_DATE:			rCategory = NUMBERFORMAT_DATE;			break;
//STRIP001 		case CAT_TIME:			rCategory = NUMBERFORMAT_TIME;			break;
//STRIP001 		case CAT_SCIENTIFIC:	rCategory = NUMBERFORMAT_SCIENTIFIC;	break;
//STRIP001 		case CAT_FRACTION:		rCategory = NUMBERFORMAT_FRACTION;		break;
//STRIP001 		case CAT_BOOLEAN:		rCategory = NUMBERFORMAT_LOGICAL;		break;
//STRIP001 		case CAT_TEXT:			rCategory = NUMBERFORMAT_TEXT;			break;
//STRIP001 		case CAT_ALL:
//STRIP001 		default:	rCategory = NUMBERFORMAT_ALL; break;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 // -----------------------------------------------------------------------
//STRIP001 
//STRIP001 void SvxNumberFormatShell::CategoryToPos_Impl( short nCategory, sal_uInt16& rPos )
//STRIP001 {
//STRIP001 	// Kategorie auf ::com::sun::star::form-Positionen abbilden (->Resource)
//STRIP001 	switch ( nCategory )
//STRIP001 	{
//STRIP001 		case NUMBERFORMAT_DEFINED:		rPos = CAT_USERDEFINED;	break;
//STRIP001 		case NUMBERFORMAT_NUMBER:		rPos = CAT_NUMBER;		break;
//STRIP001 		case NUMBERFORMAT_PERCENT:		rPos = CAT_PERCENT;		break;
//STRIP001 		case NUMBERFORMAT_CURRENCY:		rPos = CAT_CURRENCY;	break;
//STRIP001 		case NUMBERFORMAT_DATETIME:
//STRIP001 		case NUMBERFORMAT_DATE:			rPos = CAT_DATE;		break;
//STRIP001 		case NUMBERFORMAT_TIME:			rPos = CAT_TIME;		break;
//STRIP001 		case NUMBERFORMAT_SCIENTIFIC:	rPos = CAT_SCIENTIFIC;	break;
//STRIP001 		case NUMBERFORMAT_FRACTION:		rPos = CAT_FRACTION;	break;
//STRIP001 		case NUMBERFORMAT_LOGICAL:		rPos = CAT_BOOLEAN;		break;
//STRIP001 		case NUMBERFORMAT_TEXT:			rPos = CAT_TEXT;		break;
//STRIP001 		case NUMBERFORMAT_ALL:
//STRIP001 		default:						rPos = CAT_ALL;
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		MakePrevStringFromVal						Datum:19.09.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Formatiert die Zahl nValue abhaengig von rFormatStr
//STRIP001 #*				und speichert das Ergebnis in rPreviewStr.
//STRIP001 #*
//STRIP001 #*  Input:		FormatString, Farbe, zu formatierende Zahl
//STRIP001 #*
//STRIP001 #*	Output:		Ausgabestring rPreviewStr
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatShell::MakePrevStringFromVal(
//STRIP001         const String& rFormatStr,
//STRIP001         String& rPreviewStr,
//STRIP001         Color*& rpFontColor,
//STRIP001         double  nValue)
//STRIP001 {
//STRIP001     rpFontColor = NULL;
//STRIP001     pFormatter->GetPreviewString( rFormatStr, nValue, rPreviewStr, &rpFontColor, eCurLanguage );
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		GetComment4Entry							Datum:30.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert den Kommentar fuer einen gegebenen
//STRIP001 #*				Eintrag zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		Nummer des Eintrags
//STRIP001 #*
//STRIP001 #*	Output:		Kommentar-String
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 void SvxNumberFormatShell::SetComment4Entry(short nEntry,String aEntStr)
//STRIP001 {
//STRIP001 	SvNumberformat *pNumEntry;
//STRIP001 	if(nEntry<0) return;
//STRIP001 	sal_uInt32	nMyNfEntry=aCurEntryList[nEntry];
//STRIP001 	pNumEntry = (SvNumberformat*)pFormatter->GetEntry(nMyNfEntry);
//STRIP001 	if(pNumEntry!=NULL) pNumEntry->SetComment(aEntStr);
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		GetComment4Entry							Datum:30.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert den Kommentar fuer einen gegebenen
//STRIP001 #*				Eintrag zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		Nummer des Eintrags
//STRIP001 #*
//STRIP001 #*	Output:		Kommentar-String
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 String SvxNumberFormatShell::GetComment4Entry(short nEntry)
//STRIP001 {
//STRIP001 	const SvNumberformat *pNumEntry;
//STRIP001 
//STRIP001 	if(nEntry < 0)
//STRIP001 		return String();
//STRIP001 
//STRIP001 	if(nEntry<aCurEntryList.Count())
//STRIP001 	{
//STRIP001 		sal_uInt32	nMyNfEntry=aCurEntryList[nEntry];
//STRIP001 		pNumEntry = pFormatter->GetEntry(nMyNfEntry);
//STRIP001 		if(pNumEntry!=NULL)
//STRIP001 			return pNumEntry->GetComment();
//STRIP001 	}
//STRIP001 
//STRIP001 	return String();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		GetCategory4Entry							Datum:30.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert die Kategorie- Nummer fuer einen gegebenen
//STRIP001 #*				Eintrag zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		Nummer des Eintrags
//STRIP001 #*
//STRIP001 #*	Output:		Kategorie- Nummer
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 short SvxNumberFormatShell::GetCategory4Entry(short nEntry)
//STRIP001 {
//STRIP001 	const SvNumberformat *pNumEntry;
//STRIP001 	if(nEntry<0) return 0;
//STRIP001 
//STRIP001 	if(nEntry<aCurEntryList.Count())
//STRIP001 	{
//STRIP001 		sal_uInt32	nMyNfEntry=aCurEntryList[nEntry];
//STRIP001 
//STRIP001 		if(nMyNfEntry!=NUMBERFORMAT_ENTRY_NOT_FOUND)
//STRIP001 		{
//STRIP001 			pNumEntry = pFormatter->GetEntry(nMyNfEntry);
//STRIP001 			sal_uInt16 nMyCat,nMyType;
//STRIP001 			if(pNumEntry!=NULL)
//STRIP001 			{
//STRIP001 				nMyCat=pNumEntry->GetType() & ~NUMBERFORMAT_DEFINED;
//STRIP001 				CategoryToPos_Impl(nMyCat,nMyType);
//STRIP001 
//STRIP001 				return (short) nMyType;
//STRIP001 			}
//STRIP001 			return 0;
//STRIP001 		}
//STRIP001 		else if(aCurrencyFormatList.Count()>0)
//STRIP001 		{
//STRIP001 			return CAT_CURRENCY;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return 0;
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		GetUserDefined4Entry						Datum:31.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert die Information, ob ein Eintrag
//STRIP001 #*				benutzerspezifisch ist zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		Nummer des Eintrags
//STRIP001 #*
//STRIP001 #*	Output:		Benutzerspezifisch?
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::GetUserDefined4Entry(short nEntry)
//STRIP001 {
//STRIP001 	const SvNumberformat *pNumEntry;
//STRIP001 	if(nEntry<0) return 0;
//STRIP001 	if(nEntry<aCurEntryList.Count())
//STRIP001 	{
//STRIP001 		sal_uInt32	nMyNfEntry=aCurEntryList[nEntry];
//STRIP001 		pNumEntry = pFormatter->GetEntry(nMyNfEntry);
//STRIP001 
//STRIP001 		if(pNumEntry!=NULL)
//STRIP001 		{
//STRIP001 			if((pNumEntry->GetType() & NUMBERFORMAT_DEFINED)>0)
//STRIP001 			{
//STRIP001 				return sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		GetFormat4Entry								Datum:30.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert den Format- String fuer einen gegebenen
//STRIP001 #*				Eintrag zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		Nummer des Eintrags
//STRIP001 #*
//STRIP001 #*	Output:		Format- String
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 String SvxNumberFormatShell::GetFormat4Entry(short nEntry)
//STRIP001 {
//STRIP001 	const SvNumberformat *pNumEntry;
//STRIP001 
//STRIP001 	if(nEntry < 0)
//STRIP001 		return String();
//STRIP001 
//STRIP001 	if(aCurrencyFormatList.Count()>0)
//STRIP001 	{
//STRIP001 		if(aCurrencyFormatList.Count()>nEntry)
//STRIP001 			return *aCurrencyFormatList[nEntry];
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		sal_uInt32	nMyNfEntry=aCurEntryList[nEntry];
//STRIP001 		pNumEntry = pFormatter->GetEntry(nMyNfEntry);
//STRIP001 
//STRIP001 		if(pNumEntry!=NULL)
//STRIP001 			return pNumEntry->GetFormatstring();
//STRIP001 	}
//STRIP001 	return String();
//STRIP001 }
//STRIP001 
//STRIP001 /*************************************************************************
//STRIP001 #*	Member:		GetListPos4Entry							Datum:31.10.97
//STRIP001 #*------------------------------------------------------------------------
//STRIP001 #*
//STRIP001 #*  Klasse:		SvxNumberFormatShell
//STRIP001 #*
//STRIP001 #*  Funktion:	Liefert die Listen- Nummer fuer einen gegebenen
//STRIP001 #*				Formatindex zurueck.
//STRIP001 #*
//STRIP001 #*  Input:		Nummer des Eintrags
//STRIP001 #*
//STRIP001 #*	Output:		Kategorie- Nummer
//STRIP001 #*
//STRIP001 #************************************************************************/
//STRIP001 
//STRIP001 short SvxNumberFormatShell::GetListPos4Entry(sal_uInt32 nIdx)
//STRIP001 {
//STRIP001 	short nSelP=SELPOS_NONE;
//STRIP001 	for(int i=0;i<aCurEntryList.Count();i++)
//STRIP001 	{
//STRIP001 		if(aCurEntryList[i]==nIdx)
//STRIP001 		{
//STRIP001 			nSelP=i;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nSelP;
//STRIP001 }
//STRIP001 
//STRIP001 short SvxNumberFormatShell::GetListPos4Entry( const String& rFmtString )
//STRIP001 {
//STRIP001 	sal_uInt32 nAt=0;
//STRIP001 	short nSelP=SELPOS_NONE;
//STRIP001 	if(FindEntry(rFmtString, &nAt))
//STRIP001 	{
//STRIP001 		if(NUMBERFORMAT_ENTRY_NOT_FOUND!=nAt && NUMBERFORMAT_ENTRY_NEW_CURRENCY!=nAt)
//STRIP001 		{
//STRIP001 			nSelP=GetListPos4Entry(nAt);
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if(aCurrencyFormatList.Count()>0)
//STRIP001 			{
//STRIP001 				for(sal_uInt16 i=0;i<aCurrencyFormatList.Count();i++)
//STRIP001 				{
//STRIP001 					if (rFmtString==*aCurrencyFormatList[i])
//STRIP001 					{
//STRIP001 						nSelP=i;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return nSelP;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetCurrencySymbols(SvStringsDtor& rList,const XubString& rStrEurope, sal_uInt16* pPos)
//STRIP001 {
//STRIP001 
//STRIP001     const NfCurrencyEntry* pTmpCurrencyEntry=SvNumberFormatter::MatchSystemCurrency();
//STRIP001 
//STRIP001 	sal_Bool bFlag=(pTmpCurrencyEntry==NULL);
//STRIP001 
//STRIP001 	GetCurrencySymbols(rList,rStrEurope, bFlag);
//STRIP001 
//STRIP001 	if(pPos!=NULL)
//STRIP001 	{
//STRIP001         const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 		sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 		*pPos=0;
//STRIP001 		nCount=aCurCurrencyList.Count();
//STRIP001 
//STRIP001 		if(bFlag)
//STRIP001 		{
//STRIP001 			*pPos=1;
//STRIP001 			nCurCurrencyEntryPos=1;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			for(sal_uInt16 i=1;i<nCount;i++)
//STRIP001 			{
//STRIP001 				if(aCurCurrencyList[i]!=(sal_uInt16)-1 &&
//STRIP001 					pTmpCurrencyEntry==rCurrencyTable[aCurCurrencyList[i]])
//STRIP001 				{
//STRIP001 					*pPos=i;
//STRIP001 					nCurCurrencyEntryPos=i;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetCurrencySymbols(SvStringsDtor& rList,const XubString& rStrEurope, sal_Bool bFlag)
//STRIP001 {
//STRIP001 	aCurCurrencyList.Remove(0,aCurCurrencyList.Count());
//STRIP001 
//STRIP001     const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 	sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 	SvxLanguageTable* pLanguageTable=new SvxLanguageTable;
//STRIP001 
//STRIP001     sal_uInt16 nStart=1;
//STRIP001 	sal_uInt16 i,j;
//STRIP001 
//STRIP001 	XubString aString(rCurrencyTable[0]->GetSymbol());
//STRIP001 	aString += sal_Unicode(' ');
//STRIP001 	aString += pLanguageTable->GetString(rCurrencyTable[0]->GetLanguage());
//STRIP001 
//STRIP001 	WSStringPtr pStr = new XubString(aString);
//STRIP001 	rList.Insert( pStr,rList.Count());
//STRIP001 	sal_uInt16 nAuto=(sal_uInt16)-1;
//STRIP001 	aCurCurrencyList.Insert(nAuto,aCurCurrencyList.Count());
//STRIP001 
//STRIP001 	if(bFlag)
//STRIP001 	{
//STRIP001 		pStr = new XubString(aString);
//STRIP001 		rList.Insert( pStr,rList.Count());
//STRIP001 		aCurCurrencyList.Insert((sal_uInt16)0,aCurCurrencyList.Count());
//STRIP001         ++nStart;
//STRIP001 	}
//STRIP001 
//STRIP001     for(i=1;i<nCount;i++)
//STRIP001 	{
//STRIP001 		XubString aString(rCurrencyTable[i]->GetSymbol());
//STRIP001 		aString += sal_Unicode(' ');
//STRIP001 		aString += pLanguageTable->GetString(rCurrencyTable[i]->GetLanguage());
//STRIP001 
//STRIP001 		pStr = new XubString(aString);
//STRIP001 
//STRIP001 		for(j=nStart;j<rList.Count();j++)
//STRIP001 		{
//STRIP001 			const StringPtr pTestStr=rList[j];
//STRIP001 
//STRIP001 			if(*pTestStr>aString) break;
//STRIP001 		}
//STRIP001 		rList.Insert( pStr,j);
//STRIP001 		aCurCurrencyList.Insert(i,j);
//STRIP001 	}
//STRIP001 
//STRIP001     sal_uInt16 nCont = rList.Count();
//STRIP001 
//STRIP001     for(i=1;i<nCount;i++)
//STRIP001 	{
//STRIP001 		sal_Bool bTest=sal_True;
//STRIP001 		pStr = new XubString(rCurrencyTable[i]->GetBankSymbol());
//STRIP001 
//STRIP001 		for(j=nCont;j<rList.Count();j++)
//STRIP001 		{
//STRIP001 			const StringPtr pTestStr=rList[j];
//STRIP001 
//STRIP001 			if(*pTestStr==*pStr)
//STRIP001 				bTest=sal_False;
//STRIP001 			else
//STRIP001 				if(*pTestStr>*pStr) break;
//STRIP001 		}
//STRIP001 		if(bTest)
//STRIP001 		{
//STRIP001 			rList.Insert( pStr,j);
//STRIP001 			aCurCurrencyList.Insert(i,j);
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     delete pLanguageTable;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatShell::GetCurrencyFormats(SvStrings& aListDtor)
//STRIP001 {
//STRIP001 	if(pCurCurrencyEntry!=NULL)
//STRIP001 	{
//STRIP001 		NfWSStringsDtor aWSStringsDtor;
//STRIP001 		sal_uInt16 nDefault = pFormatter->GetCurrencyFormatStrings( aWSStringsDtor,
//STRIP001 			*pCurCurrencyEntry, bBankingSymbol );
//STRIP001 
//STRIP001 		for(sal_uInt16 i=0;i<aWSStringsDtor.Count();i++)
//STRIP001 		{
//STRIP001 			aListDtor.Insert(new String(*aWSStringsDtor[i]),aListDtor.Count());
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::IsBankingSymbol(sal_uInt16 nPos)
//STRIP001 {
//STRIP001     const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 	sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 	return (nPos>nCount);
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatShell::SetCurrencySymbol(sal_uInt16 nPos)
//STRIP001 {
//STRIP001     const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 	sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 	bBankingSymbol=(nPos>=nCount);
//STRIP001 
//STRIP001 	if(nPos<aCurCurrencyList.Count())
//STRIP001 	{
//STRIP001 		sal_uInt16 nCurrencyPos=aCurCurrencyList[nPos];
//STRIP001 		if(nCurrencyPos!=(sal_uInt16)-1)
//STRIP001 		{
//STRIP001 			pCurCurrencyEntry=rCurrencyTable[nCurrencyPos];
//STRIP001 			nCurCurrencyEntryPos=nPos;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			pCurCurrencyEntry=NULL;
//STRIP001 			nCurCurrencyEntryPos=0;
//STRIP001 			nCurFormatKey=pFormatter->GetFormatIndex(
//STRIP001 						 NF_CURRENCY_1000DEC2_RED, eCurLanguage);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt32 SvxNumberFormatShell::GetCurrencySymbol()
//STRIP001 {
//STRIP001 	return nCurCurrencyEntryPos;
//STRIP001 }
//STRIP001 
//STRIP001 NfCurrencyEntry* SvxNumberFormatShell::GetCurCurrencyEntry()
//STRIP001 {
//STRIP001 	return pCurCurrencyEntry;
//STRIP001 }
//STRIP001 
//STRIP001 void SvxNumberFormatShell::SetCurCurrencyEntry(NfCurrencyEntry* pCEntry)
//STRIP001 {
//STRIP001 	pCurCurrencyEntry=pCEntry;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::IsTmpCurrencyFormat( const String& rFmtString )
//STRIP001 {
//STRIP001 	sal_uInt32 nFound;
//STRIP001 	sal_Bool bRes=FindEntry(rFmtString, &nFound);
//STRIP001 
//STRIP001 	if(nFound==NUMBERFORMAT_ENTRY_NEW_CURRENCY)
//STRIP001 	{
//STRIP001 		return sal_True;
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt16 SvxNumberFormatShell::FindCurrencyFormat( const String& rFmtString )
//STRIP001 {
//STRIP001     const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 	sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 	sal_Bool bTestBanking=sal_False;
//STRIP001 
//STRIP001 	sal_uInt16 nPos=FindCurrencyTableEntry(rFmtString, bTestBanking);
//STRIP001 
//STRIP001 	sal_uInt16 nStart=0;
//STRIP001 
//STRIP001 	if(nPos!=(sal_uInt16)-1)
//STRIP001 	{
//STRIP001 		if(bTestBanking && aCurCurrencyList.Count()>nPos)
//STRIP001 		{
//STRIP001 			nStart=nCount;
//STRIP001 		}
//STRIP001 		for(sal_uInt16 j=nStart;j<aCurCurrencyList.Count();j++)
//STRIP001 		{
//STRIP001 			if(aCurCurrencyList[j]==nPos) return j;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return (sal_uInt16) -1;
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt16 SvxNumberFormatShell::FindCurrencyTableEntry( const String& rFmtString, sal_Bool &bTestBanking )
//STRIP001 {
//STRIP001 	sal_uInt16 nPos=(sal_uInt16) -1;
//STRIP001 
//STRIP001     const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 	sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 	const SvNumberformat* pFormat;
//STRIP001 	String aSymbol, aExtension;
//STRIP001 	sal_uInt32 nFound = pFormatter->TestNewString( rFmtString, eCurLanguage );
//STRIP001 	if ( nFound != NUMBERFORMAT_ENTRY_NOT_FOUND &&
//STRIP001 			(pFormat = pFormatter->GetEntry( nFound )) &&
//STRIP001 			pFormat->GetNewCurrencySymbol( aSymbol, aExtension ) )
//STRIP001 	{	// eventually match with format locale
//STRIP001 		const NfCurrencyEntry* pTmpCurrencyEntry =
//STRIP001             SvNumberFormatter::GetCurrencyEntry( bTestBanking, aSymbol, aExtension,
//STRIP001 			pFormat->GetLanguage() );
//STRIP001 		if ( pTmpCurrencyEntry )
//STRIP001 		{
//STRIP001 			for(sal_uInt16 i=0;i<nCount;i++)
//STRIP001 			{
//STRIP001 				if(pTmpCurrencyEntry==rCurrencyTable[i])
//STRIP001 				{
//STRIP001 					nPos=i;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{	// search symbol string only
//STRIP001 		for(sal_uInt16 i=0;i<nCount;i++)
//STRIP001 		{
//STRIP001 			const NfCurrencyEntry* pTmpCurrencyEntry=rCurrencyTable[i];
//STRIP001 			XubString aSymbol, aBankSymbol;
//STRIP001 			pTmpCurrencyEntry->BuildSymbolString(aSymbol,sal_False);
//STRIP001 			pTmpCurrencyEntry->BuildSymbolString(aBankSymbol,sal_True);
//STRIP001 
//STRIP001 			if(rFmtString.Search(aSymbol)!=STRING_NOTFOUND)
//STRIP001 			{
//STRIP001 				bTestBanking=sal_False;
//STRIP001 				nPos=i;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 			else if(rFmtString.Search(aBankSymbol)!=STRING_NOTFOUND)
//STRIP001 			{
//STRIP001 				bTestBanking=sal_True;
//STRIP001 				nPos=i;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return nPos;
//STRIP001 }
//STRIP001 
//STRIP001 sal_uInt16 SvxNumberFormatShell::FindCurrencyFormat(const NfCurrencyEntry* pTmpCurrencyEntry,sal_Bool bTmpBanking)
//STRIP001 {
//STRIP001     const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 	sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 	sal_Bool bTestBanking=sal_False;
//STRIP001 	sal_uInt16 nPos=0;
//STRIP001 	for(sal_uInt16 i=0;i<nCount;i++)
//STRIP001 	{
//STRIP001 		if(pTmpCurrencyEntry==rCurrencyTable[i])
//STRIP001 		{
//STRIP001 			nPos=i;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	sal_uInt16 nStart=0;
//STRIP001 	if(bTmpBanking && aCurCurrencyList.Count()>nPos)
//STRIP001 	{
//STRIP001 		nStart=nCount;
//STRIP001 	}
//STRIP001 	for(sal_uInt16 j=nStart;j<aCurCurrencyList.Count();j++)
//STRIP001 	{
//STRIP001 		if(aCurCurrencyList[j]==nPos) return j;
//STRIP001 	}
//STRIP001 	return (sal_uInt16) -1;
//STRIP001 }
//STRIP001 
//STRIP001 sal_Bool SvxNumberFormatShell::IsInTable(sal_uInt16 nPos,sal_Bool bTmpBanking,const String &rFmtString)
//STRIP001 {
//STRIP001 	sal_Bool bFlag=sal_False;
//STRIP001 
//STRIP001 	if(nPos!=(sal_uInt16)-1)
//STRIP001 	{
//STRIP001         const NfCurrencyTable& rCurrencyTable=SvNumberFormatter::GetTheCurrencyTable();
//STRIP001 		sal_uInt16 nCount=rCurrencyTable.Count();
//STRIP001 
//STRIP001 		if(nPos<nCount)
//STRIP001 		{
//STRIP001 			NfWSStringsDtor aWSStringsDtor;
//STRIP001 			sal_uInt16 nDefault;
//STRIP001 
//STRIP001 			const NfCurrencyEntry* pTmpCurrencyEntry=rCurrencyTable[nPos];
//STRIP001 
//STRIP001 			if ( pTmpCurrencyEntry!=NULL)
//STRIP001 			{
//STRIP001 				nDefault = pFormatter->GetCurrencyFormatStrings( aWSStringsDtor,
//STRIP001 								*pTmpCurrencyEntry, bTmpBanking );
//STRIP001 
//STRIP001 				for(sal_uInt16 i=0;i<aWSStringsDtor.Count();i++)
//STRIP001 				{
//STRIP001 					if(*aWSStringsDtor[i]==rFmtString)
//STRIP001 					{
//STRIP001 						bFlag=sal_True;
//STRIP001 						break;
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return bFlag;
//STRIP001 }

}
