/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_msfiltertracer.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 06:27:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _MS_FILTERTRACER_HXX
#include "msfiltertracer.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_H_
#include <com/sun/star/uno/Sequence.h>
#endif
#ifndef _COM_SUN_STAR_UTIL_LOGGING_LOGLEVEL_HPP_
#include <com/sun/star/util/logging/LogLevel.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_SEARCHALGORITHMS_HPP_
#include <com/sun/star/util/SearchAlgorithms.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_SEARCHFLAGS_HPP_
#include <com/sun/star/util/SearchFlags.hpp>
#endif
#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _FILTER_CONFIG_ITEM_HXX_
#include <svtools/FilterConfigItem.hxx>
#endif
#ifndef _LEGACYBINFILTERMGR_HXX
#include <legacysmgr/legacy_binfilters_smgr.hxx>	//STRIP002 
#endif
namespace binfilter {

// --------------
// - Namespaces -
// --------------

//STRIP001 using namespace ::com::sun::star;
//STRIP001 
//STRIP001 MSFilterTracer::MSFilterTracer() :
//STRIP001 	mpCfgItem( NULL )
//STRIP001 {
//STRIP001 
//STRIP001 };
//STRIP001 
//STRIP001 MSFilterTracer::~MSFilterTracer()
//STRIP001 {
//STRIP001 	delete mpCfgItem;
//STRIP001 };
//STRIP001 
//STRIP001 MSFilterTracer& MSFilterTracer::operator=( const MSFilterTracer& rFilterTracer )
//STRIP001 {
//STRIP001 	delete mpCfgItem, mpCfgItem = new FilterConfigItem( *rFilterTracer.mpCfgItem );
//STRIP001 	mbEnabled = rFilterTracer.mbEnabled;
//STRIP001 	mxFilterTracer = rFilterTracer.mxFilterTracer;
//STRIP001 	mxLogger = rFilterTracer.mxLogger;
//STRIP001 	return *this;
//STRIP001 }
//STRIP001 
//STRIP001 void MSFilterTracer::StartTracing( const ::rtl::OUString& rConfigPath )
//STRIP001 {
//STRIP001 	delete mpCfgItem, mpCfgItem = new FilterConfigItem( rConfigPath );
//STRIP001 
//STRIP001 	mbEnabled = mpCfgItem->ReadBool( ::rtl::OUString::createFromAscii( "Enabled" ), sal_False );
//STRIP001 	if ( mbEnabled )
//STRIP001 	{
//STRIP001 		sal_Int32 nLogLevel = mpCfgItem->ReadInt32( ::rtl::OUString::createFromAscii( "LogLevel" ), util::logging::LogLevel::ALL );
//STRIP001 		::rtl::OUString aEmptyString;
//STRIP001 		::rtl::OUString aClassFilter( mpCfgItem->ReadString( ::rtl::OUString::createFromAscii( "ClassFilter" ), aEmptyString ) );
//STRIP001 		::rtl::OUString aMethodFilter( mpCfgItem->ReadString( ::rtl::OUString::createFromAscii( "MethodFilter" ), aEmptyString ) );
//STRIP001 		::rtl::OUString aMessageFilter( mpCfgItem->ReadString( ::rtl::OUString::createFromAscii( "MessageFilter" ), aEmptyString ) );
//STRIP001 		::rtl::OUString aURL( mpCfgItem->ReadString( ::rtl::OUString::createFromAscii( "URL" ), aEmptyString ) );
//STRIP001 		util::SearchAlgorithms eSearchAlgorithm = (util::SearchAlgorithms)
//STRIP001 			mpCfgItem->ReadInt32( ::rtl::OUString::createFromAscii( "SearchAlgorithm" ), util::SearchAlgorithms_ABSOLUTE );
//STRIP001 
//STRIP001 		uno::Sequence< uno::Any > aArgument( 1 );
//STRIP001 		uno::Sequence< beans::PropertyValue > aPropValues( 5 );
//STRIP001 		aPropValues[ 0 ].Name  = ::rtl::OUString::createFromAscii( "LogLevel" );
//STRIP001 		aPropValues[ 0 ].Value <<= nLogLevel;
//STRIP001 		aPropValues[ 1 ].Name  = ::rtl::OUString::createFromAscii( "ClassFilter" );
//STRIP001 		aPropValues[ 1 ].Value <<= aClassFilter;
//STRIP001 		aPropValues[ 2 ].Name  = ::rtl::OUString::createFromAscii( "MethodFilter" );
//STRIP001 		aPropValues[ 2 ].Value <<= aMethodFilter;
//STRIP001 		aPropValues[ 3 ].Name  = ::rtl::OUString::createFromAscii( "MessageFilter" );
//STRIP001 		aPropValues[ 3 ].Value <<= aMessageFilter;
//STRIP001 		aPropValues[ 4 ].Name  = ::rtl::OUString::createFromAscii( "URL" );
//STRIP001 		aPropValues[ 4 ].Value <<= aURL;
//STRIP001 		aArgument[ 0 ] <<= aPropValues;
//STRIP001 
//STRIP001 		uno::Reference< lang::XMultiServiceFactory > xMgr( ::legacy_binfilters::getLegacyProcessServiceFactory()) );
//STRIP001 		if ( xMgr.is() )
//STRIP001 		{
//STRIP001 			mxFilterTracer = xMgr->createInstanceWithArguments( ::rtl::OUString::createFromAscii( "com.sun.star.util.FilterTracer" ), aArgument );
//STRIP001 			if ( mxFilterTracer.is() )
//STRIP001 			{
//STRIP001 				uno::Reference< util::XTextSearch >
//STRIP001 					xTextSearch( mxFilterTracer, uno::UNO_QUERY );
//STRIP001 				mxLogger = uno::Reference< util::logging::XLogger >( mxFilterTracer, uno::UNO_QUERY );
//STRIP001 
//STRIP001 				if ( xTextSearch.is() )
//STRIP001 				{
//STRIP001 					util::SearchOptions aOptions;
//STRIP001 					aOptions.algorithmType = eSearchAlgorithm;
//STRIP001 					xTextSearch->setOptions( aOptions );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 void MSFilterTracer::EndTracing()
//STRIP001 {
//STRIP001 	mbEnabled = sal_False;
//STRIP001 	uno::Reference< uno::XInterface > x;
//STRIP001 	mxFilterTracer = x;
//STRIP001 	delete mpCfgItem, mpCfgItem = NULL;
//STRIP001 }
//STRIP001 
//STRIP001 void MSFilterTracer::Trace( const ::rtl::OUString& rMessage ) const
//STRIP001 {
//STRIP001 	if ( mbEnabled && mxLogger.is() )
//STRIP001 	{
//STRIP001 		::rtl::OUString aEmpty;
//STRIP001 		mxLogger->logp( 0, aEmpty, aEmpty, rMessage );
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 uno::Any MSFilterTracer::GetProperty( const ::rtl::OUString& rPropName ) const
//STRIP001 {
//STRIP001 	uno::Any aAny;
//STRIP001 	if ( mpCfgItem )
//STRIP001 		aAny = mpCfgItem->ReadAny( rPropName, aAny );
//STRIP001 	return aAny;
//STRIP001 }
} //namespace binfilter
