/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: svx_svdotxdr.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 07:02:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {

//STRIP001 #include "svdotext.hxx"
//STRIP001 #include "svdhdl.hxx"
//STRIP001 #include "svddrag.hxx"
//STRIP001 #include "svdview.hxx"
//STRIP001 #include "svdorect.hxx" // fuer SetXPolyDirty in MovCreate bei SolidDragging
//STRIP001 #include "svdglob.hxx"  // Stringcache
//STRIP001 #include "svdstr.hrc"   // Objektname
//STRIP001 
//STRIP001 #ifndef _BIGINT_HXX //autogen
//STRIP001 #include <tools/bigint.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 //
//STRIP001 //  @@@@@@ @@@@@ @@   @@ @@@@@@  @@@@  @@@@@  @@@@@@
//STRIP001 //    @@   @@    @@@ @@@   @@   @@  @@ @@  @@     @@
//STRIP001 //    @@   @@     @@@@@    @@   @@  @@ @@  @@     @@
//STRIP001 //    @@   @@@@    @@@     @@   @@  @@ @@@@@      @@
//STRIP001 //    @@   @@     @@@@@    @@   @@  @@ @@  @@     @@
//STRIP001 //    @@   @@    @@@ @@@   @@   @@  @@ @@  @@ @@  @@
//STRIP001 //    @@   @@@@@ @@   @@   @@    @@@@  @@@@@   @@@@
//STRIP001 //
//STRIP001 //  Dragging, Handles, Create
//STRIP001 //
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 
//STRIP001 USHORT SdrTextObj::GetHdlCount() const
//STRIP001 {
//STRIP001 	return 8;
//STRIP001 }
//STRIP001 
//STRIP001 SdrHdl* SdrTextObj::GetHdl(USHORT nHdlNum) const
//STRIP001 {
//STRIP001 	SdrHdl* pH=NULL;
//STRIP001 	Point aPnt;
//STRIP001 	SdrHdlKind eKind=HDL_MOVE;
//STRIP001 	switch (nHdlNum) {
//STRIP001 		case 0: aPnt=aRect.TopLeft();      eKind=HDL_UPLFT; break; // Oben links
//STRIP001 		case 1: aPnt=aRect.TopCenter();    eKind=HDL_UPPER; break; // Oben
//STRIP001 		case 2: aPnt=aRect.TopRight();     eKind=HDL_UPRGT; break; // Oben rechts
//STRIP001 		case 3: aPnt=aRect.LeftCenter();   eKind=HDL_LEFT ; break; // Links
//STRIP001 		case 4: aPnt=aRect.RightCenter();  eKind=HDL_RIGHT; break; // Rechts
//STRIP001 		case 5: aPnt=aRect.BottomLeft();   eKind=HDL_LWLFT; break; // Unten links
//STRIP001 		case 6: aPnt=aRect.BottomCenter(); eKind=HDL_LOWER; break; // Unten
//STRIP001 		case 7: aPnt=aRect.BottomRight();  eKind=HDL_LWRGT; break; // Unten rechts
//STRIP001 	}
//STRIP001 	if (aGeo.nShearWink!=0) ShearPoint(aPnt,aRect.TopLeft(),aGeo.nTan);
//STRIP001 	if (aGeo.nDrehWink!=0) RotatePoint(aPnt,aRect.TopLeft(),aGeo.nSin,aGeo.nCos);
//STRIP001 	if (eKind!=HDL_MOVE) {
//STRIP001 		pH=new SdrHdl(aPnt,eKind);
//STRIP001 		pH->SetObj((SdrObject*)this);
//STRIP001 		pH->SetDrehWink(aGeo.nDrehWink);
//STRIP001 	}
//STRIP001 	return pH;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::HasSpecialDrag() const
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 Rectangle SdrTextObj::ImpDragCalcRect(const SdrDragStat& rDrag) const
//STRIP001 {
//STRIP001 	Rectangle aTmpRect(aRect);
//STRIP001 	const SdrHdl* pHdl=rDrag.GetHdl();
//STRIP001 	SdrHdlKind eHdl=pHdl==NULL ? HDL_MOVE : pHdl->GetKind();
//STRIP001 	FASTBOOL bEcke=(eHdl==HDL_UPLFT || eHdl==HDL_UPRGT || eHdl==HDL_LWLFT || eHdl==HDL_LWRGT);
//STRIP001 	FASTBOOL bOrtho=rDrag.GetView()!=NULL && rDrag.GetView()->IsOrtho();
//STRIP001 	FASTBOOL bBigOrtho=bEcke && bOrtho && rDrag.GetView()->IsBigOrtho();
//STRIP001 	Point aPos(rDrag.GetNow());
//STRIP001 	// Unrotate:
//STRIP001 	if (aGeo.nDrehWink!=0) RotatePoint(aPos,aTmpRect.TopLeft(),-aGeo.nSin,aGeo.nCos);
//STRIP001 	// Unshear:
//STRIP001 	if (aGeo.nShearWink!=0) ShearPoint(aPos,aTmpRect.TopLeft(),-aGeo.nTan);
//STRIP001 	//
//STRIP001 	FASTBOOL bLft=(eHdl==HDL_UPLFT || eHdl==HDL_LEFT  || eHdl==HDL_LWLFT);
//STRIP001 	FASTBOOL bRgt=(eHdl==HDL_UPRGT || eHdl==HDL_RIGHT || eHdl==HDL_LWRGT);
//STRIP001 	FASTBOOL bTop=(eHdl==HDL_UPRGT || eHdl==HDL_UPPER || eHdl==HDL_UPLFT);
//STRIP001 	FASTBOOL bBtm=(eHdl==HDL_LWRGT || eHdl==HDL_LOWER || eHdl==HDL_LWLFT);
//STRIP001 	if (bLft) aTmpRect.Left()  =aPos.X();
//STRIP001 	if (bRgt) aTmpRect.Right() =aPos.X();
//STRIP001 	if (bTop) aTmpRect.Top()   =aPos.Y();
//STRIP001 	if (bBtm) aTmpRect.Bottom()=aPos.Y();
//STRIP001 	if (bOrtho) { // Ortho
//STRIP001 		long nWdt0=aRect.Right() -aRect.Left();
//STRIP001 		long nHgt0=aRect.Bottom()-aRect.Top();
//STRIP001 		long nXMul=aTmpRect.Right() -aTmpRect.Left();
//STRIP001 		long nYMul=aTmpRect.Bottom()-aTmpRect.Top();
//STRIP001 		long nXDiv=nWdt0;
//STRIP001 		long nYDiv=nHgt0;
//STRIP001 		FASTBOOL bXNeg=(nXMul<0)!=(nXDiv<0);
//STRIP001 		FASTBOOL bYNeg=(nYMul<0)!=(nYDiv<0);
//STRIP001 		nXMul=Abs(nXMul);
//STRIP001 		nYMul=Abs(nYMul);
//STRIP001 		nXDiv=Abs(nXDiv);
//STRIP001 		nYDiv=Abs(nYDiv);
//STRIP001 		Fraction aXFact(nXMul,nXDiv); // Fractions zum kuerzen
//STRIP001 		Fraction aYFact(nYMul,nYDiv); // und zum vergleichen
//STRIP001 		nXMul=aXFact.GetNumerator();
//STRIP001 		nYMul=aYFact.GetNumerator();
//STRIP001 		nXDiv=aXFact.GetDenominator();
//STRIP001 		nYDiv=aYFact.GetDenominator();
//STRIP001 		if (bEcke) { // Eckpunkthandles
//STRIP001 			FASTBOOL bUseX=(aXFact<aYFact) != bBigOrtho;
//STRIP001 			if (bUseX) {
//STRIP001 				long nNeed=long(BigInt(nHgt0)*BigInt(nXMul)/BigInt(nXDiv));
//STRIP001 				if (bYNeg) nNeed=-nNeed;
//STRIP001 				if (bTop) aTmpRect.Top()=aTmpRect.Bottom()-nNeed;
//STRIP001 				if (bBtm) aTmpRect.Bottom()=aTmpRect.Top()+nNeed;
//STRIP001 			} else {
//STRIP001 				long nNeed=long(BigInt(nWdt0)*BigInt(nYMul)/BigInt(nYDiv));
//STRIP001 				if (bXNeg) nNeed=-nNeed;
//STRIP001 				if (bLft) aTmpRect.Left()=aTmpRect.Right()-nNeed;
//STRIP001 				if (bRgt) aTmpRect.Right()=aTmpRect.Left()+nNeed;
//STRIP001 			}
//STRIP001 		} else { // Scheitelpunkthandles
//STRIP001 			if ((bLft || bRgt) && nXDiv!=0) {
//STRIP001 				long nHgt0=aRect.Bottom()-aRect.Top();
//STRIP001 				long nNeed=long(BigInt(nHgt0)*BigInt(nXMul)/BigInt(nXDiv));
//STRIP001 				aTmpRect.Top()-=(nNeed-nHgt0)/2;
//STRIP001 				aTmpRect.Bottom()=aTmpRect.Top()+nNeed;
//STRIP001 			}
//STRIP001 			if ((bTop || bBtm) && nYDiv!=0) {
//STRIP001 				long nWdt0=aRect.Right()-aRect.Left();
//STRIP001 				long nNeed=long(BigInt(nWdt0)*BigInt(nYMul)/BigInt(nYDiv));
//STRIP001 				aTmpRect.Left()-=(nNeed-nWdt0)/2;
//STRIP001 				aTmpRect.Right()=aTmpRect.Left()+nNeed;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	ImpJustifyRect(aTmpRect);
//STRIP001 	return aTmpRect;
//STRIP001 }
//STRIP001 
//STRIP001 class ImpTextDragUser
//STRIP001 {
//STRIP001 public:
//STRIP001 	Rectangle aR;
//STRIP001 };
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::BegDrag(SdrDragStat& rDrag) const
//STRIP001 {
//STRIP001 	if (bSizProt) return FALSE; // Groesse geschuetzt
//STRIP001 	const SdrHdl* pHdl=rDrag.GetHdl();
//STRIP001 	SdrHdlKind eHdl=pHdl==NULL ? HDL_MOVE : pHdl->GetKind();
//STRIP001 	if (eHdl==HDL_UPLFT || eHdl==HDL_UPPER || eHdl==HDL_UPRGT ||
//STRIP001 		eHdl==HDL_LEFT  ||                    eHdl==HDL_RIGHT ||
//STRIP001 		eHdl==HDL_LWLFT || eHdl==HDL_LOWER || eHdl==HDL_LWRGT)
//STRIP001 	{
//STRIP001 		ImpTextDragUser* pUser=new ImpTextDragUser;
//STRIP001 		pUser->aR=aRect;
//STRIP001 		rDrag.SetUser(pUser);
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::MovDrag(SdrDragStat& rDrag) const
//STRIP001 {
//STRIP001 	ImpTextDragUser* pUser=(ImpTextDragUser*)rDrag.GetUser();
//STRIP001 	Rectangle aOldRect(pUser->aR);
//STRIP001 	pUser->aR=ImpDragCalcRect(rDrag);
//STRIP001 	return pUser->aR!=aOldRect;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::EndDrag(SdrDragStat& rDrag)
//STRIP001 {
//STRIP001 	ImpTextDragUser* pUser=(ImpTextDragUser*)rDrag.GetUser();
//STRIP001 	Rectangle aNewRect(pUser->aR);
//STRIP001 	if (aNewRect.TopLeft()!=aRect.TopLeft() &&
//STRIP001 		(aGeo.nDrehWink!=0 || aGeo.nShearWink!=0))
//STRIP001 	{
//STRIP001 		Point aNewPos(aNewRect.TopLeft());
//STRIP001 		if (aGeo.nShearWink!=0) ShearPoint(aNewPos,aRect.TopLeft(),aGeo.nTan);
//STRIP001 		if (aGeo.nDrehWink!=0) RotatePoint(aNewPos,aRect.TopLeft(),aGeo.nSin,aGeo.nCos);
//STRIP001 		aNewRect.SetPos(aNewPos);
//STRIP001 	}
//STRIP001 	if (aNewRect!=aRect) {
//STRIP001 		long nHgt0=aRect.Bottom()-aRect.Top();
//STRIP001 		long nHgt1=aNewRect.Bottom()-aNewRect.Top();
//STRIP001 		long nWdt0=aRect.Right()-aRect.Left();
//STRIP001 		long nWdt1=aNewRect.Right()-aNewRect.Left();
//STRIP001 		SetLogicRect(aNewRect);
//STRIP001 	}
//STRIP001 	delete pUser;
//STRIP001 	rDrag.SetUser(NULL);
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrTextObj::BrkDrag(SdrDragStat& rDrag) const
//STRIP001 {
//STRIP001 	delete rDrag.GetUser();
//STRIP001 	rDrag.SetUser(NULL);
//STRIP001 }
//STRIP001 
//STRIP001 XubString SdrTextObj::GetDragComment(const SdrDragStat& rDrag, FASTBOOL bUndoDragComment, FASTBOOL bCreateComment) const
//STRIP001 {
//STRIP001 	XubString aStr;
//STRIP001 	if (!bCreateComment) ImpTakeDescriptionStr(STR_DragRectResize,aStr);
//STRIP001 	return aStr;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrTextObj::TakeDragPoly(const SdrDragStat& rDrag, XPolyPolygon& rXPP) const
//STRIP001 {
//STRIP001 	rXPP.Clear();
//STRIP001 	Rectangle aTmpRect(ImpDragCalcRect(rDrag));
//STRIP001 	if (aGeo.nDrehWink!=0 || aGeo.nShearWink!=0) {
//STRIP001 		Polygon aPoly(aTmpRect);
//STRIP001 		if (aGeo.nShearWink!=0) ShearPoly(aPoly,aRect.TopLeft(),aGeo.nTan);
//STRIP001 		if (aGeo.nDrehWink!=0) RotatePoly(aPoly,aRect.TopLeft(),aGeo.nSin,aGeo.nCos);
//STRIP001 		rXPP.Insert(XPolygon(aPoly));
//STRIP001 	} else {
//STRIP001 		rXPP.Insert(XPolygon(aTmpRect));
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 ////////////////////////////////////////////////////////////////////////////////////////////////////
//STRIP001 // Create
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::BegCreate(SdrDragStat& rStat)
//STRIP001 {
//STRIP001 	rStat.SetOrtho4Possible();
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::MovCreate(SdrDragStat& rStat)
//STRIP001 {
//STRIP001 	Rectangle aRect1;
//STRIP001 	rStat.TakeCreateRect(aRect1);
//STRIP001 	ImpJustifyRect(aRect1);
//STRIP001 	rStat.SetActionRect(aRect1);
//STRIP001 	aRect=aRect1; // fuer ObjName
//STRIP001 	bBoundRectDirty=TRUE;
//STRIP001 	bSnapRectDirty=TRUE;
//STRIP001 	if (HAS_BASE(SdrRectObj,this)) {
//STRIP001 		((SdrRectObj*)this)->SetXPolyDirty();
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::EndCreate(SdrDragStat& rStat, SdrCreateCmd eCmd)
//STRIP001 {
//STRIP001 	rStat.TakeCreateRect(aRect);
//STRIP001 	ImpJustifyRect(aRect);
//STRIP001 	if (bTextFrame) {
//STRIP001 		if (IsAutoGrowHeight()) {
//STRIP001 			// MinTextHeight
//STRIP001 			long nHgt=aRect.GetHeight()-1;
//STRIP001 			if (nHgt==1) nHgt=0;
//STRIP001 			NbcSetMinTextFrameHeight(nHgt);
//STRIP001 		}
//STRIP001 		if (IsAutoGrowWidth()) {
//STRIP001 			// MinTextWidth
//STRIP001 			long nWdt=aRect.GetWidth()-1;
//STRIP001 			if (nWdt==1) nWdt=0;
//STRIP001 			NbcSetMinTextFrameWidth(nWdt);
//STRIP001 		}
//STRIP001 		// Textrahmen neu berechnen
//STRIP001 		NbcAdjustTextFrameWidthAndHeight();
//STRIP001 	}
//STRIP001 	SetRectsDirty();
//STRIP001 	if (HAS_BASE(SdrRectObj,this)) {
//STRIP001 		((SdrRectObj*)this)->SetXPolyDirty();
//STRIP001 	}
//STRIP001 	return (eCmd==SDRCREATE_FORCEEND || rStat.GetPointAnz()>=2);
//STRIP001 }
//STRIP001 
//STRIP001 void SdrTextObj::BrkCreate(SdrDragStat& rStat)
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 FASTBOOL SdrTextObj::BckCreate(SdrDragStat& rStat)
//STRIP001 {
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 void SdrTextObj::TakeCreatePoly(const SdrDragStat& rDrag, XPolyPolygon& rXPP) const
//STRIP001 {
//STRIP001 	Rectangle aRect1;
//STRIP001 	rDrag.TakeCreateRect(aRect1);
//STRIP001 	aRect1.Justify();
//STRIP001 	rXPP=XPolyPolygon(XPolygon(aRect1));
//STRIP001 }
//STRIP001 
//STRIP001 Pointer SdrTextObj::GetCreatePointer() const
//STRIP001 {
//STRIP001 	if (IsTextFrame()) return Pointer(POINTER_DRAW_TEXT);
//STRIP001 	return Pointer(POINTER_CROSS);
//STRIP001 }

}
