/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_doccomp.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:33:17 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

// auto strip #ifndef _LIST_HXX
// auto strip #include <tools/list.hxx>
// auto strip #endif
// auto strip #ifndef _VCL_VCLENUM_HXX
// auto strip #include <vcl/vclenum.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_CRSDITEM_HXX //autogen
// auto strip #include <bf_svx/crsditem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_COLRITEM_HXX //autogen
// auto strip #include <bf_svx/colritem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_BOXITEM_HXX //autogen
// auto strip #include <bf_svx/boxitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_UDLNITEM_HXX //autogen
// auto strip #include <bf_svx/udlnitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXDOCINF_HXX
// auto strip #include <bf_sfx2/docinf.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _DOC_HXX
// auto strip #include <doc.hxx>
// auto strip #endif

// auto strip #ifndef _DOCARY_HXX
// auto strip #include <docary.hxx>
// auto strip #endif

#ifndef _ERRHDL_HXX
#include <errhdl.hxx>
#endif

// auto strip #ifndef _PAM_HXX
// auto strip #include <pam.hxx>
// auto strip #endif
// auto strip #ifndef _NDTXT_HXX
// auto strip #include <ndtxt.hxx>
// auto strip #endif
// auto strip #ifndef _NDINDEX_HXX
// auto strip #include <ndindex.hxx>
// auto strip #endif
// auto strip #ifndef _REDLINE_HXX
// auto strip #include <redline.hxx>
// auto strip #endif
// auto strip #ifndef _REDLENUM_HXX
// auto strip #include <redlenum.hxx>
// auto strip #endif
// auto strip #ifndef _UNDOBJ_HXX
// auto strip #include <undobj.hxx>
// auto strip #endif
// auto strip #ifndef _SECTION_HXX
// auto strip #include <section.hxx>
// auto strip #endif
// auto strip #ifndef _TOX_HXX
// auto strip #include <tox.hxx>
// auto strip #endif
namespace binfilter {



//STRIP001 class CompareLine
//STRIP001 {
//STRIP001 public:
//STRIP001 	CompareLine() {}
//STRIP001 	virtual ~CompareLine();
//STRIP001 
//STRIP001 	virtual ULONG GetHashValue() const = 0;
//STRIP001 	virtual BOOL Compare( const CompareLine& rLine ) const = 0;
//STRIP001 };

//STRIP001 DECLARE_LIST( CompareList, CompareLine* )

//STRIP001 class CompareData
//STRIP001 {
//STRIP001 	ULONG* pIndex;
//STRIP001 	BOOL* pChangedFlag;
//STRIP001 
//STRIP001 protected:
//STRIP001 	CompareList aLines;
//STRIP001 	ULONG nSttLineNum;
//STRIP001 
//STRIP001 	// Anfang und Ende beschneiden und alle anderen in das
//STRIP001 	// LinesArray setzen
//STRIP001 	virtual void CheckRanges( CompareData& ) = 0;
//STRIP001 
//STRIP001 public:
//STRIP001 	CompareData();
//STRIP001 	virtual ~CompareData();
//STRIP001 
//STRIP001 	// gibt es unterschiede?
//STRIP001 	BOOL HasDiffs( const CompareData& rData ) const;
//STRIP001 
//STRIP001 	// startet das Vergleichen und Erzeugen der Unterschiede zweier
//STRIP001 	// Dokumente
//STRIP001 	void CompareLines( CompareData& rData );
//STRIP001 	// lasse die Unterschiede anzeigen - ruft die beiden Methoden
//STRIP001 	// ShowInsert / ShowDelete. Diese bekommen die Start und EndLine-Nummer
//STRIP001 	// uebergeben. Die Abbildung auf den tatsaechline Inhalt muss die
//STRIP001 	// Ableitung uebernehmen!
//STRIP001 	ULONG ShowDiffs( const CompareData& rData );
//STRIP001 
//STRIP001 	virtual void ShowInsert( ULONG nStt, ULONG nEnd );
//STRIP001 	virtual void ShowDelete( const CompareData& rData, ULONG nStt,
//STRIP001 								ULONG nEnd, ULONG nInsPos );
//STRIP001 	virtual void CheckForChangesInLine( const CompareData& rData,
//STRIP001 									ULONG& nStt, ULONG& nEnd,
//STRIP001 									ULONG& nThisStt, ULONG& nThisEnd );
//STRIP001 
//STRIP001 	// Eindeutigen Index fuer eine Line setzen. Gleiche Lines haben den
//STRIP001 	// selben Index; auch in den anderen CompareData!
//STRIP001 	void SetIndex( ULONG nLine, ULONG nIndex );
//STRIP001 	ULONG GetIndex( ULONG nLine ) const
//STRIP001 		{ return nLine < aLines.Count() ? pIndex[ nLine ] : 0; }
//STRIP001 
//STRIP001 	// setze/erfrage ob eine Zeile veraendert ist
//STRIP001 	void SetChanged( ULONG nLine, BOOL bFlag = TRUE );
//STRIP001 	BOOL GetChanged( ULONG nLine ) const
//STRIP001 		{
//STRIP001 			return (pChangedFlag && nLine < aLines.Count())
//STRIP001 				? pChangedFlag[ nLine ]
//STRIP001 				: 0;
//STRIP001 		}
//STRIP001 
//STRIP001 	ULONG GetLineCount() const		{ return aLines.Count(); }
//STRIP001 	ULONG GetLineOffset() const  	{ return nSttLineNum; }
//STRIP001 	const CompareLine* GetLine( ULONG nLine ) const
//STRIP001 			{ return aLines.GetObject( nLine ); }
//STRIP001 	void InsertLine( CompareLine* pLine )
//STRIP001 		{ aLines.Insert( pLine, LIST_APPEND ); }
//STRIP001 };

//STRIP001 class Hash
//STRIP001 {
//STRIP001 	struct _HashData
//STRIP001 	{
//STRIP001 		ULONG nNext, nHash;
//STRIP001 		const CompareLine* pLine;
//STRIP001 
//STRIP001 		_HashData()
//STRIP001 			: nNext( 0 ), nHash( 0 ), pLine(0) {}
//STRIP001 	};
//STRIP001 
//STRIP001 	ULONG* pHashArr;
//STRIP001 	_HashData* pDataArr;
//STRIP001 	ULONG nCount, nPrime;
//STRIP001 
//STRIP001 public:
//STRIP001 	Hash( ULONG nSize );
//STRIP001 	~Hash();
//STRIP001 
//STRIP001 	void CalcHashValue( CompareData& rData );
//STRIP001 
//STRIP001 	ULONG GetCount() const { return nCount; }
//STRIP001 };

//STRIP001 class Compare
//STRIP001 {
//STRIP001 public:
//STRIP001 	class MovedData
//STRIP001 	{
//STRIP001 		ULONG* pIndex;
//STRIP001 		ULONG* pLineNum;
//STRIP001 		ULONG nCount;
//STRIP001 
//STRIP001 	public:
//STRIP001 		MovedData( CompareData& rData, sal_Char* pDiscard );
//STRIP001 		~MovedData();
//STRIP001 
//STRIP001 		ULONG GetIndex( ULONG n ) const { return pIndex[ n ]; }
//STRIP001 		ULONG GetLineNum( ULONG n ) const { return pLineNum[ n ]; }
//STRIP001 		ULONG GetCount() const { return nCount; }
//STRIP001 	};
//STRIP001 
//STRIP001 private:
//STRIP001 	// Suche die verschobenen Lines
//STRIP001 	class CompareSequence
//STRIP001 	{
//STRIP001 		CompareData &rData1, &rData2;
//STRIP001 		const MovedData &rMoved1, &rMoved2;
//STRIP001 		long *pMemory, *pFDiag, *pBDiag;
//STRIP001 
//STRIP001 		void Compare( ULONG nStt1, ULONG nEnd1, ULONG nStt2, ULONG nEnd2 );
//STRIP001 		ULONG CheckDiag( ULONG nStt1, ULONG nEnd1,
//STRIP001 						ULONG nStt2, ULONG nEnd2, ULONG* pCost );
//STRIP001 	public:
//STRIP001 		CompareSequence( CompareData& rData1, CompareData& rData2,
//STRIP001 						const MovedData& rD1, const MovedData& rD2 );
//STRIP001 		~CompareSequence();
//STRIP001 	};
//STRIP001 
//STRIP001 
//STRIP001 	static void CountDifference( const CompareData& rData, ULONG* pCounts );
//STRIP001 	static void SetDiscard( const CompareData& rData,
//STRIP001 							sal_Char* pDiscard, ULONG* pCounts );
//STRIP001 	static void CheckDiscard( ULONG nLen, sal_Char* pDiscard );
//STRIP001 	static ULONG SetChangedFlag( CompareData& rData, sal_Char* pDiscard, int bFirst );
//STRIP001 	static void ShiftBoundaries( CompareData& rData1, CompareData& rData2 );
//STRIP001 
//STRIP001 public:
//STRIP001 	Compare( ULONG nDiff, CompareData& rData1, CompareData& rData2 );
//STRIP001 };

// ====================================================================

//STRIP001 CompareLine::~CompareLine() {}

// ----------------------------------------------------------------------

//STRIP001 CompareData::CompareData()
//STRIP001 	: nSttLineNum( 0 ), pIndex( 0 ), pChangedFlag( 0 )
//STRIP001 {
//STRIP001 }

//STRIP001 CompareData::~CompareData()
//STRIP001 {
//STRIP001 	   delete[] pIndex;
//STRIP001     delete[] pChangedFlag;
//STRIP001 }

//STRIP001 void CompareData::SetIndex( ULONG nLine, ULONG nIndex )
//STRIP001 {
//STRIP001 	if( !pIndex )
//STRIP001 	{
//STRIP001 		pIndex = new ULONG[ aLines.Count() ];
//STRIP001 		memset( pIndex, 0, aLines.Count() * sizeof( ULONG ) );
//STRIP001 	}
//STRIP001 	if( nLine < aLines.Count() )
//STRIP001 		pIndex[ nLine ] = nIndex;
//STRIP001 }

//STRIP001 void CompareData::SetChanged( ULONG nLine, BOOL bFlag )
//STRIP001 {
//STRIP001 	if( !pChangedFlag )
//STRIP001 	{
//STRIP001 		pChangedFlag = new BOOL[ aLines.Count() +1 ];
//STRIP001 		memset( pChangedFlag, 0, aLines.Count() +1 * sizeof( BOOL ) );
//STRIP001 	}
//STRIP001 	if( nLine < aLines.Count() )
//STRIP001 		pChangedFlag[ nLine ] = bFlag;
//STRIP001 }

//STRIP001 void CompareData::CompareLines( CompareData& rData )
//STRIP001 {
//STRIP001 	CheckRanges( rData );
//STRIP001 
//STRIP001 	ULONG nDifferent;
//STRIP001 	{
//STRIP001 		Hash aH( GetLineCount() + rData.GetLineCount() + 1 );
//STRIP001 		aH.CalcHashValue( *this );
//STRIP001 		aH.CalcHashValue( rData );
//STRIP001 		nDifferent = aH.GetCount();
//STRIP001 	}
//STRIP001 	{
//STRIP001 		Compare aComp( nDifferent, *this, rData );
//STRIP001 	}
//STRIP001 }

//STRIP001 ULONG CompareData::ShowDiffs( const CompareData& rData )
//STRIP001 {
//STRIP001 	ULONG nLen1 = rData.GetLineCount(), nLen2 = GetLineCount();
//STRIP001 	ULONG nStt1 = 0, nStt2 = 0;
//STRIP001 	ULONG nCnt = 0;
//STRIP001 
//STRIP001 	while( nStt1 < nLen1 || nStt2 < nLen2 )
//STRIP001 	{
//STRIP001 		if( rData.GetChanged( nStt1 ) || GetChanged( nStt2 ) )
//STRIP001 		{
//STRIP001 			ULONG nSav1 = nStt1, nSav2 = nStt2;
//STRIP001 			while( nStt1 < nLen1 && rData.GetChanged( nStt1 )) ++nStt1;
//STRIP001 			while( nStt2 < nLen2 && GetChanged( nStt2 )) ++nStt2;
//STRIP001 
//STRIP001 			// rData ist das Original,
//STRIP001 			// this ist das, in das die Veraenderungen sollen
//STRIP001 			if( nSav2 != nStt2 && nSav1 != nStt1 )
//STRIP001 				CheckForChangesInLine( rData, nSav1, nStt1, nSav2, nStt2 );
//STRIP001 
//STRIP001 			if( nSav2 != nStt2 )
//STRIP001 				ShowInsert( nSav2, nStt2 );
//STRIP001 
//STRIP001 			if( nSav1 != nStt1 )
//STRIP001 				ShowDelete( rData, nSav1, nStt1, nStt2 );
//STRIP001 			++nCnt;
//STRIP001 		}
//STRIP001 		++nStt1, ++nStt2;
//STRIP001 	}
//STRIP001 	return nCnt;
//STRIP001 }

//STRIP001 BOOL CompareData::HasDiffs( const CompareData& rData ) const
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	ULONG nLen1 = rData.GetLineCount(), nLen2 = GetLineCount();
//STRIP001 	ULONG nStt1 = 0, nStt2 = 0;
//STRIP001 
//STRIP001 	while( nStt1 < nLen1 || nStt2 < nLen2 )
//STRIP001 	{
//STRIP001 		if( rData.GetChanged( nStt1 ) || GetChanged( nStt2 ) )
//STRIP001 		{
//STRIP001 			bRet = TRUE;
//STRIP001 			break;
//STRIP001 		}
//STRIP001 		++nStt1, ++nStt2;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 void CompareData::ShowInsert( ULONG nStt, ULONG nEnd )
//STRIP001 {
//STRIP001 }

//STRIP001 void CompareData::ShowDelete( const CompareData& rData, ULONG nStt,
//STRIP001 								ULONG nEnd, ULONG nInsPos )
//STRIP001 {
//STRIP001 }

//STRIP001 void CompareData::CheckForChangesInLine( const CompareData& ,
//STRIP001 									ULONG&, ULONG&, ULONG&, ULONG& )
//STRIP001 {
//STRIP001 }

// ----------------------------------------------------------------------

//STRIP001 Hash::Hash( ULONG nSize )
//STRIP001 	: nCount( 1 )
//STRIP001 {
//STRIP001 
//STRIP001 static const ULONG primes[] =
//STRIP001 {
//STRIP001   509,
//STRIP001   1021,
//STRIP001   2039,
//STRIP001   4093,
//STRIP001   8191,
//STRIP001   16381,
//STRIP001   32749,
//STRIP001   65521,
//STRIP001   131071,
//STRIP001   262139,
//STRIP001   524287,
//STRIP001   1048573,
//STRIP001   2097143,
//STRIP001   4194301,
//STRIP001   8388593,
//STRIP001   16777213,
//STRIP001   33554393,
//STRIP001   67108859,			/* Preposterously large . . . */
//STRIP001   134217689,
//STRIP001   268435399,
//STRIP001   536870909,
//STRIP001   1073741789,
//STRIP001   2147483647,
//STRIP001   0
//STRIP001 };
//STRIP001 
//STRIP001 	pDataArr = new _HashData[ nSize ];
//STRIP001 	pDataArr[0].nNext = 0;
//STRIP001 	pDataArr[0].nHash = 0,
//STRIP001 	pDataArr[0].pLine = 0;
//STRIP001 
//STRIP001 	for( int i = 0; primes[i] < nSize / 3;  i++)
//STRIP001 		if( !primes[i] )
//STRIP001 		{
//STRIP001 			pHashArr = 0;
//STRIP001 			return;
//STRIP001 		}
//STRIP001 	nPrime = primes[ i ];
//STRIP001 	pHashArr = new ULONG[ nPrime ];
//STRIP001 	memset( pHashArr, 0, nPrime * sizeof( ULONG ) );
//STRIP001 }

//STRIP001 Hash::~Hash()
//STRIP001 {
//STRIP001     delete[] pHashArr;
//STRIP001     delete[] pDataArr;
//STRIP001 }

//STRIP001 void Hash::CalcHashValue( CompareData& rData )
//STRIP001 {
//STRIP001 	if( pHashArr )
//STRIP001 	{
//STRIP001 		for( ULONG n = 0; n < rData.GetLineCount(); ++n )
//STRIP001 		{
//STRIP001 			const CompareLine* pLine = rData.GetLine( n );
//STRIP001 			ASSERT( pLine, "wo ist die Line?" );
//STRIP001 			ULONG nH = pLine->GetHashValue();
//STRIP001 
//STRIP001 			ULONG* pFound = &pHashArr[ nH % nPrime ];
//STRIP001 			for( ULONG i = *pFound;  ;  i = pDataArr[i].nNext )
//STRIP001 				if( !i )
//STRIP001 				{
//STRIP001 					i = nCount++;
//STRIP001 					pDataArr[i].nNext = *pFound;
//STRIP001 					pDataArr[i].nHash = nH;
//STRIP001 					pDataArr[i].pLine = pLine;
//STRIP001 					*pFound = i;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 				else if( pDataArr[i].nHash == nH &&
//STRIP001 						pDataArr[i].pLine->Compare( *pLine ))
//STRIP001 					break;
//STRIP001 
//STRIP001 			rData.SetIndex( n, i );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// ----------------------------------------------------------------------

//STRIP001 Compare::Compare( ULONG nDiff, CompareData& rData1, CompareData& rData2 )
//STRIP001 {
//STRIP001 	MovedData *pMD1, *pMD2;
//STRIP001 	// Suche die unterschiedlichen Lines
//STRIP001 	{
//STRIP001 		sal_Char* pDiscard1 = new sal_Char[ rData1.GetLineCount() ];
//STRIP001 		sal_Char* pDiscard2 = new sal_Char[ rData2.GetLineCount() ];
//STRIP001 
//STRIP001 		ULONG* pCount1 = new ULONG[ nDiff ];
//STRIP001 		ULONG* pCount2 = new ULONG[ nDiff ];
//STRIP001 		memset( pCount1, 0, nDiff * sizeof( ULONG ));
//STRIP001 		memset( pCount2, 0, nDiff * sizeof( ULONG ));
//STRIP001 
//STRIP001 		// stelle fest, welche Indizies in den CompareData mehrfach vergeben wurden
//STRIP001 		CountDifference( rData1, pCount1 );
//STRIP001 		CountDifference( rData2, pCount2 );
//STRIP001 
//STRIP001 		// alle die jetzt nur einmal vorhanden sind, sind eingefuegt oder
//STRIP001 		// geloescht worden. Alle die im anderen auch vorhanden sind, sind
//STRIP001 		// verschoben worden
//STRIP001 		SetDiscard( rData1, pDiscard1, pCount2 );
//STRIP001 		SetDiscard( rData2, pDiscard2, pCount1 );
//STRIP001 
//STRIP001 		// die Arrays koennen wir wieder vergessen
//STRIP001 		delete pCount1; delete pCount2;
//STRIP001 
//STRIP001 		CheckDiscard( rData1.GetLineCount(), pDiscard1 );
//STRIP001 		CheckDiscard( rData2.GetLineCount(), pDiscard2 );
//STRIP001 
//STRIP001 		pMD1 = new MovedData( rData1, pDiscard1 );
//STRIP001 		pMD2 = new MovedData( rData2, pDiscard2 );
//STRIP001 
//STRIP001 		// die Arrays koennen wir wieder vergessen
//STRIP001 		delete pDiscard1; delete pDiscard2;
//STRIP001 	}
//STRIP001 
//STRIP001 	{
//STRIP001 		CompareSequence aTmp( rData1, rData2, *pMD1, *pMD2 );
//STRIP001 	}
//STRIP001 
//STRIP001 	ShiftBoundaries( rData1, rData2 );
//STRIP001 
//STRIP001 	delete pMD1;
//STRIP001 	delete pMD2;
//STRIP001 }



//STRIP001 void Compare::CountDifference( const CompareData& rData, ULONG* pCounts )
//STRIP001 {
//STRIP001 	ULONG nLen = rData.GetLineCount();
//STRIP001 	for( ULONG n = 0; n < nLen; ++n )
//STRIP001 	{
//STRIP001 		ULONG nIdx = rData.GetIndex( n );
//STRIP001 		++pCounts[ nIdx ];
//STRIP001 	}
//STRIP001 }

//STRIP001 void Compare::SetDiscard( const CompareData& rData,
//STRIP001 							sal_Char* pDiscard, ULONG* pCounts )
//STRIP001 {
//STRIP001 	ULONG nLen = rData.GetLineCount();
//STRIP001 
//STRIP001 	// berechne Max in Abhanegigkeit zur LineAnzahl
//STRIP001 	USHORT nMax = 5;
//STRIP001 	for( ULONG n = nLen / 64; ( n = n >> 2 ) > 0; )
//STRIP001 		nMax <<= 1;
//STRIP001 
//STRIP001 	for( n = 0; n < nLen; ++n )
//STRIP001 	{
//STRIP001 		ULONG nIdx = rData.GetIndex( n );
//STRIP001 		if( nIdx )
//STRIP001 		{
//STRIP001 			nIdx = pCounts[ nIdx ];
//STRIP001 			pDiscard[ n ] = !nIdx ? 1 : nIdx > nMax ? 2 : 0;
//STRIP001 		}
//STRIP001 		else
//STRIP001 			pDiscard[ n ] = 0;
//STRIP001 	}
//STRIP001 }

//STRIP001 void Compare::CheckDiscard( ULONG nLen, sal_Char* pDiscard )
//STRIP001 {
//STRIP001 	for( ULONG n = 0; n < nLen; ++n )
//STRIP001 	{
//STRIP001 		if( 2 == pDiscard[ n ] )
//STRIP001 			pDiscard[n] = 0;
//STRIP001 		else if( pDiscard[ n ] )
//STRIP001 		{
//STRIP001 			register ULONG j;
//STRIP001 			ULONG length;
//STRIP001 			ULONG provisional = 0;
//STRIP001 
//STRIP001 			/* Find end of this run of discardable lines.
//STRIP001 				Count how many are provisionally discardable.  */
//STRIP001 			for (j = n; j < nLen; j++)
//STRIP001 			{
//STRIP001 				if( !pDiscard[j] )
//STRIP001 					break;
//STRIP001 				if( 2 == pDiscard[j] )
//STRIP001 					++provisional;
//STRIP001 			}
//STRIP001 
//STRIP001 			/* Cancel provisional discards at end, and shrink the run.  */
//STRIP001 			while( j > n && 2 == pDiscard[j - 1] )
//STRIP001 				pDiscard[ --j ] = 0, --provisional;
//STRIP001 
//STRIP001 			/* Now we have the length of a run of discardable lines
//STRIP001 			   whose first and last are not provisional.  */
//STRIP001 			length = j - n;
//STRIP001 
//STRIP001 			/* If 1/4 of the lines in the run are provisional,
//STRIP001 			   cancel discarding of all provisional lines in the run.  */
//STRIP001 			if (provisional * 4 > length)
//STRIP001 			{
//STRIP001 				while (j > n)
//STRIP001 					if (pDiscard[--j] == 2)
//STRIP001 						pDiscard[j] = 0;
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				register ULONG consec;
//STRIP001 				ULONG minimum = 1;
//STRIP001 				ULONG tem = length / 4;
//STRIP001 
//STRIP001 				/* MINIMUM is approximate square root of LENGTH/4.
//STRIP001 				   A subrun of two or more provisionals can stand
//STRIP001 				   when LENGTH is at least 16.
//STRIP001 				   A subrun of 4 or more can stand when LENGTH >= 64.  */
//STRIP001 				while ((tem = tem >> 2) > 0)
//STRIP001 					minimum *= 2;
//STRIP001 				minimum++;
//STRIP001 
//STRIP001 				/* Cancel any subrun of MINIMUM or more provisionals
//STRIP001 				   within the larger run.  */
//STRIP001 				for (j = 0, consec = 0; j < length; j++)
//STRIP001 					if (pDiscard[n + j] != 2)
//STRIP001 						consec = 0;
//STRIP001 					else if (minimum == ++consec)
//STRIP001 						/* Back up to start of subrun, to cancel it all.  */
//STRIP001 						j -= consec;
//STRIP001 					else if (minimum < consec)
//STRIP001 						pDiscard[n + j] = 0;
//STRIP001 
//STRIP001 				/* Scan from beginning of run
//STRIP001 				   until we find 3 or more nonprovisionals in a row
//STRIP001 				   or until the first nonprovisional at least 8 lines in.
//STRIP001 				   Until that point, cancel any provisionals.  */
//STRIP001 				for (j = 0, consec = 0; j < length; j++)
//STRIP001 				{
//STRIP001 					if (j >= 8 && pDiscard[n + j] == 1)
//STRIP001 						break;
//STRIP001 					if (pDiscard[n + j] == 2)
//STRIP001 						consec = 0, pDiscard[n + j] = 0;
//STRIP001 					else if (pDiscard[n + j] == 0)
//STRIP001 						consec = 0;
//STRIP001 					else
//STRIP001 						consec++;
//STRIP001 					if (consec == 3)
//STRIP001 						break;
//STRIP001 				}
//STRIP001 
//STRIP001 				/* I advances to the last line of the run.  */
//STRIP001 				n += length - 1;
//STRIP001 
//STRIP001 				/* Same thing, from end.  */
//STRIP001 				for (j = 0, consec = 0; j < length; j++)
//STRIP001 				{
//STRIP001 					if (j >= 8 && pDiscard[n - j] == 1)
//STRIP001 						break;
//STRIP001 					if (pDiscard[n - j] == 2)
//STRIP001 						consec = 0, pDiscard[n - j] = 0;
//STRIP001 					else if (pDiscard[n - j] == 0)
//STRIP001 						consec = 0;
//STRIP001 					else
//STRIP001 						consec++;
//STRIP001 					if (consec == 3)
//STRIP001 						break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// ----------------------------------------------------------------------

//STRIP001 Compare::MovedData::MovedData( CompareData& rData, sal_Char* pDiscard )
//STRIP001 	: pIndex( 0 ), pLineNum( 0 ), nCount( 0 )
//STRIP001 {
//STRIP001 	ULONG nLen = rData.GetLineCount();
//STRIP001 	for( ULONG n = 0; n < nLen; ++n )
//STRIP001 		if( pDiscard[ n ] )
//STRIP001 			rData.SetChanged( n );
//STRIP001 		else
//STRIP001 			++nCount;
//STRIP001 
//STRIP001 	if( nCount )
//STRIP001 	{
//STRIP001 		pIndex = new ULONG[ nCount ];
//STRIP001 		pLineNum = new ULONG[ nCount ];
//STRIP001 
//STRIP001 		for( n = 0, nCount = 0; n < nLen; ++n )
//STRIP001 			if( !pDiscard[ n ] )
//STRIP001 			{
//STRIP001 				pIndex[ nCount ] = rData.GetIndex( n );
//STRIP001 				pLineNum[ nCount++ ] = n;
//STRIP001 			}
//STRIP001 	}
//STRIP001 }

//STRIP001 Compare::MovedData::~MovedData()
//STRIP001 {
//STRIP001 	delete pIndex;
//STRIP001 	delete pLineNum;
//STRIP001 }

// ----------------------------------------------------------------------

	// Suche die verschobenen Lines
//STRIP001 Compare::CompareSequence::CompareSequence(
//STRIP001 							CompareData& rD1, CompareData& rD2,
//STRIP001 							const MovedData& rMD1, const MovedData& rMD2 )
//STRIP001 	: rData1( rD1 ), rData2( rD2 ), rMoved1( rMD1 ), rMoved2( rMD2 )
//STRIP001 {
//STRIP001 	ULONG nSize = rMD1.GetCount() + rMD2.GetCount() + 3;
//STRIP001 	pMemory = new long[ nSize * 2 ];
//STRIP001 	pFDiag = pMemory + ( rMD2.GetCount() + 1 );
//STRIP001 	pBDiag = pMemory + ( nSize + rMD2.GetCount() + 1 );
//STRIP001 
//STRIP001 	Compare( 0, rMD1.GetCount(), 0, rMD2.GetCount() );
//STRIP001 }

//STRIP001 Compare::CompareSequence::~CompareSequence()
//STRIP001 {
//STRIP001 	delete pMemory;
//STRIP001 }

//STRIP001 void Compare::CompareSequence::Compare( ULONG nStt1, ULONG nEnd1,
//STRIP001 										ULONG nStt2, ULONG nEnd2 )
//STRIP001 {
//STRIP001 	/* Slide down the bottom initial diagonal. */
//STRIP001 	while( nStt1 < nEnd1 && nStt2 < nEnd2 &&
//STRIP001 		rMoved1.GetIndex( nStt1 ) == rMoved2.GetIndex( nStt2 ))
//STRIP001 		++nStt1, ++nStt2;
//STRIP001 
//STRIP001 	/* Slide up the top initial diagonal. */
//STRIP001 	while( nEnd1 > nStt1 && nEnd2 > nStt2 &&
//STRIP001 		rMoved1.GetIndex( nEnd1 - 1 ) == rMoved2.GetIndex( nEnd2 - 1 ))
//STRIP001 		--nEnd1, --nEnd2;
//STRIP001 
//STRIP001 	/* Handle simple cases. */
//STRIP001 	if( nStt1 == nEnd1 )
//STRIP001 		while( nStt2 < nEnd2 )
//STRIP001 			rData2.SetChanged( rMoved2.GetLineNum( nStt2++ ));
//STRIP001 
//STRIP001 	else if (nStt2 == nEnd2)
//STRIP001 		while (nStt1 < nEnd1)
//STRIP001 			rData1.SetChanged( rMoved1.GetLineNum( nStt1++ ));
//STRIP001 
//STRIP001 	else
//STRIP001 	{
//STRIP001 		ULONG c, d, b;
//STRIP001 
//STRIP001 		/* Find a point of correspondence in the middle of the files.  */
//STRIP001 
//STRIP001 		d = CheckDiag( nStt1, nEnd1, nStt2, nEnd2, &c );
//STRIP001 		b = pBDiag[ d ];
//STRIP001 
//STRIP001 		if( 1 != c )
//STRIP001 		{
//STRIP001 			/* Use that point to split this problem into two subproblems.  */
//STRIP001 			Compare( nStt1, b, nStt2, b - d );
//STRIP001 			/* This used to use f instead of b,
//STRIP001 			   but that is incorrect!
//STRIP001 			   It is not necessarily the case that diagonal d
//STRIP001 			   has a snake from b to f.  */
//STRIP001 			Compare( b, nEnd1, b - d, nEnd2 );
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 ULONG Compare::CompareSequence::CheckDiag( ULONG nStt1, ULONG nEnd1,
//STRIP001 									ULONG nStt2, ULONG nEnd2, ULONG* pCost )
//STRIP001 {
//STRIP001 	const long dmin = nStt1 - nEnd2;	/* Minimum valid diagonal. */
//STRIP001 	const long dmax = nEnd1 - nStt2;	/* Maximum valid diagonal. */
//STRIP001 	const long fmid = nStt1 - nStt2;	/* Center diagonal of top-down search. */
//STRIP001 	const long bmid = nEnd1 - nEnd2;	/* Center diagonal of bottom-up search. */
//STRIP001 
//STRIP001 	long fmin = fmid, fmax = fmid;	/* Limits of top-down search. */
//STRIP001 	long bmin = bmid, bmax = bmid;	/* Limits of bottom-up search. */
//STRIP001 
//STRIP001 	long c;			/* Cost. */
//STRIP001 	long odd = (fmid - bmid) & 1;	/* True if southeast corner is on an odd
//STRIP001 					 diagonal with respect to the northwest. */
//STRIP001 
//STRIP001 	pFDiag[fmid] = nStt1;
//STRIP001 	pBDiag[bmid] = nEnd1;
//STRIP001 
//STRIP001 	for (c = 1;; ++c)
//STRIP001 	{
//STRIP001 		long d;			/* Active diagonal. */
//STRIP001 		long big_snake = 0;
//STRIP001 
//STRIP001 		/* Extend the top-down search by an edit step in each diagonal. */
//STRIP001 		fmin > dmin ? pFDiag[--fmin - 1] = -1 : ++fmin;
//STRIP001 		fmax < dmax ? pFDiag[++fmax + 1] = -1 : --fmax;
//STRIP001 		for (d = fmax; d >= fmin; d -= 2)
//STRIP001 		{
//STRIP001 			long x, y, oldx, tlo = pFDiag[d - 1], thi = pFDiag[d + 1];
//STRIP001 
//STRIP001 			if (tlo >= thi)
//STRIP001 				x = tlo + 1;
//STRIP001 			else
//STRIP001 				x = thi;
//STRIP001 			oldx = x;
//STRIP001 			y = x - d;
//STRIP001 			while( ULONG(x) < nEnd1 && ULONG(y) < nEnd2 &&
//STRIP001 				rMoved1.GetIndex( x ) == rMoved2.GetIndex( y ))
//STRIP001 				++x, ++y;
//STRIP001 			if (x - oldx > 20)
//STRIP001 				big_snake = 1;
//STRIP001 			pFDiag[d] = x;
//STRIP001 			if( odd && bmin <= d && d <= bmax && pBDiag[d] <= pFDiag[d] )
//STRIP001 			{
//STRIP001 				*pCost = 2 * c - 1;
//STRIP001 				return d;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		/* Similar extend the bottom-up search. */
//STRIP001 		bmin > dmin ? pBDiag[--bmin - 1] = INT_MAX : ++bmin;
//STRIP001 		bmax < dmax ? pBDiag[++bmax + 1] = INT_MAX : --bmax;
//STRIP001 		for (d = bmax; d >= bmin; d -= 2)
//STRIP001 		{
//STRIP001 			long x, y, oldx, tlo = pBDiag[d - 1], thi = pBDiag[d + 1];
//STRIP001 
//STRIP001 			if (tlo < thi)
//STRIP001 				x = tlo;
//STRIP001 			else
//STRIP001 				x = thi - 1;
//STRIP001 			oldx = x;
//STRIP001 			y = x - d;
//STRIP001 			while( ULONG(x) > nStt1 && ULONG(y) > nStt2 &&
//STRIP001 				rMoved1.GetIndex( x - 1 ) == rMoved2.GetIndex( y - 1 ))
//STRIP001 				--x, --y;
//STRIP001 			if (oldx - x > 20)
//STRIP001 				big_snake = 1;
//STRIP001 			pBDiag[d] = x;
//STRIP001 			if (!odd && fmin <= d && d <= fmax && pBDiag[d] <= pFDiag[d])
//STRIP001 			{
//STRIP001 				*pCost = 2 * c;
//STRIP001 				return d;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

//STRIP001 void Compare::ShiftBoundaries( CompareData& rData1, CompareData& rData2 )
//STRIP001 {
//STRIP001 	for( int i = 0; i < 2; ++i )
//STRIP001 	{
//STRIP001 		CompareData* pData = &rData1;
//STRIP001 		CompareData* pOtherData = &rData2;
//STRIP001 
//STRIP001 		ULONG i = 0;
//STRIP001 		ULONG j = 0;
//STRIP001 		ULONG i_end = pData->GetLineCount();
//STRIP001 		ULONG preceding = ULONG_MAX;
//STRIP001 		ULONG other_preceding = ULONG_MAX;
//STRIP001 
//STRIP001 		while (1)
//STRIP001 		{
//STRIP001 			ULONG start, other_start;
//STRIP001 
//STRIP001 			/* Scan forwards to find beginning of another run of changes.
//STRIP001 			   Also keep track of the corresponding point in the other file.  */
//STRIP001 
//STRIP001 			while( i < i_end && !pData->GetChanged( i ) )
//STRIP001 			{
//STRIP001 				while( pOtherData->GetChanged( j++ ))
//STRIP001 					/* Non-corresponding lines in the other file
//STRIP001 					   will count as the preceding batch of changes.  */
//STRIP001 					other_preceding = j;
//STRIP001 				i++;
//STRIP001 			}
//STRIP001 
//STRIP001 			if (i == i_end)
//STRIP001 				break;
//STRIP001 
//STRIP001 			start = i;
//STRIP001 			other_start = j;
//STRIP001 
//STRIP001 			while (1)
//STRIP001 			{
//STRIP001 				/* Now find the end of this run of changes.  */
//STRIP001 
//STRIP001 				while( pData->GetChanged( ++i ))
//STRIP001 					;
//STRIP001 
//STRIP001 				/* If the first changed line matches the following unchanged one,
//STRIP001 				   and this run does not follow right after a previous run,
//STRIP001 				   and there are no lines deleted from the other file here,
//STRIP001 				   then classify the first changed line as unchanged
//STRIP001 				   and the following line as changed in its place.  */
//STRIP001 
//STRIP001 				/* You might ask, how could this run follow right after another?
//STRIP001 				   Only because the previous run was shifted here.  */
//STRIP001 
//STRIP001 				if( i != i_end &&
//STRIP001 					pData->GetIndex( start ) == pData->GetIndex( i ) &&
//STRIP001 					!pOtherData->GetChanged( j ) &&
//STRIP001 					!( start == preceding || other_start == other_preceding ))
//STRIP001 				{
//STRIP001 					pData->SetChanged( start++, 0 );
//STRIP001 					pData->SetChanged(  i );
//STRIP001 					/* Since one line-that-matches is now before this run
//STRIP001 					   instead of after, we must advance in the other file
//STRIP001 					   to keep in synch.  */
//STRIP001 					++j;
//STRIP001 				}
//STRIP001 				else
//STRIP001 					break;
//STRIP001 			}
//STRIP001 
//STRIP001 			preceding = i;
//STRIP001 			other_preceding = j;
//STRIP001 		}
//STRIP001 
//STRIP001 		pData = &rData2;
//STRIP001 		pOtherData = &rData1;
//STRIP001 	}
//STRIP001 }

/*  */

//STRIP001 class SwCompareLine : public CompareLine
//STRIP001 {
//STRIP001 	const SwNode& rNode;
//STRIP001 public:
//STRIP001 	SwCompareLine( const SwNode& rNd );
//STRIP001 	virtual ~SwCompareLine();
//STRIP001 
//STRIP001 	virtual ULONG GetHashValue() const;
//STRIP001 	virtual BOOL Compare( const CompareLine& rLine ) const;
//STRIP001 
//STRIP001 	static ULONG GetTxtNodeHashValue( const SwTxtNode& rNd, ULONG nVal );
//STRIP001 	static BOOL CompareNode( const SwNode& rDstNd, const SwNode& rSrcNd );
//STRIP001 	static BOOL CompareTxtNd( const SwTxtNode& rDstNd,
//STRIP001 							  const SwTxtNode& rSrcNd );
//STRIP001 
//STRIP001 	BOOL ChangesInLine( const SwCompareLine& rLine,
//STRIP001 							SwPaM *& rpInsRing, SwPaM*& rpDelRing ) const;
//STRIP001 
//STRIP001 	const SwNode& GetNode() const { return rNode; }
//STRIP001 
//STRIP001 	const SwNode& GetEndNode() const;
//STRIP001 
//STRIP001 	// fuers Debugging!
//STRIP001 	String GetText() const;
//STRIP001 };

//STRIP001 class SwCompareData : public CompareData
//STRIP001 {
//STRIP001 	SwDoc& rDoc;
//STRIP001 	SwPaM *pInsRing, *pDelRing;
//STRIP001 
//STRIP001 	ULONG PrevIdx( const SwNode* pNd );
//STRIP001 	ULONG NextIdx( const SwNode* pNd );
//STRIP001 
//STRIP001 	virtual void CheckRanges( CompareData& );
//STRIP001 	virtual void ShowInsert( ULONG nStt, ULONG nEnd );
//STRIP001 	virtual void ShowDelete( const CompareData& rData, ULONG nStt,
//STRIP001 								ULONG nEnd, ULONG nInsPos );
//STRIP001 
//STRIP001 	virtual void CheckForChangesInLine( const CompareData& rData,
//STRIP001 									ULONG& nStt, ULONG& nEnd,
//STRIP001 									ULONG& nThisStt, ULONG& nThisEnd );
//STRIP001 
//STRIP001 public:
//STRIP001 	SwCompareData( SwDoc& rD ) : rDoc( rD ), pInsRing(0), pDelRing(0) {}
//STRIP001 	virtual ~SwCompareData();
//STRIP001 
//STRIP001 	void SetRedlinesToDoc( BOOL bUseDocInfo, const SwDoc& rSrcDoc );
//STRIP001 };

// ----------------------------------------------------------------

//STRIP001 SwCompareLine::SwCompareLine( const SwNode& rNd )
//STRIP001 	: rNode( rNd )
//STRIP001 {
//STRIP001 }

//STRIP001 SwCompareLine::~SwCompareLine()
//STRIP001 {
//STRIP001 }

//STRIP001 ULONG SwCompareLine::GetHashValue() const
//STRIP001 {
//STRIP001 	ULONG nRet = 0;
//STRIP001 	switch( rNode.GetNodeType() )
//STRIP001 	{
//STRIP001 	case ND_TEXTNODE:
//STRIP001 		nRet = GetTxtNodeHashValue( (SwTxtNode&)rNode, nRet );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_TABLENODE:
//STRIP001 		{
//STRIP001 			const SwNode* pEndNd = rNode.EndOfSectionNode();
//STRIP001 			SwNodeIndex aIdx( rNode );
//STRIP001 			while( &aIdx.GetNode() != pEndNd )
//STRIP001 			{
//STRIP001 				if( aIdx.GetNode().IsTxtNode() )
//STRIP001 					nRet = GetTxtNodeHashValue( (SwTxtNode&)aIdx.GetNode(), nRet );
//STRIP001 				aIdx++;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_SECTIONNODE:
//STRIP001 		{
//STRIP001 			String sStr( GetText() );
//STRIP001 			for( xub_StrLen n = 0; n < sStr.Len(); ++n )
//STRIP001 				( nRet <<= 1 ) += sStr.GetChar( n );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_GRFNODE:
//STRIP001 	case ND_OLENODE:
//STRIP001 		// feste Id ? sollte aber nie auftauchen
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return nRet;
//STRIP001 }

//STRIP001 const SwNode& SwCompareLine::GetEndNode() const
//STRIP001 {
//STRIP001 	const SwNode* pNd = &rNode;
//STRIP001 	switch( rNode.GetNodeType() )
//STRIP001 	{
//STRIP001 	case ND_TABLENODE:
//STRIP001 		pNd = rNode.EndOfSectionNode();
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_SECTIONNODE:
//STRIP001 		{
//STRIP001 			const SwSectionNode& rSNd = (SwSectionNode&)rNode;
//STRIP001 			const SwSection& rSect = rSNd.GetSection();
//STRIP001 			if( CONTENT_SECTION != rSect.GetType() || rSect.IsProtect() )
//STRIP001 				pNd = rNode.EndOfSectionNode();
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return *pNd;
//STRIP001 }

//STRIP001 BOOL SwCompareLine::Compare( const CompareLine& rLine ) const
//STRIP001 {
//STRIP001 	return CompareNode( rNode, ((SwCompareLine&)rLine).rNode );
//STRIP001 }

//STRIP001 BOOL SwCompareLine::CompareNode( const SwNode& rDstNd, const SwNode& rSrcNd )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 
//STRIP001 	switch( ( rSrcNd.GetNodeType() * 256 ) + rDstNd.GetNodeType() )
//STRIP001 	{
//STRIP001 	case ( ND_TEXTNODE * 256 ) + ND_TEXTNODE:
//STRIP001 		bRet = CompareTxtNd( (SwTxtNode&)rDstNd, (SwTxtNode&)rSrcNd );
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ( ND_TABLENODE * 256 ) + ND_TABLENODE:
//STRIP001 		{
//STRIP001 			const SwTableNode& rTSrcNd = (SwTableNode&)rSrcNd;
//STRIP001 			const SwTableNode& rTDstNd = (SwTableNode&)rDstNd;
//STRIP001 
//STRIP001 			bRet = ( rTSrcNd.EndOfSectionIndex() - rTSrcNd.GetIndex() ) ==
//STRIP001 				   ( rTDstNd.EndOfSectionIndex() - rTDstNd.GetIndex() );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ( ND_SECTIONNODE * 256 ) + ND_SECTIONNODE:
//STRIP001 		{
//STRIP001 			const SwSectionNode& rSSrcNd = (SwSectionNode&)rSrcNd,
//STRIP001 							   & rSDstNd = (SwSectionNode&)rDstNd;
//STRIP001 			const SwSection& rSrcSect = rSSrcNd.GetSection(),
//STRIP001 						   & rDstSect = rSDstNd.GetSection();
//STRIP001 			SectionType eSrcSectType = rSrcSect.GetType(),
//STRIP001 						eDstSectType = rDstSect.GetType();
//STRIP001 			switch( eSrcSectType )
//STRIP001 			{
//STRIP001 			case CONTENT_SECTION:
//STRIP001 				bRet = CONTENT_SECTION == eDstSectType &&
//STRIP001 						rSrcSect.IsProtect() == rDstSect.IsProtect();
//STRIP001 				if( bRet && rSrcSect.IsProtect() )
//STRIP001 				{
//STRIP001 					// the only have they both the same size
//STRIP001 					bRet = ( rSSrcNd.EndOfSectionIndex() - rSSrcNd.GetIndex() ) ==
//STRIP001 				   		   ( rSDstNd.EndOfSectionIndex() - rSDstNd.GetIndex() );
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TOX_HEADER_SECTION:
//STRIP001 			case TOX_CONTENT_SECTION:
//STRIP001 				if( TOX_HEADER_SECTION == eDstSectType ||
//STRIP001 					TOX_CONTENT_SECTION == eDstSectType )
//STRIP001 				{
//STRIP001 					// the same type of TOX?
//STRIP001 					const SwTOXBase* pSrcTOX = rSrcSect.GetTOXBase();
//STRIP001 					const SwTOXBase* pDstTOX = rDstSect.GetTOXBase();
//STRIP001 					bRet =	pSrcTOX && pDstTOX
//STRIP001 							&& pSrcTOX->GetType() == pDstTOX->GetType()
//STRIP001 							&& pSrcTOX->GetTitle() == pDstTOX->GetTitle()
//STRIP001 							&& pSrcTOX->GetTypeName() == pDstTOX->GetTypeName()
//STRIP001 //							&& pSrcTOX->GetTOXName() == pDstTOX->GetTOXName()
//STRIP001 							;
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case DDE_LINK_SECTION:
//STRIP001 			case FILE_LINK_SECTION:
//STRIP001 				bRet = eSrcSectType == eDstSectType &&
//STRIP001 						rSrcSect.GetLinkFileName() ==
//STRIP001 						rDstSect.GetLinkFileName();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ( ND_ENDNODE * 256 ) + ND_ENDNODE:
//STRIP001 /*		if( rSrcNd.FindStartNode()->IsTableNode() &&
//STRIP001 			rDstNd.FindStartNode()->IsTableNode() )
//STRIP001 		{
//STRIP001 
//STRIP001 		}
//STRIP001 		else if( rSrcNd.FindStartNode()->IsTableNode() &&
//STRIP001 				 rDstNd.FindStartNode()->IsTableNode() )
//STRIP001 		{
//STRIP001 		}
//STRIP001 */		break;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 String SwCompareLine::GetText() const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	switch( rNode.GetNodeType() )
//STRIP001 	{
//STRIP001 	case ND_TEXTNODE:
//STRIP001 		sRet = ((SwTxtNode&)rNode).GetExpandTxt();
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_TABLENODE:
//STRIP001 		{
//STRIP001 			const SwNode* pEndNd = rNode.EndOfSectionNode();
//STRIP001 			SwNodeIndex aIdx( rNode );
//STRIP001 			while( &aIdx.GetNode() != pEndNd )
//STRIP001 			{
//STRIP001 				if( aIdx.GetNode().IsTxtNode() )
//STRIP001 				{
//STRIP001 					if( sRet.Len() )
//STRIP001 						sRet.Append( '\n' );
//STRIP001 					sRet.Append( ((SwTxtNode&)rNode).GetExpandTxt() );
//STRIP001 				}
//STRIP001 				aIdx++;
//STRIP001 			}
//STRIP001 			sRet.InsertAscii( "Tabelle: ", 0 );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_SECTIONNODE:
//STRIP001 		{
//STRIP001 			sRet.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Section - Node:" ));
//STRIP001 
//STRIP001 			const SwSectionNode& rSNd = (SwSectionNode&)rNode;
//STRIP001 			const SwSection& rSect = rSNd.GetSection();
//STRIP001 			switch( rSect.GetType() )
//STRIP001 			{
//STRIP001 			case CONTENT_SECTION:
//STRIP001 				if( rSect.IsProtect() )
//STRIP001 					sRet.Append( String::CreateFromInt32(
//STRIP001 							rSNd.EndOfSectionIndex() - rSNd.GetIndex() ));
//STRIP001 				break;
//STRIP001 
//STRIP001 			case TOX_HEADER_SECTION:
//STRIP001 			case TOX_CONTENT_SECTION:
//STRIP001 				{
//STRIP001 					const SwTOXBase* pTOX = rSect.GetTOXBase();
//STRIP001 					if( pTOX )
//STRIP001 						sRet.Append( pTOX->GetTitle() )
//STRIP001 							.Append( pTOX->GetTypeName() )
//STRIP001 //							.Append( pTOX->GetTOXName() )
//STRIP001 							.Append( String::CreateFromInt32( pTOX->GetType() ));
//STRIP001 				}
//STRIP001 				break;
//STRIP001 
//STRIP001 			case DDE_LINK_SECTION:
//STRIP001 			case FILE_LINK_SECTION:
//STRIP001 				sRet += rSect.GetLinkFileName();
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 
//STRIP001 	case ND_GRFNODE:
//STRIP001 		sRet.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "Grafik - Node:" ));
//STRIP001 		break;
//STRIP001 	case ND_OLENODE:
//STRIP001 		sRet.AssignAscii( RTL_CONSTASCII_STRINGPARAM( "OLE - Node:" ));
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }

//STRIP001 ULONG SwCompareLine::GetTxtNodeHashValue( const SwTxtNode& rNd, ULONG nVal )
//STRIP001 {
//STRIP001 	String sStr( rNd.GetExpandTxt() );
//STRIP001 	for( xub_StrLen n = 0; n < sStr.Len(); ++n )
//STRIP001 		( nVal <<= 1 ) += sStr.GetChar( n );
//STRIP001 	return nVal;
//STRIP001 }

//STRIP001 BOOL SwCompareLine::CompareTxtNd( const SwTxtNode& rDstNd,
//STRIP001 								  const SwTxtNode& rSrcNd )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	// erstmal ganz einfach!
//STRIP001 	if( rDstNd.GetTxt() == rSrcNd.GetTxt() )
//STRIP001 	{
//STRIP001 		// der Text ist gleich, aber sind die "Sonderattribute" (0xFF) auch
//STRIP001 		// dieselben??
//STRIP001 		bRet = TRUE;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

//STRIP001 BOOL SwCompareLine::ChangesInLine( const SwCompareLine& rLine,
//STRIP001 							SwPaM *& rpInsRing, SwPaM*& rpDelRing ) const
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( ND_TEXTNODE == rNode.GetNodeType() &&
//STRIP001 		ND_TEXTNODE == rLine.GetNode().GetNodeType() )
//STRIP001 	{
//STRIP001 		SwTxtNode& rDestNd = *(SwTxtNode*)rNode.GetTxtNode();
//STRIP001 		const SwTxtNode& rSrcNd = *rLine.GetNode().GetTxtNode();
//STRIP001 
//STRIP001 		xub_StrLen nDEnd = rDestNd.GetTxt().Len(), nSEnd = rSrcNd.GetTxt().Len();
//STRIP001 		for( xub_StrLen nStt = 0, nEnd = Min( nDEnd, nSEnd );
//STRIP001 			nStt < nEnd; ++nStt )
//STRIP001 			if( rDestNd.GetTxt().GetChar( nStt ) !=
//STRIP001 				rSrcNd.GetTxt().GetChar( nStt ) )
//STRIP001 				break;
//STRIP001 
//STRIP001 		while( nStt < nDEnd && nStt < nSEnd )
//STRIP001 		{
//STRIP001 			--nDEnd, --nSEnd;
//STRIP001 			if( rDestNd.GetTxt().GetChar( nDEnd ) !=
//STRIP001 				rSrcNd.GetTxt().GetChar( nSEnd ) )
//STRIP001 			{
//STRIP001 				++nDEnd, ++nSEnd;
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( nStt || !nDEnd || !nSEnd || nDEnd < rDestNd.GetTxt().Len() ||
//STRIP001 			nSEnd < rSrcNd.GetTxt().Len() )
//STRIP001 		{
//STRIP001 			// jetzt ist zwischen nStt bis nDEnd das neu eingefuegte
//STRIP001 			// und zwischen nStt und nSEnd das geloeschte
//STRIP001 			SwDoc* pDoc = rDestNd.GetDoc();
//STRIP001 			SwPaM aPam( rDestNd, nDEnd );
//STRIP001 			if( nStt != nDEnd )
//STRIP001 			{
//STRIP001 				SwPaM* pTmp = new SwPaM( *aPam.GetPoint(), rpInsRing );
//STRIP001 				if( !rpInsRing )
//STRIP001 					rpInsRing = pTmp;
//STRIP001 
//STRIP001 				pTmp->SetMark();
//STRIP001 				pTmp->GetMark()->nContent = nStt;
//STRIP001 			}
//STRIP001 
//STRIP001 			if( nStt != nSEnd )
//STRIP001 			{
//STRIP001 				{
//STRIP001 					BOOL bUndo = pDoc->DoesUndo();
//STRIP001 					pDoc->DoUndo( FALSE );
//STRIP001 					SwPaM aCpyPam( rSrcNd, nStt );
//STRIP001 					aCpyPam.SetMark();
//STRIP001 					aCpyPam.GetPoint()->nContent = nSEnd;
//STRIP001 					aCpyPam.GetDoc()->Copy( aCpyPam, *aPam.GetPoint() );
//STRIP001 					pDoc->DoUndo( bUndo );
//STRIP001 				}
//STRIP001 
//STRIP001 				SwPaM* pTmp = new SwPaM( *aPam.GetPoint(), rpDelRing );
//STRIP001 				if( !rpDelRing )
//STRIP001 					rpDelRing = pTmp;
//STRIP001 
//STRIP001 				pTmp->SetMark();
//STRIP001 				pTmp->GetMark()->nContent = nDEnd;
//STRIP001 
//STRIP001 				if( rpInsRing )
//STRIP001 				{
//STRIP001 					SwPaM* pCorr = (SwPaM*)rpInsRing->GetPrev();
//STRIP001 					if( *pCorr->GetPoint() == *pTmp->GetPoint() )
//STRIP001 						*pCorr->GetPoint() = *pTmp->GetMark();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }

// ----------------------------------------------------------------

//STRIP001 SwCompareData::~SwCompareData()
//STRIP001 {
//STRIP001 	if( pDelRing )
//STRIP001 	{
//STRIP001 		while( pDelRing->GetNext() != pDelRing )
//STRIP001 			delete pDelRing->GetNext();
//STRIP001 		delete pDelRing;
//STRIP001 	}
//STRIP001 	if( pInsRing )
//STRIP001 	{
//STRIP001 		while( pInsRing->GetNext() != pInsRing )
//STRIP001 			delete pInsRing->GetNext();
//STRIP001 		delete pInsRing;
//STRIP001 	}
//STRIP001 }

//STRIP001 ULONG SwCompareData::NextIdx( const SwNode* pNd )
//STRIP001 {
//STRIP001 	if( pNd->IsStartNode() )
//STRIP001 	{
//STRIP001 		const SwSectionNode* pSNd;
//STRIP001 		if( pNd->IsTableNode() ||
//STRIP001 			( 0 != (pSNd = pNd->GetSectionNode() ) &&
//STRIP001 				( CONTENT_SECTION != pSNd->GetSection().GetType() ||
//STRIP001 					pSNd->GetSection().IsProtect() ) ) )
//STRIP001 			pNd = pNd->EndOfSectionNode();
//STRIP001 	}
//STRIP001 	return pNd->GetIndex() + 1;
//STRIP001 }

//STRIP001 ULONG SwCompareData::PrevIdx( const SwNode* pNd )
//STRIP001 {
//STRIP001 	if( pNd->IsEndNode() )
//STRIP001 	{
//STRIP001 		const SwSectionNode* pSNd;
//STRIP001 		if( pNd->StartOfSectionNode()->IsTableNode() ||
//STRIP001 			( 0 != (pSNd = pNd->StartOfSectionNode()->GetSectionNode() ) &&
//STRIP001 				( CONTENT_SECTION != pSNd->GetSection().GetType() ||
//STRIP001 					pSNd->GetSection().IsProtect() ) ) )
//STRIP001 			pNd = pNd->StartOfSectionNode();
//STRIP001 	}
//STRIP001 	return pNd->GetIndex() - 1;
//STRIP001 }


//STRIP001 void SwCompareData::CheckRanges( CompareData& rData )
//STRIP001 {
//STRIP001 	const SwNodes& rSrcNds = ((SwCompareData&)rData).rDoc.GetNodes();
//STRIP001 	const SwNodes& rDstNds = rDoc.GetNodes();
//STRIP001 
//STRIP001 	const SwNode& rSrcEndNd = rSrcNds.GetEndOfContent();
//STRIP001 	const SwNode& rDstEndNd = rDstNds.GetEndOfContent();
//STRIP001 
//STRIP001 	ULONG nSrcSttIdx = NextIdx( rSrcEndNd.FindStartNode() );
//STRIP001 	ULONG nSrcEndIdx = rSrcEndNd.GetIndex();
//STRIP001 
//STRIP001 	ULONG nDstSttIdx = NextIdx( rDstEndNd.FindStartNode() );
//STRIP001 	ULONG nDstEndIdx = rDstEndNd.GetIndex();
//STRIP001 
//STRIP001 	while( nSrcSttIdx < nSrcEndIdx && nDstSttIdx < nDstEndIdx )
//STRIP001 	{
//STRIP001 		const SwNode* pSrcNd = rSrcNds[ nSrcSttIdx ];
//STRIP001 		const SwNode* pDstNd = rDstNds[ nDstSttIdx ];
//STRIP001 		if( !SwCompareLine::CompareNode( *pSrcNd, *pDstNd ))
//STRIP001 			break;
//STRIP001 
//STRIP001 		nSrcSttIdx = NextIdx( pSrcNd );
//STRIP001 		nDstSttIdx = NextIdx( pDstNd );
//STRIP001 	}
//STRIP001 
//STRIP001 	nSrcEndIdx = PrevIdx( &rSrcEndNd );
//STRIP001 	nDstEndIdx = PrevIdx( &rDstEndNd );
//STRIP001 	while( nSrcSttIdx < nSrcEndIdx && nDstSttIdx < nDstEndIdx )
//STRIP001 	{
//STRIP001 		const SwNode* pSrcNd = rSrcNds[ nSrcEndIdx ];
//STRIP001 		const SwNode* pDstNd = rDstNds[ nDstEndIdx ];
//STRIP001 		if( !SwCompareLine::CompareNode( *pSrcNd, *pDstNd ))
//STRIP001 			break;
//STRIP001 
//STRIP001 		nSrcEndIdx = PrevIdx( pSrcNd );
//STRIP001 		nDstEndIdx = PrevIdx( pDstNd );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( nSrcSttIdx <= nSrcEndIdx )
//STRIP001 	{
//STRIP001 		const SwNode* pNd = rSrcNds[ nSrcSttIdx ];
//STRIP001 		rData.InsertLine( new SwCompareLine( *pNd ) );
//STRIP001 		nSrcSttIdx = NextIdx( pNd );
//STRIP001 	}
//STRIP001 
//STRIP001 	while( nDstSttIdx <= nDstEndIdx )
//STRIP001 	{
//STRIP001 		const SwNode* pNd = rDstNds[ nDstSttIdx ];
//STRIP001 		InsertLine( new SwCompareLine( *pNd ) );
//STRIP001 		nDstSttIdx = NextIdx( pNd );
//STRIP001 	}
//STRIP001 }


//STRIP001 void SwCompareData::ShowInsert( ULONG nStt, ULONG nEnd )
//STRIP001 {
//STRIP001 	SwPaM* pTmp = new SwPaM( ((SwCompareLine*)GetLine( nStt ))->GetNode(), 0,
//STRIP001 							((SwCompareLine*)GetLine( nEnd-1 ))->GetEndNode(), 0,
//STRIP001 							 pInsRing );
//STRIP001 	if( !pInsRing )
//STRIP001 		pInsRing = pTmp;
//STRIP001 
//STRIP001 // vom Anfang des 1. Absatzes (1. Buchstabe) bis
//STRIP001 // zum letzten Absatz (letzter Buchstabe!)
//STRIP001 	pTmp->GetPoint()->nNode++;
//STRIP001 	pTmp->GetPoint()->nContent.Assign( pTmp->GetCntntNode(), 0 );
//STRIP001 }

//STRIP001 void SwCompareData::ShowDelete( const CompareData& rData, ULONG nStt,
//STRIP001 								ULONG nEnd, ULONG nInsPos )
//STRIP001 {
//STRIP001 	SwNodeRange aRg(
//STRIP001 		((SwCompareLine*)rData.GetLine( nStt ))->GetNode(), 0,
//STRIP001 		((SwCompareLine*)rData.GetLine( nEnd-1 ))->GetEndNode(), 1 );
//STRIP001 
//STRIP001 	USHORT nOffset = 0;
//STRIP001 	const CompareLine* pLine;
//STRIP001 	if( GetLineCount() == nInsPos )
//STRIP001 	{
//STRIP001 		pLine = GetLine( nInsPos-1 );
//STRIP001 		nOffset = 1;
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pLine = GetLine( nInsPos );
//STRIP001 
//STRIP001 	const SwNode* pLineNd;
//STRIP001 	if( pLine )
//STRIP001 	{
//STRIP001 		if( nOffset )
//STRIP001 			pLineNd = &((SwCompareLine*)pLine)->GetEndNode();
//STRIP001 		else
//STRIP001 			pLineNd = &((SwCompareLine*)pLine)->GetNode();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		pLineNd = &rDoc.GetNodes().GetEndOfContent();
//STRIP001 		nOffset = 0;
//STRIP001 	}
//STRIP001 
//STRIP001 	SwNodeIndex aInsPos( *pLineNd, nOffset );
//STRIP001 	SwNodeIndex aSavePos( aInsPos, -1 );
//STRIP001 
//STRIP001 	((SwCompareData&)rData).rDoc.CopyWithFlyInFly( aRg, aInsPos );
//STRIP001 	rDoc.SetModified();
//STRIP001 	aSavePos++;
//STRIP001 
//STRIP001 	SwPaM* pTmp = new SwPaM( aSavePos.GetNode(), aInsPos.GetNode(), 0, 0,
//STRIP001 								pDelRing );
//STRIP001 	if( !pDelRing )
//STRIP001 		pDelRing = pTmp;
//STRIP001 
//STRIP001 	if( pInsRing )
//STRIP001 	{
//STRIP001 		SwPaM* pCorr = (SwPaM*)pInsRing->GetPrev();
//STRIP001 		if( *pCorr->GetPoint() == *pTmp->GetPoint() )
//STRIP001 			*pCorr->GetPoint() = *pTmp->GetMark();
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwCompareData::CheckForChangesInLine( const CompareData& rData,
//STRIP001 									ULONG& rStt, ULONG& rEnd,
//STRIP001 									ULONG& rThisStt, ULONG& rThisEnd )
//STRIP001 {
//STRIP001 	while( rStt < rEnd && rThisStt < rThisEnd )
//STRIP001 	{
//STRIP001 		SwCompareLine* pDstLn = (SwCompareLine*)GetLine( rThisStt );
//STRIP001 		SwCompareLine* pSrcLn = (SwCompareLine*)rData.GetLine( rStt );
//STRIP001 		if( !pDstLn->ChangesInLine( *pSrcLn, pInsRing, pDelRing ) )
//STRIP001 			break;
//STRIP001 
//STRIP001 		++rStt;
//STRIP001 		++rThisStt;
//STRIP001 	}
//STRIP001 }

//STRIP001 void SwCompareData::SetRedlinesToDoc( BOOL bUseDocInfo, const SwDoc& rSrcDoc )
//STRIP001 {
//STRIP001 	SwPaM* pTmp = pDelRing;
//STRIP001 
//STRIP001 	// Bug #83296#: get the Author / TimeStamp from the "other"
//STRIP001 	//				document info
//STRIP001 	USHORT nAuthor = rDoc.GetRedlineAuthor();
//STRIP001 	DateTime aTimeStamp;
//STRIP001 	const SfxDocumentInfo* pDocInfo;
//STRIP001 	if( bUseDocInfo && 0 != (pDocInfo = rDoc.GetpInfo()) )
//STRIP001 	{
//STRIP001 		SfxStamp aTmp( 1 == pDocInfo->GetDocumentNumber()
//STRIP001 							? pDocInfo->GetCreated()
//STRIP001 							: pDocInfo->GetChanged() );
//STRIP001 		if( aTmp.GetName().Len() )
//STRIP001 		{
//STRIP001 			nAuthor = rDoc.InsertRedlineAuthor( aTmp.GetName() );
//STRIP001 			aTimeStamp = aTmp.GetTime();
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pTmp )
//STRIP001 	{
//STRIP001 		SwRedlineData aRedlnData( REDLINE_DELETE, nAuthor, aTimeStamp,
//STRIP001 									aEmptyStr, 0, 0 );
//STRIP001 		do {
//STRIP001 			rDoc.DeleteRedline( *pTmp, FALSE );
//STRIP001 
//STRIP001 			if( rDoc.DoesUndo() )
//STRIP001 				rDoc.AppendUndo( new SwUndoCompDoc( *pTmp, FALSE ));
//STRIP001 			rDoc.AppendRedline( new SwRedline( aRedlnData, *pTmp ) );
//STRIP001 
//STRIP001 		} while( pDelRing != ( pTmp = (SwPaM*)pTmp->GetNext() ));
//STRIP001 	}
//STRIP001 
//STRIP001 	pTmp = pInsRing;
//STRIP001 	if( pTmp )
//STRIP001 	{
//STRIP001 		SwRedlineData aRedlnData( REDLINE_INSERT, nAuthor, aTimeStamp,
//STRIP001 									aEmptyStr, 0, 0 );
//STRIP001 
//STRIP001 		// zusammenhaengende zusammenfassen
//STRIP001 		if( pTmp->GetNext() != pInsRing )
//STRIP001 		{
//STRIP001 			const SwCntntNode* pCNd;
//STRIP001 			do {
//STRIP001 				SwPosition& rSttEnd = *pTmp->End(),
//STRIP001 						  & rEndStt = *((SwPaM*)pTmp->GetNext())->Start();
//STRIP001 				if( rSttEnd == rEndStt ||
//STRIP001 					(!rEndStt.nContent.GetIndex() &&
//STRIP001 					rEndStt.nNode.GetIndex() - 1 == rSttEnd.nNode.GetIndex() &&
//STRIP001 					0 != ( pCNd = rSttEnd.nNode.GetNode().GetCntntNode() )
//STRIP001 						? rSttEnd.nContent.GetIndex() == pCNd->Len()
//STRIP001 						: 0 ))
//STRIP001 				{
//STRIP001 					if( pTmp->GetNext() == pInsRing )
//STRIP001 					{
//STRIP001 						// liegen hintereinander also zusammen fassen
//STRIP001 						rEndStt = *pTmp->Start();
//STRIP001 						delete pTmp;
//STRIP001 						pTmp = pInsRing;
//STRIP001 					}
//STRIP001 					else
//STRIP001 					{
//STRIP001 						// liegen hintereinander also zusammen fassen
//STRIP001 						rSttEnd = *((SwPaM*)pTmp->GetNext())->End();
//STRIP001 						delete pTmp->GetNext();
//STRIP001 					}
//STRIP001 				}
//STRIP001 				else
//STRIP001 					pTmp = (SwPaM*)pTmp->GetNext();
//STRIP001 			} while( pInsRing != pTmp );
//STRIP001 		}
//STRIP001 
//STRIP001 		do {
//STRIP001 			if( rDoc.AppendRedline( new SwRedline( aRedlnData, *pTmp )) &&
//STRIP001 				rDoc.DoesUndo() )
//STRIP001 				rDoc.AppendUndo( new SwUndoCompDoc( *pTmp, TRUE ));
//STRIP001 		} while( pInsRing != ( pTmp = (SwPaM*)pTmp->GetNext() ));
//STRIP001 	}
//STRIP001 }

/*  */



	// returnt (?die Anzahl der Unterschiede?) ob etwas unterschiedlich ist
//STRIP001 long SwDoc::CompareDoc( const SwDoc& rDoc )
//STRIP001 {
//STRIP001 	if( &rDoc == this )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	long nRet = 0;
//STRIP001 
//STRIP001 	StartUndo();
//STRIP001 	BOOL bDocWasModified = IsModified();
//STRIP001 	SwDoc& rSrcDoc = (SwDoc&)rDoc;
//STRIP001 	BOOL bSrcModified = rSrcDoc.IsModified();
//STRIP001 
//STRIP001 	SwRedlineMode eSrcRedlMode = rSrcDoc.GetRedlineMode();
//STRIP001 	rSrcDoc.SetRedlineMode( REDLINE_SHOW_INSERT );
//STRIP001 	SetRedlineMode( REDLINE_ON | REDLINE_SHOW_INSERT );
//STRIP001 
//STRIP001 	SwCompareData aD0( rSrcDoc );
//STRIP001 	SwCompareData aD1( *this );
//STRIP001 
//STRIP001 	aD1.CompareLines( aD0 );
//STRIP001 
//STRIP001 	nRet = aD1.ShowDiffs( aD0 );
//STRIP001 
//STRIP001 	if( nRet )
//STRIP001 	{
//STRIP001 		SetRedlineMode( REDLINE_ON | REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE );
//STRIP001 		aD1.SetRedlinesToDoc( !bDocWasModified, rSrcDoc );
//STRIP001 		SetModified();
//STRIP001 	}
//STRIP001 
//STRIP001 	rSrcDoc.SetRedlineMode( eSrcRedlMode );
//STRIP001 	SetRedlineMode( REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE );
//STRIP001 
//STRIP001 	if( !bSrcModified )
//STRIP001 		rSrcDoc.ResetModified();
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }


//STRIP001 typedef void (SwDoc::*FNInsUndo)( SwUndo* );

//STRIP001 class _SaveMergeRedlines : public Ring
//STRIP001 {
//STRIP001 	const SwRedline* pSrcRedl;
//STRIP001 	SwRedline* pDestRedl;
//STRIP001 public:
//STRIP001 	_SaveMergeRedlines( const SwNode& rDstNd,
//STRIP001 						const SwRedline& rSrcRedl, Ring* pRing );
//STRIP001 	USHORT InsertRedline( FNInsUndo pFn );
//STRIP001 
//STRIP001 	SwRedline* GetDestRedline() { return pDestRedl; }
//STRIP001 };

//STRIP001 _SaveMergeRedlines::_SaveMergeRedlines( const SwNode& rDstNd,
//STRIP001 						const SwRedline& rSrcRedl, Ring* pRing )
//STRIP001 	: Ring( pRing ), pSrcRedl( &rSrcRedl )
//STRIP001 {
//STRIP001 	SwPosition aPos( rDstNd );
//STRIP001 
//STRIP001 	const SwPosition* pStt = rSrcRedl.Start();
//STRIP001 	if( rDstNd.IsCntntNode() )
//STRIP001 		aPos.nContent.Assign( ((SwCntntNode*)&rDstNd), pStt->nContent.GetIndex() );
//STRIP001 	pDestRedl = new SwRedline( rSrcRedl.GetRedlineData(), aPos );
//STRIP001 
//STRIP001 	if( REDLINE_DELETE == pDestRedl->GetType() )
//STRIP001 	{
//STRIP001 		// den Bereich als geloescht kennzeichnen
//STRIP001 		const SwPosition* pEnd = pStt == rSrcRedl.GetPoint()
//STRIP001 											? rSrcRedl.GetMark()
//STRIP001 											: rSrcRedl.GetPoint();
//STRIP001 
//STRIP001 		pDestRedl->SetMark();
//STRIP001 		pDestRedl->GetPoint()->nNode += pEnd->nNode.GetIndex() -
//STRIP001 										pStt->nNode.GetIndex();
//STRIP001 		pDestRedl->GetPoint()->nContent.Assign( pDestRedl->GetCntntNode(),
//STRIP001 												pEnd->nContent.GetIndex() );
//STRIP001 	}
//STRIP001 }

//STRIP001 USHORT _SaveMergeRedlines::InsertRedline( FNInsUndo pFn )
//STRIP001 {
//STRIP001 	USHORT nIns = 0;
//STRIP001 	SwDoc* pDoc = pDestRedl->GetDoc();
//STRIP001 
//STRIP001 	if( REDLINE_INSERT == pDestRedl->GetType() )
//STRIP001 	{
//STRIP001 		// der Teil wurde eingefuegt, also kopiere ihn aus dem SourceDoc
//STRIP001 		BOOL bUndo = pDoc->DoesUndo();
//STRIP001 		pDoc->DoUndo( FALSE );
//STRIP001 
//STRIP001 		SwNodeIndex aSaveNd( pDestRedl->GetPoint()->nNode, -1 );
//STRIP001 		xub_StrLen nSaveCnt = pDestRedl->GetPoint()->nContent.GetIndex();
//STRIP001 
//STRIP001 		SwRedlineMode eOld = pDoc->GetRedlineMode();
//STRIP001 		pDoc->SetRedlineMode_intern( eOld | REDLINE_IGNORE );
//STRIP001 
//STRIP001 		pSrcRedl->GetDoc()->Copy( *(SwPaM*)pSrcRedl, *pDestRedl->GetPoint() );
//STRIP001 
//STRIP001 		pDoc->SetRedlineMode_intern( eOld );
//STRIP001 		pDoc->DoUndo( bUndo );
//STRIP001 
//STRIP001 		pDestRedl->SetMark();
//STRIP001 		aSaveNd++;
//STRIP001 		pDestRedl->GetMark()->nNode = aSaveNd;
//STRIP001 		pDestRedl->GetMark()->nContent.Assign( aSaveNd.GetNode().GetCntntNode(),
//STRIP001 												nSaveCnt );
//STRIP001 
//STRIP001 		SwPaM* pPrev = ((_SaveMergeRedlines*)GetPrev())->pDestRedl;
//STRIP001 		if( pPrev && *pPrev->GetPoint() == *pDestRedl->GetPoint() )
//STRIP001 			*pPrev->GetPoint() == *pDestRedl->GetMark();
//STRIP001 
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		//JP 21.09.98: Bug 55909
//STRIP001 		// falls im Doc auf gleicher Pos aber schon ein geloeschter oder
//STRIP001 		// eingefuegter ist, dann muss dieser gesplittet werden!
//STRIP001 		SwPosition* pDStt = pDestRedl->GetMark(),
//STRIP001 				  * pDEnd = pDestRedl->GetPoint();
//STRIP001 		USHORT n = 0;
//STRIP001 
//STRIP001 			// zur StartPos das erste Redline suchen
//STRIP001 		if( !pDoc->GetRedline( *pDStt, &n ) && n )
//STRIP001 			--n;
//STRIP001 
//STRIP001 		const SwRedlineTbl& rRedlineTbl = pDoc->GetRedlineTbl();
//STRIP001 		for( ; n < rRedlineTbl.Count(); ++n )
//STRIP001 		{
//STRIP001 			SwRedline* pRedl = rRedlineTbl[ n ];
//STRIP001 			SwPosition* pRStt = pRedl->Start(),
//STRIP001 					  * pREnd = pRStt == pRedl->GetPoint() ? pRedl->GetMark()
//STRIP001 														   : pRedl->GetPoint();
//STRIP001 			if( REDLINE_DELETE == pRedl->GetType() ||
//STRIP001 				REDLINE_INSERT == pRedl->GetType() )
//STRIP001 			{
//STRIP001 				SwComparePosition eCmpPos = ComparePosition( *pDStt, *pDEnd, *pRStt, *pREnd );
//STRIP001 				switch( eCmpPos )
//STRIP001 				{
//STRIP001 				case POS_COLLIDE_START:
//STRIP001 				case POS_BEHIND:
//STRIP001 					break;
//STRIP001 
//STRIP001 				case POS_INSIDE:
//STRIP001 				case POS_EQUAL:
//STRIP001 					delete pDestRedl, pDestRedl = 0;
//STRIP001 					// break; -> kein break !!!!
//STRIP001 
//STRIP001 				case POS_COLLIDE_END:
//STRIP001 				case POS_BEFORE:
//STRIP001 					n = rRedlineTbl.Count();
//STRIP001 					break;
//STRIP001 
//STRIP001 				case POS_OUTSIDE:
//STRIP001 					{
//STRIP001 						SwRedline* pCpyRedl = new SwRedline(
//STRIP001 							pDestRedl->GetRedlineData(), *pDStt );
//STRIP001 						pCpyRedl->SetMark();
//STRIP001 						*pCpyRedl->GetPoint() = *pRStt;
//STRIP001 
//STRIP001 						SwUndoCompDoc* pUndo = pDoc->DoesUndo()
//STRIP001 									? new SwUndoCompDoc( *pCpyRedl ) : 0;
//STRIP001 
//STRIP001                         // now modify doc: append redline, undo (and count)
//STRIP001 						pDoc->AppendRedline( pCpyRedl );
//STRIP001                         if( pUndo )
//STRIP001                             (pDoc->*pFn)( pUndo );
//STRIP001                         ++nIns;
//STRIP001 
//STRIP001 						*pDStt = *pREnd;
//STRIP001 
//STRIP001 						// dann solle man neu anfangen
//STRIP001 						n = USHRT_MAX;
//STRIP001 					}
//STRIP001 					break;
//STRIP001 
//STRIP001 				case POS_OVERLAP_BEFORE:
//STRIP001 					*pDEnd = *pRStt;
//STRIP001 					break;
//STRIP001 
//STRIP001 				case POS_OVERLAP_BEHIND:
//STRIP001 					*pDStt = *pREnd;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else if( *pDEnd <= *pRStt )
//STRIP001 				break;
//STRIP001 		}
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	if( pDestRedl )
//STRIP001 	{
//STRIP001 		SwUndoCompDoc* pUndo = pDoc->DoesUndo() ? new SwUndoCompDoc( *pDestRedl ) : 0;
//STRIP001 
//STRIP001         // now modify doc: append redline, undo (and count)
//STRIP001 		bool bRedlineAccepted = pDoc->AppendRedline( pDestRedl );
//STRIP001         if( pUndo )
//STRIP001             (pDoc->*pFn)( pUndo );
//STRIP001         ++nIns;
//STRIP001 
//STRIP001         // if AppendRedline has deleted our redline, we may not keep a
//STRIP001         // reference to it
//STRIP001         if( ! bRedlineAccepted ) 
//STRIP001             pDestRedl = NULL;
//STRIP001  }
//STRIP001 	return nIns;
//STRIP001 }

// merge zweier Dokumente
//STRIP001 long SwDoc::MergeDoc( const SwDoc& rDoc )
//STRIP001 {
//STRIP001 	if( &rDoc == this )
//STRIP001 		return 0;
//STRIP001 
//STRIP001 	long nRet = 0;
//STRIP001 
//STRIP001 	StartUndo();
//STRIP001 
//STRIP001 	SwDoc& rSrcDoc = (SwDoc&)rDoc;
//STRIP001 	BOOL bSrcModified = rSrcDoc.IsModified();
//STRIP001 
//STRIP001 	SwRedlineMode eSrcRedlMode = rSrcDoc.GetRedlineMode();
//STRIP001 	rSrcDoc.SetRedlineMode( REDLINE_SHOW_DELETE );
//STRIP001 	SetRedlineMode( REDLINE_SHOW_DELETE );
//STRIP001 
//STRIP001 	SwCompareData aD0( rSrcDoc );
//STRIP001 	SwCompareData aD1( *this );
//STRIP001 
//STRIP001 	aD1.CompareLines( aD0 );
//STRIP001 
//STRIP001 	if( !aD1.HasDiffs( aD0 ) )
//STRIP001 	{
//STRIP001 		// jetzt wollen wir alle Redlines aus dem SourceDoc zu uns bekommen
//STRIP001 
//STRIP001 		// suche alle Insert - Redlines aus dem SourceDoc und bestimme
//STRIP001 		// deren Position im DestDoc
//STRIP001 		_SaveMergeRedlines* pRing = 0;
//STRIP001 		const SwRedlineTbl& rSrcRedlTbl = rSrcDoc.GetRedlineTbl();
//STRIP001 		ULONG nEndOfExtra = rSrcDoc.GetNodes().GetEndOfExtras().GetIndex();
//STRIP001 		ULONG nMyEndOfExtra = GetNodes().GetEndOfExtras().GetIndex();
//STRIP001 		for( USHORT n = 0; n < rSrcRedlTbl.Count(); ++n )
//STRIP001 		{
//STRIP001 			const SwRedline* pRedl = rSrcRedlTbl[ n ];
//STRIP001 			ULONG nNd = pRedl->GetPoint()->nNode.GetIndex();
//STRIP001 			SwRedlineType eType = pRedl->GetType();
//STRIP001 			if( nEndOfExtra < nNd &&
//STRIP001 				( REDLINE_INSERT == eType || REDLINE_DELETE == eType ))
//STRIP001 			{
//STRIP001 				const SwNode* pDstNd = GetNodes()[
//STRIP001 										nMyEndOfExtra + nNd - nEndOfExtra ];
//STRIP001 
//STRIP001 				// Position gefunden. Dann muss im DestDoc auch
//STRIP001 				// in der Line das Redline eingefuegt werden
//STRIP001 				_SaveMergeRedlines* pTmp = new _SaveMergeRedlines(
//STRIP001 													*pDstNd, *pRedl, pRing );
//STRIP001 				if( !pRing )
//STRIP001 					pRing = pTmp;
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		if( pRing )
//STRIP001 		{
//STRIP001 			// dann alle ins DestDoc ueber nehmen
//STRIP001 			rSrcDoc.SetRedlineMode( REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE );
//STRIP001 			SetRedlineMode( REDLINE_ON | REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE );
//STRIP001 			_SaveMergeRedlines* pTmp = pRing;
//STRIP001 
//STRIP001 			do {
//STRIP001 				nRet += pTmp->InsertRedline( &SwDoc::AppendUndo );
//STRIP001 			} while( pRing != ( pTmp = (_SaveMergeRedlines*)pTmp->GetNext() ));
//STRIP001 
//STRIP001 			while( pRing != pRing->GetNext() )
//STRIP001 				delete pRing->GetNext();
//STRIP001 			delete pRing;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	rSrcDoc.SetRedlineMode( eSrcRedlMode );
//STRIP001 	if( !bSrcModified )
//STRIP001 		rSrcDoc.ResetModified();
//STRIP001 
//STRIP001 	SetRedlineMode( REDLINE_SHOW_INSERT | REDLINE_SHOW_DELETE );
//STRIP001 
//STRIP001 	EndUndo();
//STRIP001 
//STRIP001 	return nRet;
//STRIP001 }


}
