/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_edattr.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:56:40 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#ifndef _HINTIDS_HXX
#include <hintids.hxx>
#endif

#ifndef _SVX_TSTPITEM_HXX //autogen
#include <bf_svx/tstpitem.hxx>
#endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <bf_svx/lrspitem.hxx>
#endif
#ifndef _SVX_SCRIPTTYPEITEM_HXX
#include <bf_svx/scripttypeitem.hxx>
#endif
#ifndef _COM_SUN_STAR_I18N_SCRIPTTYPE_HDL_
#include <com/sun/star/i18n/ScriptType.hdl>
#endif

// auto strip #ifndef _TXATBASE_HXX //autogen
// auto strip #include <txatbase.hxx>
// auto strip #endif
// auto strip #ifndef _TXTFTN_HXX //autogen
// auto strip #include <txtftn.hxx>
// auto strip #endif
// auto strip #ifndef _FMTFTN_HXX //autogen
// auto strip #include <fmtftn.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

#ifndef _EDITSH_HXX
#include <editsh.hxx>
#endif
#ifndef _EDIMP_HXX
#include <edimp.hxx>	// fuer MACROS
#endif
// auto strip #ifndef _SWUNDO_HXX
// auto strip #include <swundo.hxx>	// fuer UNDO-Ids
// auto strip #endif
#ifndef _NDTXT_HXX
#include <ndtxt.hxx>
#endif
// auto strip #ifndef _FTNIDX_HXX
// auto strip #include <ftnidx.hxx>
// auto strip #endif
#ifndef _EXPFLD_HXX
#include <expfld.hxx>
#endif
#ifndef _DOC_HXX
#include <doc.hxx>
#endif
// auto strip #ifndef _ROOTFRM_HXX
// auto strip #include <rootfrm.hxx>
// auto strip #endif
#ifndef _PAM_HXX
#include <pam.hxx>
#endif
// auto strip #ifndef _CNTFRM_HXX
// auto strip #include <cntfrm.hxx>
// auto strip #endif
#ifndef _BREAKIT_HXX
#include <breakit.hxx>
#endif
#ifndef _TXTFLD_HXX
#include <txtfld.hxx>
#endif
#ifndef _FMTFLD_HXX
#include <fmtfld.hxx>
#endif
#ifndef _CRSSKIP_HXX
#include <crsskip.hxx>
#endif
#ifndef _TXTFRM_HXX
#include <txtfrm.hxx>		// SwTxtFrm
#endif
#ifndef _DRAWFONT_HXX
#include <drawfont.hxx>
#endif
// auto strip #ifndef _SVTOOLS_CTLOPTIONS_HXX
// auto strip #include <svtools/ctloptions.hxx>
// auto strip #endif
namespace binfilter {

using namespace ::com::sun::star::i18n;

/*************************************
 * harte Formatierung (Attribute)
 *************************************/

// wenn Selektion groesser Max Nodes oder mehr als Max Selektionen
// => keine Attribute
/*N*/ const USHORT& getMaxLookup()
/*N*/ {
/*N*/ 	static const USHORT nMaxLookup = 1000;
/*N*/ 	return nMaxLookup;
/*N*/ }

/*N*/ BOOL SwEditShell::GetAttr( SfxItemSet& rSet ) const
/*N*/ {
/*N*/ 	if( GetCrsrCnt() > getMaxLookup() )
/*N*/ 	{
/*?*/ 		rSet.InvalidateAllItems();
/*?*/ 		return FALSE;
/*N*/ 	}
/*N*/ 
/*N*/ 	SfxItemSet aSet( *rSet.GetPool(), rSet.GetRanges() );
/*N*/ 	SfxItemSet *pSet = &rSet;
/*N*/ 
/*N*/ 	FOREACHPAM_START(this)
/*N*/ 
/*N*/ 		ULONG nSttNd = PCURCRSR->GetMark()->nNode.GetIndex(),
/*N*/ 			  nEndNd = PCURCRSR->GetPoint()->nNode.GetIndex();
/*N*/ 		xub_StrLen nSttCnt = PCURCRSR->GetMark()->nContent.GetIndex(),
/*N*/ 				   nEndCnt = PCURCRSR->GetPoint()->nContent.GetIndex();
/*N*/ 
/*N*/ 		if( nSttNd > nEndNd || ( nSttNd == nEndNd && nSttCnt > nEndCnt ))
/*N*/ 		{
/*?*/ 			ULONG nTmp = nSttNd; nSttNd = nEndNd; nEndNd = nTmp;
/*?*/ 			nTmp = nSttCnt; nSttCnt = nEndCnt; nEndCnt = (xub_StrLen)nTmp;
/*N*/ 		}
/*N*/ 
/*N*/ 		if( nEndNd - nSttNd >= getMaxLookup() )
/*N*/ 		{
/*?*/ 			rSet.ClearItem();
/*?*/ 			rSet.InvalidateAllItems();
/*?*/ 			return FALSE;
/*N*/ 		}
/*N*/ 
/*N*/ 		// beim 1.Node traegt der Node die Werte in den GetSet ein (Initial)
/*N*/ 		// alle weiteren Nodes werden zum GetSet zu gemergt
/*N*/ 		for( ULONG n = nSttNd; n <= nEndNd; ++n )
/*N*/ 		{
/*N*/ 			SwNode* pNd = GetDoc()->GetNodes()[ n ];
/*N*/ 			switch( pNd->GetNodeType() )
/*N*/ 			{
/*N*/ 			case ND_TEXTNODE:
/*N*/ 				{
/*N*/ 					xub_StrLen nStt = n == nSttNd ? nSttCnt : 0,
/*N*/ 						   	   nEnd = n == nEndNd ? nEndCnt
/*N*/ 										: ((SwTxtNode*)pNd)->GetTxt().Len();
/*N*/ 					((SwTxtNode*)pNd)->GetAttr( *pSet, nStt, nEnd );
/*N*/ 				}
/*N*/ 				break;
/*N*/ 			case ND_GRFNODE:
/*N*/ 			case ND_OLENODE:
/*?*/ 				((SwCntntNode*)pNd)->GetAttr( *pSet );
/*?*/ 				break;
/*?*/ 
/*?*/ 			default:
/*?*/ 				pNd = 0;
/*N*/ 			}
/*N*/ 
/*N*/ 			if( pNd )
/*N*/ 			{
/*N*/ 				if( pSet != &rSet )
/*?*/ 					rSet.MergeValues( aSet );
/*N*/ 
/*N*/ 				if( aSet.Count() )
/*?*/ 					aSet.ClearItem();
/*N*/ 
/*N*/ #ifdef JP_NEWCORE
/*N*/ 			// vieleicht sollte man hier noch erfragen, ob schon alle Attribute
/*N*/ 			// "DontCare" sind. Dann kann man abbrechen!
/*N*/ #endif
/*N*/ 			}
/*N*/ 			pSet = &aSet;
/*N*/ 		}
/*N*/ 
/*N*/ 	FOREACHPAM_END()
/*N*/ 
/*N*/ 	return TRUE;
/*N*/ }


//STRIP001 BOOL lcl_GetFmtColl( const SwNodePtr& rpNd, void* pArgs )
//STRIP001 {
//STRIP001 	if( rpNd->IsTxtNode() )
//STRIP001 	{
//STRIP001 		SwFmtColl** ppColl = (SwFmtColl**)pArgs;
//STRIP001 		if( !*ppColl )
//STRIP001 			*ppColl = ((SwTxtNode*)rpNd)->GetTxtColl();
//STRIP001 		else if( *ppColl == ((SwTxtNode*)rpNd)->GetTxtColl() )
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001 	return TRUE;
//STRIP001 }


/*N*/ SwTxtFmtColl* SwEditShell::GetCurTxtFmtColl() const
/*N*/ {
/*N*/ 	SwTxtFmtColl *pFmt = 0;
/*N*/ 
/*N*/ 	if ( GetCrsrCnt() > getMaxLookup() )
/*?*/ 		return 0;
/*N*/ 
/*N*/ 	FOREACHPAM_START(this)
/*N*/ 
/*N*/ 		ULONG nSttNd = PCURCRSR->GetMark()->nNode.GetIndex(),
/*N*/ 			  nEndNd = PCURCRSR->GetPoint()->nNode.GetIndex();
/*N*/ 		xub_StrLen nSttCnt = PCURCRSR->GetMark()->nContent.GetIndex(),
/*N*/ 				   nEndCnt = PCURCRSR->GetPoint()->nContent.GetIndex();
/*N*/ 
/*N*/ 		if( nSttNd > nEndNd || ( nSttNd == nEndNd && nSttCnt > nEndCnt ))
/*N*/ 		{
/*?*/ 			ULONG nTmp = nSttNd; nSttNd = nEndNd; nEndNd = nTmp;
/*?*/ 			nTmp = nSttCnt; nSttCnt = nEndCnt; nEndCnt = (xub_StrLen)nTmp;
/*N*/ 		}
/*N*/ 
/*N*/ 		if( nEndNd - nSttNd >= getMaxLookup() )
/*N*/ 		{
/*?*/ 			pFmt = 0;
/*?*/ 			break;
/*N*/ 		}
/*N*/ 
/*N*/ 		for( ULONG n = nSttNd; n <= nEndNd; ++n )
/*N*/ 		{
/*N*/ 			SwNode* pNd = GetDoc()->GetNodes()[ n ];
/*N*/ 			if( pNd->IsTxtNode() )
/*N*/ 			{
/*N*/ 				if( !pFmt )
/*N*/ 					pFmt = ((SwTxtNode*)pNd)->GetTxtColl();
/*N*/ 				else if( pFmt == ((SwTxtNode*)pNd)->GetTxtColl() ) // ???
/*?*/ 					break;
/*N*/ 			}
/*N*/ 		}
/*N*/ 
/*N*/ 	FOREACHPAM_END()
/*N*/ 	return pFmt;
/*N*/ }



//STRIP001 BOOL SwEditShell::GetCurFtn( SwFmtFtn* pFillFtn )
//STRIP001 {
//STRIP001 	// der Cursor muss auf dem akt. Fussnoten-Anker stehen:
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	SwTxtNode* pTxtNd = pCrsr->GetNode()->GetTxtNode();
//STRIP001 	if( !pTxtNd )
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	SwTxtAttr *pFtn = pTxtNd->GetTxtAttr( pCrsr->GetPoint()->nContent,
//STRIP001 											RES_TXTATR_FTN );
//STRIP001 	if( pFtn && pFillFtn )
//STRIP001 	{
//STRIP001 		// Daten vom Attribut uebertragen
//STRIP001 		const SwFmtFtn &rFtn = ((SwTxtFtn*)pFtn)->GetFtn();
//STRIP001 		pFillFtn->SetNumber( rFtn );
//STRIP001 		pFillFtn->SetEndNote( rFtn.IsEndNote() );
//STRIP001 	}
//STRIP001 	return 0 != pFtn;
//STRIP001 }


//STRIP001 BOOL SwEditShell::SetCurFtn( const SwFmtFtn& rFillFtn )
//STRIP001 {
//STRIP001 	BOOL bChgd = FALSE;
//STRIP001 	StartAllAction();
//STRIP001 
//STRIP001 	SwPaM* pCrsr = GetCrsr(), *pFirst = pCrsr;
//STRIP001 	do {
//STRIP001 		bChgd |=  pDoc->SetCurFtn( *pCrsr, rFillFtn.GetNumStr(),
//STRIP001 											rFillFtn.GetNumber(),
//STRIP001 											rFillFtn.IsEndNote() );
//STRIP001 
//STRIP001 	} while( pFirst != ( pCrsr = (SwPaM*)pCrsr->GetNext() ));
//STRIP001 
//STRIP001 	EndAllAction();
//STRIP001 	return bChgd;
//STRIP001 }



/*USHORT SwEditShell::GetFtnCnt( BOOL bEndNotes = FALSE ) const
{
	const SwFtnIdxs &rIdxs = pDoc->GetFtnIdxs();
	USHORT nCnt = 0;
	for ( USHORT i = 0; i < rIdxs.Count(); ++i )
	{
		const SwFmtFtn &rFtn = rIdxs[i]->GetFtn();
		if ( bEndNotes == rFtn.IsEndNote() )
			nCnt++;
	}
	return nCnt;
} */


//STRIP001 BOOL SwEditShell::HasFtns( BOOL bEndNotes ) const
//STRIP001 {
//STRIP001 	const SwFtnIdxs &rIdxs = pDoc->GetFtnIdxs();
//STRIP001 	for ( USHORT i = 0; i < rIdxs.Count(); ++i )
//STRIP001 	{
//STRIP001 		const SwFmtFtn &rFtn = rIdxs[i]->GetFtn();
//STRIP001 		if ( bEndNotes == rFtn.IsEndNote() )
//STRIP001 			return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }


	// gebe Liste aller Fussnoten und deren Anfangstexte
//STRIP001 USHORT SwEditShell::GetSeqFtnList( SwSeqFldList& rList, BOOL bEndNotes )
//STRIP001 {
//STRIP001 	if( rList.Count() )
//STRIP001 		rList.Remove( 0, rList.Count() );
//STRIP001 
//STRIP001 	USHORT n, nFtnCnt = pDoc->GetFtnIdxs().Count();
//STRIP001 	SwTxtFtn* pTxtFtn;
//STRIP001 	for( n = 0; n < nFtnCnt; ++n )
//STRIP001 	{
//STRIP001 		pTxtFtn = pDoc->GetFtnIdxs()[ n ];
//STRIP001 		const SwFmtFtn& rFtn = pTxtFtn->GetFtn();
//STRIP001 		if ( rFtn.IsEndNote() != bEndNotes )
//STRIP001 			continue;
//STRIP001 
//STRIP001 		SwNodeIndex* pIdx = pTxtFtn->GetStartNode();
//STRIP001 		if( pIdx )
//STRIP001 		{
//STRIP001 			SwNodeIndex aIdx( *pIdx, 1 );
//STRIP001 			SwTxtNode* pTxtNd = aIdx.GetNode().GetTxtNode();
//STRIP001 			if( !pTxtNd )
//STRIP001 				pTxtNd = (SwTxtNode*)pDoc->GetNodes().GoNext( &aIdx );
//STRIP001 
//STRIP001 			if( pTxtNd )
//STRIP001 			{
//STRIP001 				String sTxt( rFtn.GetViewNumStr( *pDoc ));
//STRIP001 				if( sTxt.Len() )
//STRIP001 					sTxt += ' ';
//STRIP001 				sTxt += pTxtNd->GetExpandTxt( 0, USHRT_MAX, FALSE );
//STRIP001 
//STRIP001 				_SeqFldLstElem* pNew = new _SeqFldLstElem( sTxt,
//STRIP001 											pTxtFtn->GetSeqRefNo() );
//STRIP001 				while( rList.InsertSort( pNew ) )
//STRIP001 					pNew->sDlgEntry += ' ';
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	return rList.Count();
//STRIP001 }


// linken Rand ueber Objectleiste einstellen (aenhlich dem Stufen von
// Numerierungen)
/*N*/ BOOL SwEditShell::IsMoveLeftMargin( BOOL bRight, BOOL bModulus ) const
/*N*/ {
/*N*/ 	BOOL bRet = TRUE;
/*N*/ 
/*N*/ 	const SvxTabStopItem& rTabItem = (SvxTabStopItem&)GetDoc()->
/*N*/ 								GetDefault( RES_PARATR_TABSTOP );
/*N*/ 	USHORT nDefDist = rTabItem.Count() ? rTabItem[0].GetTabPos() : 1134;
/*N*/ 	if( !nDefDist )
/*N*/ 		return FALSE;
/*N*/ 
/*N*/ 	FOREACHPAM_START(this)
/*N*/ 
/*N*/ 		ULONG nSttNd = PCURCRSR->GetMark()->nNode.GetIndex(),
/*N*/ 			  nEndNd = PCURCRSR->GetPoint()->nNode.GetIndex();
/*N*/ 
/*N*/ 		if( nSttNd > nEndNd )
/*N*/ 		{
/*N*/ 			ULONG nTmp = nSttNd; nSttNd = nEndNd; nEndNd = nTmp;
/*N*/ 		}
/*N*/ 
/*N*/ 		SwCntntNode* pCNd;
/*N*/ 		for( ULONG n = nSttNd; bRet && n <= nEndNd; ++n )
/*N*/ 			if( 0 != ( pCNd = GetDoc()->GetNodes()[ n ]->GetTxtNode() ))
/*N*/ 			{
/*N*/ 				const SvxLRSpaceItem& rLS = (SvxLRSpaceItem&)
/*N*/ 											pCNd->GetAttr( RES_LR_SPACE );
/*N*/ 				if( bRight )
/*N*/ 				{
/*N*/ 					USHORT nNext = rLS.GetTxtLeft() + nDefDist;
/*N*/ 					if( bModulus )
/*N*/ 						nNext = ( nNext / nDefDist ) * nDefDist;
/*N*/ 					SwFrm* pFrm = pCNd->GetFrm();
/*N*/                     if ( pFrm )
/*N*/                     {
/*N*/                         const USHORT nFrmWidth = pFrm->IsVertical() ?
/*N*/                                                  pFrm->Frm().Height() :
/*N*/                                                  pFrm->Frm().Width();
/*N*/                         bRet = nFrmWidth > ( nNext + MM50 );
/*N*/                     }
/*N*/                     else
/*N*/                         bRet = FALSE;
/*N*/ 				}
/*N*/ 				else if( bModulus )
/*N*/ 					bRet = 0 != rLS.GetLeft();
/*N*/ 				else
/*N*/ 					bRet = nDefDist <= rLS.GetLeft();
/*N*/ 			}
/*N*/ 
/*N*/ 		if( !bRet )
/*N*/ 			break;
/*N*/ 
/*N*/ 	FOREACHPAM_END()
/*N*/ 	return bRet;
/*N*/ }

//STRIP001 void SwEditShell::MoveLeftMargin( BOOL bRight, BOOL bModulus )
//STRIP001 {
//STRIP001 	StartAllAction();
//STRIP001 	StartUndo( UNDO_START );
//STRIP001 
//STRIP001 	SwPaM* pCrsr = GetCrsr();
//STRIP001 	if( pCrsr->GetNext() != pCrsr )			// Mehrfachselektion ?
//STRIP001 	{
//STRIP001 		SwPamRanges aRangeArr( *pCrsr );
//STRIP001 		SwPaM aPam( *pCrsr->GetPoint() );
//STRIP001 		for( USHORT n = 0; n < aRangeArr.Count(); ++n )
//STRIP001 			GetDoc()->MoveLeftMargin( aRangeArr.SetPam( n, aPam ),
//STRIP001 										bRight, bModulus );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		GetDoc()->MoveLeftMargin( *pCrsr, bRight, bModulus );
//STRIP001 
//STRIP001 	EndUndo( UNDO_END );
//STRIP001 	EndAllAction();
//STRIP001 }


/*N*/ inline USHORT lcl_SetScriptFlags( USHORT nType )
/*N*/ {
/*N*/ 	USHORT nRet;
/*N*/    	switch( nType )
/*N*/ 	{
/*N*/ 	case ScriptType::LATIN:		nRet = SCRIPTTYPE_LATIN;	break;
/*N*/ 	case ScriptType::ASIAN:		nRet = SCRIPTTYPE_ASIAN;	break;
/*N*/ 	case ScriptType::COMPLEX:	nRet = SCRIPTTYPE_COMPLEX;	break;
/*N*/ 	default: nRet = 0;
/*N*/ 	}
/*N*/ 	return nRet;
/*N*/ }

/*N*/ BOOL lcl_IsNoEndTxtAttrAtPos( const SwTxtNode& rTNd, xub_StrLen nPos,
/*N*/                             USHORT &rScrpt, BOOL bInSelection, BOOL bNum )
/*N*/ {
/*N*/ 	BOOL bRet = FALSE;
/*N*/ 	const String& rTxt = rTNd.GetTxt();
/*N*/     String sExp;
/*N*/ 
/*N*/     // consider numbering
/*N*/     if ( bNum )
/*N*/     {
/*N*/         bRet = FALSE;
/*N*/ 
/*N*/         const SwNumRule* pNumRule = rTNd.GetNumRule();
/*N*/         const SwNodeNum* pNum = rTNd.GetNum();
/*N*/ 
/*N*/         if( !pNumRule )     // oder sollte OutlineNum an sein?
/*N*/         {
/*N*/             pNum = rTNd.GetOutlineNum();
/*N*/             if( pNum )
/*N*/                 pNumRule = rTNd.GetDoc()->GetOutlineNumRule();
/*N*/         }
/*N*/ 
/*N*/         if( pNumRule && pNum && MAXLEVEL > pNum->GetLevel() )
/*N*/         {
/*N*/             const SwNumFmt &rNumFmt = pNumRule->Get( pNum->GetLevel() );
/*N*/ 
/*N*/             if( SVX_NUM_BITMAP != rNumFmt.GetNumberingType() )
/*N*/             {
/*N*/                 if ( SVX_NUM_CHAR_SPECIAL == rNumFmt.GetNumberingType() )
/*N*/                     sExp = rNumFmt.GetBulletChar();
/*N*/                 else
/*N*/                     sExp = pNumRule->MakeNumString( *pNum );
/*N*/             }
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     // and fields
/*N*/ 	const SwTxtAttr* pTFld;
/*N*/ 	if( CH_TXTATR_BREAKWORD == rTxt.GetChar( nPos ) &&
/*N*/ 		0 != ( pTFld = rTNd.GetTxtAttr( nPos ) ) )
/*N*/ 	{
/*N*/ 		bRet = TRUE;		            // all other then fields can be
/*N*/ 										// defined as weak-script ?
/*N*/ 		const SwField* pFld;
/*N*/ 		if( RES_TXTATR_FIELD == pTFld->Which() &&
/*N*/             0 != (pFld = pTFld->GetFld().GetFld() ) )
/*N*/         {
/*N*/             sExp += pFld->Expand();
/*N*/         }
/*N*/     }
/*N*/ 
/*N*/     xub_StrLen nEnd = sExp.Len();
/*N*/     if ( nEnd )
/*N*/     {
/*N*/         xub_StrLen n;
/*N*/         if( bInSelection )
/*N*/         {
/*N*/             USHORT nScript;
/*N*/             for( n = 0; n < nEnd; n = (xub_StrLen)
/*N*/                     pBreakIt->xBreak->endOfScript( sExp, n, nScript ))
/*N*/             {
/*N*/                 nScript = pBreakIt->xBreak->getScriptType( sExp, n );
/*N*/                 rScrpt |= lcl_SetScriptFlags( nScript );
/*N*/             }
/*N*/         }
/*N*/         else
/*N*/             rScrpt |= lcl_SetScriptFlags( pBreakIt->xBreak->
/*N*/                                         getScriptType( sExp, nEnd-1 ));
/*N*/     }
/*N*/ 
/*N*/ 	return bRet;
/*N*/ }


// returns the scripttpye of the selection
/*N*/ USHORT SwEditShell::GetScriptType( USHORT nFlags ) const
/*N*/ {
/*N*/ 	USHORT nRet = 0;
/*N*/ 	if( pBreakIt->xBreak.is() )
/*N*/ 	{
/*N*/ 		FOREACHPAM_START(this)
/*N*/ 
/*N*/ 			const SwPosition *pStt = PCURCRSR->Start(),
/*N*/ 							 *pEnd = pStt == PCURCRSR->GetMark()
/*N*/ 									? PCURCRSR->GetPoint()
/*N*/ 									: PCURCRSR->GetMark();
/*N*/ 			if( pStt == pEnd || *pStt == *pEnd )
/*N*/ 			{
/*N*/ 				const SwTxtNode* pTNd = pStt->nNode.GetNode().GetTxtNode();
/*N*/ 				if( pTNd )
/*N*/ 				{
/*N*/                     // try to get SwScriptInfo
/*N*/                     const SwScriptInfo* pScriptInfo = SwScriptInfo::GetScriptInfo( *pTNd );
/*N*/ 
/*N*/ 					xub_StrLen nPos = pStt->nContent.GetIndex();
/*N*/ 					//Task 90448: we need the scripttype of the previous
/*N*/ 					//				position, if no selection exist!
/*N*/ 					if( nPos )
/*N*/ 					{
/*N*/ 						SwIndex aIdx( pStt->nContent );
/*N*/ 						if( pTNd->GoPrevious( &aIdx, CRSR_SKIP_CHARS ) )
/*N*/ 							nPos = aIdx.GetIndex();
/*N*/ 					}
/*N*/ 
/*N*/                     USHORT nScript;
/*N*/ 
/*N*/                     if ( pTNd->GetTxt().Len() )
/*N*/                     {
/*N*/                         nScript = pScriptInfo ?
/*N*/                                   pScriptInfo->ScriptType( nPos ) :
/*N*/                                   pBreakIt->xBreak->getScriptType( pTNd->GetTxt(), nPos );
/*N*/                     }
/*N*/                     else
/*N*/                         nScript = GetI18NScriptTypeOfLanguage( (USHORT)GetAppLanguage() );
/*N*/ 
/*N*/                     if( !lcl_IsNoEndTxtAttrAtPos( *pTNd, nPos, nRet, FALSE, FALSE ))
/*N*/                         nRet |= lcl_SetScriptFlags( nScript );
/*N*/ 				}
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				ULONG nEndIdx = pEnd->nNode.GetIndex();
/*N*/ 				SwNodeIndex aIdx( pStt->nNode );
/*N*/ 				for( ; aIdx.GetIndex() <= nEndIdx; aIdx++ )
/*N*/ 					if( aIdx.GetNode().IsTxtNode() )
/*N*/ 					{
/*N*/ 						const SwTxtNode* pTNd = aIdx.GetNode().GetTxtNode();
/*N*/ 						const String& rTxt = pTNd->GetTxt();
/*N*/ 
/*N*/                         // try to get SwScriptInfo
/*N*/                         const SwScriptInfo* pScriptInfo = SwScriptInfo::GetScriptInfo( *pTNd );
/*N*/ 
/*N*/ 						xub_StrLen nChg = aIdx == pStt->nNode
/*N*/ 												? pStt->nContent.GetIndex()
/*N*/ 												: 0,
/*N*/ 									nEndPos = aIdx == nEndIdx
/*N*/ 												? pEnd->nContent.GetIndex()
/*N*/ 												: rTxt.Len(),
/*N*/ 									nSttPos = nChg;
/*N*/ 
/*N*/ 						ASSERT( nEndPos <= rTxt.Len(), "Index outside the range - endless loop!" );
/*N*/ 						if( nEndPos > rTxt.Len() )
/*N*/ 							nEndPos = rTxt.Len();
/*N*/ 
/*N*/ 						USHORT nScript;
/*N*/ 						while( nChg < nEndPos )
/*N*/ 						{
/*N*/                             nScript = pScriptInfo ?
/*N*/                                       pScriptInfo->ScriptType( nChg ) :
/*N*/                                       pBreakIt->xBreak->getScriptType(
/*N*/ 																rTxt, nChg );
/*N*/ 
/*N*/                             if( !lcl_IsNoEndTxtAttrAtPos( *pTNd, nChg, nRet, TRUE,
/*N*/                                                           0 == nChg && rTxt.Len() == nEndPos ) )
/*N*/ 								nRet |= lcl_SetScriptFlags( nScript );
/*N*/ 
/*N*/ 							if( (SCRIPTTYPE_LATIN | SCRIPTTYPE_ASIAN |
/*N*/ 								SCRIPTTYPE_COMPLEX) == nRet )
/*N*/ 								break;
/*N*/ 
/*N*/ 							xub_StrLen nFldPos = nChg+1;
/*N*/ 
/*N*/                             nChg = pScriptInfo ?
/*N*/                                    pScriptInfo->NextScriptChg( nChg ) :
/*N*/                                    (xub_StrLen)pBreakIt->xBreak->endOfScript(
/*N*/ 													rTxt, nChg, nScript );
/*N*/ 
/*N*/                             nFldPos = rTxt.Search(
/*N*/ 											CH_TXTATR_BREAKWORD, nFldPos );
/*N*/ 							if( nFldPos < nChg )
/*N*/ 								nChg = nFldPos;
/*N*/ 						}
/*N*/ 						if( (SCRIPTTYPE_LATIN | SCRIPTTYPE_ASIAN |
/*N*/ 								SCRIPTTYPE_COMPLEX) == nRet )
/*N*/ 							break;
/*N*/ 					}
/*N*/ 			}
/*N*/ 			if( (SCRIPTTYPE_LATIN | SCRIPTTYPE_ASIAN |
/*N*/ 								SCRIPTTYPE_COMPLEX) == nRet )
/*N*/ 				break;
/*N*/ 
/*N*/ 		FOREACHPAM_END()
/*N*/ 	}
/*N*/ 	if( !nRet )
/*N*/         nRet = SvtLanguageOptions::GetScriptTypeOfLanguage( LANGUAGE_SYSTEM );
/*N*/ 	return nRet;
/*N*/ }



/*N*/ USHORT SwEditShell::GetCurLang() const
/*N*/ {
/*N*/ 	const SwPaM* pCrsr = GetCrsr();
/*N*/ 	const SwPosition& rPos = *pCrsr->GetPoint();
/*N*/ 	const SwTxtNode* pTNd = rPos.nNode.GetNode().GetTxtNode();
/*N*/ 	USHORT nLang;
/*N*/ 	if( pTNd )
/*N*/ 	{
/*N*/ 		//JP 24.9.2001: if exist no selection, then get the language before
/*N*/ 		//				the current character!
/*N*/ 		xub_StrLen nPos = rPos.nContent.GetIndex();
/*N*/ 		if( nPos && !pCrsr->HasMark() )
/*N*/ 			--nPos;
/*N*/ 		nLang = pTNd->GetLang( nPos );
/*N*/ 	}
/*N*/ 	else
/*?*/ 		nLang = LANGUAGE_DONTKNOW;
/*N*/ 	return nLang;
/*N*/ }

//STRIP001 USHORT SwEditShell::GetScalingOfSelectedText() const
//STRIP001 {
//STRIP001 	const SwPaM* pCrsr = GetCrsr();
//STRIP001 	const SwPosition* pStt = pCrsr->Start();
//STRIP001 	const SwTxtNode* pTNd = pStt->nNode.GetNode().GetTxtNode();
//STRIP001 	ASSERT( pTNd, "no textnode available" );
//STRIP001 
//STRIP001 	USHORT nScaleWidth;
//STRIP001 	if( pTNd )
//STRIP001 	{
//STRIP001 		xub_StrLen nStt = pStt->nContent.GetIndex(), nEnd;
//STRIP001 		const SwPosition* pEnd = pStt == pCrsr->GetPoint()
//STRIP001 										? pCrsr->GetMark()
//STRIP001 										: pCrsr->GetPoint();
//STRIP001 		if( pStt->nNode == pEnd->nNode )
//STRIP001 			nEnd = pEnd->nContent.GetIndex();
//STRIP001 		else
//STRIP001 			nEnd = pTNd->GetTxt().Len();
//STRIP001 		nScaleWidth = pTNd->GetScalingOfSelectedText( nStt, nEnd );
//STRIP001 	}
//STRIP001 	else
//STRIP001 		nScaleWidth = 100;		        // default are no scaling -> 100%
//STRIP001 	return nScaleWidth;
//STRIP001 }
}
