/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_linbox.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: mba $ $Date: 2006/03/29 08:52:16 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include "swtypes.hxx"
#include "errhdl.hxx"

#define _LINBOX_CXX

#include "linbox.hxx"

#ifndef _DEBUG_HXX //autogen
#include <tools/debug.hxx>
#endif

#ifndef _BITMAP_HXX //autogen
#include <vcl/bitmap.hxx>
#endif

#ifndef _IMAGE_HXX //autogen
#include <vcl/image.hxx>
#endif
namespace binfilter {

SV_IMPL_PTRARR(SwLineStyleLst, SwLineStyle*)

/*--------------------------------------------------------------------
	 Beschreibung: Ctor LineType
 --------------------------------------------------------------------*/


SwLineStyle::SwLineStyle(USHORT nWidth, USHORT nWidth2, USHORT nDst) :
	nIn(nWidth2), nOut(nWidth), nDist(nDst)
	{}


SwLineStyle::SwLineStyle(const SwLineStyle& rTyp) :
	nIn(rTyp.nIn), nOut(rTyp.nOut), nDist(rTyp.nDist)
	{}

/*--------------------------------------------------------------------
	 Beschreibung: Ctor LinetypeBox
 --------------------------------------------------------------------*/


SwLineBox::SwLineBox(Window* pPar, const ResId& rResId) :
	ListBox(pPar, rResId), aVirDev(*this)
{
// #ifndef PM2
	aVirDev.SetOutputSizePixel(Size(GetSizePixel().Width()-23, GetTextHeight()-2));
	aVirDev.SetMapMode(MapMode(MAP_TWIP));
	const Wallpaper aWall(GetBackground());
	aVirDev.SetBackground(aWall);
	aVirDev.SetFillColor(aWall.GetColor());
// #endif
}


void SwLineBox::InsertEntry(const SwLineStyle& rTyp, USHORT nPos)
{
	SwLineStyle* pType = new SwLineStyle(rTyp);
	// generieren, einfuegen

// #ifndef PM2
	const Size aOutSz( aVirDev.GetOutputSize() );
	const long nOff	 	= aVirDev.PixelToLogic(Point(10,0)).X();
	const long nHeight  = aOutSz.Height();
	const long nWidth   = aOutSz.Width() - 2 * nOff;
	const long nMin	 	= aVirDev.PixelToLogic(Point(1,2)).Y();

	// loeschen
	Color aWhiteColor(COL_WHITE);
	aVirDev.SetLineColor(aWhiteColor);
	aVirDev.DrawRect(Rectangle(Point(0,0), aVirDev.GetOutputSize()));
	aVirDev.SetClipRegion(Region(Rectangle(Point(nOff, 0),
											  Size(nWidth, nHeight))));

	const short nDist = (short)pType->nDist;
	const short nOut  = (short)pType->nOut ;
	const short nIn   = (short)pType->nIn  ;

	aVirDev.SetLineColor(Color(COL_BLACK));

	//	Offset berechnen
	long nY = (nHeight - nOut - nDist - nIn)/2;
	aVirDev.DrawLine(Point(0,   nY + nOut/2),
					 Point(aOutSz.Width(), nY + nOut/2));

	// evtl. Doppelte Linien
	if(nDist)
	{	// Abstand zur aeusseren Linie
		long nY2 = nY + nOut;
		nY2 += Max(long(nDist), nMin) + nIn /2 ;
		//TODO: DrawRect instead of DrawLine to show a double line
		aVirDev.DrawLine(Point(0, nY2), Point(aOutSz.Width(), nY2));
	}
	Bitmap aBmp = aVirDev.GetBitmap(Point(0, 0), aVirDev.GetOutputSize());
	ListBox::InsertEntry(aBmp, nPos);

// #endif
	if(nPos == LISTBOX_APPEND)
		nPos = aTypeList.Count();

	aTypeList.C40_INSERT(SwLineStyle, pType, nPos);
}

/*--------------------------------------------------------------------
	 Beschreibung:	Eintrag
 --------------------------------------------------------------------*/
/*

void SwLineBox::RemoveEntry(USHORT nPos)
{
	ListBox::RemoveEntry(nPos);
	aTypeList.DeleteAndDestroy(nPos, 1);
}
*/
/*--------------------------------------------------------------------
	 Beschreibung: Eintrag loeschen
 --------------------------------------------------------------------*/
/*

void SwLineBox::RemoveEntry(const SwLineStyle& rTyp)
{
	const USHORT nPos = FindEntry(rTyp);
	if(nPos != LISTBOX_ENTRY_NOTFOUND)
		RemoveEntry(nPos);
}
*/
/*--------------------------------------------------------------------
	 Beschreibung: Eintrag selektieren
 --------------------------------------------------------------------*/


void SwLineBox::SelectEntry(const SwLineStyle& rTyp)
{
	const USHORT nPos = FindEntry(rTyp);
	ListBox::SelectEntryPos(nPos);
}
/*

SwLineStyle SwLineBox::GetEntry(USHORT nPos)
{
	ASSERT(nPos < ListBox::GetEntryCount(), "Unzulaessiger Index");
	return *aTypeList[nPos];
}
*/

SwLineStyle SwLineBox::GetSelectEntry()
{
	SwLineStyle aDef;
	const USHORT nPos = ListBox::GetSelectEntryPos();
	if(nPos == LISTBOX_ENTRY_NOTFOUND)
		return aDef;

	return *aTypeList[nPos];
}


/*--------------------------------------------------------------------
	 Beschreibung: Eintrag finden
 --------------------------------------------------------------------*/


USHORT SwLineBox::FindEntry(const SwLineStyle& rTyp)
{
	for(USHORT i=0; i < aTypeList.Count();++i)
	{	const SwLineStyle* pType = aTypeList[i];
		if(*pType == rTyp)
			return i;
	}
	return LISTBOX_ENTRY_NOTFOUND;
}

/*-----------------26.02.94 00:40-------------------
 dtor ueberladen
--------------------------------------------------*/

SwLineBox::~SwLineBox() {}
}
