/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_gloshdl.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:43:23 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "so3/staticbaseurl.hxx"
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 #ifndef _HINTIDS_HXX
//STRIP001 #include <hintids.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_WGHTITEM_HXX
//STRIP001 #include <bf_svx/wghtitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_ADJITEM_HXX
//STRIP001 #include <bf_svx/adjitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef __RSC //autogen
//STRIP001 #include <tools/errinf.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _MSGBOX_HXX //autogen
//STRIP001 #include <vcl/msgbox.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXMACITEM_HXX //autogen
//STRIP001 #include <svtools/macitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFX_FCONTNR_HXX
//STRIP001 #include <bf_sfx2/fcontnr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SFXDOCFILE_HXX
//STRIP001 #include <bf_sfx2/docfile.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFAACCFG_HXX //autogen
//STRIP001 #include <bf_offmgr/ofaaccfg.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _OFF_APP_HXX //autogen
//STRIP001 #include <bf_offmgr/app.hxx>
//STRIP001 #endif
//STRIP001 #define _SVSTDARR_STRINGS
//STRIP001 #include <svtools/svstdarr.hxx>
//STRIP001 
//STRIP001 #ifndef SVTOOLS_URIHELPER_HXX
//STRIP001 #include <svtools/urihelper.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UNOTOOLS_TRANSLITERATIONWRAPPER_HXX
//STRIP001 #include <unotools/transliterationwrapper.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _POOLFMT_HXX
//STRIP001 #include <poolfmt.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _FMTCOL_HXX
//STRIP001 #include <fmtcol.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCARY_HXX
//STRIP001 #include <docary.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _WRTSH_HXX
//STRIP001 #include <wrtsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UITOOL_HXX
//STRIP001 #include <uitool.hxx>                   // Fehlermeldungen
//STRIP001 #endif
//STRIP001 #ifndef _SWVIEW_HXX //autogen
//STRIP001 #include <view.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOC_HXX
//STRIP001 #include <doc.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWEVENT_HXX
//STRIP001 #include <swevent.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSHDL_HXX
//STRIP001 #include <gloshdl.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSDOC_HXX
//STRIP001 #include <glosdoc.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOSSARY_HXX
//STRIP001 #include <glossary.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SHELLIO_HXX
//STRIP001 #include <shellio.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWUNDO_HXX
//STRIP001 #include <swundo.hxx>               	// fuer Undo-Ids
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _SELGLOS_HXX
//STRIP001 #include <selglos.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _EXPFLD_HXX
//STRIP001 #include <expfld.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _INITUI_HXX
//STRIP001 #include <initui.hxx>					// fuer ::GetGlossaries()
//STRIP001 #endif
//STRIP001 #ifndef _GLOSLST_HXX
//STRIP001 #include <gloslst.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWDTFLVR_HXX
//STRIP001 #include <swdtflvr.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _DOCSH_HXX
//STRIP001 #include <docsh.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _CRSSKIP_HXX
//STRIP001 #include <crsskip.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _DOCHDL_HRC
//STRIP001 #include <dochdl.hrc>
//STRIP001 #endif
//STRIP001 #ifndef _SWERROR_H
//STRIP001 #include <swerror.h>
//STRIP001 #endif
//STRIP001 #ifndef _FRMMGR_HXX
//STRIP001 #include <frmmgr.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 // PUBLIC METHODES -------------------------------------------------------
//STRIP001 struct TextBlockInfo_Impl
//STRIP001 {
//STRIP001 	String sTitle;
//STRIP001 	String sLongName;
//STRIP001 	String sGroupName;
//STRIP001 };
//STRIP001 typedef TextBlockInfo_Impl* TextBlockInfo_ImplPtr;
//STRIP001 SV_DECL_PTRARR_DEL( TextBlockInfoArr, TextBlockInfo_ImplPtr, 0, 4 )
//STRIP001 SV_IMPL_PTRARR( TextBlockInfoArr, TextBlockInfo_ImplPtr )
//STRIP001 SV_IMPL_REF( SwDocShell )
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Dialog fuer Bearbeiten Vorlagen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwGlossaryHdl::GlossaryDlg()
//STRIP001 {
//STRIP001 	SwGlossaryDlg* pDlg = new SwGlossaryDlg( pViewFrame, this, pWrtShell );
//STRIP001 	String sName, sShortName;
//STRIP001 
//STRIP001 	if( RET_EDIT == pDlg->Execute() )
//STRIP001 	{
//STRIP001 		sName = pDlg->GetCurrGrpName();
//STRIP001 		sShortName = pDlg->GetCurrShortName();
//STRIP001 	}
//STRIP001 
//STRIP001 	delete pDlg;
//STRIP001 	DELETEZ(pCurGrp);
//STRIP001 	if(HasGlossaryList())
//STRIP001 	{
//STRIP001 		GetGlossaryList()->ClearGroups();
//STRIP001 	}
//STRIP001 
//STRIP001 	if( sName.Len() || sShortName.Len() )
//STRIP001 		rStatGlossaries.EditGroupDoc( sName, sShortName );
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Setzen der aktuellen Gruppe; falls aus dem Dialog
//STRIP001 					gerufen, wird die Gruppe temp. erzeugt fuer einen
//STRIP001 					schnelleren Zugriff
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwGlossaryHdl::SetCurGroup(const String &rGrp, BOOL bApi, BOOL bAlwaysCreateNew )
//STRIP001 {
//STRIP001 	String sGroup(rGrp);
//STRIP001 	if(STRING_NOTFOUND == sGroup.Search(GLOS_DELIM) && !FindGroupName(sGroup))
//STRIP001 	{
//STRIP001 		sGroup += GLOS_DELIM;
//STRIP001 		sGroup += '0';
//STRIP001 	}
//STRIP001 	if(pCurGrp)
//STRIP001 	{
//STRIP001 		BOOL bPathEqual = FALSE;
//STRIP001 		if(!bAlwaysCreateNew)
//STRIP001 		{
//STRIP001 			const String& sCurPath = so3::StaticBaseUrl::SmartRelToAbs(pCurGrp->GetFileName());
//STRIP001 			xub_StrLen nSlashPos = sCurPath.SearchBackward( INET_PATH_TOKEN );
//STRIP001 			const String sCurEntryPath = sCurPath.Copy(0, nSlashPos);
//STRIP001 			const SvStrings* pPathArr = rStatGlossaries.GetPathArray();
//STRIP001 			USHORT nCurrentPath = USHRT_MAX;
//STRIP001 			for(USHORT nPath = 0; nPath < pPathArr->Count(); nPath++)
//STRIP001 			{
//STRIP001 				if(sCurEntryPath == *(*pPathArr)[nPath])
//STRIP001 				{
//STRIP001 					nCurrentPath = nPath;
//STRIP001 					break;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			String sPath = sGroup.GetToken(1, GLOS_DELIM);
//STRIP001 			USHORT nComparePath = (USHORT)sPath.ToInt32();
//STRIP001 			const String sCurBase = sCurPath.Copy(nSlashPos +  1, sCurPath.Len() - nSlashPos - 5);
//STRIP001 			if(nCurrentPath == nComparePath &&
//STRIP001 				sGroup.GetToken(0, GLOS_DELIM) == sCurBase)
//STRIP001 				bPathEqual = TRUE;
//STRIP001 		}
//STRIP001 //		const String aMac_Tmp(pCurGrp->GetName());
//STRIP001 		// Beim Pfadwechsel kann man sich auf den Namen nicht verlassen
//STRIP001 		if(!bAlwaysCreateNew &&
//STRIP001 				bPathEqual
//STRIP001 //		aMac_Tmp == sGroup
//STRIP001 		)
//STRIP001 			return;
//STRIP001 	}
//STRIP001 	aCurGrp = sGroup;
//STRIP001 	if(!bApi)
//STRIP001 	{
//STRIP001 		if(pCurGrp)
//STRIP001 		{
//STRIP001 			rStatGlossaries.PutGroupDoc(pCurGrp);
//STRIP001 			pCurGrp = 0;
//STRIP001 		}
//STRIP001 		pCurGrp = rStatGlossaries.GetGroupDoc(aCurGrp, TRUE);
//STRIP001 	}
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 USHORT SwGlossaryHdl::GetGroupCnt() const
//STRIP001 {
//STRIP001 	return rStatGlossaries.GetGroupCnt();
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 String SwGlossaryHdl::GetGroupName( USHORT nId, String* pTitle )
//STRIP001 {
//STRIP001 	String sRet = rStatGlossaries.GetGroupName(nId);
//STRIP001 	if(pTitle)
//STRIP001 	{
//STRIP001 		SwTextBlocks* pGroup = rStatGlossaries.GetGroupDoc(sRet, FALSE);
//STRIP001         if(pGroup && !pGroup->GetError())
//STRIP001 		{
//STRIP001 			*pTitle = pGroup->GetName();
//STRIP001 			if(!pTitle->Len())
//STRIP001 			{
//STRIP001 				*pTitle = sRet.GetToken(0, GLOS_DELIM);
//STRIP001 				pGroup->SetName(*pTitle);
//STRIP001 			}
//STRIP001 			rStatGlossaries.PutGroupDoc( pGroup );
//STRIP001 		}
//STRIP001         else
//STRIP001             sRet.Erase();
//STRIP001 	}
//STRIP001 	return sRet;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::NewGroup(String &rGrpName, const String& rTitle)
//STRIP001 {
//STRIP001 	if(STRING_NOTFOUND == rGrpName.Search(GLOS_DELIM))
//STRIP001 		FindGroupName(rGrpName);
//STRIP001 	return rStatGlossaries.NewGroupDoc(rGrpName, rTitle);
//STRIP001 }
//STRIP001 /* -----------------23.11.98 13:10-------------------
//STRIP001  * Umbenennen eines Textbausteins
//STRIP001  * --------------------------------------------------*/
//STRIP001 BOOL SwGlossaryHdl::RenameGroup(const String & rOld, String& rNew, const String& rNewTitle)
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	String sOldGroup(rOld);
//STRIP001 	if(STRING_NOTFOUND == rOld.Search(GLOS_DELIM))
//STRIP001 		FindGroupName(sOldGroup);
//STRIP001 	if(rOld == rNew)
//STRIP001 	{
//STRIP001 		SwTextBlocks* pGroup = rStatGlossaries.GetGroupDoc(sOldGroup, FALSE);
//STRIP001 		if(pGroup)
//STRIP001 		{
//STRIP001 			pGroup->SetName(rNewTitle);
//STRIP001 			rStatGlossaries.PutGroupDoc( pGroup );
//STRIP001 			bRet = TRUE;
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String sNewGroup(rNew);
//STRIP001 		if(STRING_NOTFOUND == sNewGroup.Search(GLOS_DELIM))
//STRIP001 		{
//STRIP001 			sNewGroup += GLOS_DELIM;
//STRIP001 			sNewGroup += '0';
//STRIP001 		}
//STRIP001 		bRet = rStatGlossaries.RenameGroupDoc(sOldGroup, sNewGroup, rNewTitle);
//STRIP001 		rNew = sNewGroup;
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 /* -----------------27.11.98 13:49-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 BOOL SwGlossaryHdl::CopyOrMove( const String& rSourceGroupName,  String& rSourceShortName,
//STRIP001 						const String& rDestGroupName, const String& rLongName, BOOL bMove )
//STRIP001 {
//STRIP001 	SwTextBlocks* pSourceGroup = rStatGlossaries.GetGroupDoc(rSourceGroupName, FALSE);
//STRIP001 
//STRIP001 	SwTextBlocks* pDestGroup = rStatGlossaries.GetGroupDoc(rDestGroupName, FALSE);
//STRIP001 	if(pDestGroup->IsReadOnly() || (bMove && pSourceGroup->IsReadOnly()) )
//STRIP001 		return FALSE;
//STRIP001 	if(pDestGroup->IsOld()&& 0!= pDestGroup->ConvertToNew())
//STRIP001 		return FALSE;
//STRIP001 	if(bMove && pSourceGroup->IsOld() && 0 != pSourceGroup->ConvertToNew())
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	//Der Index muss hier ermittelt werden, weil rSourceShortName in CopyBlock evtl veraendert wird
//STRIP001 	USHORT nDeleteIdx = pSourceGroup->GetIndex( rSourceShortName );
//STRIP001 	DBG_ASSERT(USHRT_MAX != nDeleteIdx, "Eintrag nicht gefunden")
//STRIP001 	ULONG nRet = pSourceGroup->CopyBlock( *pDestGroup, rSourceShortName, rLongName );
//STRIP001 	if(!nRet && bMove)
//STRIP001 	{
//STRIP001 		// der Index muss existieren
//STRIP001 		nRet = pSourceGroup->Delete( nDeleteIdx ) ? 0 : 1;
//STRIP001 	}
//STRIP001 	rStatGlossaries.PutGroupDoc( pSourceGroup );
//STRIP001 	rStatGlossaries.PutGroupDoc( pDestGroup );
//STRIP001 	return !nRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung: Loeschen einer Textbausteindatei-Gruppe
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::DelGroup(const String &rGrpName)
//STRIP001 {
//STRIP001 	String sGroup(rGrpName);
//STRIP001 	if(STRING_NOTFOUND == sGroup.Search(GLOS_DELIM))
//STRIP001 		FindGroupName(sGroup);
//STRIP001 	if( rStatGlossaries.DelGroupDoc(sGroup) )
//STRIP001 	{
//STRIP001 		if(pCurGrp)
//STRIP001 		{
//STRIP001 			const String aMac_Tmp(pCurGrp->GetName());
//STRIP001 			if(aMac_Tmp == sGroup)
//STRIP001 				DELETEZ(pCurGrp);
//STRIP001 		}
//STRIP001 		return TRUE;
//STRIP001 	}
//STRIP001 	return FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Anzahl Textbausteine erfragen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 USHORT SwGlossaryHdl::GetGlossaryCnt()
//STRIP001 {
//STRIP001 	return pCurGrp ? pCurGrp->GetCount() : 0;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Anzahl Textbausteine aus dem Basic erfragen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 USHORT SwGlossaryHdl::GetGlossaryCnt(const String& rGroupName)
//STRIP001 {
//STRIP001 	String sGroupName(rGroupName);
//STRIP001 	if(STRING_NOTFOUND == sGroupName.Search(GLOS_DELIM))
//STRIP001 		FindGroupName(sGroupName);
//STRIP001 	SwTextBlocks* pGrp = rStatGlossaries.GetGroupDoc(sGroupName, FALSE);
//STRIP001 	USHORT nCount = 0;
//STRIP001 	if(pGrp)
//STRIP001 	{
//STRIP001 		nCount = pGrp->GetCount();
//STRIP001 		rStatGlossaries.PutGroupDoc(pGrp);
//STRIP001 
//STRIP001 	}
//STRIP001 	return nCount;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 String SwGlossaryHdl::GetGlossaryName( USHORT nId )
//STRIP001 {
//STRIP001 	ASSERT(nId < GetGlossaryCnt(), Textbausteinarray ueberindiziert.);
//STRIP001 	return pCurGrp->GetLongName( nId );
//STRIP001 }
//STRIP001 /* -----------------30.11.98 13:18-------------------
//STRIP001  *
//STRIP001  * --------------------------------------------------*/
//STRIP001 String	SwGlossaryHdl::GetGlossaryShortName(USHORT nId)
//STRIP001 {
//STRIP001 	ASSERT(nId < GetGlossaryCnt(), Textbausteinarray ueberindiziert.);
//STRIP001 	return pCurGrp->GetShortName( nId );
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 String SwGlossaryHdl::GetGlossaryName( USHORT nId, const String& rGroupName )
//STRIP001 {
//STRIP001 	String sGroupName(rGroupName);
//STRIP001 	if(STRING_NOTFOUND == sGroupName.Search(GLOS_DELIM))
//STRIP001 		FindGroupName(sGroupName);
//STRIP001 	SwTextBlocks* pGrp = rStatGlossaries.GetGroupDoc(sGroupName, FALSE);
//STRIP001 	String sName;
//STRIP001 	if(pGrp)
//STRIP001 	{
//STRIP001 		if( nId < pGrp->GetCount())
//STRIP001 			sName = pGrp->GetLongName( nId );
//STRIP001 		rStatGlossaries.PutGroupDoc(pGrp);
//STRIP001 	}
//STRIP001 	return sName;
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Kurzname erfragen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 String SwGlossaryHdl::GetGlossaryShortName(const String &rName)
//STRIP001 {
//STRIP001 	String sReturn;
//STRIP001 	SwTextBlocks *pTmp =
//STRIP001 		pCurGrp ? pCurGrp: rStatGlossaries.GetGroupDoc( aCurGrp, FALSE );
//STRIP001 	if(pTmp)
//STRIP001 	{
//STRIP001 		USHORT nIdx = pTmp->GetLongIndex( rName );
//STRIP001 		if( nIdx != (USHORT) -1 )
//STRIP001 			sReturn = pTmp->GetShortName( nIdx );
//STRIP001 		if( !pCurGrp )
//STRIP001 			rStatGlossaries.PutGroupDoc( pTmp );
//STRIP001 	}
//STRIP001 	return sReturn;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Kuerzel fuer Textbaustein bereits verwendet?
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::HasShortName(const String& rShortName) const
//STRIP001 {
//STRIP001 	SwTextBlocks *pBlock = pCurGrp ? pCurGrp
//STRIP001 								   : rStatGlossaries.GetGroupDoc( aCurGrp );
//STRIP001 	BOOL bRet = pBlock->GetIndex( rShortName ) != (USHORT) -1;
//STRIP001 	if( !pCurGrp )
//STRIP001 		rStatGlossaries.PutGroupDoc( pBlock );
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------------------20.03.01 10:52--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 BOOL    SwGlossaryHdl::ConvertToNew(SwTextBlocks& rOld)
//STRIP001 {
//STRIP001     if( rOld.IsOld() )
//STRIP001 	{
//STRIP001 		QueryBox aAsk( pWrtShell->GetView().GetWindow(), SW_RES( MSG_UPDATE_NEW_GLOS_FMT ) );
//STRIP001 		if( aAsk.Execute() == RET_YES )
//STRIP001 		{
//STRIP001             if( rOld.ConvertToNew() )
//STRIP001 			{
//STRIP001 				InfoBox(pWrtShell->GetView().GetWindow(), SW_RES(MSG_ERR_INSERT_GLOS)).Execute();
//STRIP001 				return FALSE;
//STRIP001 			}
//STRIP001 		}
//STRIP001 		else
//STRIP001 			return FALSE;
//STRIP001 	}
//STRIP001     return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Erzeugen eines Textbausteines
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::NewGlossary(const String& rName, const String& rShortName,
//STRIP001 								BOOL bCreateGroup, BOOL bNoAttr)
//STRIP001 {
//STRIP001 	SwTextBlocks *pTmp =
//STRIP001 		pCurGrp ? pCurGrp: rStatGlossaries.GetGroupDoc( aCurGrp, bCreateGroup );
//STRIP001 	//pTmp == 0 if the AutoText path setting is wrong
//STRIP001 	if(!pTmp)
//STRIP001 		return FALSE;
//STRIP001     if(!ConvertToNew(*pTmp))
//STRIP001         return FALSE;
//STRIP001 
//STRIP001 	String sOnlyTxt;
//STRIP001 	String* pOnlyTxt = 0;
//STRIP001 	if( bNoAttr )
//STRIP001 	{
//STRIP001 		if( !pWrtShell->GetSelectedText( sOnlyTxt, GETSELTXT_PARABRK_TO_ONLYCR ))
//STRIP001 			return FALSE;
//STRIP001 		pOnlyTxt = &sOnlyTxt;
//STRIP001 	}
//STRIP001 
//STRIP001 	const OfaAutoCorrCfg* pCfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001 
//STRIP001 	const USHORT nSuccess = pWrtShell->MakeGlossary( *pTmp, rName, rShortName,
//STRIP001 							pCfg->IsSaveRelFile(), pCfg->IsSaveRelNet(),
//STRIP001 							pOnlyTxt );
//STRIP001 	if(nSuccess == (USHORT) -1 )
//STRIP001 	{
//STRIP001 		InfoBox(pWrtShell->GetView().GetWindow(), SW_RES(MSG_ERR_INSERT_GLOS)).Execute();
//STRIP001 	}
//STRIP001 	if( !pCurGrp )
//STRIP001 		rStatGlossaries.PutGroupDoc( pTmp );
//STRIP001 	return BOOL( nSuccess != (USHORT) -1 );
//STRIP001 }
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Loeschen eines Textbausteines
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::DelGlossary(const String &rShortName)
//STRIP001 {
//STRIP001 	SwTextBlocks *pGlossary = pCurGrp ? pCurGrp
//STRIP001 									: rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 	//pTmp == 0 if the AutoText path setting is wrong
//STRIP001     if(!pGlossary || !ConvertToNew(*pGlossary))
//STRIP001         return FALSE;
//STRIP001 
//STRIP001 	USHORT nIdx = pGlossary->GetIndex( rShortName );
//STRIP001 	if( nIdx != (USHORT) -1 )
//STRIP001 		pGlossary->Delete( nIdx );
//STRIP001 	if( !pCurGrp )
//STRIP001 		rStatGlossaries.PutGroupDoc( pGlossary );
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung: Kurzform expandieren
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::ExpandGlossary(BOOL bUseStandard, BOOL bApi)
//STRIP001 {
//STRIP001 	ASSERT(pWrtShell->CanInsert(), illegal);
//STRIP001 	SwTextBlocks *pGlossary;
//STRIP001 	if( bUseStandard )
//STRIP001 	{
//STRIP001 		String sGroupName(SwGlossaryDlg::GetCurrGroup());
//STRIP001 		if(STRING_NOTFOUND == sGroupName.Search(GLOS_DELIM))
//STRIP001 			FindGroupName(sGroupName);
//STRIP001 		pGlossary = rStatGlossaries.GetGroupDoc(sGroupName);
//STRIP001 	}
//STRIP001 	else
//STRIP001 		pGlossary = rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 
//STRIP001 	String aShortName;
//STRIP001 
//STRIP001 		// bei Textselektion diese verwenden
//STRIP001 	if(pWrtShell->SwCrsrShell::HasSelection())
//STRIP001 	{
//STRIP001 		aShortName = pWrtShell->GetSelTxt();
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		if(pWrtShell->IsAddMode())
//STRIP001 			pWrtShell->LeaveAddMode();
//STRIP001 		else if(pWrtShell->IsExtMode())
//STRIP001 			pWrtShell->LeaveExtMode();
//STRIP001 			// Wort selektieren
//STRIP001 		pWrtShell->SelNearestWrd();
//STRIP001 			// Wort erfragen
//STRIP001 		if(pWrtShell->IsSelection())
//STRIP001 			aShortName = pWrtShell->GetSelTxt();
//STRIP001 	}
//STRIP001 	return pGlossary ? Expand( aShortName, &rStatGlossaries, pGlossary, bApi ) : FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung: Expansion aus Basic aufrufen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::ExpandGlossary( const String& rShortName, BOOL bApi )
//STRIP001 {
//STRIP001 	ASSERT(pWrtShell->CanInsert(), illegal);
//STRIP001 	String sGroup(SwGlossaryDlg::GetCurrGroup());
//STRIP001 	if(STRING_NOTFOUND == sGroup.Search(GLOS_DELIM))
//STRIP001 		FindGroupName(sGroup);
//STRIP001 
//STRIP001 	SwTextBlocks *pGlossary = rStatGlossaries.GetGroupDoc(sGroup);
//STRIP001 	return pGlossary ? Expand( rShortName, &rStatGlossaries, pGlossary, bApi ) : FALSE;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::Expand( const String& rShortName,
//STRIP001 							SwGlossaries *pGlossaries,
//STRIP001 							SwTextBlocks *pGlossary,
//STRIP001 							BOOL bApi  )
//STRIP001 {
//STRIP001 	TextBlockInfoArr aFoundArr;
//STRIP001 	String aShortName( rShortName );
//STRIP001 	BOOL bCancel = FALSE;
//STRIP001 	// Textbaustein suchen
//STRIP001 	USHORT nFound = pGlossary->GetIndex( aShortName );
//STRIP001 	// Suchen in allen anderen Bereichen
//STRIP001 	if( nFound == (USHORT) -1 )
//STRIP001 	{
//STRIP001 		const ::utl::TransliterationWrapper& rSCmp = GetAppCmpStrIgnore();
//STRIP001 		SwGlossaryList* pGlossaryList = ::GetGlossaryList();
//STRIP001 		USHORT nGroupCount = pGlossaryList->GetGroupCount();
//STRIP001 		for(USHORT i = 1; i <= nGroupCount; i++)
//STRIP001 		{
//STRIP001 			// Gruppenname mit Pfad-Extension besorgen
//STRIP001 			String sTitle;
//STRIP001 			String sGroupName = pGlossaryList->GetGroupName(i - 1, FALSE, &sTitle);
//STRIP001 			if(sGroupName == pGlossary->GetName())
//STRIP001 				continue;
//STRIP001 			USHORT nBlockCount = pGlossaryList->GetBlockCount(i -1);
//STRIP001 			if(nBlockCount)
//STRIP001 			{
//STRIP001 				for(USHORT j = 0; j < nBlockCount; j++)
//STRIP001 				{
//STRIP001 					String sEntry;
//STRIP001 					String sLongName(pGlossaryList->GetBlockName(i - 1, j, sEntry));
//STRIP001 					if( rSCmp.isEqual( rShortName, sEntry ))
//STRIP001 					{
//STRIP001 						TextBlockInfo_Impl* pData = new TextBlockInfo_Impl;
//STRIP001 						pData->sTitle = sTitle;
//STRIP001 						pData->sLongName = sLongName;
//STRIP001 						pData->sGroupName = sGroupName;
//STRIP001 						aFoundArr.Insert(pData, aFoundArr.Count());
//STRIP001 					}
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		if( aFoundArr.Count() )  // einer wurde gefunden
//STRIP001 		{
//STRIP001 			pGlossaries->PutGroupDoc(pGlossary);
//STRIP001 			if(1 == aFoundArr.Count())
//STRIP001 			{
//STRIP001 				TextBlockInfo_Impl* pData = aFoundArr.GetObject(0);
//STRIP001 				pGlossary = (SwTextBlocks *)pGlossaries->GetGroupDoc(pData->sGroupName);
//STRIP001 				nFound = pGlossary->GetIndex( aShortName );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SwSelGlossaryDlg *pDlg =
//STRIP001 					new SwSelGlossaryDlg(0, aShortName);
//STRIP001 				for(USHORT i = 0; i < aFoundArr.Count(); ++i)
//STRIP001 				{
//STRIP001 					TextBlockInfo_Impl* pData = aFoundArr.GetObject(i);
//STRIP001 					pDlg->InsertGlos(pData->sTitle, pData->sLongName);
//STRIP001 				}
//STRIP001 				pDlg->SelectEntryPos(0);
//STRIP001 				const USHORT nRet = RET_OK == pDlg->Execute()?
//STRIP001 										pDlg->GetSelectedIdx():
//STRIP001 										LISTBOX_ENTRY_NOTFOUND;
//STRIP001 				delete pDlg;
//STRIP001 				if(LISTBOX_ENTRY_NOTFOUND != nRet)
//STRIP001 				{
//STRIP001 					TextBlockInfo_Impl* pData = aFoundArr.GetObject(nRet);
//STRIP001 					pGlossary = (SwTextBlocks *)pGlossaries->GetGroupDoc(pData->sGroupName);
//STRIP001 					nFound = pGlossary->GetIndex( aShortName );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					nFound = (USHORT) -1;
//STRIP001 					bCancel = TRUE;
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 		// nicht gefunden
//STRIP001 	if( nFound == (USHORT) -1 )
//STRIP001 	{
//STRIP001 		if( !bCancel )
//STRIP001 		{
//STRIP001 			pGlossaries->PutGroupDoc(pGlossary);
//STRIP001 
//STRIP001 			const USHORT nMaxLen = 50;
//STRIP001 			if(pWrtShell->IsSelection() && aShortName.Len() > nMaxLen)
//STRIP001 			{
//STRIP001 				aShortName.Erase(nMaxLen);
//STRIP001 				aShortName.AppendAscii(" ...");
//STRIP001 			}
//STRIP001 			if(!bApi)
//STRIP001 			{
//STRIP001 				if ( aShortName.EqualsAscii ( "StarWriterTeam", 0, 14 ) )
//STRIP001 				{
//STRIP001 					String sGraphicName ( RTL_CONSTASCII_USTRINGPARAM ( "StarWriter team photo" ) );
//STRIP001 					String sTeamCredits ( RTL_CONSTASCII_USTRINGPARAM ( "StarWriter team credits" ) );
//STRIP001 					pWrtShell->StartUndo ( UNDO_INSGLOSSARY );
//STRIP001 					pWrtShell->StartAllAction();
//STRIP001 					if(pWrtShell->HasSelection())
//STRIP001 						pWrtShell->DelLeft();
//STRIP001 					Bitmap aBitmap ( SW_RES ( BMP_SW_TEAM_MUGSHOT ) );
//STRIP001 					pWrtShell->Insert ( aEmptyStr, aEmptyStr, aBitmap);
//STRIP001 					pWrtShell->SetFlyName ( sGraphicName );
//STRIP001 					SwTxtFmtColl* pColl = pWrtShell->GetTxtCollFromPool ( RES_POOLCOLL_LABEL_ABB );
//STRIP001 					SwFieldType* pType = pWrtShell->GetDoc()->GetFldType( RES_SETEXPFLD, pColl->GetName() );
//STRIP001 					sal_uInt16 nId = pWrtShell->GetDoc()->GetFldTypes()->GetPos( pType );
//STRIP001 					pWrtShell->InsertLabel( LTYPE_OBJECT, aEmptyStr, FALSE, nId );
//STRIP001 					pWrtShell->SwFEShell::SetFlyName( sTeamCredits );
//STRIP001 					pWrtShell->SwFEShell::SelectObj ( Point ( ULONG_MAX, ULONG_MAX ) );
//STRIP001 					pWrtShell->EnterStdMode();
//STRIP001 					pWrtShell->EndPara ( TRUE );
//STRIP001 					String aTmp ( SW_RES ( STR_SW_TEAM_NAMES ) );
//STRIP001 					pWrtShell->Insert ( aTmp );
//STRIP001 					SvxAdjustItem aAdjustItem( SVX_ADJUST_CENTER, RES_PARATR_ADJUST );
//STRIP001 					pWrtShell->SetAttr( aAdjustItem );
//STRIP001 					pWrtShell->SttPara ();
//STRIP001 					pWrtShell->SplitNode();
//STRIP001 					pWrtShell->Left(CRSR_SKIP_CHARS, FALSE, 1, FALSE );
//STRIP001 					SvxWeightItem aWeightItem ( WEIGHT_BOLD );
//STRIP001 					pWrtShell->Insert ( String ( RTL_CONSTASCII_USTRINGPARAM ( "The StarWriter team!" ) ) );
//STRIP001 					pWrtShell->SttPara ( TRUE );
//STRIP001 					pWrtShell->SetAttr( aWeightItem);
//STRIP001 					pWrtShell->GotoFly ( sTeamCredits);
//STRIP001 					pWrtShell->EndAllAction();
//STRIP001 					pWrtShell->EndUndo( UNDO_INSGLOSSARY );
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					String aTmp( SW_RES(STR_NOGLOS1));
//STRIP001 					aTmp += aShortName;
//STRIP001 					aTmp += SW_RESSTR(STR_NOGLOS2);
//STRIP001 					InfoBox( pWrtShell->GetView().GetWindow(), aTmp ).Execute();
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 
//STRIP001 		return FALSE;
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		String aLongName = pGlossary->GetLongName( nFound );
//STRIP001 		SvxMacro aStartMacro(aEmptyStr, aEmptyStr, STARBASIC);
//STRIP001 		SvxMacro aEndMacro(aEmptyStr, aEmptyStr, STARBASIC);
//STRIP001 		GetMacros( aShortName, aStartMacro, aEndMacro, pGlossary );
//STRIP001 
//STRIP001 	// StartAction darf nich vor HasSelection und DelRight stehen,
//STRIP001 	// sonst wird der moeglich Shellwechsel verzoegert und
//STRIP001 	// API-Programme wuerden dann haengenbleiben
//STRIP001 	// ausserdem darf das Ereignismacro ebenfalls nicht in einer Action gerufen werden
//STRIP001 		pWrtShell->StartUndo(UNDO_INSGLOSSARY);
//STRIP001 		if( aStartMacro.GetMacName().Len() )
//STRIP001 			pWrtShell->ExecMacro( aStartMacro );
//STRIP001 		if(pWrtShell->HasSelection())
//STRIP001 			pWrtShell->DelLeft();
//STRIP001 		pWrtShell->StartAllAction();
//STRIP001 
//STRIP001 		// alle InputFelder zwischenspeichern
//STRIP001 		SwInputFieldList aFldLst( pWrtShell, TRUE );
//STRIP001 
//STRIP001 		pWrtShell->InsertGlossary(*pGlossary, aShortName);
//STRIP001 		pWrtShell->EndAllAction();
//STRIP001 		if( aEndMacro.GetMacName().Len() )
//STRIP001 		{
//STRIP001 			pWrtShell->ExecMacro( aEndMacro );
//STRIP001 		}
//STRIP001 		pWrtShell->EndUndo(UNDO_INSGLOSSARY);
//STRIP001 
//STRIP001 		// fuer alle neuen InputFelder die Eingaben abfordern
//STRIP001 		if( aFldLst.BuildSortLst() )
//STRIP001 			pWrtShell->UpdateInputFlds( &aFldLst );
//STRIP001 	}
//STRIP001 	pGlossaries->PutGroupDoc(pGlossary);
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung: Textbaustein einfuegen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::InsertGlossary(const String &rName)
//STRIP001 {
//STRIP001 	ASSERT(pWrtShell->CanInsert(), illegal);
//STRIP001 
//STRIP001 	SwTextBlocks *pGlos =
//STRIP001 		pCurGrp? pCurGrp: rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 
//STRIP001 	if (!pGlos)
//STRIP001 		return FALSE;
//STRIP001 
//STRIP001 	SvxMacro aStartMacro(aEmptyStr, aEmptyStr, STARBASIC);
//STRIP001 	SvxMacro aEndMacro(aEmptyStr, aEmptyStr, STARBASIC);
//STRIP001 	GetMacros( rName, aStartMacro, aEndMacro, pGlos );
//STRIP001 
//STRIP001 	// StartAction darf nich vor HasSelection und DelRight stehen,
//STRIP001 	// sonst wird der moeglich Shellwechsel verzoegert und
//STRIP001 	// API-Programme wuerden dann haengenbleiben
//STRIP001 	// ausserdem darf das Ereignismacro ebenfalls nicht in einer Action gerufen werden
//STRIP001 	if( aStartMacro.GetMacName().Len() )
//STRIP001 		pWrtShell->ExecMacro( aStartMacro );
//STRIP001 	if( pWrtShell->HasSelection() )
//STRIP001 		pWrtShell->DelRight();
//STRIP001 	pWrtShell->StartAllAction();
//STRIP001 
//STRIP001 	// alle InputFelder zwischenspeichern
//STRIP001 	SwInputFieldList aFldLst( pWrtShell, TRUE );
//STRIP001 
//STRIP001 	pWrtShell->InsertGlossary(*pGlos, rName);
//STRIP001 	pWrtShell->EndAllAction();
//STRIP001 	if( aEndMacro.GetMacName().Len() )
//STRIP001 	{
//STRIP001 		pWrtShell->ExecMacro( aEndMacro );
//STRIP001 	}
//STRIP001 
//STRIP001 	// fuer alle neuen InputFelder die Eingaben abfordern
//STRIP001 	if( aFldLst.BuildSortLst() )
//STRIP001 		pWrtShell->UpdateInputFlds( &aFldLst );
//STRIP001 
//STRIP001 	if(!pCurGrp)
//STRIP001 		rStatGlossaries.PutGroupDoc(pGlos);
//STRIP001 	return TRUE;
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001  Beschreibung:	Macro setzen / erfragen
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 void SwGlossaryHdl::SetMacros(const String& rShortName,
//STRIP001 							  const SvxMacro* pStart,
//STRIP001 							  const SvxMacro* pEnd,
//STRIP001 							  SwTextBlocks *pGlossary )
//STRIP001 {
//STRIP001 	SwTextBlocks *pGlos = pGlossary ? pGlossary :
//STRIP001 								pCurGrp ? pCurGrp
//STRIP001 								  : rStatGlossaries.GetGroupDoc( aCurGrp );
//STRIP001 	SvxMacroTableDtor aMacroTbl;
//STRIP001 	if( pStart )
//STRIP001 		aMacroTbl.Insert( SW_EVENT_START_INS_GLOSSARY, new SvxMacro(*pStart));
//STRIP001 	if( pEnd )
//STRIP001 		aMacroTbl.Insert( SW_EVENT_END_INS_GLOSSARY, new SvxMacro(*pEnd));
//STRIP001 	int nIdx = pGlos->GetIndex( rShortName );
//STRIP001 	if( !pGlos->SetMacroTable( nIdx, aMacroTbl ) && pGlos->GetError() )
//STRIP001 		ErrorHandler::HandleError( pGlos->GetError() );
//STRIP001 
//STRIP001 	if(!pCurGrp && !pGlossary)
//STRIP001 		rStatGlossaries.PutGroupDoc(pGlos);
//STRIP001 }
//STRIP001 
//STRIP001 void SwGlossaryHdl::GetMacros( const String &rShortName,
//STRIP001 								SvxMacro& rStart,
//STRIP001 								SvxMacro& rEnd,
//STRIP001 								SwTextBlocks *pGlossary  )
//STRIP001 {
//STRIP001 	SwTextBlocks *pGlos = pGlossary ? pGlossary
//STRIP001 									: pCurGrp ? pCurGrp
//STRIP001 										: rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 	USHORT nIndex = pGlos->GetIndex( rShortName );
//STRIP001 	if( nIndex != USHRT_MAX )
//STRIP001 	{
//STRIP001 		SvxMacroTableDtor aMacroTbl;
//STRIP001 		if( pGlos->GetMacroTable( nIndex, aMacroTbl ) )
//STRIP001 		{
//STRIP001 			SvxMacro *pMacro = aMacroTbl.Get( SW_EVENT_START_INS_GLOSSARY );
//STRIP001 			if( pMacro )
//STRIP001 				rStart = *pMacro;
//STRIP001 
//STRIP001 			pMacro = aMacroTbl.Get( SW_EVENT_END_INS_GLOSSARY );
//STRIP001 			if( pMacro )
//STRIP001 				rEnd = *pMacro;
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001 	if( !pCurGrp && !pGlossary )
//STRIP001 		rStatGlossaries.PutGroupDoc( pGlos );
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	ctor, dtor
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 SwGlossaryHdl::SwGlossaryHdl(SfxViewFrame* pVwFrm, SwWrtShell *pSh)
//STRIP001 	: rStatGlossaries( *::GetGlossaries() ),
//STRIP001 	pViewFrame( pVwFrm ),
//STRIP001 	pWrtShell( pSh ),
//STRIP001 	pCurGrp( 0 ),
//STRIP001 	aCurGrp( rStatGlossaries.GetDefName() )
//STRIP001 {
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 SwGlossaryHdl::~SwGlossaryHdl()
//STRIP001 {
//STRIP001 	if( pCurGrp )
//STRIP001 		rStatGlossaries.PutGroupDoc( pCurGrp );
//STRIP001 }
//STRIP001 
//STRIP001 /*------------------------------------------------------------------------
//STRIP001 	Beschreibung:	Umbenennen eines Textbausteines
//STRIP001 ------------------------------------------------------------------------*/
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::Rename(const String& rOldShort, const String& rNewShortName,
//STRIP001 						   const String& rNewName )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	SwTextBlocks *pGlossary = pCurGrp ? pCurGrp
//STRIP001 									: rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 	if(pGlossary)
//STRIP001 	{
//STRIP001         if(!ConvertToNew(*pGlossary))
//STRIP001             return FALSE;
//STRIP001 
//STRIP001         USHORT nIdx = pGlossary->GetIndex( rOldShort );
//STRIP001 		USHORT nOldLongIdx = pGlossary->GetLongIndex( rNewName );
//STRIP001 		USHORT nOldIdx = pGlossary->GetIndex( rNewShortName );
//STRIP001 
//STRIP001 		if( nIdx != USHRT_MAX &&
//STRIP001 				(nOldLongIdx == USHRT_MAX || nOldLongIdx == nIdx )&&
//STRIP001 					(nOldIdx == USHRT_MAX || nOldIdx == nIdx ))
//STRIP001 		{
//STRIP001 			String aNewShort( rNewShortName );
//STRIP001 			String aNewName( rNewName );
//STRIP001 			pGlossary->Rename( nIdx, &aNewShort, &aNewName );
//STRIP001 			bRet = pGlossary->GetError() == 0;
//STRIP001 		}
//STRIP001 		if( !pCurGrp )
//STRIP001 			rStatGlossaries.PutGroupDoc(pGlossary);
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::IsReadOnly( const String* pGrpNm ) const
//STRIP001 {
//STRIP001 	SwTextBlocks *pGlossary = 0;
//STRIP001 
//STRIP001 	if (pGrpNm)
//STRIP001 		pGlossary = rStatGlossaries.GetGroupDoc( *pGrpNm );
//STRIP001 	else if (pCurGrp)
//STRIP001 		pGlossary = pCurGrp;
//STRIP001 	else
//STRIP001 		pGlossary = rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 
//STRIP001 	BOOL bRet = pGlossary ? pGlossary->IsReadOnly() : TRUE;
//STRIP001 	if( pGrpNm || !pCurGrp )
//STRIP001 		delete pGlossary;
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::IsOld() const
//STRIP001 {
//STRIP001 	SwTextBlocks *pGlossary = pCurGrp ? pCurGrp
//STRIP001 									  : rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 	BOOL bRet = pGlossary ? pGlossary->IsOld() : FALSE;
//STRIP001 	if( !pCurGrp )
//STRIP001 		delete pGlossary;
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 /*-----------------09.06.97 16:15-------------------
//STRIP001 	Gruppe ohne Pfadindex finden
//STRIP001 --------------------------------------------------*/
//STRIP001 BOOL SwGlossaryHdl::FindGroupName(String & rGroup)
//STRIP001 {
//STRIP001 	return rStatGlossaries.FindGroupName(rGroup);
//STRIP001 }
//STRIP001 
//STRIP001 /* -----------------29.07.99 08:34-------------------
//STRIP001 
//STRIP001  --------------------------------------------------*/
//STRIP001 BOOL SwGlossaryHdl::CopyToClipboard(SwWrtShell& rSh, const String& rShortName)
//STRIP001 {
//STRIP001 	SwTextBlocks *pGlossary = pCurGrp ? pCurGrp
//STRIP001 									: rStatGlossaries.GetGroupDoc(aCurGrp);
//STRIP001 
//STRIP001 	SwTransferable* pTransfer = new SwTransferable( rSh );
//STRIP001 /*??*/::com::sun::star::uno::Reference<
//STRIP001 		::com::sun::star::datatransfer::XTransferable > xRef( pTransfer );
//STRIP001 
//STRIP001 	int nRet = pTransfer->CopyGlossary( *pGlossary, rShortName );
//STRIP001 	if( !pCurGrp )
//STRIP001 		rStatGlossaries.PutGroupDoc( pGlossary );
//STRIP001 	return 0 != nRet;
//STRIP001 }
//STRIP001 
//STRIP001 BOOL SwGlossaryHdl::ImportGlossaries( const String& rName )
//STRIP001 {
//STRIP001 	BOOL bRet = FALSE;
//STRIP001 	if( rName.Len() )
//STRIP001 	{
//STRIP001 		const SfxFilter* pFilter = 0;
//STRIP001 		SfxMedium* pMed = new SfxMedium( rName, STREAM_READ, TRUE, 0, 0 );
//STRIP001 		SfxFilterMatcher aMatcher( SwDocShell::Factory().GetFilterContainer() );
//STRIP001 		if( !aMatcher.GuessFilter( *pMed, &pFilter, FALSE ) )
//STRIP001 		{
//STRIP001 			SwTextBlocks *pGlossary;
//STRIP001 			pMed->SetFilter( pFilter );
//STRIP001 			Reader* pR = SwIoSystem::GetReader( pFilter->GetUserData() );
//STRIP001 			if( pR && 0 != ( pGlossary = pCurGrp ? pCurGrp
//STRIP001 									: rStatGlossaries.GetGroupDoc(aCurGrp)) )
//STRIP001 			{
//STRIP001 				SwReader aReader( *pMed, rName );
//STRIP001 				if( aReader.HasGlossaries( *pR ) )
//STRIP001 				{
//STRIP001 					const OfaAutoCorrCfg* pCfg = OFF_APP()->GetAutoCorrConfig();
//STRIP001 					bRet = aReader.ReadGlossaries( *pR, *pGlossary,
//STRIP001 								pCfg->IsSaveRelFile() );
//STRIP001 				}
//STRIP001 			}
//STRIP001 		}
//STRIP001 		DELETEZ(pMed);
//STRIP001 	}
//STRIP001 	return bRet;
//STRIP001 }
//STRIP001 
//STRIP001 String SwGlossaryHdl::GetValidShortCut( const String& rLong,
//STRIP001 							 			BOOL bCheckInBlock ) const
//STRIP001 {
//STRIP001 	String sRet;
//STRIP001 	SwTextBlocks *pGlossary = pCurGrp ? pCurGrp
//STRIP001 									: rStatGlossaries.GetGroupDoc( aCurGrp );
//STRIP001 	if( pGlossary )
//STRIP001 		sRet = pGlossary->GetValidShortCut( rLong, bCheckInBlock );
//STRIP001 	return sRet;
//STRIP001 }
}
