/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_labelcfg.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:55:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _SWTYPES_HXX
//STRIP001 #include <swtypes.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _LABELCFG_HXX
//STRIP001 #include <labelcfg.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _LABIMP_HXX
//STRIP001 #include <labimp.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_UNO_ANY_HXX_
//STRIP001 #include <com/sun/star/uno/Any.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
//STRIP001 #include <com/sun/star/uno/Sequence.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _TOOLS_DEBUG_HXX
//STRIP001 #include <tools/debug.hxx>
//STRIP001 #endif
//STRIP001 #ifndef UNOTOOLS_CONFIGPATHES_HXX_INCLUDED
//STRIP001 #include <unotools/configpathes.hxx>
//STRIP001 #endif
//STRIP001 
//STRIP001 using namespace utl;
//STRIP001 using namespace rtl;
//STRIP001 using namespace ::com::sun::star::uno;
//STRIP001 using namespace ::com::sun::star::beans;
//STRIP001 
//STRIP001 #define C2U(cChar) OUString::createFromAscii(cChar)
//STRIP001 /* -----------------------------15.01.01 11:17--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SwLabelConfig::SwLabelConfig() :
//STRIP001 	ConfigItem(C2U("Office.Labels/Manufacturer"))
//STRIP001 {
//STRIP001 	aNodeNames = GetNodeNames(OUString());
//STRIP001 }
//STRIP001 /* -----------------------------06.09.00 16:50--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 SwLabelConfig::~SwLabelConfig()
//STRIP001 {
//STRIP001 }
//STRIP001 /* -----------------------------06.09.00 16:43--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void	SwLabelConfig::Commit()
//STRIP001 {
//STRIP001 	// the config item is not writable yet
//STRIP001 }
//STRIP001 /* -----------------------------15.01.01 11:42--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 Sequence<OUString> lcl_CreatePropertyNames(const OUString& rPrefix)
//STRIP001 {
//STRIP001     Sequence<OUString> aProperties(2);
//STRIP001 	OUString* pProperties = aProperties.getArray();
//STRIP001     for(sal_Int32 nProp = 0; nProp < 2; nProp++)
//STRIP001 		pProperties[nProp] = rPrefix;
//STRIP001 
//STRIP001 	pProperties[ 0] += C2U("Name");
//STRIP001     pProperties[ 1] += C2U("Measure");
//STRIP001 	return aProperties;
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 SwLabRec* lcl_CreateSwLabRec(Sequence<Any>& rValues, const OUString& rManufacturer)
//STRIP001 {
//STRIP001 	SwLabRec* pNewRec = new SwLabRec;
//STRIP001 	const Any* pValues = rValues.getConstArray();
//STRIP001 	OUString sTmp;
//STRIP001 	pNewRec->aMake = rManufacturer;
//STRIP001 	for(sal_Int32 nProp = 0; nProp < rValues.getLength(); nProp++)
//STRIP001 	{
//STRIP001 		if(pValues[nProp].hasValue())
//STRIP001 		{
//STRIP001 			switch(nProp)
//STRIP001 			{
//STRIP001 				case 0: pValues[nProp] >>= sTmp; pNewRec->aType = sTmp; break;
//STRIP001                 case 1:
//STRIP001                 {
//STRIP001 //all values are contained as colon-separated 1/100 mm values except for the
//STRIP001 //continuous flag ('C'/'S')
//STRIP001                     pValues[nProp] >>= sTmp;
//STRIP001                     String sMeasure(sTmp);
//STRIP001                     USHORT nTokenCount = sMeasure.GetTokenCount(';');
//STRIP001                     xub_StrLen nIdx = 0;
//STRIP001                     for(USHORT i = 0; i < nTokenCount; i++)
//STRIP001                     {
//STRIP001                         String sToken(sMeasure.GetToken(i, ';' ));
//STRIP001                         int nVal = sToken.ToInt32();
//STRIP001                         switch(i)
//STRIP001                         {
//STRIP001                             case 0 : pNewRec->bCont = sToken.GetChar(0) == 'C'; break;
//STRIP001                             case 1 : pNewRec->lHDist    = MM100_TO_TWIP(nVal);break;
//STRIP001                             case 2 : pNewRec->lVDist    = MM100_TO_TWIP(nVal);break;
//STRIP001                             case 3 : pNewRec->lWidth    = MM100_TO_TWIP(nVal);break;
//STRIP001                             case 4 : pNewRec->lHeight   = MM100_TO_TWIP(nVal); break;
//STRIP001                             case 5 : pNewRec->lLeft     = MM100_TO_TWIP(nVal);break;
//STRIP001                             case 6 : pNewRec->lUpper    = MM100_TO_TWIP(nVal);break;
//STRIP001                             case 7 : pNewRec->nCols     = nVal; break;
//STRIP001                             case 8 : pNewRec->nRows     = nVal; break;
//STRIP001                         }
//STRIP001                     }
//STRIP001                 }
//STRIP001                 break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return pNewRec;
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 Sequence<PropertyValue>	lcl_CreateProperties(
//STRIP001 	Sequence<OUString>& rPropNames, const SwLabRec& rRec)
//STRIP001 {
//STRIP001 	const OUString* pNames = rPropNames.getConstArray();
//STRIP001 	Sequence<PropertyValue>	aRet(rPropNames.getLength());
//STRIP001 	PropertyValue* pValues = aRet.getArray();
//STRIP001     OUString sColon(C2U(";"));
//STRIP001 
//STRIP001     for(sal_Int32 nProp = 0; nProp < rPropNames.getLength(); nProp++)
//STRIP001 	{
//STRIP001 		pValues[nProp].Name = pNames[nProp];
//STRIP001 		switch(nProp)
//STRIP001 		{
//STRIP001 			case 0: pValues[nProp].Value <<= OUString(rRec.aType); break;
//STRIP001             case 1:
//STRIP001             {
//STRIP001                 OUString sTmp;
//STRIP001                 sTmp += C2U( rRec.bCont ? "C" : "S");                            sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(TWIP_TO_MM100(rRec.lHDist) );           sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(TWIP_TO_MM100(rRec.lVDist));            sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(TWIP_TO_MM100(rRec.lWidth)  );          sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(TWIP_TO_MM100(rRec.lHeight) );          sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(TWIP_TO_MM100(rRec.lLeft)   );          sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(TWIP_TO_MM100(rRec.lUpper)  );          sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(rRec.nCols   );sTmp += sColon;
//STRIP001                 sTmp += OUString::valueOf(rRec.nRows   );
//STRIP001                 pValues[nProp].Value <<= sTmp;
//STRIP001             }
//STRIP001             break;
//STRIP001         }
//STRIP001 	}
//STRIP001 	return aRet;
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void	SwLabelConfig::FillLabels(const OUString& rManufacturer, SwLabRecs& rLabArr)
//STRIP001 {
//STRIP001     OUString sManufacturer(wrapConfigurationElementName(rManufacturer));
//STRIP001     const Sequence<OUString> aLabels = GetNodeNames(sManufacturer);
//STRIP001 	const OUString* pLabels = aLabels.getConstArray();
//STRIP001     for(sal_Int32 nLabel = 0; nLabel < aLabels.getLength(); nLabel++)
//STRIP001 	{
//STRIP001 		OUString sPrefix(sManufacturer);
//STRIP001 		sPrefix += C2U("/");
//STRIP001 		sPrefix += pLabels[nLabel];
//STRIP001 		sPrefix += C2U("/");
//STRIP001 		Sequence<OUString> aPropNames = lcl_CreatePropertyNames(sPrefix);
//STRIP001 		Sequence<Any>	aValues = GetProperties(aPropNames);
//STRIP001 		SwLabRec* pNewRec = lcl_CreateSwLabRec(aValues, rManufacturer);
//STRIP001         rLabArr.C40_INSERT( SwLabRec, pNewRec, rLabArr.Count() );
//STRIP001 	}
//STRIP001 }
//STRIP001 /* -----------------------------23.01.01 11:36--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool	SwLabelConfig::HasLabel(const ::rtl::OUString& rManufacturer, const ::rtl::OUString& rType)
//STRIP001 {
//STRIP001 	const OUString* pNode = aNodeNames.getConstArray();
//STRIP001 	sal_Bool bFound = sal_False;
//STRIP001 	for(sal_Int32 nNode = 0; nNode < aNodeNames.getLength() && !bFound; nNode++)
//STRIP001 	{
//STRIP001 		if(pNode[nNode] == rManufacturer)
//STRIP001 			bFound = sal_True;
//STRIP001 	}
//STRIP001 	if(bFound)
//STRIP001 	{
//STRIP001 		OUString sManufacturer(wrapConfigurationElementName(rManufacturer));
//STRIP001         const Sequence<OUString> aLabels = GetNodeNames(sManufacturer);
//STRIP001 		const OUString* pLabels = aLabels.getConstArray();
//STRIP001 		for(sal_Int32 nLabel = 0; nLabel < aLabels.getLength(); nLabel++)
//STRIP001 		{
//STRIP001 			OUString sPrefix(sManufacturer);
//STRIP001 			sPrefix += C2U("/");
//STRIP001 			sPrefix += pLabels[nLabel];
//STRIP001 			sPrefix += C2U("/");
//STRIP001 			Sequence<OUString> aProperties(1);
//STRIP001 			aProperties.getArray()[0] = sPrefix;
//STRIP001 			aProperties.getArray()[0] += C2U("Name");
//STRIP001 			Sequence<Any>	aValues = GetProperties(aProperties);
//STRIP001 			const Any* pValues = aValues.getConstArray();
//STRIP001 			if(pValues[0].hasValue())
//STRIP001 			{
//STRIP001 				OUString sTmp;
//STRIP001 				pValues[0] >>= sTmp;
//STRIP001 				if(rType == sTmp)
//STRIP001 					return sal_True;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 /* -----------------------------23.01.01 11:36--------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool lcl_Exists(const OUString& rNode, const Sequence<OUString>& rLabels)
//STRIP001 {
//STRIP001 	const OUString* pLabels = rLabels.getConstArray();
//STRIP001 	for(sal_Int32 i = 0; i < rLabels.getLength(); i++)
//STRIP001 		if(pLabels[i] == rNode)
//STRIP001 			return sal_True;
//STRIP001 	return sal_False;
//STRIP001 }
//STRIP001 //-----------------------------------------------------------------------------
//STRIP001 void SwLabelConfig::SaveLabel( 	const ::rtl::OUString& rManufacturer,
//STRIP001 		const ::rtl::OUString& rType,	const SwLabRec& rRec)
//STRIP001 {
//STRIP001 	const OUString* pNode = aNodeNames.getConstArray();
//STRIP001 	sal_Bool bFound = sal_False;
//STRIP001 	for(sal_Int32 nNode = 0; nNode < aNodeNames.getLength() && !bFound; nNode++)
//STRIP001 	{
//STRIP001 		if(pNode[nNode] == rManufacturer)
//STRIP001 			bFound = sal_True;
//STRIP001 	}
//STRIP001 	if(!bFound)
//STRIP001 	{
//STRIP001 		if(!AddNode(OUString(), rManufacturer))
//STRIP001 		{
//STRIP001 			DBG_ERROR("New configuration node could not be created")
//STRIP001 			return ;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			aNodeNames = GetNodeNames(OUString());
//STRIP001 		}
//STRIP001 	}
//STRIP001 
//STRIP001     OUString sManufacturer(wrapConfigurationElementName(rManufacturer));
//STRIP001 	const Sequence<OUString> aLabels = GetNodeNames(sManufacturer);
//STRIP001 	const OUString* pLabels = aLabels.getConstArray();
//STRIP001 	OUString sFoundNode;
//STRIP001 	for(sal_Int32 nLabel = 0; nLabel < aLabels.getLength(); nLabel++)
//STRIP001 	{
//STRIP001 		OUString sPrefix(sManufacturer);
//STRIP001 		sPrefix += C2U("/");
//STRIP001 		sPrefix += pLabels[nLabel];
//STRIP001 		sPrefix += C2U("/");
//STRIP001 		Sequence<OUString> aProperties(1);
//STRIP001 		aProperties.getArray()[0] = sPrefix;
//STRIP001 		aProperties.getArray()[0] += C2U("Name");
//STRIP001 		Sequence<Any>	aValues = GetProperties(aProperties);
//STRIP001 		const Any* pValues = aValues.getConstArray();
//STRIP001 		if(pValues[0].hasValue())
//STRIP001 		{
//STRIP001 			OUString sTmp;
//STRIP001 			pValues[0] >>= sTmp;
//STRIP001 			if(rType == sTmp)
//STRIP001 			{
//STRIP001 				sFoundNode = pLabels[nLabel];
//STRIP001 				break;
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	// if not found - generate a unique node name
//STRIP001 	if(!sFoundNode.getLength())
//STRIP001 	{
//STRIP001 		sal_Int32 nIndex = aLabels.getLength();
//STRIP001 		OUString sPrefix(C2U("Label"));
//STRIP001 		sFoundNode = sPrefix;
//STRIP001 		sFoundNode += OUString::valueOf(nIndex);
//STRIP001 		while(lcl_Exists(sFoundNode, aLabels))
//STRIP001 		{
//STRIP001 			sFoundNode = sPrefix;
//STRIP001 			sFoundNode += OUString::valueOf(nIndex++);
//STRIP001 		}
//STRIP001 	}
//STRIP001 	OUString sPrefix(wrapConfigurationElementName(rManufacturer));
//STRIP001 	sPrefix += C2U("/");
//STRIP001 	sPrefix += sFoundNode;
//STRIP001 	sPrefix += C2U("/");
//STRIP001 	Sequence<OUString> aPropNames = lcl_CreatePropertyNames(sPrefix);
//STRIP001 	Sequence<PropertyValue>	aPropValues = lcl_CreateProperties(aPropNames, rRec);
//STRIP001 	SetSetProperties(wrapConfigurationElementName(rManufacturer), aPropValues);
//STRIP001 
//STRIP001 }


}
