/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_labfmt.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 04:56:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#pragma hdrstop

// auto strip #ifndef _TL_POLY_HXX
// auto strip #include <tools/poly.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif

#include "swtypes.hxx"
#include "cmdid.h"
// auto strip #include "label.hxx"
// auto strip #include "labimp.hxx"
// auto strip #include "labimg.hxx"
// auto strip #include "labfmt.hxx"
// auto strip #include "uitool.hxx"

#include "label.hrc"
#include "labfmt.hrc"

// auto strip #ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
// auto strip #include <com/sun/star/uno/Sequence.hxx>
// auto strip #endif
namespace binfilter {

using namespace utl;
using namespace rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;

// #define ------------------------------------------------------------------

#define ROUND(x) ((USHORT) ((x) + .5))
#define C2S(cChar) String::CreateFromAscii(cChar)
#define C2U(cChar) OUString::createFromAscii(cChar)
// --------------------------------------------------------------------------
//STRIP001 SwLabPreview::SwLabPreview( const SwLabFmtPage* pParent, const ResId& rResID ) :
//STRIP001 
//STRIP001 	Window((Window*) pParent, rResID),
//STRIP001 
//STRIP001 	aHDistStr (SW_RES(STR_HDIST )),
//STRIP001 	aVDistStr (SW_RES(STR_VDIST )),
//STRIP001 	aWidthStr (SW_RES(STR_WIDTH )),
//STRIP001 	aHeightStr(SW_RES(STR_HEIGHT)),
//STRIP001 	aLeftStr  (SW_RES(STR_LEFT  )),
//STRIP001 	aUpperStr (SW_RES(STR_UPPER )),
//STRIP001 	aColsStr  (SW_RES(STR_COLS  )),
//STRIP001     aRowsStr  (SW_RES(STR_ROWS  )),
//STRIP001     aGrayColor(COL_LIGHTGRAY)
//STRIP001 {
//STRIP001 	SetMapMode(MAP_PIXEL);
//STRIP001 
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001     const Color& rWinColor = rStyleSettings.GetWindowColor();
//STRIP001     SetBackground(Wallpaper(rWinColor));
//STRIP001 
//STRIP001     Font aFont = GetFont();
//STRIP001     aFont.SetTransparent(TRUE);
//STRIP001 	aFont.SetWeight	 (WEIGHT_NORMAL);
//STRIP001 	SetFont(aFont);
//STRIP001 
//STRIP001     const Size aSz(GetOutputSizePixel());
//STRIP001 
//STRIP001 	lOutWPix   = aSz.Width ();
//STRIP001 	lOutHPix   = aSz.Height();
//STRIP001 
//STRIP001 
//STRIP001 	lHDistWidth  = GetTextWidth(aHDistStr );
//STRIP001 	lVDistWidth  = GetTextWidth(aVDistStr );
//STRIP001 	lHeightWidth = GetTextWidth(aHeightStr);
//STRIP001 	lLeftWidth	 = GetTextWidth(aLeftStr  );
//STRIP001 	lUpperWidth  = GetTextWidth(aUpperStr );
//STRIP001 	lColsWidth	 = GetTextWidth(aColsStr  );
//STRIP001 
//STRIP001 	lXHeight = GetTextHeight();
//STRIP001 	lXWidth  = GetTextWidth('X');
//STRIP001 
//STRIP001 	// Skalierungsfaktor
//STRIP001 	float fx = (float)(lOutWPix - (2 * (lLeftWidth + 15))) / (float)lOutWPix;
//STRIP001 
//STRIP001 	lOutWPix23 = (long)((float)lOutWPix * fx);
//STRIP001 	lOutHPix23 = (long)((float)lOutHPix * fx);
//STRIP001 }

// --------------------------------------------------------------------------
//STRIP001 SwLabPreview::~SwLabPreview()
//STRIP001 {
//STRIP001 }
// --------------------------------------------------------------------------
//STRIP001 void SwLabPreview::Paint(const Rectangle &rRect)
//STRIP001 {
//STRIP001     const StyleSettings& rStyleSettings = GetSettings().GetStyleSettings();
//STRIP001     const Color& rWinColor = rStyleSettings.GetWindowColor();
//STRIP001     const Color& rFieldTextColor = SwViewOption::GetFontColor();
//STRIP001 
//STRIP001     Font aFont = GetFont();
//STRIP001     aFont.SetFillColor( rWinColor );
//STRIP001     aFont.SetColor(rFieldTextColor);
//STRIP001 	SetFont(aFont);
//STRIP001 
//STRIP001     SetBackground(Wallpaper(rWinColor));
//STRIP001 
//STRIP001     SetLineColor(rWinColor);
//STRIP001 	SetFillColor(aGrayColor);
//STRIP001 	Font aPaintFont(GetFont());
//STRIP001 	aPaintFont.SetTransparent(FALSE);
//STRIP001 	SetFont(aPaintFont);
//STRIP001 
//STRIP001 	// Groesse des darzustellenden Bereichs
//STRIP001 	long lDispW = ROUND(aItem.lLeft  + aItem.lHDist);
//STRIP001 	long lDispH = ROUND(aItem.lUpper + aItem.lVDist);
//STRIP001 	if (aItem.nCols == 1)
//STRIP001 		lDispW += ROUND(aItem.lLeft );
//STRIP001 	else
//STRIP001 		lDispW += ROUND(aItem.lHDist / 10);
//STRIP001 	if (aItem.nRows == 1)
//STRIP001 		lDispH += ROUND(aItem.lUpper);
//STRIP001 	else
//STRIP001 		lDispH += ROUND(aItem.lVDist / 10);
//STRIP001 
//STRIP001 	// Skalierungsfaktor
//STRIP001 	float fx = (float) lOutWPix23 / Max(1L, lDispW),
//STRIP001 		  fy = (float) lOutHPix23 / Max(1L, lDispH),
//STRIP001 		  f  = fx < fy ? fx : fy;
//STRIP001 
//STRIP001 	// Nullpunkt
//STRIP001 	long lOutlineW = ROUND(f * lDispW);
//STRIP001 	long lOutlineH = ROUND(f * lDispH);
//STRIP001 
//STRIP001 	long lX0 = (lOutWPix - lOutlineW) / 2;
//STRIP001 	long lY0 = (lOutHPix - lOutlineH) / 2;
//STRIP001 	long lX1 = ROUND(lX0 + f *	aItem.lLeft );
//STRIP001 	long lY1 = ROUND(lY0 + f *	aItem.lUpper);
//STRIP001 	long lX2 = ROUND(lX0 + f * (aItem.lLeft  + aItem.lWidth ));
//STRIP001 	long lY2 = ROUND(lY0 + f * (aItem.lUpper + aItem.lHeight));
//STRIP001 	long lX3 = ROUND(lX0 + f * (aItem.lLeft  + aItem.lHDist ));
//STRIP001 	long lY3 = ROUND(lY0 + f * (aItem.lUpper + aItem.lVDist ));
//STRIP001 
//STRIP001 	// Umriss zeichnen (Flaeche)
//STRIP001 	DrawRect(Rectangle(Point(lX0, lY0), Size(lOutlineW, lOutlineH)));
//STRIP001 
//STRIP001 	// Umriss zeichnen (Umrandung)
//STRIP001     SetLineColor(rFieldTextColor);
//STRIP001 	DrawLine(Point(lX0, lY0), Point(lX0 + lOutlineW - 1, lY0)); // Oben
//STRIP001 	DrawLine(Point(lX0, lY0), Point(lX0, lY0 + lOutlineH - 1)); // Links
//STRIP001 	if (aItem.nCols == 1)
//STRIP001 		DrawLine(Point(lX0 + lOutlineW - 1, lY0), Point(lX0 + lOutlineW - 1, lY0 + lOutlineH - 1)); // Rechts
//STRIP001 	if (aItem.nRows == 1)
//STRIP001 		DrawLine(Point(lX0, lY0 + lOutlineH - 1), Point(lX0 + lOutlineW - 1, lY0 + lOutlineH - 1)); // Unten
//STRIP001 
//STRIP001 	// Etiketten
//STRIP001 	SetClipRegion (Rectangle(Point(lX0, lY0), Size(lOutlineW, lOutlineH)));
//STRIP001     SetFillColor(rWinColor);
//STRIP001 	for (USHORT nRow = 0; nRow < Min((USHORT) 2, (USHORT) aItem.nRows); nRow++)
//STRIP001 		for (USHORT nCol = 0; nCol < Min((USHORT) 2, (USHORT) aItem.nCols); nCol++)
//STRIP001 			DrawRect(Rectangle(
//STRIP001 			  Point(ROUND(lX0 + f * (aItem.lLeft  + nCol * aItem.lHDist)),
//STRIP001 					ROUND(lY0 + f * (aItem.lUpper + nRow * aItem.lVDist))),
//STRIP001 			  Size (ROUND(f * aItem.lWidth ),
//STRIP001 					ROUND(f * aItem.lHeight))));
//STRIP001 	SetClipRegion();
//STRIP001 
//STRIP001 	// Beschritung: Rand links
//STRIP001 	if (aItem.lLeft)
//STRIP001 	{
//STRIP001 		long lX = (lX0 + lX1) / 2;
//STRIP001 		DrawArrow(Point(lX0, lY0 - 5), Point(lX1, lY0 - 5), FALSE);
//STRIP001 		DrawArrow(Point(lX, lY0 - 10), Point(lX, lY0 - 5), TRUE);
//STRIP001 		DrawText(Point(lX1 - lLeftWidth, lY0 - 10 - lXHeight), aLeftStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Beschriftung: Rand oben
//STRIP001 	if (aItem.lUpper)
//STRIP001 	{
//STRIP001 		DrawArrow(Point(lX0 - 5, lY0), Point(lX0 - 5, lY1), FALSE);
//STRIP001 		DrawText(Point(lX0 - 10 - lUpperWidth, ROUND(lY0 + f * aItem.lUpper / 2 - lXHeight / 2)), aUpperStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Beschriftung: Breite und Hoehe
//STRIP001 	{
//STRIP001 		long lX = lX2 - lXWidth / 2 - lHeightWidth / 2;
//STRIP001 		long lY = lY1 + lXHeight;
//STRIP001 
//STRIP001 		DrawLine(Point(lX1, lY), Point(lX2 - 1, lY));
//STRIP001 		DrawLine(Point(lX, lY1), Point(lX, lY2 - 1));
//STRIP001 
//STRIP001 		DrawText(Point(lX1 + lXWidth / 2, lY - lXHeight / 2), aWidthStr);
//STRIP001 		DrawText(Point(lX - lHeightWidth / 2, lY2 - lXHeight - lXHeight / 2), aHeightStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Beschriftung: Horz. Abstand
//STRIP001 	if (aItem.nCols > 1)
//STRIP001 	{
//STRIP001 		long lX = (lX1 + lX3) / 2;
//STRIP001 		DrawArrow(Point(lX1, lY0 - 5), Point(lX3, lY0 - 5), FALSE);
//STRIP001 		DrawArrow(Point(lX, lY0 - 10), Point(lX, lY0 - 5), TRUE);
//STRIP001 		DrawText(Point(lX - lHDistWidth / 2, lY0 - 10 - lXHeight), aHDistStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Beschriftung: Vertikaler Abstand
//STRIP001 	if (aItem.nRows > 1)
//STRIP001 	{
//STRIP001 		DrawArrow(Point(lX0 - 5, lY1), Point(lX0 - 5, lY3), FALSE);
//STRIP001 		DrawText(Point(lX0 - 10 - lVDistWidth, ROUND(lY1 + f * aItem.lVDist / 2 - lXHeight / 2)), aVDistStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Beschriftung: Spalten
//STRIP001 	{
//STRIP001 		long lY = lY0 + lOutlineH + 4;
//STRIP001 		DrawArrow(Point(lX0, lY), Point(lX0 + lOutlineW - 1, lY), TRUE);
//STRIP001 		DrawText(Point((lX0 + lX0 + lOutlineW - 1) / 2 - lColsWidth / 2, lY + 5), aColsStr);
//STRIP001 	}
//STRIP001 
//STRIP001 	// Beschriftung: Zeilen
//STRIP001 	{
//STRIP001 		long lX = lX0 + lOutlineW + 4;
//STRIP001 		DrawArrow(Point(lX, lY0), Point(lX, lY0 + lOutlineH - 1), TRUE);
//STRIP001 		DrawText(Point(lX + 5, (lY0 + lY0 + lOutlineH - 1 - lXHeight / 2) / 2), aRowsStr);
//STRIP001 	}
//STRIP001 }

// Pfeil bzw. Intervall zeichnen --------------------------------------------



//STRIP001 void SwLabPreview::DrawArrow(const Point &rP1, const Point &rP2, BOOL bArrow)
//STRIP001 {
//STRIP001 	DrawLine(rP1, rP2);
//STRIP001 
//STRIP001 	if (bArrow)
//STRIP001 	{
//STRIP001 		Point aArr[3];
//STRIP001 
//STRIP001 		// Pfeil zeichnen
//STRIP001 		if (rP1.Y() == rP2.Y())
//STRIP001 		{
//STRIP001 			// Waagerecht
//STRIP001 			aArr[0].X() = rP2.X() - 5;
//STRIP001 			aArr[0].Y() = rP2.Y() - 2;
//STRIP001 			aArr[1].X() = rP2.X();
//STRIP001 			aArr[1].Y() = rP2.Y();
//STRIP001 			aArr[2].X() = rP2.X() - 5;
//STRIP001 			aArr[2].Y() = rP2.Y() + 2;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Senkrecht
//STRIP001 			aArr[0].X() = rP2.X() - 2;
//STRIP001 			aArr[0].Y() = rP2.Y() - 5;
//STRIP001 			aArr[1].X() = rP2.X() + 2;
//STRIP001 			aArr[1].Y() = rP2.Y() - 5;
//STRIP001 			aArr[2].X() = rP2.X();
//STRIP001 			aArr[2].Y() = rP2.Y();
//STRIP001 		}
//STRIP001 
//STRIP001         const Color& rFieldTextColor = SwViewOption::GetFontColor();
//STRIP001         SetFillColor(rFieldTextColor);
//STRIP001 		DrawPolygon(Polygon(3, aArr));
//STRIP001 	}
//STRIP001 	else
//STRIP001 	{
//STRIP001 		// Intervall zeichnen
//STRIP001 		if (rP1.Y() == rP2.Y())
//STRIP001 		{
//STRIP001 			// Waagerecht
//STRIP001 			DrawLine(Point(rP1.X(), rP1.Y() - 2), Point(rP1.X(), rP1.Y() + 2));
//STRIP001 			DrawLine(Point(rP2.X(), rP2.Y() - 2), Point(rP2.X(), rP2.Y() + 2));
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			// Senkrecht
//STRIP001 			DrawLine(Point(rP1.X() - 2, rP1.Y()), Point(rP1.X() + 2, rP1.Y()));
//STRIP001 			DrawLine(Point(rP2.X() - 2, rP2.Y()), Point(rP2.X() + 2, rP2.Y()));
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

// --------------------------------------------------------------------------

//STRIP001 void SwLabPreview::Update(const SwLabItem& rItem)
//STRIP001 {
//STRIP001 	aItem = rItem;
//STRIP001 	Invalidate();
//STRIP001 }

// --------------------------------------------------------------------------



//STRIP001 SwLabFmtPage::SwLabFmtPage(Window* pParent, const SfxItemSet& rSet) :
//STRIP001 
//STRIP001 	SfxTabPage(pParent, SW_RES(TP_LAB_FMT), rSet),
//STRIP001 	aItem		 ((const SwLabItem&) rSet.Get(FN_LABEL)),
//STRIP001 	aMakeFI		 (this, ResId(FI_MAKE)),
//STRIP001 	aTypeFI      (this, ResId(FI_TYPE)),
//STRIP001 	aPreview	 (this, ResId(WIN_PREVIEW)),
//STRIP001 	aHDistText	 (this, ResId(TXT_HDIST  )),
//STRIP001 	aHDistField  (this, ResId(FLD_HDIST  )),
//STRIP001 	aVDistText	 (this, ResId(TXT_VDIST  )),
//STRIP001 	aVDistField  (this, ResId(FLD_VDIST  )),
//STRIP001 	aWidthText	 (this, ResId(TXT_WIDTH  )),
//STRIP001 	aWidthField  (this, ResId(FLD_WIDTH  )),
//STRIP001 	aHeightText  (this, ResId(TXT_HEIGHT )),
//STRIP001 	aHeightField (this, ResId(FLD_HEIGHT )),
//STRIP001 	aLeftText	 (this, ResId(TXT_LEFT	 )),
//STRIP001 	aLeftField	 (this, ResId(FLD_LEFT	 )),
//STRIP001 	aUpperText	 (this, ResId(TXT_UPPER  )),
//STRIP001 	aUpperField  (this, ResId(FLD_UPPER  )),
//STRIP001 	aColsText	 (this, ResId(TXT_COLUMNS)),
//STRIP001 	aColsField	 (this, ResId(FLD_COLUMNS)),
//STRIP001 	aRowsText	 (this, ResId(TXT_ROWS	 )),
//STRIP001 	aRowsField	 (this, ResId(FLD_ROWS	 )),
//STRIP001 	aSavePB		 (this, ResId(PB_SAVE  )),
//STRIP001 	bModified(FALSE)
//STRIP001 
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 	SetExchangeSupport();
//STRIP001 
//STRIP001 	// Metriken
//STRIP001 	FieldUnit aMetric = ::GetDfltMetric(FALSE);
//STRIP001 	SetMetric(aHDistField , aMetric);
//STRIP001 	SetMetric(aVDistField , aMetric);
//STRIP001 	SetMetric(aWidthField , aMetric);
//STRIP001 	SetMetric(aHeightField, aMetric);
//STRIP001 	SetMetric(aLeftField  , aMetric);
//STRIP001 	SetMetric(aUpperField , aMetric);
//STRIP001 
//STRIP001 	// Handler installieren
//STRIP001 	Link aLk = LINK(this, SwLabFmtPage, ModifyHdl);
//STRIP001 	aHDistField .SetModifyHdl( aLk );
//STRIP001 	aVDistField .SetModifyHdl( aLk );
//STRIP001 	aWidthField .SetModifyHdl( aLk );
//STRIP001 	aHeightField.SetModifyHdl( aLk );
//STRIP001 	aLeftField	.SetModifyHdl( aLk );
//STRIP001 	aUpperField .SetModifyHdl( aLk );
//STRIP001 	aColsField	.SetModifyHdl( aLk );
//STRIP001 	aRowsField	.SetModifyHdl( aLk );
//STRIP001 
//STRIP001 	aLk = LINK(this, SwLabFmtPage, LoseFocusHdl);
//STRIP001 	aHDistField .SetLoseFocusHdl( aLk );
//STRIP001 	aVDistField .SetLoseFocusHdl( aLk );
//STRIP001 	aWidthField .SetLoseFocusHdl( aLk );
//STRIP001 	aHeightField.SetLoseFocusHdl( aLk );
//STRIP001 	aLeftField	.SetLoseFocusHdl( aLk );
//STRIP001 	aUpperField .SetLoseFocusHdl( aLk );
//STRIP001 	aColsField	.SetLoseFocusHdl( aLk );
//STRIP001 	aRowsField	.SetLoseFocusHdl( aLk );
//STRIP001 
//STRIP001 	aSavePB.SetClickHdl( LINK (this, SwLabFmtPage, SaveHdl));
//STRIP001 	// Timer einstellen
//STRIP001 	aPreviewTimer.SetTimeout(1000);
//STRIP001 	aPreviewTimer.SetTimeoutHdl(LINK(this, SwLabFmtPage, PreviewHdl));
//STRIP001 }

// --------------------------------------------------------------------------



//STRIP001 SwLabFmtPage::~SwLabFmtPage()
//STRIP001 {
//STRIP001 }

// Modify-Handler der MetricFields. Preview-Timer starten -------------------



//STRIP001 IMPL_LINK_INLINE_START( SwLabFmtPage, ModifyHdl, Edit *, EMPTYARG )
//STRIP001 {
//STRIP001 	bModified = TRUE;
//STRIP001 	aPreviewTimer.Start();
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwLabFmtPage, ModifyHdl, Edit *, EMPTYARG )

// Preview invalidaten ------------------------------------------------------



//STRIP001 IMPL_LINK_INLINE_START( SwLabFmtPage, PreviewHdl, Timer *, EMPTYARG )
//STRIP001 {
//STRIP001 	aPreviewTimer.Stop();
//STRIP001 	ChangeMinMax();
//STRIP001 	FillItem( aItem );
//STRIP001 	aPreview.Update( aItem );
//STRIP001 
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwLabFmtPage, PreviewHdl, Timer *, EMPTYARG )

// LoseFocus-Handler: Bei Aenderung sofort updaten --------------------------



//STRIP001 IMPL_LINK_INLINE_START( SwLabFmtPage, LoseFocusHdl, Control *, pControl )
//STRIP001 {
//STRIP001 	if (((Edit*) pControl)->IsModified())
//STRIP001 		PreviewHdl(0);
//STRIP001 	return 0;
//STRIP001 }
//STRIP001 IMPL_LINK_INLINE_END( SwLabFmtPage, LoseFocusHdl, Control *, pControl )

// Minima und Maxima fuer Fields festlegen ----------------------------------


//STRIP001 void SwLabFmtPage::ChangeMinMax()
//STRIP001 {
//STRIP001 	long lMax = 31748; // 56 cm
//STRIP001 
//STRIP001 	// Min und Max
//STRIP001 
//STRIP001 	long lLeft	= GETFLDVAL(aLeftField ),
//STRIP001 		 lUpper = GETFLDVAL(aUpperField),
//STRIP001 		 lHDist = GETFLDVAL(aHDistField),
//STRIP001 		 lVDist = GETFLDVAL(aVDistField);
//STRIP001 
//STRIP001 	long nMinSize = 10;	// 0,1cm
//STRIP001 
//STRIP001 	aHDistField .SetMin(nMinSize, FUNIT_CM);
//STRIP001 	aVDistField .SetMin(nMinSize, FUNIT_CM);
//STRIP001 
//STRIP001 	aHDistField .SetMax((long) 100 * ((lMax - lLeft ) / Max(1L, (long) aColsField.GetValue())), FUNIT_TWIP);
//STRIP001 	aVDistField .SetMax((long) 100 * ((lMax - lUpper) / Max(1L, (long) aRowsField.GetValue())), FUNIT_TWIP);
//STRIP001 
//STRIP001 	aWidthField .SetMin(nMinSize, FUNIT_CM);
//STRIP001 	aHeightField.SetMin(nMinSize, FUNIT_CM);
//STRIP001 
//STRIP001 	aWidthField .SetMax((long) 100 * (lHDist), FUNIT_TWIP);
//STRIP001 	aHeightField.SetMax((long) 100 * (lVDist), FUNIT_TWIP);
//STRIP001 
//STRIP001 	aLeftField	.SetMax((long) 100 * (lMax - (long) aColsField.GetValue() * GETFLDVAL(aHDistField)), FUNIT_TWIP);
//STRIP001 	aUpperField .SetMax((long) 100 * (lMax - (long) aRowsField.GetValue() * GETFLDVAL(aVDistField)), FUNIT_TWIP);
//STRIP001 
//STRIP001 	aColsField	.SetMax((lMax - lLeft ) / Max(1L, lHDist));
//STRIP001 	aRowsField	.SetMax((lMax - lUpper) / Max(1L, lVDist));
//STRIP001 
//STRIP001 	// First und Last
//STRIP001 
//STRIP001 	aHDistField .SetFirst(aHDistField .GetMin());
//STRIP001 	aVDistField .SetFirst(aVDistField .GetMin());
//STRIP001 
//STRIP001 	aHDistField .SetLast (aHDistField .GetMax());
//STRIP001 	aVDistField .SetLast (aVDistField .GetMax());
//STRIP001 
//STRIP001 	aWidthField .SetFirst(aWidthField .GetMin());
//STRIP001 	aHeightField.SetFirst(aHeightField.GetMin());
//STRIP001 
//STRIP001 	aWidthField .SetLast (aWidthField .GetMax());
//STRIP001 	aHeightField.SetLast (aHeightField.GetMax());
//STRIP001 
//STRIP001 	aLeftField	.SetLast (aLeftField  .GetMax());
//STRIP001 	aUpperField .SetLast (aUpperField .GetMax());
//STRIP001 
//STRIP001 	aColsField	.SetLast (aColsField  .GetMax());
//STRIP001 	aRowsField	.SetLast (aRowsField  .GetMax());
//STRIP001 
//STRIP001 	aHDistField .Reformat();
//STRIP001 	aVDistField .Reformat();
//STRIP001 	aWidthField .Reformat();
//STRIP001 	aHeightField.Reformat();
//STRIP001 	aLeftField	.Reformat();
//STRIP001 	aUpperField .Reformat();
//STRIP001 	aColsField	.Reformat();
//STRIP001 	aRowsField	.Reformat();
//STRIP001 }

// --------------------------------------------------------------------------



//STRIP001 SfxTabPage* SwLabFmtPage::Create(Window* pParent, const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	return new SwLabFmtPage(pParent, rSet);
//STRIP001 }

// ----------------------------------------------------------------------------



//STRIP001 void SwLabFmtPage::ActivatePage(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	SfxItemSet aSet(rSet);
//STRIP001 	Reset(aSet);
//STRIP001 }

// ----------------------------------------------------------------------------



//STRIP001 int SwLabFmtPage::DeactivatePage(SfxItemSet* pSet)
//STRIP001 {
//STRIP001 	if (pSet)
//STRIP001 		FillItemSet(*pSet);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// --------------------------------------------------------------------------



//STRIP001 void SwLabFmtPage::FillItem(SwLabItem& rItem)
//STRIP001 {
//STRIP001 	if (bModified)
//STRIP001 	{
//STRIP001 		rItem.aMake = rItem.aType = SW_RESSTR(STR_CUSTOM);
//STRIP001 
//STRIP001 		SwLabRec& rRec = *GetParent()->Recs()[0];
//STRIP001 		rItem.lHDist  = rRec.lHDist  = GETFLDVAL(aHDistField );
//STRIP001 		rItem.lVDist  = rRec.lVDist  = GETFLDVAL(aVDistField );
//STRIP001 		rItem.lWidth  = rRec.lWidth  = GETFLDVAL(aWidthField );
//STRIP001 		rItem.lHeight = rRec.lHeight = GETFLDVAL(aHeightField);
//STRIP001 		rItem.lLeft   = rRec.lLeft	 = GETFLDVAL(aLeftField  );
//STRIP001 		rItem.lUpper  = rRec.lUpper  = GETFLDVAL(aUpperField );
//STRIP001 		rItem.nCols   = rRec.nCols	 = (USHORT) aColsField.GetValue();
//STRIP001 		rItem.nRows   = rRec.nRows	 = (USHORT) aRowsField.GetValue();
//STRIP001 	}
//STRIP001 }

// --------------------------------------------------------------------------



//STRIP001 BOOL SwLabFmtPage::FillItemSet(SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	FillItem(aItem);
//STRIP001 	rSet.Put(aItem);
//STRIP001 
//STRIP001 	return TRUE;
//STRIP001 }

// --------------------------------------------------------------------------
//STRIP001 void SwLabFmtPage::Reset(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001 	// Fields initialisieren
//STRIP001 	GetParent()->GetLabItem(aItem);
//STRIP001 
//STRIP001 	aHDistField .SetMax(100 * aItem.lHDist , FUNIT_TWIP);
//STRIP001 	aVDistField .SetMax(100 * aItem.lVDist , FUNIT_TWIP);
//STRIP001 	aWidthField .SetMax(100 * aItem.lWidth , FUNIT_TWIP);
//STRIP001 	aHeightField.SetMax(100 * aItem.lHeight, FUNIT_TWIP);
//STRIP001 	aLeftField	.SetMax(100 * aItem.lLeft  , FUNIT_TWIP);
//STRIP001 	aUpperField .SetMax(100 * aItem.lUpper , FUNIT_TWIP);
//STRIP001 
//STRIP001 	SETFLDVAL(aHDistField , aItem.lHDist );
//STRIP001 	SETFLDVAL(aVDistField , aItem.lVDist );
//STRIP001 	SETFLDVAL(aWidthField , aItem.lWidth );
//STRIP001 	SETFLDVAL(aHeightField, aItem.lHeight);
//STRIP001 	SETFLDVAL(aLeftField  , aItem.lLeft  );
//STRIP001 	SETFLDVAL(aUpperField , aItem.lUpper );
//STRIP001 
//STRIP001 	aColsField.SetMax(aItem.nCols);
//STRIP001 	aRowsField.SetMax(aItem.nRows);
//STRIP001 
//STRIP001 	aColsField	.SetValue(aItem.nCols);
//STRIP001 	aRowsField	.SetValue(aItem.nRows);
//STRIP001 	aMakeFI.SetText(aItem.aMake);
//STRIP001 	aTypeFI.SetText(aItem.aType);
//STRIP001 	PreviewHdl(0);
//STRIP001 }
/* -----------------------------22.01.01 15:11--------------------------------

 ---------------------------------------------------------------------------*/

//STRIP001 IMPL_LINK( SwLabFmtPage, SaveHdl, PushButton *, EMPTYARG )
//STRIP001 {
//STRIP001 	SwLabRec aRec;
//STRIP001 	aRec.lHDist  = GETFLDVAL(aHDistField );
//STRIP001 	aRec.lVDist  = GETFLDVAL(aVDistField );
//STRIP001 	aRec.lWidth  = GETFLDVAL(aWidthField );
//STRIP001 	aRec.lHeight = GETFLDVAL(aHeightField);
//STRIP001 	aRec.lLeft	 = GETFLDVAL(aLeftField  );
//STRIP001 	aRec.lUpper  = GETFLDVAL(aUpperField );
//STRIP001 	aRec.nCols	 = (USHORT) aColsField.GetValue();
//STRIP001 	aRec.nRows	 = (USHORT) aRowsField.GetValue();
//STRIP001 	aRec.bCont = aItem.bCont;
//STRIP001 	SwSaveLabelDlg* pSaveDlg = new SwSaveLabelDlg(this, aRec);
//STRIP001 	pSaveDlg->SetLabel(aItem.aLstMake, aItem.aLstType);
//STRIP001 	pSaveDlg->Execute();
//STRIP001 	if(pSaveDlg->GetLabel(aItem))
//STRIP001 	{
//STRIP001 		bModified = FALSE;
//STRIP001 		const Sequence<OUString>& rMan = GetParent()->GetLabelsConfig().GetManufacturers();
//STRIP001 		SvStringsDtor& rMakes = GetParent()->Makes();
//STRIP001 		if(rMakes.Count() < (USHORT)rMan.getLength())
//STRIP001 		{
//STRIP001 			rMakes.DeleteAndDestroy(0, rMakes.Count());
//STRIP001 			const OUString* pMan = rMan.getConstArray();
//STRIP001 			for(sal_Int32 nMan = 0; nMan < rMan.getLength(); nMan++)
//STRIP001 			{
//STRIP001 				rMakes.Insert( new String(pMan[nMan]), rMakes.Count() );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		aMakeFI.SetText(aItem.aMake);
//STRIP001 		aTypeFI.SetText(aItem.aType);
//STRIP001 	}
//STRIP001 	delete pSaveDlg;
//STRIP001 	return 0;
//STRIP001 }
/* -----------------------------23.01.01 10:41--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 SwSaveLabelDlg::SwSaveLabelDlg(SwLabFmtPage* pParent, SwLabRec& rRec) :
//STRIP001 	ModalDialog(pParent, SW_RES(DLG_SAVE_LABEL)),
//STRIP001 	rLabRec(rRec),
//STRIP001 	pLabPage(pParent),
//STRIP001     aOptionsFL(this,ResId(FL_OPTIONS  )),
//STRIP001 	aMakeFT(this, 	ResId(FT_MAKE     )),
//STRIP001 	aMakeCB(this, 	ResId(CB_MAKE     )),
//STRIP001 	aTypeFT(this, 	ResId(FT_TYPE     )),
//STRIP001 	aTypeED(this, 	ResId(ED_TYPE     )),
//STRIP001 	aOKPB(this, 	ResId(PB_OK     )),
//STRIP001 	aCancelPB(this, ResId(PB_CANCEL )),
//STRIP001 	aHelpPB(this, 	ResId(PB_HELP  	)),
//STRIP001 	aQueryMB(this,  ResId(MB_QUERY )),
//STRIP001 	bSuccess(sal_False)
//STRIP001 {
//STRIP001 	FreeResource();
//STRIP001 
//STRIP001 	aOKPB.SetClickHdl(LINK(this, SwSaveLabelDlg, OkHdl));
//STRIP001 	Link aLk(LINK(this, SwSaveLabelDlg, ModifyHdl));
//STRIP001 	aMakeCB.SetModifyHdl(aLk);
//STRIP001 	aTypeED.SetModifyHdl(aLk);
//STRIP001 
//STRIP001 	SwLabelConfig& rCfg = pLabPage->GetParent()->GetLabelsConfig();
//STRIP001 	const Sequence<OUString>& rMan = rCfg.GetManufacturers();
//STRIP001 	const OUString* pMan = rMan.getConstArray();
//STRIP001 	for(sal_Int32 i = 0; i < rMan.getLength(); i++)
//STRIP001 		aMakeCB.InsertEntry(pMan[i]);
//STRIP001 }
/* -----------------------------23.01.01 10:40--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SwSaveLabelDlg, OkHdl, OKButton*, pButton)
//STRIP001 {
//STRIP001 	SwLabelConfig& rCfg = pLabPage->GetParent()->GetLabelsConfig();
//STRIP001 	String sMake(aMakeCB.GetText());
//STRIP001 	String sType(aTypeED.GetText());
//STRIP001 	if(rCfg.HasLabel(sMake, sType))
//STRIP001 	{
//STRIP001 		String sTmp(aQueryMB.GetMessText());
//STRIP001 		String sQuery(sTmp);
//STRIP001 		sQuery.SearchAndReplace(C2S("%1"), sMake);
//STRIP001 		sQuery.SearchAndReplace(C2S("%2"), sType);
//STRIP001 		aQueryMB.SetMessText(sQuery);
//STRIP001 
//STRIP001 		short eRet = aQueryMB.Execute();
//STRIP001 		aQueryMB.SetMessText(sTmp);
//STRIP001 		if(RET_YES != eRet)
//STRIP001 			return 0;
//STRIP001 	}
//STRIP001 	rLabRec.aType = sType;
//STRIP001 	rCfg.SaveLabel(sMake, sType, rLabRec);
//STRIP001 	bSuccess = sal_True;
//STRIP001 	EndDialog(RET_OK);
//STRIP001 	return 0;
//STRIP001 }
/* -----------------------------23.01.01 11:22--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SwSaveLabelDlg, ModifyHdl, Edit*, EMPTYARG)
//STRIP001 {
//STRIP001 	aOKPB.Enable(aMakeCB.GetText().Len() && aTypeED.GetText().Len());
//STRIP001 	return 0;
//STRIP001 }
/* -----------------------------23.01.01 16:06--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool SwSaveLabelDlg::GetLabel(SwLabItem& rItem)
//STRIP001 {
//STRIP001 	if(bSuccess)
//STRIP001 	{
//STRIP001 		rItem.aMake = aMakeCB.GetText();
//STRIP001 		rItem.aType = aTypeED.GetText();
//STRIP001 		rItem.lHDist  = rLabRec.lHDist;
//STRIP001 		rItem.lVDist  = rLabRec.lVDist;
//STRIP001 		rItem.lWidth  = rLabRec.lWidth;
//STRIP001 		rItem.lHeight = rLabRec.lHeight;
//STRIP001 		rItem.lLeft   = rLabRec.lLeft;
//STRIP001 		rItem.lUpper  = rLabRec.lUpper;
//STRIP001 		rItem.nCols   = rLabRec.nCols;
//STRIP001 		rItem.nRows   = rLabRec.nRows;
//STRIP001 	}
//STRIP001 	return bSuccess;
//STRIP001 }

}
