/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_pggrid.cxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:22:38 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
namespace binfilter {


//STRIP001 #pragma hdrstop
//STRIP001 
//STRIP001 #ifndef _CMDID_H
//STRIP001 #include <cmdid.h>
//STRIP001 #endif
//STRIP001 #ifndef _HINTIDS_HXX
//STRIP001 #include <hintids.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UIPARAM_HXX
//STRIP001 #include <uiparam.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SWTYPES_HXX
//STRIP001 #include <swtypes.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _GLOBALS_HRC
//STRIP001 #include <globals.hrc>
//STRIP001 #endif
//STRIP001 
//STRIP001 #ifndef _OFF_APP_HXX //autogen
//STRIP001 #include <bf_offmgr/app.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _XTABLE_HXX //autogen
//STRIP001 #include <bf_svx/xtable.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _UITOOL_HXX
//STRIP001 #include <uitool.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_SIZEITEM_HXX
//STRIP001 #include <bf_svx/sizeitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_LRSPITEM_HXX
//STRIP001 #include <bf_svx/lrspitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_BOXITEM_HXX
//STRIP001 #include <bf_svx/boxitem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _SVX_FRMDIRITEM_HXX
//STRIP001 #include <bf_svx/frmdiritem.hxx>
//STRIP001 #endif
//STRIP001 #ifndef _PGGRID_HXX
//STRIP001 #include <pggrid.hxx>
//STRIP001 #endif
//STRIP001 #ifndef SW_TGRDITEM_HXX
//STRIP001 #include <tgrditem.hxx>
//STRIP001 #endif
//STRIP001 #include <pggrid.hrc>
//STRIP001 
//STRIP001 /*-- 06.02.2002 15:25:39---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SwTextGridPage::SwTextGridPage(Window *pParent, const SfxItemSet &rSet) :
//STRIP001     SfxTabPage(pParent, SW_RES(TP_TEXTGRID_PAGE), rSet),
//STRIP001     aGridTypeFL             (this, ResId(FL_GRID_TYPE       )),
//STRIP001     aNoGridRB               (this, ResId(RB_NOGRID          )),
//STRIP001     aLinesGridRB            (this, ResId(RB_LINESGRID       )),
//STRIP001     aCharsGridRB            (this, ResId(RB_CHARSGRID       )),
//STRIP001     aExampleWN              (this, ResId(WN_EXAMPLE         )),
//STRIP001     aLayoutFL               (this, ResId(FL_LAYOUT          )),
//STRIP001     aLinesPerPageFT         (this, ResId(FT_LINESPERPAGE    )),
//STRIP001     aLinesPerPageNF         (this, ResId(NF_LINESPERPAGE    )),
//STRIP001     aTextSizeFT             (this, ResId(FT_TEXTSIZE        )),
//STRIP001     aTextSizeMF             (this, ResId(MF_TEXTSIZE        )),
//STRIP001     aCharsPerLineFT         (this, ResId(FT_CHARSPERLINE    )),
//STRIP001     aCharsPerLineNF         (this, ResId(NF_CHARSPERLINE    )),
//STRIP001     aRubySizeFT             (this, ResId(FT_RUBYSIZE        )),
//STRIP001     aRubySizeMF             (this, ResId(MF_RUBYSIZE        )),
//STRIP001     aRubyBelowCB            (this, ResId(CB_RUBYBELOW       )),
//STRIP001     aDisplayFL              (this, ResId(FL_DISPLAY         )),
//STRIP001     aDisplayCB              (this, ResId(CB_DISPLAY         )),
//STRIP001     aPrintCB                (this, ResId(CB_PRINT           )),
//STRIP001     aColorFT                (this, ResId(FT_COLOR           )),
//STRIP001     aColorLB                (this, ResId(LB_COLOR           )),
//STRIP001     m_nRubyUserValue(0),
//STRIP001     m_bRubyUserValue(sal_False),
//STRIP001     m_aPageSize(MM50, MM50),
//STRIP001     m_bVertical(sal_False)
//STRIP001 {
//STRIP001     FreeResource();
//STRIP001 
//STRIP001     aControls[0] =&aLayoutFL;
//STRIP001     aControls[1] =&aLinesPerPageFT;
//STRIP001     aControls[2] =&aLinesPerPageNF;
//STRIP001     aControls[3] =&aTextSizeFT;
//STRIP001     aControls[4] =&aTextSizeMF;
//STRIP001     aControls[5] =&aCharsPerLineFT;
//STRIP001     aControls[6] =&aCharsPerLineNF;
//STRIP001     aControls[7] =&aRubySizeFT;
//STRIP001     aControls[8] =&aRubySizeMF;
//STRIP001     aControls[9] =&aRubyBelowCB;
//STRIP001     aControls[10] =&aDisplayFL;
//STRIP001     aControls[11] =&aDisplayCB;
//STRIP001     aControls[12] =&aPrintCB;
//STRIP001     aControls[13] =&aColorFT;
//STRIP001     aControls[14] =&aColorLB;
//STRIP001     aControls[15] =0;
//STRIP001 
//STRIP001     Link aLink = LINK(this, SwTextGridPage, CharSizeChangedHdl);
//STRIP001     aCharsPerLineNF.SetUpHdl(aLink);
//STRIP001     aTextSizeMF.SetUpHdl(aLink);
//STRIP001     aCharsPerLineNF.SetDownHdl(aLink);
//STRIP001     aTextSizeMF.SetDownHdl(aLink);
//STRIP001     aCharsPerLineNF.SetLoseFocusHdl(aLink);
//STRIP001     aTextSizeMF.SetLoseFocusHdl(aLink);
//STRIP001 
//STRIP001     Link aGridTypeHdl = LINK(this, SwTextGridPage, GridTypeHdl);
//STRIP001     aNoGridRB   .SetClickHdl(aGridTypeHdl);
//STRIP001     aLinesGridRB.SetClickHdl(aGridTypeHdl);
//STRIP001     aCharsGridRB.SetClickHdl(aGridTypeHdl);
//STRIP001 
//STRIP001     Link aModifyLk = LINK(this, SwTextGridPage, GridModifyHdl);
//STRIP001     aColorLB.SetSelectHdl(aModifyLk);
//STRIP001     aPrintCB.SetClickHdl(aModifyLk);
//STRIP001     aRubyBelowCB.SetClickHdl(aModifyLk);
//STRIP001 
//STRIP001     aLinesPerPageNF.SetUpHdl(aModifyLk);
//STRIP001     aRubySizeMF.SetUpHdl(aModifyLk);
//STRIP001     aLinesPerPageNF.SetDownHdl(aModifyLk);
//STRIP001     aRubySizeMF.SetDownHdl(aModifyLk);
//STRIP001     aLinesPerPageNF.SetLoseFocusHdl(aModifyLk);
//STRIP001     aRubySizeMF.SetLoseFocusHdl(aModifyLk);
//STRIP001 
//STRIP001     aDisplayCB.SetClickHdl(LINK(this, SwTextGridPage, DisplayGridHdl));
//STRIP001 
//STRIP001     XColorTable* pColorTbl = OFF_APP()->GetStdColorTable();
//STRIP001     aColorLB.InsertAutomaticEntry();
//STRIP001 	for( USHORT i = 0; i < pColorTbl->Count(); ++i )
//STRIP001 	{
//STRIP001 		XColorEntry* pEntry = pColorTbl->Get( i );
//STRIP001 		Color aColor = pEntry->GetColor();
//STRIP001 		String sName = pEntry->GetName();
//STRIP001 		aColorLB.InsertEntry( aColor, sName );
//STRIP001 	}
//STRIP001 	aColorLB.SetUpdateMode( TRUE );
//STRIP001 }
//STRIP001 /*-- 06.02.2002 15:25:40---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SwTextGridPage::~SwTextGridPage()
//STRIP001 {
//STRIP001 }
//STRIP001 /*-- 06.02.2002 15:25:40---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 SfxTabPage *SwTextGridPage::Create(Window *pParent, const SfxItemSet &rSet)
//STRIP001 {
//STRIP001     return new SwTextGridPage(pParent, rSet);
//STRIP001 }
//STRIP001 /*-- 06.02.2002 15:25:40---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 BOOL    SwTextGridPage::FillItemSet(SfxItemSet &rSet)
//STRIP001 {
//STRIP001     BOOL bRet = FALSE;
//STRIP001     if(aNoGridRB.GetSavedValue() != aNoGridRB.IsChecked()||
//STRIP001         aLinesGridRB.GetSavedValue() != aLinesGridRB.IsChecked()||
//STRIP001         aLinesPerPageNF.GetSavedValue() != aLinesPerPageNF.GetValue()||
//STRIP001         aTextSizeMF.GetSavedValue() != aTextSizeMF.GetValue()||
//STRIP001         aCharsPerLineNF.GetSavedValue() != aCharsPerLineNF.GetValue()||
//STRIP001         aRubySizeMF.GetSavedValue() != aRubySizeMF.GetValue()||
//STRIP001         aRubyBelowCB.GetSavedValue() != aRubyBelowCB.IsChecked()||
//STRIP001         aDisplayCB.GetSavedValue() != aDisplayCB.IsChecked()||
//STRIP001         aPrintCB.GetSavedValue() != aPrintCB.IsChecked()||
//STRIP001         aColorLB.GetSavedValue() != aColorLB.GetSelectEntryPos())
//STRIP001     {
//STRIP001         PutGridItem(rSet);
//STRIP001         bRet = TRUE;
//STRIP001     }
//STRIP001 
//STRIP001     return bRet;
//STRIP001 }
//STRIP001 /*-- 06.02.2002 15:25:40---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void    SwTextGridPage::Reset(const SfxItemSet &rSet)
//STRIP001 {
//STRIP001     if(SFX_ITEM_AVAILABLE <= rSet.GetItemState(RES_TEXTGRID, TRUE))
//STRIP001     {
//STRIP001         const SwTextGridItem& rGridItem = (const SwTextGridItem&)rSet.Get(RES_TEXTGRID);
//STRIP001         RadioButton* pButton = 0;
//STRIP001         switch(rGridItem.GetGridType())
//STRIP001         {
//STRIP001             case GRID_NONE :        pButton = &aNoGridRB;    break;
//STRIP001             case GRID_LINES_ONLY  : pButton = &aLinesGridRB; break;
//STRIP001             default:                pButton = &aCharsGridRB;
//STRIP001         }
//STRIP001         pButton->Check();
//STRIP001         GridTypeHdl(pButton);
//STRIP001         aLinesPerPageNF.SetValue(rGridItem.GetLines());
//STRIP001         m_nRubyUserValue = rGridItem.GetBaseHeight();
//STRIP001         m_bRubyUserValue = sal_True;
//STRIP001         aTextSizeMF.SetValue(aTextSizeMF.Normalize(m_nRubyUserValue), FUNIT_TWIP);
//STRIP001         aRubySizeMF.SetValue(aRubySizeMF.Normalize(rGridItem.GetRubyHeight()), FUNIT_TWIP);
//STRIP001         aRubyBelowCB.Check(rGridItem.IsRubyTextBelow());
//STRIP001         aDisplayCB.Check(rGridItem.IsDisplayGrid());
//STRIP001         aPrintCB.Check(rGridItem.IsPrintGrid());
//STRIP001         aColorLB.SelectEntry(rGridItem.GetColor());
//STRIP001     }
//STRIP001     UpdatePageSize(rSet);
//STRIP001 
//STRIP001     aNoGridRB.SaveValue();
//STRIP001     aLinesGridRB.SaveValue();
//STRIP001     aLinesPerPageNF.SaveValue();
//STRIP001     aTextSizeMF.SaveValue();
//STRIP001     aCharsPerLineNF.SaveValue();
//STRIP001     aRubySizeMF.SaveValue();
//STRIP001     aRubyBelowCB.SaveValue();
//STRIP001     aDisplayCB.SaveValue();
//STRIP001     aPrintCB.SaveValue();
//STRIP001     aColorLB.SaveValue();
//STRIP001 
//STRIP001 }
//STRIP001 /*-- 06.02.2002 15:25:41---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 void    SwTextGridPage::ActivatePage( const SfxItemSet& rSet )
//STRIP001 {
//STRIP001     aExampleWN.Hide();
//STRIP001     aExampleWN.UpdateExample( rSet );
//STRIP001     UpdatePageSize(rSet);
//STRIP001     aExampleWN.Show();
//STRIP001     aExampleWN.Invalidate();
//STRIP001 }
//STRIP001 /*-- 06.02.2002 15:25:41---------------------------------------------------
//STRIP001 
//STRIP001   -----------------------------------------------------------------------*/
//STRIP001 int SwTextGridPage::DeactivatePage( SfxItemSet* pSet )
//STRIP001 {
//STRIP001     return LEAVE_PAGE;
//STRIP001 }
//STRIP001 /* -----------------------------08.02.2002 11:57------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwTextGridPage::PutGridItem(SfxItemSet& rSet)
//STRIP001 {
//STRIP001         SwTextGridItem aGridItem;
//STRIP001         aGridItem.SetGridType(aNoGridRB.IsChecked() ? GRID_NONE :
//STRIP001             aLinesGridRB.IsChecked() ? GRID_LINES_ONLY : GRID_LINES_CHARS );
//STRIP001         aGridItem.SetLines(aLinesPerPageNF.GetValue());
//STRIP001         aGridItem.SetBaseHeight(
//STRIP001             m_bRubyUserValue ? m_nRubyUserValue :
//STRIP001                 aTextSizeMF.Denormalize(aTextSizeMF.GetValue(FUNIT_TWIP)));
//STRIP001         aGridItem.SetRubyHeight(aRubySizeMF.Denormalize(aRubySizeMF.GetValue(FUNIT_TWIP)));
//STRIP001         aGridItem.SetRubyTextBelow(aRubyBelowCB.IsChecked());
//STRIP001         aGridItem.SetDisplayGrid(aDisplayCB.IsChecked());
//STRIP001         aGridItem.SetPrintGrid(aPrintCB.IsChecked());
//STRIP001         aGridItem.SetColor(aColorLB.GetSelectEntryColor());
//STRIP001         rSet.Put(aGridItem);
//STRIP001 }
//STRIP001 /* -----------------------------08.02.2002 10:54------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 void SwTextGridPage::UpdatePageSize(const SfxItemSet& rSet)
//STRIP001 {
//STRIP001     if( SFX_ITEM_UNKNOWN !=  rSet.GetItemState( RES_FRAMEDIR, TRUE ))
//STRIP001 	{
//STRIP001         const SvxFrameDirectionItem& rDirItem =
//STRIP001                     (const SvxFrameDirectionItem&)rSet.Get(RES_FRAMEDIR);
//STRIP001         m_bVertical = rDirItem.GetValue() == FRMDIR_VERT_TOP_RIGHT||
//STRIP001                     rDirItem.GetValue() == FRMDIR_VERT_TOP_LEFT;
//STRIP001     }
//STRIP001 
//STRIP001     if( SFX_ITEM_SET == rSet.GetItemState( SID_ATTR_PAGE_SIZE ))
//STRIP001     {
//STRIP001         const SvxSizeItem& rSize = (const SvxSizeItem&)rSet.Get(
//STRIP001                                             SID_ATTR_PAGE_SIZE);
//STRIP001         const SvxLRSpaceItem& rLRSpace = (const SvxLRSpaceItem&)rSet.Get(
//STRIP001                                                             RES_LR_SPACE );
//STRIP001         const SvxBoxItem& rBox = (const SvxBoxItem&) rSet.Get(RES_BOX);
//STRIP001         sal_Int32 nDistance = rLRSpace.GetLeft() + rLRSpace.GetRight();
//STRIP001 
//STRIP001         sal_Int32 nValue1 = rSize.GetSize().Height() - nDistance -
//STRIP001                 rBox.GetDistance(BOX_LINE_TOP) -
//STRIP001                                     rBox.GetDistance(BOX_LINE_BOTTOM);
//STRIP001         sal_Int32 nValue2 = rSize.GetSize().Width() - nDistance -
//STRIP001                 rBox.GetDistance(BOX_LINE_LEFT) -
//STRIP001                                     rBox.GetDistance(BOX_LINE_RIGHT);
//STRIP001         if(m_bVertical)
//STRIP001         {
//STRIP001             m_aPageSize.Width() = nValue1;
//STRIP001             m_aPageSize.Height() = nValue2;
//STRIP001         }
//STRIP001         else
//STRIP001         {
//STRIP001             m_aPageSize.Width() = nValue2;
//STRIP001             m_aPageSize.Height() = nValue1;
//STRIP001         }
//STRIP001 
//STRIP001         sal_Int32 nTextSize = m_bRubyUserValue ?
//STRIP001                     m_nRubyUserValue :
//STRIP001                         aTextSizeMF.Denormalize(aTextSizeMF.GetValue(FUNIT_TWIP));
//STRIP001         aCharsPerLineNF.SetValue(m_aPageSize.Width() / nTextSize);
//STRIP001     }
//STRIP001 }
//STRIP001 /* -----------------------------06.02.2002 15:24------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 USHORT* SwTextGridPage::GetRanges()
//STRIP001 {
//STRIP001     static USHORT __FAR_DATA aPageRg[] = {
//STRIP001         RES_TEXTGRID, RES_TEXTGRID,
//STRIP001         0};
//STRIP001     return aPageRg;
//STRIP001 }
//STRIP001 /* -----------------------------08.02.2002 10:56------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SwTextGridPage, CharSizeChangedHdl, SpinField*, pField)
//STRIP001 {
//STRIP001     if(&aCharsPerLineNF == pField)
//STRIP001     {
//STRIP001         long nWidth = m_aPageSize.Width() / aCharsPerLineNF.GetValue();
//STRIP001         aTextSizeMF.SetValue(aTextSizeMF.Normalize(nWidth), FUNIT_TWIP);
//STRIP001         //prevent rounding errors in the MetricField by saving the used value
//STRIP001         m_nRubyUserValue = nWidth;
//STRIP001         m_bRubyUserValue = sal_True;
//STRIP001     }
//STRIP001     else
//STRIP001     {
//STRIP001         sal_Int32 nTextSize = aTextSizeMF.Denormalize(aTextSizeMF.GetValue(FUNIT_TWIP));
//STRIP001         aCharsPerLineNF.SetValue(m_aPageSize.Width() / nTextSize);
//STRIP001         m_bRubyUserValue = sal_False;
//STRIP001     }
//STRIP001     GridModifyHdl(0);
//STRIP001     return 0;
//STRIP001 }
//STRIP001 /* -----------------------------22.04.2002 14:53------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SwTextGridPage, GridTypeHdl, RadioButton*, pButton)
//STRIP001 {
//STRIP001     sal_Bool bEnable = &aNoGridRB != pButton;
//STRIP001     sal_Int32 nIndex = 0;
//STRIP001     while(aControls[nIndex])
//STRIP001         aControls[nIndex++]->Enable(bEnable);
//STRIP001     //one special case
//STRIP001     if(bEnable)
//STRIP001         DisplayGridHdl(&aDisplayCB);
//STRIP001 
//STRIP001     GridModifyHdl(0);
//STRIP001     return 0;
//STRIP001 }
//STRIP001 /* -----------------------------22.04.2002 15:46------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SwTextGridPage, DisplayGridHdl, CheckBox*, EMPTYARG)
//STRIP001 {
//STRIP001     aPrintCB.Enable(aDisplayCB.IsChecked());
//STRIP001     return 0;
//STRIP001 }
//STRIP001 /* -----------------------------08.02.2002 11:54------------------------------
//STRIP001 
//STRIP001  ---------------------------------------------------------------------------*/
//STRIP001 IMPL_LINK(SwTextGridPage, GridModifyHdl, void*, EMPTYARG)
//STRIP001 {
//STRIP001     //set maximum for Lines per page
//STRIP001     sal_Int32 nMaxLines = m_aPageSize.Height() /
//STRIP001                 (   aTextSizeMF.Denormalize(aTextSizeMF.GetValue(FUNIT_TWIP)) +
//STRIP001                     aRubySizeMF.Denormalize(aRubySizeMF.GetValue(FUNIT_TWIP)));
//STRIP001     aLinesPerPageNF.SetMax(nMaxLines);
//STRIP001     const SfxItemSet& rOldSet = GetItemSet();
//STRIP001     SfxItemSet aSet(rOldSet);
//STRIP001     const SfxItemSet* pExSet = GetTabDialog()->GetExampleSet();
//STRIP001     if(pExSet)
//STRIP001         aSet.Put(*pExSet);
//STRIP001     PutGridItem(aSet);
//STRIP001     aExampleWN.UpdateExample(aSet);
//STRIP001     return 0;
//STRIP001 }

}
