/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_viewmdi.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:51:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#pragma hdrstop

#include <string> // HACK: prevent conflict between STLPORT and Workshop headers

#include "hintids.hxx"
// auto strip #include "uiparam.hxx"

// auto strip #ifndef _SFXDISPATCH_HXX //autogen
// auto strip #include <bf_sfx2/dispatch.hxx>
// auto strip #endif
#ifndef _SVX_RULER_HXX //autogen
#include <bf_svx/ruler.hxx>
#endif
// auto strip #ifndef _SVX_LRSPITEM_HXX //autogen
// auto strip #include <bf_svx/lrspitem.hxx>
// auto strip #endif
// auto strip #ifndef _SVX_SRCHITEM_HXX //autogen
// auto strip #include <bf_svx/srchitem.hxx>
// auto strip #endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif

// auto strip #ifndef _SWMODULE_HXX
// auto strip #include <swmodule.hxx>
// auto strip #endif
// auto strip #ifndef _VIEW_HXX
// auto strip #include <view.hxx>
// auto strip #endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _WRTSH_HXX
// auto strip #include <wrtsh.hxx>
// auto strip #endif
// auto strip #ifndef _VIEWOPT_HXX
// auto strip #include <viewopt.hxx>
// auto strip #endif
// auto strip #ifndef _FRMATR_HXX
// auto strip #include <frmatr.hxx>
// auto strip #endif
#ifndef _WDOCSH_HXX
#include <wdocsh.hxx>
#endif
// auto strip #ifndef _UITOOL_HXX
// auto strip #include <uitool.hxx>
// auto strip #endif
#ifndef _EDTWIN_HXX
#include <edtwin.hxx>
#endif
#ifndef _PAGEDESC_HXX
#include <pagedesc.hxx>
#endif
// auto strip #ifndef _BOOKMRK_HXX
// auto strip #include <bookmrk.hxx>
// auto strip #endif
// auto strip #ifndef _FLDBAS_HXX
// auto strip #include <fldbas.hxx>
// auto strip #endif
#ifndef _WORKCTRL_HXX
#include <workctrl.hxx>
#endif
// auto strip #ifndef _USRPREF_HXX
// auto strip #include <usrpref.hxx>
// auto strip #endif
#ifndef _SCROLL_HXX
#include <scroll.hxx>
#endif
#ifndef _WVIEW_HXX
#include <wview.hxx>
#endif

#ifndef _CMDID_H
#include <cmdid.h>
#endif
#ifndef _VIEW_HRC
#include <view.hrc>
#endif
#ifndef _RIBBAR_HRC
#include <ribbar.hrc>
#endif
#ifndef _HELPID_H
#include <helpid.h>
#endif
#ifndef _GLOBALS_HRC
#include <globals.hrc>
#endif
namespace binfilter {

USHORT	SwView::nMoveType = NID_PGE;
BYTE	SwView::nActMark = 0;

#define VIEW_IMAGECOLOR COL_LIGHTBLUE

/*N*/ void SwView::SetZoom( SvxZoomType eZoomType, short nFactor, BOOL bViewOnly )
/*N*/ {
/*N*/ 	_SetZoom( GetEditWin().GetOutputSizePixel(), eZoomType, nFactor, bViewOnly );
/*N*/ }

//STRIP001 void SwView::_SetZoom( const Size &rEditSize, SvxZoomType eZoomType,
//STRIP001 						short nFactor, BOOL bViewOnly )
//STRIP001 {
//STRIP001 	BOOL bUnLockView = !pWrtShell->IsViewLocked();
//STRIP001 	pWrtShell->LockView( TRUE );
//STRIP001 	pWrtShell->LockPaint();
//STRIP001 	{
//STRIP001 	ACT_KONTEXT(pWrtShell);
//STRIP001 
//STRIP001 	long nFac = nFactor;
//STRIP001 
//STRIP001 	BOOL bWeb = 0 != PTR_CAST(SwWebView, this);
//STRIP001 	SwMasterUsrPref *pUsrPref = (SwMasterUsrPref*)SW_MOD()->GetUsrPref(bWeb);
//STRIP001 
//STRIP001 	const SwPageDesc &rDesc = pWrtShell->GetPageDesc(
//STRIP001 												pWrtShell->GetCurPageDesc() );
//STRIP001 	const SvxLRSpaceItem &rLRSpace = rDesc.GetMaster().GetLRSpace();
//STRIP001 	const SwViewOption *pOpt = pWrtShell->GetViewOptions();
//STRIP001 	long lLeftMargin;
//STRIP001 
//STRIP001 	if( eZoomType != SVX_ZOOM_PERCENT )
//STRIP001 	{
//STRIP001 		const long nOf = DOCUMENTBORDER * 2L;
//STRIP001 		Size aPageSize( pWrtShell->GetAnyCurRect(RECT_PAGE_CALC).SSize() );
//STRIP001 
//STRIP001 		if( PD_MIRROR == rDesc.GetUseOn() )	// gespiegelte Seiten
//STRIP001 		{
//STRIP001 			const SvxLRSpaceItem &rLeftLRSpace = rDesc.GetLeft().GetLRSpace();
//STRIP001 			aPageSize.Width() +=
//STRIP001 				Abs( long(rLeftLRSpace.GetLeft()) - long(rLRSpace.GetLeft()) );
//STRIP001 		}
//STRIP001 		if( SVX_ZOOM_OPTIMAL == eZoomType )
//STRIP001 		{
//STRIP001 			aPageSize.Width() -=
//STRIP001 				( rLRSpace.GetLeft() + rLRSpace.GetRight() + nLeftOfst * 2 );
//STRIP001 		}
//STRIP001         else if(SVX_ZOOM_PAGEWIDTH_NOBORDER != eZoomType)
//STRIP001 		{
//STRIP001 			aPageSize.Width() += nOf;
//STRIP001 			aPageSize.Height() += nOf;
//STRIP001 		}
//STRIP001         lLeftMargin = SVX_ZOOM_PAGEWIDTH != eZoomType && SVX_ZOOM_PAGEWIDTH_NOBORDER != eZoomType ?
//STRIP001 			long(rLRSpace.GetLeft()) + DOCUMENTBORDER + nLeftOfst : 0L;
//STRIP001 
//STRIP001 		const MapMode aTmpMap( MAP_TWIP );
//STRIP001 		const Size aWindowSize( GetEditWin().PixelToLogic( rEditSize, aTmpMap ) );
//STRIP001 		nFac = aWindowSize.Width() * 100 / aPageSize.Width();
//STRIP001 		if( SVX_ZOOM_WHOLEPAGE == eZoomType )
//STRIP001 		{
//STRIP001 			long nVisPercent = aWindowSize.Height() * 100 / aPageSize.Height();
//STRIP001 			nFac = Min( nFac, nVisPercent );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	else
//STRIP001 		lLeftMargin = long(rLRSpace.GetLeft()) + DOCUMENTBORDER;
//STRIP001 
//STRIP001 	nFac = Max( long( MINZOOM ), nFac );
//STRIP001 
//STRIP001 	SwViewOption aOpt( *pOpt );
//STRIP001 	SwDocShell* pDocShell = GetDocShell();
//STRIP001 	if ( pDocShell->GetProtocol().IsEmbed() ||
//STRIP001 		 pDocShell->GetCreateMode() == SFX_CREATE_MODE_STANDARD  )
//STRIP001 	{
//STRIP001 		//MasterUsrPrefs updaten UND DANACH die ViewOptions der aktuellen
//STRIP001 		//View updaten.
//STRIP001 		if ( !bViewOnly &&
//STRIP001 				(USHORT(nFac) 	   != pUsrPref->GetZoom() ||
//STRIP001 				BYTE  (eZoomType) != pUsrPref->GetZoomType()) )
//STRIP001 		{
//STRIP001 			pUsrPref->SetZoom	 ( USHORT(nFac) );
//STRIP001 			pUsrPref->SetZoomType( BYTE( eZoomType ) );
//STRIP001 			SW_MOD()->ApplyUsrPref( *pUsrPref,
//STRIP001 					bViewOnly ? this: 0,
//STRIP001 					bViewOnly ? VIEWOPT_DEST_VIEW_ONLY : 0 );
//STRIP001 			pUsrPref->SetModified();
//STRIP001 		}
//STRIP001 		if ( pOpt->GetZoom() != (USHORT) nFac )
//STRIP001 		{
//STRIP001 			aOpt.SetZoom	( USHORT(nFac) );
//STRIP001 			aOpt.SetReadonly(pOpt->IsReadonly());
//STRIP001 			pWrtShell->ApplyViewOptions( aOpt );
//STRIP001 		}
//STRIP001 		if ( eZoomType != SVX_ZOOM_PERCENT )
//STRIP001 		{
//STRIP001 			Point aPos;
//STRIP001 			if ( eZoomType == SVX_ZOOM_WHOLEPAGE )
//STRIP001 				aPos.Y() = pWrtShell->GetAnyCurRect(RECT_PAGE).Top() - DOCUMENTBORDER;
//STRIP001 			else
//STRIP001 			{
//STRIP001 				//sicherstellen, dass sich der Cursor im sichtbaren
//STRIP001 				//Bereich befindet, damit nur 1x gescrollt wird
//STRIP001 				aPos.X() = lLeftMargin;
//STRIP001 				const SwRect &rCharRect = pWrtShell->GetCharRect();
//STRIP001 				if ( rCharRect.Top() > GetVisArea().Bottom() ||
//STRIP001 					 rCharRect.Bottom() < aPos.Y() )
//STRIP001 					aPos.Y() = rCharRect.Top() - rCharRect.Height();
//STRIP001 				else
//STRIP001 					aPos.Y() = GetVisArea().Top();
//STRIP001 			}
//STRIP001 			SetVisArea( aPos );
//STRIP001 		}
//STRIP001 		// OS: Notloesung - in CalcVisArea wird u.U. wieder SetZoom gerufen und
//STRIP001 		// dann werden falsche Werte eingestellt
//STRIP001 		((SwViewOption*)pWrtShell->GetViewOptions())->SetZoomType((BYTE)eZoomType);
//STRIP001 		CalcVisArea( rEditSize );	//fuer das Neuberechnen des sichtbaren Bereiches
//STRIP001 	}
//STRIP001 	else if ( USHORT(nFac) != pOpt->GetZoom() )
//STRIP001 	{
//STRIP001 		aOpt.SetZoom	( USHORT(nFac) );
//STRIP001 		pWrtShell->ApplyViewOptions( aOpt );
//STRIP001 	}
//STRIP001 
//STRIP001 	const Fraction aFrac( nFac, 100 );
//STRIP001     pVRuler->SetZoom( aFrac );
//STRIP001     pVRuler->ForceUpdate();
//STRIP001     pHRuler->SetZoom( aFrac );
//STRIP001     pHRuler->ForceUpdate();
//STRIP001 	((SwViewOption*)pWrtShell->GetViewOptions())->SetZoomType((BYTE)eZoomType);
//STRIP001 	}
//STRIP001 	pWrtShell->UnlockPaint();
//STRIP001 	if( bUnLockView )
//STRIP001 		pWrtShell->LockView( FALSE );
//STRIP001 //	eZoom = eZoomType;
//STRIP001 }

/*
 * Scrollbar - Handler
 */

/*N*/ int	SwView::_CreateScrollbar( int bHori )
/*N*/ {
/*N*/ 	Window *pMDI = &GetViewFrame()->GetWindow();
/*N*/ 	SwScrollbar** ppScrollbar = bHori ? &pHScrollbar : &pVScrollbar;
/*N*/ 
/*N*/ 	ASSERT( !*ppScrollbar, "vorher abpruefen!" )
/*N*/ 
/*N*/ 	if( !bHori )
/*N*/ 		CreatePageButtons( !bShowAtResize );
/*N*/ 
/*N*/ 	*ppScrollbar = new SwScrollbar( pMDI, bHori );
/*N*/ 	UpdateScrollbars();
/*N*/ 	if(bHori)
/*N*/ 		(*ppScrollbar)->SetScrollHdl( LINK( this, SwView, EndScrollHdl ));
/*N*/ 	else
/*N*/ 		(*ppScrollbar)->SetScrollHdl( LINK( this, SwView, ScrollHdl ));
/*N*/ 	(*ppScrollbar)->SetEndScrollHdl( LINK( this, SwView, EndScrollHdl ));
/*N*/ 
/*N*/ 	(*ppScrollbar)->EnableDrag( TRUE );
/*N*/ 
/*N*/     if(GetWindow())
/*?*/        InvalidateBorder();
/*N*/ 
/*N*/ 	// Scrollbar muss nochmals getestet werden, da im InvalidateBorder u.U. der
/*N*/ 	// Scrollbar wieder geloescht wurde
/*N*/ 	if ( !bShowAtResize && (*ppScrollbar))
/*?*/ 		(*ppScrollbar)->Show();
/*N*/ 
/*N*/ 	return 1;
/*N*/ }

/*N*/ void SwView::CreatePageButtons(BOOL bShow)
/*N*/ {
/*N*/ 	Window *pMDI = &GetViewFrame()->GetWindow();
//STRIP001 /*N*/ 	pPageUpBtn		= new SwHlpImageButton(pMDI, SW_RES( BTN_PAGEUP ), TRUE );
/*N*/ 	pPageUpBtn->SetHelpId(HID_SCRL_PAGEUP);
//STRIP001 /*N*/ 	pPageDownBtn	= new SwHlpImageButton(pMDI, SW_RES( BTN_PAGEDOWN ), FALSE );
/*N*/ 	pPageDownBtn->SetHelpId(HID_SCRL_PAGEDOWN);
//STRIP001 /*N*/ 	pNaviBtn = new SwNaviImageButton(pMDI);
//STRIP001 /*N*/ 	pNaviBtn->SetHelpId(HID_SCRL_NAVI);
/*N*/ 	Link aLk( LINK( this, SwView, BtnPage ) );
/*N*/ 	pPageUpBtn->SetClickHdl( aLk );
/*N*/ 	pPageDownBtn->SetClickHdl( aLk );
/*N*/ 	if(nMoveType != NID_PGE)
/*N*/ 	{
			{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 /*?*/ 		Color aColor(VIEW_IMAGECOLOR);
//STRIP001 /*?*/ 		SetImageButtonColor(aColor);
/*N*/ 	}
/*N*/ 
/*N*/ 	if(bShow)
/*N*/ 	{
/*?*/ 		pPageUpBtn->Show();
/*?*/ 		pPageDownBtn->Show();
//STRIP001 /*?*/ 		pNaviBtn->Show();
/*N*/ 	}
/*N*/ };

/*
 * Button-Handler
 */
/*?*/ IMPL_LINK( SwView, BtnPage, Button *, pButton )
/*?*/ {
		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	MoveNavigation(pButton == pPageDownBtn);
/*?*/ 	return 0;
/*?*/ }
/*-----------------20.06.97 10:46-------------------

--------------------------------------------------*/
//STRIP001 void SwView::MoveNavigation(BOOL bNext)
//STRIP001 {
//STRIP001 	SwWrtShell& rSh = GetWrtShell();
//STRIP001 	switch( nMoveType )
//STRIP001 	{
//STRIP001 		case NID_PGE:
//STRIP001 			bNext ? PhyPageDown() : PhyPageUp();
//STRIP001 		break;
//STRIP001 		case NID_TBL :
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			if(bNext)
//STRIP001 				rSh.MoveTable(fnTableNext, fnTableStart);
//STRIP001 			else
//STRIP001 				rSh.MoveTable(fnTablePrev, fnTableStart);
//STRIP001 		break;
//STRIP001 		case NID_FRM :
//STRIP001 		case NID_GRF:
//STRIP001 		case NID_OLE:
//STRIP001 		{
//STRIP001             GotoObjType eType = FLY_FRM;
//STRIP001 			if(nMoveType == NID_GRF)
//STRIP001                 eType = FLY_GRF;
//STRIP001 			else if(nMoveType == NID_OLE)
//STRIP001                 eType = FLY_OLE;
//STRIP001 			BOOL bSuccess = bNext ?
//STRIP001 					rSh.GotoNextFly(eType) :
//STRIP001 						rSh.GotoPrevFly(eType);
//STRIP001 			if(bSuccess)
//STRIP001 			{
//STRIP001 				rSh.HideCrsr();
//STRIP001 				rSh.EnterSelFrmMode();
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case NID_DRW :
//STRIP001 		case NID_CTRL:
//STRIP001 			rSh.GotoObj(bNext,
//STRIP001 					nMoveType == NID_DRW ?
//STRIP001 						DRAW_SIMPLE :
//STRIP001 							DRAW_CONTROL);
//STRIP001 		break;
//STRIP001 		case NID_REG :
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			if(bNext)
//STRIP001 				rSh.MoveRegion(fnRegionNext, fnRegionStart);
//STRIP001 			else
//STRIP001 				rSh.MoveRegion(fnRegionPrev, fnRegionStart);
//STRIP001 
//STRIP001 		break;
//STRIP001 		case NID_BKM :
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			GetViewFrame()->GetDispatcher()->Execute(bNext ?
//STRIP001 										FN_NEXT_BOOKMARK :
//STRIP001 											FN_PREV_BOOKMARK);
//STRIP001 		break;
//STRIP001 		case NID_OUTL:
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			bNext ? rSh.GotoNextOutline() : rSh.GotoPrevOutline();
//STRIP001 		break;
//STRIP001 		case NID_SEL :
//STRIP001 			bNext ? rSh.GoNextCrsr() : rSh.GoPrevCrsr();
//STRIP001 		break;
//STRIP001 		case NID_FTN:
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			bNext ?
//STRIP001 				rSh.GotoNextFtnAnchor() :
//STRIP001 					rSh.GotoPrevFtnAnchor();
//STRIP001 		break;
//STRIP001 		case NID_MARK:
//STRIP001 		{
//STRIP001 			// Selektionen aufheben
//STRIP001 			rSh.MoveCrsr();
//STRIP001 			rSh.EnterStdMode();
//STRIP001 			const USHORT nBookCnt = rSh.GetBookmarkCnt();
//STRIP001 			USHORT nMarkCount = 0;
//STRIP001 			USHORT nRealIdx[MAX_MARKS];
//STRIP001 			for( USHORT nCount = 0; nCount < nBookCnt; ++nCount )
//STRIP001 			{
//STRIP001 				if( rSh.GetBookmark( nCount ).IsMark() )
//STRIP001 				{
//STRIP001 					nRealIdx[nMarkCount] = nCount;
//STRIP001 					++nMarkCount;
//STRIP001 				}
//STRIP001 			}
//STRIP001 			if (nMarkCount)
//STRIP001 			{
//STRIP001 				if(!bNext)
//STRIP001 				{
//STRIP001 					if (nActMark > 1)
//STRIP001 						--nActMark;
//STRIP001 					else
//STRIP001 						nActMark = nMarkCount;
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					++nActMark;
//STRIP001 					if (nActMark > MAX_MARKS || nActMark > nMarkCount)
//STRIP001 						nActMark = 1;
//STRIP001 				}
//STRIP001 
//STRIP001 				rSh.GotoBookmark( nRealIdx[nActMark - 1] );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case NID_POSTIT:
//STRIP001 		{
//STRIP001 
//STRIP001 			SwFieldType* pFldType = rSh.GetFldType(0, RES_POSTITFLD);
//STRIP001 			rSh.MoveFldType( pFldType, bNext );
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case NID_SRCH_REP:
//STRIP001 		if(pSrchItem)
//STRIP001 		{
//STRIP001 			BOOL bBackward = pSrchItem->GetBackward();
//STRIP001 			if(rSh.HasSelection() && !bNext == rSh.IsCrsrPtAtEnd())
//STRIP001 				rSh.SwapPam();
//STRIP001 			pSrchItem->SetBackward(!bNext);
//STRIP001 			SfxRequest aReq(FN_REPEAT_SEARCH, SFX_CALLMODE_SLOT, GetPool());
//STRIP001 			ExecSearch(aReq);
//STRIP001 			pSrchItem->SetBackward(bBackward);
//STRIP001 		}
//STRIP001 		break;
//STRIP001 		case NID_INDEX_ENTRY:
//STRIP001 			rSh.GotoNxtPrvTOXMark(bNext);
//STRIP001 		break;
//STRIP001 
//STRIP001 		case NID_TABLE_FORMULA:
//STRIP001 			rSh.GotoNxtPrvTblFormula( bNext );
//STRIP001 			break;
//STRIP001 
//STRIP001 		case NID_TABLE_FORMULA_ERROR:
//STRIP001 			rSh.GotoNxtPrvTblFormula( bNext, TRUE );
//STRIP001 			break;
//STRIP001 	}
//STRIP001 	pEditWin->GrabFocus();
//STRIP001 }

/*************************************************************************
|*
|*	SwView::CreateTab()
|*
|*	Beschreibung
|*	Ersterstellung		VB 29.05.91
|*	Letzte Aenderung	OS 09.05.96
|*
*************************************************************************/

/*N*/ int SwView::CreateTab()
/*N*/ {
/*N*/     pHRuler->SetActive(GetFrame() && IsActive());
/*N*/ 
/*N*/     pHRuler->Show();
/*N*/ 	InvalidateBorder();
/*N*/ 	return 1;
/*N*/ }

/*************************************************************************
|*
|*	SwView::KillTab()
|*
|*	Beschreibung
|*	Ersterstellung		VB 29.05.91
|*	Letzte Aenderung	OS 09.05.96
|*
*************************************************************************/

//STRIP001 int SwView::KillTab()
//STRIP001 {
//STRIP001     pHRuler->Hide();
//STRIP001 	InvalidateBorder();
//STRIP001 	return 1;
//STRIP001 }

//STRIP001 void SwView::ChangeTabMetric( FieldUnit eUnit )
//STRIP001 {
//STRIP001     if(pHRuler->GetUnit() != eUnit )
//STRIP001     {
//STRIP001         pHRuler->SetUnit( eUnit );
//STRIP001         pHRuler->Invalidate();
//STRIP001     }
//STRIP001 }

//STRIP001 void SwView::ChangeVLinealMetric( FieldUnit eUnit )
//STRIP001 {
//STRIP001     if(pVRuler->GetUnit() != eUnit)
//STRIP001     {
//STRIP001         pVRuler->SetUnit( eUnit );
//STRIP001         pVRuler->Invalidate();
//STRIP001     }
//STRIP001 }
/* -----------------------------07.04.01 17:09--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 BOOL SwView::GetVLinealMetric(FieldUnit& eToFill) const
//STRIP001 {
//STRIP001     eToFill = pVRuler->GetUnit();
//STRIP001     return pVRuler != 0;
//STRIP001 }
/* -----------------------------07.04.01 17:09--------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 BOOL SwView::GetHLinealMetric(FieldUnit& eToFill) const
//STRIP001 {
//STRIP001     eToFill = pHRuler->GetUnit();
//STRIP001     return pHRuler != 0;
//STRIP001 }
/*************************************************************************
|*
|*	SwView::CreateVLineal()
|*
|*	Beschreibung
|*	Ersterstellung	VB 29.05.91
|*
*************************************************************************/

//STRIP001 int SwView::CreateVLineal()
//STRIP001 {
//STRIP001     pHRuler->SetBorderPos( pVRuler->GetSizePixel().Width()-1 );
//STRIP001 
//STRIP001     pVRuler->SetActive(GetFrame() && IsActive());
//STRIP001 	const SwViewOption* pOpt = pWrtShell->GetViewOptions();
//STRIP001     pVRuler->Show();
//STRIP001     InvalidateBorder();
//STRIP001     return 1;
//STRIP001 }

/*************************************************************************
|*
|*	SwView::KillVLineal()
|*
|*	Beschreibung
|*	Ersterstellung	VB 29.05.91
|*
*************************************************************************/

//STRIP001 int SwView::KillVLineal()
//STRIP001 {
//STRIP001     pVRuler->Hide();
//STRIP001     pHRuler->SetBorderPos( 0 );
//STRIP001 	InvalidateBorder();
//STRIP001 	return 1;
//STRIP001 }
/*************************************************************************
|*
|*	SwView::ExecRulerClick()
|*
|*	Beschreibung
|*	Ersterstellung	OS 15.06.95
|*	Letzte Aenderung
|*
*************************************************************************/

/*?*/ IMPL_LINK( SwView, ExecRulerClick, Ruler *, pRuler )
/*?*/ {
		{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 	USHORT nDefPage = 0;
//STRIP001 	switch( pRuler->GetClickType() )
//STRIP001 	{
//STRIP001 		case RULER_TYPE_DONTKNOW:
//STRIP001 		case RULER_TYPE_OUTSIDE:
//STRIP001 		case RULER_TYPE_INDENT:
//STRIP001 		case RULER_TYPE_MARGIN1:
//STRIP001 		case RULER_TYPE_MARGIN2:
//STRIP001 			nDefPage = TP_PARA_STD;
//STRIP001 		break;
//STRIP001 		default:
//STRIP001 			nDefPage = TP_TABULATOR;
//STRIP001 
//STRIP001 	}
//STRIP001 
//STRIP001 	SfxUInt16Item aDefPage(SID_PARA_DLG, nDefPage);
//STRIP001 	GetViewFrame()->GetDispatcher()->Execute( SID_PARA_DLG,
//STRIP001 								SFX_CALLMODE_SYNCHRON|SFX_CALLMODE_RECORD,
//STRIP001 								&aDefPage, 0L );
/*?*/ 	return 0;
/*?*/ }


/*-----------------20.02.97 09:11-------------------

--------------------------------------------------*/

//STRIP001 USHORT SwView::GetMoveType()
//STRIP001 {
//STRIP001 	return nMoveType;
//STRIP001 }
/*-----------------20.02.97 09:11-------------------

--------------------------------------------------*/

//STRIP001 void SwView::SetMoveType(USHORT nSet)
//STRIP001 {
//STRIP001 	BOOL bLastPage = nMoveType == NID_PGE;
//STRIP001 	nMoveType = nSet;
//STRIP001 	BOOL bNewPage = nMoveType == NID_PGE;
//STRIP001 	if(bNewPage != bLastPage)
//STRIP001 	{
//STRIP001 		Color aColor(bNewPage ? COL_BLACK : VIEW_IMAGECOLOR);
//STRIP001 		const TypeId aTypeId = TYPE(SwView);
//STRIP001 		SwView* pView = (SwView*)SfxViewShell::GetFirst(&aTypeId);
//STRIP001 		while( pView )
//STRIP001 		{
//STRIP001 			pView->SetImageButtonColor(aColor);
//STRIP001 			pView = (SwView*)SfxViewShell::GetNext(*pView, &aTypeId);
//STRIP001 		}
//STRIP001 	}
//STRIP001 }

/*-----------------20.06.97 11:18-------------------

--------------------------------------------------*/
//STRIP001 void SwView::SetActMark(BYTE nSet)
//STRIP001 {
//STRIP001 	nActMark = nSet;
//STRIP001 }

/*-----------------15.03.97 10:53-------------------

--------------------------------------------------*/

//STRIP001 void SwView::SetImageButtonColor(Color& rColor)
//STRIP001 {
//STRIP001 	if(pPageUpBtn)
//STRIP001 	{
//STRIP001 		pPageUpBtn->SetControlForeground(rColor);
//STRIP001 		pPageDownBtn->SetControlForeground(rColor);
//STRIP001 	}
//STRIP001 }
/* -----------------------------2002/06/26 13:57------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void SwView::ShowHScrollbar(sal_Bool bShow)
/*N*/ {
/*N*/     DBG_ASSERT(pHScrollbar, "Scrollbar invalid")
/*N*/     pHScrollbar->Show(bShow);
/*N*/ }
/* -----------------------------2002/06/26 13:57------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool SwView::IsHScrollbarVisible()const
//STRIP001 {
//STRIP001     DBG_ASSERT(pHScrollbar, "Scrollbar invalid")
//STRIP001     return pHScrollbar->IsVisible() || pHScrollbar->IsAuto();
//STRIP001 }
/* -----------------------------2002/06/26 13:57------------------------------

 ---------------------------------------------------------------------------*/
/*N*/ void SwView::ShowVScrollbar(sal_Bool bShow)
/*N*/ {
/*N*/     DBG_ASSERT(pVScrollbar, "Scrollbar invalid")
/*N*/     pVScrollbar->Show(bShow);
/*N*/     pPageUpBtn->Show(bShow);
/*N*/     pPageDownBtn->Show(bShow);
//STRIP001 /*N*/     pNaviBtn->Show(bShow);
/*N*/ }
/* -----------------------------2002/06/26 13:57------------------------------

 ---------------------------------------------------------------------------*/
//STRIP001 sal_Bool SwView::IsVScrollbarVisible()const
//STRIP001 {
//STRIP001     DBG_ASSERT(pVScrollbar, "Scrollbar invalid")
//STRIP001     return pVScrollbar->IsVisible();
//STRIP001 }


}
