/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sw_viewtab.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 06:52:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/



#pragma hdrstop

// auto strip #ifndef _LIST_HXX //autogen
// auto strip #include <tools/list.hxx>
// auto strip #endif

#include <hintids.hxx>
#include "uiparam.hxx"
#include "uitool.hxx"

#ifndef _SVX_RULRITEM_HXX //autogen
#include <bf_svx/rulritem.hxx>
#endif
#ifndef _SVX_TSPTITEM_HXX //autogen
#include <bf_svx/tstpitem.hxx>
#endif
// auto strip #ifndef _SFXREQUEST_HXX //autogen
// auto strip #include <bf_sfx2/request.hxx>
// auto strip #endif
#ifndef _SVX_LRSPITEM_HXX //autogen
#include <bf_svx/lrspitem.hxx>
#endif
#ifndef _SVX_ULSPITEM_HXX //autogen
#include <bf_svx/ulspitem.hxx>
#endif
#ifndef _SVX_BOXITEM_HXX //autogen
#include <bf_svx/boxitem.hxx>
#endif
// auto strip #ifndef _SVX_FRMDIRITEM_HXX
// auto strip #include <bf_svx/frmdiritem.hxx>
// auto strip #endif
#ifndef _SFXENUMITEM_HXX //autogen
#include <svtools/eitem.hxx>
#endif
#ifndef _SFX_WHITER_HXX //autogen
#include <svtools/whiter.hxx>
#endif
#ifndef _SVX_RULER_HXX //autogen
#include <bf_svx/ruler.hxx>
#endif
#ifndef _SVX_PROTITEM_HXX //autogen
#include <bf_svx/protitem.hxx>
#endif
#ifndef _SFXRECTITEM_HXX //autogen
#include <svtools/rectitem.hxx>
#endif
// auto strip #ifndef _SFX_BINDINGS_HXX
// auto strip #include <bf_sfx2/bindings.hxx>
// auto strip #endif

// auto strip #ifndef _FMTFSIZE_HXX //autogen
// auto strip #include <fmtfsize.hxx>
// auto strip #endif
#ifndef _FMTHDFT_HXX //autogen
#include <fmthdft.hxx>
#endif
#ifndef _FMTCLDS_HXX //autogen
#include <fmtclds.hxx>
#endif

#ifndef _HORIORNT_HXX
#include <horiornt.hxx>
#endif

// auto strip #ifndef _FMTORNT_HXX //autogen
// auto strip #include <fmtornt.hxx>
// auto strip #endif
#ifndef _FRMATR_HXX
#include <frmatr.hxx>
#endif
// auto strip #include "view.hxx"
#include "wrtsh.hxx"
// auto strip #include "basesh.hxx"
#include "cmdid.h"
// auto strip #include "viewopt.hxx"
// auto strip #include "tabcol.hxx"
// auto strip #include "frmfmt.hxx"		// FrameFormat
#include "pagedesc.hxx"		// Aktuelles Seitenformat
#include "wview.hxx"
// auto strip #include "fmtcol.hxx"
// auto strip #include "section.hxx"
namespace binfilter {

/*--------------------------------------------------------------------
	Beschreibung:	Debug-Methode
 --------------------------------------------------------------------*/
#ifdef DEBUGLIN


//STRIP001 static void DebugTabCols(const SwTabCols &rCols)
//STRIP001 {
//STRIP001 	String aTmp("TabCols LeftMin ");
//STRIP001 	aTmp += rCols.GetLeftMin() / 56;
//STRIP001 	aTmp += "Left: ";
//STRIP001 	aTmp += rCols.GetLeft() / 56;
//STRIP001 	aTmp += "Right: ";
//STRIP001 	aTmp += rCols.GetRight() / 56;
//STRIP001 	aTmp += "RightMax: ";
//STRIP001 	aTmp += rCols.GetRightMax() / 56;
//STRIP001 	aTmp += ": ";
//STRIP001 	const USHORT nCount = rCols.Count();
//STRIP001 	for(USHORT i = 0; i < nCount; ++i) {
//STRIP001 		aTmp += rCols[i] / 56;
//STRIP001 		aTmp += ' ';
//STRIP001 	}
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }



//STRIP001 static void DebugColItems(SvxColumnItem& rColItem)
//STRIP001 {
//STRIP001 	String aTmp("Aktuell: ");
//STRIP001 	aTmp += rColItem.GetActColumn();
//STRIP001 	aTmp += " ColLeft: ";
//STRIP001 	aTmp +=  String(rColItem.GetLeft() / 56);
//STRIP001 	aTmp += "   ColRight: ";
//STRIP001 	aTmp +=  String(rColItem.GetRight() / 56);
//STRIP001 	for(USHORT i = 0; i < rColItem.Count(); ++i) {
//STRIP001 		aTmp += " Start: ";
//STRIP001 		aTmp += String(rColItem[i].nStart/56);
//STRIP001 		aTmp += " End: ";
//STRIP001 		aTmp += String(rColItem[i].nEnd/56);
//STRIP001 	}
//STRIP001 
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }


//STRIP001 static void DebugLRSpace(const SvxLongLRSpaceItem& rLRSpace)
//STRIP001 {
//STRIP001 	String aTmp("Left: ");
//STRIP001 	aTmp += rLRSpace.GetLeft() / 56;
//STRIP001 	aTmp += "   Right: ";
//STRIP001 	aTmp += rLRSpace.GetRight() / 56;
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }
//STRIP001 
//STRIP001 
//STRIP001 
//STRIP001 static void DebugULSpace(const SvxLongULSpaceItem& rULSpace)
//STRIP001 {
//STRIP001 	String aTmp("Upper: ");
//STRIP001 	aTmp += rULSpace.GetUpper() / 56;
//STRIP001 	aTmp += "   Lower: ";
//STRIP001 	aTmp += rULSpace.GetLower() / 56;
//STRIP001 
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }



//STRIP001 static void DebugTabStops(const SvxTabStopItem& rTabs)
//STRIP001 {
//STRIP001 	String aTmp("Tabs: ");
//STRIP001 
//STRIP001 	// Def Tabs loeschen
//STRIP001 	for(USHORT i = 0; i < rTabs.Count(); ++i)
//STRIP001 	{
//STRIP001 		aTmp += String(rTabs[i].GetTabPos() / 56);
//STRIP001 		aTmp += " : ";
//STRIP001 	}
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }



//STRIP001 static void DebugParaMargin(const SvxLRSpaceItem& rLRSpace)
//STRIP001 {
//STRIP001 	String aTmp("ParaLeft: ");
//STRIP001 	aTmp += rLRSpace.GetTxtLeft() / 56;
//STRIP001 	aTmp += "   ParaRight: ";
//STRIP001 	aTmp += rLRSpace.GetRight() / 56;
//STRIP001 	aTmp += "   FLI: ";
//STRIP001 	aTmp += rLRSpace.GetTxtFirstLineOfst() / 56;
//STRIP001 	InfoBox(0, aTmp).Execute();
//STRIP001 }
#define DEBUGTABCOLS( bla )		DebugTabCols( bla )
#define DEBUGCOLITEMS( bla )	DebugColItems	( bla )
#define DEBUGLRSPACE( bla )		DebugLRSpace	( bla )
#define DEBUGULSPACE( bla )		DebugULSpace	( bla )
#define DEBUGTABSTOPS( bla )	DebugTabStops	( bla )
#define DEBUGPARAMARGIN( bla )	DebugParaMargin	( bla )
#else
#define DEBUGTABCOLS
#define DEBUGCOLITEMS
#define DEBUGLRSPACE
#define DEBUGULSPACE
#define DEBUGTABSTOPS
#define DEBUGPARAMARGIN
#endif


/*--------------------------------------------------------------------
	Beschreibung:	Columns eintueten
 --------------------------------------------------------------------*/


/*N*/ void lcl_FillSvxColumn(const SwFmtCol& rCol,
/*N*/ 						  USHORT nTotalWidth,
/*N*/ 						  SvxColumnItem& rColItem,
/*N*/ 						  long nDistance)
/*N*/ {
/*N*/ 	const SwColumns& rCols = rCol.GetColumns();
/*N*/ 	USHORT nWidth = 0;
/*N*/ 
/*N*/     BOOL bOrtho = rCol.IsOrtho() && rCols.Count();
/*N*/     long nInnerWidth;
/*N*/     if( bOrtho )
/*N*/     {
/*N*/         nInnerWidth = nTotalWidth;
/*N*/         for ( USHORT i = 0; i < rCols.Count(); ++i )
/*N*/         {
/*N*/             SwColumn* pCol = rCols[i];
/*N*/             nInnerWidth -= pCol->GetLeft() + pCol->GetRight();
/*N*/         }
/*N*/         if( nInnerWidth < 0 )
/*N*/             nInnerWidth = 0;
/*N*/         else
/*N*/             nInnerWidth /= rCols.Count();
/*N*/     }
/*N*/     for ( USHORT i = 0; i < rCols.Count(); ++i )
/*N*/     {
/*N*/         SwColumn* pCol = rCols[i];
/*N*/         const USHORT nStart = USHORT(pCol->GetLeft() + nWidth + nDistance);
/*N*/         if( bOrtho )
/*N*/             nWidth += nInnerWidth + pCol->GetLeft() + pCol->GetRight();
/*N*/         else
/*N*/             nWidth += rCol.CalcColWidth(i, nTotalWidth);
/*N*/         const USHORT nEnd = USHORT(nWidth - pCol->GetRight() + nDistance);
/*N*/ 
/*N*/         SvxColumnDescription aColDesc(nStart, nEnd, TRUE);
/*N*/         rColItem.Append(aColDesc);
/*N*/     }
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	ColumnItem in ColumnInfo ueberfuehren
 --------------------------------------------------------------------*/


//STRIP001 void lcl_ConvertToCols(const SvxColumnItem& rColItem,
//STRIP001 						  USHORT nTotalWidth,
//STRIP001 						  SwFmtCol& rCols)
//STRIP001 {
//STRIP001 	ASSERT( rCols.GetNumCols() == rColItem.Count(), "Column count mismatch" );
//STRIP001 
//STRIP001 	USHORT nLeft 	= 0;
//STRIP001 	SwTwips nSumAll= 0;  // Summiere alle Spalten und Raender auf
//STRIP001 
//STRIP001 	SwColumns& rArr = rCols.GetColumns();
//STRIP001 
//STRIP001 	// Tabcols der Reihe nach
//STRIP001 	for( USHORT i=0; i < rColItem.Count()-1; ++i )
//STRIP001 	{
//STRIP001 		DBG_ASSERT(rColItem[i+1].nStart >= rColItem[i].nEnd,"\201berlappende Spalten" );
//STRIP001 		USHORT nStart = rColItem[i+1].nStart;
//STRIP001 		USHORT nEnd = rColItem[i].nEnd;
//STRIP001 		if(nStart < nEnd)
//STRIP001 			nStart = nEnd;
//STRIP001 		const USHORT nDiff	= nStart - nEnd;
//STRIP001 		const USHORT nRight = nDiff / 2;
//STRIP001 
//STRIP001 		USHORT nWidth = rColItem[i].nEnd - rColItem[i].nStart;
//STRIP001 		nWidth += nLeft + nRight;
//STRIP001 
//STRIP001 		SwColumn* pCol = rArr[i];
//STRIP001 		pCol->SetWishWidth( USHORT(long(rCols.GetWishWidth()) * long(nWidth) /
//STRIP001 															long(nTotalWidth) ));
//STRIP001 		pCol->SetLeft( nLeft );
//STRIP001 		pCol->SetRight( nRight );
//STRIP001 		nSumAll += pCol->GetWishWidth();
//STRIP001 
//STRIP001 		nLeft = nRight;
//STRIP001 	}
//STRIP001 	rArr[rColItem.Count()-1]->SetLeft( nLeft );
//STRIP001 
//STRIP001 	//Die Differenz aus der Gesamtwunschbreite und der Summe der bisher berechneten
//STRIP001 	// Spalten und Raender sollte die Breite der letzten Spalte ergeben.
//STRIP001 	rArr[rColItem.Count()-1]->SetWishWidth( rCols.GetWishWidth() - (USHORT)nSumAll );
//STRIP001 
//STRIP001 	rCols.SetOrtho(FALSE, 0, 0 );
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Tabs loeschen
 --------------------------------------------------------------------*/


/*N*/ void lcl_EraseDefTabs(SvxTabStopItem& rTabStops)
/*N*/ {
/*N*/ 	// Def Tabs loeschen
/*N*/ 	for ( USHORT i = 0; i < rTabStops.Count(); )
/*N*/ 	{
/*N*/ 		// Hier auch den DefTab auf Null rausschmeissen
/*N*/ 		if ( SVX_TAB_ADJUST_DEFAULT == rTabStops[i].GetAdjustment() ||
/*N*/ 			rTabStops[i].GetTabPos() == 0 )
/*N*/ 		{
/*N*/ 			rTabStops.Remove(i);
/*N*/ 			continue;
/*N*/ 		}
/*N*/ 		++i;
/*N*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Seitenrand umdrehen
 --------------------------------------------------------------------*/


/*N*/ void SwView::SwapPageMargin(const SwPageDesc& rDesc, SvxLRSpaceItem& rLRSpace)
/*N*/ {
/*N*/ 	USHORT nPhyPage, nVirPage;
/*N*/ 	GetWrtShell().GetPageNum( nPhyPage, nVirPage );
/*N*/ 
/*N*/ 	if ( rDesc.GetUseOn() == PD_MIRROR && (nPhyPage % 2) == 0 )
/*N*/ 	{
/*M*/ 		        long nTmp = rLRSpace.GetRight();
/*N*/ 		rLRSpace.SetRight( rLRSpace.GetLeft() );
/*N*/ 		rLRSpace.SetLeft( nTmp );
/*N*/ 	}
/*N*/ }

/*--------------------------------------------------------------------
	Beschreibung:	Wenn der Rahmenrand verschoben wird, sollen die
					Spaltentrenner an der gleichen absoluten Position bleiben
 --------------------------------------------------------------------*/


//STRIP001 void lcl_Scale(long& nVal, long nScale)
//STRIP001 {
//STRIP001 	nVal *= nScale;
//STRIP001 	nVal >>= 8;
//STRIP001 }

//STRIP001 void ResizeFrameCols(SwFmtCol& rCol,
//STRIP001 					long nOldWidth,
//STRIP001 					long nNewWidth,
//STRIP001 					long nLeftDelta )
//STRIP001 {
//STRIP001 	SwColumns& rArr = rCol.GetColumns();
//STRIP001 	long nWishSum = (long)rCol.GetWishWidth();
//STRIP001 	long nWishDiff = (nWishSum * 100/nOldWidth * nNewWidth) / 100 - nWishSum;
//STRIP001 	long nNewWishWidth = nWishSum + nWishDiff;
//STRIP001 	if(nNewWishWidth > 0xffffl)
//STRIP001 	{
//STRIP001 		// wenn die Wunschbreite zu gross wird, dann muessen alle Werte passend skaliert werden
//STRIP001 		long nScale = (0xffffl << 8)/ nNewWishWidth;
//STRIP001 		for(USHORT i = 0; i < rArr.Count(); i++)
//STRIP001 		{
//STRIP001 			SwColumn* pCol = rArr.GetObject(i);
//STRIP001 			long nVal = pCol->GetWishWidth();
//STRIP001 			lcl_Scale(nVal, nScale);
//STRIP001 			pCol->SetWishWidth((USHORT) nVal);
//STRIP001 			nVal = pCol->GetLeft();
//STRIP001 			lcl_Scale(nVal, nScale);
//STRIP001 			pCol->SetLeft((USHORT) nVal);
//STRIP001 			nVal = pCol->GetRight();
//STRIP001 			lcl_Scale(nVal, nScale);
//STRIP001 			pCol->SetRight((USHORT) nVal);
//STRIP001 		}
//STRIP001 		lcl_Scale(nNewWishWidth, nScale);
//STRIP001 		lcl_Scale(nWishDiff, nScale);
//STRIP001 	}
//STRIP001 	rCol.SetWishWidth( (USHORT) (nNewWishWidth) );
//STRIP001 
//STRIP001 	if( nLeftDelta >= 2 || nLeftDelta <= -2)
//STRIP001 		rArr[0]->SetWishWidth(rArr[0]->GetWishWidth() + (USHORT)nWishDiff);
//STRIP001 	else
//STRIP001 		rArr[rArr.Count()-1]->SetWishWidth(rArr[rArr.Count()-1]->GetWishWidth() + (USHORT)nWishDiff);
//STRIP001     //reset auto width
//STRIP001     rCol.SetOrtho(FALSE, 0, 0 );
//STRIP001 }
/*--------------------------------------------------------------------
	Beschreibung:	Hier werden alle Aenderungen der Tableiste
					wieder in das Modell geschossen
 --------------------------------------------------------------------*/


//STRIP001 void SwView::ExecTabWin( SfxRequest& rReq )
//STRIP001 {
//STRIP001 	SwWrtShell &rSh 		= GetWrtShell();
//STRIP001 	const USHORT nFrmType	= rSh.IsObjSelected() ?
//STRIP001 									FRMTYPE_DRAWOBJ :
//STRIP001 										rSh.GetFrmType(0,TRUE);
//STRIP001 	const BOOL 	bFrmSelection = rSh.IsFrmSelected();
//STRIP001 	BOOL bBrowse = rSh.IsBrowseMode();
//STRIP001 
//STRIP001 
//STRIP001 	const USHORT nSlot 	  	= rReq.GetSlot();
//STRIP001 	const USHORT nDescId  	= rSh.GetCurPageDesc();
//STRIP001 	const SwPageDesc& rDesc = rSh.GetPageDesc( nDescId );
//STRIP001 
//STRIP001     const SvxFrameDirectionItem& rFrameDir = rDesc.GetMaster().GetFrmDir();
//STRIP001     const BOOL bVerticalWriting = rSh.IsInVerticalText();
//STRIP001     const SwFmtHeader& rHeaderFmt = rDesc.GetMaster().GetHeader();
//STRIP001 	SwFrmFmt *pHeaderFmt = (SwFrmFmt*)rHeaderFmt.GetHeaderFmt();
//STRIP001 
//STRIP001 	const SwFmtFooter& rFooterFmt = rDesc.GetMaster().GetFooter();
//STRIP001 	SwFrmFmt *pFooterFmt = (SwFrmFmt*)rFooterFmt.GetFooterFmt();
//STRIP001 
//STRIP001 	const SwFmtFrmSize &rFrmSize = rDesc.GetMaster().GetFrmSize();
//STRIP001 
//STRIP001 	const SwRect& rPrtRect = rSh.GetAnyCurRect(RECT_PAGE);
//STRIP001 	const long nPageWidth  = bBrowse ?
//STRIP001 								rPrtRect.Width() :
//STRIP001 									rFrmSize.GetWidth();
//STRIP001 	const long nPageHeight = bBrowse ?
//STRIP001 								rPrtRect.Height() :
//STRIP001 									rFrmSize.GetHeight();
//STRIP001 	const SfxItemSet* pArgs = rReq.GetArgs();
//STRIP001 
//STRIP001 	BOOL bUnlockView = FALSE;
//STRIP001 	rSh.StartAllAction();
//STRIP001 
//STRIP001 	switch	( nSlot )
//STRIP001 	{
//STRIP001     case SID_ATTR_LONG_LRSPACE:
//STRIP001 	{
//STRIP001 		SvxLongLRSpaceItem aLongLR( (const SvxLongLRSpaceItem&)rReq.GetArgs()->
//STRIP001 													Get( SID_ATTR_LONG_LRSPACE ) );
//STRIP001 		SvxLRSpaceItem aLR;
//STRIP001 		DEBUGLRSPACE(aLongLR);
//STRIP001 		BOOL bSect = 0 != (nFrmType & FRMTYPE_COLSECT);
//STRIP001         if ( !bSect && (bFrmSelection || nFrmType & FRMTYPE_FLY_ANY) )
//STRIP001 		{
//STRIP001             SwFrmFmt* pFmt = ((SwFrmFmt*)rSh.GetFlyFrmFmt());
//STRIP001 			const SwRect &rRect = rSh.GetAnyCurRect(RECT_FLY_EMBEDDED);
//STRIP001 
//STRIP001             BOOL bRTL;
//STRIP001 			BOOL bVerticalFrame = (bFrmSelection && rSh.IsFrmVertical(TRUE, bRTL))|| (!bFrmSelection && bVerticalWriting);
//STRIP001             long nDeltaX = bVerticalFrame ?
//STRIP001                 rRect.Right() - nPageWidth - DOCUMENTBORDER + aLongLR.GetRight() :
//STRIP001 				DOCUMENTBORDER + aLongLR.GetLeft() - rRect.Left();
//STRIP001 
//STRIP001             SfxItemSet aSet( GetPool(), RES_FRM_SIZE, RES_FRM_SIZE,
//STRIP001                                         RES_VERT_ORIENT, RES_HORI_ORIENT,
//STRIP001 										RES_COL, RES_COL, 0 );
//STRIP001 
//STRIP001             if(bVerticalFrame)
//STRIP001             {
//STRIP001                 SwFmtVertOrient aVertOrient(pFmt->GetVertOrient());
//STRIP001                 aVertOrient.SetVertOrient(VERT_NONE);
//STRIP001                 aVertOrient.SetPos(aVertOrient.GetPos() + nDeltaX );
//STRIP001                 aSet.Put( aVertOrient );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 SwFmtHoriOrient aHoriOrient( pFmt->GetHoriOrient() );
//STRIP001                 aHoriOrient.SetHoriOrient( HORI_NONE );
//STRIP001                 aHoriOrient.SetPos( aHoriOrient.GetPos() + nDeltaX );
//STRIP001                 aSet.Put( aHoriOrient );
//STRIP001             }
//STRIP001 
//STRIP001 			SwFmtFrmSize aSize( pFmt->GetFrmSize() );
//STRIP001 			long nOldWidth = (long) aSize.GetWidth();
//STRIP001 
//STRIP001 			if(aSize.GetWidthPercent())
//STRIP001 			{
//STRIP001 				SwRect aRect;
//STRIP001 				rSh.CalcBoundRect(aRect, FLY_IN_CNTNT);
//STRIP001 				long nPrtWidth = aRect.Width();
//STRIP001 				aSize.SetWidthPercent(BYTE((nPageWidth - aLongLR.GetLeft() - aLongLR.GetRight()) * 100 /nPrtWidth));
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aSize.SetWidth( nPageWidth -
//STRIP001 						(aLongLR.GetLeft() + aLongLR.GetRight()));
//STRIP001 
//STRIP001 			if( nFrmType & FRMTYPE_COLUMN )
//STRIP001 			{
//STRIP001 				SwFmtCol aCol(pFmt->GetCol());
//STRIP001 
//STRIP001 				::ResizeFrameCols(aCol, nOldWidth, (long)aSize.GetWidth(), nDeltaX );
//STRIP001 				aSet.Put(aCol);
//STRIP001 			}
//STRIP001 
//STRIP001 			aSet.Put( aSize );
//STRIP001 
//STRIP001 			rSh.StartAction();
//STRIP001 			rSh.Push();
//STRIP001 			rSh.SetFlyFrmAttr( aSet );
//STRIP001 			//die Rahmenselektion wieder aufheben
//STRIP001 			if(!bFrmSelection && rSh.IsFrmSelected())
//STRIP001 			{
//STRIP001 				rSh.UnSelectFrm();
//STRIP001 				rSh.LeaveSelFrmMode();
//STRIP001 			}
//STRIP001 			rSh.Pop();
//STRIP001 			rSh.EndAction();
//STRIP001 		}
//STRIP001 		else if ( nFrmType & ( FRMTYPE_HEADER | FRMTYPE_FOOTER ))
//STRIP001 		{
//STRIP001 			// Seitenraender rausrechnen
//STRIP001             long nOld = rDesc.GetMaster().GetLRSpace().GetLeft();
//STRIP001             aLongLR.SetLeft( nOld > aLongLR.GetLeft() ? 0 : aLongLR.GetLeft() - nOld );
//STRIP001 
//STRIP001 			nOld = rDesc.GetMaster().GetLRSpace().GetRight();
//STRIP001 			aLongLR.SetRight( nOld > (USHORT)aLongLR.GetRight() ? 0 : aLongLR.GetRight() - nOld );
//STRIP001 			aLR.SetLeft((USHORT)aLongLR.GetLeft());
//STRIP001 			aLR.SetRight((USHORT)aLongLR.GetRight());
//STRIP001 
//STRIP001 			if ( nFrmType & FRMTYPE_HEADER )
//STRIP001 				pHeaderFmt->SetAttr( aLR );
//STRIP001 			else
//STRIP001 				pFooterFmt->SetAttr( aLR );
//STRIP001 		}
//STRIP001 		else if( nFrmType == FRMTYPE_DRAWOBJ)
//STRIP001 		{
//STRIP001 			SwRect aRect( rSh.GetObjRect() );
//STRIP001 			aRect.Left( aLongLR.GetLeft() + DOCUMENTBORDER );
//STRIP001 			aRect.Right( nPageWidth + DOCUMENTBORDER - aLongLR.GetRight());
//STRIP001 			rSh.SetObjRect( aRect );
//STRIP001 		}
//STRIP001         else if(bSect || rSh.IsDirectlyInSection())
//STRIP001 		{
//STRIP001 			//change the section indents and the columns if available
//STRIP001 			//at first determine the changes
//STRIP001             SwRect aSectRect = rSh.GetAnyCurRect(RECT_SECTION_PRT, 0);
//STRIP001             const SwRect aTmpRect = rSh.GetAnyCurRect(RECT_SECTION, 0);
//STRIP001             aSectRect.Pos() += aTmpRect.Pos();
//STRIP001             long nLeftDiff = aLongLR.GetLeft() - (long)(aSectRect.Left() - DOCUMENTBORDER);
//STRIP001             long nRightDiff = aLongLR.GetRight() - (long)(nPageWidth + DOCUMENTBORDER - aSectRect.Right());
//STRIP001 			//change the LRSpaceItem of the section accordingly
//STRIP001             const SwSection* pCurrSect = rSh.GetCurrSection();
//STRIP001             const SwSectionFmt* pSectFmt = pCurrSect->GetFmt();
//STRIP001             SvxLRSpaceItem aLR = pSectFmt->GetLRSpace();
//STRIP001             aLR.SetLeft(aLR.GetLeft() + nLeftDiff);
//STRIP001             aLR.SetRight(aLR.GetRight() + nRightDiff);
//STRIP001             SfxItemSet aSet(rSh.GetAttrPool(), RES_LR_SPACE, RES_LR_SPACE, RES_COL, RES_COL, 0L);
//STRIP001             aSet.Put(aLR);
//STRIP001 			//change the first/last column
//STRIP001 			if(bSect)
//STRIP001 			{
//STRIP001                 SwFmtCol aCols( pSectFmt->GetCol() );
//STRIP001                 long nDiffWidth = nLeftDiff + nRightDiff;
//STRIP001                 ::ResizeFrameCols(aCols, aSectRect.Width(), aSectRect.Width() - nDiffWidth, nLeftDiff );
//STRIP001                 aSet.Put( aCols );
//STRIP001 			}
//STRIP001             rSh.ChgSection( rSh.GetSectionFmtPos(*pSectFmt), *pCurrSect, &aSet );
//STRIP001 
//STRIP001         }
//STRIP001 		else
//STRIP001 		{	// Seitenraender einstellen
//STRIP001 			aLR.SetLeft((USHORT)aLongLR.GetLeft());
//STRIP001 			aLR.SetRight((USHORT)aLongLR.GetRight());
//STRIP001 			SwapPageMargin( rDesc, aLR );
//STRIP001 			SwPageDesc aDesc( rDesc );
//STRIP001 			aDesc.GetMaster().SetAttr( aLR );
//STRIP001 			rSh.ChgPageDesc( nDescId, aDesc );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001     case SID_ATTR_LONG_ULSPACE:
//STRIP001 	{
//STRIP001 		SvxLongULSpaceItem aLongULSpace( (const SvxLongULSpaceItem&)rReq.GetArgs()->
//STRIP001 														Get( SID_ATTR_LONG_ULSPACE ));
//STRIP001 		DEBUGULSPACE(aLongULSpace);
//STRIP001 
//STRIP001 		if( bFrmSelection || nFrmType & FRMTYPE_FLY_ANY )
//STRIP001 		{
//STRIP001             SwFrmFmt* pFmt = ((SwFrmFmt*)rSh.GetFlyFrmFmt());
//STRIP001 			const SwRect &rRect = rSh.GetAnyCurRect(RECT_FLY_EMBEDDED);
//STRIP001             const long nDeltaY =
//STRIP001                     DOCUMENTBORDER + aLongULSpace.GetUpper() -
//STRIP001 									rRect.Top();
//STRIP001 			const long nHeight = nPageHeight -
//STRIP001 							(aLongULSpace.GetUpper() + aLongULSpace.GetLower());
//STRIP001 
//STRIP001             SfxItemSet aSet( GetPool(), RES_FRM_SIZE, RES_FRM_SIZE,
//STRIP001                                         RES_VERT_ORIENT, RES_HORI_ORIENT, 0 );
//STRIP001             //which of the orientation attributes is to be put depends on the frame's environment
//STRIP001             BOOL bRTL;
//STRIP001             if((bFrmSelection && rSh.IsFrmVertical(TRUE, bRTL))|| (!bFrmSelection && bVerticalWriting))
//STRIP001             {
//STRIP001                 SwFmtHoriOrient aHoriOrient(pFmt->GetHoriOrient());
//STRIP001                 aHoriOrient.SetHoriOrient(HORI_NONE);
//STRIP001                 aHoriOrient.SetPos(aHoriOrient.GetPos() + nDeltaY );
//STRIP001                 aSet.Put( aHoriOrient );
//STRIP001             }
//STRIP001             else
//STRIP001             {
//STRIP001                 SwFmtVertOrient aVertOrient(pFmt->GetVertOrient());
//STRIP001                 aVertOrient.SetVertOrient(VERT_NONE);
//STRIP001                 aVertOrient.SetPos(aVertOrient.GetPos() + nDeltaY );
//STRIP001                 aSet.Put( aVertOrient );
//STRIP001             }
//STRIP001 			SwFmtFrmSize aSize(pFmt->GetFrmSize());
//STRIP001 			if(aSize.GetHeightPercent())
//STRIP001 			{
//STRIP001 				SwRect aRect;
//STRIP001 				rSh.CalcBoundRect(aRect, FLY_IN_CNTNT);
//STRIP001 				long nPrtHeight = aRect.Height();
//STRIP001 				aSize.SetHeightPercent(BYTE(nHeight * 100 /nPrtHeight));
//STRIP001 			}
//STRIP001 			else
//STRIP001 				aSize.SetHeight(nHeight );
//STRIP001 
//STRIP001             aSet.Put( aSize );
//STRIP001             rSh.SetFlyFrmAttr( aSet );
//STRIP001 		}
//STRIP001 		else if( nFrmType == FRMTYPE_DRAWOBJ )
//STRIP001 		{
//STRIP001 			SwRect aRect( rSh.GetObjRect() );
//STRIP001 			const SwRect &rPageRect = rSh.GetAnyCurRect(RECT_PAGE);
//STRIP001 			aRect.Top( aLongULSpace.GetUpper() + rPageRect.Top() );
//STRIP001 			aRect.Bottom( rPageRect.Bottom() - aLongULSpace.GetLower() );
//STRIP001 			rSh.SetObjRect( aRect ) ;
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{	SwPageDesc aDesc( rDesc );
//STRIP001 
//STRIP001 			if ( nFrmType & ( FRMTYPE_HEADER | FRMTYPE_FOOTER ))
//STRIP001 			{
//STRIP001 
//STRIP001 				const BOOL bHead = nFrmType & FRMTYPE_HEADER ? TRUE : FALSE;
//STRIP001 				SvxULSpaceItem aUL( rDesc.GetMaster().GetULSpace() );
//STRIP001 				if ( bHead )
//STRIP001 					aUL.SetUpper( (USHORT)aLongULSpace.GetUpper() );
//STRIP001 				else
//STRIP001 					aUL.SetLower( (USHORT)aLongULSpace.GetLower() );
//STRIP001 				aDesc.GetMaster().SetAttr( aUL );
//STRIP001 
//STRIP001 				SwFmtFrmSize aSz( bHead ? pHeaderFmt->GetFrmSize() :
//STRIP001 										  pFooterFmt->GetFrmSize() );
//STRIP001 				aSz.SetSizeType( ATT_FIX_SIZE );
//STRIP001 				aSz.SetHeight(nPageHeight - aLongULSpace.GetLower() -
//STRIP001 											aLongULSpace.GetUpper() );
//STRIP001 				if ( bHead )
//STRIP001 					pHeaderFmt->SetAttr( aSz );
//STRIP001 				else
//STRIP001 					pFooterFmt->SetAttr( aSz );
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SvxULSpaceItem aUL;
//STRIP001 				aUL.SetUpper((USHORT)aLongULSpace.GetUpper());
//STRIP001 				aUL.SetLower((USHORT)aLongULSpace.GetLower());
//STRIP001 				aDesc.GetMaster().SetAttr(aUL);
//STRIP001 			}
//STRIP001 
//STRIP001 			rSh.ChgPageDesc( nDescId, aDesc );
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001     case SID_ATTR_TABSTOP_VERTICAL:
//STRIP001     case SID_ATTR_TABSTOP:
//STRIP001     {
//STRIP001 		USHORT nWhich = GetPool().GetWhich(nSlot);
//STRIP001 		SvxTabStopItem aTabStops( (const SvxTabStopItem&)rReq.GetArgs()->
//STRIP001                                                     Get( nWhich ));
//STRIP001 		aTabStops.SetWhich(RES_PARATR_TABSTOP);
//STRIP001 		DEBUGTABSTOPS(aTabStops);
//STRIP001 		const SvxTabStopItem& rDefTabs =
//STRIP001 					(const SvxTabStopItem&)rSh.GetDefault(RES_PARATR_TABSTOP);
//STRIP001 
//STRIP001 		// Default-Tab an Pos 0
//STRIP001 		SfxItemSet aSet( GetPool(), RES_LR_SPACE, RES_LR_SPACE );
//STRIP001 		rSh.GetAttr( aSet );
//STRIP001 		const SvxLRSpaceItem& rLR = (const SvxLRSpaceItem&)aSet.Get(RES_LR_SPACE);
//STRIP001 
//STRIP001 		if ( rLR.GetTxtFirstLineOfst() < 0 )
//STRIP001 		{
//STRIP001 			SvxTabStop aSwTabStop( 0, SVX_TAB_ADJUST_DEFAULT );
//STRIP001 			aTabStops.Insert( aSwTabStop );
//STRIP001 		}
//STRIP001 
//STRIP001 		// auffuellen mit Default-Tabs
//STRIP001 		USHORT nDef = ::binfilter::GetTabDist( rDefTabs );
//STRIP001 		::MakeDefTabs( nDef, aTabStops );
//STRIP001 
//STRIP001 		SwTxtFmtColl* pColl = rSh.GetCurTxtFmtColl();
//STRIP001 		if(	pColl && pColl->IsAutoUpdateFmt() )
//STRIP001 		{
//STRIP001 			SfxItemSet aSet(GetPool(), RES_PARATR_TABSTOP, RES_PARATR_TABSTOP);
//STRIP001 			aSet.Put(aTabStops);
//STRIP001 			rSh.AutoUpdatePara( pColl, aSet);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rSh.SetAttr( aTabStops );
//STRIP001 		break;
//STRIP001 	}
//STRIP001     case SID_ATTR_PARA_LRSPACE_VERTICAL:
//STRIP001     case SID_ATTR_PARA_LRSPACE:
//STRIP001 	{
//STRIP001 		SvxLRSpaceItem aParaMargin((const SvxLRSpaceItem&)rReq.
//STRIP001 										GetArgs()->Get(nSlot));
//STRIP001 
//STRIP001 		long nLDist = 0;
//STRIP001         long nRDist = 0;
//STRIP001 
//STRIP001 		if(nFrmType & FRMTYPE_FLY_ANY)
//STRIP001 		{
//STRIP001 // os: Wegen #42444# wird hier der Umrandungsabstand eingefuegt
//STRIP001 			SfxItemSet aCoreSet( GetPool(),
//STRIP001 									RES_BOX, RES_BOX,
//STRIP001 									SID_ATTR_BORDER_INNER, SID_ATTR_BORDER_INNER, 0 );
//STRIP001 
//STRIP001             sal_Bool bFirstColumn = sal_True;
//STRIP001             sal_Bool bLastColumn = sal_True;
//STRIP001             if(nFrmType & FRMTYPE_COLUMN)
//STRIP001             {
//STRIP001                 USHORT nCurFrameCol = rSh.GetCurColNum() - 1;
//STRIP001                 bFirstColumn = !nCurFrameCol;
//STRIP001                 const SwFrmFmt* pFmt =  rSh.GetFlyFrmFmt();
//STRIP001                 const SwFmtCol* pCols = &pFmt->GetCol();
//STRIP001                 const SwColumns& rCols = pCols->GetColumns();
//STRIP001                 USHORT nColumnCount = rCols.Count();
//STRIP001                 bLastColumn = nColumnCount == nCurFrameCol + 1;
//STRIP001             }
//STRIP001 
//STRIP001             if(bFirstColumn || bLastColumn)
//STRIP001             {
//STRIP001                 SvxBoxInfoItem aBoxInfo;
//STRIP001                 aCoreSet.Put( aBoxInfo );
//STRIP001                 rSh.GetFlyFrmAttr( aCoreSet );
//STRIP001                 const SvxBoxItem& rBox = (const SvxBoxItem&)aCoreSet.Get(RES_BOX);
//STRIP001 
//STRIP001                 if(bFirstColumn)
//STRIP001                     nLDist = rBox.GetDistance(BOX_LINE_LEFT);
//STRIP001                 if(bLastColumn)
//STRIP001                     nRDist = rBox.GetDistance(BOX_LINE_RIGHT);
//STRIP001             }
//STRIP001 		}
//STRIP001         else if ( IsTabColFromDoc() ||
//STRIP001 			( rSh.GetTableFmt() && !bFrmSelection &&
//STRIP001 			!(nFrmType & FRMTYPE_COLSECT ) ) )
//STRIP001 		{
//STRIP001             SfxItemSet aCoreSet( GetPool(),
//STRIP001                                     RES_BOX, RES_BOX,
//STRIP001                                     SID_ATTR_BORDER_INNER, SID_ATTR_BORDER_INNER, 0 );
//STRIP001             SvxBoxInfoItem aBoxInfo;
//STRIP001             aCoreSet.Put( aBoxInfo );
//STRIP001             aBoxInfo.SetTable(FALSE);
//STRIP001             aBoxInfo.SetDist((BOOL) TRUE);
//STRIP001             aCoreSet.Put(aBoxInfo);
//STRIP001             rSh.GetTabBorders( aCoreSet );
//STRIP001             const SvxBoxItem& rBox = (const SvxBoxItem&)aCoreSet.Get(RES_BOX);
//STRIP001             SvxLRSpaceItem aDistLR(SID_RULER_BORDER_DISTANCE);
//STRIP001 			nLDist = rBox.GetDistance(BOX_LINE_LEFT);
//STRIP001 			nRDist = rBox.GetDistance(BOX_LINE_RIGHT);
//STRIP001 		}
//STRIP001 		aParaMargin.SetRight( aParaMargin.GetRight() - nRDist );
//STRIP001         aParaMargin.SetTxtLeft(aParaMargin.GetTxtLeft() - nLDist);
//STRIP001 
//STRIP001 		DEBUGPARAMARGIN(aParaMargin);
//STRIP001 
//STRIP001 		aParaMargin.SetWhich( RES_LR_SPACE );
//STRIP001 		SwTxtFmtColl* pColl = rSh.GetCurTxtFmtColl();
//STRIP001 		if(	pColl && pColl->IsAutoUpdateFmt() )
//STRIP001 		{
//STRIP001 			SfxItemSet aSet(GetPool(), RES_LR_SPACE, RES_LR_SPACE);
//STRIP001 			aSet.Put(aParaMargin);
//STRIP001 			rSh.AutoUpdatePara( pColl, aSet);
//STRIP001 		}
//STRIP001 		else
//STRIP001 			rSh.SetAttr( aParaMargin );
//STRIP001 
//STRIP001 		if ( aParaMargin.GetTxtFirstLineOfst() < 0 )
//STRIP001 		{
//STRIP001 			SfxItemSet aSet( GetPool(), RES_PARATR_TABSTOP, RES_PARATR_TABSTOP );
//STRIP001 
//STRIP001 			rSh.GetAttr( aSet );
//STRIP001 			const SvxTabStopItem&  rTabStops = (const SvxTabStopItem&)aSet.Get(RES_PARATR_TABSTOP);
//STRIP001 
//STRIP001 			// Haben wir einen Tab an Stelle Null
//STRIP001 			for ( USHORT i = 0; i < rTabStops.Count(); ++i )
//STRIP001 				if ( rTabStops[i].GetTabPos() == 0 )
//STRIP001 					break;
//STRIP001 
//STRIP001 			if ( i >= rTabStops.Count() )
//STRIP001 			{
//STRIP001 				// Kein DefTab
//STRIP001 				SvxTabStopItem aTabStops;
//STRIP001 				aTabStops = rTabStops;
//STRIP001 
//STRIP001 				::binfilter::lcl_EraseDefTabs(aTabStops);
//STRIP001 
//STRIP001 				SvxTabStop aSwTabStop( 0, SVX_TAB_ADJUST_DEFAULT );
//STRIP001 				aTabStops.Insert(aSwTabStop);
//STRIP001 
//STRIP001 				const SvxTabStopItem& rDefTabs =
//STRIP001 					(const SvxTabStopItem&)rSh.GetDefault(RES_PARATR_TABSTOP);
//STRIP001 				USHORT nDef = ::binfilter::GetTabDist(rDefTabs);
//STRIP001 				::MakeDefTabs( nDef, aTabStops );
//STRIP001 
//STRIP001 				if(	pColl && pColl->IsAutoUpdateFmt())
//STRIP001 				{
//STRIP001 					SfxItemSet aSet(GetPool(), RES_PARATR_TABSTOP, RES_PARATR_TABSTOP);
//STRIP001 					aSet.Put(aTabStops);
//STRIP001 					rSh.AutoUpdatePara( pColl, aSet);
//STRIP001 				}
//STRIP001 				else
//STRIP001 					rSh.SetAttr( aTabStops );
//STRIP001 			}
//STRIP001 		}
//STRIP001 	}
//STRIP001 	break;
//STRIP001     case SID_RULER_BORDERS_VERTICAL:
//STRIP001     case SID_RULER_BORDERS:
//STRIP001 	{
//STRIP001 		SvxColumnItem aColItem((const SvxColumnItem&)rReq.
//STRIP001                                             GetArgs()->Get(nSlot));
//STRIP001 
//STRIP001 		BOOL bSect = 0 != (nFrmType & FRMTYPE_COLSECT);
//STRIP001 		if( bSetTabColFromDoc || !bSect && rSh.GetTableFmt() )
//STRIP001 		{
//STRIP001 			ASSERT(aColItem.Count(), "ColDesc ist leer!!");
//STRIP001 
//STRIP001 			const BOOL bSingleLine = ((const SfxBoolItem&)rReq.
//STRIP001 							GetArgs()->Get(SID_RULER_ACT_LINE_ONLY)).GetValue();
//STRIP001 
//STRIP001 			DEBUGCOLITEMS(aColItem);
//STRIP001 			SwTabCols aTabCols;
//STRIP001 			if ( bSetTabColFromDoc )
//STRIP001 				rSh.GetMouseTabCols( aTabCols, aTabColFromDocPos );
//STRIP001 			else
//STRIP001 				rSh.GetTabCols(aTabCols);
//STRIP001 			DEBUGTABCOLS(aTabCols);
//STRIP001 
//STRIP001 			// linker Tabellenrand
//STRIP001 			long nBorder = long(aColItem.GetLeft()) -
//STRIP001 							 (long(aTabCols.GetLeftMin()) - DOCUMENTBORDER);
//STRIP001 			aTabCols.SetLeft( nBorder );
//STRIP001 
//STRIP001 			nBorder = nPageWidth - aTabCols.GetLeftMin() +
//STRIP001 							  DOCUMENTBORDER - aColItem.GetRight();
//STRIP001 
//STRIP001 #ifdef DEBUG
//STRIP001             long nTmp1 = DOCUMENTBORDER + nPageWidth;
//STRIP001             long nTmp2 = aTabCols.GetLeftMin() + nBorder;
//STRIP001 #endif
//STRIP001 
//STRIP001             if ( aColItem.GetRight() > 0 )
//STRIP001         		aTabCols.SetRight( nBorder );
//STRIP001 
//STRIP001 			// Tabcols der Reihe nach
//STRIP001 			// Die letzte Col wird durch den Rand definiert
//STRIP001             //columns in right-to-left tables need to be mirrored
//STRIP001             BOOL bIsTableRTL =
//STRIP001                 IsTabColFromDoc() ?
//STRIP001                       rSh.IsMouseTableRightToLeft(aTabColFromDocPos)
//STRIP001                     : rSh.IsTableRightToLeft();
//STRIP001             if(bIsTableRTL)
//STRIP001 			{
//STRIP001 				USHORT nColCount = aColItem.Count() - 1;
//STRIP001 				for ( USHORT i = 0; i < nColCount; ++i )
//STRIP001 				{
//STRIP001 					const SvxColumnDescription& rCol = aColItem[nColCount - i];
//STRIP001 					aTabCols[i] = aTabCols.GetRight() - rCol.nStart;
//STRIP001 					aTabCols.SetHidden( i, !rCol.bVisible );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				for ( USHORT i = 0; i < aColItem.Count()-1; ++i )
//STRIP001 				{
//STRIP001 					const SvxColumnDescription& rCol = aColItem[i];
//STRIP001 					aTabCols[i] = rCol.nEnd + aTabCols.GetLeft();
//STRIP001 					aTabCols.SetHidden( i, !rCol.bVisible );
//STRIP001 				}
//STRIP001 			}
//STRIP001 			DEBUGTABCOLS(aTabCols);
//STRIP001 
//STRIP001 			if ( bSetTabColFromDoc )
//STRIP001 			{
//STRIP001 				if( !rSh.IsViewLocked() )
//STRIP001 				{
//STRIP001 					bUnlockView = TRUE;
//STRIP001 					rSh.LockView( TRUE );
//STRIP001 				}
//STRIP001 				rSh.SetMouseTabCols( aTabCols, bSingleLine,
//STRIP001 											   aTabColFromDocPos );
//STRIP001 			}
//STRIP001 			else
//STRIP001 				rSh.SetTabCols(aTabCols, bSingleLine);
//STRIP001 
//STRIP001 		}
//STRIP001 		else
//STRIP001 		{
//STRIP001 			if ( bFrmSelection || nFrmType & FRMTYPE_FLY_ANY || bSect)
//STRIP001 			{
//STRIP001 				SwSectionFmt *pSectFmt = 0;
//STRIP001 				SfxItemSet aSet( GetPool(), RES_COL, RES_COL );
//STRIP001 				if(bSect)
//STRIP001 				{
//STRIP001 					const SwSection *pSect = rSh.GetAnySection();
//STRIP001 					ASSERT( pSect, "Welcher Bereich?");
//STRIP001 					pSectFmt = pSect->GetFmt();
//STRIP001 				}
//STRIP001 				else
//STRIP001 				{
//STRIP001 					rSh.GetFlyFrmAttr( aSet );
//STRIP001 				}
//STRIP001 				SwFmtCol aCols(
//STRIP001 					bSect ?
//STRIP001 						pSectFmt->GetCol() :
//STRIP001 							(const SwFmtCol&)aSet.Get( RES_COL, FALSE ));
//STRIP001 
//STRIP001 				const long lWidth = rSh.GetAnyCurRect(bSect ? RECT_SECTION_PRT : RECT_FLY_PRT_EMBEDDED).Width();
//STRIP001 				::lcl_ConvertToCols( aColItem, USHORT(lWidth), aCols );
//STRIP001 				DEBUGCOLITEMS(aColItem);
//STRIP001 				aSet.Put( aCols );
//STRIP001 				if(bSect)
//STRIP001 					rSh.SetSectionAttr( aSet, pSectFmt );
//STRIP001 				else
//STRIP001 				{
//STRIP001 					rSh.StartAction();
//STRIP001 					rSh.Push();
//STRIP001 					rSh.SetFlyFrmAttr( aSet );
//STRIP001 					//die Rahmenselektion wieder aufheben
//STRIP001 					if(!bFrmSelection && rSh.IsFrmSelected())
//STRIP001 					{
//STRIP001 						rSh.UnSelectFrm();
//STRIP001 						rSh.LeaveSelFrmMode();
//STRIP001 					}
//STRIP001 					rSh.Pop();
//STRIP001 					rSh.EndAction();
//STRIP001 				}
//STRIP001 			}
//STRIP001 			else
//STRIP001 			{
//STRIP001 				SwFmtCol aCols( rDesc.GetMaster().GetCol() );
//STRIP001                 const SwRect aPrtRect = rSh.GetAnyCurRect(RECT_PAGE_PRT);
//STRIP001 				::lcl_ConvertToCols( aColItem,
//STRIP001 					USHORT(bVerticalWriting ? aPrtRect.Height() : aPrtRect.Width()),
//STRIP001 								aCols );
//STRIP001 				DEBUGCOLITEMS(aColItem);
//STRIP001 				SwPageDesc aDesc( rDesc );
//STRIP001 				aDesc.GetMaster().SetAttr( aCols );
//STRIP001 				rSh.ChgPageDesc( rSh.GetCurPageDesc(), aDesc );
//STRIP001 			}
//STRIP001 		}
//STRIP001 		break;
//STRIP001 	}
//STRIP001 	default:
//STRIP001 		ASSERT( !this, "Falsche SlotId");
//STRIP001 	}
//STRIP001 	rSh.EndAllAction();
//STRIP001 
//STRIP001 	if( bUnlockView )
//STRIP001 		rSh.LockView( FALSE );
//STRIP001 
//STRIP001 	bSetTabColFromDoc = bTabColFromDoc = FALSE;
//STRIP001 }

/*--------------------------------------------------------------------
	Beschreibung:	Hier wird der Status der Tableiste ermittelt
					sprich alle relevanten Attribute an der CursorPos
					werden der Tableiste uebermittelt
 --------------------------------------------------------------------*/


/*N*/ void SwView::StateTabWin(SfxItemSet& rSet)
/*N*/ {
/*N*/ 	SwWrtShell &rSh 		= GetWrtShell();
/*N*/ 
/*N*/ 	const Point* pPt = IsTabColFromDoc() ? &aTabColFromDocPos : 0;
/*N*/ 	const USHORT nFrmType	= rSh.IsObjSelected()
/*N*/ 				? FRMTYPE_DRAWOBJ
/*N*/ 				: rSh.GetFrmType( pPt, TRUE );
/*N*/ 
/*N*/ 	const BOOL 	bFrmSelection = rSh.IsFrmSelected();
/*N*/ 
/*N*/ 	BOOL bBrowse = rSh.IsBrowseMode();
/*N*/ 	// PageOffset/Begrenzer
/*N*/ 	const SwRect& rPageRect = rSh.GetAnyCurRect( RECT_PAGE, pPt );
/*N*/ 	const SwRect& rPagePrtRect = rSh.GetAnyCurRect( RECT_PAGE_PRT, pPt );
/*N*/ 	const long nPageWidth  = rPageRect.Width();
/*N*/ 	const long nPageHeight = rPageRect.Height();
/*N*/ 
/*N*/     const SwPageDesc& rDesc = rSh.GetPageDesc(
/*N*/                 IsTabColFromDoc() ? rSh.GetMousePageDesc(aTabColFromDocPos) : rSh.GetCurPageDesc() );
/*N*/ 
/*N*/     const SvxFrameDirectionItem& rFrameDir = rDesc.GetMaster().GetFrmDir();
/*N*/     const BOOL bVerticalWriting = rSh.IsInVerticalText();
/*N*/ 
/*N*/     //enable tab stop display on the rulers depending on the writing direction
/*N*/     WinBits nRulerStyle = pHRuler->GetStyle() & ~WB_EXTRAFIELD;
/*N*/     pHRuler->SetStyle(bVerticalWriting||bBrowse ? nRulerStyle : nRulerStyle|WB_EXTRAFIELD);
/*N*/ 
/*N*/     nRulerStyle = pVRuler->GetStyle() & ~WB_EXTRAFIELD;
/*N*/     pVRuler->SetStyle(bVerticalWriting ? nRulerStyle|WB_EXTRAFIELD : nRulerStyle);
/*N*/ 
/*N*/     SvxLRSpaceItem aPageLRSpace( rDesc.GetMaster().GetLRSpace() );
/*N*/ 	SwapPageMargin( rDesc, aPageLRSpace );
/*N*/ 
/*N*/ 	SfxItemSet aCoreSet( GetPool(), RES_PARATR_TABSTOP, RES_PARATR_TABSTOP,
/*N*/ 									RES_LR_SPACE, 		 RES_UL_SPACE, 0 );
/*N*/ 	rSh.GetAttr( aCoreSet );
/*N*/ 	USHORT nSelectionType = rSh.GetSelectionType();
/*N*/ 
/*N*/ 	SfxWhichIter aIter( rSet );
/*N*/ 	USHORT nWhich = aIter.FirstWhich();
/*N*/ 
/*N*/ 	while ( nWhich )
/*N*/ 	{
/*N*/ 		switch ( nWhich )
/*N*/ 		{
/*N*/ //        case RES_LR_SPACE:
/*N*/ //        case SID_ATTR_LRSPACE:
/*N*/ 		case SID_ATTR_LONG_LRSPACE:
/*N*/         {
/*?*/ 			SvxLongLRSpaceItem aLongLR( (long)aPageLRSpace.GetLeft(),
/*?*/ 										(long)aPageLRSpace.GetRight(),
/*?*/ 										SID_ATTR_LONG_LRSPACE);
/*?*/ 			if(bBrowse)
/*?*/ 			{
/*?*/ 				aLongLR.SetLeft(rPagePrtRect.Left());
/*?*/ 				aLongLR.SetRight(nPageWidth - rPagePrtRect.Right());
/*?*/ 			}
/*?*/ 			if ( ( nFrmType & FRMTYPE_HEADER || nFrmType & FRMTYPE_FOOTER ) &&
/*?*/ 				 !(nFrmType & FRMTYPE_COLSECT) )
/*?*/ 			{
/*?*/ 				SwFrmFmt *pFmt = (SwFrmFmt*) (nFrmType & FRMTYPE_HEADER ?
/*?*/ 								rDesc.GetMaster().GetHeader().GetHeaderFmt() :
/*?*/ 								rDesc.GetMaster().GetFooter().GetFooterFmt());
/*?*/ 				SwRect aRect( rSh.GetAnyCurRect( RECT_HEADERFOOTER, pPt));
/*?*/ 				aRect.Pos() -= rSh.GetAnyCurRect( RECT_PAGE, pPt ).Pos();
/*?*/ 				const SvxLRSpaceItem& aLR = pFmt->GetLRSpace();
/*?*/ 				aLongLR.SetLeft ( (long)aLR.GetLeft() + (long)aRect.Left() );
/*?*/ 				aLongLR.SetRight( (nPageWidth -
/*?*/ 									(long)aRect.Right() + (long)aLR.GetRight()));
/*?*/ 			}
/*?*/ 			else
/*?*/ 			{
/*?*/ 				SwRect aRect;
/*?*/ 				if( !bFrmSelection && ((nFrmType & FRMTYPE_COLSECT) || rSh.IsDirectlyInSection()) )
/*?*/                 {
/*?*/                     aRect = rSh.GetAnyCurRect(RECT_SECTION_PRT, pPt);
/*?*/                     const SwRect aTmpRect = rSh.GetAnyCurRect(RECT_SECTION, pPt);
/*?*/                     aRect.Pos() += aTmpRect.Pos();
/*?*/                 }
/*?*/ 
/*?*/ 				else if ( bFrmSelection || nFrmType & FRMTYPE_FLY_ANY )
/*?*/ 					aRect = rSh.GetAnyCurRect(RECT_FLY_EMBEDDED, pPt);
/*?*/ 				else if( nFrmType & FRMTYPE_DRAWOBJ)
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP");} //STRIP001 aRect = rSh.GetObjRect();
/*?*/ 
/*?*/ 				if( aRect.Width() )
/*?*/ 				{
/*?*/ 					aLongLR.SetLeft ((long)(aRect.Left() - DOCUMENTBORDER));
/*?*/ 					aLongLR.SetRight((long)(nPageWidth + DOCUMENTBORDER - aRect.Right()));
/*?*/ 				}
/*?*/ 			}
/*?*/ 			if( nWhich == SID_ATTR_LONG_LRSPACE )
/*?*/ 				rSet.Put( aLongLR );
/*?*/             else
/*?*/ 			{
/*?*/ 				SvxLRSpaceItem aLR( aLongLR.GetLeft(),
/*?*/ 								    aLongLR.GetRight(),
/*?*/ 									nWhich);
/*?*/ 				rSet.Put(aLR);
/*?*/ 			}
/*?*/ 			DEBUGLRSPACE(aLongLR);
/*?*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_ATTR_LONG_ULSPACE:
/*N*/ //        case SID_ATTR_ULSPACE:
/*N*/ //        case RES_UL_SPACE:
/*N*/ 		{
/*N*/ 			// Rand Seite Oben Unten
/*N*/ 			SvxULSpaceItem aUL( rDesc.GetMaster().GetULSpace() );
/*N*/ 			SvxLongULSpaceItem aLongUL( (long)aUL.GetUpper(),
/*N*/ 										(long)aUL.GetLower(),
/*N*/ 										SID_ATTR_LONG_ULSPACE);
/*N*/ 
/*N*/ 			if ( bFrmSelection || nFrmType & FRMTYPE_FLY_ANY )
/*N*/ 			{
/*N*/ 				// Dokumentkoordinaten Frame auf Seitenkoordinaten umbrechen
/*N*/ 				const SwRect &rRect = rSh.GetAnyCurRect(RECT_FLY_EMBEDDED, pPt);
/*N*/ 				aLongUL.SetUpper((USHORT)(rRect.Top() - rPageRect.Top() ));
/*N*/ 				aLongUL.SetLower((USHORT)(rPageRect.Bottom() - rRect.Bottom() ));
/*N*/ 			}
/*N*/ 			else if ( nFrmType & FRMTYPE_HEADER || nFrmType & FRMTYPE_FOOTER )
/*N*/ 			{
/*?*/ 				SwRect aRect( rSh.GetAnyCurRect( RECT_HEADERFOOTER, pPt));
/*?*/ 				aRect.Pos() -= rSh.GetAnyCurRect( RECT_PAGE, pPt ).Pos();
/*?*/ 				aLongUL.SetUpper( (USHORT)aRect.Top() );
/*?*/ 				aLongUL.SetLower( (USHORT)(nPageHeight - aRect.Bottom()) );
/*?*/ 			}
/*N*/ 			else if( nFrmType & FRMTYPE_DRAWOBJ)
/*?*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				const SwRect &rRect = rSh.GetObjRect();
//STRIP001 /*?*/ 				aLongUL.SetUpper((rRect.Top() - rPageRect.Top()));
//STRIP001 /*?*/ 				aLongUL.SetLower((rPageRect.Bottom() - rRect.Bottom()));
/*N*/ 			}
/*N*/ 			else if(bBrowse)
/*?*/ 			{
/*?*/ 				aLongUL.SetUpper(rPagePrtRect.Top());
/*?*/ 				aLongUL.SetLower(nPageHeight - rPagePrtRect.Bottom());
/*?*/ 			}
/*N*/ 			if( nWhich == SID_ATTR_LONG_ULSPACE )
/*N*/ 				rSet.Put( aLongUL );
/*N*/ 			else
/*N*/ 			{
/*?*/ 				SvxULSpaceItem aUL((USHORT)aLongUL.GetUpper(),
/*?*/ 									(USHORT)aLongUL.GetLower(),
/*?*/ 									nWhich);
/*?*/ 				rSet.Put(aUL);
/*N*/ 			}
/*N*/ 			DEBUGULSPACE(aLongUL);
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_ATTR_TABSTOP_VERTICAL :
/*N*/         case RES_PARATR_TABSTOP:
/*N*/ 		{
/*N*/ 			if ( ISA( SwWebView ) ||
/*N*/ 				 IsTabColFromDoc() ||
/*N*/ 				 ( nSelectionType & SwWrtShell::SEL_GRF) ||
/*N*/ 					(nSelectionType & SwWrtShell::SEL_FRM) ||
/*N*/ 					(nSelectionType & SwWrtShell::SEL_OLE) ||
/*N*/                     SFX_ITEM_AVAILABLE > aCoreSet.GetItemState(RES_LR_SPACE)||
/*N*/                     !bVerticalWriting && (SID_ATTR_TABSTOP_VERTICAL == nWhich)||
/*N*/                     bVerticalWriting && (RES_PARATR_TABSTOP == nWhich)
/*N*/                  )
/*N*/                 rSet.DisableItem( nWhich );
/*N*/ 			else
/*N*/ 			{	SvxTabStopItem aTabStops((const SvxTabStopItem&)
/*?*/ 											aCoreSet.Get( RES_PARATR_TABSTOP ));
/*?*/ 
/*?*/ 				const SvxTabStopItem& rDefTabs = (const SvxTabStopItem&)
/*?*/ 											rSh.GetDefault(RES_PARATR_TABSTOP);
/*?*/ 
/*?*/                 DBG_ASSERT(pHRuler, "warum ist das Lineal nicht da?")
/*?*/ 				long nDefTabDist = ::binfilter::GetTabDist(rDefTabs);
/*?*/                 pHRuler->SetDefTabDist( nDefTabDist );
/*?*/                 pVRuler->SetDefTabDist( nDefTabDist );
/*?*/ 				::binfilter::lcl_EraseDefTabs(aTabStops);
/*?*/ 				DEBUGTABSTOPS(aTabStops);
/*?*/                 rSet.Put(aTabStops, nWhich);
/*N*/ 			}
/*N*/ 			break;
/*N*/ 		}
/*N*/         case SID_ATTR_PARA_LRSPACE_VERTICAL:
/*N*/         case SID_ATTR_PARA_LRSPACE:
/*N*/ 		{
/*N*/ 			if ( nSelectionType & SwWrtShell::SEL_GRF ||
/*N*/ 					nSelectionType & SwWrtShell::SEL_FRM ||
/*N*/ 					nSelectionType & SwWrtShell::SEL_OLE ||
/*N*/                     nFrmType == FRMTYPE_DRAWOBJ ||
/*N*/                     !bVerticalWriting && (SID_ATTR_PARA_LRSPACE_VERTICAL == nWhich)||
/*N*/                     bVerticalWriting && (SID_ATTR_PARA_LRSPACE == nWhich)
/*N*/                     )
/*N*/             {
/*N*/                 rSet.DisableItem(nWhich);
/*N*/             }
/*N*/ 			else
/*N*/ 			{
/*?*/ 				SvxLRSpaceItem aLR;
/*?*/ 				if ( !IsTabColFromDoc() )
/*?*/ 					aLR = (const SvxLRSpaceItem&)aCoreSet.Get(RES_LR_SPACE);
/*?*/ 				DEBUGPARAMARGIN(aLR);
/*?*/ 				aLR.SetWhich(nWhich);
/*?*/ 				rSet.Put(aLR);
/*N*/ 			}
/*N*/         break;
/*N*/ 		}
/*N*/         case SID_RULER_BORDER_DISTANCE:
/*N*/         {
/*N*/             if ( nSelectionType & SwWrtShell::SEL_GRF ||
/*N*/ 					nSelectionType & SwWrtShell::SEL_FRM ||
/*N*/ 					nSelectionType & SwWrtShell::SEL_OLE ||
/*N*/ 					nFrmType == FRMTYPE_DRAWOBJ )
/*N*/                 rSet.DisableItem(SID_RULER_BORDER_DISTANCE);
/*N*/ 			else
/*N*/ 			{
/*N*/                 SvxLRSpaceItem aDistLR(SID_RULER_BORDER_DISTANCE);
/*N*/                 if(nFrmType & FRMTYPE_FLY_ANY)
/*N*/ 				{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ //                    USHORT nLDist, nRDist;
//STRIP001 /*?*/ 					if( IsTabColFromDoc() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						const SwRect& rPrtRect = rSh.GetAnyCurRect(
//STRIP001 /*?*/ 										RECT_FLY_PRT_EMBEDDED, pPt );
//STRIP001 /*?*/                         aDistLR.SetLeft(rPrtRect.Left());
//STRIP001 /*?*/                         aDistLR.SetRight(rPrtRect.Left());
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SfxItemSet aCoreSet( GetPool(),
//STRIP001 /*?*/ 												RES_BOX, RES_BOX,
//STRIP001 /*?*/ 												SID_ATTR_BORDER_INNER, SID_ATTR_BORDER_INNER, 0 );
//STRIP001 /*?*/ 						SvxBoxInfoItem aBoxInfo;
//STRIP001 /*?*/ 						aCoreSet.Put( aBoxInfo );
//STRIP001 /*?*/ 						rSh.GetFlyFrmAttr( aCoreSet );
//STRIP001 /*?*/ 						const SvxBoxItem& rBox = (const SvxBoxItem&)aCoreSet.Get(RES_BOX);
//STRIP001 /*?*/                         aDistLR.SetLeft((USHORT)rBox.GetDistance(BOX_LINE_LEFT ));
//STRIP001 /*?*/                         aDistLR.SetRight((USHORT)rBox.GetDistance(BOX_LINE_RIGHT));
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/                     rSet.Put(aDistLR);
/*N*/                 }
/*N*/                 else if ( IsTabColFromDoc() ||
/*N*/ 					( rSh.GetTableFmt() && !bFrmSelection &&
/*N*/ 					!(nFrmType & FRMTYPE_COLSECT ) ) )
/*N*/                 {
/*?*/                     SfxItemSet aCoreSet( GetPool(),
/*?*/                                             RES_BOX, RES_BOX,
/*?*/                                             SID_ATTR_BORDER_INNER, SID_ATTR_BORDER_INNER, 0 );
/*?*/                     SvxBoxInfoItem aBoxInfo;
/*?*/                     aCoreSet.Put( aBoxInfo );
/*?*/                     aBoxInfo.SetTable(FALSE);
/*?*/                     aBoxInfo.SetDist((BOOL) TRUE);
/*?*/                     aCoreSet.Put(aBoxInfo);
/*?*/                     rSh.GetTabBorders( aCoreSet );
/*?*/                     const SvxBoxItem& rBox = (const SvxBoxItem&)aCoreSet.Get(RES_BOX);
/*?*/                     SvxLRSpaceItem aDistLR(SID_RULER_BORDER_DISTANCE);
/*?*/                     aDistLR.SetLeft((USHORT)rBox.GetDistance(BOX_LINE_LEFT ));
/*?*/                     aDistLR.SetRight((USHORT)rBox.GetDistance(BOX_LINE_RIGHT));
/*?*/                     rSet.Put(aDistLR);
/*N*/                 }
/*N*/             }
/*N*/         }
/*N*/         break;
/*N*/         case SID_RULER_TEXT_RIGHT_TO_LEFT:
/*N*/         {
/*N*/             if ( nSelectionType & SwWrtShell::SEL_GRF ||
/*N*/ 					nSelectionType & SwWrtShell::SEL_FRM ||
/*N*/ 					nSelectionType & SwWrtShell::SEL_OLE ||
/*N*/                     nFrmType == FRMTYPE_DRAWOBJ)
/*N*/                 rSet.DisableItem(nWhich);
/*N*/             else
/*N*/             {
/*N*/                 BOOL bFlag = rSh.IsInRightToLeftText();
/*N*/                 rSet.Put(SfxBoolItem(nWhich, bFlag));
/*N*/             }
/*N*/         }
/*N*/         break;
/*N*/         case SID_RULER_BORDERS_VERTICAL:
/*N*/         case SID_RULER_BORDERS:
/*N*/ 		{
/*N*/             BOOL bFrameRTL;
/*N*/             BOOL bFrameHasVerticalColumns =  rSh.IsFrmVertical(FALSE, bFrameRTL) && bFrmSelection;
/*N*/ 
/*N*/             if((SID_RULER_BORDERS_VERTICAL == nWhich) &&
/*N*/                     ((!bVerticalWriting && !bFrmSelection) || (bFrmSelection && !bFrameHasVerticalColumns)) ||
/*N*/                 ((SID_RULER_BORDERS == nWhich) &&
/*N*/                     ((bVerticalWriting && !bFrmSelection) || bFrameHasVerticalColumns)))
/*N*/                 rSet.DisableItem(nWhich);
/*N*/             else if ( IsTabColFromDoc() ||
/*N*/ 					( rSh.GetTableFmt() && !bFrmSelection &&
/*N*/ 					!(nFrmType & FRMTYPE_COLSECT ) ) )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				SwTabCols aTabCols;
//STRIP001 /*?*/ 				USHORT	  nNum;
//STRIP001 /*?*/ 				if ( 0 != ( bSetTabColFromDoc = IsTabColFromDoc() ) )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					rSh.GetMouseTabCols( aTabCols, aTabColFromDocPos );
//STRIP001 /*?*/ 					nNum = rSh.GetCurMouseTabColNum( aTabColFromDocPos );
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					rSh.GetTabCols( aTabCols );
//STRIP001 /*?*/ 					nNum = rSh.GetCurTabColNum();
//STRIP001 /*?*/                     if(rSh.IsTableRightToLeft())
//STRIP001 /*?*/                         nNum = aTabCols.Count() - nNum;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				ASSERT(nNum <= aTabCols.Count(), "TabCol not found");
//STRIP001 /*?*/ 				int nLft = aTabCols.GetLeftMin() -
//STRIP001 /*?*/ 								  USHORT(DOCUMENTBORDER) +
//STRIP001 /*?*/ 								  aTabCols.GetLeft();
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 int nRgt = (USHORT)(bVerticalWriting ? nPageHeight : nPageWidth) -
//STRIP001 /*?*/ 								  (aTabCols.GetLeftMin() +
//STRIP001 /*?*/ 								  aTabCols.GetRight() -
//STRIP001 /*?*/ 								  USHORT(DOCUMENTBORDER) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				const USHORT nL = nLft > 0 ? nLft : 0;
//STRIP001 /*?*/ 				const USHORT nR = nRgt > 0 ? nRgt : 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				SvxColumnItem aColItem(nNum, nL, nR);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				USHORT nStart = 0,
//STRIP001 /*?*/ 					   nEnd;
//STRIP001 /*?*/ 
//STRIP001 /*?*/                 //columns in right-to-left tables need to be mirrored
//STRIP001 /*?*/                 BOOL bIsTableRTL =
//STRIP001 /*?*/                     IsTabColFromDoc() ?
//STRIP001 /*?*/                           rSh.IsMouseTableRightToLeft(aTabColFromDocPos)
//STRIP001 /*?*/                         : rSh.IsTableRightToLeft();
//STRIP001 /*?*/                 if(bIsTableRTL)
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     for ( USHORT i = aTabCols.Count(); i ; --i )
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         nEnd  = aTabCols.GetRight();
//STRIP001 /*?*/ 						nEnd  -=  aTabCols[i-1];
//STRIP001 /*?*/                         SvxColumnDescription aColDesc( nStart, nEnd,
//STRIP001 /*?*/                                                     !aTabCols.IsHidden(i - 1) );
//STRIP001 /*?*/                         aColItem.Append(aColDesc);
//STRIP001 /*?*/                         nStart = nEnd;
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                     SvxColumnDescription aColDesc(nStart,
//STRIP001 /*?*/                                     aTabCols.GetRight() - aTabCols.GetLeft(), TRUE);
//STRIP001 /*?*/                     aColItem.Append(aColDesc);
//STRIP001 /*?*/                 }
//STRIP001 /*?*/                 else
//STRIP001 /*?*/                 {
//STRIP001 /*?*/                     for ( USHORT i = 0; i < aTabCols.Count(); ++i )
//STRIP001 /*?*/                     {
//STRIP001 /*?*/                         nEnd  = aTabCols[i] - aTabCols.GetLeft();
//STRIP001 /*?*/                         SvxColumnDescription aColDesc( nStart, nEnd,
//STRIP001 /*?*/                                                     !aTabCols.IsHidden(i) );
//STRIP001 /*?*/                         aColItem.Append(aColDesc);
//STRIP001 /*?*/                         nStart = nEnd;
//STRIP001 /*?*/                     }
//STRIP001 /*?*/                     SvxColumnDescription aColDesc(nStart,
//STRIP001 /*?*/                                     aTabCols.GetRight() - aTabCols.GetLeft(), TRUE);
//STRIP001 /*?*/                     aColItem.Append(aColDesc);
//STRIP001 /*?*/                 }
//STRIP001 /*?*/ 				rSet.Put(aColItem, nWhich);
//STRIP001 /*?*/ 				DEBUGCOLITEMS(aColItem);
/*N*/ 			}
/*N*/ 			else if ( bFrmSelection || nFrmType & ( FRMTYPE_COLUMN | FRMTYPE_COLSECT ) )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				// Aus Rahmen oder Seite ?
//STRIP001 /*?*/ 				USHORT nNum = 0;
//STRIP001 /*?*/ 				if(bFrmSelection)
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					const SwFrmFmt* pFmt = rSh.GetFlyFrmFmt();
//STRIP001 /*?*/ 					if(pFmt)
//STRIP001 /*?*/ 						nNum = pFmt->GetCol().GetNumCols();
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 					nNum = rSh.GetCurColNum();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				if(
//STRIP001 /*?*/ 					//eigentlich sollte FRMTYPE_COLSECT nicht enthalten sein, wenn der Rahmen selektiert ist!
//STRIP001 /*?*/ 					!bFrmSelection &&
//STRIP001 /*?*/  					nFrmType & FRMTYPE_COLSECT )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					const SwSection *pSect = rSh.GetAnySection(FALSE, pPt);
//STRIP001 /*?*/ 					ASSERT( pSect, "Welcher Bereich?");
//STRIP001 /*?*/ 					if( pSect )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SwSectionFmt *pFmt = pSect->GetFmt();
//STRIP001 /*?*/ 						const SwFmtCol& rCol = pFmt->GetCol();
//STRIP001 /*?*/ 						if(rSh.IsInRightToLeftText())
//STRIP001 /*?*/ 							nNum = rCol.GetColumns().Count() - nNum;
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 							--nNum;
//STRIP001 /*?*/ 						SvxColumnItem aColItem(nNum);
//STRIP001 /*?*/ 						SwRect aRect = rSh.GetAnyCurRect(RECT_SECTION_PRT, pPt);
//STRIP001 /*?*/                         const SwRect aTmpRect = rSh.GetAnyCurRect(RECT_SECTION, pPt);
//STRIP001 /*?*/                         aRect.Pos() += aTmpRect.Pos();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						::lcl_FillSvxColumn(rCol, USHORT(bVerticalWriting ? aRect.Height() : aRect.Width()), aColItem, 0);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						if(bVerticalWriting)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							aColItem.SetLeft ((USHORT)(aRect.Top() - DOCUMENTBORDER ));
//STRIP001 /*?*/ 							aColItem.SetRight((USHORT)(nPageHeight	- aRect.Bottom() +
//STRIP001 /*?*/ 																		DOCUMENTBORDER ));
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							aColItem.SetLeft ((USHORT)(aRect.Left() - DOCUMENTBORDER ));
//STRIP001 /*?*/                             aColItem.SetRight((USHORT)(nPageWidth   - aRect.Right() +
//STRIP001 /*?*/ 																		DOCUMENTBORDER ));
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						aColItem.SetOrtho(aColItem.CalcOrtho());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						rSet.Put(aColItem, nWhich);
//STRIP001 /*?*/ 						DEBUGCOLITEMS(aColItem);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else if( bFrmSelection || nFrmType & FRMTYPE_FLY_ANY )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					// Spalten in Rahmen
//STRIP001 /*?*/ 					if ( nNum  )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						const SwFrmFmt* pFmt = rSh.GetFlyFrmFmt() ;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						const SwFmtCol& rCol = pFmt->GetCol();
//STRIP001 /*?*/ 						if(rSh.IsInRightToLeftText())
//STRIP001 /*?*/ 							nNum = rCol.GetColumns().Count() - nNum;
//STRIP001 /*?*/ 						else 
//STRIP001 /*?*/ 							nNum--;
//STRIP001 /*?*/ 						SvxColumnItem aColItem(nNum);
//STRIP001 /*?*/ 						const SwRect &rSizeRect = rSh.GetAnyCurRect(RECT_FLY_PRT_EMBEDDED, pPt);
//STRIP001 /*?*/ 
//STRIP001 /*?*/                         BOOL bUseVertical = bFrameHasVerticalColumns || (!bFrmSelection && bVerticalWriting);
//STRIP001 /*?*/                         const long lWidth = bUseVertical ? rSizeRect.Height() : rSizeRect.Width();
//STRIP001 /*?*/ 						const SwRect &rRect = rSh.GetAnyCurRect(RECT_FLY_EMBEDDED, pPt);
//STRIP001 /*?*/                         long nDist2 = ((bUseVertical ? rRect.Height() : rRect.Width()) - lWidth) /2;
//STRIP001 /*?*/ 						::lcl_FillSvxColumn(rCol, USHORT(lWidth), aColItem, nDist2);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						SfxItemSet aFrameSet(GetPool(), RES_LR_SPACE, RES_LR_SPACE);
//STRIP001 /*?*/ 						rSh.GetFlyFrmAttr( aFrameSet );
//STRIP001 /*?*/ 
//STRIP001 /*?*/                         if(bUseVertical)
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							aColItem.SetLeft ((USHORT)(rRect.Top() - DOCUMENTBORDER ));
//STRIP001 /*?*/ 							aColItem.SetRight((USHORT)(nPageHeight	- rRect.Bottom() +
//STRIP001 /*?*/                                                                         DOCUMENTBORDER ));
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 						else
//STRIP001 /*?*/ 						{
//STRIP001 /*?*/ 							aColItem.SetLeft ((USHORT)(rRect.Left() - DOCUMENTBORDER ));
//STRIP001 /*?*/ 							aColItem.SetRight((USHORT)(nPageWidth	- rRect.Right() -
//STRIP001 /*?*/ 																	DOCUMENTBORDER ));
//STRIP001 /*?*/ 						}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						aColItem.SetOrtho(aColItem.CalcOrtho());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 						rSet.Put(aColItem, nWhich);
//STRIP001 /*?*/ 						DEBUGCOLITEMS(aColItem);
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/                         rSet.DisableItem(nWhich);
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{	// Spalten auf der Seite
//STRIP001 /*?*/ 					const SwFrmFmt& rMaster = rDesc.GetMaster();
//STRIP001 /*?*/ 					SwFmtCol aCol(rMaster.GetCol());
//STRIP001 /*?*/ 					if(rFrameDir.GetValue() == FRMDIR_HORI_RIGHT_TOP)
//STRIP001 /*?*/ 						nNum = aCol.GetColumns().Count() - nNum;
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						nNum--;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					SvxColumnItem aColItem(nNum);
//STRIP001 /*?*/                     const SwRect aPrtRect = rSh.GetAnyCurRect(RECT_PAGE_PRT, pPt);
//STRIP001 /*?*/ 					const SvxBoxItem& rBox = (const SvxBoxItem&)rMaster.GetAttr(RES_BOX);
//STRIP001 /*?*/ 					long nDist = rBox.GetDistance();
//STRIP001 /*?*/                     ::lcl_FillSvxColumn(aCol,
//STRIP001 /*?*/                         USHORT(bVerticalWriting ? aPrtRect.Height() : aPrtRect.Width() ),
//STRIP001 /*?*/                         aColItem, nDist);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if(bBrowse)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aColItem.SetLeft((USHORT)rPagePrtRect.Left());
//STRIP001 /*?*/ 						aColItem.SetRight(USHORT(nPageWidth - rPagePrtRect.Right()));
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aColItem.SetLeft (aPageLRSpace.GetLeft());
//STRIP001 /*?*/ 						aColItem.SetRight(aPageLRSpace.GetRight());
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					aColItem.SetOrtho(aColItem.CalcOrtho());
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					rSet.Put(aColItem, nWhich);
//STRIP001 /*?*/ 					DEBUGCOLITEMS(aColItem);
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 			else
/*?*/                 rSet.DisableItem(nWhich);
/*?*/ 			break;
/*?*/ 		}
/*N*/ 		case SID_RULER_PAGE_POS:
/*N*/ 		{
/*?*/ 			SvxPagePosSizeItem aPagePosSize(
/*?*/ 					Point( DOCUMENTBORDER , rPageRect.Top()) ,
/*?*/ 					nPageWidth, nPageHeight);
/*?*/ 			rSet.Put(aPagePosSize);
/*?*/ 			break;
/*N*/ 		}
/*N*/ 		case SID_RULER_LR_MIN_MAX:
/*N*/ 		{
/*N*/ 			Rectangle aRectangle;
/*N*/ 			if( ( nFrmType & FRMTYPE_COLSECT ) && !IsTabColFromDoc() &&
/*N*/ 				( nFrmType & ( FRMTYPE_TABLE|FRMTYPE_COLUMN ) ) )
/*N*/ 			{DBG_BF_ASSERT(0, "STRIP"); //STRIP001 
//STRIP001 /*?*/ 				if( nFrmType & FRMTYPE_TABLE )
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					const USHORT nNum = rSh.GetCurTabColNum();
//STRIP001 /*?*/ 					SwTabCols aTabCols;
//STRIP001 /*?*/ 					rSh.GetTabCols( aTabCols );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					int nLft = aTabCols.GetLeftMin() -
//STRIP001 /*?*/ 									USHORT(DOCUMENTBORDER) +
//STRIP001 /*?*/ 									aTabCols.GetLeft();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					int nRgt = (USHORT)nPageWidth -
//STRIP001 /*?*/ 									(aTabCols.GetLeftMin() +
//STRIP001 /*?*/ 									aTabCols.GetRight() -
//STRIP001 /*?*/ 									USHORT(DOCUMENTBORDER) );
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					const USHORT nL = nLft > 0 ? nLft : 0;
//STRIP001 /*?*/ 					const USHORT nR = nRgt > 0 ? nRgt : 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					aRectangle.Left() = nL;
//STRIP001 /*?*/ 					if(nNum > 1)
//STRIP001 /*?*/ 						aRectangle.Left() += aTabCols[nNum - 2];
//STRIP001 /*?*/ 					if(nNum)
//STRIP001 /*?*/ 						aRectangle.Left() += MINLAY;
//STRIP001 /*?*/ 					if(aTabCols.Count() <= nNum + 1 )
//STRIP001 /*?*/ 						aRectangle.Right() = nR;
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						aRectangle.Right() = nPageWidth - (nL + aTabCols[nNum + 1]);
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if(nNum < aTabCols.Count())
//STRIP001 /*?*/ 						aRectangle.Right() += MINLAY;
//STRIP001 /*?*/ 				}
//STRIP001 /*?*/ 				else
//STRIP001 /*?*/ 				{
//STRIP001 /*?*/ 					const SwFrmFmt* pFmt =  rSh.GetFlyFrmFmt();
//STRIP001 /*?*/ 					const SwFmtCol* pCols = pFmt ? &pFmt->GetCol():
//STRIP001 /*?*/ 												   &rDesc.GetMaster().GetCol();
//STRIP001 /*?*/ 					const SwColumns& rCols = pCols->GetColumns();
//STRIP001 /*?*/ 					USHORT nNum = rSh.GetCurOutColNum();
//STRIP001 /*?*/ 					USHORT nCount = Min(USHORT(nNum + 1), rCols.Count());
//STRIP001 /*?*/ 					const SwRect aRect( rSh.GetAnyCurRect( pFmt
//STRIP001 /*?*/ 													? RECT_FLY_PRT_EMBEDDED
//STRIP001 /*?*/ 													: RECT_PAGE_PRT, pPt ));
//STRIP001 /*?*/ 					const SwRect aAbsRect( rSh.GetAnyCurRect( pFmt
//STRIP001 /*?*/ 													? RECT_FLY_EMBEDDED
//STRIP001 /*?*/ 													: RECT_PAGE, pPt ));
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					//die Breite im Rahmen bzw. innerhalbe der Seitenraender
//STRIP001 /*?*/ 					const USHORT nTotalWidth = (USHORT)aRect.Width();
//STRIP001 /*?*/ 					//die gesamte Rahmenbreite - die Differenz ist der doppelte Abstand zum Rand
//STRIP001 /*?*/ 					const USHORT nOuterWidth = (USHORT)aAbsRect.Width();
//STRIP001 /*?*/ 					int nWidth = 0,
//STRIP001 /*?*/ 						nStart = 0,
//STRIP001 /*?*/ 						nEnd = 0;
//STRIP001 /*?*/ 					aRectangle.Left() = 0;
//STRIP001 /*?*/ 					for ( int i = 0; i < nCount; ++i )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SwColumn* pCol = rCols[i];
//STRIP001 /*?*/ 						nStart = pCol->GetLeft() + nWidth;
//STRIP001 /*?*/ 						if(i == nNum - 2)
//STRIP001 /*?*/ 							aRectangle.Left() = nStart;
//STRIP001 /*?*/ 						nWidth += pCols->CalcColWidth( i, nTotalWidth );
//STRIP001 /*?*/ 						nEnd = nWidth - pCol->GetRight();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					aRectangle.Right() = nPageWidth - nEnd;
//STRIP001 /*?*/ 					aRectangle.Left() -= DOCUMENTBORDER;
//STRIP001 /*?*/ 					aRectangle.Right() += DOCUMENTBORDER;
//STRIP001 /*?*/ 					if(nNum > 1)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aRectangle.Left() += MINLAY;
//STRIP001 /*?*/ 						aRectangle.Left() += aRect.Left();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					if(pFmt) //Bereich in Rahmen - hier darf man bis zum Rand
//STRIP001 /*?*/ 						aRectangle.Left()  = aRectangle.Right() = 0;
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						// das Rechteck an die richtige absolute Position verschieben
//STRIP001 /*?*/ 						aRectangle.Left() += aAbsRect.Left();
//STRIP001 /*?*/ 						aRectangle.Right() -= aAbsRect.Left();
//STRIP001 /*?*/ 						// Abstand zur Umrandung mit einbeziehen
//STRIP001 /*?*/ 						aRectangle.Right() -= (nOuterWidth - nTotalWidth) / 2;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if(nNum < rCols.Count())
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aRectangle.Right() += MINLAY;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 						// rechts ist jetzt nur noch der Seitenrand
//STRIP001 /*?*/ 						aRectangle.Right() = 0;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 				}
/*N*/ 			}
/*N*/ 			else if ( ((nFrmType & FRMTYPE_TABLE) || IsTabColFromDoc()) &&
/*N*/ 				 !bFrmSelection )
/*N*/ 			{
/*N*/ 				BOOL bColumn;
/*N*/ 				if ( IsTabColFromDoc() )
/*?*/ 					{DBG_BF_ASSERT(0, "STRIP"); }//STRIP001 bColumn = rSh.GetCurMouseColNum( aTabColFromDocPos ) != 0;
/*N*/ 				else
/*N*/ 					bColumn = (nFrmType & (FRMTYPE_COLUMN|FRMTYPE_FLY_ANY|
/*N*/ 											FRMTYPE_COLSECTOUTTAB)) ?
/*N*/ 											TRUE : FALSE;
/*N*/ 				if ( !bColumn )
/*N*/ 				{
/*N*/ 					if( nFrmType & FRMTYPE_FLY_ANY && IsTabColFromDoc() )
/*N*/ 					{
/*N*/ 						SwRect aRect( rSh.GetAnyCurRect(
/*N*/ 											RECT_FLY_PRT_EMBEDDED, pPt ) );
/*N*/ 						aRect.Pos() += rSh.GetAnyCurRect( RECT_FLY_EMBEDDED,
/*N*/ 																pPt ).Pos();
/*N*/ 
/*N*/ 						aRectangle.Left()  = aRect.Left() - DOCUMENTBORDER;
/*N*/ 						aRectangle.Right() = nPageWidth - ( aRect.Right()
/*N*/ 													 	- DOCUMENTBORDER );
/*N*/ 					}
/*N*/ 					else if( bBrowse )
/*N*/ 					{
/*N*/ 						aRectangle.Left()  = rPagePrtRect.Left();
/*N*/ 						aRectangle.Right() = nPageWidth - rPagePrtRect.Right();
/*N*/ 					}
/*N*/ 					else
/*N*/ 					{
/*N*/ 						aRectangle.Left()  = aPageLRSpace.GetLeft();
/*N*/ 						aRectangle.Right() = aPageLRSpace.GetRight();
/*N*/ 					}
/*N*/ 				}
/*N*/ 				else
/*N*/ 				{	DBG_BF_ASSERT(0, "STRIP"); //STRIP001 //hier nur fuer Tabelle in mehrspaltigen Seiten und Rahmen
//STRIP001 /*?*/ 					BOOL bSectOutTbl = (nFrmType & FRMTYPE_TABLE) ? TRUE : FALSE;
//STRIP001 /*?*/ 					BOOL bFrame = (nFrmType & FRMTYPE_FLY_ANY) ? TRUE : FALSE;
//STRIP001 /*?*/ 					BOOL bColSct = 	(nFrmType & ( bSectOutTbl
//STRIP001 /*?*/ 													? FRMTYPE_COLSECTOUTTAB
//STRIP001 /*?*/ 													: FRMTYPE_COLSECT )
//STRIP001 /*?*/ 												) ? TRUE : FALSE;
//STRIP001 /*?*/ 					//Damit man auch mit der Mouse ziehen kann,
//STRIP001 /*?*/ 					//ohne in der Tabelle zu stehen
//STRIP001 /*?*/ 					CurRectType eRecType = RECT_PAGE_PRT;
//STRIP001 /*?*/ 					int nNum = IsTabColFromDoc() ?
//STRIP001 /*?*/ 								rSh.GetCurMouseColNum( aTabColFromDocPos ):
//STRIP001 /*?*/ 								rSh.GetCurOutColNum();
//STRIP001 /*?*/ 					const SwFrmFmt* pFmt = NULL;
//STRIP001 /*?*/ 					if( bColSct )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						eRecType = bSectOutTbl ? RECT_OUTTABSECTION
//STRIP001 /*?*/ 											   : RECT_SECTION;
//STRIP001 /*?*/ 						const SwSection *pSect = rSh.GetAnySection( bSectOutTbl, pPt );
//STRIP001 /*?*/ 						ASSERT( pSect, "Welcher Bereich?");
//STRIP001 /*?*/ 						pFmt = pSect->GetFmt();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else if( bFrame )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						pFmt = rSh.GetFlyFrmFmt();
//STRIP001 /*?*/ 						eRecType = RECT_FLY_PRT_EMBEDDED;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					const SwFmtCol* pCols = pFmt ? &pFmt->GetCol():
//STRIP001 /*?*/ 												   &rDesc.GetMaster().GetCol();
//STRIP001 /*?*/ 					const SwColumns& rCols = pCols->GetColumns();
//STRIP001 /*?*/ 					const USHORT nBorder = pFmt ? pFmt->GetBox().GetDistance() :
//STRIP001 /*?*/ 												  rDesc.GetMaster().GetBox().GetDistance();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					/* RECT_FLY_PRT_EMBEDDED returns the relative position to
//STRIP001 /*?*/ 						RECT_FLY_EMBEDDED
//STRIP001 /*?*/ 						the absolute position must be added here
//STRIP001 /*?*/ 					*/
//STRIP001 /*?*/ 					SwRect aRect( rSh.GetAnyCurRect( eRecType, pPt ) );
//STRIP001 /*?*/ 					if(RECT_FLY_PRT_EMBEDDED == eRecType)
//STRIP001 /*?*/ 						aRect.Pos() += rSh.GetAnyCurRect( RECT_FLY_EMBEDDED,
//STRIP001 /*?*/ 																pPt ).Pos();
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					const USHORT nTotalWidth = (USHORT)aRect.Width();
//STRIP001 /*?*/ 					//nStart und nEnd initialisieren fuer nNum == 0
//STRIP001 /*?*/ 					int nWidth = 0,
//STRIP001 /*?*/ 						nStart = 0,
//STRIP001 /*?*/ 						nEnd = nTotalWidth;
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					if( nNum > rCols.Count() )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						ASSERT( !this, "es wird auf dem falschen FmtCol gearbeitet!" );
//STRIP001 /*?*/ 						nNum = rCols.Count();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 
//STRIP001 /*?*/ 					for( int i = 0; i < nNum; ++i )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						SwColumn* pCol = rCols[i];
//STRIP001 /*?*/ 						nStart = pCol->GetLeft() + nWidth;
//STRIP001 /*?*/ 						nWidth += pCols->CalcColWidth( i, nTotalWidth );
//STRIP001 /*?*/ 						nEnd = nWidth - pCol->GetRight();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					if( bFrame | bColSct )
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aRectangle.Left()  = aRect.Left()
//STRIP001 /*?*/ 												- DOCUMENTBORDER + nStart;
//STRIP001 /*?*/ 						aRectangle.Right() = nPageWidth
//STRIP001 /*?*/ 												- aRectangle.Left()
//STRIP001 /*?*/ 													- nEnd + nStart;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else if(!bBrowse)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aRectangle.Left()  = aPageLRSpace.GetLeft() + nStart;
//STRIP001 /*?*/ 						aRectangle.Right() = nPageWidth - nEnd - aPageLRSpace.GetLeft();
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					else
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						long nLeft = rPagePrtRect.Left();
//STRIP001 /*?*/ 						aRectangle.Left()  = nStart + nLeft;
//STRIP001 /*?*/ 						aRectangle.Right() = nPageWidth - nEnd - nLeft;
//STRIP001 /*?*/ 					}
//STRIP001 /*?*/ 					if(!bFrame)
//STRIP001 /*?*/ 					{
//STRIP001 /*?*/ 						aRectangle.Left() += nBorder;
//STRIP001 /*?*/ 						aRectangle.Right() -= nBorder;
//STRIP001 /*?*/ 					}
/*N*/ 				}
/*N*/ 			}
/*N*/ 			else if ( nFrmType & ( FRMTYPE_HEADER  | FRMTYPE_FOOTER ))
/*N*/ 			{
/*N*/ 				aRectangle.Left()  = aPageLRSpace.GetLeft();
/*N*/ 				aRectangle.Right() = aPageLRSpace.GetRight();
/*N*/ 			}
/*N*/ 			else
/*N*/ 				aRectangle.Left()  = aRectangle.Right() = 0;
/*N*/ 
/*N*/ 			SfxRectangleItem aLR( SID_RULER_LR_MIN_MAX , aRectangle);
/*N*/ 			rSet.Put(aLR);
/*N*/ 		}
/*N*/ 		break;
/*N*/ 		case SID_RULER_PROTECT:
/*N*/ 		{
/*N*/ 			if(bFrmSelection)
/*N*/ 			{
/*?*/ 				BYTE nProtect = pWrtShell->IsSelObjProtected((FlyProtectType)(FLYPROTECT_SIZE|FLYPROTECT_POS|FLYPROTECT_CONTENT));
/*?*/ 
/*?*/ 				SvxProtectItem aProt(SID_RULER_PROTECT);
/*?*/ 				aProt.SetCntntProtect((nProtect & FLYPROTECT_CONTENT)	!= 0);
/*?*/ 				aProt.SetSizeProtect ((nProtect & FLYPROTECT_SIZE)		!= 0);
/*?*/ 				aProt.SetPosProtect  ((nProtect & FLYPROTECT_POS)		!= 0);
/*?*/ 				rSet.Put(aProt);
/*N*/ 			}
/*N*/ 			else
/*N*/ 			{
/*N*/ 				SvxProtectItem aProtect(SID_RULER_PROTECT);
/*N*/ 				if(bBrowse && !(nFrmType & (FRMTYPE_DRAWOBJ|FRMTYPE_COLUMN)) && !rSh.GetTableFmt())
/*N*/ 				{
/*N*/ 					aProtect.SetSizeProtect(TRUE);
/*N*/ 					aProtect.SetPosProtect(TRUE);
/*N*/ 				}
/*N*/ 				rSet.Put(aProtect);
/*N*/ 			}
/*N*/ 		}
/*N*/ 		break;
/*N*/ 		}
/*N*/ 		nWhich = aIter.NextWhich();
/*N*/ 	}
/*N*/ }


}
