/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: controlpropertyhdl.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:04:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _XMLOFF_FORMS_CONTROLPROPERTYHDL_HXX_
#define _XMLOFF_FORMS_CONTROLPROPERTYHDL_HXX_

#ifndef _XMLOFF_PROPERTYHANDLERFACTORY_HXX
#include "prhdlfac.hxx"
#endif
#ifndef _VOS_REF_HXX_
#include <vos/ref.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _XMLOFF_XMLEXPPR_HXX
#include "xmlexppr.hxx"
#endif
#ifndef _XMLOFF_CONTROLBORDERHDL_HXX_
#include "ControlBorderHandler.hxx"
#endif
namespace binfilter {

struct SvXMLEnumMapEntry;
class XMLConstantsPropertyHandler;
//.........................................................................
namespace xmloff
{
//.........................................................................

	class IFormsExportContext;
	class IFormsImportContext;

	//=====================================================================
	//= ORotationAngleHandler
	//=====================================================================
	class ORotationAngleHandler : public XMLPropertyHandler
	{
	public:
		ORotationAngleHandler();

		virtual sal_Bool importXML( const ::rtl::OUString& _rStrImpValue, ::com::sun::star::uno::Any& _rValue, const SvXMLUnitConverter& _rUnitConverter ) const;
		virtual sal_Bool exportXML( ::rtl::OUString& _rStrExpValue, const ::com::sun::star::uno::Any& _rValue, const SvXMLUnitConverter& _rUnitConverter ) const;
	};

	//=====================================================================
	//= OFontWidthHandler
	//=====================================================================
	class OFontWidthHandler : public XMLPropertyHandler
	{
	public:
		OFontWidthHandler();

		virtual sal_Bool importXML( const ::rtl::OUString& _rStrImpValue, ::com::sun::star::uno::Any& _rValue, const SvXMLUnitConverter& _rUnitConverter ) const;
		virtual sal_Bool exportXML( ::rtl::OUString& _rStrExpValue, const ::com::sun::star::uno::Any& _rValue, const SvXMLUnitConverter& _rUnitConverter ) const;
	};

	//=====================================================================
	//= OControlPropertyHandlerFactory
	//=====================================================================
	class OControlPropertyHandlerFactory : public XMLPropertyHandlerFactory
	{
	protected:
		mutable XMLConstantsPropertyHandler*	m_pTextAlignHandler;
		mutable OControlBorderHandler*			m_pControlBorderHandler;
		mutable ORotationAngleHandler*			m_pRotationAngleHandler;
		mutable OFontWidthHandler*				m_pFontWidthHandler;
		mutable XMLConstantsPropertyHandler*	m_pFontEmphasisHandler;
		mutable XMLConstantsPropertyHandler*	m_pFontReliefHandler;

	public:
		OControlPropertyHandlerFactory();
		virtual ~OControlPropertyHandlerFactory();

		virtual const XMLPropertyHandler* GetPropertyHandler(sal_Int32 _nType) const;
	};

//.........................................................................
}	// namespace xmloff
//.........................................................................

}//end of namespace binfilter
#endif // _XMLOFF_FORMS_CONTROLPROPERTYHDL_HXX_

/*************************************************************************
 * history:
 *	$Log: controlpropertyhdl.hxx,v $
 *	Revision 1.2  2005/09/09 09:04:09  rt
 *	INTEGRATION: CWS ooo19126 (1.1.158); FILE MERGED
 *	2005/09/05 11:30:07 rt 1.1.158.1: #i54170# Change license header: remove SISSL
 *	
 *	Revision 1.1.158.1  2005/09/05 11:30:07  rt
 *	#i54170# Change license header: remove SISSL
 *	
 *	Revision 1.1  2003/12/05 09:34:01  aw
 *	Added bf_xmloff files
 *	
 *	Revision 1.6  2001/06/07 12:27:21  fs
 *	#86096# handler for FontEmphasis/FontRelief / substituted OEnumInt16Handler by XMLConstantsPropertyHandler
 *	
 *	Revision 1.5  2001/05/28 15:03:48  fs
 *	#86712# hold the handler as pointer, not as member instance
 *	
 *	Revision 1.4  2001/04/19 12:05:35  cl
 *	#85097# moved control properties to shape styles
 *	
 *	Revision 1.3  2000/12/19 12:13:57  fs
 *	some changes ... now the exported styles are XSL conform
 *	
 *	Revision 1.2  2000/12/19 08:43:00  fs
 *	no handling for the font with anymore - stored as measure
 *	
 *	Revision 1.1  2000/12/18 15:16:04  fs
 *	initial checkin - property handlers / property handler factory
 *	
 *
 *	Revision 1.0 14.12.00 10:50:10  fs
 ************************************************************************/

