/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: sbadbit.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 10:52:57 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SBA_SBADBIT_HXX
#define _SBA_SBADBIT_HXX

#ifndef _SDB_SDBCOL_HXX //autogen
#include <sdb/sdbcol.hxx>
#endif

#ifndef _SDB_SDBSQLIT_HXX //autogen
#include <sdb/sdbsqlit.hxx>
#endif
namespace binfilter {

extern String QuoteField( const String& rValue, SdbDatabaseType aType );
extern void ReplaceChars( String& rStr, const char nOrg, const char nNew );

//-------------------------------------------------------------------------------------

enum	SbaLogType { SBA_LOG_AND, SBA_LOG_OR, SBA_LOG_INVALID=0xFF };

//-------------------------------------------------------------------------------------


struct SbaPredicateItem
{
	String				aTableRange;
	String				aFieldName;
	SdbPredicateType	eType;
	String				aValue;		// kann Wert aber auch Feldnamen enthalten
	String				aName;		// kann Parameter aber auch Tabellenname enthalten
	SdbDatabaseType		eVarType;
	SbaLogType			eLogType;

	SbaPredicateItem(){}
	SbaPredicateItem(const SbaPredicateItem& rItem)
				:aTableRange(rItem.aTableRange)
				,aFieldName(rItem.aFieldName)
				,eType(rItem.eType)
				,aValue(rItem.aValue)
				,eVarType(rItem.eVarType)
				,eLogType(rItem.eLogType)
				,aName(rItem.aName){}

};

DECLARE_LIST( SbaPredicateItemList, SbaPredicateItem* )//STRIP008 DECLARE_LIST( SbaPredicateItemList, SbaPredicateItem* );
DECLARE_LIST( SbaPredSelectList, SbaPredicateItemList* )//STRIP008 DECLARE_LIST( SbaPredSelectList, SbaPredicateItemList* );

struct SbaOrderItem
{
	String	aTableRange;
	String	aFieldName;
	BOOL	bDirection;

	SbaOrderItem(){}
	SbaOrderItem(const SbaOrderItem& rItem)
				:aTableRange(rItem.aTableRange)
				,aFieldName(rItem.aFieldName)
				,bDirection(rItem.bDirection){}

};

DECLARE_LIST( SbaOrderItemList, SbaOrderItem* )//STRIP008 DECLARE_LIST( SbaOrderItemList, SbaOrderItem* );
//-------------------------------------------------------------------------------------

//==================================================================
// SbaParseIterator
//==================================================================
class SdbDatabase;
class SbaParseIterator: public SdbSqlParseTreeIterator
{
	friend class SbaQueryObj;

	SbaPredicateItemList*	pTempCriteriaList;
	SbaOrderItemList*		pTempOrderList;

	const SdbSqlParseNode	*pWhereTree,*pOrderTree, *pHavingTree, *pGroupByTree;

public:
	enum SQLOptionalPart
	{
		WHERE,
		HAVING,
		ORDER_BY,
		GROUP_BY
	};

protected:
	virtual void SetPredicate(const String & rColumnName,
							  const String & rTableRange,
							  SdbPredicateType ePredicateType,
							  const String & rValue,
							  const String & rName);
	virtual void SetOrderByColumnName(const String & rColumnName, const String & rTableRange, BOOL bAscending);

public:
	SbaParseIterator();
	SbaParseIterator(const SdbSqlParseNode* pRootNode, SdbDatabase* pDb);
	SbaParseIterator(const SdbSqlParseNode* pRootNode, SdbConnection* pConn);
	~SbaParseIterator();

	void  SetParseTree(const SdbSqlParseNode* pRootNode);

	BOOL  IsValid() const {return ParseTree() != 0;};

	String	GetOperator( const SdbPredicateType eType ) const;

	String	BuildColumnPart() const;
	String	BuildTablePart() const;

	String	BuildPart(SQLOptionalPart ePart, BOOL bPrependKeyword = FALSE) const;
	// bPrependKeyword wird das Keyword vorangestellt, vor und hinter dem Keyword steht ein Leerzeichen

	BOOL	HasPart(SQLOptionalPart ePart) const;

	String	BuildWherePart( SbaPredicateItemList& rList );
	String	BuildOrderPart( SbaOrderItemList& rList );

	BOOL	FillCriteriaList(SbaPredicateItemList& rList);
	BOOL	FillOrderList(SbaOrderItemList& rList);

	const SdbColumn*	GetCol(const String & rColumnName) const;

	BOOL	IsSimple() const;
	BOOL	HasFilterOrSort() const;
	String	IdentifierQuotation(const String& rValue) const;

};

// SQL Keywords
extern const String STR_ORDER_BY;
extern const String STR_WHERE;
extern const String STR_GROUP_BY;
extern const String STR_HAVING;
extern const String STR_AND;
extern const String STR_SELECT;
extern const String STR_FROM;

} //namespace binfilter
#endif

