/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: clientsh.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:11:19 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFX_CLIENTSH_HXX
#define _SFX_CLIENTSH_HXX

#ifndef _IPCLIENT_HXX //autogen
#include <so3/ipclient.hxx>
#endif
class INetURLObject;
namespace binfilter {
struct SfxInPlaceClient_Impl;
class SfxViewShell;

//=========================================================================

class SfxInPlaceClient : public SvInPlaceClient
{
	SfxInPlaceClient_Impl*	pImp;
	SfxViewShell*			pViewSh;

public:
						SfxInPlaceClient( SfxViewShell* pViewShell,
										  Window* pDraw );
						SfxInPlaceClient( SfxViewShell* pViewShell,
										  SvInPlaceClient* pParent );
	virtual 			~SfxInPlaceClient();

	virtual void    	Opened( BOOL bOpen );
	virtual void        Embedded( BOOL bEmbedding );
	virtual void		Connected( BOOL bConnect );
	virtual void    	InPlaceActivate( BOOL bActivate );
	virtual void		UIActivate( BOOL );
	virtual void    	RequestObjAreaPixel( const Rectangle & rObjRect );
	virtual void 		MakeViewData();
	virtual void		FreeViewData();
	virtual void		MakeVisible();
	virtual ErrCode		GetContURL( INetURLObject & );

	SfxViewShell*		GetViewShell() const { return pViewSh; }

#if _SOLAR__PRIVATE
	DECL_LINK			(TimerHdl_Impl, Timer*);
#endif
};

SO2_DECL_IMPL_REF(SfxInPlaceClient)

}//end of namespace binfilter
#endif

