/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mnumgr.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:26:42 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SFXMNUMGR_HXX
#define _SFXMNUMGR_HXX

#include <stdarg.h>

#ifndef _MENU_HXX //autogen //wg. MENU_APPEND !!!!
#include <vcl/menu.hxx>
#endif
#ifndef _SV_WINTYPES_HXX
#include <vcl/wintypes.hxx>
#endif
#ifndef _LINK_HXX //autogen
#include <tools/link.hxx>
#endif

#include <tools/stream.hxx>
#include <bf_sfx2/cfgitem.hxx>
#include <bf_sfx2/sfx.hrc>
class SfxPoolItem; 
class ResMgr;
class Menu;
class MenuBar;
class PopupMenu;
class ResId;
class SvVerbList;
class SystemWindow;
class Point;
namespace binfilter {

class SfxMenuCfgItemArr;
class SfxMenuCfgItemArrStack;
class SfxVirtualMenu;
class SfxBindings;
class SfxMenuIter_Impl;
class SfxBindings;
class SfxObjectShell;
class SfxModule;
class SfxViewFrame;

class SfxMenuManager : public SfxConfigItem
{
friend class SfxPopupMenuManager;
friend class SfxMenuBarManager;

	SfxVirtualMenu* 		pMenu;			// das eigentliche Menu
	SfxVirtualMenu* 		pOldMenu;		// only while reconfiguring
	BOOL					bMenuBar;		// Popup oder MenuBar
	SfxMenuIter_Impl*		pIterator;		// Iterator zum Auslesen
	SfxMenuCfgItemArr*		pCfg;
	SfxMenuCfgItemArrStack* pCfgStack;
	SfxBindings*			pBindings;
	ResMgr* 				pResMgr;
	BOOL                    bOLE : 1;
	BOOL					bAddClipboardFuncs : 1;

	void					Construct( SfxVirtualMenu& rMenu );
//STRIP001 	void					ConstructSvMenu ( Menu*, SfxMenuCfgItemArr& );
//STRIP001     static void             ConstructSvMenu ( Menu*, SvStream&, BOOL, BOOL );

    int                     Load( SvStream& rStream );
//STRIP001     BOOL                    Store( SvStream& rStream );

protected:
//STRIP001                             SfxMenuManager( Menu*, SfxBindings& );
                            SfxMenuManager( const ResId&, SfxBindings&, SfxConfigManager*, BOOL );
							~SfxMenuManager();
    USHORT                  GetItemPos( USHORT nId );
public:

//STRIP001     static Menu*            LoadMenu( SvStream& rStream );
//STRIP001     static BOOL             StoreMenu( SvStream& rStream, Menu* pMenu, SfxModule* pMod );
    virtual int             Load( SotStorage& );
    virtual BOOL            Store( SotStorage& );
	virtual void			UseDefault();
    virtual String          GetStreamName() const;

	static void				EraseItemCmds( Menu* ); // Used for 6.0/src641 compatibility
	static void				RestoreMacroIDs( Menu* pMenu );

	DECL_LINK( Select, Menu* );

	SfxVirtualMenu* 		GetMenu() const
							{ return pMenu; }

	SfxBindings&			GetBindings() { return *pBindings; }
	const SfxBindings&		GetBindings() const { return *pBindings; }
	void					SetResMgr(ResMgr* pMgr)  {pResMgr = pMgr; }
    ResMgr*                 GetResMgr() const { return pResMgr; }
	void					SetPopupMenu( USHORT nId, PopupMenu *pMenu );

	// reading out the menu
//STRIP001 	BOOL    FirstItem();         // resets the item iterator, FALSE if none
//STRIP001 	BOOL    NextItem();          // skips to the next item, FALSE if no more
//STRIP001 	BOOL    IsBinding() const;   // TRUE if current item is a binding
//STRIP001 	BOOL    IsSeparator() const; // TRUE if current item is a separator
//STRIP001 	BOOL    IsPopup() const;     // TRUE if current item is a popup
//STRIP001 	USHORT  GetLevel() const;    // returns sub-menu-level
//STRIP001 	USHORT	GetItemId() const;	 // id of binding if IsBinding()
//STRIP001 	String  GetTitle() const;    // text
//STRIP001 	String  GetHelpText() const; // HilfeText
//STRIP001 	String	GetCommand() const;

	// reconfiguring the menu
	void SetForceCtrlCreateMode( BOOL bCreate = TRUE );
//STRIP001 	void Clear();                           // call this before reconfiguring
//STRIP001 	void Reconfigure();                     // call this after reconfiguring
//STRIP001 	void AppendItem(const String &rText, const String &rHelpText, USHORT nId, const String& rCommand );	// append a binding by function-id
//STRIP001 	void AppendSeparator();                 // append a separator
//STRIP001 	void EnterPopup(const String& rTitle,  // append a popup (sub)-menu
//STRIP001 					const String &rHelpText,
//STRIP001 					USHORT nId = 0 );      //      with MDI/Pick etc.
//STRIP001 	void LeavePopup();                      // end a sub-menu
//STRIP001 	void InvalidateKeyCodes();				// called from SfxAcceleratorManager

	static BOOL 	IsPopupFunction( USHORT nId );
//STRIP001 	void            InsertVerbs(const SvVerbList *pVerblist);

#if _SOLAR__PRIVATE
//STRIP001 	void			Construct_Impl( Menu* pMenu, BOOL bWithHelp );
#endif
};

//--------------------------------------------------------------------

class SfxPopupMenuManager : public SfxMenuManager
{
private:
	DECL_LINK( SelectHdl, void * );
	Menu*				pSVMenu;

public:
                        SfxPopupMenuManager( const ResId&, SfxBindings& );
                        SfxPopupMenuManager( PopupMenu*, SfxBindings& );
    static void         ExecutePopup( const ResId&, SfxViewFrame* pViewFrame, const Point& rPoint, Window* pWindow );

	USHORT				Execute( const Point& rPos, Window *pWindow );
    USHORT              Execute( const Point& rPoint, Window* pWindow, va_list pArgs, const SfxPoolItem *pArg1 );
    USHORT              Execute( const Point& rPoint, Window* pWindow, const SfxPoolItem *pArg1 ... );

	void				StartInsert();
	void				EndInsert();
	void				CheckItem( USHORT, BOOL );
	void				RemoveItem( USHORT );
	void 				InsertItem( USHORT, const String&, MenuItemBits,
								USHORT nPos = MENU_APPEND );
	void 				InsertSeparator( USHORT nPos = MENU_APPEND );
	void				RemoveDisabledEntries();
	void				AddClipboardFunctions();
};

//--------------------------------------------------------------------

class SfxMenuBarManager : public SfxMenuManager
{
private:
	struct SfxObjectMenu_Impl
	{
		USHORT					nId;
		ResMgr* 				pResMgr;
		SfxPopupMenuManager*	pPMMgr;
	};

	SfxObjectMenu_Impl			aObjMenus[4];
    SystemWindow*               pWindow;
    BOOL                        bDowning;

public:
//    SfxMenuBarManager( SfxBindings& rBindings, BOOL bPlugin = FALSE );
    SfxMenuBarManager( const ResId&, SfxBindings& rBindings, SfxConfigManager*, BOOL bOLE );
    SfxMenuBarManager( const SfxMenuBarManager& rOther, SfxConfigManager* );
	~SfxMenuBarManager();

	static MenuBar*	LoadMenuBar( SvStream& rStream );
	static BOOL		StoreMenuBar( SvStream& rStream, MenuBar* pMenuBar );

    virtual BOOL        	ReInitialize();
    virtual int             Load( SotStorage& );
    virtual BOOL            Store( SotStorage& );
//    BOOL            Load( SvStream& rStream, BOOL bOLEServer=FALSE );
//    static SvStream* GetDefaultStream( StreamMode );
	void			ResetObjectMenus();
	void			SetObjectMenu( USHORT nPos, const ResId& rResId );
	PopupMenu*		GetObjectMenu( USHORT nPos, USHORT& rConfigId );
	void            UpdateObjectMenus();
	MenuBar*		GetMenuBar() const;
	void			ReconfigureObjectMenus();
    SystemWindow*   GetWindow() const { return pWindow; }
};

}//end of namespace binfilter
#endif // #ifndef _SFXMNUMGR_HXX

