/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: CompactEdgeFormat.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:22:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

public final class CompactEdgeFormat extends VectorFormat {
    private final static int SIZE = 9;
  
    public static byte[] makeVector() {
	return new byte[SIZE];
    }
  
    public static int getSrc(byte[] vector) {
	return integerAt(vector, 0);
    }
  
    public static int getDst(byte[] vector) {
	return integerAt(vector, 5);
    }
  
    public static int getCode(byte[] vector) {
	return vector[4];
    }

    public static void setSrc(byte[] vector, int value) {
	setIntegerAt(vector, 0, value);
    }
    
    public static void setCode(byte[] vector, int value) {
	vector[4] = (byte)value;
    }

    public static void setDst(byte[] vector, int value) {
	setIntegerAt(vector, 5, value);
    }
}
