/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ConceptGraph.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 16:23:05 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
package com.sun.xmlsearch.db;

import com.sun.xmlsearch.util.IndexAccessor;

class ConceptGraph {
  protected static final int CHILD = 0;
  protected BtreeDict _tmap;
  protected VectorBtree _edges;

  protected ConceptGraph() {}

  public ConceptGraph(String dbName) throws Exception {
    Schema schema = new Schema(new IndexAccessor(dbName), false);
    _edges = new VectorBtree(new VectorBtreeParameters(schema, "EDGE"));
    _tmap = new BtreeDict(new BtreeDictParameters(schema, "DICTIONARY"));
  }
  
  public void children(String concept) throws Exception {
    int id = _tmap.fetch(concept);
    if (id != 0) {
      System.out.println(id);
      VectorBtreeIterator iter = _edges.makeIterator();
      byte[] prefix = CompactEdgeFormat.makeVector();
      CompactEdgeFormat.setSrc(prefix, id);
      byte[] vec;
      for (vec = iter.first(prefix, 5); vec != null; vec = iter.next())
	System.out.println(_tmap.fetch(CompactEdgeFormat.getDst(vec)));
    }
    else
      System.out.println(concept + " not found");
  }
  
  public static void main(String[] args) {
    try {
      ConceptGraph cg = new ConceptGraph("/files/resources/lexicon/LIF_ONT");
      cg.children("!N/CHANGE");
      System.out.println("--------------------");
      cg.children("!N/DAMAGE");
      cg.children("!N/DAMAGE");
      cg.children("!N/DAMAGE");
    }
    catch (Exception e) {
      e.printStackTrace();
    }
  }
}
