/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: c_gate.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 17:02:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef ARY_CPP_C_GATE_HXX
#define ARY_CPP_C_GATE_HXX

// USED SERVICES
	// BASE CLASSES
#include <ary/cpp/c_rwgate.hxx>
#include <ary/cpp/c_disply.hxx>
	// COMPONENTS
	// PARAMETERS



namespace ary
{
    namespace loc
    {
        class Gate;
    }
    namespace store
    {
        class Interface;
    }
    class IdGenerator;
    class InstanceList;

namespace cpp
{


class Gate : public RwGate,
             public DisplayGate
{
  public:
	// LIFECYCLE
						Gate(
                            ary::store::Interface &
                                                i_rStorage,
                            IdGenerator &       i_rIds,
                            ary::loc::Gate &    i_rGate_Locations );
						~Gate();

	// OPERATIONS
    const InstanceList &
                        Search_TypeName(
                            const udmstri &     i_sName ) const;     

  private:
    // Interface RwGate:
	virtual Namespace & do_CheckIn_Namespace(
                            const InputContext& i_rContext,
                            const udmstri &     i_sLocalName );
	virtual const Type &
						do_CheckIn_UsedType(
                            const InputContext& i_rContext,
                            DYN UsedType &    	let_drType );

	virtual Class &     do_Store_Class(
                            const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            E_ClassKey          i_eClassKey );
	virtual Enum &      do_Store_Enum(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName );
	virtual Typedef &   do_Store_Typedef(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            Tid                 i_nReferedType );
	virtual Function &  do_Store_Operation(      /// @ATTENTION  This is not enabled for multitasking!
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            Tid                 i_nReturnType,
                            const std::vector<S_Parameter> &
                                                i_rParameters,
                            E_Virtuality        i_eVirtuality,
                            E_ConVol            i_eConVol,
                            FunctionFlags       i_aFlags,
                            bool                i_bThrowExists,
                            const std::vector<Tid> &
                                                i_rExceptions );
	virtual Variable &  do_Store_Variable(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            Tid                 i_nType,
                            VariableFlags       i_aFlags,
                            const udmstri &     i_sArraySize,
                            const udmstri &     i_sInitValue );
	virtual EnumValue & do_Store_EnumValue(
							const InputContext& i_rContext,
							const udmstri &     i_sLocalName,
                            const udmstri &     i_sInitValue );
    virtual void        do_Connect_AllTypes_2_TheirRelated_CodeEntites();
    virtual const DisplayGate &
                        inq_RoGate() const;
    virtual Tid         inq_Tid_Ellipse() const;
	virtual Namespace &	access_GlobalNamespace();
    virtual ary::cpp::RwGate_Defines &
                        access_Defines() const;
    virtual ary::cpp::RwGate_Groups &
                        access_Groups() const;
    virtual ary::loc::RwGate &
                        access_Locations() const;

    // Interface ary::cpp::DisplayGate:
	virtual const CodeEntity &
                        inq_Ref_Ce(
							Cid					i_nId ) const;
	virtual const CodeEntity *
                        inq_Find_Ce(
							Cid					i_nId ) const;
    virtual const OperationSignature *
                        inq_Find_Signature(
                            OSid                i_nSignature ) const;
	virtual const CodeEntity *
                        inq_Search_RelatedCe(
							Tid					i_nType ) const;
    virtual const CodeEntity *
                        inq_Search_CeAbsolute(
                            const QualifiedName &
                                                i_rSearchedName ) const;
    virtual const CodeEntity *
                        inq_Search_CeLocal(
                            const udmstri &     i_sLocalName,
                            bool                i_bIsFunction,
                            const Namespace &   i_rCurNamespace,
                            const Class *       i_pCurClass ) const;
    virtual uintt       inq_Get_AlphabeticalList(
                            List_Rid &          o_sResult,
                            const char *        i_sBegin,
                            const char *        i_sEnd ) const;
    virtual void        inq_Get_QualifiedName(
                            StreamStr &         o_rOut,
                            const udmstri &     i_sLocalName,
                            Cid                 i_nOwner,
                            const char *        i_sDelimiter ) const;
    virtual bool        inq_Get_TypeText(
                            StreamStr &         o_rOut,
                            Tid                 i_nType ) const;
    virtual bool        inq_Get_TypeText(
                            StreamStr &         o_rPreName,     ///  ::ary::cpp::
                            StreamStr &         o_rName,        ///  MyClass
                            StreamStr &         o_rPostName,    ///  <TplArgument> * const &
                            Tid                 i_nType ) const;
    virtual void        inq_Get_SignatureText(
                            StreamStr &         o_rOut,
                            OSid                i_nSignature,
                            const StringVector *
                                                i_sParameterNames ) const;
    virtual const Namespace &
                        inq_GlobalNamespace() const;
    virtual const RoGate_Defines &
                        inq_RoDefines() const;
    virtual const RoGate_Groups &
                        inq_RoGroups() const;
    virtual const loc::RoGate &
                        inq_RoLocations() const;
    // Interface ary::DisplayGate:
    virtual const RepositoryEntity *
                        inq_Find_Re(
                            Rid                 i_nId ) const;
    // Local types
    struct CheshireCat;

    // DATA
    Dyn<CheshireCat>    pi;
};



}   // namespace cpp
}   // namespace ary



#endif

