/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: FileDataSource.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 00:59:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "FileDataSource.hxx"
#include "CachedDataSequence.hxx"
#include "macros.hxx"

#ifndef _COM_SUN_STAR_BEANS_PROPERTYATTRIBUTE_HPP_
#include <com/sun/star/beans/PropertyAttribute.hpp>
#endif

using ::rtl::OUString;
using ::osl::MutexGuard;
using ::com::sun::star::uno::Sequence;
using ::com::sun::star::uno::Reference;
using ::com::sun::star::uno::RuntimeException;
using ::com::sun::star::uno::Any;

using namespace ::com::sun::star;

// necessary for MS compiler
using ::comphelper::OPropertyContainer;
using ::chart::impl::FileDataSource_Base;

namespace
{
static const ::rtl::OUString lcl_aServiceName(
    RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.comp.chart.FileDataSource" ));

enum
{
    PROP_SERVER_COMPONENT,
    PROP_SERVER_LOCATOR
};
}  // anonymous namespace

namespace chart
{

FileDataSource::FileDataSource( Reference< uno::XComponentContext > const & xContext )
        : OPropertyContainer( GetBroadcastHelper()),
          FileDataSource_Base( GetMutex()),
          m_bInitialized( false )
{
    registerProperty( C2U( "ServerComponent" ),
                      PROP_SERVER_COMPONENT,
                      beans::PropertyAttribute::READONLY,
                      & m_sServerComponent,
                      ::getCppuType( & m_sServerComponent ) );

    registerProperty( C2U( "ServerLocator" ),
                      PROP_SERVER_LOCATOR,
                      0,   // PropertyAttributes
                      & m_sServerLocator,
                      ::getCppuType( & m_sServerLocator ) );
}

FileDataSource::~FileDataSource()
{}

// ================================================================================

Sequence< OUString > FileDataSource::getSupportedServiceNames_Static()
{
    Sequence< OUString > aServices( 2 );
    aServices[ 0 ] = lcl_aServiceName;
    aServices[ 1 ] = C2U( "com.sun.star.chart2.DataSource" );
    return aServices;
}

IMPLEMENT_FORWARD_XINTERFACE2( FileDataSource, FileDataSource_Base, OPropertyContainer )
IMPLEMENT_FORWARD_XTYPEPROVIDER2( FileDataSource, FileDataSource_Base, OPropertyContainer )

// ____ XPropertySet ____
Reference< beans::XPropertySetInfo > SAL_CALL FileDataSource::getPropertySetInfo()
    throw(uno::RuntimeException)
{
    return Reference< beans::XPropertySetInfo >( createPropertySetInfo( getInfoHelper() ) );
}

// ____ ::comphelper::OPropertySetHelper ____
// __________________________________________
::cppu::IPropertyArrayHelper& FileDataSource::getInfoHelper()
{
	return *getArrayHelper();
}

// ____ ::comphelper::OPropertyArrayHelper ____
// ____________________________________________
::cppu::IPropertyArrayHelper* FileDataSource::createArrayHelper() const
{
	Sequence< beans::Property > aProps;
    // describes all properties which have been registered in the ctor
	describeProperties( aProps );

	return new ::cppu::OPropertyArrayHelper( aProps );
}

// implement XServiceInfo methods basing upon getSupportedServiceNames_Static
APPHELPER_XSERVICEINFO_IMPL( FileDataSource, lcl_aServiceName )

// ================================================================================

// ____ XDataSource ____
Sequence< Reference< chart2::XDataSequence > > SAL_CALL FileDataSource::getDataSequences()
    throw (RuntimeException)
{
    return m_aData;
}

// ____ XInitialization ____
void SAL_CALL FileDataSource::initialize( const Sequence< Any >& aArguments )
    throw (uno::Exception,
           RuntimeException)
{
    if( aArguments.getLength() > 0 )
    {
        aArguments[ 0 ] >>= m_sServerLocator;

        if( m_sServerLocator.getLength() > 0 )
        {
            oslFileHandle aHdl;
            if( osl_File_E_None == osl_openFile( m_sServerLocator.pData, & aHdl, osl_File_OpenFlag_Read ))
            {
                if( ReadData( aHdl ) )
                    m_bInitialized = true;
                osl_closeFile( aHdl );
            }
        }
    }
}

bool FileDataSource::ReadData( oslFileHandle & aHdl )
{
    sal_Bool bIsEOF = sal_False;
    sal_Sequence * pLine = NULL;

    enum ePart {
        LABELS,
        CATEGORIES,
        DATA
    };

//    ::std::vector< OUString > aLabels;
    ::std::vector< OUString > aCategories;
    ::std::vector< OUString > aCurrentSeries;
    ::std::vector< OUString > aCurrentLabel;
    ::std::vector< ::std::vector< OUString > > aSeries;
    ::std::vector< ::std::vector< OUString > > aLabels;

    ePart eWhatToRead = LABELS;

    while( osl_isEndOfFile( aHdl, &bIsEOF ) == osl_File_E_None &&
           ! bIsEOF )
    {
        oslFileError eErr = osl_readLine( aHdl, &pLine );
        if( eErr == osl_File_E_None &&
            pLine != NULL )
        {
            OUString aLine( (sal_Char*)&pLine->elements[0],
                            pLine->nElements,
                            RTL_TEXTENCODING_UTF8 );
            sal_Int32 nIndex = 0;
            bool bEmptyLine = false;

            // parse line
            while( nIndex != -1 )
            {
                // skip blank lines
                if( aLine.getLength() == 0 )
                {
                    nIndex = -1;
                    bEmptyLine = true;
                }
                else
                {
                    OUString aTok( aLine.getToken( 0, static_cast< sal_Unicode >( ' ' ), nIndex ) );

                    // comments start with #
                    if( aTok.indexOf( static_cast< sal_Unicode >( '#' ) ) == 0 )
                    {
                        nIndex = -1;
                        bEmptyLine = true;
                    }
                    else
                    {
                        aTok = aTok.replace( static_cast< sal_Unicode >('_'), static_cast< sal_Unicode >(' '));
                        switch( eWhatToRead )
                        {
                            case LABELS:
                                aCurrentLabel.push_back( aTok );
                                aLabels.push_back( aCurrentLabel );
                                aCurrentLabel.clear();
                                break;
                            case CATEGORIES:
                                aCategories.push_back( aTok );
                                break;
                            case DATA:
                                aCurrentSeries.push_back( aTok );
                                break;
                        }
                        bEmptyLine = false;
                    }
                }
            }

            if( ! bEmptyLine )
            {
                switch( eWhatToRead )
                {
                    case LABELS:
                        eWhatToRead = CATEGORIES;
                        break;
                    case CATEGORIES:
                        eWhatToRead = DATA;
                        break;
                    case DATA:
                        aSeries.push_back( aCurrentSeries );
                        aCurrentSeries.clear();
                        break;
                }
            }
        }
        if( eErr != osl_File_E_None )
            return false;
    }

    // create data sequences for the values read
    sal_Int32 nNumberOfSequences =
        aLabels.size() +         // labels
        1 +                      // categories
        aSeries.size();

    CachedDataSequence * pNewSequence = NULL;

    if( nNumberOfSequences > 0 )
    {
        Reference< beans::XPropertySet > xProp;

        m_aData.realloc( nNumberOfSequences );
        Reference< chart2::XDataSequence > * pArray = m_aData.getArray();

        pNewSequence = new CachedDataSequence( aCategories );
        pNewSequence->PreferTextualData();
        pArray[ 0 ].set( static_cast< chart2::XTextualDataSequence * >( pNewSequence ));
        // set proposed role
        xProp.set( pArray[ 0 ], uno::UNO_QUERY );
        if( xProp.is())
            xProp->setPropertyValue(
                C2U( "Role" ), uno::makeAny( C2U( "categories" )));

        sal_Int32 i = 1;
        ::std::vector< ::std::vector< OUString > >::const_iterator aIt;
        for( aIt = aLabels.begin(); aIt != aLabels.end(); ++aIt, ++i )
        {
            pNewSequence = new CachedDataSequence( *aIt );
            pNewSequence->PreferTextualData();
            pArray[ i ].set( static_cast< chart2::XTextualDataSequence * >( pNewSequence ));

            // set proposed role
            xProp.set( pArray[ i ], uno::UNO_QUERY );
            if( xProp.is())
                xProp->setPropertyValue(
                    C2U( "Role" ), uno::makeAny( C2U( "label" )));
        }

        for( aIt = aSeries.begin(); aIt != aSeries.end(); ++aIt, ++i )
        {
            pNewSequence = new CachedDataSequence( *aIt );
            pNewSequence->PreferNumericalData();
            pArray[ i ].set( static_cast< chart2::XNumericalDataSequence * >( pNewSequence ));

            // set proposed role
            xProp.set( pArray[ i ], uno::UNO_QUERY );
            if( xProp.is())
                xProp->setPropertyValue( C2U( "Role" ), uno::makeAny( C2U( "y-values" )));
        }
    }

    return true;
}

} // namespace chart
