/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: ChartViewImpl.hxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 01:46:47 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _CHARTVIEWIMPL_HXX
#define _CHARTVIEWIMPL_HXX

#include "chartview/ChartView.hxx"

#ifndef _COM_SUN_STAR_DRAWING_XDRAWPAGE_HPP_
#include <com/sun/star/drawing/XDrawPage.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#include <vector>

//.............................................................................
namespace chart
{
//.............................................................................

class NumberFormatterWrapper;
class VCoordinateSystem;

//-----------------------------------------------------------------------------
/** The ChartView is responsible to manage the generation of Drawing Objects
for visualization on a given OutputDevice. It is furthermore responsible to
keep this Objects up to date according to changes of the underlying ChartModel.

It is not responsible to handle single user events (what is instead done by the ChartWindow).
*/

class ChartViewImpl : public ChartView
{
public:
	ChartViewImpl(
                 const ::com::sun::star::uno::Reference<
                       ::com::sun::star::uno::XComponentContext >& xCC
               , const ::com::sun::star::uno::Reference<
                       ::com::sun::star::frame::XModel >& xChartModel
               , const ::com::sun::star::uno::Reference<
                       ::com::sun::star::drawing::XDrawPagesSupplier>& xDrawPagesSuplier
               , NumberFormatterWrapper* pNumberFormatterWrapper );
	virtual ~ChartViewImpl();

    //___ChartView___
    virtual bool create( const ::com::sun::star::awt::Size& rPageSize );

    //___ExplicitValueProvider___
    virtual void getExplicitValuesForMeter(
        ::com::sun::star::uno::Reference< ::com::sun::star::chart2::XMeter > xMeter
        , ::com::sun::star::chart2::ExplicitScaleData&  rExplicitScale
        , ::com::sun::star::chart2::ExplicitIncrementData& rExplicitIncrement
        , double& rfExplicitOrigin );

private: //member
	::com::sun::star::uno::Reference< ::com::sun::star::uno::XComponentContext>
			m_xCC;
    ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >
            m_xChartModel;

	::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory>
			m_xShapeFactory;
	::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPage>
			m_xDrawPage;
    ::com::sun::star::uno::Reference< ::com::sun::star::drawing::XDrawPages >
            m_xDrawPages;

    NumberFormatterWrapper* m_pNumberFormatterWrapper;

    std::vector< VCoordinateSystem* > m_aVCooSysList;
};

//.............................................................................
} //namespace chart
//.............................................................................

#endif
