/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: heap.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: hr $ $Date: 2005/12/28 17:29:58 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef CONFIGMGR_DATAHEAP_HXX
#define CONFIGMGR_DATAHEAP_HXX

#ifndef CONFIGMGR_DATAHEAPMANAGER_HXX
#include "heapmanager.hxx"
#endif
#ifndef CONFIGMGR_UTILITY_HXX_
#include "utility.hxx"
#endif
#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif

namespace configmgr
{
// -----------------------------------------------------------------------------	
    namespace memory
    {
    // -------------------------------------------------------------------------
        class Heap : Noncopyable
        {
            HeapManager       & m_impl;
            HeapManager::Handle m_heap;
            HeapManager::Size   m_size;
        public:
            typedef HeapManager::Lock        Lock;
            typedef HeapManager::Size        Size;
            typedef HeapManager::HeapId      HeapId;
            typedef HeapManager::HeapIdParam HeapIdParam;
            typedef HeapManager::Address     Address;

            Heap(HeapManager& _impl);
            Heap(HeapManager& _impl, Size _nInitialSize);
            Heap(HeapManager& _impl, HeapIdParam _anId);
            ~Heap();

            Size    size() const { return m_size; }

            Size    grow(Size _nReqSize); 

            void *  base() const   { return m_impl.base(m_heap); }
            HeapId  id()   const   { return m_impl.id(m_heap); }

            Address allocate(Size _sNewSize)    { return m_impl.allocate(m_heap, _sNewSize); }
            Address reallocate(Address _aOldAddress, Size _sNewSize)    
            { return m_impl.reallocate(m_heap, _aOldAddress, _sNewSize); }
            void    deallocate(Address _aAddress)    { m_impl.deallocate(m_heap, _aAddress); }
            bool    didAllocate(Address _aAddress) const 
            { return m_impl.didAllocate(m_heap, _aAddress); }

            Lock *  createLock()                { return m_impl.createHeapLock(m_heap); }
            void    destroyLock(Lock * _pLock)  { m_impl.destroyHeapLock(m_heap,_pLock); }
        };
    // -------------------------------------------------------------------------	
    }
// -----------------------------------------------------------------------------	
} // namespace configmgr

#endif // CONFIGMGR_DATAHEAP_HXX

