/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: memorymodel.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2005/12/28 17:30:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef CONFIGMGR_MEMORYMODEL_HXX
#define CONFIGMGR_MEMORYMODEL_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

//-----------------------------------------------------------------------------
// no full heap implementation available yet - storing pointer value in Address
#define CFG_ADDRESS_HOLDS_POINTER
//-----------------------------------------------------------------------------

namespace configmgr
{
//-----------------------------------------------------------------------------

    namespace memory 
    {
    //-----------------------------------------------------------------------------
    // some base types that describe our memory model
#ifndef CFG_ADDRESS_HOLDS_POINTER
        typedef sal_uInt32 Address; // points to relative location in memory segment
#else
        typedef sal_uIntPtr Address; // points to absolute location in memory
#endif
        typedef sal_uInt32 HeapSize; // memory block size within private heap
        typedef sal_uInt8  Byte;  
    //-----------------------------------------------------------------------------
    }
//-----------------------------------------------------------------------------
}


#endif // CONFIGMGR_MEMORYMODEL_HXX 
