/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: rcptr.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 08:00:24 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef CSV_REFPTR_HXX
#define CSV_REFPTR_HXX


namespace csv
{


/** A refcounting pointer class.

    @tpl REF
    Has to provide the two methods:
        void    Acquire() const;
        void    Release() const;
    Has to handle deleting itself, when reference count reaches zero.
*/

template <class REF>
class RCPtr
{
  public:
    typedef RCPtr<REF> self;


    // LIFECYCLE
						RCPtr(
							DYN REF *		    i_pObject = 0);
                        RCPtr(
                            const self &        i_rOther );
						~RCPtr();

    self &              operator=(
                            const self &        i_rOther );

						operator bool() const;

    const REF *         operator->() const;
    REF *               operator->();
    const REF &         operator*() const;
    REF &               operator*();

    const REF *		    Ptr() const;
    REF *		        Ptr();
    REF *			    MutablePtr() const;


  private:
    void                Acquire() const;
    void                Release() const;

    // DATA
    REF *               pRef;
};




// IMPLEMENTATION

template <class REF>
inline void
RCPtr<REF>::Acquire() const
    { if (pRef != 0) pRef->Acquire(); }
template <class REF>
inline void
RCPtr<REF>::Release() const
    { if (pRef != 0) pRef->Release(); }

template <class REF>
inline
RCPtr<REF>::RCPtr( DYN REF * i_pObject )
    :   pRef(i_pObject) { Acquire(); }
template <class REF>
inline
RCPtr<REF>::RCPtr( const self & i_rOther )
    :   pRef(i_rOther.pRef) { Acquire(); }
template <class REF>
inline
RCPtr<REF>::~RCPtr()
    { Release(); }

template <class REF>
inline RCPtr<REF> &
RCPtr<REF>::operator=( const self & i_rOther )
    { i_rOther.Acquire(); Release(); pRef = i_rOther.pRef; }
template <class REF>
inline
RCPtr<REF>::operator bool() const
    { return pRef != 0; }

template <class REF>
inline const REF *
RCPtr<REF>::operator->() const
    { return pRef; }
template <class REF>
inline REF *
RCPtr<REF>::operator->()
    { return pRef; }

template <class REF>
inline const REF &
RCPtr<REF>::operator*() const
    { csv_assert(pRef != 0); return *pRef; }
template <class REF>
inline REF &
RCPtr<REF>::operator*()
    { csv_assert(pRef != 0); return *pRef; }

template <class REF>
inline const REF *
RCPtr<REF>::Ptr() const
    { return pRef; }
template <class REF>
inline REF *
RCPtr<REF>::Ptr()
    { return pRef; }
template <class REF>
inline REF *
RCPtr<REF>::MutablePtr() const
    { return const_cast< REF* >(pRef); }


}   // namespace csv


#endif

