/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TableFieldData.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 16:29:08 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef DBAUI_TABLEFIELDDATA_HXX
#define DBAUI_TABLEFIELDDATA_HXX

#ifndef _COM_SUN_STAR_IO_XOBJECTOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XObjectOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOBJECTINPUTSTREAM_HPP_
#include <com/sun/star/io/XObjectInputStream.hpp>
#endif

namespace dbaui
{
	class OTableFieldData
	{
	private:
		::rtl::OUString m_aFieldName;
		::rtl::OUString m_aTableName;
		::rtl::OUString m_aAliasName;
		sal_Int32		m_nColWidth;

	public:
		OTableFieldData();
		OTableFieldData( const ::rtl::OUString& rFieldName, const ::rtl::OUString& rTableName, const ::rtl::OUString& rAliasName );
		~OTableFieldData();

		::rtl::OUString GetFieldName(){ return m_aFieldName; }
		::rtl::OUString GetTableName(){ return m_aTableName; }
		::rtl::OUString GetAliasName(){ return m_aAliasName; }
		sal_Int32 GetColWidth(){ return m_nColWidth; }

		void SetFieldName( const ::rtl::OUString& rName ){ m_aFieldName = rName; }
		void SetTableName( const ::rtl::OUString& rName ){ m_aTableName = rName; }
		void SetAliasName( const ::rtl::OUString& rName ){ m_aAliasName = rName; }
		void SetColWidth( sal_Int32 nWidth ){ m_nColWidth = nWidth; }

		void Load(const ::com::sun::star::uno::Reference< ::com::sun::star::io::XObjectInputStream>& _rxIn);
		void Save(const ::com::sun::star::uno::Reference< ::com::sun::star::io::XObjectOutputStream>& _rxOut);
	};
}
#endif // DBAUI_TABLEFIELDDATA_HXX



