/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: specialobject.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 18:40:06 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _INC_SPECIALOBJECT_HXX_
#define _INC_SPECIALOBJECT_HXX_

#include <com/sun/star/awt/Size.hpp>

#include "commonembobj.hxx"

class OSpecialEmbeddedObject : public OCommonEmbeddedObject
{
private:
    com::sun::star::awt::Size         maSize;
public:
    OSpecialEmbeddedObject(
		const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& xFactory,
        const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::NamedValue >& aObjectProps );

    // XInterface
	virtual ::com::sun::star::uno::Any SAL_CALL queryInterface( const ::com::sun::star::uno::Type& rType )
		throw( ::com::sun::star::uno::RuntimeException ) ;

    // XTypeProvider
	virtual ::com::sun::star::uno::Sequence< ::com::sun::star::uno::Type > SAL_CALL getTypes()
		throw( ::com::sun::star::uno::RuntimeException ) ;

    // XVisualObject
    virtual ::com::sun::star::embed::VisualRepresentation SAL_CALL getPreferredVisualRepresentation( ::sal_Int64 nAspect )
		throw ( ::com::sun::star::lang::IllegalArgumentException,
				::com::sun::star::embed::WrongStateException,
				::com::sun::star::uno::Exception,
				::com::sun::star::uno::RuntimeException );

    virtual void SAL_CALL setVisualAreaSize( sal_Int64 nAspect, const ::com::sun::star::awt::Size& aSize )
		throw ( ::com::sun::star::lang::IllegalArgumentException,
				::com::sun::star::embed::WrongStateException,
				::com::sun::star::uno::Exception,
				::com::sun::star::uno::RuntimeException );

    virtual ::com::sun::star::awt::Size SAL_CALL getVisualAreaSize( sal_Int64 nAspect )
		throw ( ::com::sun::star::lang::IllegalArgumentException,
				::com::sun::star::embed::WrongStateException,
				::com::sun::star::uno::Exception,
				::com::sun::star::uno::RuntimeException );

    virtual sal_Int32 SAL_CALL getMapUnit( sal_Int64 nAspect )
		throw ( ::com::sun::star::uno::Exception,
				::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL changeState( sal_Int32 nNewState )
		throw ( ::com::sun::star::embed::UnreachableStateException,
				::com::sun::star::embed::WrongStateException,
				::com::sun::star::uno::Exception,
				::com::sun::star::uno::RuntimeException );

    virtual void SAL_CALL doVerb( sal_Int32 nVerbID )
		throw ( ::com::sun::star::lang::IllegalArgumentException,
				::com::sun::star::embed::WrongStateException,
				::com::sun::star::embed::UnreachableStateException,
				::com::sun::star::uno::Exception,
				::com::sun::star::uno::RuntimeException );
};

#endif

