#!/bin/sh
# **********************************************************************
#
#   OpenOffice.org - a multi-platform office productivity suite
#
#   $RCSfile: adopatch.sh,v $
#
#   $Revision: 1.4 $
#
#   last change: $Author: rt $ $Date: 2005/09/06 14:21:32 $
#
#   The Contents of this file are made available subject to
#   the terms of GNU Lesser General Public License Version 2.1.
#
#
#     GNU Lesser General Public License Version 2.1
#     =============================================
#     Copyright 2005 by Sun Microsystems, Inc.
#     901 San Antonio Road, Palo Alto, CA 94303, USA
#
#     This library is free software; you can redistribute it and/or
#     modify it under the terms of the GNU Lesser General Public
#     License version 2.1, as published by the Free Software Foundation.
#
#     This library is distributed in the hope that it will be useful,
#     but WITHOUT ANY WARRANTY; without even the implied warranty of
#     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#     Lesser General Public License for more details.
#
#     You should have received a copy of the GNU Lesser General Public
#     License along with this library; if not, write to the Free Software
#     Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#     MA  02111-1307  USA
#
# **********************************************************************

#rem *****************  Get the source files and patch them *****************

tarball="${PSDK_HOME}/Include/AdoCtint.h"
fname="adoctint.h"

if test -s "$tarball"; then

#
# apply the patches
#

  tar -x -z -m -f ado.pat.tar.gz
  # Warning! $tarball may contain spaces!
  cp "$tarball" $fname

  patch $fname pat/${fname}.pat
  rm -f patcherror
  rm -rf pat

  echo "Patch done." > patchinf
  echo "Patch done."
else

#
# error message
#

  echo "Can't find the $tarball file. See patcherror file."
  echo "Source tarball is missing: $tarball " > patcherror
fi
