
package org.netbeans.modules.openoffice;

import java.beans.SimpleBeanInfo;
import java.awt.Image;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;


public final class OOIDLGlobalSettingsBeanInfo extends SimpleBeanInfo {
    
    public PropertyDescriptor[] getPropertyDescriptors() {
        try {
            PropertyDescriptor propertydescriptorSDKDirectory
            = new PropertyDescriptor( NbBundle.getMessage( 
            OOIDLGlobalSettings.class,
            "PROP_sdk_directory"),
            OOIDLGlobalSettings.class );
            
            propertydescriptorSDKDirectory.setDisplayName(
            "OpenOffice.org SDK Install Directory" );
            
            PropertyDescriptor propertydescriptorOfficeDirectory
            = new PropertyDescriptor( NbBundle.getMessage( 
            OOIDLGlobalSettings.class,
            "PROP_office_directory"),
            OOIDLGlobalSettings.class );
            
            propertydescriptorOfficeDirectory.setDisplayName(
            "OpenOffice.org Install Directory" );
            
            return (
            new PropertyDescriptor[] { propertydescriptorSDKDirectory,
            propertydescriptorOfficeDirectory } );
            
        }
        catch(IntrospectionException introspectionexception) {
            introspectionexception.printStackTrace();
        }
        return null;
    }
    
    /** Icons for compiler settings objects. */
    private static Image icon;
    
    /** Get the bean icon for the loader.
     * @param type desired type of the icon
     * @return returns the OOIDL loader's icon
     */
    public Image getIcon(final int type) {
        if ((type == java.beans.BeanInfo.ICON_COLOR_16x16) ||
        (type == java.beans.BeanInfo.ICON_MONO_16x16)) {
            if (icon == null)
                icon = loadImage("/org/netbeans/modules/openoffice/Global.gif");
            return icon;
        } else {
            return null;
        }
    }
    
}
