
package org.netbeans.modules.openoffice.wizard.nodes;

import java.beans.FeatureDescriptor;
import java.util.StringTokenizer;
import org.netbeans.modules.openoffice.wizard.panels.idl.AliasPanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.BasePanel;
import org.netbeans.modules.openoffice.wizard.panels.idl.UnionMemberPanel;
import org.netbeans.modules.openoffice.wizard.keys.*;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Node;
import java.util.Vector;


public class UnionMemberNode extends LeafNode
{

    public UnionMemberNode(NameKey namedkey)
    {
        super(namedkey);
        setName(namedkey.getName());
        setIconBase("org/netbeans/modules/openoffice/wizard/ui/unionmember");
    }

    public String generateSelf(int i)
    {
        String s = new String();
        for(int j = 0; j < i; j++)
            s = s + "    ";

        UnionMemberKey unionmemberkey = (UnionMemberKey)key;
        if(unionmemberkey.isDefaultValue())
        {
            s = s + "default: " + unionmemberkey.getType() + " " + getName();
        }
        else
        {
            s = s + "case " + unionmemberkey.getLabel() + ": ";
            s = s + unionmemberkey.getType() + " " + getName();
        }
       
        s = s + ";\n";
        return s;
    }

    public void destroy()
    {
        try{
        if(((UnionMemberKey)key).isDefaultValue())
            ((UnionNode)getParentNode()).canAdd = true;
        super.destroy();
        }catch ( Exception e ){}
    }

    public BasePanel getEditPanel()
    {
        UnionMemberKey unionmemberkey = (UnionMemberKey)key;
        if(unionmemberkey.isDefaultValue())
        {
            AliasPanel aliaspanel = new AliasPanel();
            aliaspanel.setName(getName());
            aliaspanel.setType(((UnionMemberKey)key).getType());
      
            return aliaspanel;
        }
        else
        {
            UnionMemberPanel unionmemberpanel = new UnionMemberPanel();
            unionmemberpanel.setName(getName());
            unionmemberpanel.setType(((UnionMemberKey)key).getType());
            unionmemberpanel.setLabel(((UnionMemberKey)key).getLabel());
        
            return unionmemberpanel;
        }
    }

    public void reInit(BasePanel BasePanel)
    {
        String s;
        String s1;
        String s2;
        String s3;
        if(BasePanel instanceof UnionMemberPanel)
        {
            UnionMemberPanel unionmemberpanel = (UnionMemberPanel)BasePanel;
            s = unionmemberpanel.getName();
            s1 = unionmemberpanel.getType();
            s2 = unionmemberpanel.getLabel();
          
        }
        else
        if(BasePanel instanceof AliasPanel)
        {
            AliasPanel aliaspanel = (AliasPanel)BasePanel;
            s = aliaspanel.getName();
            s1 = aliaspanel.getType();
          
            s2 = null;
        }
        else
        {
            return;
        }
        UnionMemberKey unionmemberkey = (UnionMemberKey)key;
        if(!unionmemberkey.getName().equals(s))
        {
            setName(s);
            unionmemberkey.setName(s);
        }
        if(!unionmemberkey.getType().equals(s1))
            unionmemberkey.setType(s1);
        if(s2 != null && !unionmemberkey.getLabel().equals(s2))
            unionmemberkey.setLabel(s2);
        
    }
   
    public void generateImports(Vector Imports1)
    {  
        Node anode[] = getChildren().getNodes();
        for(int l = 0; l < anode.length; l++)
        {
            ((BaseNode)anode[l]).generateImports(Imports1);
            
        }  
    }        
 
    private static final String ICON_BASE = "org/netbeans/modules/openoffice/wizard/ui/unionmember";
}
