/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: futext.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:51:03 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SCH_FUTEXT_HXX
#define _SCH_FUTEXT_HXX

#ifndef _SV_FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif
#ifndef _SVDTRANS_HXX //autogen
#include <svx/svdtrans.hxx>
#endif


#ifndef _SVDOTEXT_HXX //autogen
#include <svx/svdotext.hxx>
#endif

#ifndef _SCH_FUDRAW_HXX
#include "fudraw.hxx"
#endif

/*************************************************************************
|*
|* Basisklasse fuer Textfunktionen
|*
\************************************************************************/
class SchFuText : public SchFuDraw
{
protected:
	SdrTextObj* 		pTextObj;
	Rectangle			aTextRect;
	OutlinerParaObject* pOutlinerParaObject;

public:
	TYPEINFO();

	SchFuText(SchViewShell* pViewSh, SchWindow* pWin, SchView* pView,
			  ChartModel* pDoc, SfxRequest& rReq);

	virtual ~SchFuText();

	virtual BOOL KeyInput(const KeyEvent& rKEvt);
	virtual BOOL MouseMove(const MouseEvent& rMEvt);
	virtual BOOL MouseButtonUp(const MouseEvent& rMEvt);
	virtual BOOL MouseButtonDown(const MouseEvent& rMEvt);
	virtual BOOL Command(const CommandEvent& rCEvt);

	virtual void Activate();		   // Function aktivieren
	virtual void Deactivate();		   // Function deaktivieren

	virtual void ForcePointer(const MouseEvent* pMEvt = NULL);

	BOOL StartEditMode();
	BOOL EndEditMode();
};

#endif	// _SCH_FUTEXT_HXX


