/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: title.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 00:55:01 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


#ifndef _SCH_TITLE_HXX
#define _SCH_TITLE_HXX

#ifndef _SV_BUTTON_HXX //autogen
#include <vcl/button.hxx>
#endif
#ifndef _SV_EDIT_HXX //autogen
#include <vcl/edit.hxx>
#endif
#ifndef _SV_DIALOG_HXX //autogen
#include <vcl/dialog.hxx>
#endif
#ifndef _SFXITEMSET_HXX //autogen
#include <svtools/itemset.hxx>
#endif

#include "title.hrc"

/*************************************************************************
|*
|* Titel-Dialog
|*
\************************************************************************/
class SchTitleDlg : public ModalDialog
{
private:
	CheckBox 			aCbxMain;
	Edit     			aEdtMain;
	CheckBox 			aCbxSub;
	Edit     			aEdtSub;
	CheckBox 			aCbxXAxis;
	Edit     			aEdtXAxis;
	CheckBox 			aCbxYAxis;
	Edit     			aEdtYAxis;
	CheckBox 			aCbxZAxis;
	Edit     			aEdtZAxis;
	OKButton			aBtnOK;
	CancelButton		aBtnCancel;
	HelpButton			aBtnHelp;

	const SfxItemSet&	rOutAttrs;

	DECL_LINK(EnableTitleHdl, CheckBox*);

	void Reset();

public:
	SchTitleDlg(Window* pParent, const SfxItemSet& rInAttrs,
				BOOL bEnableXYAxis, BOOL bEnableZAxis);
	virtual ~SchTitleDlg();

	void GetAttr(SfxItemSet& rOutAttrs);
};

#endif // _SCH_TITLE_HXX

