/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: mailwindow.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/07 18:24:09 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// includes --------------------------------------------------------------

#include "mailwindow.hxx"
#include <mailmodel.hxx>
#if SUPD<613//MUSTINI
#include "inimgr.hxx"
#endif
#include "sfxtypes.hxx"
#include "sfxresid.hxx"
#include "bindings.hxx"
#include "sfxsids.hrc"
#include "mailwindow.hrc"
#include "dialog.hrc"

#include <vcl/msgbox.hxx>	// InfoBox
//#include <svtools/useroptions.hxx>

// class AddressEdit_Impl ------------------------------------------------
/*
AddressEdit_Impl::AddressEdit_Impl( MailWindow_Impl* pWin, const ResId& rResId ) :

	Edit( pWin, rResId ),

	mpWindow( pWin )

{
}

void AddressEdit_Impl::KeyInput( const KeyEvent& rKEvt )
{
	switch ( rKEvt.GetKeyCode().GetCode() )
	{
		case KEY_RETURN:
			mpWindow->ReceiveAddress();
			break;

		case KEY_ESCAPE:
			mpWindow->ClearAddress();
			break;

		default:
			Edit::KeyInput( rKEvt );
	}
}

// class AddressListBox_Impl ---------------------------------------------

AddressListBox_Impl::AddressListBox_Impl( MailWindow_Impl* pWin, const ResId& rResId ) :

	ListBox( pWin, rResId ),

	mpWindow( pWin )

{
}

long AddressListBox_Impl::Notify( NotifyEvent& rNEvt )
{
	long nRet = 0;

	if ( rNEvt.GetType() == EVENT_KEYINPUT )
	{
		const KeyCode& rKey = rNEvt.GetKeyEvent()->GetKeyCode();

		if ( rKey.GetCode() == KEY_DELETE )
		{
			mpWindow->DeleteAddress();
			nRet = 1;
		}
	}

	return nRet ? nRet : ListBox::Notify( rNEvt );
}

// class MailWindow_Impl -------------------------------------------------

MailWindow_Impl::MailWindow_Impl( Window* pParent, SfxBindings* pBinds, const ResId& rResId ) :

	Window( pParent, rResId ),

	aSendBtn	( this, ResId( PB_MAILWIN_SEND ) ),
	aCloseBtn	( this, ResId( PB_MAILWIN_CLOSE ) ),
	aRoleLB		( this, ResId( LB_MAILWIN_ROLE ) ),
	aRoleEdit	( this, ResId( ED_MAILWIN_ROLE ) ),
	aAddressLB	( this, ResId( LB_MAILWIN_ADDRESS ) ),
	aSubjectFT	( this, ResId( FT_MAILWIN_SUBJECT ) ),
	aSubjectEdit( this, ResId( ED_MAILWIN_SUBJECT ) ),
	aFromFT		( this, ResId( FT_MAILWIN_FROM ) ),
	aFromEdit	( this, ResId( ED_MAILWIN_FROM ) ),
	aPrioFT		( this, ResId( FT_MAILWIN_PRIO ) ),
	aPrioLB		( this, ResId( LB_MAILWIN_PRIO ) ),
	aSendImage	(		ResId( IMG_MAILWIN_SEND ) ),
	aCloseImage	(		ResId( IMG_MAILWIN_CLOSE ) ),

	bSend			( sal_False ),
	pBindings		( pBinds )

{
	FreeResource();

	aSendBtn.SetClickHdl( LINK( this, MailWindow_Impl, SendHdl ) );
	aCloseBtn.SetClickHdl( LINK( this, MailWindow_Impl, CloseHdl ) );
	Link aLink( LINK( this, MailWindow_Impl, ModifyHdl ) );
	aRoleEdit.SetModifyHdl( aLink );
	aSubjectEdit.SetModifyHdl( aLink );
	aFromEdit.SetModifyHdl( aLink );

//! (pb) not implemented in VCL
//	aSendBtn.SetImage( aSendImage );
//	aSendBtn.SetImageAlign( IMAGEALIGN_LEFT );
//	aCloseBtn.SetImage( aCloseImage );
//	aCloseBtn.SetImageAlign( IMAGEALIGN_LEFT );

	String aFrom;
	if ( CreateFromAddress_Impl( aFrom ) )
		aFromEdit.SetText( aFrom );

	aRoleLB.SelectEntryPos(0);	// To
	aPrioLB.SelectEntryPos(2);	// Normal
	n6Size = LogicToPixel( Size( 6, 6 ), MAP_APPFONT ).Width();
	nMinWidth = ( aSubjectEdit.GetSizePixel().Width() / 2 ) + n6Size +
				aPrioFT.GetSizePixel().Width() + aPrioLB.GetSizePixel().Width();

	ModifyHdl( NULL );

	aCloseTimer.SetTimeout( 200 );
	aCloseTimer.SetTimeoutHdl( LINK( this, MailWindow_Impl, CloseHdl ) );

	aInitTimer.SetTimeout( 500 );
	aInitTimer.SetTimeoutHdl( LINK( this, MailWindow_Impl, InitHdl ) );
	aInitTimer.Start();
}

// -----------------------------------------------------------------------

MailWindow_Impl::~MailWindow_Impl()
{}

// -----------------------------------------------------------------------

void MailWindow_Impl::FillModel( SfxMailModel_Impl& rModel )
{
	if ( aRoleEdit.GetText().Len() > 0 )
		ReceiveAddress();
	USHORT i, nCount = aAddressLB.GetEntryCount();
	String aPrefix( DEFINE_CONST_UNICODE(": ") );
	for ( i = 0; i < nCount; ++i )
	{
		String aAddress = aAddressLB.GetEntry(i);
		USHORT nPos = aAddress.Search( aPrefix );
		aAddress.Erase( 0, nPos + 2 );
		SfxMailModel_Impl::AddressRole eRole =
			(SfxMailModel_Impl::AddressRole)(long)aAddressLB.GetEntryData(i);
		rModel.AddAddress( aAddress, eRole );
	}
	rModel.SetSubject( aSubjectEdit.GetText() );
	rModel.SetPriority( (SfxMailModel_Impl::MailPriority)aPrioLB.GetSelectEntryPos() );
	rModel.SetFromAddress( aFromEdit.GetText() );
}

// -----------------------------------------------------------------------

IMPL_LINK( MailWindow_Impl, SendHdl, PushButton*, EMPTYARG )
{
	Send();
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( MailWindow_Impl, CloseHdl, void*, EMPTYARG )
{
    pBindings->Execute( SID_MAIL_CHILDWIN );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( MailWindow_Impl, ModifyHdl, Edit*, EMPTYARG )
{
	aSendBtn.Enable( CanSend() );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( MailWindow_Impl, ChangeHdl, MailListener_Impl*, pListener )
{
	ModifyHdl( NULL );
	return 0;
}

// -----------------------------------------------------------------------

IMPL_LINK( MailWindow_Impl, InitHdl, Timer*, EMPTYARG )
{
	return 0;
}

// -----------------------------------------------------------------------

void MailWindow_Impl::Resize()
{
	Size aWinSize = GetSizePixel();
	Point aPos = aFromEdit.GetPosPixel();
	Size aOldSize = aFromEdit.GetSizePixel();
	Size aNewSize = aOldSize;
	aNewSize.Width() = aWinSize.Width() - aPos.X() - n6Size;

	if ( nMinWidth < aNewSize.Width() )
	{
		Size aAddressSize = aAddressLB.GetSizePixel();
		aAddressSize.Width() = aNewSize.Width();
		aAddressLB.SetSizePixel( aAddressSize );

		aRoleEdit.SetSizePixel( aNewSize );
		aSubjectEdit.SetSizePixel( aNewSize );

		Size aPrioSize1 = aPrioFT.GetSizePixel();
		Size aPrioSize2 = aPrioLB.GetSizePixel();
		aNewSize.Width() -= ( n6Size + aPrioSize1.Width() + aPrioSize2.Width() );
		aFromEdit.SetSizePixel( aNewSize );

		long nNewXPos = aFromEdit.GetPosPixel().X() + aNewSize.Width() + ( n6Size / 2 );
		Point aNewPos = aPrioFT.GetPosPixel();
		aNewPos.X() = nNewXPos;
		aPrioFT.SetPosPixel( aNewPos );
		aNewPos = aPrioLB.GetPosPixel();
		aNewPos.X() = nNewXPos + aPrioSize1.Width() + ( n6Size / 2 );
		aPrioLB.SetPosPixel( aNewPos );
	}
}

// -----------------------------------------------------------------------

sal_Bool MailWindow_Impl::CanSend() const
{
	return ( aSubjectEdit.GetText().Len() > 0 &&
			 aFromEdit.GetText().Len() > 0 &&
			 ( aRoleEdit.GetText().Len() > 0 || aAddressLB.GetEntryCount() > 0 ) );
}

// -----------------------------------------------------------------------

void MailWindow_Impl::Send()
{
	SfxMailModel_Impl aModel( pBindings );
	EnterWait();
	FillModel( aModel );
	SfxMailModel_Impl::SendMailResult eResult = 
		aModel.Send( SfxMailModel_Impl::TYPE_SELF );
	LeaveWait();
	if ( eResult == SfxMailModel_Impl::SEND_MAIL_ERROR )
	{
		ErrorBox aBox( this, SfxResId( RID_ERRBOX_SEND_FAILED ) );
		aBox.Execute();
	}
}

// -----------------------------------------------------------------------

void MailWindow_Impl::ReceiveAddress()
{
	USHORT nRole = aRoleLB.GetSelectEntryPos();
	String aAddress = aRoleLB.GetEntry( nRole );
	aAddress += DEFINE_CONST_UNICODE(": ");
	aAddress += aRoleEdit.GetText();
	USHORT nPos = aAddressLB.InsertEntry( aAddress );
	aAddressLB.SetEntryData( nPos, (void*)(long)nRole );
	aRoleEdit.SetText( String() );
}

// -----------------------------------------------------------------------

void MailWindow_Impl::ClearAddress()
{
	aRoleEdit.SetText( String() );
}

// -----------------------------------------------------------------------

void MailWindow_Impl::DeleteAddress()
{
	USHORT nPos = aAddressLB.GetSelectEntryPos();
	aAddressLB.RemoveEntry( nPos );
	USHORT nCount = aAddressLB.GetEntryCount();

	if ( nCount )
	{
		if ( nPos >= nCount )
			nPos = ( nCount - 1 );
		aAddressLB.SelectEntryPos( nPos );
	}
}

*/
