/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: intrinsicanimation.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: obo $ $Date: 2005/10/11 08:51:12 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SLIDESHOW_INTRINSICANIMATION_HXX
#define _SLIDESHOW_INTRINSICANIMATION_HXX

#ifndef BOOST_SHARED_PTR_HPP_INCLUDED
#include <boost/shared_ptr.hpp>
#endif

#include <shape.hxx>
#include <slideshowcontext.hxx>


namespace presentation
{
    namespace internal
    {
        /** Offers control over a shape's intrinsic animation.

            This interface, presented as an aspect of a Shape,
            provides control over that shape's intrinsic animation. An
            intrinsic animation is an animation that is part of the
            shape itself (e.g. drawing layer animations or GIF
            animations), and not controlled or provided by
            XAnimationNodes.
         */
        class IntrinsicAnimation
        {
        public:
            virtual ~IntrinsicAnimation() {}

            /** Inits the intrinsic animation which is used to apply
                initial shape attributes e.g. for drawing layer animations.
                
                @param rContext
                Slideshow context, provides common objects for shape
                animation.

                @param rShape
                Shared pointer to the shape, whose intrinsic animation
                should start.

                @return true, if the intrinsic animation has been inited.
            */
            virtual bool initIntrinsicAnimation(
                const SlideShowContext& rContext,
                const ShapeSharedPtr&   rShape ) = 0;
            
            /** Start the intrinsic animation.

            	@param rContext
                Slideshow context, provides common objects for shape
                animation.

                @param rShape
                Shared pointer to the shape, whose intrinsic animation
                should start.

                @return true, if the intrinsic animation was
                successfully started.
             */
            virtual bool startIntrinsicAnimation( const SlideShowContext& rContext,
                                                  const ShapeSharedPtr&	  rShape ) = 0;

            /** End the intrinsic animation unconditionally.

            	@return true, if the animation was successfully stopped.
             */
            virtual bool endIntrinsicAnimation() = 0;
        };

        typedef ::boost::shared_ptr< IntrinsicAnimation > IntrinsicAnimationSharedPtr;
    }
}

#endif /* _SLIDESHOW_INTRINSICANIMATION_HXX */
