/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: isbxobj.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/08 23:35:48 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _SVX_ISBXOBJ_HXX
#define _SVX_ISBXOBJ_HXX

// include ---------------------------------------------------------------

#ifndef _AUTO_HXX //autogen
#include <so3/auto.hxx>
#endif

//#include "svxids.hrc"
#include "tstpitem.hxx"

//-------------------------------------------------------------------------

class SvxTabStopObject_Impl: public SvDispatch

/*	[Beschreibung]

	Diese SbxObject-Subklasse kann Instanzen der Klasse <SvxTabStopsItem>
	im SBX-System recorden und wieder abspielen. Ein Item mit einem Dezimal-
	und einem Links-Tab wird wie folgt recorded (das WITH-Statement kommt
	dabei vom Sfx-Makro-Recorder, nur die Insert-Statements werden hier
	generiert):

		DIM aTabStops1 AS NEW TabStops
		WITH aTabStops1
			Insert( 2343, "D", ",", " " )
			Insert( 5343, "L", " ", "." )
		END WITH

	 Die Positionsangaben sind noch in Core-Ma\seinheiten, da ich diese
	 noch nicht kenne (also nicht umrechnen kann).

	 Desweiteren gibt es die folgenden Sbx-Methoden an diesem Objekt:

		int 	GetCount()
		long	GetPosition()
		String	GetAdjust()
		String	GetDecimalChar()
		String	GetFillChar()


	[Anmerkung]

	SbxObjects, die nur aus einfachen (keine Arrays) Properties bestehen,
	brauchen nur den Konstruktor implementieren, da die Basisklasse
	<SbxObject> Properties bereits selbst recorden kann. Notify() ist
	dann i.d.R. auch automatisch korrekt implemementiert.
*/

{
	SvxTabStopItem* 		pTabs;	// Container f"ur die TabStops
	SbxVariableRef			xVar;	// zum Benachrichtigen

private:
	char					GetAdjustChar( SvxTabAdjust eAdj );

protected:
	void					SFX_NOTIFY( SfxBroadcaster& rBC, const TypeId& rBCType,
									const SfxHint& rHint, const TypeId& rHintType );

public:
							TYPEINFO();
							SvxTabStopObject_Impl();
							SvxTabStopObject_Impl( SbxVariable *pVar,
												   const SvxTabStopItem &rTabs );
							~SvxTabStopObject_Impl();

	const SvxTabStopItem&	GetTabStops() const { return *pTabs; }

	virtual String 			GenerateSource( const String &rLinePrefix,
											const SbxObject *pRelativeTo );
};


#endif

