/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: _xfont.cxx,v $
 *
 *  $Revision: 1.15 $
 *
 *  last change: $Author: kz $ $Date: 2005/10/05 13:26:18 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <tools/poly.hxx>
#include <vcl/metric.hxx>
#include <vcl/virdev.hxx>
#include <math.h>
#include "xpoly.hxx"
#include "xattr.hxx"
#include "xoutx.hxx"

// #101498#
#ifndef _OUTLINER_HXX
#include "outliner.hxx"
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_I18N_SCRIPTTYPE_HDL_
#include <com/sun/star/i18n/ScriptType.hdl>
#endif

#ifndef _COM_SUN_STAR_I18N_XBREAKITERATOR_HPP_
#include <com/sun/star/i18n/XBreakIterator.hpp>
#endif

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _COM_SUN_STAR_I18N_CHARACTERITERATORMODE_HDL_
#include <com/sun/star/i18n/CharacterIteratorMode.hdl>
#endif

#ifndef _UNO_LINGU_HXX
#include "unolingu.hxx"
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::i18n;

/*************************************************************************
|*
|*	  XOutGetCharOutline()
|*
|*	  Ein Zeichen eines Outlinefonts in ein Bezier-PolyPolygon umwandeln
|*	  Wenn keine Umwandlung moeglich ist, wird ein leeres PolyPolygon
|*	  zurueckgegeben
|*	  Ersterstellung	12.01.95 ESO
|*	  Letzte Aenderung	09.05.95 ESO
|*
*************************************************************************/

// #102382# Remove XOutGetCharOutline
// #100318# deprecated, use XOutGetTextOutline
//XPolyPolygon XOutGetCharOutline( USHORT nChar, OutputDevice& rOut, BOOL bOptimizeSize )
//{
//	PolyPolygon aPolyPoly;
//
//	//if( !rOut.GetGlyphOutline( (xub_Unicode) nChar, aPolyPoly, bOptimizeSize ) && rOut.GetOutDevType() == OUTDEV_PRINTER )
//	// #97492#
//	String aGlyphString((xub_Unicode) nChar);
//
//	if( !rOut.GetTextOutline(aPolyPoly, aGlyphString) && OUTDEV_PRINTER == rOut.GetOutDevType())
//	{
//		VirtualDevice aVDev;
//		aVDev.SetMapMode( rOut.GetMapMode() );
//		aVDev.SetFont( rOut.GetFont() );
//		aVDev.SetTextAlign( rOut.GetTextAlign() );
//		// #97492#
//		//aVDev.GetGlyphOutline( (xub_Unicode) nChar, aPolyPoly, FALSE );
//		aVDev.GetTextOutline(aPolyPoly, aGlyphString);
//	}
//
//	// #97492# since GetTextOutline(...) is base line oriented, the
//	// polygon needs to be moved one line height
//	aPolyPoly.Move(0, rOut.GetFontMetric().GetAscent());
//
//	return XPolyPolygon( aPolyPoly );
//}

// #100318# new for XOutGetCharOutline
// #102382# new interface for XOutGetTextOutline to support PolyPolyVector
sal_Bool XOutGetTextOutlines(PolyPolyVector& rPolyPolyVector, const String& rText, OutputDevice& rOut, 
	xub_StrLen nBase, xub_StrLen nIndex, xub_StrLen nLen)
{
	// #102382# use GetTextOutlines and PolyPolyVector now
	if(!rOut.GetTextOutlines(rPolyPolyVector, rText, nBase, nIndex, nLen) && OUTDEV_PRINTER == rOut.GetOutDevType())
	{
		VirtualDevice aVDev;

		aVDev.SetMapMode(rOut.GetMapMode());
		aVDev.SetFont(rOut.GetFont());
		aVDev.SetTextAlign(rOut.GetTextAlign());

		// #102382# use GetTextOutlines and PolyPolyVector now
		aVDev.GetTextOutlines(rPolyPolyVector, rText, nBase, nIndex, nLen);
	}

	// since GetTextOutline(...) is base line oriented, the
	// polygon needs to be moved one line height
	// #102382# now a loop is necessary for moving all contained single PolyPolygons
	for(sal_uInt32 a(0); a < rPolyPolyVector.size(); a++)
	{
		rPolyPolyVector[a].Move(0, rOut.GetFontMetric().GetAscent());
	}

	return (rPolyPolyVector.size() != 0);
}

/*************************************************************************
|*
|*	  XOutputDevice::ImpDrawFormText(String, Polygon, Font, nAbsStart)
|*
|*	  Einen String entlang eines Polygons ausgeben; nAbsStart
|*	  ueberschreibt den XFormTextStartItem-Wert und wird fuer die
|*	  Ausgabe mehrerer Strings entlang des gleichen Polygons benoetigt.
|*	  Rueckgabewert ist die Endposition des ausgegebenen Textes in
|*	  Bezug auf den Linienanfang.
|*
|*	  nAbsStart <  0: Die Gesamtlaenge aller Strings, notwendig fuer
|*					  alle Formatierungen ausser Linksbuendig
|*				<= 0: Item-Startwert verwenden
|*				>  0: Text an dieser absoluten Position ausgeben; ist
|*					  normalerweise der Rueckgabewert eines vorigen
|*					  DrawFormText-Aufrufs
|*
|*	  bToLastPoint: alle Linien einschliesslich der letzten Zeichnen,
|*					sonst die letzte Linie auslassen
|*
|*	  bDraw: wenn FALSE, wird nichts ausgegeben, sondern nur das BoundRect
|*			 berechnet
|*
|*	  pDXArray: wenn vorhanden, enthaelt dieses Array die horizontalen
|*				Positionen der einzelnen Zeichen, beginnend beim ersten
|*				und endend hinter dem letzten Zeichen; es mu also
|*				rText.Len()-1 long-Werte enthalten
|*
|*
|*	  Ersterstellung	02.02.95 ESO
|*	  Letzte Aenderung	11.10.95 ESO
|*
*************************************************************************/

// #101498# Helper method ImpGetTextLength to get text length taking into account
// hor/vertical and BIDI, especially right-to-left.
sal_Int32 ImpGetTextLength(OutputDevice* pOut, DrawPortionInfo* pInfo, sal_Int32* pDXArray, 
	xub_StrLen nIndex, xub_StrLen nLen)
{
	sal_Bool bRightToLeft = pInfo->IsRTL();
	sal_Int32 nRetval(0L);

	if(pInfo->rFont.IsVertical())
	{
		nRetval = pOut->GetTextHeight() * (sal_Int32)nLen;
	}
	else
	{
		if(bRightToLeft)
		{
			nRetval = pOut->GetTextArray(pInfo->rText, pDXArray, 
				pInfo->nTextStart + (pInfo->nTextLen - (nIndex + nLen)), 
				nLen);
		}
		else
		{
			nRetval = pOut->GetTextArray(pInfo->rText, pDXArray, 
				pInfo->nTextStart + nIndex, 
				nLen);
		}
	}

	return nRetval;
}

// #101498# Helper method ImpDrawTextArray to draw text taking into account
// hor/vertical and BIDI, especially right-to-left.
void ImpDrawTextArray(OutputDevice* pOut, const Point& rPos, DrawPortionInfo* pInfo, sal_Int32* pDXArray, 
	xub_StrLen nIndex, xub_StrLen nLen)
{
	sal_Bool bRightToLeft(pInfo->IsRTL());

	if(bRightToLeft)
	{
		pOut->DrawTextArray(rPos, pInfo->rText, pDXArray, 
			pInfo->nTextStart + (pInfo->nTextLen - (nIndex + nLen)), 
			nLen);
	}
	else
	{
		pOut->DrawTextArray(rPos, pInfo->rText, pDXArray, 
			pInfo->nTextStart + nIndex, 
			nLen);
	}
}

// #101498# Helper method ImpXOutGetTextOutline to get text outline taking into account
// hor/vertical and BIDI, especially right-to-left.
// #102382# new interface for XOutGetTextOutline to support PolyPolyVector
sal_Bool ImpXOutGetTextOutlines(PolyPolyVector& rPolyPolyVector, OutputDevice* pOut, DrawPortionInfo* pInfo, 
	xub_StrLen nIndex, xub_StrLen nLen)
{
	sal_Bool bRightToLeft(pInfo->IsRTL());

	if(bRightToLeft)
	{
		return XOutGetTextOutlines(rPolyPolyVector, pInfo->rText, *pOut, 
			pInfo->nTextStart + (pInfo->nTextLen - (nIndex + nLen)), 
			pInfo->nTextStart + (pInfo->nTextLen - (nIndex + nLen)), 
			nLen);
	}
	else
	{
		return XOutGetTextOutlines(rPolyPolyVector, pInfo->rText, *pOut, 
			pInfo->nTextStart + nIndex, 
			pInfo->nTextStart + nIndex, 
			nLen);
	}
}

// #101498# changed interface due to bidi requirements
sal_Int32 XOutputDevice::ImpDrawFormText(DrawPortionInfo* pInfo, const Polygon& rPoly, sal_Int32 nAbsStart, 
	sal_Bool bToLastPoint, sal_Bool bDraw, sal_Bool bIsShadow)
{
	Font aFont = pInfo->rFont;
	const sal_Int32* pDXArray = pInfo->pDXArray;
	sal_Bool bUseBreakIterator(sal_False);

	Reference < com::sun::star::i18n::XBreakIterator > xBreak;
	Reference < XMultiServiceFactory > xMSF = ::comphelper::getProcessServiceFactory();
	Reference < XInterface > xInterface = xMSF->createInstance(::rtl::OUString::createFromAscii("com.sun.star.i18n.BreakIterator"));
	::com::sun::star::lang::Locale aFontLocale = SvxCreateLocale(pInfo->rFont.GetLanguage());
	
	if(xInterface.is())
	{
		Any x = xInterface->queryInterface(::getCppuType((const Reference< XBreakIterator >*)0));
		x >>= xBreak;
	}

	if(xBreak.is())
	{
		bUseBreakIterator = sal_True;
	}

	long	nXMin = LONG_MAX, nYMin = LONG_MAX;
	long	nXMax = LONG_MIN, nYMax = LONG_MIN;
	long	nMaxCharExtent;
	long	nPolyLen = 0;
	long	nTextLen = 0;
	long	nTotal = 0;
	long	nTextWidth;
	long	nStart;
	long	nShadowX;
	USHORT	nPntCnt = rPoly.GetSize();
	USHORT	nLastPnt;
	USHORT	nPnt;
	xub_StrLen nChar(0);
	const xub_StrLen nCharCnt(pInfo->nTextLen);
	short	nDirection;

	if ( nPntCnt < 2 || !nCharCnt)
		return 0;

	BOOL bIsSlantShadow = ( bIsShadow && eFormTextShadow == XFTSHADOW_SLANT );
	BOOL bDrawAsPoly = ( bFormTextOutline || bIsSlantShadow );

	if ( nAbsStart > 0 )	nStart = nAbsStart;
	else					nStart = nFormTextStart;

	aFont.SetTransparent(TRUE);

	// Attribute sichern
	XLineStyle eOldLineStyle = eLineStyle;
	XFillStyle eOldFillStyle = eFillStyle;

	Color aOldLineColor( pOut->GetLineColor() );

	pOut->SetFillColor( aFont.GetColor() );

	if ( !(bFormTextOutline && bHair) || bIsShadow )
		pOut->SetLineColor();

	if ( !bFormTextOutline || bIsShadow )
		eLineStyle = XLINE_NONE;

	eFillStyle = XFILL_SOLID;

	if ( eFormTextAdjust == XFT_AUTOSIZE && nAbsStart > 0 )
		aFont.SetSize(Size(0, nFtAutoHeightSave));

	Font aOldFont = pOut->GetFont();
	pOut->SetFont(aFont);
	long nAscent = pOut->GetFontMetric().GetAscent();

	// #78478# outline text in FontWork
	if(bFormTextOutline)
	{
		eLineStyle = XLINE_SOLID;
		pOut->SetLineColor(aLineColor);
	}

	if ( eFormTextAdjust == XFT_AUTOSIZE )
	{
		// bei Autosize den Arrayinhalt immer ignorieren
		pDXArray = NULL;
	}

	nTextWidth = ImpGetTextLength(pOut, pInfo, (sal_Int32*) pDXArray, 0, pInfo->nTextLen);

	if ( eFormTextAdjust != XFT_LEFT && nAbsStart <= 0 )
	{
		// Gesamtlaenge des Polygons berechnen
		USHORT nMax = nPntCnt;
		nPnt = 1;

		if ( !bToLastPoint )
			nMax--;

		for ( ; nPnt < nMax; nPnt++)
		{
			double	fDx = rPoly[nPnt].X() - rPoly[nPnt-1].X();
			double	fDy = rPoly[nPnt].Y() - rPoly[nPnt-1].Y();
			nPolyLen += (long) (sqrt(fDx * fDx + fDy * fDy) + 0.5);
		}

		if ( nAbsStart == 0 )
			nAbsStart = - nTextWidth;

		if ( eFormTextAdjust == XFT_AUTOSIZE )
		{
			nFtAutoHeightSave = aFont.GetSize().Height();
			nFtAutoHeightSave = - (nPolyLen * nFtAutoHeightSave / nAbsStart);
			aFont.SetSize(Size(0, nFtAutoHeightSave));
			pOut->SetFont(aFont);
			nFtAutoHeightSave = aFont.GetSize().Height();
			nTextWidth = pOut->GetTextWidth(pInfo->rText, pInfo->nTextStart, pInfo->nTextLen);
			nAscent = pOut->GetFontMetric().GetAscent();
			nAbsStart = - nPolyLen;
		}
		// Bei rechtsbuendiger Ausgabe auch Startposition beruecksichtigen
		if ( eFormTextAdjust == XFT_RIGHT )
			nAbsStart -= nStart;
		nStart = nPolyLen + nAbsStart;

		if ( eFormTextAdjust != XFT_RIGHT )
			nStart /= 2;
	}
	if ( nStart < 0 )
		nStart = 0;

	if ( bIsShadow && eFormTextShadow != XFTSHADOW_SLANT )
		nShadowX = nFormTextShdwXVal;
	else
		nShadowX = 0;

	nTotal = nStart + nTextWidth;

	if ( bIsShadow && eFormTextShadow == XFTSHADOW_SLANT &&
		 nFormTextShdwYVal && nFormTextShdwYVal != 100 )
		nAscent = nAscent * nFormTextShdwYVal / 100;

	// Maximaler Zeichenbereich ca. 1,4 (sqrt(2)) * Ascent fuer BoundRect
	nMaxCharExtent = nAscent * 7 / 5;

	// Laufrichtung des Polygons ggf. spiegeln
	if ( bFormTextMirror )
	{
		nDirection = -1;
		nLastPnt = (USHORT) -1;
		nPnt = nPntCnt - 2;
		if ( !bToLastPoint )
			nPnt--;
	}
	else
	{
		nDirection = 1;
		nLastPnt = nPntCnt - 1;
		nPnt = 1;
		if ( bToLastPoint )
			nLastPnt++;
	}

	while ( nChar < nCharCnt && nPnt != nLastPnt )
	{
		xub_StrLen nGlyphLen(1);

		if(bUseBreakIterator)
		{
			sal_Int32 nDone(0L);
			nGlyphLen = (xub_StrLen)xBreak->nextCharacters( pInfo->rText, nChar + pInfo->nTextStart, aFontLocale, 
				CharacterIteratorMode::SKIPCELL, 1, nDone) - (nChar + pInfo->nTextStart);
		}

		Point	aPos = rPoly[nPnt];
		double	fDx, fDy, fLen;
		long	nLen, nChar1Len;

		fDx = aPos.X() - rPoly[nPnt-nDirection].X();
		fDy = aPos.Y() - rPoly[nPnt-nDirection].Y();
		fLen = sqrt(fDx * fDx + fDy * fDy);
		nLen = (long) (fLen + 0.5);

		nChar1Len = ImpGetTextLength(pOut, pInfo, (sal_Int32*) pDXArray, nChar, nGlyphLen);

		double fXDist, fYDist;
		double fCos = fDx;
		double fSin = fDy;
		double fPartLen = fLen;
		double fLenSum = fLen - nTextLen;
		USHORT nSumPnt = nPnt + nDirection;

		// Laenge halbieren, um Zeichenmitte als Referenzpunkt zu verwenden
		nChar1Len /= 2;

		while ( nSumPnt != nLastPnt && fLenSum < nChar1Len )
		{
			fCos = rPoly[nSumPnt].X() - rPoly[nSumPnt-nDirection].X();
			fSin = rPoly[nSumPnt].Y() - rPoly[nSumPnt-nDirection].Y();
			fPartLen = sqrt(fSin * fSin + fCos * fCos);
			fLenSum += fPartLen;
			nSumPnt += nDirection;
		}
		fSin /= - fPartLen;
		fCos /=   fPartLen;

		fXDist = fSin * nFormTextDistance;
		fYDist = fCos * nFormTextDistance;

		if ( nStart > 0 )
			nStart -= nLen;
		else
		{
			nLen -= nTextLen;
			nTextLen = - nLen;
		}

		if ( nLen > 0 && nStart <= 0 )
		{
			xub_StrLen nCnt(0);

			if ( nStart < 0 )
			{
				nLen = - nStart;
				nStart = 0;
			}

			do
			{
				xub_StrLen nNextGlyphLen(1);

				if(bUseBreakIterator)
				{
					sal_Int32 nDone(0L);
					nNextGlyphLen = (xub_StrLen)xBreak->nextCharacters( pInfo->rText, nChar + pInfo->nTextStart + nCnt, aFontLocale, 
						CharacterIteratorMode::SKIPCELL, 1, nDone) - (nChar + pInfo->nTextStart + nCnt);
				}

				nTextLen = ImpGetTextLength(pOut, pInfo, (sal_Int32*) pDXArray, nChar, nCnt + nNextGlyphLen);

				nCnt += nNextGlyphLen;
			}
			while ( nChar + nCnt < nCharCnt && nTextLen < nLen );

			aPos.X() -= (long) (fDx * (nLen - nShadowX) / fLen + fXDist);
			aPos.Y() -= (long) (fDy * (nLen - nShadowX) / fLen + fYDist);

			// BoundRect-Approximation
			nXMin = Min(nXMin, aPos.X() - nMaxCharExtent);
			nYMin = Min(nYMin, aPos.Y() - nMaxCharExtent);
			nXMax = Max(nXMax, aPos.X() + nMaxCharExtent);
			nYMax = Max(nYMax, aPos.Y() + nMaxCharExtent);

			if ( eFormTextStyle == XFT_ROTATE )
			{
				if ( bDrawAsPoly )
				{
					// #101145# Do create outline polygons more efficient
					// #102382# new interface supporting PolyPolyVector
					PolyPolyVector aPolyPolyVector;
					sal_Bool bOkay(ImpXOutGetTextOutlines(aPolyPolyVector, pOut, pInfo, nChar, nCnt));

					// #102382# iterate over single PolyPolygons
					for(sal_uInt32 a(0); a < aPolyPolyVector.size(); a++)
					{
						PolyPolygon aPolyPoly(aPolyPolyVector[a]);

						if(aPolyPoly.Count() > 0 && aPolyPoly[0].GetSize() > 0)
						{
							XPolyPolygon aChar(aPolyPoly);

							// #102382# new interface supporting PolyPolyVector
							if(bIsSlantShadow)
							{
								if(nFormTextShdwYVal && 100 != nFormTextShdwYVal)
								{
									aChar.Scale(1.0, (double)nFormTextShdwYVal / 100.0);
								}

								aChar.SlantX(nAscent,
									sin(- F_PI * nFormTextShdwXVal / 1800.0),
									cos(- F_PI * nFormTextShdwXVal / 1800.0));
							}

							aChar.Translate(Point(aPos.X(), aPos.Y() - nAscent));
							aChar.Rotate(aPos, fSin, fCos);
							
							if(bDraw)
							{
								DrawXPolyPolygon(aChar);
							}
						}
					}
				}
				else
				{
					// #83801# vertical writing for contour
					if(aFont.IsVertical())
					{
						short nAngle = (short) (acos(fCos) * 1800 / F_PI + 0.5);
						if(fSin < 0)
							nAngle = 3600 - nAngle;
						nAngle += 2700;
						aFont.SetOrientation(nAngle);
						pOut->SetFont(aFont);
						if(bDraw)
						{
							ImpDrawTextArray(pOut, aPos, pInfo, (sal_Int32*)pDXArray, nChar, nCnt);
						}
					}
					else
					{
						short nAngle = (short) (acos(fCos) * 1800 / F_PI + 0.5);
						if(fSin < 0)
							nAngle = 3600 - nAngle;
						aFont.SetOrientation(nAngle);
						pOut->SetFont(aFont);
						if(bDraw)
						{
							ImpDrawTextArray(pOut, aPos, pInfo, (sal_Int32*)pDXArray, nChar, nCnt);
						}
					}
				}
			}
			else
			{
				bDrawAsPoly = ( bDrawAsPoly || eFormTextStyle != XFT_UPRIGHT);

				for (xub_StrLen i = 0; i < nCnt;)
				{
					xub_StrLen nNextGlyphLen(1);
					
					if(bUseBreakIterator)
					{
						sal_Int32 nDone(0L);
						nNextGlyphLen = (xub_StrLen)xBreak->nextCharacters( pInfo->rText, nChar + pInfo->nTextStart + i, aFontLocale, 
							CharacterIteratorMode::SKIPCELL, 1, nDone) - (nChar + pInfo->nTextStart + i);
					}
					
					XPolyPolygon aChar(0);
					Point aPolyPos = aPos;

					if ( i > 0 )
					{
						long nW;

						nW = ImpGetTextLength(pOut, pInfo, (sal_Int32*) pDXArray, nChar, i);

						aPolyPos.X() += (long) (fDx * nW / fLen);
						aPolyPos.Y() += (long) (fDy * nW / fLen);
					}
					if ( bDrawAsPoly )
					{
						// #100318# new for XOutGetCharOutline
						// #102382# new interface supporting PolyPolyVector
						PolyPolyVector aPolyPolyVector;

						// #108756#
						// Here the wrong index was called for the ImpXOutGetTextOutlines(...)
						// call. nChar needs to be added here to index the different characters.
						sal_Bool bOkay(ImpXOutGetTextOutlines(aPolyPolyVector, pOut, pInfo, nChar + i, nNextGlyphLen));

						// #102382# iterate over single PolyPolygons
						for(sal_uInt32 a(0); a < aPolyPolyVector.size(); a++)
						{
							PolyPolygon aPolyPoly(aPolyPolyVector[a]);

							if(aPolyPoly.Count() > 0 && aPolyPoly[0].GetSize() > 0)
							{
								// #103163# Create in-between XPolxPolygon
								XPolyPolygon aNextChar(aPolyPoly);

								if ( bIsSlantShadow )
								{
									if ( nFormTextShdwYVal && nFormTextShdwYVal != 100 )
										aNextChar.Scale(1.0, (double)nFormTextShdwYVal/100);

									aNextChar.SlantX(nAscent,
												 sin(- F_PI * nFormTextShdwXVal / 1800),
												 cos(- F_PI * nFormTextShdwXVal / 1800));
								}

								// #103163# Insert in-between XPolxPolygon to main XPolxPolygon
								aChar.Insert(aNextChar);
							}
						}
					}

					if ( eFormTextStyle == XFT_SLANTY )
					{
						aPolyPos.Y() -= nAscent;
						aChar.SlantY(0, fSin, fCos);
					}
					else
					{
						long nW;

						nW = ImpGetTextLength(pOut, pInfo, (sal_Int32*) pDXArray, nChar + i, nNextGlyphLen);

						aPolyPos.X() -= nW / 2;

						if ( eFormTextStyle == XFT_SLANTX )
						{
							aPolyPos.X() += (long) (fDy * nAscent / fLen);
							aPolyPos.Y() -= (long) (fDx * nAscent / fLen);
							aChar.SlantX(0, fSin, fCos);
						}
						else if ( bDrawAsPoly )
							aPolyPos.Y() -= nAscent;
					}
					aChar.Translate(aPolyPos);

					if ( bDraw )
					{
						if ( bDrawAsPoly )
							DrawXPolyPolygon(aChar);
						else
						{
							ImpDrawTextArray(pOut, aPolyPos, pInfo, (sal_Int32*)pDXArray, nChar + i, nNextGlyphLen);
						}
					}

					i += nNextGlyphLen;
				}
			}
			nChar += nCnt;
			nTextLen -= nLen;
		}
		nPnt += nDirection;
	}
	// auch letzten Punkt fuer BoundRect-Approximation beruecksichtigen
	Point aPos = rPoly[nPnt - nDirection];
	nXMin = Min(nXMin, aPos.X() - nMaxCharExtent);
	nYMin = Min(nYMin, aPos.Y() - nMaxCharExtent);
	nXMax = Max(nXMax, aPos.X() + nMaxCharExtent);
	nYMax = Max(nYMax, aPos.Y() + nMaxCharExtent);

	aFormTextBoundRect.Union(Rectangle(nXMin, nYMin, nXMax, nYMax));

	pOut->SetFont(aOldFont);
	pOut->SetLineColor( aOldLineColor );
	eLineStyle = eOldLineStyle;
	eFillStyle = eOldFillStyle;

	return nTotal;
}

// #101498# changed interface due to bidi requirements
void XOutputDevice::ImpDrawFormTextShadow(DrawPortionInfo* pInfo, const Polygon& rPoly, sal_Int32 nAbsStart, sal_Bool bToLastPoint, sal_Bool bDraw)
{
	if(XFTSHADOW_NONE != eFormTextShadow)
	{
		sal_Bool bOutline(bFormTextOutline);
		Font aShadowFont(pInfo->rFont);

		aShadowFont.SetColor(aFormTextShdwColor);

		DrawPortionInfo aNewInfo(
			pInfo->rStartPos,
			pInfo->rText,
			pInfo->nTextStart,
			pInfo->nTextLen,
			aShadowFont,
			pInfo->nPara,
			pInfo->nIndex,
			pInfo->pDXArray,
			pInfo->GetBiDiLevel());

		if(XFTSHADOW_SLANT != eFormTextShadow)
		{
			nFormTextDistance += nFormTextShdwYVal;
		}

		ImpDrawFormText(&aNewInfo, rPoly, nAbsStart, bToLastPoint, bDraw, sal_True);

		if(XFTSHADOW_SLANT != eFormTextShadow)
		{
			nFormTextDistance -= nFormTextShdwYVal;
		}

		bFormTextOutline = bOutline;
	}
}

/*************************************************************************
|*
*************************************************************************/

// #101498# changed interface due to bidi requirements
sal_Int32 XOutputDevice::DrawFormText(DrawPortionInfo* pInfo, const Polygon& rPoly,
	sal_Int32 nAbsStart, sal_Bool bToLastPoint, sal_Bool bDraw)
{
	if(nAbsStart <= 0L)
	{
		// empty BoundRect at first call
		aFormTextBoundRect = Rectangle();
	}

	ImpDrawFormTextShadow(pInfo, rPoly, nAbsStart, bToLastPoint, bDraw);

	return ImpDrawFormText(pInfo, rPoly, nAbsStart, bToLastPoint, bDraw, sal_False);
}

// eof
