/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: pgfnote.hxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 09:57:02 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _PGFNOTE_HXX
#define _PGFNOTE_HXX

#ifndef _SFXTABDLG_HXX //autogen
#include <sfx2/tabdlg.hxx>
#endif

#ifndef _FIELD_HXX //autogen
#include <vcl/field.hxx>
#endif

#ifndef _FIXED_HXX //autogen
#include <vcl/fixed.hxx>
#endif

#ifndef _GROUP_HXX //autogen
#include <vcl/group.hxx>
#endif

#ifndef _CTRLBOX_HXX
#include <svtools/ctrlbox.hxx>
#endif

/*--------------------------------------------------------------------
	Beschreibung:	Fussnoteneinstellungs-TabPage
 --------------------------------------------------------------------*/

class SwFootNotePage: public SfxTabPage
{
public:
	static SfxTabPage *Create(Window *pParent, const SfxItemSet &rSet);
	static USHORT* GetRanges();

	virtual BOOL FillItemSet(SfxItemSet &rSet);
	virtual void Reset(const SfxItemSet &rSet);

private:
	SwFootNotePage(Window *pParent, const SfxItemSet &rSet);
	~SwFootNotePage();

	RadioButton		aMaxHeightPageBtn;
	RadioButton		aMaxHeightBtn;
	MetricField		aMaxHeightEdit;
	FixedText   	aDistLbl;
	MetricField		aDistEdit;
	FixedLine		aPosHeader;

	FixedText   	aLinePosLbl;
	ListBox			aLinePosBox;
	FixedText   	aLineTypeLbl;
	LineListBox		aLineTypeBox;
	FixedText   	aLineWidthLbl;
	MetricField		aLineWidthEdit;
	FixedText   	aLineDistLbl;
	MetricField		aLineDistEdit;
	FixedLine		aLineHeader;

	DECL_LINK( HeightPage, Button * );
	DECL_LINK( HeightMetric, Button * );
	DECL_LINK( HeightModify, MetricField * );

	long 			lMaxHeight;

	virtual void	ActivatePage( const SfxItemSet& rSet );
	virtual int		DeactivatePage( SfxItemSet* pSet = 0 );

};

#endif
