/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: vclxaccessiblemenubar.hxx,v $
 *
 *  $Revision: 1.7 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 12:37:54 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _TOOLKIT_AWT_VCLXACCESSIBLEMENUBAR_HXX_
#define _TOOLKIT_AWT_VCLXACCESSIBLEMENUBAR_HXX_

#ifndef _TOOLKIT_AWT_ACCESSIBLEMENUCOMPONENT_HXX_
#include <toolkit/awt/accessiblemenucomponent.hxx>
#endif

class VclSimpleEvent;
class VclWindowEvent;
class Window;


//	----------------------------------------------------
//	class VCLXAccessibleMenuBar
//	----------------------------------------------------

class VCLXAccessibleMenuBar :	public OAccessibleMenuComponent
{
protected:
	Window*					m_pWindow;

	virtual sal_Bool		IsFocused();

	DECL_LINK( WindowEventListener, VclSimpleEvent* );

	virtual void			ProcessWindowEvent( const VclWindowEvent& rVclWindowEvent );

	// XComponent
	virtual void SAL_CALL	disposing();

public:
	VCLXAccessibleMenuBar( Menu* pMenu );
	virtual ~VCLXAccessibleMenuBar();

	// XServiceInfo
	virtual ::rtl::OUString SAL_CALL getImplementationName() throw (::com::sun::star::uno::RuntimeException);
	virtual ::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL getSupportedServiceNames() throw (::com::sun::star::uno::RuntimeException);

	// XAccessibleContext
	virtual sal_Int32 SAL_CALL getAccessibleIndexInParent(  ) throw (::com::sun::star::uno::RuntimeException);
	virtual sal_Int16 SAL_CALL getAccessibleRole(  ) throw (::com::sun::star::uno::RuntimeException);

	// XAccessibleExtendedComponent
	virtual sal_Int32 SAL_CALL getBackground(  ) throw (::com::sun::star::uno::RuntimeException);
};

#endif // _TOOLKIT_AWT_VCLXACCESSIBLEMENUBAR_HXX_
