/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MemMac.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:06:39 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#include <Memory.h>
#include <solar.h>

// -----------------------------------------------------------------------

// Groesse eines Blocks, der fuer die SubAllocation verwendet wird
#define MEMBLOCK_SIZE       (0x1000-sizeof(FreeBlock))

// Groesse, ab der Speicher direkt angefordert wird. Die Groesse muss
// <= MEMBLOCK_SIZE-sizeof(MemBlock) sein
#define MEMBLOCK_MAXSIZE    (MEMBLOCK_SIZE-sizeof(MemBlock))

// Defines fuer MultiThread-Systeme, um Suballocation multithreadfest
// zu machen
#define MEM_SEMSTART()
#define MEM_SEMEND()

// -----------------------------------------------------------------------

struct FreeBlock;

struct MemData
{
    FreeBlock*    pFirstBlock;		// Erster Block in der Memoryverwaltung
    BOOL	      bIsInMain;		// Wir sind in main(), sobald nicht mehr
									// kein DisposePtr mehr, weil Heap invalid								
									// in statischen Destrukoren !
};

extern _NEW_HANDLER		_new_handler;
static MemData  		aMemD = { NULL, TRUE };

/*************************************************************************
|*
|*    GetMemData()
|*
|*    Beschreibung      Daten vom Memory-Manager besorgen
|*    Ersterstellung    TH 21.07.92
|*    Letzte Aenderung  TH 21.07.92
|*
*************************************************************************/

inline MemData* GetMemData()
{
    return &aMemD;
}

// -----------------------------------------------------------------------

/*************************************************************************
|*
|*    AllocMemory()
|*
|*    Beschreibung      Fordert Speicherblock an
|*    Ersterstellung    TH 06.09.92
|*    Letzte Aenderung  TH 06.09.92
|*
*************************************************************************/

inline void* AllocMemory( size_t n )
{
    return NewPtr(n);
}

/*************************************************************************
|*
|*    FreeMemory()
|*
|*    Beschreibung      Gibt Speicherblock frei
|*    Ersterstellung    TH 06.09.92
|*    Letzte Aenderung  TH 06.09.92
|*
*************************************************************************/

inline void FreeMemory( void* p )
{
	DisposePtr((Ptr) p);
}
