 /*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: filcmd.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 15:22:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#ifndef _FILCMD_HXX_
#include "filcmd.hxx"
#endif
#ifndef _SHELL_HXX_
#include "shell.hxx"
#endif
#ifndef _PROV_HXX_
#include "prov.hxx"
#endif


using namespace fileaccess;
using namespace com::sun::star;
using namespace com::sun::star::ucb;


XCommandInfo_impl::XCommandInfo_impl( shell* pMyShell,const rtl::OUString& aUnqPath )
	: m_pMyShell( pMyShell ),
	  m_xProvider( pMyShell->m_pProvider )
{
}

XCommandInfo_impl::~XCommandInfo_impl()
{
}



void SAL_CALL
XCommandInfo_impl::acquire(
			     void )
  throw()
{
  OWeakObject::acquire();
}


void SAL_CALL
XCommandInfo_impl::release(
	void )
  throw()
{
	OWeakObject::release();
}


uno::Any SAL_CALL
XCommandInfo_impl::queryInterface(
				    const uno::Type& rType )
  throw( uno::RuntimeException )
{
	uno::Any aRet = cppu::queryInterface( rType,
										  SAL_STATIC_CAST( XCommandInfo*,this) );
	return aRet.hasValue() ? aRet : OWeakObject::queryInterface( rType );
}


uno::Sequence< CommandInfo > SAL_CALL
XCommandInfo_impl::getCommands(
	void )
	throw( uno::RuntimeException )
{
	return m_pMyShell->m_sCommandInfo;
}


CommandInfo SAL_CALL
XCommandInfo_impl::getCommandInfoByName(
	const rtl::OUString& aName )
	throw( UnsupportedCommandException,
		   uno::RuntimeException)
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); i++ )
		if( m_pMyShell->m_sCommandInfo[i].Name == aName )
			return m_pMyShell->m_sCommandInfo[i];

	throw UnsupportedCommandException();
}


CommandInfo SAL_CALL
XCommandInfo_impl::getCommandInfoByHandle(
	sal_Int32 Handle )
	throw( UnsupportedCommandException,
		   uno::RuntimeException )
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); ++i )
		if( m_pMyShell->m_sCommandInfo[i].Handle == Handle )
			return m_pMyShell->m_sCommandInfo[i];

	throw UnsupportedCommandException();
}


sal_Bool SAL_CALL
XCommandInfo_impl::hasCommandByName(
	const rtl::OUString& aName )
	throw( uno::RuntimeException )
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); ++i )
		if( m_pMyShell->m_sCommandInfo[i].Name == aName )
			return true;

	return false;
}


sal_Bool SAL_CALL
XCommandInfo_impl::hasCommandByHandle(
	sal_Int32 Handle )
	throw( uno::RuntimeException )
{
	for( sal_Int32 i = 0; i < m_pMyShell->m_sCommandInfo.getLength(); ++i )
		if( m_pMyShell->m_sCommandInfo[i].Handle == Handle )
			return true;

	return false;
}
