/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: array.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2005/09/09 14:21:13 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef UDM_ARRAY_HXX
#define UDM_ARRAY_HXX



// USED SERVICES
	// BASE CLASSES
#include <udm/data.hxx>
	// COMPONENTS
	// PARAMETERS
#include <udm/object.hxx>



namespace udm
{

class Array : public Data
{
  public:
    // LIFECYCLE
    virtual             ~Array() {}

    // OPERATORS
    Object              operator[](
                            uintt               i_nIndex ) const;
    // OPERATIONS

    // INQUIRY
    uintt               size() const;

  private:
    // Interface Data:
    virtual accessor_type
                        inq_Type() const;
    virtual Array &     access_Array();

    // Locals
    virtual Object      op_Array(
                            uintt               i_nIndex ) const = 0;
    virtual uintt       inq_Size() const = 0;
};


// IMPLEMENTATION


inline Object
Array::operator[]( uintt i_nIndex ) const
    { return op_Array(i_nIndex); }

inline uintt               
Array::size() const
    { return inq_Size(); }


}   // namespace udm


#endif

