/*
 * ExecuteCache.java
 *
 * Created on 28. Juli 2003, 15:55
 */
package com.sun.star.wizards.tutorial.executer;

import java.util.Vector;

import com.sun.star.accessibility.AccessibleRole;
import com.sun.star.accessibility.XAccessibleContext;
import com.sun.star.awt.XExtendedToolkit;
import com.sun.star.beans.NamedValue;
import com.sun.star.wizards.tutorial.executer.officeHelper.XAccessibility;
import com.sun.star.wizards.tutorial.executer.officeHelper.Desktop;
import com.sun.star.wizards.tutorial.executer.util.AccessibilityTools;
import com.sun.star.wizards.tutorial.executer.util.Control;
import com.sun.star.wizards.tutorial.executer.util.Helper;
import com.sun.star.wizards.tutorial.executer.util.URLDispatcher;

/**
 * DOCUMENT ME!
 *
 * @author mc114771
 */
public class ExecuteCache extends Thread {
    /**
     * Properties
     */
    public Vector commandsPool = new Vector();
    public static boolean m_localisation = false;
    public static Vector m_localisationPaths = new Vector();

    //public static boolean            m_break             = false;
    private XExtendedToolkit m_exToolkit = null;
    private Helper m_helper = null;
    private CallKeyHandler m_keyHandler = new CallKeyHandler();

    /**
     * Creates a new ExecuteCache object.
     *
     * @param helper DOCUMENT ME!
     */
    public ExecuteCache(Helper helper) {
        try {
            m_exToolkit = helper.getXExtendedToolkit();
            m_helper = helper;
        } catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /**
     * DOCUMENT ME!
     */
    public void run() {
        try {
            while (true) {
                while (commandsPool.size() > 0) {
                    if (isInterrupted()) {
                        break;
                    }

                    commands();
                }

                gotoSleep();

                if (isInterrupted()) {
                    break;
                }
            }
        } catch (ThreadDeath td) {
        }
    }

    /**
     * Close all alive internal threads.
     */
    public void closeThread() {
        if (isAlive()) {
            synchronized (this) {
                interrupt();
                notify();
            }
        }
    }

    /**
     * Wakeup thread.
     */
    public void waken() {
        synchronized (this) {
            try {
                notify();
            } catch (Exception e) {
            }
        }
    }

    /**
     * Wakeup thread.
     */
    public void gotoSleep() {
        synchronized (this) {
            try {
                wait();
            } catch (Exception e) {
            }
        }
    }

    /**
     * Is Alive this thread.
     *
     * @return DOCUMENT ME!
     */
    public boolean isActive() {
        boolean status = false;

        synchronized (this) {
            try {
                status = isActive();
            } catch (Exception e) {
            }
        }

        return status;
    }

    /**
     * The empty file, which ought to become opened, is inserted in a list. As soon as a
     * new entry is inserted the thread will be resumed and will open the files one
     * after another.
     *
     * @param commands the path for empty Document: text doc :
     *        staroffice.private:factory/swriter calc doc :
     *        staroffice.private:factory/scalc draw doc :
     *        staroffice.private:factory/sdraw pres doc :
     *        staroffice.private:factory/simpress math doc :
     *        staroffice.private:factory/smath
     */
    public synchronized void put(final NamedValue[] commands) {
        /*new Thread( new Runnable() {
                public void run() {
                    try {*/
        boolean isEmpty = commandsPool.isEmpty();
        commandsPool.add(commands);

        if (isEmpty) {
            waken();
        }

        /*}catch ( ThreadDeath td ) { }
        }
        }).start();  */
    }

    /**
     * DOCUMENT ME!
     */
    private synchronized void commands() {
        while (!commandsPool.isEmpty()) {
            NamedValue[] commands = (NamedValue[]) commandsPool.get(0);
            commandsPool.remove(0);
            execute(commands);
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @return DOCUMENT ME!
     */
    public static synchronized Vector getLocalisationPaths() {
        return m_localisationPaths;
    }

    /**
     * DOCUMENT ME!
     *
     * @param commands DOCUMENT ME!
     */
    private synchronized void execute(NamedValue[] commands) {
        //m_break = false;
        Control.setBreakControl(false);

        Vector temp = new Vector();

        addKeyHandler(m_keyHandler);

        if (!m_localisation) {
            dispatchTutorialDialog("macro:///Tutorials.Functions.SetVisibleFalse()");
            dispatchTutorialDialog("macro:///Tutorials.ShowInfoDialog.ShowON()");
        }

        try {
            for (int j = 1; j < commands.length; j++) {
                Helper.log(" ***************************************************************");

                NamedValue[] namedValues = (NamedValue[]) commands[j].Value;

                Object classIntance = null;
                String methodName = "";
                String[] path = null;
                Vector params = new Vector();
                int leng = namedValues.length;

                for (int i = 0; i < leng; i++) {
                    NamedValue namedValue = (NamedValue) namedValues[i];

                    if (namedValue.Name.equals("DocumentTYP")) {
                        String typ = (String) namedValue.Value;

                        classIntance = Desktop.createDocumentInstance(typ, m_helper);
                    } else if (namedValue.Name.equals("MethodName")) {
                        methodName = (String) namedValue.Value;
                    } else if (namedValue.Name.equals("Path")) {
                        path = (String[]) namedValue.Value;
                    } else if (namedValue.Name.equals("Param")) {
                        params.add(namedValue.Value);
                    }
                }

                if ((classIntance != null) && !methodName.equals("")) {
                    if (AccessibilityTools.getSearchForm().equals(AccessibilityTools.SERCH_FORM_INDEX)) {
                        waitTopWindow(AccessibleRole.TOOL_TIP);
                    }

                    if (m_localisation) {
                        try {
                            sleep(1000);
                            AccessibilityTools.setSearchForm(AccessibilityTools.SERCH_FORM_INDEX);

                            XAccessibility access = (XAccessibility) classIntance;

                            checkExecutePath(path);
                            XAccessibleContext xcontext = access.getXAccessibleContext(path);
                            if (xcontext == null)
                                break;
                            path = access.getLocalisationPath(xcontext);

                            if (path != null) {
                                int size = temp.size();
                                temp.add(size, path.clone());

                                //checkExecutePath(path);
                                ExecuteMethod.instanceMethodExecute(classIntance, methodName, path, params);
                            }
                        } catch (Exception ex) {
                        }
                    } else {
                        ExecuteMethod.instanceMethodExecute(classIntance, methodName, path, params);
                    }
                }

                if (Control.getBreakControl()) {
                    break;
                }
            }
        } catch (Exception ex) {
            if (Helper.getLogState()) {
                ex.printStackTrace();
            }
        }

        if (m_localisation && !Control.getBreakControl()) {
            if (!temp.isEmpty()) {
                m_localisationPaths.add(temp);
            }
        } else if (!m_localisation) {
            dispatchTutorialDialog("macro:///Tutorials.ShowInfoDialog.ShowOFF()");
            dispatchTutorialDialog("macro:///Tutorials.Functions.SetVisibleTrue()");

            if (!Control.getBreakControl()) {
                dispatchTutorialDialog("macro:///Tutorials.Functions.SetDisableShowMeButton()");
            }
        }

        Control.setBreakControl(false);

        removeKeyHandler(m_keyHandler);

        if (m_localisation) {
            LocalisationCache.waken();
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param path DOCUMENT ME!
     */
    private void checkExecutePath(String[] path) {
        String identify = path[0].trim();
        String[] idents = identify.split("#", 3);

        if (idents.length == 3) {
            String sRole = idents[0].trim();

            if (sRole.indexOf("{D}") > -1) {
                sRole = sRole.substring("{D}".length());
                path[0] = sRole + "#" + idents[1].trim() + "#" + idents[2].trim();
            }
        }
    }

    /**
     * DOCUMENT ME!
     *
     * @param role DOCUMENT ME!
     */
    private void waitTopWindow(short role) {
        try {
            while (AccessibilityTools.isTopWindowActive(m_helper.getTopWindows(), role)) {
                sleep(1000);
                Helper.log(" is active : " + true);
            }
        } catch (com.sun.star.uno.Exception ex) {
        } catch (java.lang.InterruptedException ex) {
        }

        Helper.log(" is active : " + false);
    }

    /**
     * DOCUMENT ME!
     *
     * @param keyhandler DOCUMENT ME!
     */
    private synchronized void addKeyHandler(CallKeyHandler keyhandler) {
        m_exToolkit.addKeyHandler(keyhandler);
    }

    /**
     * DOCUMENT ME!
     *
     * @param keyhandler DOCUMENT ME!
     */
    private synchronized void removeKeyHandler(CallKeyHandler keyhandler) {
        m_exToolkit.removeKeyHandler(keyhandler);
    }

    /**
     * DOCUMENT ME!
     *
     * @param url DOCUMENT ME!
     */
    public void dispatchTutorialDialog(String url) {
        try {
            URLDispatcher.dispatch_Thread(m_helper.getXFrame(), url, "_self", 0, null);
        } catch (com.sun.star.uno.Exception ex) {
            ex.printStackTrace();
        }
    }
}
